﻿// JScript File

function createCustomAlertTLSDeclaration(messageTLS) {
    if ($('#AlertErr2').length > 0) 
        $("#AlertErr2").remove();
    
    $("<div></div>").attr('id', 'AlertErr2')
                    .attr('class', 'popup tls')
                    .attr('data-popup', 'popup-alert-formDeclarationErr2')
        .html("<header><a href='javascript:;' class='b-close tls' id='close-pop-up-tls'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" 
                        + messageTLS 
                        + "</p></div></div><footer><a href='javascript:;' title='OK' class='b-close tls js-approve-payment btn btn-wide btn-highlight-2 btn' data-action='cancel'>OK</a></footer>")
                    .appendTo('body');

    $(openPopup('popup-alert-formDeclarationErr2'));

    $(document).ready(function () { 
        if ($('.loading').length > 0)
            $(".loading").attr("style", "display: none;");
    });

    $(document).keypress(function (e) {
        $("a[id='popup tls']").click();
    });
}

function checkBrowserVersion(language) {
    var userAgent = window.navigator.userAgent.toLowerCase();
    var warningMessage = '';
    var TLSNotSupported = false;
    var isBgLng = (language == 'BG') ? true : false;
    warningMessage = (isBgLng) ? 'Моля обърнете внимание! <br></br>' : 'Please pay attention! <br></br>';    
     
    if (userAgent.indexOf('msie ') > -1) { // Internet Explorer 11 and lower (MSIE test)
        userAgentVersion = Number(userAgent.split('msie ')[1].split('.')[0]);
        if (userAgentVersion <= 10) {
            TLSNotSupported = true;
            warningMessage += (isBgLng) 
            ? '<span style="color:red;font-weight:bold">Вашият браузър (MSIE) е с критично ниска версия!</span><br></br>' 
            : '<span style="color:red;font-weight:bold">Your browser (MSIE) has a critically low version!</span><br></br>';
        }
    } else if (userAgent.indexOf('trident/') > -1) { // Internet Explorer (some versions, but checking for 11+) (Trident test)
        var tridentVersion = Number(userAgent.split('trident/')[1].split('.')[0]);  //Internet Explorer (by Trident if MSIE is missing)
        if (tridentVersion <= 6) {
            TLSNotSupported = true;
            warningMessage += (isBgLng) 
            ? '<span style="color:red;font-weight:bold">Вашият браузър (MSIE) е с критично ниска версия!</span><br></br>' 
            : '<span style="color:red;font-weight:bold">Your browser (MSIE) has a critically low version!</span><br></br>';
        }
    } else if (userAgent.indexOf('applewebkit/') > -1) {  // Chrome, Edge and Safari
        userAgentVersion = Number(userAgent.split('applewebkit/')[1].split('.')[0]);
        if (userAgentVersion <= 536) {
            TLSNotSupported = true;
            warningMessage += (isBgLng) 
            ? '<span style="color:red;font-weight:bold">Вашият браузър е с критично ниска версия!</span><br></br>' 
            : '<span style="color:red;font-weight:bold">Your browser has a critically low version!</span><br></br>';
        }
    } else if (userAgent.indexOf('firefox/') > -1) { // Firefox
        userAgentVersion = Number(userAgent.split('firefox/')[1].split('.')[0]);
        if (userAgentVersion <= 26) {
            TLSNotSupported = true;
            warningMessage += (isBgLng) 
            ? '<span style="color:red;font-weight:bold">Вашият браузър (Firefox) е с критично ниска версия!</span><br></br>'
            : '<span style="color:red;font-weight:bold">Your browser (Firefox) has a critically low version!</span><br></br>';    
        }  
    } else if (userAgent.indexOf('opera/') > -1) { // Opera
        userAgentVersion = Number(userAgent.split('opera/')[1].split('.')[0]);
        if (userAgentVersion <= 13) {
            TLSNotSupported = true;
            warningMessage += (isBgLng) 
            ? '<span style="color:red;font-weight:bold">Вашият браузър (Opera) е с критично ниска версия!</span><br></br>' 
            : '<span style="color:red;font-weight:bold">Your browser (Opera) has a critically low version!</span><br></br>';    
        }
    }
    
    if (TLSNotSupported == true) {
        warningMessage += (isBgLng) 
            ? 'За по-добра сигурност Ви препоръчваме да използвате само актуални и поддържани от съответния производител браузъри и версии на операционните системи. За да може да достъпите безпроблемно услугата след 01.09.2019 г., е необходимо да използвате версии на браузърите поддържащи минималната версия на протокола за сигурна комуникация TLS 1.1.<br></br>За повече информация тук: <a href ="https://ebb.ubb.bg/help/faq0BG_Re.html?CRT=45#45" target="_blank" class="link">(често задавани въпроси)</a>' 
            : 'For better security reasons we recommend that you should use only up-to-date and supported by the respective manufacturer browsers and versions of the operating systems. In order to seamlessly access the service after 01.09.2019, you need to use versions of browsers that support the minimum version of secure communication protocol TLS 1.1.<br></br>More information is available here: <a href ="https://ebb.ubb.bg/help/faq0BG_Re.html?CRT=45#45" target="_blank" class="link">(Frequently Asked Questions)</a>'; 
        var upgradeBrowserText = '<div id="upgrade-browser">\
            <a href="https://www.microsoft.com/en-US/download/internet-explorer.aspx" class="ie" target="_blank">Internet Explorer</a>\
            <a href="https://www.mozilla.org/en-US/firefox/new/" class="firefox" target="_blank">Firefox</a>\
            <a href="https://www.google.com/chrome" class="chrome" target="_blank">Chrome</a>\
            <a href="https://www.opera.com/bg/download" class="opera" target="_blank">Opera</a>\
            <a href="https://support.apple.com/downloads/safari" class="safari" target="_blank">Opera</a>';
        upgradeBrowserText += (isBgLng) 
            ? '<span>За по-добро качество и функционалност на сайта, моля обновете вашия браузър или изтеглете нов.</span></div>' 
            : '<span>For better quality and site functionality, please update your browser or download a new one.</span></div>';
        createCustomAlertTLSDeclaration(warningMessage + upgradeBrowserText);  
    }
};
//10477 end
//проверка валидността на IBAN сметката
function CheckIBAN(sIBAN) {
    try {
        IBAN = sIBAN.replace(/ /gi, "");
        var reIBAN = /[A-Z]{2}\d\d[A-Z0-9]{4}\d{4}[A-Z0-9]{10}/;
        var test1 = reIBAN.test(IBAN);
        var test2 = (IBAN.replace(reIBAN, "") == "") ? true : false;
        if (test1 && test2) {
            var strDisorded = IBAN.substr(4, 22) + IBAN.substr(0, 4);
            var strABC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            var i = 0;
            var strReplaced = "";
            for (i; i < 22; i++) {
                var charValue = strABC.indexOf(strDisorded.charAt(i), 0);
                if (charValue < 0) {
                    throw "Невалиден символ " + strDisorded.charAt(i) + "!<br/>Invalid symbol " + strDisorded.charAt(i) + "!";
                    return false;
                }
                strReplaced += charValue;
            }
            var result = MOD97(strReplaced);
            var check = 98 - MOD97(strReplaced.substr(0, strReplaced.length - 2) + "00");
            if (check < 10)
                check = "0" + check;
            if (strReplaced.substr(strReplaced.length - 2, strReplaced.length) != check) {
                createCustomAlertDeclaration("Некоректно въведен IBAN.<br/>The IBAN entered is incorrect."); /*15879_2024 - Kris*/
                return false;
            }
        }
        else {
            createCustomAlertDeclaration("Некоректна сметка " + sIBAN + "<br/>Invalid account " + sIBAN);
            return false;
        }
    }
    catch (e) {
        createCustomAlertDeclaration(e);
        return false;
    }
    return true;
}
//8365 - Vili
function CheckIBANRE(sIBAN, idForm) {
    try {
        var F = document.getElementById(idForm);
        IBAN = sIBAN.replace(/ /gi, "");
        var reIBAN = /[A-Z]{2}\d\d[A-Z0-9]{4}\d{4}[A-Z0-9]{10}/;
        var test1 = reIBAN.test(IBAN);
        var test2 = (IBAN.replace(reIBAN, "") == "") ? true : false;
        if (test1 && test2) {
            var strDisorded = IBAN.substr(4, 22) + IBAN.substr(0, 4);
            var strABC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            var i = 0;
            var strReplaced = "";
            for (i; i < 22; i++) {
                var charValue = strABC.indexOf(strDisorded.charAt(i), 0);
                if (charValue < 0) {
                    throw "Невалиден символ " + strDisorded.charAt(i) + "!<br/>Invalid symbol " + strDisorded.charAt(i) + "!";
                    return false;
                }
                strReplaced += charValue;
            }
            var result = MOD97(strReplaced);
            var check = 98 - MOD97(strReplaced.substr(0, strReplaced.length - 2) + "00");
            if (check < 10)
                check = "0" + check;
            if (strReplaced.substr(strReplaced.length - 2, strReplaced.length) != check) {
                //createCustomAlertDeclaration("Контролното число трябва да бъде " + check + "!<br/>Control number has to be " + check + "!");
                elemErrorNotF(F.elements["ACC_R"], "Некоректно въведен IBAN.<br/>The IBAN entered is incorrect.");
                return false;
            }
        }
        else {
            //createCustomAlertDeclaration("Некоректна сметка " + sIBAN + "<br/>Invalid account " + sIBAN);
            elemErrorNotF(F.elements["ACC_R"], "Некоректна сметка " + sIBAN + "<br/>Invalid account " + sIBAN);
            return false;
        }
    }
    catch (e) {
        createCustomAlertDeclaration(e);
        return false;
    }
    return true;
}

function CheckIBANSWIFT2(idForm, sIBAN) {
    try {
        var F = document.getElementById(idForm);
        IBAN = sIBAN.replace(/ /gi, "");
        var reIBAN = /[A-Z]{2}\d\d[A-Z0-9]{4}\d{4}[A-Z0-9]{10}/;
        var test1 = reIBAN.test(IBAN);
        var test2 = (IBAN.replace(reIBAN, "") == "") ? true : false;
        if (test1 && test2) {
            var strDisorded = IBAN.substr(4, 22) + IBAN.substr(0, 4);
            var strABC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            var i = 0;
            var strReplaced = "";
            for (i; i < 22; i++) {
                var charValue = strABC.indexOf(strDisorded.charAt(i), 0);
                if (charValue < 0) {
                    throw "Невалиден символ " + strDisorded.charAt(i) + "!<br/>Invalid symbol " + strDisorded.charAt(i) + "!";
                    return false;
                }
                strReplaced += charValue;
            }
            var result = MOD97(strReplaced);
            var check = 98 - MOD97(strReplaced.substr(0, strReplaced.length - 2) + "00");
            if (check < 10)
                check = "0" + check;
            if (strReplaced.substr(strReplaced.length - 2, strReplaced.length) != check) {
                elemErrorNotF(F.elements["ACC_R"], "Некоректно въведен IBAN. <br/>The IBAN entered is incorrect.");
                return false;
            }
        }
        else {
            elemErrorNotF(F.elements["ACC_R"], "Некоректно въведен IBAN. <br/>The IBAN entered is incorrect.");
            return false;
        }
    }
    catch (e) {
        createCustomAlertDeclaration(e);
        return false;
    }
    return true;
}

//Проверка за IBAN Валутен превод - 12020
function CheckSWIFTAcc(idForm, sIBAN,cntryEU) {
    try {
      
        let letterMap = new Map();
        letterMap.set('A', '10'); letterMap.set('B', '11'); letterMap.set('C', '12'); letterMap.set('D', '13'); letterMap.set('E', '14');
        letterMap.set('F', '15'); letterMap.set('G', '16'); letterMap.set('H', '17'); letterMap.set('I', '18'); letterMap.set('J', '19');
        letterMap.set('K', '20'); letterMap.set('L', '21'); letterMap.set('M', '22'); letterMap.set('N', '23'); letterMap.set('O', '24');
        letterMap.set('P', '25'); letterMap.set('Q', '26'); letterMap.set('R', '27'); letterMap.set('S', '28'); letterMap.set('T', '29');
        letterMap.set('U', '30'); letterMap.set('V', '31'); letterMap.set('W', '32'); letterMap.set('X', '33'); letterMap.set('Y', '34');
        letterMap.set('Z', '35');


        var IBAN1 = sIBAN.replace(/ /gi, "");
        var IBAN2 = IBAN1.substr(4, IBAN1.length) + IBAN1.substr(0, 4);
        // var IBAN3 = IBAN2.substr(0, IBAN2.length - 2) + "00"

        var i = 0;
        var strReplaced = "";
        for (i; i < IBAN2.length; i++) {
            var charValue = IBAN2.charAt(i);
            if (letterMap.has(charValue)) {
                strReplaced += letterMap.get(charValue);
            }
            else {
                strReplaced += charValue;
            }
        }

        var result = MOD97(strReplaced);

        if (result != 1 && cntryEU == 1) {
            return 77;
        }
        else if (result != 1) {
            return 99
        }
        else
            true;
   
        //var check = 98 - result;
        //if (check < 10)
        //    check = "0" + check;
        //if (IBAN1.substr(2, 2) != check)
        //    alert("greshka")

    }
    catch (e) {
        createCustomAlertDeclaration(e);
        return false;
    }
    return true;
}

function CheckIbanForUBBS(sIBAN, idForm, inputId) {
    var F = document.getElementById(idForm);
    try {
        if (!(sIBAN.startsWith("BG") && sIBAN.substring(4, 8) == "UBBS")) {
            elemErrorNotF(F.elements[inputId], "Моля, за валутен превод извън ОББ използвайте меню „Валутен превод“.<br/>For foreign currency transfers outside UBB, please, use the “FCY funds transfer” menu.");
            return false;
        }
    }
    catch (e) {
        alert(e);
        return false;
    }
    return true;
}

function IBAN311forBudjet(sIBAN) {
    try {
        if (sIBAN.charAt(12) == "3" || sIBAN.charAt(12) == "8") {
            createCustomAlertDeclaration("За превод към бюджетна сметка изберете 'Превод от/към бюджета'!<br/>For transfer to budget account choose 'Payment from/to the Budget'!");
            return false;
        }
    }
    catch (e) {
        alert(e);
        return false;
    }
    return true;
}

function IBAN311forBudjetR(sIBAN, F) {
    try {
        if (sIBAN.charAt(12) == "3" || sIBAN.charAt(12) == "8") {
			var fl = '#' + F; //9214
            elemErrorNotF(fl, "Моля, за превод към бюджетна сметка използвайте меню “Превод от/към бюджета”.<br/>For fund transfers to a State Budget account, please, use the Payment from/to the Budget menu.");
            return false;
        }


    }
    catch (e) {
        alert(e);
        return false;
    }
    return true;
}

function MOD97(str) {
    var i = 0;
    for (; ;) {
        var strPart = str.substr(0, 9);
        var decnumber = parseInt(strPart, 10);
        if ((decnumber < 97) && (str.length < 3))
            break;
        var del = decnumber % 97;
        str = del + str.substr(9);
    }
    return str;

}

function htmlEscape(unsafe) {
    return document
        .createTextNode(unsafe)
        .wholeText
        .replace(/&/g, "&amp;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;");
}

function OnlyNumbers_onkeypress(thisObj, evt) {

    evt = (evt) ? evt : event;
    var charCode = (evt.charCode) ? evt.charCode : ((evt.keyCode) ? evt.keyCode :
        ((evt.which) ? evt.which : 0));

    //натиснат ли е ENTER?
    if (charCode == 8)
        return;

    if (charCode == 13) {//да
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }


    //Проверка за символи различни от числа
    if (charCode < 48 || charCode > 57) {
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }
}

function Amount_onkeypress(thisObj, evt) {

    evt = (evt) ? evt : event;
    var charCode = (evt.charCode) ? evt.charCode : ((evt.keyCode) ? evt.keyCode :
        ((evt.which) ? evt.which : 0));

    //натиснат ли е ENTER?
    if (charCode == 8)
        return;

    if (charCode == 13) {//да
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }
    //, става .
    if (charCode == 44)
        charCode = 46;

    //Проверка за символи различни от числа
    if ((charCode < 48 || charCode > 57) && charCode != 46) {
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }
    //има ли "." и на коя позиция е "." ако я има
    var index = thisObj.value.lastIndexOf(".");
    //&& index != 1
    if (index != -1) {//има "."
        //стринга след "."
        var fractStr = thisObj.value.substr(index);
        if (fractStr.length > 2)//колко символа има след "."
        {
            if (evt.preventDefault)
                evt.preventDefault();
            else
                evt.returnValue = false;
            return;
        }
    }
    //ако клавиша е "."
    if (charCode == 46) {	//ако има вече "." или ако започва с "."
        if (index != -1 || thisObj.value == "") {//"."та, не се приема
            if (evt.preventDefault)
                evt.preventDefault();
            else
                evt.returnValue = false;
            return;
        }
        //дясно подравняване
        thisObj.style.textAlign = "right";
    }
}

function AmountENot_onkeypress(thisObj, evt) { //10634 amount without ,

    evt = (evt) ? evt : event;
    var charCode = (evt.charCode) ? evt.charCode : ((evt.keyCode) ? evt.keyCode :
        ((evt.which) ? evt.which : 0));

    //натиснат ли е ENTER?
    if (charCode == 8)
        return;

    if (charCode == 13) {//да
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }
    //, става .
    //if (charCode == 44)
    //    charCode = 46;

    //Проверка за символи различни от числа
    if ((charCode < 48 || charCode > 57) && charCode != 46) {
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }
    //има ли "." и на коя позиция е "." ако я има
    var index = thisObj.value.lastIndexOf(".");
    //&& index != 1
    if (index != -1) {//има "."
        //стринга след "."
        var fractStr = thisObj.value.substr(index);
        if (fractStr.length > 2)//колко символа има след "."
        {
            if (evt.preventDefault)
                evt.preventDefault();
            else
                evt.returnValue = false;
            return;
        }
    }
    //ако клавиша е "."
    if (charCode == 46) {	//ако има вече "." или ако започва с "."
        if (index != -1 || thisObj.value == "") {//"."та, не се приема
            if (evt.preventDefault)
                evt.preventDefault();
            else
                evt.returnValue = false;
            return;
        }
        //дясно подравняване
        thisObj.style.textAlign = "right";
    }
}



//проверка на съответствие между сметка и код вид плащане
function CheckVIDPAY(strIBAN, strVIDPAY) {
    var char14IBAN = strIBAN.substr(13, 1);

    var char13IBAN = strIBAN.substr(12, 1);

    if (strVIDPAY == "" && char13IBAN != "8")
        return null;

    if (strVIDPAY != "" && char13IBAN != "8")
        return ("Вид плащане се попълва само за сметки на администратори на приходи на Центр.бюджет! <br/> Payment Type should be filled in only for accounts of revenue administrators of Central Government Budget!");

    if (strVIDPAY == "" && char13IBAN == "8")
        return ("Моля, попълнете 'Вид плащане'!<br/>Please fill in 'Payment's type'!");

    var errStr = "";
    if (errStr = CheckIsStringDigit(strVIDPAY, 6, ""))
        return errStr;

    switch (char14IBAN) {
        case "1":
            if (strVIDPAY.substr(0, 2) != 11)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "2":
            if (strVIDPAY.substr(0, 2) != 22)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "3":
            if (strVIDPAY.substr(0, 2) != 33)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "4":
            if (strVIDPAY.substr(0, 2) != 44)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "5":
            if (strVIDPAY.substr(0, 2) != 55)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "6":
            if (strVIDPAY.substr(0, 2) != 56)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "7":
            if (strVIDPAY.substr(0, 2) != 57)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "8":
            if (strVIDPAY.substr(0, 2) != 58)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        case "9":
            if (strVIDPAY.substr(0, 2) != 59)
                return ("Некоректен вид плащане!<br/>Wrong Payment's type!");
            break;
        default:
            return null;
    }
}

//проверка на съответствие между сметка и код вид плащане
function CheckVIDPAY_B(strIBAN, strVIDPAY) {  //14802 //14858 //14857
    var char14IBAN = strIBAN.substr(13, 1);
    var char13IBAN = strIBAN.substr(12, 1);

    if (strVIDPAY == "" && char13IBAN != "8")
        return null;

    if (strVIDPAY != "" && char13IBAN != "8")
        return ("Вид плащане се попълва само за сметки на администратори на приходи на Центр.бюджет! <br/> Payment Type should be filled in only for accounts of revenue administrators of Central Government Budget!");
 
}

//Скриване и показване на Вид плащане на sender 8365
function VidPayS(sender, idForm) {
    var F = document.getElementById(idForm);

    var accS = "";
    accS = F.elements["ACC_S"].value;
    payS = F.elements["PAY_S"].value;

    if (accS.substring(12, 13) != 8) {

        $('#frmPAYMENT #PAYS1').val("");
        $('#frmPAYMENT #PAYS1').prop('selected', false).change().trigger('select2:select');
        $('#dPAYS1').addClass("hidden");
        return;
    }
    else {
        $('#dPAYS1').removeClass("hidden");
        return;
    }
}
//кодовете за вид плащане, които съответстват на изписаната бюджетна сметка

function CodPayView(idForm,accR,frmVidPay,flag) {
	
	if(accR != '' && accR.length > 13 ){
    var F = document.getElementById(idForm);
	var fVidPay = document.getElementById(frmVidPay);   
	var char313IBAN = accR.substring(12, 14);	 	
	if(flag == 1 || (document.getElementById("OldPayTwoChar").value != document.getElementById("TwoCharIBAN").value && document.getElementById("TmplId").value ==''))
		{
	
	 switch (char313IBAN) {
		  case "00": 									
              document.getElementById("TwoCharIBAN").value = '00';				
              break;
	    case "80":
	         document.getElementById("TwoCharIBAN").value = '80';
	         break;
        case "81": 									
              document.getElementById("TwoCharIBAN").value = '11';				
            break;
        case "82":
             document.getElementById('TwoCharIBAN').value = '22';
            break;
        case "83":
            document.getElementById('TwoCharIBAN').value = '33';
            break;
        case "84":
            document.getElementById('TwoCharIBAN').value = '44';
            break;
        case "85":
            document.getElementById('TwoCharIBAN').value = '55';
            break;
        case "86":
            document.getElementById('TwoCharIBAN').value = '56';
            break;
        case "87":
            document.getElementById('TwoCharIBAN').value = '57';
            break;
        case "88":
            document.getElementById('TwoCharIBAN').value = '58';
            break;
        case "89":
           document.getElementById('TwoCharIBAN').value = '59';
            break;
        default:
           document.getElementById('TwoCharIBAN').value = '99';
			break;
    }	 	
	GetIbanSal('frmPAYMENT', 'frmVidPay','PAYR1'); 
	
	document.getElementById('OldPayTwoChar').value = char313IBAN;
		}
	}
	
}

//скриване и показване на полета Импорт/Масови плащания 9485
function hideShowFieldsImport(idForm)
{
	 var F = document.getElementById(idForm);
	
    if (document.getElementById("IMPORT_TYPE1").checked) {
        $('#lblSwift').removeClass("hidden");
        $('#lblSwiftAcc').removeClass("hidden");
        $('#lblSwiftRd').removeClass("hidden");
        $('#hideValueDate').removeClass("hidden");
        $('#importBudgetMassBtn').addClass("hidden"); //Tisho
        $('#importBtn').removeClass("hidden");
        $('#massPaymBtn').addClass("hidden");
        $('#DEC').addClass("hidden"); //10476
        $("#DECL30K1").val('');//10476
        $('#chbDeclData').prop('checked', false);
        UploadFileImportB(1); // Tisho 14279/OOBT-109
    }
    else if (document.getElementById("IMPORT_TYPE2").checked) //Tisho
    {
        $('#lblSwift').addClass("hidden");
        $('#lblSwiftAcc').addClass("hidden");
        $('#lblSwiftRd').addClass("hidden");
        $('#hideValueDate').addClass("hidden");
        $("#DECL30K1").val('');//10476
        $('#chbDeclData').prop('checked', false);//10476
        $('#importBudgetMassBtn').addClass("hidden"); //Tisho
        $('#importBtn').addClass("hidden");
        $('#massPaymBtn').removeClass("hidden");
        UploadFileImportB(2); // Tisho 14279/OOBT-109
    }
    else //Tisho
    {
        $('#lblSwift').removeClass("hidden");       // OOBT-142 Tisho {
        $('#lblSwiftAcc').removeClass("hidden");
        $('#lblSwiftRd').removeClass("hidden");
        $('#hideValueDate').removeClass("hidden");  // OOBT-142 Tisho }
        $('#importBudgetMassBtn').removeClass("hidden");
        $('#importBtn').addClass("hidden");
        $('#massPaymBtn').addClass("hidden");
        $('#DEC').addClass("hidden"); //10476
        $("#DECL30K1").val('');//10476
        $('#chbDeclData').prop('checked', false);
        UploadFileImportB(3); // Tisho 14279/OOBT-109
    }
}

//Скриване и показване на Декларация при Местно-Чуждестранно лице за SWIFT2 при попълване от шаблон 8365 Vili
function SWIFTTypeR(sender, idForm) {
    var F = document.getElementById(idForm);
    F.elements["rbY"].checked = false;
    F.elements["rbN"].checked = false;

    var radios = document.getElementsByName('TYPE_R');
    var type_r = 9;
    for (var i = 0, length = radios.length; i < length; i++) {
        if (radios[i].checked) {
            type_r = radios[i].value;

            if (type_r == 'МЕСТНО ЛИЦЕ') {
                $('#Decl7').addClass("hidden");
                return;
            }
            if (type_r == 'ЧУЖДЕСТРАННО ЛИЦЕ') {
                $('#Decl7').removeClass("hidden");
                return;
            }
        }
    }
}

function OnlyNumbers(evt) {
    evt = (evt) ? evt : event;
    var charCode = (evt.charCode) ? evt.charCode : ((evt.keyCode) ? evt.keyCode :
        ((evt.which) ? evt.which : 0));
    if (charCode == 13 || charCode == 46 || charCode == 8) {
        evt.returnValue = true;
        return;
    }
    else if (charCode < 48 || charCode > 57) {
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return;
    }
    return;
}


function SignImportSalary(f, submitform) {

    if ("ActiveXObject" in window || !(navigator.userAgent.toLowerCase().indexOf('firefox') == -1)) {

        removeError(f);
        removeError("enquiry-salary-table");

        if ($("div[id^='IdErr']").length > 0) { //8954
            $("div[id^='IdErr']").remove();
        }
        var strPacketInXML = "";

        if (document.getElementById("outPutDec").value == 1)
            document.getElementById('OUTPUTF').value = document.getElementById("outPutFOld").value;


        if (document.getElementById("NotValC").value != "") {
            createCustomAlertDeclaration("Непозволена сметка за изплащане на работни заплати. Повече информация можете да получите на тел. 0700 117 17.<br/>Unauthorised payroll account. For further information call 0700 117 17.");
            return;
        }
        if (document.getElementById("salIbs").value == "") {
            elemError(document.getElementById("salIbs"), "Няма избрана сметка!<br/>No selected account!");
            return;
        }
        if ("ActiveXObject" in window) {
            //if (typeof ActiveXObject != "undefined") {
            strPacketInXML = readFileSalary("enquiry-salary-table");
            document.getElementById('OUTPUTF').value = strPacketInXML;
        }
        else {
            strPacketInXML = document.getElementById("OUTPUTF").value;
            if (strPacketInXML == "") {
                elemError(document.getElementById("FILE"), "Моля изберете файл!<br/>Please select a file!");
                return;
            }
        }


        if (document.getElementById("SALB").value.toString().substring(0, 3) != "BGN") {
            createCustomAlertZ("Сметката е валутна. Сигурни ли сте че искате да продължите?<br/>The account is in foreign currency. Are you sure you want to proceed?", 97);
        }

        var sRetCheck = CheckFile(document.getElementById("FILENAME").value, document.getElementById("SALB").value, document.getElementById("SalAc").value, document.getElementById("ACC_S").value, document.getElementById("ALLFILEMODEL").value, strPacketInXML);
        if (sRetCheck === "refused" || sRetCheck.indexOf('refused') > -1) {
            return;
        }

        if (sRetCheck.indexOf("|") <= 0) {
            //if (navigator.userAgent.toLowerCase().indexOf('firefox') == -1) {
            VP_SalaryError(document.getElementById("idMSID").value, document.getElementById("FILENAME").value + "|" + sRetCheck, "bg", "", "");
            //}
            createCustomAlertDeclaration("Във файла има грешки! " + sRetCheck + " <br/> Поправете ги и опитайте отново!<br/>Списъкът с грешките може да се разгледа през меню Справки по заплати-Грешки при зареждане на файлове. <br/>Errors in the file! " + sRetCheck + "<br/> Please, correct errors and try again!<br/> The error list can be  viewed through Payroll Reports-Files Upload Errors Menu.");
            return;
        }
        else {
            var viewDS = sRetCheck.toString().split("|");
            if (viewDS[8] === 'true') {
                createCustomAlertZ('Вие стартирате зареждане на файл със заплати от валутна сметка, като сумите и сметките на преводите за служителите трябва да са в същата валутата. Сигурни ли сте, че искате да продължите ?<br/> You will start uploading a payroll file from an account in foreign currency. Note that the employees` payroll amounts and accounts should be in that same ', 95)
            }

            var message = "";
            var messageEN = "";
            message += "Файл на обща сума: " + viewDS[0] + " " + htmlEscape(document.getElementById("SALB").value).toString().substring(0, 3) + " и " + viewDS[1] + " записа";
            messageEN += "File (total amount):" + viewDS[0] + " " + htmlEscape(document.getElementById("SALB").value).toString().substring(0, 3) + " and " + viewDS[1] + " entries";

            if (viewDS[5] > 0) {
                if (document.getElementById("SALB").value.toString().substring(0, 3) != "BGN") {
                    message += ".<br/>" + viewDS[5] + " броя вътрешни превода, с такса " + (viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)).toFixed(2) + " BGN";
                    messageEN += ".<br/>" + viewDS[5] + " nmb. of intrabank transfers, with a fee of BGN " + (viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)).toFixed(2);
                }
                else {
                    message += ".<br/>" + viewDS[5] + " броя вътрешни превода, с такса " + (viewDS[5] * parseFloat(document.getElementById("tubbL").value)).toFixed(2) + " BGN";
                    messageEN += ".<br/>" + viewDS[5] + " nmb. of intrabank transfers, with a fee of BGN " + (viewDS[5] * parseFloat(document.getElementById("tubbL").value)).toFixed(2);
                }
            }
            if (document.getElementById("SALB").value.toString().substring(0, 3) == "BGN") {
                if (viewDS[6] > 0) {
                    message += ".<br/>" + viewDS[6] + " броя междубанкови BISERA превода, с такса " + (viewDS[6] * parseFloat(document.getElementById("tBisera").value)).toFixed(2) + " BGN";
                    messageEN += ".<br/>" + viewDS[6] + " nmb. of interbank BISERA transfers, with a fee of " + (viewDS[6] * parseFloat(document.getElementById("tBisera").value)).toFixed(2) + " BGN";
                }
                if (viewDS[7] > 0) {
                    message += ".<br/>" + viewDS[7] + " броя междубанкови RINGS превода, с такса " + (viewDS[7] * parseFloat(document.getElementById("trings").value)).toFixed(2) + " BGN";
                    messageEN += ".<br/>" + viewDS[7] + " nmb. of interbank RINGS transfers, with a fee of " + (viewDS[7] * parseFloat(document.getElementById("trings").value)).toFixed(2) + " BGN";
                }
            }
            message += ".  <br/><br/> " + messageEN + "";
            createCustomAlertOKZ(message, 94);
        }
        if (viewDS[3]) {
            if (viewDS[3] == "true") {
                document.getElementById("YESECON").value = "1";
            }
        }

        //sektor foreing
        var sSectorForeingArr = "2200|9100|9210|9220|9300|9500|9930|9940|";
        var sGLSECTOR = document.getElementById("GLSECTOR").value;
        if (sSectorForeingArr.indexOf(sGLSECTOR + "|") >= 0) {
            document.getElementById("YESECON").value = "1";
        }

        if (viewDS[0]) {
            /*document.getElementById("outPutFOld").value = document.getElementById("OUTPUTF").value;
            document.getElementById("OUTPUTF").value = base64Encode(viewDS[2]);
            document.getElementById("AMOUNT").value = viewDS[0];
            document.getElementById("ALLROW").value = viewDS[1];
            document.getElementById("CURR").value = document.getElementById("SALB").value.toString().substring(0, 3);
            document.getElementById("outPutDec").value = 1;*/
            document.getElementById(f).elements["outPutFOld"].value = document.getElementById("OUTPUTF").value;
            document.getElementById(f).elements["OUTPUTF"].value = base64Encode(viewDS[2]);
            document.getElementById(f).elements["AMOUNT"].value = viewDS[0];
            document.getElementById(f).elements["ALLROW"].value = viewDS[1];
            document.getElementById(f).elements["CURR"].value = document.getElementById("SALB").value.toString().substring(0, 3);
            document.getElementById("outPutDec").value = 1;

        }
        else {
            createCustomAlertDeclaration("Има грешка! <br/> ERROR !");
            return;
        }

        try {
            var frm = document.getElementById(f);

            if (frm.elements["AMOUNT"].value >= 30000) {
                var isFreeDekl = document.getElementById("idisFreeOfDECL30K").value;
                if (isFreeDekl != 1) {
                    var frmDECL30 = frm.elements["DECL30K"].value;
                    var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
                    var test1 = re.test(frmDECL30);

                    if (frmDECL30.length < 5) {
                        if (trim(frmDECL30).length == 0) {
                            elemError(frm.elements["DECL30K"], "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП! <br/> Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!");
                            return false;
                        }
                        elemError(frm.elements["DECL30K"], "Моля, въведете поне 5 символа в полето за произход на паричните средства.<br/>Please, enter minimum 5 characters in the Origin of Funds field.");
                        return false;
                    }
                    else {
                        if (!test1) {
                            elemError(frm.elements["DECL30K"], " Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/> Incorrect symbol in field 'DECLARATION for money origin according'!");
                            return;
                        }

                    }
                }
            }

            if (!FormalCheckOrder(f))
            { return false; }

            if (!Validate(f))
            { return false; }
            //8954
            if (!CheckDeclData(f))
            { return false; }
            //8954

            var fileInput = document.getElementById("FILENAME");

            createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "", 93);

            if ($("div[id='id-js-continue']").length < 1) {
                $("<div id='id-js-continue'  class='invisible'><a href='javascript:;' class='js-continue'>OK</a></div>").appendTo('body');//8954
            }

            $(document).off('click', '.js-continue').on('click', '.js-continue', function () {
                $("div[id='id-js-continue']").remove();
                ImportSalaryConfirmReTo(f, submitform);
            });
            showPopupZi(function () {
                $('.js-continue').click();
            });

        }
        catch (e) {
            createCustomAlertDeclaration(e + "<br/>" + e.description);
        }
    }
    else {
        createCustomAlertDeclaration("Подписване на документи е възможно само с браузъри Internet Explorer (32-битова версия) или Mozilla Firefox.<br/>Signing of documents is possible only with browsers Internet Explorer (32-bit version) or Mozilla Firefox.");
    }
}

function ImportSalaryConfirmReTo(f, submitform) {
    var submfrm = document.getElementById(submitform);
    var frm = document.getElementById(f);

    submfrm.elements["COMMAND"].value = "IMPORTF";

    submfrm.elements["SEND"].value = "Off";
    if (frm.elements["send"].checked)
        submfrm.elements["SEND"].value = "on";

    var xmltoSEND = "<Packet/>";
    var ElemGuid = frm.elements["id"];
    xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
    ElemGuid.value = NextGuid(ElemGuid.value);
    sxmlnull = MakeXML(f)
    if ("" == sxmlnull)
        return false;

    xmltoSEND += sxmlnull;
    xmltoSEND += "</Packet>";
    var SerialNumber = document.getElementById("idMSERIALNUMBER").value;
    xmltoSEND = CRLF(xmltoSEND);
    var Base64Sign = SignContent(xmltoSEND, submfrm.elements["ENCODING"], SerialNumber);

    if (null == Base64Sign) {
        createCustomAlertDeclaration("Невалиден подпис!<br/>Your sign is not valid!");
        return false;
    }

    Base64Sign = Base64Sign.replace(/\r\n/gi, "");
    submfrm.elements["BASE64SIGN"].value = Base64Sign;
    submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
    BASE64XMLtoSEND = null;
    xmltoSEND = null;

    breadcrumbs();

    var sbody = ObtainBody(submitform);
    document.getElementById("Panel1").innerHTML = strWait;
    idAJAXResult = "Panel1";

    SendPostRequest("t.aspx", sbody);
}
function SignImportSalaryF(f, submitform) {

        removeError(f);
        removeError("enquiry-salary-table");

        if ($("div[id^='IdErr']").length > 0) { //8954
            $("div[id^='IdErr']").remove();
        }
        var strPacketInXML = "";
        var FL_EUR_BGN = document.getElementById("FL_EUR_BGN").value;
        var Rate = document.getElementById("Rate").value;
        var Currency = document.getElementById("Currency").value;
        var toCurrency = document.getElementById("toCurrency").value;

        if (document.getElementById("outPutDec").value == 1)
            document.getElementById('OUTPUTF').value = document.getElementById("outPutFOld").value;


        if (document.getElementById("NotValC").value != "") {
            createCustomAlertDeclaration("Непозволена сметка за изплащане на работни заплати. Повече информация можете да получите на тел. 0700 117 17.<br/>Unauthorised payroll account. For further information call 0700 117 17.");
            return;
        }
        if (document.getElementById("salIbs").value == "") {
            elemError(document.getElementById("salIbs"), "Няма избрана сметка!<br/>No selected account!");
            return;
        }
        if ("ActiveXObject" in window) {
            strPacketInXML = readFileSalary("enquiry-salary-table");
            document.getElementById('OUTPUTF').value = strPacketInXML;
        }
        else {
            strPacketInXML = document.getElementById("OUTPUTF").value;
            if (strPacketInXML == "") {
                elemError(document.getElementById("FILE"), "Моля изберете файл!<br/>Please select a file!");
                return;
            }
        }


        if (document.getElementById("SALB").value.toString().substring(0, 3) != "BGN") {
            createCustomAlertZ("Сметката е валутна. Сигурни ли сте че искате да продължите?<br/>The account is in foreign currency. Are you sure you want to proceed?", 97);
        }

        var sRetCheck = CheckFile(document.getElementById("FILENAME").value, document.getElementById("SALB").value, document.getElementById("SalAc").value, document.getElementById("ACC_S").value, document.getElementById("ALLFILEMODEL").value, strPacketInXML);
        if (sRetCheck === "refused" || sRetCheck.indexOf('refused') > -1) {
            return;
        }

        if (sRetCheck.indexOf("|") <= 0) {
            VP_SalaryError(document.getElementById("idMSID").value, document.getElementById("FILENAME").value + "|" + sRetCheck, "bg", "", "");
            createCustomAlertDeclaration("Във файла има грешки! " + sRetCheck + " <br/> Поправете ги и опитайте отново!<br/>Списъкът с грешките може да се разгледа през меню Справки по заплати-Грешки при зареждане на файлове. <br/>Errors in the file! " + sRetCheck + "<br/> Please, correct errors and try again!<br/> The error list can be  viewed through Payroll Reports-Files Upload Errors Menu.");
            return;
        }
        else {
            var viewDS = sRetCheck.toString().split("|");
            if (viewDS[8] === 'true') {
                createCustomAlertZ('Вие стартирате зареждане на файл със заплати от валутна сметка, като сумите и сметките на преводите за служителите трябва да са в същата валутата. Сигурни ли сте, че искате да продължите ?<br/> You will start uploading a payroll file from an account in foreign currency. Note that the employees` payroll amounts and accounts should be in that same ', 95)
            }

            var message = "";
            var messageEN = "";

            if (FL_EUR_BGN == 1 && Currency == document.getElementById("SALB").value.toString().substring(0, 3)) {
                message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (viewDS[0] / Rate).toFixed(2) + " " + toCurrency + " и " + viewDS[1] + " записа";
                messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (viewDS[0] / Rate).toFixed(2) + " " + toCurrency + " and " + viewDS[1] + " entries";

                if (viewDS[5] > 0) {
                    if (document.getElementById("SALB").value.toString().substring(0, 3) != "BGN") {
                        message += ".<br/>" + viewDS[5] + " броя вътрешни превода, с такса " + (viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)).toFixed(2) + " BGN / " + ((viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)) / Rate).toFixed(2) + " " + toCurrency;
                        messageEN += ".<br/>" + viewDS[5] + " nmb. of intrabank transfers, with a fee of " + (viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)).toFixed(2) + " BGN / " + ((viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)) / Rate).toFixed(2) + " " + toCurrency;
                    }
                    else {
                        message += ".<br/>" + viewDS[5] + " броя вътрешни превода, с такса " + (viewDS[5] * parseFloat(document.getElementById("tubbL").value)).toFixed(2) + " BGN / " + ((viewDS[5] * parseFloat(document.getElementById("tubbL").value)) / Rate).toFixed(2) + " " + toCurrency;
                        messageEN += ".<br/>" + viewDS[5] + " nmb. of intrabank transfers, with a fee of " + (viewDS[5] * parseFloat(document.getElementById("tubbL").value)).toFixed(2) + " BGN / " + ((viewDS[5] * parseFloat(document.getElementById("tubbL").value)) / Rate).toFixed(2) + " " + toCurrency;
                    }
                }
                if (document.getElementById("SALB").value.toString().substring(0, 3) == "BGN") {
                    if (viewDS[6] > 0) {
                        message += ".<br/>" + viewDS[6] + " броя междубанкови BISERA превода, с такса " + (viewDS[6] * parseFloat(document.getElementById("tBisera").value)).toFixed(2) + " BGN / " + ((viewDS[6] * parseFloat(document.getElementById("tBisera").value)) / Rate).toFixed(2) + " " + toCurrency;
                        messageEN += ".<br/>" + viewDS[6] + " nmb. of interbank BISERA transfers, with a fee of " + (viewDS[6] * parseFloat(document.getElementById("tBisera").value)).toFixed(2) + " BGN / " + ((viewDS[6] * parseFloat(document.getElementById("tBisera").value)) / Rate).toFixed(2) + " " + toCurrency;
                    }
                    if (viewDS[7] > 0) {
                        message += ".<br/>" + viewDS[7] + " броя междубанкови RINGS превода, с такса " + (viewDS[7] * parseFloat(document.getElementById("trings").value)).toFixed(2) + " BGN / " + ((viewDS[7] * parseFloat(document.getElementById("trings").value)) / Rate).toFixed(2) + " " + toCurrency;
                        messageEN += ".<br/>" + viewDS[7] + " nmb. of interbank RINGS transfers, with a fee of " + (viewDS[7] * parseFloat(document.getElementById("trings").value)).toFixed(2) + " BGN / " + ((viewDS[7] * parseFloat(document.getElementById("trings").value)) / Rate).toFixed(2) + " " + toCurrency;
                    }
                }

            }
            else {
                message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " и " + viewDS[1] + " записа";
                messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " and " + viewDS[1] + " entries";

                if (viewDS[5] > 0) {
                    if (document.getElementById("SALB").value.toString().substring(0, 3) != "BGN") {
                        message += ".<br/>" + viewDS[5] + " броя вътрешни превода, с такса " + (viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)).toFixed(2) + " BGN";
                        messageEN += ".<br/>" + viewDS[5] + " nmb. of intrabank transfers, with a fee of " + (viewDS[5] * parseFloat(document.getElementById("tubbNotL").value)).toFixed(2) + " BGN";
                    }
                    else {
                        message += ".<br/>" + viewDS[5] + " броя вътрешни превода, с такса " + (viewDS[5] * parseFloat(document.getElementById("tubbL").value)).toFixed(2) + " BGN";
                        messageEN += ".<br/>" + viewDS[5] + " nmb. of intrabank transfers, with a fee of " + (viewDS[5] * parseFloat(document.getElementById("tubbL").value)).toFixed(2) + " BGN";
                    }
                }
                if (document.getElementById("SALB").value.toString().substring(0, 3) == "BGN") {
                    if (viewDS[6] > 0) {
                        message += ".<br/>" + viewDS[6] + " броя междубанкови BISERA превода, с такса " + (viewDS[6] * parseFloat(document.getElementById("tBisera").value)).toFixed(2) + " BGN";
                        messageEN += ".<br/>" + viewDS[6] + " nmb. of interbank BISERA transfers, with a fee of " + (viewDS[6] * parseFloat(document.getElementById("tBisera").value)).toFixed(2) + " BGN";
                    }
                    if (viewDS[7] > 0) {
                        message += ".<br/>" + viewDS[7] + " броя междубанкови RINGS превода, с такса " + (viewDS[7] * parseFloat(document.getElementById("trings").value)).toFixed(2) + " BGN";
                        messageEN += ".<br/>" + viewDS[7] + " nmb. of interbank RINGS transfers, with a fee of " + (viewDS[7] * parseFloat(document.getElementById("trings").value)).toFixed(2) + " BGN";
                    }
                }

            }
            message += ".  <br/><br/> " + messageEN + "";
            createCustomAlertOKZ(message, 94);
        }
        if (viewDS[3]) {
            if (viewDS[3] == "true") {
                document.getElementById("YESECON").value = "1";
            }
        }

        //sektor foreing
        var sSectorForeingArr = "2200|9100|9210|9220|9300|9500|9930|9940|";
        var sGLSECTOR = document.getElementById("GLSECTOR").value;
        if (sSectorForeingArr.indexOf(sGLSECTOR + "|") >= 0) {
            document.getElementById("YESECON").value = "1";
        }

        if (viewDS[0]) {
            /*document.getElementById("outPutFOld").value = document.getElementById("OUTPUTF").value;
            document.getElementById("OUTPUTF").value = base64Encode(viewDS[2]);
            document.getElementById("AMOUNT").value = viewDS[0];
            document.getElementById("ALLROW").value = viewDS[1];
            document.getElementById("CURR").value = document.getElementById("SALB").value.toString().substring(0, 3);
            document.getElementById("outPutDec").value = 1;*/
            document.getElementById(f).elements["outPutFOld"].value = document.getElementById("OUTPUTF").value;
            document.getElementById(f).elements["OUTPUTF"].value = base64Encode(viewDS[2]);
            document.getElementById(f).elements["AMOUNT"].value = viewDS[0];
            document.getElementById(f).elements["ALLROW"].value = viewDS[1];
            document.getElementById(f).elements["CURR"].value = document.getElementById("SALB").value.toString().substring(0, 3);
            document.getElementById("outPutDec").value = 1;
        }
        else {
            createCustomAlertDeclaration("Има грешка! <br/> ERROR !");
            return;
        }

        try {
            var frm = document.getElementById(f);

			var curr = frm.elements["SALB"].value.toString().substring(0, 3);
            if (RATE[curr] * frm.elements["AMOUNT"].value >= 30000) {
                var isFreeDekl = document.getElementById("idisFreeOfDECL30K").value;
                if (isFreeDekl != 1) {
                    frm.elements["AMOUNT2"].value = frm.elements["AMOUNT"].value;//10476
                    frm.elements["CURR2"].value = frm.elements["SALB"].value.toString().substring(0, 3);                                      
                    $("#DEC").removeClass("hidden");

                    var frmDECL30 = frm.elements["DECL30K"].value;
                    var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
                    var test1 = re.test(frmDECL30);

                    if (frmDECL30.length < 5) {
                        if (trim(frmDECL30).length == 0) {
                            elemError(frm.elements["DECL30K"], "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП! <br/> Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!");
                            return false;
                        }
                        elemError(frm.elements["DECL30K"], "Моля, въведете поне 5 символа в полето за произход на паричните средства.<br/>Please, enter minimum 5 characters in the Origin of Funds field.");
                        return false;
                    }
                    else {
                        if (!test1) {
                            elemError(frm.elements["DECL30K"], " Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/> Incorrect symbol in field 'DECLARATION for money origin according'!");
                            return;
                        }

                    }


                }



            }
            else {
			$("#DECL30K").val('');
			$('#chbDeclData').prop('checked', false);
                	$("#DEC").addClass("hidden");
                    }

            if (!FormalCheckOrder(f))
            { return false; }

            if (!Validate(f))
            { return false; }

            //8954
            if (!CheckDeclData(f))
            { return false; }
            //8954
            var fileInput = document.getElementById("FILENAME");

            

            if (FL_EUR_BGN == 1 && Currency == document.getElementById("SALB").value.toString().substring(0, 3)) {
                createCustomAlertZ("Изберете ОК за изпращане към банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (parseFloat(frm.elements["AMOUNT"].value) / Rate).toFixed(2) + " " + toCurrency + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (parseFloat(frm.elements["AMOUNT"].value) / Rate).toFixed(2) + " " + toCurrency + "", 93);
            }
            else {
                createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "", 93);
            }


            if ($("div[id='id-js-continue']").length < 1) {
                $("<div id='id-js-continue' class='invisible'><a href='javascript:;' class='js-continue'>OK</a></div>").appendTo('body'); //8954
            }

            $(document).off('click', '.js-continue').on('click', '.js-continue', function () {
                $("div[id='id-js-continue']").remove();
                ImportSalaryConfirmReToF(f, submitform);
            });
            showPopupZi(function () {
                $('.js-continue').click();
            });

        }
        catch (e) {
            createCustomAlertDeclaration(e + "<br/>" + e.description);
        }
}
//9720
function SignImportMassPaymF(f, submitform) {

    removeError(f);
    removeError("enquiry-salary-table");

    if ($("div[id^='IdErr']").length > 0) { //8954
        $("div[id^='IdErr']").remove();
    }

    var strPacketInXML = "";

    if (document.getElementById("outPutDec").value == 1)
        document.getElementById('OUTPUTF').value = document.getElementById("outPutFOld").value;

    if (document.getElementById("salIbs").value == "") {
        elemError(document.getElementById("salIbs"), "Няма избрана сметка!<br/>No selected account!");
        return;
    }
    if ("ActiveXObject" in window) {
        //if (typeof ActiveXObject != "undefined") {
        strPacketInXML = readFileMP("enquiry-salary-table");
        document.getElementById('OUTPUTF').value = strPacketInXML;
    }
    else {
        strPacketInXML = document.getElementById("OUTPUTF").value;
        if (strPacketInXML == "") {
            elemError(document.getElementById("FILE"), "Моля изберете файл!<br/>Please select a file!");
           return;
        }
    }
	
	if(strPacketInXML.indexOf(';') == -1 || strPacketInXML.indexOf('|') >=0)
	{
		  elemError(document.getElementById("FILE"), "Моля, изберете файл в коректен формат!<br/>Please, choose file in correct format!");
           return;
	}
	if(strPacketInXML.indexOf('OMP;DP;') == -1)
	{
		createCustomAlertDeclaration("За обработка на посоченият от Вас файл е необходимо да използване функцията Импорт на файл.<br/>For processing the file, indicated by you, please select Import From File function.");
        return;
	}
	var decl = "";
   if(typeof(document.getElementById(f).elements["DECL30K"]) != "undefined")
	   decl = document.getElementById(f).elements["DECL30K"].value;
	   
    var sRetCheck = CheckFileMass(htmlEscape(document.getElementById("FILENAME").value), htmlEscape(document.getElementById("SALB").value), htmlEscape(document.getElementById("SalAc").value), htmlEscape(document.getElementById("ACC_S").value), htmlEscape(document.getElementById("ALLFILEMODEL").value), strPacketInXML, decl);
     var viewDS = sRetCheck.toString().split("|");
  if (viewDS[7] != "") { //full file and error
		$('#Panel1 #mainIMPORTMassP').attr("style", "display: none;"); //скрива полетата
		$("#ErrLoad").removeAttr("style");
        $('#Panel1 #ErrLoad table').append('<tbody>' + sRetCheck + '<tbody>');
        sRetCheck = null;

        var errorTable = cDataTable($('.error-table'), "", false, false, true);
		
		return;
    }
    else {
		
		if (document.getElementById("ACC_S").value != viewDS[5]) {
            createCustomAlertDeclaration("Избраната сметка не съответства на сметката във файла.<br/> The chosen account does not match the one in the file.");
        return;
       }

        if (parseFloat(viewDS[0]).toFixed(2) != parseFloat(viewDS[3]).toFixed(2)) {
            createCustomAlertDeclaration("Грешна обща сума: Написано: " + parseFloat(viewDS[3]).toFixed(2) + ", изчислено: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong Total Amount: Entered: " + parseFloat(viewDS[3]).toFixed(2) + ", Calculated: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Please, make the needed corrections and try again.");
        return;
       }
	    if (viewDS[1] != viewDS[4]) {
            createCustomAlertDeclaration("Грешен брой редове: Написано " + viewDS[4] + ", изчислено " + viewDS[1] + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong number of rows: Entered: " + viewDS[4] + ", Calculated " + viewDS[1] + ".<br/>Please, make the needed corrections and try again.");
        return;
       }

        var message = "";
        var messageEN = "";
        message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("OCurr").value.toString() + " и " + viewDS[1] + " записа";
        messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("OCurr").value.toString() + " and " + viewDS[1] + " entries";

        message += ".  <br/><br/> " + messageEN + "";
        createCustomAlertOKZ(message, 94);
    }

    if (viewDS[0]) {
        document.getElementById(f).elements["outPutFOld"].value = document.getElementById("OUTPUTF").value;
        document.getElementById(f).elements["OUTPUTF"].value = base64Encode(viewDS[2]);
        document.getElementById(f).elements["AMOUNT"].value = viewDS[0];
        document.getElementById(f).elements["ALLROW"].value = viewDS[1];
        document.getElementById(f).elements["CURR"].value = document.getElementById("OCurr").value.toString();
        document.getElementById("outPutDec").value = 1;

    }
    else {
        createCustomAlertDeclaration("Има грешка! <br/> ERROR !");
        return;
    }

    try {
        var frm = document.getElementById(f);

        if (viewDS[6] > 0) {
            var isFreeDekl = document.getElementById("idisFreeOfDECL30K").value;
            if (isFreeDekl != 1) {
                var frmDECL30 = frm.elements["DECL30K"].value;
                var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
                var test1 = re.test(frmDECL30);
				
                frm.elements["AMOUNT2"].value = frm.elements["AMOUNT"].value;//10476
                frm.elements["CURR2"].value = frm.elements["CURR"].value;
               		
                $("#DEC").removeClass("hidden");
                if (frmDECL30.length < 5) {
                    if (trim(frmDECL30).length == 0) {
                        elemError(frm.elements["DECL30K"], "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП! <br/> Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!");
                        return false;
                    }
                    elemError(frm.elements["DECL30K"], "Моля, въведете поне 5 символа в полето за произход на паричните средства.<br/>Please, enter minimum 5 characters in the Origin of Funds field.");
                    return false;
                }
                else {
                    if (!test1) {
                        elemError(frm.elements["DECL30K"], " Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/> Incorrect symbol in field 'DECLARATION for money origin according'!");
                        return;
                    }

                }
            }
	else{
		$("#DECL30K").val('');				
		$("#DEC").addClass("hidden");
	 }
        }

        if (!FormalCheckOrder(f))
        { return false; }

        if (!Validate(f))
        { return false; }

        //8954
        if (!CheckDeclData(f))
        { return false; }
        //8954
        var fileInput = document.getElementById("FILENAME");

        createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("OCurr").value.toString() + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("OCurr").value.toString() + "", 93);

        if ($("div[id='id-js-continue']").length < 1) {
            $("<div id='id-js-continue'  class='invisible'><a href='javascript:;' class='js-continue'>OK</a></div>").appendTo('body'); //8954
        }

        $(document).off('click', '.js-continue').on('click', '.js-continue', function () {
            $("div[id='id-js-continue']").remove();
            ImportMPConfirmReToF(f, submitform);
        });
        showPopupZi(function () {
            $('.js-continue').click();
        });

    }
    catch (e) {
        createCustomAlertDeclaration(e + "<br/>" + e.description);
    }
}
//9720
function SignImportMassPaym(f, submitform) {

    removeError(f);
    removeError("enquiry-salary-table");

    if ($("div[id^='IdErr']").length > 0) { //8954
        $("div[id^='IdErr']").remove();
    }

    var strPacketInXML = "";

    if (document.getElementById("outPutDec").value == 1)
        document.getElementById('OUTPUTF').value = document.getElementById("outPutFOld").value;
    if (document.getElementById("salIbs").value == "") {
        elemError(document.getElementById("salIbs"), "Няма избрана сметка!<br/>No selected account!");
        return;
    }
    if ("ActiveXObject" in window) {
        //if (typeof ActiveXObject != "undefined") {
        strPacketInXML = readFileMP("enquiry-salary-table");
        document.getElementById('OUTPUTF').value = strPacketInXML;
    }
    else {
        strPacketInXML = document.getElementById("OUTPUTF").value;
        if (strPacketInXML == "") {
            elemError(document.getElementById("FILE"), "Моля изберете файл!<br/>Please select a file!");
           return;
        }
    }

	if(strPacketInXML.indexOf(';') == -1 || strPacketInXML.indexOf('|') >=0)
	{
		  elemError(document.getElementById("FILE"), "Моля, изберете файл в коректен формат!<br/>Please, choose file in correct format!");
           return;
	}

	var decl = "";
   if(typeof(document.getElementById(f).elements["DECL30K"]) != "undefined")
	   decl = document.getElementById(f).elements["DECL30K"].value;

    var sRetCheck = CheckFileMass(htmlEscape(document.getElementById("FILENAME").value), htmlEscape(document.getElementById("SALB").value), htmlEscape(document.getElementById("SalAc").value), htmlEscape(document.getElementById("ACC_S").value), htmlEscape(document.getElementById("ALLFILEMODEL").value), strPacketInXML, decl);
          var viewDS = sRetCheck.toString().split("|");

 if (viewDS[7] != "") { //full file and error
		$('#Panel1 #mainIMPORTMassP').attr("style", "display: none;"); //скрива полетата
		$("#ErrLoad").removeAttr("style");
        $('#Panel1 #ErrLoad table').append('<tbody>' + sRetCheck + '<tbody>');
        sRetCheck = null;

        var errorTable = cDataTable($('.error-table'), "", false, false, true);
		
		return;
    }
    else {

		
		if (document.getElementById("ACC_S").value != viewDS[5]) {
           createCustomAlertDeclaration("Избраната сметка не съответства на сметката във файла.");
        return;
       }

        if (parseFloat(viewDS[0]).toFixed(2) != parseFloat(viewDS[3]).toFixed(2)) {
            createCustomAlertDeclaration("Грешна обща сума: Написано: " + parseFloat(viewDS[3]).toFixed(2) + ", изчислено: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong Total Amount: Entered: " + parseFloat(viewDS[3]).toFixed(2) + ", Calculated: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Please, make the needed corrections and try again.");
        return;
       }
	    if (viewDS[1] != viewDS[4]) {
            createCustomAlertDeclaration("Грешен брой редове: Написано " + viewDS[4] + ", изчислено " + viewDS[1] + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong number of rows: Entered: " + viewDS[4] + ", Calculated " + viewDS[1] + ".<br/>Please, make the needed corrections and try again.");
        return;
       }

        var message = "";
        var messageEN = "";
        message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("OCurr").value.toString() + " и " + viewDS[1] + " записа";
        messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("OCurr").value.toString() + " and " + viewDS[1] + " entries";

        message += ".  <br/><br/> " + messageEN + "";
        createCustomAlertOKZ(message, 94);
    }

    if (viewDS[0]) {
        document.getElementById(f).elements["outPutFOld"].value = document.getElementById("OUTPUTF").value;
        document.getElementById(f).elements["OUTPUTF"].value = base64Encode(viewDS[2]);
        document.getElementById(f).elements["AMOUNT"].value = viewDS[0];
        document.getElementById(f).elements["ALLROW"].value = viewDS[1];
        document.getElementById(f).elements["CURR"].value = document.getElementById("OCurr").value.toString();
        document.getElementById("outPutDec").value = 1;

    }
    else {
        createCustomAlertDeclaration("Има грешка! <br/> ERROR !");
        return;
    }

    try {
        var frm = document.getElementById(f);

        if (viewDS[6] > 0) {
            var isFreeDekl = document.getElementById("idisFreeOfDECL30K").value;
            if (isFreeDekl != 1) {
                var frmDECL30 = frm.elements["DECL30K"].value;
                var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
                var test1 = re.test(frmDECL30);
				

                if (frmDECL30.length < 5) {
                    if (trim(frmDECL30).length == 0) {
                        elemError(frm.elements["DECL30K"], "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП! <br/> Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!");
                        return false;
                    }
                    elemError(frm.elements["DECL30K"], "Моля, въведете поне 5 символа в полето за произход на паричните средства.<br/>Please, enter minimum 5 characters in the Origin of Funds field.");
                    return false;
                }
                else {
                    if (!test1) {
                        elemError(frm.elements["DECL30K"], " Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/> Incorrect symbol in field 'DECLARATION for money origin according'!");
                        return;
                    }

                }
            }
        }

        if (!FormalCheckOrder(f))
        { return false; }

        if (!Validate(f))
        { return false; }

        //8954
        if (!CheckDeclData(f))
        { return false; }
        //8954
        var fileInput = document.getElementById("FILENAME");

        createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("OCurr").value.toString() + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("OCurr").value.toString() + "", 93);

        if ($("div[id='id-js-continue']").length < 1) {
            $("<div id='id-js-continue'  class='invisible'><a href='javascript:;' class='js-continue'>OK</a></div>").appendTo('body'); //8954
        }

        $(document).off('click', '.js-continue').on('click', '.js-continue', function () {
            $("div[id='id-js-continue']").remove();
            ImportMPConfirmReTo(f, submitform);
        });
        showPopupZi(function () {
            $('.js-continue').click();
        });

    }
    catch (e) {
        createCustomAlertDeclaration(e + "<br/>" + e.description);
    }
}
//end 9720

//new salary ex cibank begin
function SignImportSalaryuCiBF(f, submitform) {

    removeError(f);
    removeError("enquiry-salary-table");

    if ($("div[id^='IdErr']").length > 0) { //8954
        $("div[id^='IdErr']").remove();
    }

    var strPacketInXML = "";
    var FL_EUR_BGN = document.getElementById("FL_EUR_BGN").value;
    var Rate = document.getElementById("Rate").value;
    var Currency = document.getElementById("Currency").value;
    var toCurrency = document.getElementById("toCurrency").value;

    if (document.getElementById("outPutDec").value == 1)
        document.getElementById('OUTPUTF').value = document.getElementById("outPutFOld").value;


    if (document.getElementById("NotValC").value != "") {
        createCustomAlertDeclaration("Непозволена сметка за изплащане на работни заплати. Повече информация можете да получите на тел. 0700 117 17.<br/>Unauthorised payroll account. For further information call 0700 117 17.");
        return;
    }
    if (document.getElementById("salIbs").value == "") {
        elemError(document.getElementById("salIbs"), "Няма избрана сметка!<br/>No selected account!");
        return;
    }
    if ("ActiveXObject" in window) {
        //if (typeof ActiveXObject != "undefined") {
        strPacketInXML = readFileMP("enquiry-salary-table");
        document.getElementById('OUTPUTF').value = strPacketInXML;
    }
    else {
        strPacketInXML = document.getElementById("OUTPUTF").value;
        if (strPacketInXML == "") {
            elemError(document.getElementById("FILE"), "Моля изберете файл!<br/>Please select a file!");
           return;
        }
    }

    if (document.getElementById("FILEMODEL").value == '198') {
        createCustomAlertDeclaration("Файлът  е с неразрешен формат.<br/>Invalid file format");
        return;
    }

	if(strPacketInXML.indexOf('OMP;DP;') == -1)
	{
		createCustomAlertDeclaration("За обработка на посоченият от Вас файл е необходимо да използване функцията Импорт на файл.<br/>For processing the file, indicated by you, please select Import From File function.");
        return;
	}
   var decl = "";
   if(typeof(document.getElementById(f).elements["DECL30K"]) != "undefined")
	   decl = document.getElementById(f).elements["DECL30K"].value;

    var sRetCheck = CheckFileMass(htmlEscape(document.getElementById("FILENAME").value), htmlEscape(document.getElementById("SALB").value), htmlEscape(document.getElementById("SalAc").value), htmlEscape(document.getElementById("ACC_S").value), htmlEscape(document.getElementById("ALLFILEMODEL").value), strPacketInXML, decl, 1);
   var viewDS = sRetCheck.toString().split("|");
    if (viewDS[7] != "") { //full file and error
	var strError =  viewDS[7].replace(/<tr>/g,' ').replace(/<\/tr>/g,'').replace(/<td>/g,' ').replace(/<\/td>/g,'').replace(/<\/br>/g,'');
		VP_SalaryError(document.getElementById("idMSID").value, document.getElementById("FILENAME").value + "|" + strError, "bg", "", "");
            createCustomAlertDeclaration("Във файла има грешки! " + viewDS[7] + " <br/> Поправете ги и опитайте отново!<br/>Списъкът с грешките може да се разгледа през меню Справки по заплати-Грешки при зареждане на файлове. <br/>Errors in the file! " + viewDS[7] + "<br/> Please, correct errors and try again!<br/> The error list can be  viewed through Payroll Reports-Files Upload Errors Menu.");
            return;
    }
    else {
      if (document.getElementById("ACC_S").value != viewDS[5]) {
           createCustomAlertDeclaration("Избраната сметка не съответства на сметката във файла.");
        return;
       }

        if (parseFloat(viewDS[0]).toFixed(2) != parseFloat(viewDS[3]).toFixed(2)) {
            createCustomAlertDeclaration("Грешна обща сума: Написано: " + parseFloat(viewDS[3]).toFixed(2) + ", изчислено: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong Total Amount: Entered: " + parseFloat(viewDS[3]).toFixed(2) + ", Calculated: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Please, make the needed corrections and try again.");
        return;
       }
	    if (viewDS[1] != viewDS[4]) {
            createCustomAlertDeclaration("Грешен брой редове: Написано " + viewDS[4] + ", изчислено " + viewDS[1] + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong number of rows: Entered: " + viewDS[4] + ", Calculated " + viewDS[1] + ".<br/>Please, make the needed corrections and try again.");
        return;
       }

        var message = "";
        var messageEN = "";

        if (FL_EUR_BGN == 1 && Currency == document.getElementById("SALB").value.toString().substring(0, 3)) {
            message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (viewDS[0] / Rate).toFixed(2) + " " + toCurrency + " и " + viewDS[1] + " записа";
            messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (viewDS[0] / Rate).toFixed(2) + " " + toCurrency + " and " + viewDS[1] + " entries";
        }
        else {
            message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " и " + viewDS[1] + " записа";
            messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " and " + viewDS[1] + " entries";
        }
        
        message += ".  <br/><br/> " + messageEN + "";
        createCustomAlertOKZ(message, 94);
    

    if (viewDS[0]) {
        document.getElementById(f).elements["outPutFOld"].value = document.getElementById("OUTPUTF").value;
        document.getElementById(f).elements["OUTPUTF"].value = base64Encode(viewDS[2]);
        document.getElementById(f).elements["AMOUNT"].value = viewDS[0];
        document.getElementById(f).elements["ALLROW"].value = viewDS[1];
        document.getElementById(f).elements["CURR"].value = document.getElementById("SALB").value.toString().substring(0, 3);
        document.getElementById("outPutDec").value = 1;

    }
    else {
        createCustomAlertDeclaration("Има грешка! <br/> ERROR !");
        return;
    }

    try {
        var frm = document.getElementById(f);

        if (viewDS[3] > 30000) {
            var isFreeDekl = document.getElementById("idisFreeOfDECL30K").value;
            if (isFreeDekl != 1) {
                frm.elements["AMOUNT2"].value = frm.elements["AMOUNT"].value;//10476
                frm.elements["CURR2"].value = frm.elements["CURR"].value;
				
                $("#DEC").removeClass("hidden");
                var frmDECL30 = frm.elements["DECL30K"].value;
                var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
                var test1 = re.test(frmDECL30);

                if (frmDECL30.length < 5) {
                    if (trim(frmDECL30).length == 0) {
                        elemError(frm.elements["DECL30K"], "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП! <br/> Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!");
                        return false;
                    }
                    elemError(frm.elements["DECL30K"], "Моля, въведете поне 5 символа в полето за произход на паричните средства.<br/>Please, enter minimum 5 characters in the Origin of Funds field.");
                    return false;
                }
                else {
                    if (!test1) {
                        elemError(frm.elements["DECL30K"], " Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/> Incorrect symbol in field 'DECLARATION for money origin according'!");
                        return;
                    }

                }
            }
        }
	else {
                $("#DEC").addClass("hidden");
        }

        if (!FormalCheckOrder(f))
        { return false; }

        if (!Validate(f))
        { return false; }

        //8954
        if (!CheckDeclData(f))
        { return false; }
        //8954
        var fileInput = document.getElementById("FILENAME");
	
        if (FL_EUR_BGN == 1 && Currency == document.getElementById("SALB").value.toString().substring(0, 3)) {
            createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (parseFloat(frm.elements["AMOUNT"].value) / Rate).toFixed(2) + " " + toCurrency + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " / " + (parseFloat(frm.elements["AMOUNT"].value) / Rate).toFixed(2) + " " + toCurrency + "", 93);
        }
        else {
            createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "", 93);
        }
        

        if ($("div[id='id-js-continue']").length < 1) {
            $("<div id='id-js-continue'  class='invisible'><a href='javascript:;' class='js-continue'>OK</a></div>").appendTo('body'); //8954
        }

        $(document).off('click', '.js-continue').on('click', '.js-continue', function () {
            $("div[id='id-js-continue']").remove();
			ImportSalaryConfirmReToF(f, submitform);
        });
        showPopupZi(function () {
            $('.js-continue').click();
        });

    }
    catch (e) {
        createCustomAlertDeclaration(e + "<br/>" + e.description);
    }
	}
}

function SignImportSalaryuCiB(f, submitform) {

    removeError(f);
    removeError("enquiry-salary-table");

    if ($("div[id^='IdErr']").length > 0) { //8954
        $("div[id^='IdErr']").remove();
    }

    var strPacketInXML = "";

    if (document.getElementById("outPutDec").value == 1)
        document.getElementById('OUTPUTF').value = document.getElementById("outPutFOld").value;


    if (document.getElementById("NotValC").value != "") {
        createCustomAlertDeclaration("Непозволена сметка за изплащане на работни заплати. Повече информация можете да получите на тел. 0700 117 17.<br/>Unauthorised payroll account. For further information call 0700 117 17.");
        return;
    }
    if (document.getElementById("salIbs").value == "") {
        elemError(document.getElementById("salIbs"), "Няма избрана сметка!<br/>No selected account!");
        return;
    }
    if ("ActiveXObject" in window) {
        //if (typeof ActiveXObject != "undefined") {
        strPacketInXML = readFileMP("enquiry-salary-table");
        document.getElementById('OUTPUTF').value = strPacketInXML;
    }
    else {
        strPacketInXML = document.getElementById("OUTPUTF").value;
        if (strPacketInXML == "") {
            elemError(document.getElementById("FILE"), "Моля изберете файл!<br/>Please select a file!");
           return;
        }
    }

	if(strPacketInXML.indexOf('OMP;DP;') == -1)
	{
		createCustomAlertDeclaration("За обработка на посоченият от Вас файл е необходимо да използване функцията Импорт на файл.<br/>For processing the file, indicated by you, please select Import From File function.");
        return;
	}

   var decl = "";
   if(typeof(document.getElementById(f).elements["DECL30K"]) != "undefined")
	   decl = document.getElementById(f).elements["DECL30K"].value;
   
    var sRetCheck = CheckFileMass(htmlEscape(document.getElementById("FILENAME").value), htmlEscape(document.getElementById("SALB").value), htmlEscape(document.getElementById("SalAc").value), htmlEscape(document.getElementById("ACC_S").value), htmlEscape(document.getElementById("ALLFILEMODEL").value), strPacketInXML, decl, 1);
   var viewDS = sRetCheck.toString().split("|");
    if (viewDS[7] != "") { //full file and error
	var strError =  viewDS[7].replace(/<tr>/g,' ').replace(/<\/tr>/g,'').replace(/<td>/g,' ').replace(/<\/td>/g,'').replace(/<\/br>/g,'');
		VP_SalaryError(document.getElementById("idMSID").value, document.getElementById("FILENAME").value + "|" + strError, "bg", "", "");
            createCustomAlertDeclaration("Във файла има грешки! " + viewDS[7] + " <br/> Поправете ги и опитайте отново!<br/>Списъкът с грешките може да се разгледа през меню Справки по заплати-Грешки при зареждане на файлове. <br/>Errors in the file! " + viewDS[7] + "<br/> Please, correct errors and try again!<br/> The error list can be  viewed through Payroll Reports-Files Upload Errors Menu.");
            return;
    }
    else {
      if (document.getElementById("ACC_S").value != viewDS[5]) {
            createCustomAlertDeclaration("Избраната сметка не съответства на сметката във файла.<br/> The chosen account does not match the one in the file.");
        return;
       }

        if (parseFloat(viewDS[0]).toFixed(2) != parseFloat(viewDS[3]).toFixed(2)) {
            createCustomAlertDeclaration("Грешна обща сума: Написано: " + parseFloat(viewDS[3]).toFixed(2) + ", изчислено: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong Total Amount: Entered: " + parseFloat(viewDS[3]).toFixed(2) + ", Calculated: " + parseFloat(viewDS[0]).toFixed(2) + ".<br/>Please, make the needed corrections and try again.");
        return;
       }
	    if (viewDS[1] != viewDS[4]) {
            createCustomAlertDeclaration("Грешен брой редове: Написано " + viewDS[4] + ", изчислено " + viewDS[1] + ".<br/>Направете необходимата корекция и опитайте отново.<br/>Wrong number of rows: Entered: " + viewDS[4] + ", Calculated " + viewDS[1] + ".<br/>Please, make the needed corrections and try again.");
        return;
       }

        var message = "";
        var messageEN = "";
        message += "Файл на обща сума: " + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " и " + viewDS[1] + " записа";
        messageEN += "File (total amount):" + viewDS[0] + " " + document.getElementById("SALB").value.toString().substring(0, 3) + " and " + viewDS[1] + " entries";

        message += ".  <br/><br/> " + messageEN + "";
        createCustomAlertOKZ(message, 94);
    

    if (viewDS[0]) {
        document.getElementById(f).elements["outPutFOld"].value = document.getElementById("OUTPUTF").value;
        document.getElementById(f).elements["OUTPUTF"].value = base64Encode(viewDS[2]);
        document.getElementById(f).elements["AMOUNT"].value = viewDS[0];
        document.getElementById(f).elements["ALLROW"].value = viewDS[1];
        document.getElementById(f).elements["CURR"].value = document.getElementById("SALB").value.toString().substring(0, 3);
        document.getElementById("outPutDec").value = 1;

    }
    else {
        createCustomAlertDeclaration("Има грешка! <br/> ERROR !");
        return;
    }

    try {
        var frm = document.getElementById(f);

        if (viewDS[6] > 0) {
            var isFreeDekl = document.getElementById("idisFreeOfDECL30K").value;
            if (isFreeDekl != 1) {
                var frmDECL30 = frm.elements["DECL30K"].value;
                var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
                var test1 = re.test(frmDECL30);

                if (frmDECL30.length < 5) {
                    if (trim(frmDECL30).length == 0) {
                        elemError(frm.elements["DECL30K"], "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП! <br/> Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!");
                        return false;
                    }
                    elemError(frm.elements["DECL30K"], "Моля, въведете поне 5 символа в полето за произход на паричните средства.<br/>Please, enter minimum 5 characters in the Origin of Funds field.");
                    return false;
                }
                else {
                    if (!test1) {
                        elemError(frm.elements["DECL30K"], " Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/> Incorrect symbol in field 'DECLARATION for money origin according'!");
                        return;
                    }

                }
            }
        }

        if (!FormalCheckOrder(f))
        { return false; }

        if (!Validate(f))
        { return false; }

        //8954
        if (!CheckDeclData(f))
        { return false; }
        //8954
        var fileInput = document.getElementById("FILENAME");
	

        createCustomAlertZ("Изберете ОК за изпращане към Банката на документ за сумата от " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "<br/>Chose OK to send to the Bank a document for the amount of " + frm.elements["AMOUNT"].value + " " + document.getElementById("SALB").value.toString().substring(0, 3) + "", 93);

        if ($("div[id='id-js-continue']").length < 1) {
            $("<div id='id-js-continue'  class='invisible'><a href='javascript:;' class='js-continue'>OK</a></div>").appendTo('body'); //8954
        }

        $(document).off('click', '.js-continue').on('click', '.js-continue', function () {
            $("div[id='id-js-continue']").remove();
			ImportSalaryConfirmReTo(f, submitform);
        });
        showPopupZi(function () {
            $('.js-continue').click();
        });

    }
    catch (e) {
        createCustomAlertDeclaration(e + "<br/>" + e.description);
    }
	}
}

//new salary ex cibank end


//9485
function SignImportImportMass(f, fAc, submitform) {
    var loadFile;
    var fileData = new File();
	var isFreeD = $('#isFreeDecl').val();
	

    var F = document.getElementById(f);
    var FAc = document.getElementById(fAc);

    var chSend = F.elements["send"].checked;

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка.<br/>Please, choose account.";
        fieldErr = FAc.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }

    /* За годишното приключване 6785_2015 8975*/
    if (F.elements["ACC_S"].value.length == 10) {
        if (trim(document.getElementById("frmMain").elements["Text312"].value) != "") {
            createCustomAlertDeclaration(document.getElementById("frmMain").elements["Text312"].value);
            return false;
        }
    }
    /*За годишното приключване*/

    if (F.elements["FILENAME"].value == "") {
        txtErr = "Моля, изберете файл.<br/>Please, choose file.";
        fieldErr = F.elements["FILENAME"];
        elemError(fieldErr, txtErr);
        return false;
    }

    var strFileName = document.getElementById("FILENAME").value;

    var reFileName = /^[ А-Яа-яA-Za-z0-9\"\, '\/\.;\:\=@%^&#\n\r\-_*\\\(\)\|\+\?\!)\(]{0,255}$/g;
    var tFileName = reFileName.test(strFileName);

    if (!tFileName) {
        txtErr = "Невалидно име на файл! Името на файла не трябва да съдържа специални символи и разширението му трябва да е .txt или .xml .<br/><br/>Invalid file name! The file name should not contain special characters and its extension should be either .txt or .xml .";
        fieldErr = document.getElementById("FILENAME");
        elemError(fieldErr, txtErr);
        return false;
    }

    $(".loading").removeAttr("style"); //включва часовника
    var chkDecl = F.elements['chkDecl'].value; //8954
	
    loadFile = CheckBrowserMass(f, fileData, ""); //readFile
    F.elements["send"].checked = chSend; //важно!!!
    F.elements["chkDecl"].checked = chkDecl; //важно!!! //9144

var flagDecl = $('#flagDecl').val();

    if (fileData.Error != "") {
        createCustomAlertDeclaration(fileData.Error);
        return false;
    }

    var errorFile = loadFile.filter(function (e) {  //грешни редове
        return (e.Error != "" || e.Warn != "");
    });

    var errorStr = errorFile.map(function (e) { //грешни редове за таблица
        return e.GErrorRow();
    }).join('');

    var errorXML = errorFile.map(function (e) { //грешни редове XML
        return e.GErrorRowO();
    }).join('');

    errorFile = null;

    var correctXMLStr = loadFile.filter(function (e) {
        return e.Error == "";
    }).map(function (e) {
        return e.GXmlRow();
    }).join('');

    loadFile = null; //???

    //8954 begin
   // if (chkDecl == 1) {
        //alert('chkDecl: ' + chkDecl);
        var correctXML = $.parseXML("<P>" + correctXMLStr + "</P>");
        var chkDecl30K = $(correctXML).find("DECL30K").length;
		
		if(isFreeD != 1 && flagDecl == 1 && (F.elements["DECL30K1"].value == "" || !$("#chbDeclData").is(':checked')))
		{
		var txtErr = "Моля, попълнете Декларация за произход на паричните средства – Данни за декларатора.<br/>Please, fill Declaration on origin of funds – Declarant’s data.";
        
		if (flagDecl == 1 && F.elements["DECL30K1"].value == "") {
			elemError(F.elements["DECL30K1"], txtErr);
        }
		else if(flagDecl == 1 && !$("#chbDeclData").is(':checked'))
		{
			 var fieldErr = F.elements["chbDeclData"];
            elemErrorSend(fieldErr, txtErr);
		}
		 if ($('.file-upload input[type="text"]').val().length > 0) {
                $('.file-upload input[type="text"]').parents('.file-upload').addClass('filled');
            }

            //if ($(".loading") && $(".loading").length > 0)
            $(".loading").attr("style", "display: none;"); //изключва часовника
		
		//F.elements["chkDecl"].value = 1;
            return false;
    }
//}
    //8954 end

    $('#Panel1 .tabs').attr("style", "display: none;"); //скрива полетата

    var errorXMLStr = FormImport(f, fileData, errorXML, ""); //form import order
    errorXML = null; //???

    $("#loadFile").removeAttr("style");//8975
    if (errorStr != "") {

        $("#ErrLoad").removeAttr("style");
        $('#Panel1 #ErrLoad table').append('<tbody>' + errorStr + '<tbody>');
        errorStr = null;

        var errorTable = cDataTable($('.error-table'), "", false, false, true);
    }
    else if (fileData.Count > 0) {
        $("#SuccessLoad").removeAttr("style");
    }
	if(F.elements["CHSPCH"].value == "1")
	{
		 $("#specialChar").removeAttr("style");
	}

    $("#loadFile #count").append(fileData.Count);   //обработени записи
    $("#loadFile #countall").append(fileData.CountAll);
    $("#loadFile #sum").append(fileData.Sum);

    $(".loading").attr("style", "display: none;"); //изключва часовника

    if (correctXMLStr == "") {
        $('#ContinueImport').remove();
        return false;
    }

    //изпълнява се при натискане на бутон Продължи
    $(document).off('click', '.js-confirm-import').on('click', '.js-confirm-import', function () {
        var submfrmImp = document.getElementById(submitform);
        submfrmImp.elements["COMMAND"].value = "IMPORTEXEC";//"PACKSIGNSTOR";//IMPORTF
        submfrmImp.elements["SEND"].value = "Off";
        if (F.elements["send"].checked)
            submfrmImp.elements["SEND"].value = "on";

        xmltoSEND = "<Packet/>";
        ElemGuid = document.getElementById("idPacket");

        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">" + correctXMLStr + "<SubPacket>" + errorXMLStr + "</SubPacket></Packet>";

        correctXMLStr = null;
        errorXMLStr = null;


        createCustomAlertDocumentCount("Изберете ОК за изпращане към банката.<br/>Choose OK to send to the Bank.", function () {


            SerialNumber = document.getElementById("idMSERIALNUMBER").value;
            xmltoSEND = CRLF(xmltoSEND);

            Base64Sign = SignContent(xmltoSEND, submfrmImp.elements["ENCODING"], SerialNumber);
            if (document.getElementById("errMessSign").value != "") {
                createCustomAlertJsOK(htmlEscape(document.getElementById("errMessSign").value), 'js-cont-err', function () {
                    document.getElementById("errMessSign").value = "";
                    if (null == Base64Sign) {
                        createCustomAlertHeaderAndTxt("Възникна грешка / Error", "Невалиден подпис! <br/> Your sign is not valid!");
                        return false;
                    }

                    return false;

                });
            }
            else {
                if (null == Base64Sign) {
                    createCustomAlertHeaderAndTxt("Възникна грешка / Error", "Невалиден подпис! <br/> Your sign is not valid!");

                    return false;
                }

                Base64Sign = Base64Sign.replace(/\r\n/gi, "");
                submfrmImp.elements["BASE64SIGN"].value = Base64Sign;


                submfrmImp.elements["BASE64XML"].value = base64Encode(xmltoSEND);


                BASE64XMLtoSEND = null;
                xmltoSEND = null;


                breadcrumbs();

                idAJAXResult = "Panel1";
                document.getElementById("Panel1").innerHTML = strWait;

                sbody = ObtainBody1(submitform);
                SendPostRequest1("t.aspx", sbody);

                sbody = null;


            }




        });

    });
    return true;
}
function SignImportImportMassF(f, fAc, submitform) {

     var loadFile;
    var fileData = new File();
	var isFreeD = $('#isFreeDecl').val();

    var F = document.getElementById(f);
    var FAc = document.getElementById(fAc);

    var chSend = F.elements["send"].checked;

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка.<br/>Please, choose account.";
        fieldErr = FAc.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }

    /* За годишното приключване 6785_2015 8975*/
    if (F.elements["ACC_S"].value.length == 10) {
        if (trim(document.getElementById("frmMain").elements["Text312"].value) != "") {
            createCustomAlertDeclaration(document.getElementById("frmMain").elements["Text312"].value);
            return false;
        }
    }
    /*За годишното приключване*/

    if (F.elements["FILENAME"].value == "") {
        txtErr = "Моля, изберете файл.<br/>Please, choose file.";
        fieldErr = F.elements["FILENAME"];
        elemError(fieldErr, txtErr);
        return false;
    }

    var strFileName = document.getElementById("FILENAME").value;

    var reFileName = /^[ А-Яа-яA-Za-z0-9\"\, '\/\.;\:\=@%^&#\n\r\-_*\\\(\)\|\+\?\!)\(]{0,255}$/g;
    var tFileName = reFileName.test(strFileName);

    if (!tFileName) {
        txtErr = "Невалидно име на файл! Името на файла не трябва да съдържа специални символи и разширението му трябва да е .txt или .xml .<br/><br/>Invalid file name! The file name should not contain special characters and its extension should be either .txt or .xml .";
        fieldErr = document.getElementById("FILENAME");
        elemError(fieldErr, txtErr);
        return false;
    }

    $(".loading").removeAttr("style"); //включва часовника
    var chkDecl = F.elements['chkDecl'].value; //8954
	
    loadFile = CheckBrowserMass(f, fileData, ".F"); //readFile
    F.elements["send"].checked = chSend; //важно!!!
    F.elements["chkDecl"].checked = chkDecl; //важно!!! //9144

		var flagDecl = $('#flagDecl').val();
		
    if (fileData.Error != "") {
        createCustomAlertDeclaration(fileData.Error);
        return false;
    }

    var errorFile = loadFile.filter(function (e) {  //грешни редове
        return (e.Error != "" || e.Warn != "");
    });

    var errorStr = errorFile.map(function (e) { //грешни редове за таблица
        return e.GErrorRow();
    }).join('');

    var errorXML = errorFile.map(function (e) { //грешни редове XML
        return e.GErrorRowO();
    }).join('');

    errorFile = null;

    var correctXMLStr = loadFile.filter(function (e) {
        return e.Error == "";
    }).map(function (e) {
        return e.GXmlRow();
    }).join('');

    loadFile = null; //???

    //8954 begin
   // if (chkDecl == 1) {
        //alert('chkDecl: ' + chkDecl);
        var correctXML = $.parseXML("<P>" + correctXMLStr + "</P>");
        var chkDecl30K = $(correctXML).find("DECL30K").length;
	F.elements["SUMFILE"].value = fileData.Sum;
        F.elements["AMOUNT2"].value = F.elements["SUMFILE"].value;
	F.elements["CURR2"].value = F.elements["CURR"].value;
		
		if(isFreeD != 1 && flagDecl == 1 )
		{
			$('#DEC').removeClass("hidden"); //20191223
		}
		else
		{
			$('#DEC').addClass("hidden"); //20191223
				F.elements["DECL30K1"].value == "";
		}
		if(isFreeD != 1 && flagDecl == 1 && (F.elements["DECL30K1"].value == "" || !$("#chbDeclData").is(':checked')))
		{
		var txtErr = "Моля, попълнете Декларация за произход на паричните средства – Данни за декларатора.<br/>Please, fill Declaration on origin of funds – Declarant’s data.";
        
		if (flagDecl == 1 && F.elements["DECL30K1"].value == "") {
			elemError(F.elements["DECL30K1"], txtErr);
        }
		else if(flagDecl == 1 && !$("#chbDeclData").is(':checked'))
		{
			 var fieldErr = F.elements["chbDeclData"];
            elemErrorSend(fieldErr, txtErr);
		}
		 if ($('.file-upload input[type="text"]').val().length > 0) {
                $('.file-upload input[type="text"]').parents('.file-upload').addClass('filled');
            }

            //if ($(".loading") && $(".loading").length > 0)
            $(".loading").attr("style", "display: none;"); //изключва часовника
		
		//F.elements["chkDecl"].value = 1;
            return false;
    }
//}
    //8954 end

    $('#Panel1 .tabs').attr("style", "display: none;"); //скрива полетата

    var errorXMLStr = FormImport(f, fileData, errorXML, ".F"); //form import order
    errorXML = null; //???

    $("#loadFile").removeAttr("style");//8975
    if (errorStr != "") {

        $("#ErrLoad").removeAttr("style");
        $('#Panel1 #ErrLoad table').append('<tbody>' + errorStr + '<tbody>');
        errorStr = null;

        var errorTable = cDataTable($('.error-table'), "", false, false, true);
    }
    else if (fileData.Count > 0) {
        $("#SuccessLoad").removeAttr("style");
    }
	
	
	if(F.elements["CHSPCH"].value == "1")
	{
		 $("#specialChar").removeAttr("style");
	}

    $("#loadFile #count").append(fileData.Count);   //обработени записи
    $("#loadFile #countall").append(fileData.CountAll);
    $("#loadFile #sum").append(fileData.Sum);

    $(".loading").attr("style", "display: none;"); //изключва часовника

    if (correctXMLStr == "") {
        $('#ContinueImport').remove();
        return false;
    }



    //изпълнява се при натискане на бутон Продължи
    $(document).off('click', '.js-confirm-import').on('click', '.js-confirm-import', function () {
        var submfrmImp = document.getElementById(submitform);
        submfrmImp.elements["COMMAND"].value = "IMEX";//"IMPORTEXEC";//"PACKSIGNSTOR";
        submfrmImp.elements["SEND"].value = "Off";
        if (F.elements["send"].checked)
            submfrmImp.elements["SEND"].value = "on";

        xmltoSEND = "<Packet/>";
        ElemGuid = document.getElementById("idPacket");
        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">" + correctXMLStr + "<SubPacket>" + errorXMLStr + "</SubPacket></Packet>";

        correctXMLStr = null;
        errorXMLStr = null;


        createCustomAlertDocumentCount("Изберете ОК за изпращане към банката.<br/>Choose OK to send to the Bank.", function () {

            try {
                SerialNumber = document.getElementById("idMSERIALNUMBER").value;
                xmltoSEND = CRLF(xmltoSEND);

                submfrmImp.elements["BASE64SIGN"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["BASE64XML"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["ENCODING"].value = "Windows-1251";

                BASE64XMLtoSEND = null;
                xmltoSEND = null;


                breadcrumbs();

                idAJAXResult = "Panel1";
                document.getElementById("Panel1").innerHTML = strWait;

                sbody = ObtainBody1(submitform);
                SendPostRequest1("t.aspx", sbody);

                sbody = null;
                //}

            }
            catch (e) {
                createCustomAlertHeaderAndTxt("Възникна грешка / Error", e + " <br/> " + e.description);
            }

        });

    });
    return true;
}

// FOB_Budjet_MASS_PAYMENTS_FINAL Tisho
function SignImportImportBudgetMass(f, fAc, submitform) {
    var loadFile;
    var fileData = new File();
    var isFreeD = $('#isFreeDecl').val();

    var F = document.getElementById(f);
    var FAc = document.getElementById(fAc);
    var chkDecl = F.elements['chkDecl'].value; //8954


    var chSend = F.elements["send"].checked;

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка.<br/>Please, choose account.";
        fieldErr = FAc.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }

    /* За годишното приключване 6785_2015 8975*/
    if (F.elements["ACC_S"].value.length == 10) {
        if (trim(document.getElementById("frmMain").elements["Text312"].value) != "") {
            createCustomAlertDeclaration(document.getElementById("frmMain").elements["Text312"].value);
            return false;
        }
    }
    /*За годишното приключване*/

    if (F.elements["FILENAME"].value == "") {
        txtErr = "Моля, изберете файл.<br/>Please, choose file.";
        fieldErr = F.elements["FILENAME"];
        elemError(fieldErr, txtErr);
        return false;
    }

    var strFileName = document.getElementById("FILENAME").value;

    var reFileName = /^[ А-Яа-яA-Za-z0-9\"\, '\/\.;\:\=@%^&#\n\r\-_*\\\(\)\|\+\?\!)\(]{0,255}$/g;
    var tFileName = reFileName.test(strFileName);

    if (!tFileName) {
        txtErr = "Невалиден файлов формат - разширението в името на заредения файл не е .bgi. Коригирайте и заредете файла отново.<br/><br/>Invalid file format - the file extension is not .bgi. Please, correct the file and reupload it.";
        fieldErr = document.getElementById("FILENAME");
        elemError(fieldErr, txtErr);
        return false;
    }



    $(".loading").removeAttr("style"); //включва часовника

    // 15384
    var iFileNameLength = strFileName.length;
    var strFileNameExt = strFileName.substr(iFileNameLength - 3).toLowerCase();
    switch (strFileNameExt) {
        case "int":
        case "bgi":
            loadFile = readFileImportBudgetMassOth(f, fileData, ".B");
            break;
        case "xml":
            loadFile = readFileImportSEPA(f, fileData);
            break;
        default:
            fileData.SError("Невалидно име на файл! Името на файла не трябва да съдържа специални символи и разширението му трябва да е .bgi, .int или .xml .<br/><br/>Invalid file name! The file name should not contain special characters and its extension should be either .bgi, .int or .xml .");
            break;
    }
  
    //var strFile = document.getElementById('OUTPUTFIMP').value;
    //alert(strFile);


    F.elements["send"].checked = chSend; //важно!!!
    F.elements["chkDecl"].value = chkDecl; //важно!!! //9144

    var flagDecl = $('#flagDecl').val();

    if (isFreeD != 1 && flagDecl == 1) {
        $('#DEC').removeClass("hidden"); //20191223
        //F.elements["AMOUNT2"].value = F.elements["SUMFILE"].value;
        //F.elements["CURR2"].value = F.elements["CURR"].value;
    }
    else {
        $('#DEC').addClass("hidden"); //20191223
    }

    if (fileData.Error != "") {
        createCustomAlertDeclaration(fileData.Error);
        return false;
    }

    var errorFile = loadFile.filter(function (e) {  //грешни редове
        return (e.Error != "" || e.Warn != "");
    });

    var errorStr = errorFile.map(function (e) { //грешни редове за таблица
        return e.GErrorRow();
    }).join('');

    var errorXML = errorFile.map(function (e) { //грешни редове XML
        return e.GErrorRowO();
    }).join('');

    errorFile = null;

    var correctXMLStr = loadFile.filter(function (e) {
        return e.Error == "";
    }).map(function (e) {
        return e.GXmlRow();
    }).join('');

    loadFile = null; //???

    //8954 begin
    // if (chkDecl == 1) {
    //alert('chkDecl: ' + chkDecl);
    var correctXML = $.parseXML("<P>" + correctXMLStr + "</P>");
    var chkDecl30K = $(correctXML).find("DECL30K").length;
    F.elements["SUMFILE"].value = fileData.Sum;


    if (isFreeD != 1 && flagDecl == 1) {
        F.elements["AMOUNT2"].value = F.elements["SUMFILE"].value;
        F.elements["CURR2"].value = F.elements["CURR"].value;
    }


    if (isFreeD != 1 && flagDecl == 1 && (F.elements["DECL30K1"].value == "" || !$("#chbDeclData").is(':checked'))) {
        var txtErr = "Моля, попълнете Декларация за произход на паричните средства – Данни за декларатора.<br/>Please, fill Declaration on origin of funds – Declarant’s data.";

        if (flagDecl == 1 && F.elements["DECL30K1"].value == "") {
            elemError(F.elements["DECL30K1"], txtErr);
            $(".loading").attr("style", "display: none;"); //изключва часовника

            return false;
        }
        else if (flagDecl == 1 && chkDecl != 0 && !$("#chbDeclData").is(':checked')) {
            var fieldErr = F.elements["chbDeclData"];
            elemErrorSend(fieldErr, txtErr);
            $(".loading").attr("style", "display: none;"); //изключва часовника

            return false;
        }
        if ($('.file-upload input[type="text"]').val().length > 0) {
            $('.file-upload input[type="text"]').parents('.file-upload').addClass('filled');
        }

    }
    //8954 end

    $('#Panel1 .tabs').attr("style", "display: none;"); //скрива полетата

    var errorXMLStr = FormImport(f, fileData, errorXML, ".P"); //form import order
    errorXML = null; //???

    $("#loadFile").removeAttr("style");//8975
    if (errorStr != "") {

        $("#ErrLoad").removeAttr("style");
        $('#Panel1 #ErrLoad table').append('<tbody>' + errorStr + '<tbody>');
        errorStr = null;

        var errorTable = cDataTable($('.error-table'), "", false, false, true);
    }
    else if (fileData.Count > 0) {
        $("#SuccessLoad").removeAttr("style");
    }


    if (F.elements["CHSPCH"].value == "1") {
        $("#specialChar").removeAttr("style");
    }

    //14858
    if (F.elements["CHFLD20"].value == "1") {
        $("#specialFields").removeAttr("style");
    }

    $("#loadFile #count").append(fileData.Count);   //обработени записи
    $("#loadFile #countall").append(fileData.CountAll);
    $("#loadFile #sum").append(fileData.Sum);

    $(".loading").attr("style", "display: none;"); //изключва часовника

    if (correctXMLStr == "") {
        $('#ContinueImport').remove();
        return false;
    }



    //изпълнява се при натискане на бутон Продължи
    $(document).off('click', '.js-confirm-import').on('click', '.js-confirm-import', function () {
        var submfrmImp = document.getElementById(submitform);
        submfrmImp.elements["COMMAND"].value = "IM1"; //"IMEX"; //20200122
        submfrmImp.elements["SEND"].value = "Off";
        if (F.elements["send"].checked)
            submfrmImp.elements["SEND"].value = "on";

        xmltoSEND = "<Packet/>";
        ElemGuid = document.getElementById("idPacket");
        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">" + correctXMLStr + "<SubPacket>" + errorXMLStr + "</SubPacket></Packet>";

        correctXMLStr = null;
        errorXMLStr = null;


        createCustomAlertDocumentCount("Изберете ОК за изпращане към банката.<br/>Choose OK to send to the Bank.", function () {

            try {
                SerialNumber = document.getElementById("idMSERIALNUMBER").value;
                xmltoSEND = CRLF(xmltoSEND);

                submfrmImp.elements["BASE64SIGN"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["BASE64XML"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["ENCODING"].value = "Windows-1251";

                BASE64XMLtoSEND = null;
                xmltoSEND = null;


                breadcrumbs();

                idAJAXResult = "Panel1";
                document.getElementById("Panel1").innerHTML = strWait;

                sbody = ObtainBody1(submitform);
                SendPostRequest1("D.aspx", sbody);// SendPostRequest1("t.aspx", sbody); //20200122

                sbody = null;
                //}

            }
            catch (e) {
                createCustomAlertHeaderAndTxt("Възникна грешка / Error", e + " <br/> " + e.description);
            }

        });

    });
    return true;
}

//20200122
function SignImportImportMassP(f, fAc, submitform) {
	
    var loadFile;
    var fileData = new File();
    var isFreeD = $('#isFreeDecl').val();
	
    var F = document.getElementById(f);
    var FAc = document.getElementById(fAc);
	var chkDecl = F.elements['chkDecl'].value; //8954
	
	
	var chSend = F.elements["send"].checked;

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка.<br/>Please, choose account.";
        fieldErr = FAc.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }

    /* За годишното приключване 6785_2015 8975*/
    if (F.elements["ACC_S"].value.length == 10) {
        if (trim(document.getElementById("frmMain").elements["Text312"].value) != "") {
            createCustomAlertDeclaration(document.getElementById("frmMain").elements["Text312"].value);
            return false;
        }
    }
    /*За годишното приключване*/

    if (F.elements["FILENAME"].value == "") {
        txtErr = "Моля, изберете файл.<br/>Please, choose file.";
        fieldErr = F.elements["FILENAME"];
        elemError(fieldErr, txtErr);
        return false;
    }

    var strFileName = document.getElementById("FILENAME").value;

    var reFileName = /^[ А-Яа-яA-Za-z0-9\"\, '\/\.;\:\=@%^&#\n\r\-_*\\\(\)\|\+\?\!)\(]{0,255}$/g;
    var tFileName = reFileName.test(strFileName);

    if (!tFileName) {
        txtErr = "Невалидно име на файл! Името на файла не трябва да съдържа специални символи и разширението му трябва да е .txt или .xml .<br/><br/>Invalid file name! The file name should not contain special characters and its extension should be either .txt or .xml .";
        fieldErr = document.getElementById("FILENAME");
        elemError(fieldErr, txtErr);
        return false;
    }
	


    $(".loading").removeAttr("style"); //включва часовника
   
    //14858
    var OrdName = F.elements['ORDNAME'].value;
    switch (OrdName) {
        case "IMPORT.B":
        case "IBAN313.B":
            loadFile = CheckBrowserMass(f, fileData, ".B");
            break;
        default:
            loadFile = CheckBrowserMass(f, fileData, ".P"); //readFile //20200122
            break;
    }

    F.elements["send"].checked = chSend; //важно!!!
    F.elements["chkDecl"].value = chkDecl; //важно!!! //9144

    var flagDecl = $('#flagDecl').val();
	
	if (isFreeD != 1  && flagDecl == 1 ) {
        $('#DEC').removeClass("hidden"); //20191223
		//F.elements["AMOUNT2"].value = F.elements["SUMFILE"].value;
		//F.elements["CURR2"].value = F.elements["CURR"].value;
    }
    else {
        $('#DEC').addClass("hidden"); //20191223
    }
	
    if (fileData.Error != "") {
        createCustomAlertDeclaration(fileData.Error);
        return false;
    }

    var errorFile = loadFile.filter(function (e) {  //грешни редове
        return (e.Error != "" || e.Warn != "");
    });

    var errorStr = errorFile.map(function (e) { //грешни редове за таблица
        return e.GErrorRow();
    }).join('');

    var errorXML = errorFile.map(function (e) { //грешни редове XML
        return e.GErrorRowO();
    }).join('');

    errorFile = null;

    var correctXMLStr = loadFile.filter(function (e) {
        return e.Error == "";
    }).map(function (e) {
        return e.GXmlRow();
    }).join('');

    loadFile = null; //???

    //8954 begin
    // if (chkDecl == 1) {
    //alert('chkDecl: ' + chkDecl);
    var correctXML = $.parseXML("<P>" + correctXMLStr + "</P>");
    var chkDecl30K = $(correctXML).find("DECL30K").length;
    F.elements["SUMFILE"].value = fileData.Sum;
    
	
		if (isFreeD != 1 && flagDecl == 1) {
		F.elements["AMOUNT2"].value = F.elements["SUMFILE"].value;
		F.elements["CURR2"].value = F.elements["CURR"].value;
		}

    
    if (isFreeD != 1 && flagDecl == 1  && (F.elements["DECL30K1"].value == "" || !$("#chbDeclData").is(':checked'))) {
        var txtErr = "Моля, попълнете Декларация за произход на паричните средства – Данни за декларатора.<br/>Please, fill Declaration on origin of funds – Declarant’s data.";

        if (flagDecl == 1 && F.elements["DECL30K1"].value == "") {
            elemError(F.elements["DECL30K1"], txtErr);
			$(".loading").attr("style", "display: none;"); //изключва часовника

			return false;
        }
        else if (flagDecl == 1 && chkDecl !=0 && !$("#chbDeclData").is(':checked')) {
            var fieldErr = F.elements["chbDeclData"];
            elemErrorSend(fieldErr, txtErr);
			$(".loading").attr("style", "display: none;"); //изключва часовника
       
			return false;
        }
        if ($('.file-upload input[type="text"]').val().length > 0) {
            $('.file-upload input[type="text"]').parents('.file-upload').addClass('filled');			
        }

    }
    //8954 end

    $('#Panel1 .tabs').attr("style", "display: none;"); //скрива полетата

    var errorXMLStr = FormImport(f, fileData, errorXML, ".P"); //form import order
    errorXML = null; //???

    $("#loadFile").removeAttr("style");//8975
    if (errorStr != "") {

        $("#ErrLoad").removeAttr("style");
        $('#Panel1 #ErrLoad table').append('<tbody>' + errorStr + '<tbody>');
        errorStr = null;

        var errorTable = cDataTable($('.error-table'), "", false, false, true);
    }
    else if (fileData.Count > 0) {
        $("#SuccessLoad").removeAttr("style");
    }


    if (F.elements["CHSPCH"].value == "1") {
        $("#specialChar").removeAttr("style");
    }

    //14858
    if (F.elements["CHFLD20"].value == "1") {
        $("#specialFields").removeAttr("style");
    }

    $("#loadFile #count").append(fileData.Count);   //обработени записи
    $("#loadFile #countall").append(fileData.CountAll);
    $("#loadFile #sum").append(fileData.Sum);

    $(".loading").attr("style", "display: none;"); //изключва часовника

    if (correctXMLStr == "") {
        $('#ContinueImport').remove();
        return false;
    }



    //изпълнява се при натискане на бутон Продължи
    $(document).off('click', '.js-confirm-import').on('click', '.js-confirm-import', function () {
        var submfrmImp = document.getElementById(submitform);
        submfrmImp.elements["COMMAND"].value = "IM1"; //"IMEX"; //20200122
        submfrmImp.elements["SEND"].value = "Off";
        if (F.elements["send"].checked)
            submfrmImp.elements["SEND"].value = "on";

        xmltoSEND = "<Packet/>";
        ElemGuid = document.getElementById("idPacket");
        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">" + correctXMLStr + "<SubPacket>" + errorXMLStr + "</SubPacket></Packet>";

        correctXMLStr = null;
        errorXMLStr = null;


        createCustomAlertDocumentCount("Изберете ОК за изпращане към банката.<br/>Choose OK to send to the Bank.", function () {

            try {
                SerialNumber = document.getElementById("idMSERIALNUMBER").value;
                xmltoSEND = CRLF(xmltoSEND);

                submfrmImp.elements["BASE64SIGN"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["BASE64XML"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["ENCODING"].value = "Windows-1251";

                BASE64XMLtoSEND = null;
                xmltoSEND = null;


                breadcrumbs();

                idAJAXResult = "Panel1";
                document.getElementById("Panel1").innerHTML = strWait;

                sbody = ObtainBody1(submitform);
                SendPostRequest1("D.aspx", sbody);// SendPostRequest1("t.aspx", sbody); //20200122

                sbody = null;
                //}

            }
            catch (e) {
                createCustomAlertHeaderAndTxt("Възникна грешка / Error", e + " <br/> " + e.description);
            }

        });

    });
    return true;
}


function ImportSalaryConfirmReToF(f, submitform) {
    var submfrm = document.getElementById(submitform);
    var frm = document.getElementById(f);

    submfrm.elements["COMMAND"].value = "IMPORTFF";

    submfrm.elements["SEND"].value = "Off";
    if (frm.elements["send"].checked)
        submfrm.elements["SEND"].value = "on";

    var xmltoSEND = "<Packet/>";
    var ElemGuid = frm.elements["id"];
    xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
    ElemGuid.value = NextGuid(ElemGuid.value);
    sxmlnull = MakeXML(f)
    if ("" == sxmlnull)
        return false;

    xmltoSEND += sxmlnull;
    xmltoSEND += "</Packet>";
    var SerialNumber = document.getElementById("idMSERIALNUMBER").value;
    xmltoSEND = CRLF(xmltoSEND);

	var Base64Sign = base64Encode(xmltoSEND);
    submfrm.elements["BASE64SIGN"].value = Base64Sign;
    submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
	submfrm.elements["ENCODING"].value = "Windows-1251";
    BASE64XMLtoSEND = null;
    xmltoSEND = null;

    breadcrumbs();

    var sbody = ObtainBody(submitform);
    document.getElementById("Panel1").innerHTML = strWait;
    idAJAXResult = "Panel1";

    SendPostRequest("t.aspx", sbody);
}
//9720 begin
function ImportMPConfirmReToF(f, submitform) { //9720
    var submfrm = document.getElementById(submitform);
    var frm = document.getElementById(f);

    submfrm.elements["COMMAND"].value = "IMPORTMPF";

    submfrm.elements["SEND"].value = "Off";
    if (frm.elements["send"].checked)
        submfrm.elements["SEND"].value = "on";

    var xmltoSEND = "<Packet/>";
    var ElemGuid = frm.elements["id"];
    xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
    ElemGuid.value = NextGuid(ElemGuid.value);
    sxmlnull = MakeXML(f)
    if ("" == sxmlnull)
        return false;

    xmltoSEND += sxmlnull;
    xmltoSEND += "</Packet>";
    var SerialNumber = document.getElementById("idMSERIALNUMBER").value;
    xmltoSEND = CRLF(xmltoSEND);
 
	var Base64Sign = base64Encode(xmltoSEND);
    submfrm.elements["BASE64SIGN"].value = Base64Sign;
    submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
	submfrm.elements["ENCODING"].value = "Windows-1251";
    BASE64XMLtoSEND = null;
    xmltoSEND = null;

    breadcrumbs();

    var sbody = ObtainBody(submitform);
    document.getElementById("Panel1").innerHTML = strWait;
    idAJAXResult = "Panel1";

    SendPostRequest("t.aspx", sbody);
}

function ImportMPConfirmReTo(f, submitform) { //9720
    var submfrm = document.getElementById(submitform);
    var frm = document.getElementById(f);

    submfrm.elements["COMMAND"].value = "IMPORTMP";

    submfrm.elements["SEND"].value = "Off";
    if (frm.elements["send"].checked)
        submfrm.elements["SEND"].value = "on";

    var xmltoSEND = "<Packet/>";
    var ElemGuid = frm.elements["id"];
    xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
    ElemGuid.value = NextGuid(ElemGuid.value);
    sxmlnull = MakeXML(f)
    if ("" == sxmlnull)
        return false;

    xmltoSEND += sxmlnull;
    xmltoSEND += "</Packet>";
    var SerialNumber = document.getElementById("idMSERIALNUMBER").value;
    xmltoSEND = CRLF(xmltoSEND);
var Base64Sign = SignContent(xmltoSEND, submfrm.elements["ENCODING"], SerialNumber);

    if (null == Base64Sign) {
        createCustomAlertDeclaration("Невалиден подпис!<br/>Your sign is not valid!");
        return false;
    }
	
    Base64Sign = Base64Sign.replace(/\r\n/gi, "");
	
    submfrm.elements["BASE64SIGN"].value = Base64Sign;
    submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
	//submfrm.elements["ENCODING"].value = "Windows-1251";
    BASE64XMLtoSEND = null;
    xmltoSEND = null;

    breadcrumbs();

    var sbody = ObtainBody(submitform);
    document.getElementById("Panel1").innerHTML = strWait;
    idAJAXResult = "Panel1";

    SendPostRequest("t.aspx", sbody);
}
//9720 end

function LoadReadFileSalary(idForm) {
	
	 if (!("ActiveXObject" in window)) {
        strPacketInXML = readFileSalary(idForm);
        document.getElementById("outPutDec").value = 0;
		$("#OUTPUTCHEKF").val(strPacketInXML);
    	}
	else
	{
		setTimeout(function () {//10050
		  strPacketInXML = readFileSalary(idForm);
		  $("#OUTPUTCHEKF").val(strPacketInXML);
		 },50);
	 }

	 $("#DEC").addClass("hidden");
	 $("#DECL30K").val('');		
	 $("input[name='chbDeclData']").prop('checked', false);

}


function readFileSalary(idForm) {
    var f = null;
    var fAll = "";
    var countall = 0;
    var count = 0;
    document.getElementById("YESECON").value = "0";
    document.getElementById("OUTPUTF").value = "";
    document.getElementById("AMOUNT").value = "";
    document.getElementById("ALLROW").value = "";
    document.getElementById("CURR").value = "";

    var F = document.getElementById(idForm);

    try {//Проверка за браузера
        if ("ActiveXObject" in window) {
            //if (typeof ActiveXObject != "undefined") {
            var fso = new ActiveXObject("Scripting.FileSystemObject");
            strFileName = F.elements["FILE_NAME"].value;
            document.getElementById("FILENAME").value = strFileName;
            if (fso.FileExists(strFileName) == false) {
                elemError(F.elements["FILE"], "Моля изберете файл!<br/>Please select a file!");
                fso = null;
                return false;
            }
            var iFileNameLength = strFileName.length;
            var strFileNameExt = strFileName.substr(iFileNameLength - 3);
           
            f = fso.OpenTextFile(strFileName, 1, 1);//Original 10050
            fAll = f.ReadAll();
				if(fAll.indexOf(';') == -1)//10050
				{
				if (strFileNameExt.toLowerCase() != "txt") {
                elemError(F.elements["FILE"], "Моля изберете файл!<br/>Please select a file.");
                return false;
            }
			
					$('#UbbSal').removeClass('hidden');//10050
					$('#exCiBankSal').addClass('hidden');//10050
				}
				else
				{
					$('#UbbSal').addClass('hidden');//10050
					$('#exCiBankSal').removeClass('hidden');//10050

				}
        }
        else {
            var file = document.getElementById("FILE").files[0];
            var strFileName = file.name;
            document.getElementById("FILENAME").value = strFileName;

            var iFileNameLength = strFileName.length;
            var strFileNameExt = strFileName.substr(iFileNameLength - 3);
           

            var reader = new FileReader();
            reader.onload = function (event) {
                // NOTE: event.target point to FileReader
                var contents = event.target.result;
                var lines = contents.split('\n');
				if(lines[0].indexOf(';') == -1)
                {//15057 Формат 198
                    if ((strFileNameExt.toLowerCase() != "txt") && (strFileNameExt.toLowerCase() != "bgi")) {
                        elemError(F.elements["FILE"], "Моля изберете файл!<br/>Please select a file.");
                        return false;
                    }

			
					$('#UbbSal').removeClass('hidden');
					$('#exCiBankSal').addClass('hidden');
				}
				else
				{
					$('#UbbSal').addClass('hidden');
					$('#exCiBankSal').removeClass('hidden');

				}
                document.getElementById('OUTPUTF').value = contents;
				$("#OUTPUTCHEKF").val(contents);
				
            };

            reader.readAsText(file, 'windows-1251');
        }

    }//end try
    catch (e) {
        alert(e.description);
    }
    return fAll;
}

function readFileMP(idForm) {//9720
    var f = null;
    var fAll = "";
    var countall = 0;
    var count = 0;
    document.getElementById("YESECON").value = "0";
    document.getElementById("OUTPUTF").value = "";
    document.getElementById("AMOUNT").value = "";
    document.getElementById("ALLROW").value = "";
    document.getElementById("CURR").value = "";

    var F = document.getElementById(idForm);

    try {//Проверка за браузера
        if ("ActiveXObject" in window) {
            //if (typeof ActiveXObject != "undefined") {
            var fso = new ActiveXObject("Scripting.FileSystemObject");
            strFileName = F.elements["FILE_NAME"].value;
            document.getElementById("FILENAME").value = strFileName;
            if (fso.FileExists(strFileName) == false) {
                elemError(F.elements["FILE"], "Моля изберете файл!<br/>Please select a file!");
                fso = null;
                return false;
            }
            var iFileNameLength = strFileName.length;
            var strFileNameExt = strFileName.substr(iFileNameLength - 3);
            f = fso.OpenTextFile(strFileName, 1, 1);//Original
            fAll = f.ReadAll();
        }
        else {
            var file = document.getElementById("FILE").files[0];
            var strFileName = file.name;
            document.getElementById("FILENAME").value = strFileName;

            var iFileNameLength = strFileName.length;
            var strFileNameExt = strFileName.substr(iFileNameLength - 3);
            var reader = new FileReader();
            reader.onload = function (event) {
                // NOTE: event.target point to FileReader
                var contents = event.target.result;
                var lines = contents.split('\n');
                document.getElementById('OUTPUTF').value = contents;
            };

            reader.readAsText(file, 'windows-1251');
        }

    }//end try
    catch (e) {
        alert(e.description);
    }
    return fAll;
}
/************************** end Import SALARY ***************************/


function GetAllValues1(Elem) {
    var retAllValues = "";
    try {
        if (Elem != null) {
            var ss = "";
            var count = Elem.length;
            if (Elem.length && Elem.type != "select-one") {
                for (var i = 0; i < count; i++)
                    retAllValues += htmlEscape(GetValue(Elem[i]));
            }
            else
                retAllValues = htmlEscape(GetValue(Elem));
        }//end if(Elem != null)
    }
    catch (e) {
        alert(e.description);
    }
    return retAllValues;
}

function popupAlert(textPopup, cl) {
    var targetPopup = "popup_alert";
    var popupContent = "#" + targetPopup + "_c";

    $(popupContent).empty();
    $(popupContent).append('<div class="popup-text-box"><p>' + textPopup + '</p></div>');

    if (cl) {
        $(popupContent).append('<footer><a href="javascript:;" onclick="popupCloseExport()" title="OK" class="b-close btn btn-highlight-2 btn-wide" data-action="ok"> OK </a></footer>');
    }
    else {
        $(popupContent).append('<footer><a href="javascript:;" title="OK" class="b-close btn btn-highlight-2 btn-wide" data-action="ok"> OK </a></footer>');
    }
    openPopup(targetPopup);

}

function popupCloseExport() {

    $("a[class='b-close']").click();
}


function ExportToExelAllBrowsersRightsManagement(nameExpFile2, fileType, title1, title2) {
    if (title2 != '') {

        tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
        tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
        tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
        tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
        tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
        tab_text += "<p><font size='5'>" + title1 + "</font></p>" + '\n' + '<p></p>' + '\n';
        tab_text += "<table border='1px'>";
        tab_text += "<thead><tr style='height:35px'>" + $('#stmt thead tr').html().toUpperCase() + "</tr><thead>";
        tab_text += '<tbody>';
        $('#stmt tbody tr').each(function () {
            $(this).each(function () {
                tab_text += "<tr>";
                for (var i = 0; i < $(this).children().length; i++) {
                    var cellResult = $(this).children().eq(i).text();
                    cellResult = cellResult.replace(/(\n)/gm, "");
                    cellResult = cellResult.trim();
                    switch (i) {
                        case 0: tab_text += "<td align='left'>" + cellResult.replace('i', '') + "</td>"; break;
                        case 1: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                        case 2: tab_text += "<td align='right'>" + cellResult.replace('i', '') + "</td>"; break;
                        case 3: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                        case 4: tab_text += "<td>" + cellResult + "</td>"; break;
                        case 5: tab_text += "<td>" + cellResult + "</td>"; break;
                        case 6: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break;
                        case 7: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                        case 8: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                        case 9: tab_text += "<td>" + cellResult + "</td>"; break;
                    }
                }
                tab_text += "</tr>";
            })
        });
        //style="font-weight:bold"
        tab_text += "</tbody>";
        /* tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#stmt tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";*/
        tab_text += "</table>";
        tab_text += "<p><font size='5'>" + title2 + "</font></p>" + '\n' + '<p></p>' + '\n';
        tab_text += "<table border='1px'>";
        tab_text += "<thead><tr style='height:35px'>" + $('#table2 thead tr').html().toUpperCase() + "</tr><thead>";
        tab_text += '<tbody>';
        $('#table2 tbody tr').each(function () {
            $(this).each(function () {
                tab_text += "<tr>";
                for (var i = 0; i < $(this).children().length; i++) {
                    var cellResult = $(this).children().eq(i).text();
                    cellResult = cellResult.replace(/(\n)/gm, "");
                    cellResult = cellResult.trim();
                    switch (i) {
                        case 0: tab_text += "<td align='left'>" + cellResult.replace('i', '') + "</td>"; break;
                        case 1: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                        case 2: tab_text += "<td align='right'>" + cellResult.replace('i', '') + "</td>"; break;
                        case 3: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                        case 4: tab_text += "<td>" + cellResult + "</td>"; break;
                        case 5: tab_text += "<td>" + cellResult + "</td>"; break;
                        case 6: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break;
                        case 7: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                        case 8: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                        case 9: tab_text += "<td>" + cellResult + "</td>"; break;
                    }
                }
                tab_text += "</tr>";
            })
        });
        //style="font-weight:bold"
        tab_text += "</tbody>";
        /* tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#stmt tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";*/
        tab_text += "</table></body></html>";
        tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
        var fileResult = nameExpFile2 + "." + fileType;
        $.getScript('web/js-fileServer/file-server.js', function () {
            var blob = new Blob([tab_text], { type: "application/csv;charset=utf-8;" });
            saveAs(blob, fileResult);
        });

        return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
    }
    else {
        tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
        tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
        tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
        tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
        tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
        tab_text += "<p><font size='5'>" + title1 + "</font></p>" + '\n' + '<p></p>' + '\n';
        tab_text += "<table border='1px'>";
        tab_text += "<thead><tr style='height:35px'>" + $('#stmt thead tr').html().toUpperCase() + "</tr><thead>";
        tab_text += '<tbody>';
        $('#stmt tbody tr').each(function () {
            $(this).each(function () {
                tab_text += "<tr>";
                for (var i = 0; i < $(this).children().length; i++) {
                    var cellResult = $(this).children().eq(i).html();
                    cellResult = cellResult.replace(/(\n)/gm, "");
                    cellResult = cellResult.trim();
                    switch (i) {
                        case 0: tab_text += "<td align='left'>" + cellResult.replace('i', '') + "</td>"; break;
                        case 1: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                        case 6:
                            if (cellResult.indexOf("checkbox") > 0) {
                                //alert(cellResult.substring(cellResult.indexOf("value=") + "value=".length+1, cellResult.indexOf("value=")+"value=".length+2));
                                var checkboxValue = cellResult.substring(cellResult.indexOf("value=") + "value=".length + 1, cellResult.indexOf("value=") + "value=".length + 2);
                                if (checkboxValue == "1") {
                                    tab_text += "<td align='center'>" + "&#10004;" + "</td>";
                                }
                                else {
                                    tab_text += "<td></td>";
                                }
                            }
                            else {
                                tab_text += "<td>" + cellResult + "</td>";
                            }
                            break;
                        case 7: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                        case 8: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                        case 9: tab_text += "<td>" + cellResult + "</td>"; break;
                    }
                }
                tab_text += "</tr>";
            })
        });
        //style="font-weight:bold"
        tab_text += "</tbody>";
        /* tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#stmt tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";*/
        tab_text += "</table></body></html>";
        tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
        var fileResult = nameExpFile2 + "." + fileType;
        $.getScript('web/js-fileServer/file-server.js', function () {
            var blob = new Blob([tab_text], { type: "application/csv;charset=utf-8;" });
            saveAs(blob, fileResult);
        });

        return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
    }
}
/*
Задание 13097
 */
function ExportToExelAllBrowsersReqHistory(nameExpFile2, fileType, sFROMDATE, sTODATE, sdetail) {
    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + $('#stmt thead tr').html().toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {
            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult.replace('i', '') + "</td>"; break;
                    case 1: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                    case 2: tab_text += "<td align='right'>" + cellResult.replace('i', '') + "</td>"; break;
                    case 3: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                    case 4: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 5: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 6: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break;
                    case 7: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                    case 8: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                    case 9: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 10: tab_text += (sdetail) ? "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>" : "<td>" + cellResult + "</td>"; break;
                    case 11: if (sdetail) { tab_text += "<td>" + cellResult + "</td>"; } break;
                    case 12: if (sdetail) { tab_text += "<td style='width:80px;'>" + cellResult + "</td>"; } break;
                    case 13: if (sdetail) { tab_text += "<td>" + cellResult + "</td>"; } break;
                    case 14: if (sdetail) { tab_text += "<td>" + cellResult + "</td>"; } break;
                }
            }
            tab_text += "</tr>";
        })
    });
    //style="font-weight:bold"
    tab_text += "</tbody>";
    /* tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#stmt tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";*/
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob([tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт за периода " + sFROMDATE + " - " + sTODATE + " " + " допълнителна информация във файл " + fileResult + "<br/><br/>Successful data export for period " + sFROMDATE + " - " + sTODATE + " " + " additional info in file " + fileResult, true);
}
function ExportToExcelAllBrowsersPos(nameExpFile2, fileType) {
    var txtTitleC = $('#stmt thead th')[4].outerHTML; //remove create similar 
    var txtAllRow = $('#stmt thead tr').html();

    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + txtAllRow.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {

            tab_text += "<tr>";
            var cellId = $(this).attr('id');
            if (cellId == 'tidid' || cellId == 'mcid') { // TID/MID SubTotal
                tab_text += "<td colspan='10'>" + $(this).children().eq(0).text() + "</td>"; // BLANK
                tab_text += "<td style='mso-number-format:\"0\.00\"'>" + $(this).children().eq(10).text().replace(/[,]/gm, "") + "</td>"; // СУМА НА ТРАНЗАКЦИЯ
                tab_text += "<td style='mso-number-format:\"0\.00\"'>" + $(this).children().eq(11).text().replace(/[,]/gm, "") + "</td>"; // КОМИСИОНА
                tab_text += "<td style='mso-number-format:\"0\.00\"'>" + $(this).children().eq(12).text().replace(/[,]/gm, "") + "</td>"; // НЕТНА СУМА
                tab_text += "<td colspan='6'>";  // BLANK 2
            }
            else {
                for (var i = 0; i < $(this).children().length; i++) {
                    var cellResult = $(this).children().eq(i).text();
                    cellResult = cellResult.replace(/(\n)/gm, "");
                    cellResult = cellResult.trim().toUpperCase();
                    switch (i) {
                        case 0: tab_text += "<td style='mso-number-format:\"00000000\"' align='left'>" + cellResult + "</td>"; break; // КОД ТЪРГОВЕЦ
                        case 1: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // TЕРМИНАЛ ИД
                        case 2: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // ИМЕ НА ОБЕКТ
                        case 3: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // ГРАД
                        case 4: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // ТЕРМ АДРЕС
                        case 5: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // ДАТА НА ОСЧ./ПЛАЩАНЕ
                        case 6: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // ДАТА И ЧАС НА ТРАНЗАКЦИЯ
                        case 7: tab_text += "<td align='left'>" + cellResult + "</td>"; break;// ВАЛЪОР
                        case 8: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // ТИП ТРАНЗАКЦИЯ
                        case 9: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // КАРТА
                        case 10: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // СУМА НА ТРАНЗАКЦИЯ
                        case 11: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break;// КОМИСИОНА
                        case 12: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break;// НЕТНА СУМА
                        case 13: tab_text += "<td align='left'>" + cellResult + "</td>"; break;// АВТ. КОД
                        case 14: tab_text += "<td align='left'>" + cellResult + "</td>"; break;// ВАЛ.
                        case 15: tab_text += "<td align='left'>" + cellResult + "</td>"; break;// БАНКА ИЗДАТЕЛ
                        case 16: tab_text += "<td align='left'>" + cellResult + "</td>"; break;// CARD BRAND
                        case 17: tab_text += "<td align='left' style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break;// CASH BACK
                        case 18: tab_text += "<td align='left'>" + cellResult + "</td>"; break;// РЕФЕРЕНЦИЯ
                    }
                }
            }
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, nameExpFile2);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}
//start 10280
function ExportToExelAllBrowsers(nameExpFile2, fileType, sFROMDATE, sTODATE, additionalInfo, additionalInfoEN, sdetail) {
    var dualOn = $('#FL_EUR_BGN').val() != 0 && $('#Currency').val() == $('#CURR').val() && $('#FizLize').val() == 1;
    var txtTitleC = $('#stmt thead th')[dualOn ? 6 : 4].outerHTML; //remove create similar 
    var txtAllRow = $('#stmt thead tr').html();
    var txtFinal = txtAllRow.replace(txtTitleC, "");
    
    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 +'</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() +  "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>"; 
    tab_text += "<thead><tr style='height:35px'>" + txtFinal.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function() {
        $(this).each(function(){
            function getFormattedText(row, i) {
                var cellResult = row.children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim();
                return cellResult;
            }

            tab_text += "<tr>";
            tab_text += "<td align='left'>" + getFormattedText($(this), 0).replace('i', '') + "</td>";  //СЧЕТОВОДНА ДАТА
            tab_text += "<td style='width:40px;'>" + getFormattedText($(this), 1) + "</td>"; //ЧАС
            tab_text += "<td style='mso-number-format:\"0\.00\"'>" + getFormattedText($(this), 2).replace(/[,]/gm, "") + "</td>";  //ПЛАЩАНИЯ
            if (dualOn) {
                tab_text += "<td style='mso-number-format:\"0\.00\"'>" + getFormattedText($(this), 3).replace(/[,]/gm, "") + "</td>"; //ПЛАЩАНИЯ В EUR
            }
            tab_text += "<td style='mso-number-format:\"0\.00\"'>" + getFormattedText($(this), dualOn ? 4 : 3).replace(/[,]/gm, "") + "</td>"; //ПОСТЪПЛЕНИЯ
            if (dualOn) {
                tab_text += "<td style='mso-number-format:\"0\.00\"'>" + getFormattedText($(this), 5).replace(/[,]/gm, "") + "</td>"; //ПОСТЪПЛЕНИЯ В EUR
            }
            //Here we skip "Create Similar" column, so indexing goes up +1
            tab_text += "<td>" + getFormattedText($(this), dualOn ? 7 : 5) + "</td>"; //ОПИСАНИЕ
            tab_text += "<td>" + getFormattedText($(this), dualOn ? 8 : 6) + "</td>"; //КОРЕСПОНДЕНТ
            tab_text += "<td style='mso-number-format:\"0\.00\"'>" + getFormattedText($(this), dualOn ? 9 : 7).replace(/[,]/gm, "") + "</td>"; //МЕЖДИННО САЛДО
            if (dualOn) {
                tab_text += "<td style='mso-number-format:\"0\.00\"'>" + getFormattedText($(this), 10).replace(/[,]/gm, "") + "</td>"; //МЕЖДИННО САЛДО В EUR
            }
            tab_text += "<td style='mso-number-format:\"\\@\"'>" + getFormattedText($(this), dualOn ? 11 : 8) + "</td>"; //ОСНОВАНИЕ ЗА ПЛАЩАНЕ
            tab_text += "<td style='mso-number-format:\"\\@\"'>" + getFormattedText($(this), dualOn ? 12 : 9) + "</td>"; //ОЩЕ ПОЯСНЕНИЯ
            tab_text += "<td style='mso-number-format:\"\\@\"'>" + getFormattedText($(this), dualOn ? 13 : 10) + "</td>"; //РЕФЕРЕНЦИЯ
            tab_text += ((sdetail) ? "<td style='mso-number-format:\"\\@\"'>" : "<td>") + getFormattedText($(this), dualOn ? 14 : 11) + "</td>"; //ДЕБИТНО АВИЗО
            if (sdetail) { tab_text += "<td>" + getFormattedText($(this), dualOn ? 15 : 12) + "</td>"; } //ОЩЕ	
            if (sdetail) { tab_text += "<td style='width:80px;'>" + getFormattedText($(this), dualOn ? 16 : 13) + "</td>"; } //ДАТА И ЧАС НА ТРАНЗАКЦИЯ
            if (sdetail) { tab_text += "<td>" + getFormattedText($(this), dualOn ? 17 : 14) + "</td>"; } //ВАЛЬОР
            if (sdetail) { tab_text += "<td>" + getFormattedText($(this), dualOn ? 18 : 15) + "</td>"; } //ОСНОВАНИЯ
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#stmt tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}

function ExportToExcelAllBrowsersBankGuaranteesIssued(nameExpFile2, fileType) {

    var txtAllRow = $('#stmt thead tr').html();

    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + txtAllRow.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {

            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim().toUpperCase();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Reference
                    case 1: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Old Reference
                    case 2: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Beneficery
                    case 3: tab_text += "<td>" + cellResult + "</td>"; break; // Currency
                    case 4: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Amount
                    case 5: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Issue date
                    case 6: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Validity date
                    case 7: tab_text += "<td>" + cellResult + "</td>"; break;// Guarantee type
                    case 8: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Limit No.
                    case 9: tab_text += "<td align='right'> " + cellResult + "</td>"; break; // Limit up to
                    case 10: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Credit contract No.
                }
            }
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}

function ExportToExcelAllBrowsersBankGuaranteesReceived(nameExpFile2, fileType) {

    var txtAllRow = $('#stmt thead tr').html();

    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + txtAllRow.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {

            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim().toUpperCase();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Reference
                    case 1: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Ordering Party
                    case 2: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Currency
                    case 3: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Amount
                    case 4: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Issuing Bank Name
                    case 5: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Issue date
                    case 6: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Validity date
                    case 7: tab_text += "<td>" + cellResult + "</td>"; break;// Guarantee type
                }
            }
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}

// OOBT 1064 - 2025 
function ExportToExcelAllBrowsersLetterOfCreditIssued(nameExpFile2, fileType) {

    var txtAllRow = $('#stmt thead tr').html();
    // This is added because hidden columns have 0 width and are not showed properly when export to Excel
    txtAllRow = txtAllRow.replaceAll('style="width: 0px;', 'style="width: 100px;');

    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + txtAllRow.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {

            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim().toUpperCase();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Reference
                    case 1: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Old Reference
                    case 2: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Beneficery
                    case 3: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Advising Bank Name
                    case 4: tab_text += "<td>" + cellResult + "</td>"; break; // Currency
                    case 5: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Lc amount
                    case 6: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Tolerance Plus
                    case 7: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Tolerance Minus
                    case 8: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Tolerance Amount
                    case 9: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Drawings
                    case 10: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Remaining Amount
                    case 11: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Issue date
                    case 12: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Expiry date
                    case 13: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // End Expiry date
                    case 14: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Limit No.
                    case 15: tab_text += "<td align='left'> " + cellResult + "</td>"; break; // Description
                    case 16: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Credit contract No.
                }
            }
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}

function ExportToExcelAllBrowsersLetterOfCreditReceived(nameExpFile2, fileType) {

    var txtAllRow = $('#stmt thead tr').html();

    // This is added because hidden columns have 0 width and are not showed properly when export to Excel
    txtAllRow = txtAllRow.replaceAll('style="width: 0px;', 'style="width: 100px;');

    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + txtAllRow.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {

            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim().toUpperCase();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Reference
                    case 1: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Old Reference
                    case 2: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Ordering party
                    case 3: tab_text += "<td>" + cellResult + "</td>"; break; // Currency
                    case 4: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Lc amount
                    case 5: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Tolerance Plus
                    case 6: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Tolerance Minus
                    case 7: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Tolerance Amount
                    case 8: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Drawings
                    case 9: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Remaining Amount
                    case 10: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Issuing Bank Name                   
                    case 11: tab_text += "<td align='left'> " + cellResult + "</td>"; break; // Description
                    case 12: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Issue date
                    case 13: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Adv Exp date
                }
            }
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}

function ExportToExcelAllBrowsersDocumentaryCollections(nameExpFile2, fileType) {
       var txtAllRow = $('#stmt thead tr').html();
    // This is added because hidden columns have 0 width and are not showed properly when export to Excel
    txtAllRow = txtAllRow.replaceAll('style="width: 0px;', 'style="width: 100px;');

    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + txtAllRow.toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {

            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim().toUpperCase();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Reference
                    case 1: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Сendingbank
                    case 2: tab_text += "<td align='left'>" + cellResult + "</td>"; break; // Beneficery
                    case 3: tab_text += "<td>" + cellResult + "</td>"; break; // Currency
                    case 4: tab_text += "<td style='mso-number-format:\"0\.00\"'>" + cellResult.replace(/[,]/gm, "") + "</td>"; break; // Amount
                    case 5: tab_text += "<td align='right'>" + cellResult + "</td>"; break; // Issue date
                    case 6: tab_text += "<td>" + cellResult + "</td>"; break; // invisible
                }
            }
            tab_text += "</tr>";
        })
    });
    tab_text += "</tbody>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob(["\uFEFF" + tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт" + "<br/><br/>Successful data export for period ", true);
}

function ExportToExelAllBrowsersAdmin(nameExpFile2, fileType) {
    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    tab_text += "<thead><tr style='height:35px'>" + $('#UserManageTable thead tr').html().toUpperCase() + "</tr><thead>";
    tab_text += '<tbody>';
    $('#UserManageTable tbody tr').each(function () {
        $(this).each(function () {
            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult.replace('i', '') + "</td>"; break;
                    case 1: tab_text += "<td style='width:40px;'>" + cellResult + "</td>"; break;
                    case 2: tab_text += "<td align='right'>" + cellResult + "</td>"; break;
                    case 3: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 4: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 5: tab_text += "<td align='right'>" + cellResult + "</td>"; break;
                    case 6: tab_text += "<td>" + cellResult + "</td>"; break;
                    // case 7: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                    // case 8: tab_text += "<td style='mso-number-format:\"\\@\"'>" + cellResult + "</td>"; break;
                    // case 9: tab_text += "<td>" + cellResult + "</td>"; break;

                }
            }
            tab_text += "</tr>";
        })
    });
    //style="font-weight:bold"
    tab_text += "</tbody>";
    //tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#UserManageTable tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&nbsp;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob([tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт!", true);
}
function ExportToExelAllBrowsersSal(nameExpFile2, fileType) {
    tab_text = '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
    tab_text += '<head><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet>';
    tab_text += '<x:Name>' + nameExpFile2 + '</x:Name>';
    tab_text += '<x:WorksheetOptions><x:Panes></x:Panes></x:WorksheetOptions></x:ExcelWorksheet>';
    tab_text += '</x:ExcelWorksheets></x:ExcelWorkbook></xml></head><body>';
    tab_text += "<p><font size='5'>" + $('#idResultScreen_c h3').text() + "</font></p>" + '\n' + '<p></p>' + '\n';
    tab_text += "<table border='1px'>";
    /*tab_text += "<thead><tr style='height:35px'>" + $('#stmt thead tr').html().toUpperCase() + "</tr><thead>";*/
    tab_text += '<tbody>';
    $('#stmt tbody tr').each(function () {
        $(this).each(function () {
            tab_text += "<tr>";
            for (var i = 0; i < $(this).children().length; i++) {
                var cellResult = $(this).children().eq(i).text();
                cellResult = cellResult.replace(/(\n)/gm, "");
                cellResult = cellResult.trim();
                switch (i) {
                    case 0: tab_text += "<td align='left'>" + cellResult.replace('i', '') + "</td>"; break;
                    case 1: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 2: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 3: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 4: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 5: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 6: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 7: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 8: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 9: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 10: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 11: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 12: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 13: tab_text += "<td>" + cellResult + "</td>"; break;
                    case 14: tab_text += "<td>" + cellResult + "</td>"; break;
                }
            }
            tab_text += "</tr>";
        })
    });
    //style="font-weight:bold"
    tab_text += "</tbody>";
    /*tab_text += "<tfoot><tr style='height:25px; font-weight:bold; font-size: 15px;'>" + $('#stmt tfoot tr').html().replace(/[,]/gm, "") + "</tr></tfoot>";*/
    tab_text += "</table></body></html>";
    tab_text = tab_text.replace(/(\n)|(&NBSP;)/gm, "");
    var fileResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var blob = new Blob([tab_text], { type: "application/csv;charset=utf-8;" });
        saveAs(blob, fileResult);
    });

    return popupAlert("Успешно извършен експорт!", true);
}


function ExportToXMLAndTXTAllBrowsersBankGuaranteesIssued(nameExpFile2, fileType, sdelimiter) {
    var xml = '';
    var strCloseBalance = "";
    if (fileType == "xml") {
        //xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
        xml += ("<BANK_GUARANTEES_ISSUED>\n");
    }

    var iRowsLength = document.getElementById("stmt").rows.length;
    for (var i = 1; i < iRowsLength; i++) {

        if (i === iRowsLength - 1) {
            continue;
        }

        for (var j = 0; j < document.getElementById("stmt").rows[i].cells.length; j++) {
            if (fileType == "xml") {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                if (strInnerText != "") {

                    var re3 = /[<>&]/g;
                    strInnerText = strInnerText.replace(re3, " ");

                    switch (j) {
                        case 0:
                            strInnerText = strInnerText.replace(/[i]/g, "");
                            xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                            break;
                        case 1:
                            xml += ("<OLD_REFERENCE>" + strInnerText + "</OLD_REFERENCE>");
                            break;
                        case 2:
                            xml += ("<BENEFICIARY>" + strInnerText + "</BENEFICIARY>");
                            break;
                        case 3:
                            xml += ("<CURRENCY>" + strInnerText + "</CURRENCY>");
                            break;
                        case 4:
                            xml += ("<AMOUNT>" + strInnerText + "</AMOUNT>");
                            break;
                        case 5:
                            xml += ("<ISSUE_DATE>" + strInnerText + "</ISSUE_DATE>");
                            break;
                        case 6:
                            xml += ("<EXPIRY_DATE>" + strInnerText + "</EXPIRY_DATE>");
                            break;
                        case 7:
                            xml += ("<GUARANTEE_TYPE>" + strInnerText + "</GUARANTEE_TYPE>");
                            break;
                        case 8:
                            xml += ("<LIMIT_NO>" + strInnerText + "</LIMIT_NO>");
                            break;
                        case 9:
                            xml += ("<LIMIT_REFERENCE>" + strInnerText + "</LIMIT_REFERENCE>");
                            break;
                        case 10:
                            xml += ("<CREDIT_CONTRACT>" + strInnerText + "</CREDIT_CONTRACT>");
                            break;
                    }
                }
            }
            else {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                if (j === 0) {
                    xml += strInnerText.toUpperCase();
                }
                else if (j === document.getElementById("stmt").rows[i].cells.length - 1) {
                    xml += sdelimiter + strInnerText.toUpperCase();
                    xml += ("\r\n");
                } else {
                    xml += sdelimiter + strInnerText.toUpperCase();
                }
            }
        }

        if (fileType == "xml") {
            xml += ("\r\n");
        }
    }
    if (fileType == "xml") {
        xml += ("</BANK_GUARANTEES_ISSUED>");
    }


    var exportNameResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        //629313HD
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + xml;
        var encodeType, csvA; //= (fileType == 'xml') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        if (fileType == 'xml') {
            encodeType = 'text/csv;charset=UTF-16LE';
            csvA = new Uint16Array(csv.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        } else {
            encodeType = 'text/csv;charset=ANSI';
            var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
            var csv1251 = '';
            for (var i = 0; i < csv.length; i++) {
                var ord = csv.charCodeAt(i);
                if (ord in DMap) {
                    csv1251 += (String.fromCharCode(DMap[ord]));
                };
            };
            csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        }
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);
    });

    popupAlert("Успешно извършен експорт за периода" + "<br/><br/>Successful data export for period", true);
}

function ExportToXMLAndTXTAllBrowsersBankGuaranteesReceived(nameExpFile2, fileType, sdelimiter) {
    var xml = '';
    var strCloseBalance = "";
    if (fileType == "xml") {
        //xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
        xml += ("<BANK_GUARANTEES_RECEIVED>\n");
    }

    var iRowsLength = document.getElementById("stmt").rows.length;
    for (var i = 1; i < iRowsLength; i++) {

        if (i === iRowsLength - 1) {
            continue;
        }

        for (var j = 0; j < document.getElementById("stmt").rows[i].cells.length; j++) {
            if (fileType == "xml") {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                if (strInnerText != "") {

                    var re3 = /[<>&]/g;
                    strInnerText = strInnerText.replace(re3, " ");

                    switch (j) {
                        case 0:
                            strInnerText = strInnerText.replace(/[i]/g, "");
                            xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                            break;
                        case 1:
                            xml += ("<ORDERING_PARTY>" + strInnerText + "</ORDERING_PARTY>");
                            break;
                        case 2:
                            xml += ("<CURRENCY>" + strInnerText + "</CURRENCY>");
                            break;
                        case 3:
                            xml += ("<AMOUNT>" + strInnerText + "</AMOUNT>");
                            break;
                        case 4:
                            xml += ("<ISSUING_BANK_NAME>" + strInnerText + "</ISSUING_BANK_NAME>");
                            break;
                        case 5:
                            xml += ("<ISSUE_DATE>" + strInnerText + "</ISSUE_DATE>");
                            break;
                        case 6:
                            xml += ("<EXPIRY_DATE>" + strInnerText + "</EXPIRY_DATE>");
                            break;
                        case 7:
                            xml += ("<GUARANTEE_TYPE>" + strInnerText + "</GUARANTEE_TYPE>");
                            break;
                    }
                }
            }
            else {


                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                if (j === 0) {
                    xml += strInnerText.toUpperCase();
                }
                else if (j === document.getElementById("stmt").rows[i].cells.length - 1) {
                    xml += sdelimiter + strInnerText.toUpperCase();
                    xml += ("\r\n");
                } else {
                    xml += sdelimiter + strInnerText.toUpperCase();
                }
            }
        }

        if (fileType == "xml") {
            xml += ("\r\n");
        }
    }
    if (fileType == "xml") {
        xml += ("</BANK_GUARANTEES_RECEIVED>");
    }


    var exportNameResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        //629313HD
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + xml;
        var encodeType, csvA; //= (fileType == 'xml') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        if (fileType == 'xml') {
            encodeType = 'text/csv;charset=UTF-16LE';
            csvA = new Uint16Array(csv.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        } else {
            encodeType = 'text/csv;charset=ANSI';
            var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
            var csv1251 = '';
            for (var i = 0; i < csv.length; i++) {
                var ord = csv.charCodeAt(i);
                if (ord in DMap) {
                    csv1251 += (String.fromCharCode(DMap[ord]));
                };
            };
            csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        }
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);
    });

    popupAlert("Успешно извършен експорт за периода" + "<br/><br/>Successful data export for period", true);
}

function ExportToXMLAndTXTAllBrowsersLetterOfCreditIssued(nameExpFile2, fileType, sdelimiter) {
    var xml = '';
    var strCloseBalance = "";
    if (fileType == "xml") {
        //xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
        xml += ("<LETTER_OF_CREDIT_ISSUED>\n");
    }

    var iRowsLength = document.getElementById("stmt").rows.length;
    for (var i = 1; i < iRowsLength; i++) {

        if (i === iRowsLength - 1) {
            continue;
        }

        for (var j = 0; j < document.getElementById("stmt").rows[i].cells.length; j++) {
            if (fileType == "xml") {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                var re3 = /[<>&]/g;
                strInnerText = strInnerText.replace(re3, " ");

                switch (j) {
                    case 0:
                        strInnerText = strInnerText.replace(/[i]/g, "");
                        xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                        break;
                    case 1:
                        xml += ("<OLD_REFERENCE>" + strInnerText + "</OLD_REFERENCE>");
                        break;
                    case 2:
                        xml += ("<BENEFICIARY>" + strInnerText + "</BENEFICIARY>");
                        break;
                    case 3:
                        xml += ("<ADVINSING_BANK_NAME>" + strInnerText + "</ADVINSING_BANK_NAME>");
                        break;
                    case 4:
                        xml += ("<CURRENCY>" + strInnerText + "</CURRENCY>");
                        break;
                    case 5:
                        xml += ("<LC_AMOUNT>" + strInnerText + "</LC_AMOUNT>");
                        break;
                    case 6:
                        xml += ("<TOLERANCE_PLUS>" + strInnerText + "</TOLERANCE_PLUS>");
                        break;
                    case 7:
                        xml += ("<TOLERANCE_MINUS>" + strInnerText + "</TOLERANCE_MINUS>");
                        break;
                    case 8:
                        xml += ("<TOLERANCE_AMOUNT>" + strInnerText + "</TOLERANCE_AMOUNT>");
                        break;
                    case 9:
                        xml += ("<DRAWINGS>" + strInnerText + "</DRAWINGS>");
                        break;
                    case 10:
                        xml += ("<OUTSTANDING_LC_AMOUNT>" + strInnerText + "</OUTSTANDING_LC_AMOUNT>");
                        break;
                    case 11:
                        xml += ("<ISSUE_DATE>" + strInnerText + "</ISSUE_DATE>");
                        break;
                    case 12:
                        xml += ("<EXPIRY_DATE>" + strInnerText + "</EXPIRY_DATE>");
                        break;
                    case 13:
                        xml += ("<END_EXPIRY_DATE>" + strInnerText + "</END_EXPIRY_DATE>");
                        break;
                    case 14:
                        xml += ("<LIMIT_NO>" + strInnerText + "</LIMIT_NO>");
                        break;
                    case 15:
                        xml += ("<DESCRIPTION>" + strInnerText + "</DESCRIPTION>");
                        break;
                    case 16:
                        xml += ("<CREDIT_CONTRACT>" + strInnerText + "</CREDIT_CONTRACT>");
                        break;
                }
            }
            else {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                if (j === 0) {
                    xml += strInnerText.toUpperCase();
                }
                else if (j === document.getElementById("stmt").rows[i].cells.length - 1) {
                    xml += sdelimiter + strInnerText.toUpperCase();
                    xml += ("\r\n");
                } else {
                    xml += sdelimiter + strInnerText.toUpperCase();
                }
            }
        }

        if (fileType == "xml") {
            xml += ("\r\n");
        }
    }
    if (fileType == "xml") {
        xml += ("</LETTER_OF_CREDIT_ISSUED>");
    }


    var exportNameResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        //629313HD
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + xml;
        var encodeType, csvA; //= (fileType == 'xml') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        if (fileType == 'xml') {
            encodeType = 'text/csv;charset=UTF-16LE';
            csvA = new Uint16Array(csv.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        } else {
            encodeType = 'text/csv;charset=ANSI';
            var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
            var csv1251 = '';
            for (var i = 0; i < csv.length; i++) {
                var ord = csv.charCodeAt(i);
                if (ord in DMap) {
                    csv1251 += (String.fromCharCode(DMap[ord]));
                };
            };
            csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        }
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);
    });

    popupAlert("Успешно извършен експорт за периода" + "<br/><br/>Successful data export for period", true);
}

function ExportToXMLAndTXTAllBrowsersLetterOfCreditReceived(nameExpFile2, fileType, sdelimiter) {
    var xml = '';
    var strCloseBalance = "";
    if (fileType == "xml") {
        //xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
        xml += ("<LETTER_OF_CREDIT_RECEIVED>\n");
    }

    var iRowsLength = document.getElementById("stmt").rows.length;
    for (var i = 1; i < iRowsLength; i++) {

        if (i === iRowsLength - 1) {
            continue;
        }

        for (var j = 0; j < document.getElementById("stmt").rows[i].cells.length; j++) {
            if (fileType == "xml") {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                var re3 = /[<>&]/g;
                strInnerText = strInnerText.replace(re3, " ");

                switch (j) {
                    case 0:
                        strInnerText = strInnerText.replace(/[i]/g, "");
                        xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                        break;
                    case 1:
                        xml += ("<OLD_REFERENCE>" + strInnerText + "</OLD_REFERENCE>");
                        break;
                    case 2:
                        xml += ("<ORDERING_PARTY>" + strInnerText + "</ORDERING_PARTY>");
                        break;
                    case 3:
                        xml += ("<CURRENCY>" + strInnerText + "</CURRENCY>");
                        break;
                    case 4:
                        xml += ("<LC_AMOUNT>" + strInnerText + "</LC_AMOUNT>");
                        break;
                    case 5:
                        xml += ("<TOLERANCE_PLUS>" + strInnerText + "</TOLERANCE_PLUS>");
                        break;
                    case 6:
                        xml += ("<TOLERANCE_MINUS>" + strInnerText + "</TOLERANCE_MINUS>");
                        break;
                    case 7:
                        xml += ("<TOLERANCE_AMOUNT>" + strInnerText + "</TOLERANCE_AMOUNT>");
                        break;
                    case 8:
                        xml += ("<DRAWINGS>" + strInnerText + "</DRAWINGS>");
                        break;
                    case 9:
                        xml += ("<OUTSTANDING_LC_AMOUNT>" + strInnerText + "</OUTSTANDING_LC_AMOUNT>");
                        break;
                    case 10:
                        xml += ("<ISSUING_BANK_NAME>" + strInnerText + "</ISSUING_BANK_NAME>");
                        break;
                    case 11:
                        xml += ("<DESCRIPTION>" + strInnerText + "</DESCRIPTION>");
                        break;
                    case 12:
                        xml += ("<ISSUE_DATE>" + strInnerText + "</ISSUE_DATE>");
                        break;
                    case 13:
                        xml += ("<ADV_EXP_DATE>" + strInnerText + "</ADV_EXP_DATE>");
                        break;
                }
            }
            else {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;

                if (j === 0) {
                    xml += strInnerText.toUpperCase();
                }
                else if (j === document.getElementById("stmt").rows[i].cells.length - 1) {
                    xml += sdelimiter + strInnerText.toUpperCase();
                    xml += ("\r\n");
                } else {
                    xml += sdelimiter + strInnerText.toUpperCase();
                }
            }
        }

        if (fileType == "xml") {
            xml += ("\r\n");
        }
    }
    if (fileType == "xml") {
        xml += ("</LETTER_OF_CREDIT_RECEIVED>");
    }


    var exportNameResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        //629313HD
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + xml;
        var encodeType, csvA; //= (fileType == 'xml') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        if (fileType == 'xml') {
            encodeType = 'text/csv;charset=UTF-16LE';
            csvA = new Uint16Array(csv.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        } else {
            encodeType = 'text/csv;charset=ANSI';
            var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
            var csv1251 = '';
            for (var i = 0; i < csv.length; i++) {
                var ord = csv.charCodeAt(i);
                if (ord in DMap) {
                    csv1251 += (String.fromCharCode(DMap[ord]));
                };
            };
            csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        }
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);
    });

    popupAlert("Успешно извършен експорт за периода" + "<br/><br/>Successful data export for period", true);
}

function ExportToXMLAndTXTAllBrowsersDocumentaryCollections(nameExpFile2, fileType, sdelimiter) {
    var xml = '';
    var strCloseBalance = "";
    var table = document.getElementById("stmt");
    if (fileType == "xml") {
        //xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
        xml += ("<DOCUMENTARY_COLLECTIONS>\n");
    }

    var iRowsLength = table.rows.length;
    for (var i = 1; i < iRowsLength; i++) {

        if (i === iRowsLength - 1) {
            continue;
        }

        for (var j = 0; j < table.rows[i].cells.length; j++) {
            if (fileType == "xml") {
                var strInnerText = table.rows[i].cells[j].innerText;

                if (strInnerText != "") {

                    var re3 = /[<>&]/g;
                    strInnerText = strInnerText.replace(re3, " ");
                    if (table.classList.contains("export")) {
                        switch (j) {
                            case 0:
                                strInnerText = strInnerText.replace(/[i]/g, "");
                                xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                                break;
                            case 1:
                                xml += ("<COLLECTING_BANK>" + strInnerText + "</COLLECTING_BANK>");
                                break;
                            case 2:
                                xml += ("<DRAWEE>" + strInnerText + "</DRAWEE>");
                                break;
                            case 3:
                                xml += ("<CURRENCY>" + strInnerText + "</CURRENCY>");
                                break;
                            case 4:
                                xml += ("<AMOUNT>" + strInnerText + "</AMOUNT>");
                                break;
                            case 5:
                                xml += ("<REMITTANCE_DATE>" + strInnerText + "</REMITTANCE_DATE>");
                                break;
                            case 6:
                                xml += ("<DC_TYPE_DESCRIPTION>" + strInnerText.toUpperCase() + "</DC_TYPE_DESCRIPTION>");
                                break;
                        }
                    }
                    else {
                        switch (j) {
                            case 0:
                                strInnerText = strInnerText.replace(/[i]/g, "");
                                xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                                break;
                            case 1:
                                xml += ("<SENDING_BANK>" + strInnerText + "</SENDING_BANK>");
                                break;
                            case 2:
                                xml += ("<BENEFICIARY>" + strInnerText + "</BENEFICIARY>");
                                break;
                            case 3:
                                xml += ("<CURRENCY>" + strInnerText + "</CURRENCY>");
                                break;
                            case 4:
                                xml += ("<AMOUNT>" + strInnerText + "</AMOUNT>");
                                break;
                            case 5:
                                xml += ("<RECEIVE_DATE>" + strInnerText + "</RECEIVE_DATE>");
                                break;                          
                            case 6:
                                xml += ("<DC_TYPE_DESCRIPTION>" + strInnerText.toUpperCase() + "</DC_TYPE_DESCRIPTION>");
                                break;
                        }
                    }
                }
            }
            else {
                var strInnerText = table.rows[i].cells[j].innerText;

                if (j === 0) {
                    xml += strInnerText.toUpperCase();
                }
                else if (j === table.rows[i].cells.length - 1) {
                    xml += sdelimiter + strInnerText.toUpperCase();
                    xml += ("\r\n");
                } else {
                    xml += sdelimiter + strInnerText.toUpperCase();
                }
            }
        }

        if (fileType == "xml") {
            xml += ("\r\n");
        }
    }
    if (fileType == "xml") {
        xml += ("</DOCUMENTARY_COLLECTIONS>");
    }


    var exportNameResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function () {
        //629313HD
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + xml;
        var encodeType, csvA; //= (fileType == 'xml') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        if (fileType == 'xml') {
            encodeType = 'text/csv;charset=UTF-16LE';
            csvA = new Uint16Array(csv.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        } else {
            encodeType = 'text/csv;charset=ANSI';
            var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
            var csv1251 = '';
            for (var i = 0; i < csv.length; i++) {
                var ord = csv.charCodeAt(i);
                if (ord in DMap) {
                    csv1251 += (String.fromCharCode(DMap[ord]));
                };
            };
            csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        }
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);
    });

    popupAlert("Успешно извършен експорт за периода" + "<br/><br/>Successful data export for period", true);
}

function ExportToXMLAndTXTAllBrowsers(nameExpFile2, fileType, sACCOUNT, sFROMDATE, sTODATE, sOPENBALANCE, sWITHDETAILS, sdelimiter, sdetail, sFL_EUR_BGN, sCurrency, sCURR, sFizLize) {
    
	
    var createSimilarNum = 0;
    var debitAdvice = 0;
    var debitAdviceSDetailOn = 0;
	var xml = '';
    var strCloseBalance = "";  
    if (fileType == "xml") {
        //xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
        xml += ("<STATEMENT>\n");
        xml += ("<IBAN_S>" + sACCOUNT + "</IBAN_S>\n");
        xml += ("<FROM_ST_DATE>" + sFROMDATE + "</FROM_ST_DATE>\n");
        xml += ("<TILL_ST_DATE>" + sTODATE + "</TILL_ST_DATE>\n");
        xml += ("<OPEN_BALANCE>" + sOPENBALANCE + "</OPEN_BALANCE>\n");
    }

    var iRowsLength = document.getElementById("stmt").rows.length;
    for (var i = 0; i < iRowsLength; i++) {
        if (fileType == "xml") {
            if (i == 0 || i == (iRowsLength - 1)) continue;
            xml += ("<TRANSACTION>");
        }

        for (var j = 0; j < document.getElementById("stmt").rows[i].cells.length; j++) {
            if (sFL_EUR_BGN != "0" && sCurrency == sCURR && sFizLize == "1") {
                createSimilarNum = 6
                debitAdvice = 14;
                debitAdviceSDetailOn = 18;
                if ((i == (iRowsLength - 2)) && (j == 9))
                    strCloseBalance = document.getElementById("stmt").rows[i].cells[j].innerText + "/" + document.getElementById("stmt").rows[i].cells[j+1].innerText;
            }
            else {
                createSimilarNum = 4
                debitAdvice = 11;
                debitAdviceSDetailOn = 15;
                if ((i == (iRowsLength - 2)) && (j == 7))
                    strCloseBalance = document.getElementById("stmt").rows[i].cells[j].innerText;
            }
           
            if (fileType == "xml") {
                var strInnerText = document.getElementById("stmt").rows[i].cells[j].innerText;
                if (j == 1 && strInnerText == "") {
                    strInnerText = "00:00";
                }
                if (strInnerText != "") {

                    var re3 = /[<>&]/g;
                    strInnerText = strInnerText.replace(re3, " ");

                    switch (j) {
                        case 0:
                            strInnerText = strInnerText.replace(/[i]/g, "");
                            xml += ("<POST_DATE>" + strInnerText + "</POST_DATE>");
                            break;
                        case 1:
                            xml += ("<TIME>" + strInnerText + "</TIME>");
                            break;
                        case 2:
                            xml += ("<AMOUNT_D>" + strInnerText + "</AMOUNT_D>");
                            break;
                        case 3:
                            xml += ("<AMOUNT_C>" + strInnerText + "</AMOUNT_C>");
                            break;
                        case 5:
                            xml += ("<TR_NAME>" + strInnerText + "</TR_NAME>");
                            break;
                        case 6:
                            xml += ("<NAME_R>" + strInnerText + "</NAME_R>");
                            break;
                        case 8:
                            xml += ("<REM_I>" + strInnerText + "</REM_I>");
                            break;
                        case 9:
                            xml += ("<REM_II>" + strInnerText + "</REM_II>");
                            break;
                        case 10:
                            xml += ("<REFERENCE>" + strInnerText + "</REFERENCE>");
                            break;
                        case 11:
                            if (sdetail == "on") {
                                var aContr = strInnerText.split("|");
                                if (aContr.length > 0) xml += ("<BIC_R>" + aContr[0] + "</BIC_R>");
                                if (aContr.length > 1) xml += ("<IBAN_R>" + aContr[1] + "</IBAN_R>");

                                if (aContr.length < 3) break;
                                if (aContr.length > 2) {
                                    if (aContr[2] != "") xml += ("<PAY_R>" + aContr[2] + "</PAY_R>")
                                }
                                if (aContr.length > 3) {
                                    if (aContr[3] != "") xml += ("<BULSTAT>" + aContr[3] + "</BULSTAT>");
                                }
                                if (aContr.length > 4) {
                                    if (aContr[4] != "") xml += ("<EGN>" + aContr[4] + "</EGN>");
                                }
                                if (aContr.length > 5) {
                                    if (aContr[5] != "") xml += ("<LNC>" + aContr[5] + "</LNC>");
                                }
                                if (aContr.length > 6) {
                                    if (aContr[6] != "") xml += ("<OBLIG_NAME>" + aContr[6] + "</OBLIG_NAME>");
                                }
                                if (aContr.length > 7) {
                                    if (aContr[7] != "") xml += ("<TYPEDOCNO>" + aContr[7] + "</TYPEDOCNO>");
                                }
                                if (aContr.length > 8) {
                                    if (aContr[8] != "") xml += ("<DOCDATE>" + aContr[8] + "</DOCDATE>");
                                }
                                if (aContr.length > 9) {
                                    if (aContr[9] != "") xml += ("<FROMDATE>" + aContr[9] + "</FROMDATE>");
                                }
                                if (aContr.length > 10) {
                                    if (aContr[10] != "") xml += ("<TODATE>" + aContr[10] + "</TODATE>");
                                }
                                if (aContr.length > 11) {
                                    if (aContr[11] != "") xml += ("<PAY_S>" + aContr[10] + "</PAY_S>");
                                }
                            }
                            break;
                        case 12:
                            if (sdetail == "on") {
                                xml += ("<DATETRANS>" + strInnerText + "</DATETRANS>");
                            }
                            break;
                        case 13:
                            xml += ("<DATEVAL>" + strInnerText + "</DATEVAL>");
                            break;
                        case 14:
                            var aREM = strInnerText.split("|");
                            if (aREM.length > 0) {
                                for (k = 0; k < aREM.length; k++) {
                                    var m = k + 1;
                                    xml += ("<MORE" + m + ">" + aREM[k] + "</MORE" + m + ">");
                                }
                            }
                            break;
                    }
                }
            }
            else {
                if (j) {
                    if (sdetail == "on" && j != debitAdviceSDetailOn && j != createSimilarNum) {
                        xml += (sdelimiter);
                    }
                    if (sdetail == "" && j != debitAdvice && j != createSimilarNum) {
                        xml += (sdelimiter);
                    }
                }
                if ((sdetail == "" && (j == document.getElementById("stmt").rows[i].cells.length - 8) && (i == (iRowsLength - 1))) || (sdetail == "on" && (j == document.getElementById("stmt").rows[i].cells.length - 12) && (i == (iRowsLength - 1)))) {
                    var next = "Total:" + sdelimiter + sACCOUNT + sdelimiter + sFROMDATE + sdelimiter + sTODATE + sdelimiter + sOPENBALANCE.replace(/\s+|[a-zA-z]/g, "") + sdelimiter + strCloseBalance + sdelimiter + (i - 1) + sdelimiter + document.getElementById("stmt").rows[i].cells[2].innerText + sdelimiter + document.getElementById("stmt").rows[i].cells[3].innerText + sdelimiter;
                    xml += (next);
                    break;
                }
                if (j == 1 && document.getElementById("stmt").rows[i].cells[j].innerText.length == 0) {
                    xml += ("00:00");
                }
                else {
                    if (sdetail == "on") {
                        if (j != debitAdviceSDetailOn && j != createSimilarNum) {

                            var strInnerTxt = (i == 0) ? document.getElementById("stmt").rows[i].cells[j].innerText.toUpperCase() : document.getElementById("stmt").rows[i].cells[j].innerText;


                            if (j == 0)
                                strInnerTxt = strInnerTxt.replace(/[i]/g, "");
								
								
								strInnerTxt = strInnerTxt.replace(/(\n)/gm, "");
								strInnerTxt = strInnerTxt.trim();
								
							   xml += (strInnerTxt);
								
                            
							
							
                        }
                    }
                    else {
                        if (j != debitAdvice && j != createSimilarNum) {
                            var strInnerTxt = (i == 0) ? document.getElementById("stmt").rows[i].cells[j].innerText.toUpperCase() : document.getElementById("stmt").rows[i].cells[j].innerText;
                            if (j == 0)
                                strInnerTxt = strInnerTxt.replace(/[i]/g, "");
								
								strInnerTxt = strInnerTxt.replace(/(\n)/gm, "");
								strInnerTxt = strInnerTxt.trim();
								
                           // strInnerTxt = strInnerTxt.replace("Счетоводна дата", "Счет.дата");
						     xml += (strInnerTxt);
                        }
                    }
                }
            }
        }

        if (fileType == "xml") {
            xml += ("</TRANSACTION>");
        }
        xml += ("\r\n");
    }
    if (fileType == "xml") {
        xml += ("<CLOSE_BALANCE>" + strCloseBalance + "</CLOSE_BALANCE>\n");
        xml += ("</STATEMENT>");
    }

    var additionalInfo = (sWITHDETAILS != "on") ? "без" : "с";
    var additionalInfoEN = (sWITHDETAILS != "on") ? "without" : "with";
    
    var exportNameResult = nameExpFile2 + "." + fileType;
    $.getScript('web/js-fileServer/file-server.js', function()
    {     
		//629313HD
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + xml;
        var encodeType, csvA; //= (fileType == 'xml') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        if (fileType == 'xml') {
            encodeType = 'text/csv;charset=UTF-16LE';
            csvA = new Uint16Array(csv.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        } else {
            encodeType = 'text/csv;charset=ANSI';
            var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
            var csv1251 = '';
            for (var i = 0; i < csv.length; i++) {
                var ord = csv.charCodeAt(i);
                if (ord in DMap) {
                    csv1251 += (String.fromCharCode(DMap[ord]));
                };
            };
            csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
                return k.charCodeAt(0);
            }));
        }
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);  
    });
    
	

    popupAlert("Успешно извършен експорт за периода " + sFROMDATE + " - " + sTODATE + " " + additionalInfo + " допълнителна информация във файл " + exportNameResult + "<br/><br/>Successful data export for period " + sFROMDATE + " - " + sTODATE + " " + additionalInfoEN + " additional info in file " + exportNameResult,
    true); 
}
function appendHTMLFromFormToAnother(fromFormId, toFormId) {
    var fromForm = document.getElementById(fromFormId);
    var toForm = document.getElementById(toFormId);

    if (fromForm && toForm) {
        // toForm.innerHTML += fromForm.innerHTML;
        toForm.insertAdjacentHTML('beforeend', fromForm.innerHTML);
    }
}

/************************** Export to File ***************************/
function ExportToFile(idForm) {
    try {
            var F = document.getElementById(idForm);
            var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
            var fileType = GetAllValues1(F.elements["file_type"]); 
            var sACCOUNT = GetAllValues1(F.elements["ACCOUNT"]);
            var sFROMDATE = GetAllValues1(F.elements["FROMDATE"]);
            var sTODATE = GetAllValues1(F.elements["TODATE"]);
            var sOPENBALANCE = GetAllValues1(F.elements["OPENBALANCE"]);
            var sWITHDETAILS = GetAllValues1(F.elements["WITHDETAILS"]);
            var sdelimiter = GetAllValues1(F.elements["DELIMITER"]);
            var sdetail = GetAllValues1(F.elements["WITHDETAILS"]);

            //Dual visualization fields
            var sFL_EUR_BGN = GetAllValues1(document.getElementById("FL_EUR_BGN"));
            var sCurrency = GetAllValues1(document.getElementById("Currency"));
            var sCURR = GetAllValues1(document.getElementById("CURR"));
            var sFizLize = GetAllValues1(document.getElementById("FizLize"));


            if (nameExpFile2 == "") {
                popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
                F.elements["export_file2"].focus();
                return;
            }

            if (fileType == "xls") {  // .xls            
                var additionalInfo = (sWITHDETAILS != "on") ? "без" : "с";
                var additionalInfoEN = (sWITHDETAILS != "on") ? "without" : "with";      
                return ExportToExelAllBrowsers(nameExpFile2, 
                    fileType, 
                    sFROMDATE, 
                    sTODATE, 
                    additionalInfo, 
                    additionalInfoEN,
                    sdetail,
                    sFL_EUR_BGN,
                    sCurrency,
                    sCURR,
                    sFizLize);   
            } else { // .txt .xml                          
                return ExportToXMLAndTXTAllBrowsers(nameExpFile2, 
                    fileType,
                    sACCOUNT,
                    sFROMDATE,
                    sTODATE,
                    sOPENBALANCE,
                    sWITHDETAILS,
                    sdelimiter,
                    sdetail,
                    sFL_EUR_BGN,
                    sCurrency,
                    sCURR,
                    sFizLize
                );         
            }
     }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileBankGuarantees(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sdelimiter = '|';


        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        if (fileType == "xls") {
            return ExportToExcelAllBrowsersBankGuaranteesIssued(nameExpFile2,
                fileType);
        } else { // .txt .xml                          
            return ExportToXMLAndTXTAllBrowsersBankGuaranteesIssued(nameExpFile2,
                fileType,
                sdelimiter
            );
        }
    }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileBankGuaranteesReceived(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sdelimiter = '|';


        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        if (fileType == "xls") {
            return ExportToExcelAllBrowsersBankGuaranteesReceived(nameExpFile2,
                fileType);
        } else { // .txt .xml                          
            return ExportToXMLAndTXTAllBrowsersBankGuaranteesReceived(nameExpFile2,
                fileType,
                sdelimiter
            );
        }
    }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileLetterOfCreditsIssued(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sdelimiter = '|';


        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        if (fileType == "xls") {
            return ExportToExcelAllBrowsersLetterOfCreditIssued(nameExpFile2,
                fileType);
        } else { // .txt .xml                          
            return ExportToXMLAndTXTAllBrowsersLetterOfCreditIssued(nameExpFile2,
                fileType,
                sdelimiter
            );
        }
    }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileLetterOfCreditsReceived(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sdelimiter = '|';


        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        if (fileType == "xls") {
            return ExportToExcelAllBrowsersLetterOfCreditReceived(nameExpFile2,
                fileType);
        } else { // .txt .xml                          
            return ExportToXMLAndTXTAllBrowsersLetterOfCreditReceived(nameExpFile2,
                fileType,
                sdelimiter
            );
        }
    }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileDocumentaryCollections(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sdelimiter = '|';


        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        if (fileType == "xls") {
            return ExportToExcelAllBrowsersDocumentaryCollections(nameExpFile2,
                fileType);
        } else { // .txt .xml                          
            return ExportToXMLAndTXTAllBrowsersDocumentaryCollections(nameExpFile2,
                fileType,
                sdelimiter
            );
        }
    }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileAdmin(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);


        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }


        return ExportToExelAllBrowsersAdmin(nameExpFile2, fileType);

    }
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}
 
function ExportToFileReqHistory(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sFROMDATE = GetAllValues1(F.elements["FROMDATE"]);
        var sTODATE = GetAllValues1(F.elements["TODATE"]);
        var sdetail = GetAllValues1(F.elements["WITHDETAILS"]);

        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }
        return ExportToExelAllBrowsersReqHistory(nameExpFile2,
            fileType,
            sFROMDATE,
            sTODATE,
            sdetail);
    }
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function ExportToFileRightsManagement(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);
        /* var sdetail = GetAllValues1(F.elements["WITHDETAILS"]);*/
        var title1 = GetAllValues1(F.elements["TitleTable1"]);
        var title2 = GetAllValues1(F.elements["TitleTable2"]);

        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }
        return ExportToExelAllBrowsersRightsManagement(nameExpFile2,
            fileType,
            title1,
            title2
        );
    }
    //end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

//
function insertDate(idForm)
{
    var F = document.getElementById(idForm);
   
    var fromDate = GetAllValues1(F.elements["FROMDATE"]);
    
    var arrayFromDate = new Array();
    arrayFromDate = fromDate.split("/");
    fromDate = arrayFromDate[0] + arrayFromDate[1] + arrayFromDate[2];
   

    var toDate = GetAllValues1(F.elements["TODATE"]);
    var arrayToDate = new Array();
    arrayToDate = toDate.split("/");
    toDate = arrayToDate[0] + arrayToDate[1] + arrayToDate[2];
    


    var export_file = GetAllValues1(F.elements["export_file"]);

   // F.elements["export_file"].value = "ExportPeriod_" + fromDate + "_" + toDate;
    F.elements["export_file2"].value = "ExportPeriod_" + fromDate + "_" + toDate;

    




}



//
//9668
function ExportToFileStat(idForm) {
    try {
        // if (typeof ActiveXObject != "undefined") {
        if (window.clipboardData) {
            var F = document.getElementById(idForm);
            var nameExpFile = GetAllValues1(F.elements["export_file"]);
            var nameExpFileExt = nameExpFile.substr(nameExpFile.length - 3);
            var nameExpFile2 = GetAllValues1(F.elements["export_file2"]);
            var nameExpFileExt2 = nameExpFile2.substr(nameExpFile2.length - 3);
            var fileType = GetAllValues1(F.elements["file_type"]);
            var sACCOUNT = GetAllValues1(F.elements["ACCOUNT"]);
            var sFROMDATE = GetAllValues1(F.elements["FROMDATE"]);
            var sTODATE = GetAllValues1(F.elements["TODATE"]);
            var sOPENBALANCE = GetAllValues1(F.elements["OPENBALANCE"]);
            var sWITHDETAILS = GetAllValues1(F.elements["WITHDETAILS"]);
            var sdelimiter = GetAllValues1(F.elements["DELIMITER"]);
            var sdetail = GetAllValues1(F.elements["WITHDETAILS"]);


            if (nameExpFile != "" && nameExpFile2 != "") {
                popupAlert("Моля, направете само едното действие – изберете файл или въведете име!<br/>Please, do only one – choose file or input a name!");
                F.elements["export_file"].focus();
                return;
            }
            if (nameExpFile == "" && nameExpFile2 == "") {
                popupAlert("Моля, изберете или въведете име на файл!<br/>Please, choose or input file name!");
                F.elements["export_file"].focus();
                return;
            }

            var fso = new ActiveXObject("Scripting.FileSystemObject");
            if (nameExpFile2 != "") {
                nameExpFile = nameExpFile2;
                nameExpFileExt = nameExpFileExt2;
                var f = fso.CreateTextFile(nameExpFile, true, (fileType == "xml") ? -1 : 0);
            }
            else {
                var f = fso.OpenTextFile(nameExpFile, 2, true, (fileType == "xml") ? -1 : 0);
            }

            var strCloseBalance = "";
            if (((nameExpFileExt.toLowerCase() == "txt") && (fileType != "txt")) ||
               ((nameExpFileExt.toLowerCase() == "xml") && (fileType != "xml"))) {
                popupAlert("Несъвпадение между име и тип на посочения файл!<br/>Wrong correspondence file type and file extension!");
                F.elements["export_file"].focus();

                return;
            }

            if (fileType == "xml") {
                f.Write("<STATEMENT>\n");
                f.Write("<IBAN_S>" + sACCOUNT + "</IBAN_S>\n");
                f.Write("<FROM_ST_DATE>" + sFROMDATE + "</FROM_ST_DATE>\n");
                f.Write("<TILL_ST_DATE>" + sTODATE + "</TILL_ST_DATE>\n");
                f.Write("<OPEN_BALANCE>" + sOPENBALANCE + "</OPEN_BALANCE>\n");
            }

            var iRowsLength = document.all.stmtPr.rows.length;
            for (var i = 0; i < iRowsLength; i++) {
                if (fileType == "xml") {
                    if (i == 0 || i == (iRowsLength - 1)) continue;
                    f.Write("<TRANSACTION>");
                }
                for (var j = 0; j < document.all.stmtPr.rows(i).cells.length; j++) {
                    if ((i == (iRowsLength - 2)) && (j == 6))
                        strCloseBalance = document.all.stmtPr.rows(i).cells(j).innerText;
                    if (fileType == "xml") {
                        var strInnerText = document.all.stmtPr.rows(i).cells(j).innerText;
                        if (j == 1 && strInnerText == "") {
                            strInnerText = "00:00";
                        }
                        if (strInnerText != "") {

                            var re3 = /[<>&]/g;
                            strInnerText = strInnerText.replace(re3, " ");

                            switch (j) {
                                case 0:
                                    strInnerText = strInnerText.replace(/[i]/g, "");
                                    f.Write("<POST_DATE>" + strInnerText + "</POST_DATE>");
                                    break;
                                case 1:
                                    f.Write("<TIME>" + strInnerText + "</TIME>");
                                    break;
                                case 2:
                                    f.Write("<AMOUNT_D>" + strInnerText + "</AMOUNT_D>");
                                    break;
                                case 3:
                                    f.Write("<AMOUNT_C>" + strInnerText + "</AMOUNT_C>");
                                    break;
                                case 4:
                                    f.Write("<TR_NAME>" + strInnerText + "</TR_NAME>");
                                    break;
                                case 5:
                                    f.Write("<NAME_R>" + strInnerText + "</NAME_R>");
                                    break;
                                case 7:
                                    f.Write("<REM_I>" + strInnerText + "</REM_I>");
                                    break;
                                case 8:
                                    f.Write("<REM_II>" + strInnerText + "</REM_II>");
                                    break;
                                case 9:
                                    f.Write("<REFERENCE>" + strInnerText + "</REFERENCE>");
                                    break;
                                case 10:
                                    if (sdetail == "on") {
                                        var aContr = strInnerText.split("|");
                                        if (aContr.length > 0) f.Write("<BIC_R>" + aContr[0] + "</BIC_R>");
                                        if (aContr.length > 1) f.Write("<IBAN_R>" + aContr[1] + "</IBAN_R>");

                                        if (aContr.length < 3) break;
                                        if (aContr.length > 2) {
                                            if (aContr[2] != "") f.Write("<PAY_R>" + aContr[2] + "</PAY_R>")
                                        }
                                        if (aContr.length > 3) {
                                            if (aContr[3] != "") f.Write("<BULSTAT>" + aContr[3] + "</BULSTAT>");
                                        }
                                        if (aContr.length > 4) {
                                            if (aContr[4] != "") f.Write("<EGN>" + aContr[4] + "</EGN>");
                                        }
                                        if (aContr.length > 5) {
                                            if (aContr[5] != "") f.Write("<LNC>" + aContr[5] + "</LNC>");
                                        }
                                        if (aContr.length > 6) {
                                            if (aContr[6] != "") f.Write("<OBLIG_NAME>" + aContr[6] + "</OBLIG_NAME>");
                                        }
                                        if (aContr.length > 7) {
                                            if (aContr[7] != "") f.Write("<TYPEDOCNO>" + aContr[7] + "</TYPEDOCNO>");
                                        }
                                        if (aContr.length > 8) {
                                            if (aContr[8] != "") f.Write("<DOCDATE>" + aContr[8] + "</DOCDATE>");
                                        }
                                        if (aContr.length > 9) {
                                            if (aContr[9] != "") f.Write("<FROMDATE>" + aContr[9] + "</FROMDATE>");
                                        }
                                        if (aContr.length > 10) {
                                            if (aContr[10] != "") f.Write("<TODATE>" + aContr[10] + "</TODATE>");
                                        }
                                        if (aContr.length > 11) {
                                            if (aContr[11] != "") f.Write("<PAY_S>" + aContr[10] + "</PAY_S>");
                                        }
                                    }
                                    break;
                                case 11:
                                    if (sdetail == "on") {
                                        f.Write("<DATETRANS>" + strInnerText + "</DATETRANS>");
                                    }
                                    break;
                                case 12:
                                    f.Write("<DATEVAL>" + strInnerText + "</DATEVAL>");
                                    break;
                                case 13:
                                    var aREM = strInnerText.split("|");
                                    if (aREM.length > 0) {
                                        for (k = 0; k < aREM.length; k++) {
                                            var m = k + 1;
                                            f.Write("<MORE" + m + ">" + aREM[k] + "</MORE" + m + ">");
                                        }
                                    }
                                    break;
                            }
                        }
                    }
                    else {
                        if (j) {
                            if (sdetail == "on" && j != 14) {
                                f.Write(sdelimiter);
                            }
                            if (sdetail == "" && j != 10) {
                                f.Write(sdelimiter);
                            }
                        }
                        if ((sdetail == "" && (j == document.all.stmtPr.rows(i).cells.length - 8) && (i == (iRowsLength - 1))) || (sdetail == "on" && (j == document.all.stmtPr.rows(i).cells.length - 12) && (i == (iRowsLength - 1)))) {
                            var next = "Total:" + sdelimiter + sACCOUNT + sdelimiter + sFROMDATE + sdelimiter + sTODATE + sdelimiter + sOPENBALANCE + sdelimiter + strCloseBalance + sdelimiter + (i - 1) + sdelimiter + document.all.stmtPr.rows(i).cells(2).innerText + sdelimiter + document.all.stmtPr.rows(i).cells(3).innerText + sdelimiter;
                            f.Write(next);
                            break;
                        }
                        if (j == 1 && document.all.stmtPr.rows(i).cells(j).innerText.length == 0) {
                            f.Write("00:00");
                        }
                        else {
                            if (sdetail == "on") {
                                if (j != 14) {
                                    var strInnerTxt = document.all.stmtPr.rows(i).cells(j).innerText;
                                    if (j == 0)
                                        strInnerTxt = strInnerTxt.replace(/[i]/g, "");
                                    f.Write(strInnerTxt);
                                }
                            }
                            else {
                                if (j != 10) {
                                    var strInnerTxt = document.all.stmtPr.rows(i).cells(j).innerText;
                                    if (j == 0)
                                        strInnerTxt = strInnerTxt.replace(/[i]/g, "");
                                    strInnerTxt = strInnerTxt.replace("Счетоводна дата", "Счет.дата");
                                    f.Write(strInnerTxt);
                                }
                            }
                        }
                    }
                }

                if (fileType == "xml") {
                    f.Write("</TRANSACTION>");
                }
                f.Write("\r\n");
            }
            if (fileType == "xml") {
                f.Write("<CLOSE_BALANCE>" + strCloseBalance + "</CLOSE_BALANCE>\n");
                f.Write("</STATEMENT>");
            }


            f.Close();
            f = null;
            fso = null;
            var additionalInfo = (sWITHDETAILS != "on") ? "без" : "с";
            var additionalInfoEN = (sWITHDETAILS != "on") ? "without" : "with";

            popupAlert("Успешно извършен експорт за периода " + sFROMDATE + " - " + sTODATE + " " + additionalInfo + " допълнителна информация във файл с път " + nameExpFile + "<br/><br/>Successful data export for period " + sFROMDATE + " - " + sTODATE + " " + additionalInfoEN + " additional info in file " + nameExpFile,
                true);

        }
        else {
            popupAlert('Функцията изисква Internet Explorer. <br/> This function requires Internet Explorer.');
            return;
        }
    }//end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}
/************************** Export to File ***************************/


/************************** Export to File EINVOICE ***************************/
function ExportToFileEINVOICE(idForm) {
    try {
        //if (typeof ActiveXObject != "undefined") 
        //{


        var F = document.getElementById(idForm);
        var nameExpFile = GetAllValues1(F.elements["export_file"]);
        var nameExpFileExt = nameExpFile.substr(nameExpFile.length - 3);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]);
        var nameExpFileExt2 = nameExpFile2.substr(nameExpFile2.length - 3);
        var fileType = GetAllValues1(F.elements["file_type"]);

        if (idForm == "frmRECIPIENT2") {
            var F1 = document.getElementById("frmRECIPIENT1");
            var F2 = document.getElementById("frmRECIPIENT");
        }
        else {
            var F1 = document.getElementById("frmBILLER1");
            var F2 = document.getElementById("frmBILLER");
        }

        var sFROMDATE = GetAllValues1(F2.elements["FROMDATE"]);
        var sTODATE = GetAllValues1(F2.elements["TODATE"]);
        var sSTATUS = GetAllValues1(F2.elements["BNSTATEXPORT"]);
        var sTYPE_REPORT = GetAllValues1(F2.elements["CLSTAT1"]);
        var sdelimiter = GetAllValues1(F.elements["DELIMITER"]);

        var sCurrentPage = GetAllValues1(F1.elements["CurrentPage"]);
        var sAllPages = GetAllValues1(F1.elements["AllPages"]);
        var sCountCurrentPage = GetAllValues1(F1.elements["CountCurrentPage"]);
        var sAllRecord = GetAllValues1(F1.elements["AllRecord"]);

        if (sSTATUS == "")
            sSTATUS = "ВСИЧКИ";

        if (nameExpFile != "" && nameExpFile2 != "") {
            popupAlert("Моля, направете само едното действие – изберете файл или въведете име!<br/>Please, do only one – choose file or input a name!");
            return;
        }
        if (nameExpFile == "" && nameExpFile2 == "") {
            popupAlert("Моля, изберете или въведете име на файл!<br/>Please, choose or input file name!");
            return;
        }

        var fso = new ActiveXObject("Scripting.FileSystemObject");
        if (nameExpFile2 != "") {
            nameExpFile = nameExpFile2;
            nameExpFileExt = nameExpFileExt2;
            var f = fso.CreateTextFile(nameExpFile, true, (fileType == "xml") ? -1 : 0);
        }
        else {
            var f = fso.OpenTextFile(nameExpFile, 2, true, (fileType == "xml") ? -1 : 0);
        }

        var strCloseBalance = "";
        if (((nameExpFileExt.toLowerCase() == "txt") && (fileType != "txt")) ||
           ((nameExpFileExt.toLowerCase() == "xml") && (fileType != "xml"))) {
            popupAlert("Несъвпадение между име и тип на посочения файл!<br/>Wrong correspondence file type and file extension!");
            F.elements["export_file"].value = "";
            return;
        }

        var iRowsLength = document.all.billinfoEinv.rows.length;
        var sCountEINV = document.all.billinfoEinv.rows.length - 1;


        if (fileType == "xml") {
            f.Write("<EINVOICES>\n");
            f.Write("<TYPE_REPORT>" + sTYPE_REPORT + "</TYPE_REPORT>\n");
            f.Write("<STATUS_NAME>" + sSTATUS + "</STATUS_NAME>\n");
            f.Write("<FROM_ST_DATE>" + sFROMDATE + "</FROM_ST_DATE>\n");
            f.Write("<TILL_ST_DATE>" + sTODATE + "</TILL_ST_DATE>\n");
            f.Write("<CURRENT_PAGE>" + sCurrentPage + "</CURRENT_PAGE>\n");
            f.Write("<TOTAL_PAGES>" + sAllPages + "</TOTAL_PAGES>\n");
            f.Write("<RECORDS_PER_PAGE>" + sCountCurrentPage + "</RECORDS_PER_PAGE>\n");
            f.Write("<TOTAL_EINVOICE>" + sAllRecord + "</TOTAL_EINVOICE>\n");
        }

        for (var i = 0; i < iRowsLength; i++) {
            if (fileType == "xml") {
                if (i == 0 || i == (iRowsLength)) continue;
                f.Write("<EINVOICE>");
            }
            for (var j = 0; j < document.all.billinfoEinv.rows(i).cells.length; j++) {
                if (fileType == "xml") {
                    var strInnerText = document.all.billinfoEinv.rows(i).cells(j).innerText;
                    if (strInnerText != "") {
                        var re3 = /[<>&]/g;
                        strInnerText = strInnerText.replace(re3, " ");

                        if (idForm == "frmRECIPIENT2") {

                            switch (j) {
                                case 0:
                                    f.Write("<STATUS>" + strInnerText + "</STATUS>");
                                    break;
                                case 2:
                                    f.Write("<EINVOICE_NUMBER>" + strInnerText + "</EINVOICE_NUMBER>");
                                    break;
                                case 3:
                                    f.Write("<INVOICE_DATE>" + strInnerText + "</INVOICE_DATE>");
                                    break;
                                case 4:
                                    f.Write("<TYPE>" + strInnerText + "</TYPE>");
                                    break;
                                case 5:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<BILLER_BULSTAT>" + strInnerText + "</BILLER_BULSTAT>");
                                    }
                                    else {
                                        f.Write("<RECIPIENT_BULSTAT_EGN>" + strInnerText + "</RECIPIENT_BULSTAT_EGN>");
                                    }
                                    break;
                                case 6:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<BILLER_NAME>" + strInnerText + "</BILLER_NAME>");
                                    }
                                    else {
                                        f.Write("<RECIPIENT_NAME>" + strInnerText + "</RECIPIENT_NAME>");
                                    }
                                    break;
                                case 7:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<BILLER_IBAN>" + strInnerText + "</BILLER_IBAN>");
                                    }
                                    else {
                                        f.Write("<RECIPIENT_IBAN>" + strInnerText + "</RECIPIENT_IBAN>");
                                    }
                                    break;
                                case 8:
                                    f.Write("<AMOUNT>" + strInnerText + "</AMOUNT>");
                                    break;
                                case 9:
                                    f.Write("<CURRENCY>" + strInnerText + "</CURRENCY>");
                                    break;
                                case 10:
                                    f.Write("<REM_I>" + strInnerText + "</REM_I>");
                                    break;
                                case 11:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<RECIPIENT_NAME>" + strInnerText + "</RECIPIENT_NAME>");
                                    }
                                    else {
                                        f.Write("<BILLER_NAME>" + strInnerText + "</BILLER_NAME>");
                                    }
                                    break;
                                case 12:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<RECIPIENT_IBAN>" + strInnerText + "</RECIPIENT_IBAN>");
                                    }
                                    else {
                                        f.Write("<BILLER_IBAN>" + strInnerText + "</BILLER_IBAN>");
                                    }
                                    break;
                            }
                        }
                        else {
                            switch (j) {
                                case 1:
                                    f.Write("<STATUS>" + strInnerText + "</STATUS>");
                                    break;
                                case 3:
                                    f.Write("<EINVOICE_NUMBER>" + strInnerText + "</EINVOICE_NUMBER>");
                                    break;
                                case 4:
                                    f.Write("<INVOICE_DATE>" + strInnerText + "</INVOICE_DATE>");
                                    break;
                                case 5:
                                    f.Write("<TYPE>" + strInnerText + "</TYPE>");
                                    break;
                                case 6:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<BILLER_BULSTAT>" + strInnerText + "</BILLER_BULSTAT>");
                                    }
                                    else {
                                        f.Write("<RECIPIENT_BULSTAT_EGN>" + strInnerText + "</RECIPIENT_BULSTAT_EGN>");
                                    }
                                    break;
                                case 7:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<BILLER_NAME>" + strInnerText + "</BILLER_NAME>");
                                    }
                                    else {
                                        f.Write("<RECIPIENT_NAME>" + strInnerText + "</RECIPIENT_NAME>");
                                    }
                                    break;
                                case 8:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<BILLER_IBAN>" + strInnerText + "</BILLER_IBAN>");
                                    }
                                    else {
                                        f.Write("<RECIPIENT_IBAN>" + strInnerText + "</RECIPIENT_IBAN>");
                                    }
                                    break;
                                case 9:
                                    f.Write("<AMOUNT>" + strInnerText + "</AMOUNT>");
                                    break;
                                case 10:
                                    f.Write("<CURRENCY>" + strInnerText + "</CURRENCY>");
                                    break;
                                case 11:
                                    f.Write("<REM_I>" + strInnerText + "</REM_I>");
                                    break;
                                case 12:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<RECIPIENT_NAME>" + strInnerText + "</RECIPIENT_NAME>");
                                    }
                                    else {
                                        f.Write("<BILLER_NAME>" + strInnerText + "</BILLER_NAME>");
                                    }
                                    break;
                                case 13:
                                    if (idForm == "frmRECIPIENT2") {
                                        f.Write("<RECIPIENT_IBAN>" + strInnerText + "</RECIPIENT_IBAN>");
                                    }
                                    else {
                                        f.Write("<BILLER_IBAN>" + strInnerText + "</BILLER_IBAN>");
                                    }
                                    break;
                            }
                        }
                    }
                }
                else {

                    if ((j) && (j > 1) && document.all.billinfoEinv.rows(i).cells(j).style.display != "none") {
                        f.Write(sdelimiter);
                    }
                    if (idForm == "frmRECIPIENT2") {
                        if (j != 1)
                            f.Write(document.all.billinfoEinv.rows(i).cells(j).innerText.replace(/[\r\n]/g, " "));
                    }
                    else {
                        if (j != 0 && j != 2)
                            f.Write(document.all.billinfoEinv.rows(i).cells(j).innerText.replace(/[\r\n]/g, " "));
                    }


                    if (i == (iRowsLength - 1) && (j == document.all.billinfoEinv.rows(i).cells.length - 1)) {
                        f.Write("\r\n");
                        var next = "Total:" + sdelimiter + sTYPE_REPORT + sdelimiter + sSTATUS + sdelimiter + sFROMDATE + sdelimiter + sTODATE + sdelimiter + (i) + sdelimiter + sCurrentPage + sdelimiter + sAllPages + sdelimiter + sAllRecord + sdelimiter + sCountCurrentPage; //+ sdelimiter + document.all.stmt.rows(i).cells(2).innerText + sdelimiter + document.all.stmt.rows(i).cells(3).innerText + sdelimiter;
                        f.Write(next);
                    }

                }
            }
            if (fileType == "xml")
                f.Write("</EINVOICE>");
            f.Write("\r\n");
        }
        if (fileType == "xml") {
            f.Write("</EINVOICES>");
        }
        f.Close();
        f = null;
        fso = null;

        popupAlert("Успешно извършен експорт за периода " + sFROMDATE + " - " + sTODATE + " допълнителна информация във файл с път " + nameExpFile + "<br/><br/>Successful data export for period " + sFROMDATE + " - " + sTODATE + " additional info in file " + nameExpFile);

    }//end try
    catch (e) {
        popupAlert(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/><br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}
/************************** Export to File EINVOICE ***************************/

function zStr(dig, l) {
    var ret = "";
    var t = "" + dig;

    if (t.length <= l) {
        for (var i = 0; i < l - t.length; i++)
            ret = ret + "0";
        ret = ret + t;
    }
    return ret;
}

function setSysDate(elemname, idForm) {
    var d = new Date();
    var year = ((d.getYear() < 1900) ? 1900 : 0) + d.getYear();
    Today = zStr(d.getDate(), 2) + zStr((d.getMonth() + 1), 2) + year;
    var F = document.getElementById(idForm);
    F.elements[elemname].value = Today;
}

function setDateNow(elemname, idForm) {
    var d = new Date();
    Today = zStr(d.getDate(), 2) + "/" + zStr((d.getMonth() + 1), 2) + "/" + (((d.getYear() < 1900) ? 1900 : 0) + d.getYear());
    document.getElementById(idForm)[elemname].value = Today;
}

function setAmount(idForm) {
    var F = document.getElementById(idForm);
    var sAMT_R = F.elements["AMOUNT_R"].value;
    var sAMT_S = F.elements["AMOUNT_S"].value;
    var sCURR_R = F.elements["CURR_R"].value;
    var sCURR_S = F.elements["CURR_S"].value;

    if ((sAMT_R != "" && sAMT_S != "") || (sAMT_R == "" && sAMT_S == "")) {
        createCustomAlertDeclaration("Моля, въведете дебитна сума ИЛИ кредитна сума!<br/>Please, fill in debit OR credit amount!"); //8365 - Vili
        F.elements["AMOUNT_R"].focus();
        return false;
    }

    if ((sAMT_R != "") && (sCURR_R != "")) {
        F.elements["AMOUNT"].value = sAMT_R;
        F.elements["CURR"].value = F.elements["CURR_R"].value;
    }
    else if ((sAMT_S != "") && (sCURR_S != "")) {
        F.elements["AMOUNT"].value = sAMT_S;
        F.elements["CURR"].value = F.elements["CURR_S"].value;
    }
    return true;
}

function FillPartners(idForm, sACC_R, sBIC_R, sNAME_R, sBN_R) {
    try {
        var F = document.getElementById(idForm);

        F.elements["NAME_R"].value = sNAME_R;
        F.elements["ACC_R"].value = sACC_R;
        if (F.elements["BIC_R"]) {
            F.elements["BIC_R"].value = sBIC_R;
            F.elements["BN_R"].value = sBN_R;
        }
    }
    catch (e) {
        alert(e.description);
    }

}





function FillPartnersReD(idForm, strData,sT) {//8365    , ORDNAME
    try {
        var F = document.getElementById(idForm);
        var aValues = (strData + "").split("|");

        F.elements["NAME_R"].value = aValues[2];
        $('#NAME_R').blur();
       
        F.elements["ACC_R"].value = aValues[0];
        F.elements["TEMPL"].value = sT;
        if (F.elements["TmplId"]) {
            F.elements["TmplId"].value = aValues[4];
        }
        $('#ACC_R').blur();
        if (F.elements["BIC_R"]) {
            F.elements["BIC_R"].value = aValues[1];
            $('#BIC_R').blur();
            if (F.elements["BN_R"]) {
                F.elements["BN_R"].value = aValues[3];
                $('#BN_R').blur();
            }
        }
        F.elements["NAME_R"].disabled = true;//2020
    }
    catch (e) {
        alert(e.description);
    }

}

function FillBANKS(idForm, sBN_R, sBIC_R) {
    try {
        var F = document.getElementById(idForm);
        F.elements["BN_R"].value = sBN_R;
        F.elements["BIC_R"].value = sBIC_R;
    }
    catch (e) {
        alert(e.description);
    }

}

function FillVIDPAY(idForm, sPT) {
    try {
        if (document.getElementById(idForm) == null) idForm = "frmCOPY";
        var F = document.getElementById(idForm);
        F.elements[senderVIDPAY].value = sPT;
    }
    catch (e) {
        alert(e.description);
    }

}

function FillUBBMC1(idForm, sPT, sMsg) {
    try {
        if (document.getElementById(idForm) == null) idForm = "frmCOPY";
        var F = document.getElementById(idForm);
        F.elements["UBBMC1"].value = sPT;
        F.elements["UBBMC1NAME"].value = sMsg;
        F.elements["UBBMC1"].focus();
    }
    catch (e) {
        alert(e.description);
    }
}

function chkDECL_BNB(idForm)  //the function is used in SWIFT and SWIFT2 orders and for radio buttons of Sender & Receiver, so nameRadio is needless!
{

    var frm = document.getElementById(idForm);
    var tmprbY = frm.elements["rbY"].checked;
    var tmprbN = frm.elements["rbN"].checked;
    if (tmprbY == true && tmprbN == false) {
        document.getElementById('DECL_BNB').value = "Y";
    }
    if (tmprbY == false && tmprbN == true) {
        document.getElementById('DECL_BNB').value = "N";
    }
}

function chkDECL_BNB_SCA(idForm)  //the function is used in EURO orders in SCA
{
    var frm = document.getElementById(idForm);
    var tmprbY = frm.elements["rbY"].checked;
    var tmprbN = frm.elements["rbN"].checked;
    if (tmprbY == true && tmprbN == false) {
        document.querySelector('input[name=DECL_BNB_SCA]').value = "Y";
    }
    if (tmprbY == false && tmprbN == true) {
        document.querySelector('input[name=DECL_BNB_SCA]').value = "N";
    }

    var button = document.getElementById('accBtn');
    if (button.classList.contains('btn-disabled-sca')) {
        button.classList.remove('btn-disabled-sca');
    }
}

//8365 - Vili
function chkCorpPhys(idForm)  //the function is used in SWIFT and SWIFT2 orders and for radio buttons of Sender & Receiver, so nameRadio is needless!
{
    try {
        var frm = document.getElementById(idForm);
        var tmpForeigner = frm.elements["r2"].checked;
        frm.elements["DECL_BNB"].value = "";
        if (tmpForeigner == true) {
            $('#Decl7').addClass("hidden");
            frm.elements["rbY"].checked = false;
            frm.elements["rbN"].checked = false;
        }
        else {
            if (frm.elements["JUR_PHYS"].value == 1) {
                $('#Decl7').addClass("hidden");
                frm.elements["rbY"].checked = false;
                frm.elements["rbN"].checked = false;
            }
            else {
                if (frm.elements["ORDNAME"].value == "SWIFT") {
                    $('#Decl7').removeClass("hidden");
                }
                if (frm.elements["ORDNAME"].value == "SWIFT2" || frm.elements["ORDNAME"].value == "SWIFT2.N.C") {
                    if (frm.elements["rbR2"].checked == true) { 
                        $('#Decl7').removeClass("hidden");
                    }
                    else {
                       
                        $('#Decl7').addClass("hidden");
                        frm.elements["rbY"].checked = false;
                        frm.elements["rbN"].checked = false;
                    }
                }
            }  //visible only (for resident juridicals receivers ("JUR_PHYS"=0 and tmpForeigner=false) for SWIFT) & (for resident juridicals receivers + senders-foreigners forSWIFT2)!
        }
    }
    catch (e) {
        alert("chkCorpPhys e:" + e.description);
    }
}

function FillCountry(idForm, sCodeOrName, sCode, sCountry, sCtrARRAY, sCtrEurope) {
    try {
        var FFF = sCtrARRAY;
        var str = FFF.split("|");
        var Country57 = str[0];
        var ISO57 = str[1];
        var ibanlen57 = str[2];
        var ibancode57 = str[3];
        var cISO1_57 = str[4];
        var CuntryName = str[5];

        var F = document.getElementById(idForm);
        if (sCodeOrName == 2) {
            F.elements[senderADR].value = Country57;
        }
        else {
            F.elements[senderADR].value = sCode;
        }

        F.elements[senderCtrNAME].value = sCountry;
        F.elements[senderADR_arr].value = sCtrARRAY;
        F.elements[senderCtrEU].value = sCtrEurope;
        F.elements[senderCtrNAME].focus();

        if (senderADR == "ADR2_R") {
            if (sCountry.length > 35)
            { F.elements[senderADR].value = Country57; }
            else
            { F.elements[senderADR].value = CuntryName; }
        }
    }
    catch (e) {
        alert(e.description);
    }
}

function GetCNTRSwift() {
    var FFF = '';
    FFF = document.getElementById("ADR2_ARR").value;
    var str = FFF.split("|");
    var Country57 = str[0];
    var ISO57 = str[1];
    var ibanlen57 = str[2];
    var ibancode57 = str[3];
    var cISO1_57 = str[4];
    document.getElementById('CNTRY').value = ISO57;
}

function GetCountryShortSwift() {
    var FFF = '';
    FFF = document.getElementById("COUNTRY_ARR").value;
    var str = FFF.split("|");
    var Country57 = str[0];
    var ISO57 = str[1];
    var ibanlen57 = str[2];
    var ibancode57 = str[3];
    var cISO1_57 = str[4];
    document.getElementById('COUNTRY').value = Country57;
}


function chkCntryEU(vCountry) {
    try {
        var CntryEU = new Array();
        var flFnd = 0;
        var i = 1;

        //CntryEU[1] = 'ANDORRA';
        CntryEU[1] = 'AUSTRIA';
        CntryEU[2] = 'BELGIUM';
        CntryEU[3] = 'BULGARIA';
        //CntryEU[5] = 'BOUVET ISLAND';
        CntryEU[4] = 'CROATIA';          //'SWITZERLAND'; //HD 447675 and 447735 from 03.02.2017
        CntryEU[5] = 'CYPRUS';
        CntryEU[6] = 'CZECH REPUBLIC';
        CntryEU[7] = 'GERMANY';
        CntryEU[8] = 'DENMARK';
        CntryEU[9] = 'ESTONIA';
        CntryEU[10] = 'SPAIN';
        CntryEU[11] = 'FINLAND';
        CntryEU[12] = 'FRANCE';
        CntryEU[13] = 'UNITED KINGDOM';
        CntryEU[14] = 'FRENCH GUIANA';
        CntryEU[15] = 'GIBRALTAR';
        CntryEU[16] = 'GUADELOUPE';
        CntryEU[17] = 'GREECE';
        CntryEU[18] = 'HUNGARY';
        CntryEU[19] = 'IRELAND';
        CntryEU[20] = 'ICELAND';
        CntryEU[21] = 'ITALY';
        CntryEU[22] = 'LIECHTENSTEIN';
        CntryEU[23] = 'LITHUANIA';
        CntryEU[24] = 'LUXEMBOURG';
        CntryEU[25] = 'LATVIA';
        //CntryEU[28] = 'MONACO';
        CntryEU[26] = 'MARTINIQUE';
        CntryEU[27] = 'MALTA';
        CntryEU[28] = 'NETHERLANDS';
        CntryEU[29] = 'NORWAY';
        CntryEU[30] = 'POLAND';
        CntryEU[31] = 'PORTUGAL';
        CntryEU[32] = 'REUNION';
        CntryEU[33] = 'ROMANIA';
        CntryEU[34] = 'SWEDEN';
        CntryEU[35] = 'SLOVENIA';
        CntryEU[36] = 'SLOVAKIA';
        //CntryEU[40] = 'SAN MARINO';
        //CntryEU[41] = 'PM';
        //CntryEU[42] = 'SJ';
        //CntryEU[43] = 'TF';
        //CntryEU[44] = 'VA';

        while ((i < CntryEU.length + 1) && (flFnd == 0)) {
            if (CntryEU[i] == vCountry) {
                flFnd = 1;
            }
            i++;
        }

    }
    catch (e) {
        alert("out param chkCntryEU:" + e.description);
    }
    return flFnd;
}

function FillTemplate(idForm, strData, arrCountry, TmplKey, TmplId) {
    try {
        removeError(idForm); //9214
        if (document.getElementById("btnTmpl")) {
            $('#btnTmpl').addClass("hidden");
        }
        var F = document.getElementById(idForm);
        var aValues = (strData + "").split("|");
        var ORDNAME = F.elements["ORDNAME"].value;

        switch (ORDNAME) {
            case "SWIFT2":
            case "SWIFT2.F":
            case "SWIFT2.P":
                F.elements["NAME_R"].value = aValues[0];
                F.elements["ACC_R"].value = aValues[1];
                $(F.elements["ACC_R"]).blur(); //9214
                var dd = document.getElementById('CURR');
                for (var i = 0; i < dd.options.length; i++) {
                    if (dd.options[i].text === aValues[2]) {
                        dd.selectedIndex = i;
                        break;
                    }
                }
                F.elements["AMOUNT"].value = aValues[4];
                F.elements["REM_I"].value = aValues[5];
                F.elements["REM_II"].value = aValues[6];
                F.elements["UBBMC1"].value = aValues[7];

                var radios = document.getElementsByName('TYPE_R');
                var radioChkValue = "";
                for (var i = 0, length = radios.length; i < length; i++) {
                    if (aValues[8] == radios[i].value) {
                        radios[i].checked = true;
                        break;
                    }
                }
                if (TmplId == "")
                    F.elements["TmplId"].value = aValues[9];
                else
                    F.elements["TmplId"].value = TmplId;
                F.elements["TEMPL"].value = TmplKey;
                break;
            case "OWN.ACCOUNT":
            case "OWN.ACCOUNT.P": //11521
                F.elements["TmplId"].value = TmplId;
                F.elements["ACC_R"].value = aValues[1];
                F.elements["CURR_R"].value = aValues[2];
                F.elements["AMOUNT_RS"].value = aValues[4];
                F.elements["AMOUNT_R"].value = aValues[4];
                F.elements["REM_I"].value = aValues[5];
                F.elements["REM_II"].value = aValues[6];
                FillAccountsOwn(idForm, F.elements["ACC_S"].value, F.elements["CURR_S"].value, F.elements["lng"].value);
                F.elements["TEMPL"].value = TmplId;
                break;
            case "IBAN311":
			case "IBAN311.F":
            case "IBAN311.P":
            case "IBAN311IMG":
                F.elements["NAME_R"].value = aValues[0];
                F.elements["ACC_R"].value = aValues[1];
                $(F.elements["ACC_R"]).blur(); //9214
                F.elements["BIC_R"].value = aValues[3];
                F.elements["AMOUNT"].value = aValues[4];
                F.elements["REM_I"].value = aValues[5];
                F.elements["REM_II"].value = aValues[6];
                if (TmplId == "")
                    F.elements["TmplId"].value = aValues[7];
                else
                    F.elements["TmplId"].value = TmplId;

                F.elements["TEMPL"].value = TmplKey;
                F.elements["NAME_R"].disabled = false;
                F.elements["ACC_R"].disabled = false;
                F.elements["BIC_R"].disabled = false;
                F.elements["REM_I"].disabled = false;
                F.elements["REM_II"].disabled = false;
                /*if (TmplId == "")//20200110
                    F.elements["TEMPL"].value = aValues[7];
                else
                    F.elements["TEMPL"].value = TmplId;*/
                break;
            case "IBAN411":
            case "IBAN411.F":
            case "IBAN411.P":
                F.elements["NAME_R"].value = aValues[0];
                F.elements["ACC_R"].value = aValues[1];
                $(F.elements["ACC_R"]).blur(); //9214
                F.elements["BIC_R"].value = aValues[3];
                F.elements["AMOUNT"].value = aValues[4];
                F.elements["REM_I"].value = aValues[5];
                F.elements["REM_II"].value = aValues[6];
                F.elements["TEMPL"].value = TmplId;
                break;
            case "IBAN312":
            case "IBAN312.F":
            case "IBAN312.P":
            case "IBAN312.B": //14857
                F.elements["NAME_R"].value = aValues[0];
                F.elements["ACC_R"].value = aValues[1];
                F.elements["PAY_R"].value = aValues[2];

                F.elements["AMOUNT"].value = aValues[4];
                F.elements["REM_I"].value = aValues[5];
                F.elements["REM_II"].value = aValues[6];

                F.elements["ACT"].value = aValues[7];
                F.elements["KIND"].value = aValues[8];
                var dd = document.getElementById('KIND1');
                for (var i = 0; i < dd.options.length; i++) {
                    if (dd.options[i].text === aValues[8]) {
                        dd.selectedIndex = i;
                        break;
                    }
                }
                $('#frmPAYMENT #KIND1').find('option[value^="' + aValues[8] + '"]').prop('selected', true).change().trigger('select2:select');
                F.elements["KINDADD"].value = aValues[9];
                if (TmplId == "")
                    F.elements["TmplId"].value = aValues[11];
                else
                    F.elements["TmplId"].value = TmplId;

                F.elements["TEMPL"].value = TmplKey;
                break;
            case "IBAN313":
            case "IBAN313.F":
            case "IBAN313.P":
            case "IBAN313.B": //14802
				if (TmplId == "")
                    F.elements["TmplId"].value = aValues[18];
                else
                    F.elements["TmplId"].value = TmplId;

                F.elements["NAME_R"].value = aValues[0];
                F.elements["ACC_R"].value = aValues[1];
                $(F.elements["ACC_R"]).blur(); //9214
                //if (aValues[17] != '00000000-0000-0000-0000-000000000000') {
                if (aValues[17] != aValues[18]) {
                    var payr = (aValues[17] == "0") ? "" : aValues[17]; //613747HD
                    F.elements["PAY_R"].value = payr;
                }
                else {
                    var payr = (aValues[2] == "0") ? "" : aValues[2]; //613747HD
                    F.elements["PAY_R"].value = payr;
                }
                F.elements["BIC_R"].value = aValues[3];

                F.elements["AMOUNT"].value = aValues[4];
                F.elements["REM_I"].value = aValues[5];
                F.elements["REM_II"].value = aValues[6];

                if (ORDNAME != "IBAN313.B") { //14802
                    F.elements["TYPEDOC"].value = aValues[7];
                    F.elements["TYPENUM"].value = aValues[8];

                    F.elements["DOCDATE"].value = aValues[9];
                    F.elements["FROMDATE"].value = aValues[10];
                    F.elements["TODATE"].value = aValues[11];
                }

                F.elements["BUL"].value = aValues[12];
                F.elements["EGN"].value = aValues[13];
                F.elements["LNC"].value = aValues[14];
                F.elements["PAY_S"].value = aValues[15];
                F.elements["OBLIG"].value = aValues[16];
                
                F.elements["TEMPL"].value = TmplKey;
                break;
            case "SWIFT":
            case "SWIFT.F":
            case "SWIFT.P":
                if (aValues[0] == "OLD") {
                    var strAlert = "Моля, проверете дали данните за: наредителя (Наредител-име, Адрес, Град, Държава) и \nполучателя (Получател - Име) са коректно попълнени/подредени.\n\nАко направите промени за тези полета в платежния документ можете:\n1. Да го запазите като шаблон с ново име от Опции>>Нов шаблон с име>>Добави\n2. Да изтриете стария от списъка с Шаблони>>Десен бутон на мишката върху името му.";
                    strAlert = strAlert + "\n\n\n\nPlease, check whether the data about: \nOrdering Customer (Ordering Customer-name, Address, City, Country) and \n Beneficiary (Beneficiary-name) are correctly entered/arranged.\n\nIf you are made changes about these fields in the payment document you can:\n1. Add it as a template with new name from Options>> New Template with name>>Add\n2. Delete old one from the list Templates>>Right Click on item to delete it.";

                    if (F.elements["BK.TO.BK.INFO2"]) {
                        F.elements["BK.TO.BK.INFO2"].checked = false;
                    }
                    // OOBT-321 {
                    //F.elements["NAME_S"].value = aValues[1].substr(0, 35);
                    //if (aValues[1].substr(35, 35) != "") F.elements["ADR1_S"].value = aValues[1].substr(35, 35);
                    //var part = aValues[1].length - 33;
                    //if (aValues[1].substr(part, aValues[1].length) == "S NAD 50 NA STO DARJAVNO UCHASTIE") {
                    //    if (aValues[1].substr(70, part - 70) != "") F.elements["ADR2_S"].value = aValues[1].substr(70, part - 70);
                    //}
                    //else
                    //    if (aValues[1].substr(70, 35) != "") F.elements["ADR2_S"].value = aValues[1].substr(70, 35);
                    // OOBT-321 }
                    F.elements["CURR"].value = aValues[2];
                    F.elements["NAME_R"].value = aValues[3];
                    F.elements["ADR1_R"].value = aValues[4];
                    F.elements["ACC_R"].value = aValues[5];
                    $(F.elements["ACC_R"]).blur(); //9214
                    F.elements["BENBANK1"].value = aValues[6];
                    F.elements["BENBANK2"].value = aValues[7];
                    F.elements["BIC_R"].value = aValues[8];
                    F.elements["CITY"].value = aValues[9];
                    F.elements["COUNTRY"].value = aValues[10];

                    F.elements["COUNTRYNAME"].value = aValues[10];
                    var arrayCountry2 = arrCountry.split(";");
                    F.elements["COUNTRY_ARR"].value = "||||||";
                    for (i = 0; i < arrayCountry2.length; i++) {
                        var jj = arrayCountry2[i];
                        if (jj.indexOf(F.elements["COUNTRY"].value) >= 0) {
                            var sArr = jj.split("|");
                            if (F.elements["COUNTRY"].value == sArr[0]) {
                                F.elements["COUNTRYNAME"].value = sArr[5];
                                F.elements["COUNTRY_ARR"].value = arrayCountry2[i];
                                var vEU = chkCntryEU(sArr[5]);
                                if (vEU == '1') {
                                    F.elements["CNTRY_EU"].value = 1;
                                }
                                else {
                                    F.elements["CNTRY_EU"].value = "";
                                }
                            }
                        }
                    }

                    F.elements["REM_I"].value = aValues[11].substr(0, 35);
                    if (aValues[11].substr(35, 35)) F.elements["REM_II"].value = aValues[11].substr(35, 35);
                    if (aValues[11].substr(70, 35)) F.elements["REM_III"].value = aValues[11].substr(70, 35);
                    if (aValues[11].substr(105, 35)) F.elements["REM_IV"].value = aValues[11].substr(105, 35);
                    F.elements["UBBMC1"].value = aValues[12];

                    if (aValues[13] == "SHA") aValues[13] = 0;
                    else if (aValues[13] == "OUR") aValues[13] = 1;
                    else if (aValues[13] == "BEN") aValues[13] = 2;
                    else aValues[13] = parseInt(aValues[13]) - 1;
                    if (!isNaN(aValues[13])) F.elements["CHARGES"][aValues[13]].checked = true;

                    if (aValues[14] == "МЕСТНО ЛИЦЕ") aValues[14] = 0;
                    else if (aValues[14] == "ЧУЖДЕСТРАННО ЛИЦЕ") aValues[14] = 1;
                    else aValues[14] = parseInt(aValues[14]) - 1;
                    if (!isNaN(aValues[14])) F.elements["TYPE_R"][aValues[14]].checked = true;

                    if (typeof (aValues[15]) != "undefined") {
                        F.elements["ADR2_R"].value = aValues[15];
                        if (F.elements["ADR2_R"].value != '') {
                            var C_ADDR2 = document.getElementById("ADR2_R").value;
                            var FFF = '';
                            var arrayCountry1 = arrCountry.split(";");
                            for (i = 0; i < arrayCountry1.length; i++) {
                                var jj = arrayCountry1[i];
                                if (jj.indexOf(C_ADDR2) >= 0) {
                                    FFF = arrayCountry1[i];
                                    var str = FFF.split("|");
                                    if (C_ADDR2 == str[0] || C_ADDR2 == str[5]) {
                                        var Country57 = str[0];
                                        var ISO57 = str[1];
                                        var ibanlen57 = str[2];
                                        var ibancode57 = str[3];
                                        var cISO1_57 = str[4];
                                        F.elements["CNTRY"].value = ISO57;
                                        F.elements["ADR2_RNAME"].value = str[5];
                                        F.elements["ADR2_ARR"].value = arrayCountry1[i];
                                    }
                                }
                            }
                        }
                        else {
                            $('#frmPAYMENT #addres').attr('selectedIndex', '-1').find("option:selected").prop('selected', false).change().trigger('select2:select');
                        }
                    }
                    if (typeof (aValues[16]) != "undefined")
                        F.elements["AMOUNT"].value = aValues[16];
                    if ((typeof (aValues[17]) != "undefined") && (aValues[17] == "/ACC/UP50 DU"))
                        F.elements["BK.TO.BK.INFO2"].checked = true;
                }
                else {
                    if (F.elements["BK.TO.BK.INFO2"]) {
                        F.elements["BK.TO.BK.INFO2"].checked = false;
                    }
                    // OOBT-321 {
                    //F.elements["NAME_S"].value = aValues[1];
                    //F.elements["ADR1_S"].value = aValues[2];
                    //F.elements["ADR2_S"].value = aValues[3];
                    // OOBT-321 }
                    F.elements["CURR"].value = aValues[4];
                    F.elements["NAME_R"].value = aValues[5];
                    F.elements["ADR1_R"].value = aValues[6];
                    F.elements["ACC_R"].value = aValues[7];
                    F.elements["BENBANK1"].value = aValues[8];
                    F.elements["BENBANK2"].value = aValues[9];
                    F.elements["BIC_R"].value = aValues[10];
                    F.elements["CITY"].value = aValues[11];
                    F.elements["COUNTRY"].value = aValues[12];
                    F.elements["COUNTRYNAME"].value = aValues[12];
                    var vEU = chkCntryEU(aValues[12]);
                    if (vEU == '1') {
                        F.elements["CNTRY_EU"].value = 1;
                    }
                    else {
                        F.elements["CNTRY_EU"].value = "";
                    }

                    var arrayCountry2 = arrCountry.split(";");
                    document.getElementById("COUNTRY_ARR").value = "||||||";
                    for (i = 0; i < arrayCountry2.length; i++) {
                        var jj = arrayCountry2[i];
                        if (jj.indexOf(F.elements["COUNTRY"].value) >= 0) {
                            var sArr = jj.split("|");
                            if (F.elements["COUNTRY"].value == sArr[0]) {
                                F.elements["COUNTRYNAME"].value = sArr[5];
                                F.elements["COUNTRY_ARR"].value = arrayCountry2[i];
                            }
                        }
                    }
                    var tmpCNTRY = F.elements["COUNTRY_ARR"].value.split("|");
                    F.elements["CNTRY"].value = tmpCNTRY[1];
                    F.elements["ADR2_RNAME"].value = aValues[17];

                    F.elements["REM_I"].value = aValues[13].substr(0, 35);
                    if (aValues[13].substr(35, 35)) F.elements["REM_II"].value = aValues[13].substr(35, 35);
                    if (aValues[13].substr(70, 35)) F.elements["REM_III"].value = aValues[13].substr(70, 35);
                    if (aValues[13].substr(105, 35)) F.elements["REM_IV"].value = aValues[13].substr(105, 35);

                    var tmpEGNBUL = trim(document.getElementById("frmMain").elements["ACTEGN"].value);

                    if (aValues[15] == "SHA") aValues[15] = 0;
                    else if (aValues[15] == "OUR") aValues[15] = 1;
                    else if (aValues[15] == "BEN") aValues[15] = 2;
                    else aValues[15] = parseInt(aValues[15]) - 1;
                    if (!isNaN(aValues[15])) F.elements["CHARGES"][aValues[15]].checked = true;
                    if (aValues[16] == "МЕСТНО ЛИЦЕ") aValues[16] = 0;
                    else if (aValues[16] == "ЧУЖДЕСТРАННО ЛИЦЕ") aValues[16] = 1;
                    else aValues[16] = parseInt(aValues[16]) - 1;
                    if (!isNaN(aValues[16])) F.elements["TYPE_R"][aValues[16]].checked = true;
                    //На живо е друго????
                    if (typeof (aValues[17]) != "undefined") {
                        F.elements["ADR2_R"].value = aValues[17];
                        //MD добавени следващите три реда за извличане на информацията за CNTRY
                        if (F.elements["ADR2_R"].value != '') {

                            var C_ADDR2 = document.getElementById("ADR2_R").value;
                            var FFF = '';
                            var arrayCountry1 = arrCountry.split(";");
                            for (i = 0; i < arrayCountry1.length; i++) {
                                var jj = arrayCountry1[i];
                                if (jj.indexOf(C_ADDR2) >= 0) {
                                    FFF = arrayCountry1[i];
                                    var str = FFF.split("|");
                                    if (C_ADDR2 == str[0] || C_ADDR2 == str[5]) {
                                        var Country57 = str[0];
                                        var ISO57 = str[1];
                                        var ibanlen57 = str[2];
                                        var ibancode57 = str[3];
                                        var cISO1_57 = str[4];
                                        F.elements["ADR2_ARR"].value = arrayCountry1[i];
                                    }
                                }
                            }
                        }
                        else {//13130
                            $('#frmPAYMENT #addres').attr('selectedIndex', '-1').find("option:selected").prop('selected', false).change().trigger('select2:select');
                            $('#frmPAYMENT #addres').parent().removeClass('filled');
                        }
                    }
                    if (typeof (aValues[18]) != "undefined")
                        F.elements["AMOUNT"].value = aValues[18];
                    if ((typeof (aValues[19]) != "undefined") && (aValues[19] == "/ACC/UP50 DU"))
                        F.elements["BK.TO.BK.INFO2"].checked = true;
                }
                if (TmplId == "" && aValues[0] == 'OLD')
                    F.elements["TmplId"].value = aValues[19];
                else if (TmplId == "" && aValues[0] == 'NEW')
                    F.elements["TmplId"].value = aValues[20];
                else
                    F.elements["TmplId"].value = TmplId;

                F.elements["TEMPL"].value = TmplKey;
                break;

            default:
        }//end switch
    }
    catch (e) {
        alert(e.description);
    }
}

function GetPartners(sender, title, ORDNAME, idForm, slng) {

    var F = document.getElementById(idForm);
    var sACC_S = F.elements["ACC_S"].value;

    idAJAXResult = "floatContent1";
    var sSID = document.getElementById("idMSID").value;
    document.getElementById("title1_title").innerHTML = title;

    document.getElementById("floatContent1").innerHTML = strWait;
    var surl = "Q.aspx?Q=GETPARTNERS&ORDNAME=" + ORDNAME + "&ACC_S=" + sACC_S + "&lng=" + slng + "&SID=" + sSID;
    SendGetRequest(surl);
    showBox('float1', sender, 'floatIn1', 'title1', 'floatContent1', 420, 0);
}

function GetPartnersRe(sender, title, ORDNAME, idForm, slng) {//8365

    var F = document.getElementById(idForm);
    var sACC_S = "";//F.elements["ACC_S"].value;

    idAJAXResult = sender;
    var sSID = document.getElementById("idMSID").value;
    document.getElementById(idForm).elements[sender].innerHTML = strWait;
    var surl = "Q.aspx?Q=GETPARTNERS&ORDNAME=" + ORDNAME + "&ACC_S=" + sACC_S + "&lng=" + slng + "&SID=" + sSID;
    SendPostRequestAc(surl);
}

function GetTemplatesRe(sender, title, ORDNAME, idForm, slng) {
    idAJAXResult = sender;
    var sSID = document.getElementById("idMSID").value;
    document.getElementById(idForm).elements[sender].innerHTML = strWait;
    var surl = "Q.aspx?Q=GETTEMPLATES&ORDNAME=" + ORDNAME + "&lng=" + slng + "&SID=" + sSID;
    SendPostRequestAc(surl);
}



function GetBANKS(sender, title, idForm) {
    try {
        idAJAXResult = "floatContent1";
        var sSID = document.getElementById("idMSID").value;
        document.getElementById("title1_title").innerHTML = title;

        document.getElementById("floatContent1").innerHTML = strWait;
        var surl = "Q.aspx?Q=GETBANKS&SID=" + sSID;
        SendGetRequest(surl);
        showBox('float1', sender, 'floatIn1', 'title1', 'floatContent1', 300, 0);
    }
    catch (e) {
        alert(e.description);
    }

}

var senderVIDPAY = "";
function GetVIDPAY(sender, title, idForm, sendername) {

    senderVIDPAY = sendername;
    idAJAXResult = "floatContent1";
    var sSID = document.getElementById("idMSID").value;
    document.getElementById("title1_title").innerHTML = title;

    document.getElementById("floatContent1").innerHTML = strWait;
    var surl = "Q.aspx?Q=GETVIDPAY&SID=" + sSID;
    SendGetRequest(surl);
    showBox('float1', sender, 'floatIn1', 'title1', 'floatContent1', 550, 0);

}



function GetUBBMC1(sender, title, idForm, slng) {
    idAJAXResult = "floatContent1";
    var sSID = document.getElementById("idMSID").value;
    document.getElementById("title1_title").innerHTML = title;
    document.getElementById("floatContent1").innerHTML = strWait;
    var surl = "Q.aspx?Q=GETUBBMC1&lng=" + slng + "&SID=" + sSID;
    SendGetRequest(surl);
    showBox('float1', sender, 'floatIn1', 'title1', 'floatContent1', 613, 0);
}

var senderADR = "";
var senderADR_arr = "";
var senderCtrNAME = "";
var senderCtrEU = "";
var senderACC = "";
function GetAccountsCHARGE(sender, title, ORDNAME, idForm, sendername) {
    senderACC = sendername;
    idAJAXResult = "floatContent1";
    var sSID = document.getElementById("idMSID").value;
    document.getElementById("title1_title").innerHTML = title;

    document.getElementById("floatContent1").innerHTML = strWait;
    var surl = "Q.aspx?Q=GETACCOUNTS&ORDNAME=" + ORDNAME + "&SID=" + sSID;
    SendGetRequest(surl);
    showBox('float1', sender, 'floatIn1', 'title1', 'floatContent1', 220, 0);
}

function GetAccounts(sender, title, ORDNAME, idForm) {
    senderACC = "";
    idAJAXResult = "floatContent1";
    var sSID = document.getElementById("idMSID").value;

    document.getElementById("title1_title").innerHTML = title;
    document.getElementById("floatContent1").innerHTML = strWait;
    var surl = "Q.aspx?Q=GETACCOUNTS&ORDNAME=" + ORDNAME + "&SID=" + sSID;
    SendGetRequest(surl);
    showBox('float1', sender, 'floatIn1', 'title1', 'floatContent1', 220, 0);

}




function DelPartnerULP(idfrm,OrdName,TMPLKEY, Nametmpl, acc) {//10478

 if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form-deltemplate"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + 'Сигурни ли сте, че искате да изтриете избрания контрагент?' + '<br/>' + 'Are you sure you want to delete the chosen beneficiary?' + '</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkDelTempl" id="OkDelTempl">Потвърди / OK</a></footer></div>').appendTo('body');
    $(openPopup('popup-confirm-form-deltemplate'));
    $('#OkDelTempl').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OkDelTempl') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

            var F = document.getElementById(idfrm);
            F.elements["ORDNAME"].value = OrdName;
            F.elements["IDPart"].value = TMPLKEY;
            F.elements["ACC_R"].value = acc;

            StoreAndSignReP(idfrm, 'frmSubmit');
        }

    });
    $("a[class='b-close']").click();
}

function DelTemplateP(Sess, idfrm, OrdName, obj, tid, tkey,tname,acc)  {//10478

    if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form-deltemplate"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Сигурни ли сте, че искате да изтриете избрания шаблон?<br/>Are you sure you want to delete the chosen template?</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkDelTempl" id="OkDelTempl">Потвърди / OK</a></footer></div>').appendTo('body');
    $(openPopup('popup-confirm-form-deltemplate'));
    $('#OkDelTempl').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OkDelTempl') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

          var F = document.getElementById(idfrm);
          F.elements["ORDNAME"].value = OrdName;
          F.elements["TEMPLID"].value = tid;
          F.elements["TMPLKEY"].value = tkey;
          F.elements["TMPLNAME"].value = tname;
          F.elements["ACC_R"].value = acc;

          StoreAndSignReP(idfrm, 'frmSubmit');
        }

    });
    $("a[class='b-close']").click();
   
}
function ShareTemplateP(Sess, idfrm, OrdName, obj, tid, tkey,tname,acc)  {//10478

	///alert('Alert');
    if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form-ShareTemplate"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Сигурни ли сте, че искате да споделите избрания шаблон?<br/>Are you sure you want to share the chosen template?</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkDelTemp2" id="OkDelTemp2">Потвърди / OK</a></footer></div>').appendTo('body');
    $(openPopup('popup-confirm-form-ShareTemplate'));
    $('#OkDelTemp2').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OkDelTemp2') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

          var F = document.getElementById(idfrm);
          F.elements["ORDNAME"].value = OrdName;
          F.elements["TEMPLID"].value = tid;
          F.elements["TMPLKEY"].value = tkey;
          F.elements["TMPLNAME"].value = tname;
          F.elements["ACC_R"].value = acc;

          StoreAndSignReP(idfrm, 'frmSubmit');
        }

    });
    $("a[class='b-close']").click();
   
}
function CheckShareTemplateName(idfrm,tname) {

    
    var F = document.getElementById(idfrm);
	var StringAllSharedTemps = $('#StringAllSharedTemps').val();
	
	var str = StringAllSharedTemps.indexOf('|' + tname + '|'); 
	
	if(str >= 0){
		if ($('#id-CheckShareTemplateName').length > 0) {
			    $("#id-CheckShareTemplateName").remove();
		}
		var lng = $("#frmMain input[name=lng]").val();
		if(lng=='BG'){
            $('<div id="id-CheckShareTemplateName" class="popup" data-popup="popup-CheckShareTemplateName"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + 'Споделен шаблон с това име вече съществува. Моля преименувайте шаблона.' + '</div><footer><a title="Да" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkBtn1" id="OkBtn1">Ok</a></footer></div>').appendTo('body');
		}
		else{
            $('<div id="id-CheckShareTemplateName" class="popup" data-popup="popup-CheckShareTemplateName"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + 'A shared template of this name already exists. Please, rename the template! ' + '</div><footer><a title="Ok" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkBtn1" id="OkBtn1">Ok</a></footer></div>').appendTo('body');
		}
		$(openPopup('popup-CheckShareTemplateName'));
		$('#OkBtn1').one('click', function (event) {

                event.preventDefault();
               
            });
            $("a[class='b-close']").click();
			return false;
	}
	
	return true;
	
   
}





function SaveTemplate(f, submitform, sTMPLNAME) {
    try {
        if (sTMPLNAME.length <= 0) {
            txtErr = "Въведете име на шаблона!" + "<br/>" + "Type the name of the template!";
            fieldErr = document.getElementById("idtmplname");
            elemError(fieldErr, txtErr);
            return;
       }

        //EK добавена е проверка за името на шаблона
        var re = /^[ A-ZА-Яa-zа-я0-9/\.;=@%\-_*\\\(\)\|\+!?$#&]+$/;
        var test1 = re.test(sTMPLNAME);
        if (!test1) {
            txtErr = "Недопустим символ в поле 'Нов шаблон с име'!" + "<br/>" + "Incorrect symbol in field 'New Template with name'!";
            fieldErr = document.getElementById("idtmplname");
            elemError(fieldErr, txtErr);
            return;
        }

        if (!FormalCheckOrder(f))
            return;

        var frm = document.getElementById(f);
        var submfrm = document.getElementById(submitform);

        submfrm.elements["COMMAND"].value = "";

        var xmltoSEND = "<Packet/>";
        var ElemGuid = frm.elements["id"];
        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
        ElemGuid.value = NextGuid(ElemGuid.value);
        var DeclGuid = ElemGuid.value.toUpperCase(); //HD 675264 
        xmltoSEND += MakeXML(f);
        xmltoSEND += "</Packet>";
        submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
        xmltoSEND = null;

        submfrm.elements["BASE64SIGN"].value = "";
        submfrm.elements["TMPLNAME"].value = sTMPLNAME;
		
		 if (document.getElementById("save-visible").checked)
		 {submfrm.elements["isShared"].value = "1";}//12379}
		 else
		 {submfrm.elements["isShared"].value = "0";}//12379
		 
        submfrm.elements["Q"].value = "INSTEMPLATE";

        var sbody = ObtainBody(submitform);
        idAJAXResult = "#alert";
        SendPostRequestAcTemplate("q.aspx", sbody);//11924
        //HD 675264 
        if ($("input[name='chbDeclData']").length > 0) 
        {
            $("input[name='chbDeclData']").prop('checked', false);
            $("#frmGetDeclData #DeclId").val(DeclGuid);
        }
    }
    catch (e) {
        createCustomAlertDeclaration(e);
    }
}

//МД добавенa e тази функция            
function SaveTemplateSWIFT(f, submitform, sTMPLNAME) {
    try {

        var fе = document.getElementById(f);
        var constEXPR = new RegExp(/[^a-zA-Z0-9. -]/g);
        var TMPelement = fе.elements["NAME_S"].value;
        fе.elements["NAME_S"].value = TMPelement.replace(constEXPR, " ");
        var TMPelement = fе.elements["ADR1_S"].value;
        fе.elements["ADR1_S"].value = TMPelement.replace(constEXPR, " ");
        var TMPelement = fе.elements["ADR2_S"].value;
        fе.elements["ADR2_S"].value = TMPelement.replace(constEXPR, " ");
        var TMPelement = fе.elements["CNTRY50"].value;
        fе.elements["CNTRY50"].value = TMPelement.replace(constEXPR, " ");

        if (!CheckSWIFT(f, submitform, 'Template'))
            return;
        if (!FormalCheckOrder(f))
            return;
        if (sTMPLNAME.length <= 0) {
            txtErr = "Въведете име на шаблона!" + "<br/>" + "Type the name of the template!";
            fieldErr = document.getElementById("idtmplname");
            elemError(fieldErr, txtErr);
            return;
        }
        //EK добавена е проверка за името на шаблона
        var re = /^[ A-ZА-Яa-zа-я0-9/\.;=@%\-_*\\\(\)\|\+!?$#&]+$/;
        var test1 = re.test(sTMPLNAME);
        if (!test1) {
            txtErr = "Недопустим символ в поле 'Нов шаблон с име'!" + "<br/>" + "Incorrect symbol in field 'New Template with name'!";
            fieldErr = document.getElementById("idtmplname");
            elemError(fieldErr, txtErr);
            return;
        }
        var frm = document.getElementById(f);
        var submfrm = document.getElementById(submitform);

        submfrm.elements["COMMAND"].value = "";

        var xmltoSEND = "<Packet/>";
        var ElemGuid = frm.elements["id"];
        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
        ElemGuid.value = NextGuid(ElemGuid.value);
        var DeclGuid = ElemGuid.value.toUpperCase(); //HD 675264 
        xmltoSEND += MakeXML(f);
        xmltoSEND += "</Packet>";
        //alert("xmltoSEND="+xmltoSEND); 
        submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
        xmltoSEND = null;

        submfrm.elements["BASE64SIGN"].value = "";
        submfrm.elements["TMPLNAME"].value = sTMPLNAME;
        submfrm.elements["Q"].value = "INSTEMPLATE";

        var sbody = ObtainBody(submitform);
        idAJAXResult = "#alert";
        SendPostRequestTemplate("q.aspx", sbody); //11924
        //HD 675264 
        if ($("input[name='chbDeclData']").length > 0) 
        {
            $("input[name='chbDeclData']").prop('checked', false);
            $("#frmGetDeclData #DeclId").val(DeclGuid);
        }
    }
    catch (e) {
        createCustomAlertDeclaration(e);
    }
}

function SavePartner(f, submitform) {
    try {
        if (!FormalCheckOrder(f))
            return;

        var frm = document.getElementById(f);
        var submfrm = document.getElementById(submitform);

        submfrm.elements["COMMAND"].value = "";

        var xmltoSEND = "<Packet/>";
        var ElemGuid = frm.elements["id"];
        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">";
        ElemGuid.value = NextGuid(ElemGuid.value);
        var DeclGuid = ElemGuid.value.toUpperCase(); //HD 675264 
		
        xmltoSEND += MakeXML(f);
        xmltoSEND += "</Packet>";

        submfrm.elements["BASE64XML"].value = base64Encode(xmltoSEND);
        xmltoSEND = null;

        submfrm.elements["BASE64SIGN"].value = "";
        submfrm.elements["Q"].value = "INSPARTNER";

        var sbody = ObtainBody(submitform);
        idAJAXResult = "#alert";
        SendPostRequestAc("q.aspx", sbody);

        //HD 675264 
        if ($("input[name='chbDeclData']").length > 0) 
		{
            $("input[name='chbDeclData']").prop('checked', false);
            $("#frmGetDeclData #DeclId").val(DeclGuid);
        }
		
    }
    catch (e) {
        createCustomAlertDeclaration(e);

    }
}

function CalcTax(idTable1, n) {
    var payResidual = 0.00; //обща сума по вноската
    var payInterest = 0.00; //обща сума по лихвите
    var paySum = 0.00; //обща сума 
    var tblname = "";
    var taxEIN = "";
    var F = document.getElementById("frmGetTaxes");

    var countTables = parseInt(GetAllValues1(F.elements["COUNTObligation"]));
    var arrEIN = new Array(countTables)

    for (var k = 1; k <= countTables; k++) {
        tblname = idTable1 + k;

        var idTable = document.getElementById(tblname);
        var iRowsLength = idTable.rows.length;
        payResidual = 0.00;     //обща сума по вноската
        payInterest = 0.00; //обща сума по лихвите
        paySum = 0.00; //обща сума 

        for (var i = 2; i < iRowsLength - 1; i++) {
            for (var j = 1; j < document.getElementById('IDTaxKindDebt').length; j++) {
                ss = document.getElementById('IDTaxKindDebt').item(j).value.split("|");
                if (ss[1] == idTable.rows[i].cells[n - 2].innerHTML) {
                    idTable.rows[i].cells[n - 2].innerHTML = ss[0];
                }
            }

            sum = parseFloat((idTable.rows[i].cells[n].innerHTML).replace(/,/g, ''));
            payResidual = parseFloat(payResidual) + parseFloat(sum);

            sum = parseFloat((idTable.rows[i].cells[n + 1].innerHTML).replace(/,/g, ''));
            payInterest = parseFloat(payInterest) + parseFloat(sum);

            sum = parseFloat((idTable.rows[i].cells[n + 3].innerHTML).replace(/,/g, ''));
            paySum = parseFloat(paySum) + parseFloat(sum);
        }  //end for by i  

        idTable.rows[iRowsLength - 1].cells[n - 1].innerHTML = CommaFormatted(payResidual.toFixed(2));
        idTable.rows[iRowsLength - 1].cells[n].innerHTML = CommaFormatted(payInterest.toFixed(2));
        idTable.rows[iRowsLength - 1].cells[n + 2].innerHTML = CommaFormatted(paySum.toFixed(2));
    }
}

function CalcUnaccounted(frm, idTable1, idType, n) {
    var allSum = 0.00;
    var tblname = "";

    var F = document.getElementById(frm);
    var countTables = parseInt(GetAllValues1(F.elements[idType]));

    for (var k = 1; k <= countTables; k++) {
        tblname = idTable1 + k;
        var idTable = document.getElementById(tblname);

        if (idTable != null) {
            var iRowsLength = idTable.rows.length;
            allSum = 0.00;

            for (var i = 1; i < iRowsLength - 1; i++) {
                sum = parseFloat((idTable.rows[i].cells[n + 3].innerHTML).replace(/,/g, ''));

                allSum = parseFloat(allSum) + parseFloat(sum);
            }  //end for by i  

            idTable.rows[iRowsLength - 1].cells[n + 3].innerHTML = CommaFormatted(allSum.toFixed(2));

        }
    }
}

function CalcUnaccountedRe(frm, idTable1, idType, n) {
    var allSum = 0.00;
    var tblname = "";

    var F = document.getElementById(frm);
    var countTables = parseInt(GetAllValues1(F.elements[idType]));

    for (var k = 1; k <= countTables; k++) {
        tblname = idTable1 + k;
	var idTable = document.getElementsByName(tblname)[1];

        if (idTable != null) {
            var iRowsLength = idTable.rows.length;
            allSum = 0.00;

            idTable = tblname;

            for (var i = 1; i < iRowsLength - 1; i++) {
                //sum = parseFloat((document.getElementById(idTable).rows[i].cells[n + 3].innerHTML).replace(/,/g, ''));
		sum = parseFloat((document.getElementsByName(idTable)[1].rows[i].cells[n + 3].innerHTML).replace(/,/g, ''));
                allSum = parseFloat(allSum) + parseFloat(sum);
            }  //end for by i  

            //8975 begin
            var tf = $('table[name="' + idTable + '"]:has(tfoot)');

            tf.each(function () {
                var cell = $(this).find("tr:first td:nth-child(" + (n + 4) + ")");
                $(cell).html(CommaFormatted(allSum.toFixed(2)));
            });

        }
    }
}

function CommaFormatted(amount) {
    var delimiter = ",";
    var a = amount.split('.', 2);
    var d = a[1];
    var i = parseInt(a[0]);
    var minus = '';
    if (i < 0)
        minus = '-';
    i = Math.abs(i);
    var n = new String(i);
    var a = [];
    while (n.length > 3) {
        var nn = n.substr(n.length - 3);
        a.unshift(nn);
        n = n.substr(0, n.length - 3);
    }
    if (n.length > 0) { a.unshift(n); }
    n = a.join(delimiter);
    if (d.length < 1)
        amount = n;
    else
        amount = n + '.' + d;
    amount = minus + amount;
    return amount;
}

function DeletePaymentInstrument() {
    document.getElementById('utility-steps-form').elements['ACC_S'].value = '';
    document.getElementById('utility-steps-form').elements['CRCARD_MID'].value = '';
    document.getElementById('utility-steps-form').elements['CRCARD_PID'].value = '';
    document.getElementById('utility-steps-form').elements['AP'].value = '';
}

function UtilityMode(uMode) {
    if (uMode == 'AUTO') {
        document.getElementById('AutoMode').style.display = "inline-block";
    }
    if (uMode == 'MANUAL') {
        document.getElementById('AutoMode').style.display = "none";
        document.getElementById('utility-steps-form').elements['ACC_S'].value = '';
        document.getElementById('utility-steps-form').elements['CRCARD_MID'].value = '';
        document.getElementById('utility-steps-form').elements['CRCARD_PID'].value = '';
        document.getElementById('utility-steps-form').elements['AP'].value = '';
    }
}

function UtilityModeEdit(uMode) {
    if (uMode == 'AUTO') {
        document.getElementById('AutoMode').style.display = "inline-block";
    }
    if (uMode == 'MANUAL') {
        document.getElementById('AutoMode').style.display = "none";
        //document.getElementById('utility-steps-form').elements['ACC_S'].value = '';
        //document.getElementById('utility-steps-form').elements['CRCARD_MID'].value = '';
        //document.getElementById('utility-steps-form').elements['CRCARD_PID'].value = '';
        //document.getElementById('utility-steps-form').elements['AP'].value = '';
    }
}





function EmailModes(uMode) {
    if (uMode == 'YESS') {
        document.getElementById('emailNotification').style.display = "inline-block";
    }
    if (uMode == 'NO') {
        document.getElementById('emailNotification').style.display = "none";
    }
}

function NewAn() {
    if (document.getElementById('utility-steps-form').elements['KKU_COMP'].value == 4 || document.getElementById('utility-steps-form').elements['KKU_COMP'].value == 19) {
        document.getElementById('utility-steps-form').elements['NEW_AN'].value = document.getElementById('utility-steps-form').elements['clNumber'].value + '-' + document.getElementById('utility-steps-form').elements['f-subscription-model-mtel'].value;
    }
    else {
        document.getElementById('utility-steps-form').elements['NEW_AN'].value = document.getElementById('utility-steps-form').elements['clNumber'].value;
    }
}

function GetAnUtBills(strVal, LNG) {

    // тази ф-я се използва в MPLS_KKU_SUBSCRIPTIONS.xslt
    //зарежда макета и примера за АН за ККУ компания
    var ss = new Array(8)
    ss = strVal.split(";");
    document.getElementById('KKU_COMP').value = ss[0];
    document.getElementById('f-subscription-model').value = ss[1];
    document.getElementById('KKU_COMP_NAME').value = ss[4];
    //if (ss[0] == 4) {
    //    document.getElementById('RegEx').value = ss[5] + '|' + ss[6];
    //    document.getElementById('anLen').value = ss[9];
    //}
    //else {
    document.getElementById('RegEx').value = ss[5];
    document.getElementById('anLen').value = ss[8];
    //}
    document.getElementById('f-subscription-model').focus();

    //Vili MPLS UtilityPayment
    if (ss[0] == '4' || ss[0] == '19') {
        document.getElementById('Mtel').style.display = "inline-block";
        document.getElementById('noMtel').style.display = "none";

        if (ss[0] == '4') {
            document.getElementById('clNumberMtel').style.display = "inline-block";
            document.getElementById('clNumberNoMtel').style.display = "none";
            document.getElementById('clNumberBOB').style.display = "none";

            document.getElementById('ttCodeMTEL').style.display = "inline-block";
            document.getElementById('codeBOB').style.display = "none";

            document.getElementById('codeMtel').style.display = "inline-block";
            document.getElementById('ttCodeBOB').style.display = "none";
        }
        if (ss[0] == '19') {
            document.getElementById('clNumberBOB').style.display = "inline-block";
            document.getElementById('clNumberMtel').style.display = "none";
            document.getElementById('clNumberNoMtel').style.display = "none";

            document.getElementById('codeBOB').style.display = "inline-block";
            document.getElementById('codeMtel').style.display = "none";

            document.getElementById('ttCodeBOB').style.display = "inline-block";
            document.getElementById('ttCodeMTEL').style.display = "none";
        }

        if (LNG == 'BG') {

            document.getElementById('tooltipAN').title = ss[7];

        }
        else {
            document.getElementById('tooltipAN').title = ss[8];

        }
    }
    //else {
    //    document.getElementById('clNumberMtel').style.display = "none";
    //}


    if (ss[0] != '4' && ss[0] != '19') {

        document.getElementById('noMtel').style.display = "inline-block";
        document.getElementById('Mtel').style.display = "none";

        document.getElementById('clNumberNoMtel').style.display = "inline-block";
        document.getElementById('clNumberBOB').style.display = "none";
        document.getElementById('clNumberMtel').style.display = "none";

        document.getElementById('ttCodeBOB').style.display = "none";
        document.getElementById('ttCodeMTEL').style.display = "none";
    }

    if (LNG == 'BG') {
        if (ss[0] == 4) {
            document.getElementById('tooltipAN').title = 'Моля, въведете 10-цифрен номер на телефон с водеща 0 или 12-цифрен номер на услуга (при НЕмобилни и пакетни услуги на А1). <br/>Ако по един договор имате повече от една услуга (няколко телефонни номера), в системата е необходимо да се регистрира само един от тези телефонни номера (една услуга), като ще се плащат задълженията по всички услуги по договора.';
            document.getElementById('clNumberMtel').title = 'Телефонен номер/Номер на услуга';
        }
        if (ss[0] == 14) {
            document.getElementById('tooltipAN').title = 'Моля, въведете абонатен номер, състоящат се от 11 цифри.';
        }
        if (ss[0] == 19) {
            document.getElementById('tooltipAN').title = 'Моля, въведете 10-цифрен номер на телефон с водеща 0.';
        }
        if (ss[0] == 6) {
            document.getElementById('tooltipAN').title = 'Моля, въведете клиентски номер, състоящ се от 6 до 11 цифри.';
        }
        if (ss[0] == 5) {
            document.getElementById('tooltipAN').title = 'Моля, въведете 9-цифрен абонатен номер.';
        }
        if (ss[0] == 3) {
            document.getElementById('tooltipAN').title = 'Моля, въведете 10-цифрен номер на договорна сметка с водеща цифра 2.';
        }
        if (ss[0] == 1) {
            document.getElementById('tooltipAN').title = 'Моля, въведете 12-цифрен абонатен номер.';
        }
    }
    else {
        if (ss[0] == 4) {//Мтел
            document.getElementById('tooltipAN').title = 'Please, enter a 10-digit telephone number with initial 0 or 12-digit number of a service (with non-mobile and packaged services of A1). <br/>In case you use more than one service (several telephone numbers) under a particular subscriber contract, only one of those telephone numbers (one service) has to be registered in the system, however as a result the obligations under all contractual services will be paid.';
        }
        if (ss[0] == 14) {//Близу
            document.getElementById('tooltipAN').title = 'Please, enter a subscriber number, comprised of 11 digits.';
        }
        if (ss[0] == 19) {//БОБ
            document.getElementById('tooltipAN').title = 'Pleaseq enter a 10-digit telephone number with initial 0.';
        }
        if (ss[0] == 6) {//Виваком
            document.getElementById('tooltipAN').title = 'Please, enter a client number, comprised of 6 to 11 digits.';
        }
        if (ss[0] == 5) {//Теленор
            document.getElementById('tooltipAN').title = 'Please, enter a 9-digit client number.';
        }
        if (ss[0] == 3) {//Софийска вода
            document.getElementById('tooltipAN').title = 'Please, enter a 10-digit contract account number.';
        }
        if (ss[0] == 1) {//ЧЕЗ
            document.getElementById('tooltipAN').title = 'Please, enter a 12-digit client number.';
        }
    }

    if (ss[0] != '4' && ss[0] != '19' && ss[0] != '6' && ss[0] != '14' && ss[0] != '5' && ss[0] != '3' && ss[0] != '1') {
        if (LNG == 'BG') {
            document.getElementById('tooltipAN').title = ss[6];
        }
        else {
            document.getElementById('tooltipAN').title = ss[7];
        }
    }

    if (ss[0] == 3) {//Софийска вода
        document.getElementById('f-subscription-model').value = '2NNNNNNNNN';
        document.getElementById('f-subscription-model').focus();
    }
    if (ss[0] == 1) {//ЧЕЗ
        document.getElementById('f-subscription-model').value = 'NNNNNNNNNNNN';
        document.getElementById('f-subscription-model').focus();
    }
    if (ss[0] == 5) {//Теленор
        document.getElementById('f-subscription-model').value = 'NNNNNNNNN';
        document.getElementById('f-subscription-model').focus();
    }
    if (ss[0] == 14) {//Теленор
        document.getElementById('f-subscription-model').value = 'NNNNNNNNNNN';
        document.getElementById('f-subscription-model').focus();
    }
}

function GetAn(strVal) {
    // тази ф-я се използва в MPLS_KKU_SUBSCRIPTIONS.xslt
    //зарежда макета и примера за АН за ККУ компания
    var ss = new Array(3)
    ss = strVal.split("|");
    document.getElementById('KKU_COMP').value = ss[0];
    document.getElementById('ANM').value = ss[1];
    document.getElementById('ClientDescription').value = ss[2];
    document.getElementById('KKU_COMP_NAME').value = ss[4];

    if (ss[0] == '2093') {
        //тринадесет цифри- 11 цифри номер на приемник+2 цифри вид услуга, а именно:<br/>
        //01-DTH TV СТАНДАРТЕН, 02-HBO, 03-DTH ИКОНОМИЧЕН, 04-PPV,<br/>05-ВТОРИ ПРИЕМНИК, 06-ПАКЕТ PREMIUM, 09-CINEMAX, 10-DIEMA EXTRA, 21 - HD1.</br>Когато в номер на приемника се съдържат символи GC01S, те се заменят с 5 нули.

        var strHelp = "";
        strHelp = strHelp + "<font color='#d20c0c'>За заплащане на ТЕЛЕВИЗИЯ:</font><br/><p style='margin:0; padding:0;text-align:justify;'>Регистрира се номера на основния приемник, който се състои от 11 (единадесет) цифри и в края се добавя двуцифрен код в зависимост от услугата, която клиентът ползва. Моля, имайте предвид, че за всяка отделна услуга трябва да се въведе отделно съгласие:"
        strHelp = strHelp + "<center><table class='smetka_movement' border='0' cellpadding='0' cellspacing='0'><tr><td>код - услуга</td><td>код - услуга</td><td>код - услуга</td></tr>"
        strHelp = strHelp + "<tr><td>01 - DTH TV СТАНДАРТЕН</td><td>06 - ПАКЕТ PREMIUM</td><td>21 - SPORT+</td></tr>";
        strHelp = strHelp + "<tr><td>02 - Action+Comedy</td><td>07 - DIEMA EXTRA</td><td>25 - Fusion</td></tr>";
        strHelp = strHelp + "<tr><td>05 - ДОПЪЛНИТЕЛНИ ПРИЕМНИЦИ</td><td>09 - CINEMA+</td><td></td></tr></table></center>";

        strHelp = strHelp + "<p style='margin:0; padding:0;text-align:justify;'>За клиенти, ползващи услугата „Допълнителни приемници“ при регистриране на съгласие се въвежда само номера на основния приемник, като след него се добавя код 05 (независимо от броя на допълнителните приемници). От Булсатком ще подават отделно задълженията за всеки отделен приемник. </p><br/>";

        strHelp = strHelp + "Въвеждането на всички останали задължително трябва да започва със стандартен пакет.<br/>Пример: &#160;&#160; номер на основен приемник: 11000000014; услуги: ПАКЕТ PREMIUM, CINEMA+<br/>";
        strHelp = strHelp + "Съгласията, които трябва да се въведат, са:  11000000014<font color='#d20c0c'>01</font>, 11000000014<font color='#d20c0c'>06</font>, 11000000014<font color='#d20c0c'>09</font><br/>";

        strHelp = strHelp + "<br/><font color='#d20c0c'>За заплащане на ИНТЕРНЕТ:</font><br/><p style='margin:0; padding:0;text-align:justify;'>Въвежда се номера на договора за интернет, който се състои от 11 цифри  и започва с 22, като в края се добавя двуцифрен код в зависимост от скоростта на потребление.</p>";
        strHelp = strHelp + "<center><table class='smetka_movement' border='0' cellpadding='0' cellspacing='0'><tr><td>скорост - код</td><td>скорост - код</td><td>скорост - код</td><td>скорост - код</td></tr>"
        strHelp = strHelp + "<tr><td>15mbps - 35</td><td>25mbps - 36</td><td>50mbps - 38</td><td>100mbps - 39</td></tr></table></center><br/>";

        strHelp = strHelp + "Пример: &#160;&#160;&#160;  номер на договор: 22000001243; скорост 25mbps - код 36<br/>номер, който се въвежда в системата следва да бъде 22000001243<font color='#d20c0c'>36</font><br/><br/>";
        strHelp = strHelp + "<p style='margin:0; padding:0;text-align:justify;'>В случаите, когато клиентът няма отделен номер на интернет договор, а ползва пакетна услуга телевизия+интернет, регистрацията се извършва по номер на основен приемник, като се добавя  съответният  двуцифрен код за интернет потребление.</p>";
        document.getElementById('SpecialHelp').innerHTML = strHelp;
    }
    else if (ss[0] == '1261')
        document.getElementById('SpecialHelp').innerHTML = "В поле абонатен номер се въвежда номер на водомер.";
    else if (ss[0] == '95' || ss[0] == '99') {
        var strHelpEVN = "";
        strHelpEVN = strHelpEVN + "<font color='#d20c0c'>Абонатен номер за ЕВН - Електроразпределение и ЕВН - Топлофикация</font><br/><p style='margin:0; padding:0;text-align:justify;'>";
        strHelpEVN = strHelpEVN + "<font color='#d20c0c'></font><br/><p style='margin:0; padding:0;text-align:justify;'>Полето абонатен номер се състои от 17 цифри, като се въвеждат: 7 цифри ИТН и 10 цифри клиентски номер към компанията, задължително в посочената последователност, без интервали.";
        strHelpEVN = strHelpEVN + "<br/><p style='margin:0; padding:0;text-align:justify;'>Пример: ";
        strHelpEVN = strHelpEVN + "<br/><p style='margin:0; padding:0;text-align:justify;'>ЕВН ИТН: 7777777";
        strHelpEVN = strHelpEVN + "<br/><p style='margin:0; padding:0;text-align:justify;'>ЕВН Клиентски номер: 1111111111";
        strHelpEVN = strHelpEVN + "<br/><br/><p style='margin:0; padding:0;text-align:justify;'>В полето „Абонатен номер” се въвежда: 77777771111111111. ";

        document.getElementById('SpecialHelp').innerHTML = strHelpEVN;
    }
    else
        document.getElementById('SpecialHelp').innerHTML = "<table class='smetka_movement' border='0' cellpadding='0' cellspacing='0'><tr><td colspan='3' class='fields'>В макета може да присъстват следните символи</td></tr><tr><td align='left' class='fields'> N - цифра</td><td  align='left' class='fields'>A – цифра или буква на латиница</td><td  align='left' class='fields'>L – буква на латиница</td></tr><tr><td  align='left' class='fields'>Q – цифра или буква на кирилица</td><td  align='left' class='fields'>S – произволен символ</td><td  align='left' class='fields'>K – буква на кирилица</td></tr></table>";
}


function GetIBAN(strVal, idForm) {
    // тази ф-я се използва в EINVOICE_PAY.xslt  
    var F = document.getElementById(idForm);
    var ss = new Array(3);
    ss = strVal.split("|");
    F.elements["ACC_R"].value = ss[0];
    F.elements["BIC_R"].value = ss[1];
    F.elements["IBAN"].value = ss[0];
    F.elements["REM_I"].value = F.elements["REM_I"].value.toUpperCase();
    F.elements["REM_II"].value = F.elements["REM_II"].value.toUpperCase();
    F.elements["NAME_S"].value = F.elements["NAME_S"].value.toUpperCase();
    F.elements["NAME_R"].value = F.elements["NAME_R"].value.toUpperCase();
}


function GetAnByCompId(strVal) {
    // тази ф-я се използва в MPLS_KKU_SUBSCRIPTIONS.xslt
    //претърсва списъка с компаниите за да извлече модела на АН
    //използва се при отказаните съгласия, за да се провери АН в случая когато искаме да го активираме

    var found = false;
    var san = new Array(4);
    var ss = new Array(4);

    san = strVal.split("_");
    // Активни съгласия могат да се отказват без проверка за валидност на абонатния номер
    if (san[4] == 1) return true;

    for (var i = 0; i < document.getElementById('AllComps').length; i++) {
        if (!found) {
            ss = document.getElementById('AllComps').item(i).value.split("|");
            if (san[0] == ss[0]) found = true;
        }
    }

    if (found) {

        var compAN1 = san[2];
        compAN1 = trim(compAN1);
        var compAN2 = ss[1];
        compAN2 = trim(compAN2);

        if (!IsValidAN(compAN1, compAN2))
            return false;
        else
            return true;
    }
    else
        return false;
}


function GetCurent(idTab, row) {
    // тази ф-я се използва в MPLS_KKU_SUBSCRIPTIONS.xslt
    //зарежда данните за посочено активно или неактивно съгласие във формата "Добавяне на съгласие"
    //да не се допуска зареждане на данните за 3481-ОББ ЕЙ АЙ ДЖИ ЛАЙФ ЗД АД и  2526-ПОК Доверие
    var idTable = document.getElementById(idTab);
    var ss = new Array(3)
    var j = 0;
    var j2 = 0;
    var k2 = 0;

    for (var i = 1; i < document.getElementById('AllComps').length; i++) {
        if (j == 0) {
            ss = document.getElementById('AllComps').item(i).value.split("|");
            if (ss[0] == idTable.rows[row].cells[6].innerHTML) {
                j = i;
                j2 = parseInt(ss[3]);
                FillSelect(j2);
                GetAn(document.getElementById('AllComps').item(j).value);
                for (var k = 1; k < document.getElementById('KKUComps').length; k++) {
                    if (k2 == 0 && (document.getElementById('KKUComps').item(k).value == document.getElementById('AllComps').item(j).value))
                        k2 = k;

                }//for(k)
            }
        }
    }

    //EK dobaveno na 3.11.2010
    for (var p = 1; p < document.getElementById('KKUGroups').length; p++) {
        if (document.getElementById('KKUGroups').item(p).value == j2)
            document.getElementById('KKUGroups').item(p).selected = true;
    }//for(p)

    document.getElementById('AllComps').item(j).selected = true;
    document.getElementById('KKUComps').item(k2).selected = true;

    document.getElementById('NEW_AN').value = idTable.rows[row].cells[2].innerHTML;
    document.getElementById('AN_DESCRIPTION').value = idTable.rows[row].cells[3].innerHTML;
    document.getElementById('SUBSCRIBER_NAME').value = idTable.rows[row].cells[4].innerHTML;

}

function GetCurentSubsc(idTab, row, idForm) {

     var idTable = document.getElementsByName(idTab)[1];
        var F = document.getElementById(idForm);

        F.elements['AN'].value = idTable.rows[row].cells[1].innerHTML;
        F.elements['CompanyId'].value = idTable.rows[row].cells[4].innerHTML;
        if (idTable.rows[row].cells[6].innerHTML == 'Активен' || idTable.rows[row].cells[6].innerHTML == 'Active')
            F.elements['Status'].value = "1";
        else
            F.elements['Status'].value = "0";


        //F.elements['Subscriber_Name'].value = idTable.rows[row].cells[2].innerHTML;
        F.elements['AN_Description'].value = idTable.rows[row].cells[2].innerHTML;
        F.elements['KKU_Comp'].value = idTable.rows[row].cells[4].innerHTML;
        F.elements['new_AN'].value = idTable.rows[row].cells[1].innerHTML;
        // F.elements['KKU_COMP_NAME'].value = idTable.rows[row].cells[1].innerHTML;
        F.elements['KKU_COMP_NAME'].value = idTable.rows[row].cells[0].innerHTML;

        $('#' + idForm + ' #AN_Description').blur();
        //$('#' + idForm + ' #Subscriber_Name').blur();
}

function GetCurentSubscUP(idTab, row, idForm) {

    var idTable = document.getElementsByName(idTab)[1];
    var F = document.getElementById(idForm);
    var vLNG = document.getElementById('frmEditSub').elements['LNG'].value;

    F.elements['KKU_COMP_NAME'].value = idTable.rows[row].cells[0].innerHTML;
    F.elements['AN'].value = idTable.rows[row].cells[1].innerHTML;
    F.elements['CompanyId'].value = idTable.rows[row].cells[4].innerHTML;
    //if (idTable.rows[row].cells[5].innerHTML == 'Активен' || idTable.rows[row].cells[5].innerHTML == 'Active')
    //    F.elements['Status'].value = "1";
    //else
    //    F.elements['Status'].value = "0";


    //F.elements['Subscriber_Name'].value = idTable.rows[row].cells[2].innerHTML;
    if (idTable.rows[row].cells[2].innerHTML == ' ' || idTable.rows[row].cells[2].innerHTML == 'null') {
        F.elements['AN_Description'].value = null;
    }
    else {
        F.elements['AN_Description'].value = idTable.rows[row].cells[2].innerHTML;
    }
    F.elements['KKU_Comp'].value = idTable.rows[row].cells[4].innerHTML;
    F.elements['new_AN'].value = idTable.rows[row].cells[1].innerHTML;
    if (F.elements['PMCount'].value != 0 && F.elements['PMCount'].value == F.elements['PMAll'].value) {

    }
    else {
        F.elements['ACC_S'].value = idTable.rows[row].cells[7].innerHTML;
        F.elements['Limit'].value = idTable.rows[row].cells[8].innerHTML;
    }

    if (idTable.rows[row].cells[6].innerHTML == 'Ръчен' || idTable.rows[row].cells[6].innerHTML == 'Ръчен '
	|| idTable.rows[row].cells[6].innerHTML == 'Manual' || idTable.rows[row].cells[6].innerHTML == 'Manual ') {
        F.elements['PAYMODE'].value = "1";
        F.elements['MODE'].value = "MANUAL";

        $('#frmEditSub #toggle_0').addClass("active");
        $('#frmEditSub #toggle_1').removeClass("active");
        $('#frmEditSub #toggle_btn').addClass("active");
        $('#frmEditSub #payment-type2').val("0");
        $('#frmEditSub #MODE').val("MANUAL");
        document.getElementById('AutoMode').style.display = "none";
    }
    else {
        F.elements['PAYMODE'].value = "0";
        F.elements['MODE'].value = "AUTO";

        $('#frmEditSub #toggle_0').removeClass("active");
        $('#frmEditSub #toggle_1').addClass("active");
        $('#frmEditSub #toggle_btn').removeClass("active");
        $('#frmEditSub #payment-type2').val("1");
        $('#frmEditSub #MODE').val("AUTO");
        document.getElementById('AutoMode').style.display = "inline-block";

        var accEdit = $('#frmEditSub #ACC_S').val();
        //if (accEdit.length == 22) {
        //    $('#frmEditSub #f-acc').find('option[value^="' + accEdit + '"]').prop('selected', true).change().trigger('select2:select');
        //}
        //else {
        //    //var cardEdit = $('#frmEditSub #wCRCARD_PID').val();
        //    //var pcard;
        //    //pcard = cardEdit.value.substr(0, this.value.indexOf('|'));
        //    $('#frmEditSub #f-acc1').find('option[value^="' + accEdit + '"]').prop('selected', true).change().trigger('select2:select');
        //}
    }

    //setTimeout(function () {
    //document.getElementById("idMBASE64XML").value = "";
    //idAJAXResult = "f-acc1";
    ////document.getElementById("idMSID") = "C39B45285BD542A189FC69C1D863957D";
    //document.getElementById("idMlng").value = "BG";
    //document.getElementById("idMCOMMAND").value = "EXEC";
    //document.getElementById("idMORDNAME").value = "LIST.CARDS.GLID";
    //document.getElementById("idMGLOBUSID").value = "4881400";
    //document.getElementById("idMEGNBULSTAT").value = "9207156051";

    //var sbody = ObtainBody("frmMain");
    //SendPostRequestAc("t.aspx", sbody, function () {
    //    var result = document.getElementById('f-acc1').innerHTML;
    //    select.html(result);
    //});
    //delete (sbody);

    //}, 10);

    if (vLNG == 'EN') {
        strNoResults = "No results found";
    }
    else {
        strNoResults = "Няма намерени резултати";
    }


    $('#f-acc').select2({
        //tags: "true",
        allowClear: true,
        placeholder: "",
        language: {
            noResults: function () {
                return strNoResults;
            }
        }
    })
    $('#f-acc').on("select2:unselecting", function (e) {
        $('#ACC_S').val("");
    }).trigger('change');

    $('#f-acc1').select2({
        //tags: "true",
        allowClear: true,
        placeholder: "",
        language: {
            noResults: function () {
                return strNoResults;
            }
        }
    })
    $('#f-acc1').on("select2:unselecting", function (e) {
        $('#CRCARD_PID').val("");
    }).trigger('change');

    $('#' + idForm + ' #AN_Description').blur();
    //$('#' + idForm + ' #Subscriber_Name').blur();
    $('#' + idForm + ' #Limit').blur();

    //openPopupZB("popup-edit2", 100); //9045
    openPopup("popup-edit2");
}

function OpenPopupUM(idTab, row, idForm, salary, Utrade, Clientmanagement, Cardmerchant, Biller, broker, Customerposition, Recipient, BMSignGroup, TradeFinanceR, TradeFinanceA) {

    var idTable = document.getElementsByName(idTab)[1];
    var F = document.getElementById(idForm);


    F.elements['DateOfBirth'].value = idTable.rows[row].cells[2].innerText;
    F.elements['FirstName'].value = idTable.rows[row].cells[0].innerText;
    F.elements['ThirdName'].value = idTable.rows[row].cells[1].innerText;
    F.elements['DescPos'].value = idTable.rows[row].cells[3].innerText;

    

    F.elements['mobile'].value = idTable.rows[row].cells[4].innerHTML;
    if (BMSignGroup != '0') {
        F.elements['BMSignGroup'].checked = BMSignGroup;
    }
    else {
        F.elements['BMSignGroup'].checked = false;
    }

    F.elements['Salary'].checked = salary;
    F.elements['UTrade'].checked = Utrade;
    F.elements['ClientManagement'].checked = Clientmanagement;
    F.elements['CardMerchant'].checked = Cardmerchant;
    /*
    if (Biller == '1') {
        F.elements['EINVOICE'].checked = Biller;
    }
    else {
        F.elements['EINVOICE'].checked = false;
    }
    if (Recipient == '1') {
        F.elements['EINVOICE'].checked = Recipient;
    }
    else {
        F.elements['EINVOICE'].checked = false;
    } */
    //OOBT-865
    if ((Recipient == '0' || Recipient == "") && (Biller == '0' || Biller == "")) {
        F.elements['EINVOICE'].checked = false;
    }
    else {
        F.elements['EINVOICE'].checked = true;
    }
    F.elements['Broker'].checked = broker;
    F.elements['CustomerPosition'].checked = Customerposition;
    //OOBT-865
    if ((TradeFinanceR == '0' || TradeFinanceR == "") && (TradeFinanceA == '0' || TradeFinanceA == "")) {
        F.elements['TradeFinance'].checked = false;
    }
    else {
        F.elements['TradeFinance'].checked = true;
    }
    openPopup("popup-edit2");
}



function FillSelect(grpCode) {
    //тази ф-я се използва в MPLS_KKU_SUBSCRIPTIONS.xslt
    //зарежда списък с компании за дадена група от общия списък с компании
    var objKKUComps = document.getElementById('KKUComps');
    //изчистване на списъка
    for (var i = document.getElementById('KKUComps').length; i >= 0 ; i--) {
        document.getElementById('KKUComps').remove(i);
    }
    //пълнене на списъка
    for (var i = 0; i < document.getElementById('AllComps').length; i++) {
        ss = document.getElementById('AllComps').item(i).value.split("|");
        if (ss[3] == grpCode) {
            var oOption = document.createElement("OPTION");
            document.getElementById('KKUComps').options.add(oOption);
            oOption.innerHTML = document.getElementById('AllComps').item(i).innerHTML;
            oOption.value = document.getElementById('AllComps').item(i).value;
        }
    }

    //нова проверка, добавена на 14.10.2010   Елена Кюрчиева
    if (grpCode != 0) {
        GetAn(document.getElementById('KKUComps').item(0).value); //добавено на 26/11/2008*** 
    }
    else {
        document.getElementById('SpecialHelp').innerHTML = "";
        document.getElementById('NEW_AN').value = "";
        document.getElementById('AN_DESCRIPTION').value = "";
        document.getElementById('SUBSCRIBER_NAME').value = "";
        document.getElementById('KKU_COMP').value = "";
        document.getElementById('ANM').value = "";
        document.getElementById('ClientDescription').value = "";
    }

}

function FillSelectMun(grpCode, currentmun) {
    var countMun = grpCode.split("|");
    var vLNG = document.getElementById('frmGetTaxes').elements['lng'].value;
    //тази ф-я се използва в TAXES_OBLIGATIONS.xslt
    //зарежда списък с райони за дадена община от общия списък с общини
    var objKKUComps = document.getElementById('IDMUNICIPALITY1');
    //изчистване на списъка
    for (var i = document.getElementById('IDMUNICIPALITY1').length; i >= 0 ; i--) {
        document.getElementById('IDMUNICIPALITY1').remove(i);
    }
    var count = 0;
    //пълнене на списъка
    if (countMun[1] > 1) {
        var oOption = document.createElement("OPTION");
        document.getElementById('IDMUNICIPALITY1').options.add(oOption);
        oOption.value = "0";
    }

    for (var i = 0; i < document.getElementById('AllMuns').length; i++) {
        ss = document.getElementById('AllMuns').item(i).value.split("|");
        if (ss[3] == countMun[0]) {
            count++;
            var oOption = document.createElement("OPTION");
            document.getElementById('IDMUNICIPALITY1').options.add(oOption);
            oOption.innerHTML = document.getElementById('AllMuns').item(i).innerHTML;
            oOption.value = document.getElementById('AllMuns').item(i).value;
            if (ss[0] == currentmun) {
                oOption.selected = true;
            }
        }
    }
    if (count < 2) {
        document.getElementById('rowMun').style.display = "none";
        document.getElementById('IDMUNICIPALITY1').style.display = 'none';
    }
    else {
        //document.getElementById('rowMun').style.display = "";
        //document.getElementById('IDMUNICIPALITY1').style.display = "";
        document.getElementById('rowMun').style.display = "none";
        document.getElementById('IDMUNICIPALITY1').style.display = 'none';
    }
}

function FillSelectMunRe(grpCode, currentmun) {
    var countMun = grpCode.split("|");
    var vLNG = document.getElementById('frmGetTaxes').elements['lng'].value;
    //тази ф-я се използва в TAXES_OBLIGATIONS.xslt
    //зарежда списък с райони за дадена община от общия списък с общини
    var objKKUComps = document.getElementById('IDMUNICIPALITY1');
    //изчистване на списъка
    for (var i = document.getElementById('IDMUNICIPALITY1').length; i >= 0 ; i--) {
        document.getElementById('IDMUNICIPALITY1').remove(i);
    }
    var count = 0;
    //пълнене на списъка
    if (countMun[1] > 1) {
        var oOption = document.createElement("OPTION");
        document.getElementById('IDMUNICIPALITY1').options.add(oOption);
        if (vLNG == "EN") {
            oOption.innerHTML = "-----Select Region-----";
        }
        else {
            oOption.innerHTML = "-----Изберете район-----";
        }
        oOption.value = "0";
    }

    for (var i = 0; i < document.getElementById('AllMuns').length; i++) {
        ss = document.getElementById('AllMuns').item(i).value.split("|");
        if (ss[3] == countMun[0]) {
            count++;
            var oOption = document.createElement("OPTION");
            document.getElementById('IDMUNICIPALITY1').options.add(oOption);
            oOption.innerHTML = document.getElementById('AllMuns').item(i).innerHTML;
            oOption.value = document.getElementById('AllMuns').item(i).value;
            if (ss[0] == currentmun) {
                oOption.selected = true;
            }
        }
    }
    if (count < 2) {
        document.getElementById('rowMun').style.display = "none";
        document.getElementById('IDMUNICIPALITY1').style.display = 'none';
    }
    else {

        document.getElementById('rowMun').style.display = "";
        document.getElementById('IDMUNICIPALITY1').style.display = "";
    }
}

function ClearNewSubscription(strForm) {
    //тази ф-я се използва в MPLS_KKU_SUBSCRIPTIONS.xslt
    //изчиства формата "Добавяне на съгласие"

    //изчистване на списъка
    for (var i = document.getElementById('KKUComps').length; i >= 0 ; i--) {
        document.getElementById('KKUComps').remove(i);
    }
    document.getElementById('SpecialHelp').innerHTML = "";
    document.getElementById('AllComps').item(0).selected = true;
    document.getElementById('KKUGroups').item(0).selected = true;

    document.getElementById('NEW_AN').value = "";
    document.getElementById('AN_DESCRIPTION').value = "";
    document.getElementById('SUBSCRIBER_NAME').value = "";
    document.getElementById('KKU_COMP').value = "";
    document.getElementById('ANM').value = "";
    document.getElementById('ClientDescription').value = "";

}




function SubmitLog(idForm, strWhereSave, lng) {
    var strText = 'Бихме искали да Ви информираме, че във връзка с планирана промяна в политиката за идентификация и подписване на електронни трансакции, от 01.06.2017г. ОББ преустановява регистрирането на Квалифицирани електронни подписи (КЕП) за работа в онлайн банкиране. \r\n\r За подписване на електронни трансакции, е необходимо да инсталирате сертификат, издаден от банката. \r\n\r За Ваше удобство е осигурена възможност за отдалечено заявяване на ОББ сертификат през секция Профил, Заявка за нов сертификат. След обработка на заявката до 1 работен ден, в секция Профил ще е  достъпно меню Изтегляна на нов сертификат за инсталиране чрез паролата за сертификат, изпратена Ви като SMS.';
    var strTextEN = 'We would like to inform you that in line with a planned change in our Policy on electronic transactions’ authentication and signing, with effect from 01.06.2017 UBB discontinues the registration of Qualified Electronic Signatures (QES) for use in online banking. \r\n\r After this date, to enable e-transactions’ signing, you will need to install a certificate, issued by the Bank. \r\n\r For your convenience, there is an option to obtain such certificate remotely, via the PROFILE section, Request new certificate.';

    if (lng == 'EN') {
        createCustomAlertDeclaration(strTextEN); //5501
    }
    else {
        createCustomAlertDeclaration(strText); //5501
    }

}



function IsValidAN(sAN, sANModel) {

    if (sAN.length != sANModel.length) {
        window.alert("Невалиден абонатен номер!\nАбонатният номер трябва да е с дължина " + sANModel.length + " символа!");
        return false;
    }

    for (i = 0; i < sANModel.length; i++) {
        switch (sANModel.charAt(i)) {
            case "K":
                if (!isLetterCyr(sAN.charCodeAt(i))) {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е буква на кирилица!");
                    return false;
                }
                break;

            case "L":
                if (!isLetterLat(sAN.charCodeAt(i))) {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е буква на латиница!");
                    return false;
                }
                break;

            case "N":
                if (!isDigit(sAN.charCodeAt(i))) {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е цифра!");
                    return (false);
                }
                break;

            case "A":
                if (!(isLetterLat(sAN.charCodeAt(i)) || isDigit(sAN.charCodeAt(i)))) {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е цифра или буква на латиница!");
                    return (false);
                }
                break;

            case "Q":
                if (!(isLetterCyr(sAN.charCodeAt(i)) || isDigit(sAN.charCodeAt(i)))) {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е цифра или буква на кирилица!");
                    return (false);
                }
                break;



            case "0":
                if (sAN.charCodeAt(i) != "48") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 0!");
                    return (false);
                }
                break;

            case "1":
                if (sAN.charCodeAt(i) != "49") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 1!");
                    return (false);
                }
                break;

            case "2":
                if (sAN.charCodeAt(i) != "50") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 2!");
                    return (false);
                }
                break;

            case "3":
                if (sAN.charCodeAt(i) != "51") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 3!");
                    return (false);
                }
                break;

            case "4":
                if (sAN.charCodeAt(i) != "52") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 4!");
                    return (false);
                }
                break;

            case "5":
                if (sAN.charCodeAt(i) != "53") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 5!");
                    return (false);
                }
                break;

            case "6":
                if (sAN.charCodeAt(i) != "54") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 6!");
                    return (false);
                }
                break;

            case "7":
                if (sAN.charCodeAt(i) != "55") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 7!");
                    return (false);
                }
                break;

            case "8":
                if (sAN.charCodeAt(i) != "56") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 8!");
                    return (false);
                }
                break;

            case "9":
                if (sAN.charCodeAt(i) != "57") {
                    window.alert("Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 9!");
                    return (false);
                }
                break;

        }
    }
    return true;
}


function IsValidANRe(sAN, sANModel) {

    var sAnValue = sAN.value;
    var sANModelValue = sANModel.value;
    if (sAnValue.length != sANModelValue.length) {
        elemError(sAN, "Невалиден абонатен номер!\nАбонатният номер трябва да е с дължина " + sANModelValue.length + " символа!");
        return false;
    }

    for (i = 0; i < sANModelValue.length; i++) {
        switch (sANModelValue.charAt(i)) {
            case "K":
                if (!isLetterCyr(sAnValue.charCodeAt(i))) {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е буква на кирилица!");
                    return false;
                }
                break;

            case "L":
                if (!isLetterLat(sAnValue.charCodeAt(i))) {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е буква на латиница!");
                    return false;
                }
                break;

            case "N":
                if (!isDigit(sAnValue.charCodeAt(i))) {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е цифра!");
                    return (false);
                }
                break;

            case "A":
                if (!(isLetterLat(sAnValue.charCodeAt(i)) || isDigit(sAnValue.charCodeAt(i)))) {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е цифра или буква на латиница!");
                    return (false);
                }
                break;

            case "Q":
                if (!(isLetterCyr(sAnValue.charCodeAt(i)) || isDigit(sAnValue.charCodeAt(i)))) {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е цифра или буква на кирилица!");
                    return (false);
                }
                break;



            case "0":
                if (sAnValue.charCodeAt(i) != "48") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 0!");
                    return (false);
                }
                break;

            case "1":
                if (sAnValue.charCodeAt(i) != "49") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 1!");
                    return (false);
                }
                break;

            case "2":
                if (sAnValue.charCodeAt(i) != "50") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 2!");
                    return (false);
                }
                break;

            case "3":
                if (sAnValue.charCodeAt(i) != "51") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 3!");
                    return (false);
                }
                break;

            case "4":
                if (sAnValue.charCodeAt(i) != "52") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 4!");
                    return (false);
                }
                break;

            case "5":
                if (sAnValue.charCodeAt(i) != "53") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 5!");
                    return (false);
                }
                break;

            case "6":
                if (sAnValue.charCodeAt(i) != "54") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 6!");
                    return (false);
                }
                break;

            case "7":
                if (sAnValue.charCodeAt(i) != "55") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 7!");
                    return (false);
                }
                break;

            case "8":
                if (sAnValue.charCodeAt(i) != "56") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 8!");
                    return (false);
                }
                break;

            case "9":
                if (sAnValue.charCodeAt(i) != "57") {
                    elemError(sAN, "Невалиден абонатен номер!\nСимвол " + (i + 1) + " от абонатния номер трябва да е 9!");
                    return (false);
                }
                break;

        }
    }
    return true;
}


function isDigit(iCode) {
    if (iCode < 48 || iCode > 57) return false; //ако не е цифра
    else return true;
}

function isLetterLat(iCode) {
    if ((iCode >= "a".charCodeAt(0) && iCode <= "z".charCodeAt(0)) || (iCode >= "A".charCodeAt(0) && iCode <= "Z".charCodeAt(0))) return true;
    else return false;
}


function isLetterCyr(iCode) {
    if ((iCode >= "а".charCodeAt(0) && iCode <= "я".charCodeAt(0)) || (iCode >= "А".charCodeAt(0) && iCode <= "Я".charCodeAt(0))) return true;
    else return false;
}



function IsValidEmail(sEmail) {
    if (sEmail.indexOf(" ") != -1) return false; //не трябва да съдържа шпации
    var index = sEmail.indexOf("@");
    if (index <= 0 || index == sEmail.length - 1) return false; //няма "@" или е първи или последен символ
    else if (sEmail.indexOf("@", index + 1) != -1) return false; //повече от веднъж "@"

    var strMail = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ._-";
    var charValue = "";

    for (i = 0; i < sEmail.length; i++) {
        if (index != i) {
            charValue = strMail.indexOf(sEmail.substr(i, 1), 0);
            if (charValue < 0) {
                window.alert("Невалиден e-mail!\nСимвол " + (i + 1) + " от e-mail трябва да е буква на латиница или цифра.");
                return false;
            }
        }
    }


    return true;
}


function IsValidGSM(sTel) {

    if (sTel.substr(0, 1) != "0" && sTel.substr(0, 3) != "359")
        return false;
    if (sTel.substr(0, 1) == "0" && sTel.length != 10)
        return false;
    if (sTel.substr(0, 3) == "359" && sTel.length != 12)
        return false;

    for (var k = 0; k < sTel.length; k++) { //трябва да съдържа само цифри
        if ((sTel.charCodeAt(k) < 48 || sTel.charCodeAt(k) > 57)) //ако не е цифра или шпация
            return false;

    }
    return true;
}

function IsValidMPLSRegPayer() {


    var ocbxSend = document.getElementById('send');
    var payWith = document.getElementById('frmRegPayer').elements['PAYWITH'];
    var vLNG = document.getElementById('frmRegPayer').elements['LNG'].value;

    if (typeof (payWith) != 'undefined') {
        if (!payWith[0].checked && !payWith[1].checked) {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, choose way of payment.");
            else
                createCustomAlertDeclaration("Моля, изберете платежно средство.");

            return false;
        }
    }

    if (!ocbxSend.checked) {
        if (typeof (payWith) != 'undefined') {
            if (payWith[0].checked) {
                if (vLNG == 'EN')
                    createCustomAlertDeclaration("Please, read UBB AD General Terms on Accounts of Individuals and the Specific Terms for the service Payment of Utility Bills Through a Current Account");
                else
                    createCustomAlertDeclaration("Моля, запознайте се с Общите условия на ОББ АД за сметки на физически лица и Специфичните условия за услугата Заплащане на битови сметки от сметка.");
            }
            else if (payWith[1].checked) {
                if (vLNG == 'EN')
                    createCustomAlertDeclaration("Please, read UBB AD General Terms on Debit and Credit Cards and the Specific Terms for the service  Payment of Utility Bills Through a Credit Card .");
                else
                    createCustomAlertDeclaration("Моля, запознайте се с Общите условия на ОББ АД за дебитни и кредитни карти и Специфичните условия за услугата Заплащане на битови сметки от кредитна карта.");
            }
            else {
                if (vLNG == 'EN')
                    createCustomAlertDeclaration("Please, choose way of payment.");
                else
                    createCustomAlertDeclaration("Моля, изберете платежно средство.");
            }
        }
        else {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, confirm the declaration. ");
            else
                createCustomAlertDeclaration("Моля, потвърдете декларацията.");
        }
        return false;
    }

    var frm = document.getElementById('frmRegPayer');
    if (frm.elements['ALERTADDRESS'].value != '' && !IsValidEmail(frm.elements["ALERTADDRESS"].value) && !IsValidGSM(frm.elements["ALERTADDRESS"].value)) {
        if (vLNG == 'EN')
            createCustomAlertDeclaration("Incorrect address for alerts. Please enter a valid e-mail or GSM number (it should start with a 0 or be a 10-digit one or begin with 359 and contain 12 digits.");
        else
            createCustomAlertDeclaration("Некоректен адрес за алерти " + frm.elements["ALERTADDRESS"].value + ". Моля, въведете валиден e-mail или GSM номер(трябва да започва с 0-ла и да бъде 10 цифрен или да започва с 359 и да бъде 12 цифри).");

        return false;
    }

    if (typeof (payWith) != 'undefined') {
        if (payWith[0].checked && (frm.elements["ACC_S"].value == '' || frm.elements["ACC_S"].value == '-')) {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, choose account.");
            else
                createCustomAlertDeclaration("Моля, изберете сметка.");

            return false;
        }
        else if (payWith[1].checked && (frm.elements["wCRCARD_PID"].value == '' || frm.elements["wCRCARD_PID"].value == '-')) {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, choose credit card.");
            else
                createCustomAlertDeclaration("Моля, изберете кредитна карта.");
            return false;
        }
    }


    return true;

}

function IsValidMPLSRegPayerHome() {


    var ocbxSend = document.getElementById('sendH');
    var payWith = document.getElementById('frmRegPayer').elements['PAYWITH'];
    var vLNG = document.getElementById('frmRegPayer').elements['LNG'].value;

    if (typeof (payWith) != 'undefined') {
        if (!payWith[0].checked && !payWith[1].checked) {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, choose way of payment.");
            else
                createCustomAlertDeclaration("Моля, изберете платежно средство.");

            return false;
        }
    }

    if (!ocbxSend.checked) {
        if (typeof (payWith) != 'undefined') {
            if (payWith[0].checked) {
                if (vLNG == 'EN')
                    createCustomAlertDeclaration("Please, read UBB AD General Terms on Accounts of Individuals and the Specific Terms for the service Payment of Utility Bills Through a Current Account");
                else
                    createCustomAlertDeclaration("Моля, запознайте се с Общите условия на ОББ АД за сметки на физически лица и Специфичните условия за услугата Заплащане на битови сметки от сметка.");
            }
            else if (payWith[1].checked) {
                if (vLNG == 'EN')
                    createCustomAlertDeclaration("Please, read UBB AD General Terms on Debit and Credit Cards and the Specific Terms for the service  Payment of Utility Bills Through a Credit Card .");
                else
                    createCustomAlertDeclaration("Моля, запознайте се с Общите условия на ОББ АД за дебитни и кредитни карти и Специфичните условия за услугата Заплащане на битови сметки от кредитна карта.");
            }
            else {
                if (vLNG == 'EN')
                    createCustomAlertDeclaration("Please, choose way of payment.");
                else
                    createCustomAlertDeclaration("Моля, изберете платежно средство.");
            }
        }
        else {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, confirm the declaration. ");
            else
                createCustomAlertDeclaration("Моля, потвърдете декларацията.");
        }
        return false;
    }

    var frm = document.getElementById('frmRegPayer');
    if (frm.elements['ALERTADDRESS'].value != '' && !IsValidEmail(frm.elements["ALERTADDRESS"].value) && !IsValidGSM(frm.elements["ALERTADDRESS"].value)) {
        if (vLNG == 'EN')
            createCustomAlertDeclaration("Incorrect address for alerts. Please enter a valid e-mail or GSM number (it should start with a 0 or be a 10-digit one or begin with 359 and contain 12 digits.");
        else
            createCustomAlertDeclaration("Некоректен адрес за алерти " + frm.elements["ALERTADDRESS"].value + ". Моля, въведете валиден e-mail или GSM номер(трябва да започва с 0-ла и да бъде 10 цифрен или да започва с 359 и да бъде 12 цифри).");

        return false;
    }

    if (typeof (payWith) != 'undefined') {
        if (payWith[0].checked && (frm.elements["ACC_S"].value == '' || frm.elements["ACC_S"].value == '-')) {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, choose account.");
            else
                createCustomAlertDeclaration("Моля, изберете сметка.");

            return false;
        }
        else if (payWith[1].checked && (frm.elements["wCRCARD_PID"].value == '' || frm.elements["wCRCARD_PID"].value == '-')) {
            if (vLNG == 'EN')
                createCustomAlertDeclaration("Please, choose credit card.");
            else
                createCustomAlertDeclaration("Моля, изберете кредитна карта.");
            return false;
        }
    }


    return true;

}

function messForex(f, mess) {
    removeError(f);
    var frm = document.getElementById(f);
    elemError(frm.elements["DEALREFi"], mess);
    return false;
}

function IsValidEditEmailNotf(f) {
    var vLNG = document.getElementById(f).elements['LNG'].value;
    var flagRegistration = true;

    var frm = document.getElementById(f);

    if (!frm.elements["EmailAddressEB"]) {
        frm.elements["ALERTADDRESS"].value = frm.elements["EmailAddressMPLS"].value;

        if (vLNG == 'BG') {
            if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["ALERTADDRESS"].value == '') {
                elemError(frm.elements["EmailAddressMPLS"], "За да получавате известия, трябва да регистрирате вашия имейл през меню Профил, Администриране на имейл адрес и след това да се регистрирате за услугата Имейл известяване.");
                return false;
            }
        }
        else {
            if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["ALERTADDRESS"].value == '') {
                elemError(frm.elements["EmailAddressMPLS"], "To receive notifications you should register your e-mail via Profile menu, E-mail Administration option and then subscribe for the service E-mail notification.");
                return false;
            }
        }

    }
    else {
        frm.elements["ALERTADDRESS"].value = frm.elements["EmailAddressEB"].value;

        if (vLNG == 'BG') {
            if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["ALERTADDRESS"].value == '') {
                elemError(frm.elements["EmailAddressEB"], "За да получавате известия, трябва да регистрирате вашия имейл през меню Профил, Администриране на имейл адрес и след това да се регистрирате за услугата Имейл известяване.");
                return false;
            }
        }
        else {
            if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["ALERTADDRESS"].value == '') {
                elemError(frm.elements["EmailAddressEB"], "To receive notifications you should register your e-mail via Profile menu, E-mail Administration option and then subscribe for the service E-mail notification.");
                return false;
            }
        }
    }

    
    return true;
}

function IsValidUPRegPayerEdit(f) {

    removeError(f);

    if (f == 'frmEditPaymentMode')
        var ocbxSend = document.getElementById('sendMode');
    else
        var ocbxSend = document.getElementById('send');


    var payWith = document.getElementById(f).elements['PAYWITH'];
    var vLNG = document.getElementById(f).elements['LNG'].value;
    var flagRegistration = true;

    var frm = document.getElementById(f);

    if (vLNG == 'BG') {

        if (f == 'utility-steps-form') {//добавне на съгласие + регистрация

            if (frm.elements["f-company"].value.length == 0) {
                elemError(frm.elements["f-company"], "Моля, изберете компания. ");
                return false;
            }

            if (frm.elements["clNumber"].value.length == 0) {
                elemError(frm.elements["clNumber"], "Моля, въведете абонатен номер.");
                return false;
            }

            if (frm.elements["KKU_COMP"].value != 109 && frm.elements["KKU_COMP"].value != 92 && frm.elements["KKU_COMP"].value != 87 && frm.elements["KKU_COMP"].value != 82 && frm.elements["KKU_COMP"].value != 81 && frm.elements["KKU_COMP"].value != 85 && frm.elements["KKU_COMP"].value != 50) {
                if (frm.elements["anLen"].value != 0 && frm.elements["clNumber"].value.length > frm.elements["anLen"].value) {     //HD  621832        
                    elemError(frm.elements["clNumber"], "Моля, въведете абонатния номер според посочения формат в информацията към полето.");
                    return false;
                }              
            }
            if (frm.elements["KKU_COMP"].value == "1") {//ЧЕЗ 
                if (frm.elements["clNumber"].value.length > 12) {
                    elemError(frm.elements["clNumber"], "Моля, въведете абонатния номер според посочения формат в информацията към полето.");
                    return false;
                }
            }

            if (frm.elements["KKU_COMP"].value == "6") {//Виваком 
                if (frm.elements["clNumber"].value.length > 11) {
                    elemError(frm.elements["clNumber"], "Моля, въведете абонатния номер според посочения формат в информацията към полето.");
                    return false;
                }
            }

            if (frm.elements["KKU_COMP"].value == "50") {//Топлофикация София
                if (frm.elements["clNumber"].value.length < 3 || frm.elements["clNumber"].value.length > 10) {
                    elemError(frm.elements["clNumber"], "Моля, въведете абонатния номер според посочения формат в информацията към полето.");
                    return false;
                }
            }
          
            if (frm.elements["KKU_COMP"].value == "3") { //Софийска вода/Sofiyska voda
                var isValid = 1;
                if (frm.elements["clNumber"].value.length != frm.elements["f-subscription-model"].value.length) {
                    isValid = false;
                }

                for (i = 0; i < frm.elements["clNumber"].value.length; i++) {
                    switch (frm.elements["f-subscription-model"].value.charAt(i)) {
                        case "N":
                            if (!isDigit(frm.elements["clNumber"].value.charCodeAt(i))) {
                                isValid = 0;
                            }
                            break;
                        case "2":
                            if (frm.elements["clNumber"].value.charCodeAt(i) != "50") {
                                isValid = 0;
                            }
                            break;
                    }
                }
                if (isValid == 0) {
                    elemError(frm.elements["clNumber"], "Моля, въведете абонатния номер според посочения формат в информацията към полето.");
                    return false;
                }
            }

            if (frm.elements["f-subscription-model-mtel"].value.length == 0 && document.getElementById('Mtel').style.display == 'inline-block') {
                elemError(frm.elements["f-subscription-model-mtel"], "Моля, въведете персонален код.");
                return false;
            }
            if (frm.elements["f-subscription-model-mtel"].value.length != 4 && document.getElementById('Mtel').style.display == 'inline-block') {
                elemError(frm.elements["f-subscription-model-mtel"], "Невалиден персонален код.");
                return false;
            }

            var re = new RegExp(frm.elements["RegEx"].value);
            var checkRegEx = re.test(frm.elements['clNumber'].value);
            if (!checkRegEx) {
                elemError(frm.elements["clNumber"], "Моля, въведете абонатния номер според посочения формат в информацията към полето.");
                return false;
            }

            if (frm.elements["MODE"].value == "AUTO" && frm.elements["PAYWITH"].value == "IBAN" && frm.elements["f-account"].value.length == 0) {
                elemError(frm.elements["f-account"], "Моля, изберете сметка.");
                return false;
            }
            if (frm.elements["MODE"].value == "AUTO" && frm.elements["PAYWITH"].value == "CARD" && frm.elements["f-account1"].value.length == 0) {
                elemError(frm.elements["f-account1"], "Моля, изберете кредитна карта.");
                return false;
            }
            if (!frm.elements["EmailAddressF"]){
                if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["EmailAddressSec"].value == '') {
                    elemError(frm.elements["EmailAddressSec"], "За да получавате известия, трябва да регистрирате вашия имейл през меню Профил, Администриране на имейл адрес и след това да се регистрирате за услугата.");
                    return false;
                }
                //else {
                //    frm.elements["ALERTADDRESS"].value = frm.elements["EmailAddressSec"].value;
                //}
            }
            if (!frm.elements["EmailAddressSec"]) {               
                if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["EmailAddressF"].value == '') {
                    elemError(frm.elements["EmailAddressF"], "За да получавате известия, трябва да регистрирате вашия имейл през меню Профил, Администриране на имейл адрес и след това да се регистрирате за услугата.");
                    return false;
                }
                //else {
                //    frm.elements["ALERTADDRESS"].value = frm.elements["EmailAddressF"].value;
                //}
            }
        }
        if (f == 'frmEditSub')//редакция на съгласие
        {
            if (frm.elements["MODE"].value == "AUTO" && frm.elements["f-acc"].value.length == 0 && frm.elements["f-acc1"].value.length == 0) {
                elemError(frm.elements["f-acc1"], "Моля, изберете сметка или кредитна карта.");
                return false;
            }
            if (frm.elements["MODE"].value == "AUTO" && frm.elements["f-acc"].value.length != 0 && frm.elements["f-acc1"].value.length != 0) {
                elemError(frm.elements["f-acc1"], "Моля, изберете сметка или кредитна карта.");
                return false;
            }
        }



        if (!ocbxSend.checked) {          
            elemErrorSend(ocbxSend, "Моля, потвърдете декларациите.");
            return false;
        }
    }
    else {//EN
        if (f == 'utility-steps-form') {//добавне на съгласие + регистрация

            if (frm.elements["f-company"].value.length == 0) {
                elemError(frm.elements["f-company"], "Please, choose company.");
                return false;
            }

            if (frm.elements["clNumber"].value.length == 0) {
                elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                return false;
            }
           
            //if (frm.elements["KKU_COMP"].value != 109 && frm.elements["KKU_COMP"].value != 92 && frm.elements["KKU_COMP"].value != 87 && frm.elements["KKU_COMP"].value != 82 && frm.elements["KKU_COMP"].value != 81 && frm.elements["KKU_COMP"].value != 85) {
            //    if (frm.elements["anLen"].value != 0 && frm.elements["clNumber"].value.length != frm.elements["anLen"].value) {
            //        elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
            //        return false;
            //    }
            //}

            //
            if (frm.elements["KKU_COMP"].value != 109 && frm.elements["KKU_COMP"].value != 92 && frm.elements["KKU_COMP"].value != 87 && frm.elements["KKU_COMP"].value != 82 && frm.elements["KKU_COMP"].value != 81 && frm.elements["KKU_COMP"].value != 85 && frm.elements["KKU_COMP"].value != 50) {
                if (frm.elements["anLen"].value != 0 && frm.elements["clNumber"].value.length > frm.elements["anLen"].value) {//HD  621832      
                    elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                    return false;
                }
            }
            if (frm.elements["KKU_COMP"].value == "1") {//ЧЕЗ 
                if (frm.elements["clNumber"].value.length > 12) {
                    elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                    return false;
                }
            }

            if (frm.elements["KKU_COMP"].value == "6") {//Виваком 
                if (frm.elements["clNumber"].value.length > 11) {
                    elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                    return false;
                }
            }

            if (frm.elements["KKU_COMP"].value == "50") {//Топлофикация София
                if (frm.elements["clNumber"].value.length < 3 || frm.elements["clNumber"].value.length > 10) {
                    elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                    return false;
                }
            }
            //

            if (frm.elements["KKU_COMP"].value == "3") { //HD 457563_2015
                var isValid = 1;
                if (frm.elements["clNumber"].value.length != frm.elements["f-subscription-model"].value.length) {
                    isValid = false;
                }

                for (i = 0; i < frm.elements["clNumber"].value.length; i++) {
                    switch (frm.elements["f-subscription-model"].value.charAt(i)) {
                        case "N":
                            if (!isDigit(frm.elements["clNumber"].value.charCodeAt(i))) {
                                isValid = 0;
                            }
                            break;
                        case "2":
                            if (frm.elements["clNumber"].value.charCodeAt(i) != "50") {
                                isValid = 0;
                            }
                            break;
                    }
                }
                if (isValid == 0) {
                    elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                    return false;
                }
            }
        
            if (frm.elements["f-subscription-model-mtel"].value.length == 0 && document.getElementById('Mtel').style.display == 'inline-block') {
                elemError(frm.elements["f-subscription-model-mtel"], "Please, enter the subscriber number");
                return false;
            }
            if (frm.elements["f-subscription-model-mtel"].value.length != 4 && document.getElementById('Mtel').style.display == 'inline-block') {
                elemError(frm.elements["f-subscription-model-mtel"], "Invalid personal code.");
                return false;
            }

            var re = new RegExp(frm.elements["RegEx"].value);
            var checkRegEx = re.test(frm.elements['clNumber'].value);
            if (!checkRegEx) {
                elemError(frm.elements["clNumber"], "Please, enter the subscriber number by following the indication in info.");
                return false;
            }

            if (frm.elements["MODE"].value == "AUTO" && frm.elements["PAYWITH"].value == "IBAN" && frm.elements["f-account"].value.length == 0) {
                elemError(frm.elements["f-account"], "Please, select an account.");
                return false;
            }
            if (frm.elements["MODE"].value == "AUTO" && frm.elements["PAYWITH"].value == "CARD" && frm.elements["f-account1"].value.length == 0) {
                elemError(frm.elements["f-account1"], "Please, select a credit card number.");
                return false;
            }
            if (!frm.elements["EmailAddressF"]) {
                if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["EmailAddressSec"].value == '') {
                    elemError(frm.elements["EmailAddressSec"], "To receive notifications you should register your e-mail via Profile menu, E-mail Administration option and then subscribe for the service.");
                    return false;
                }
                //else {
                //    frm.elements["ALERTADDRESS"].value = frm.elements["EmailAddressSec"].value;
                //}
            }
            if (!frm.elements["EmailAddressSec"]) {
                if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["EmailAddressF"].value == '') {
                    elemError(frm.elements["EmailAddressF"], "To receive notifications you should register your e-mail via Profile menu, E-mail Administration option and then subscribe for the service.");
                    return false;
                }
                //else {
                //    frm.elements["ALERTADDRESS"].value = frm.elements["EmailAddressF"].value;
                //}
            }
            //if (frm.elements["EMAIL_YN"].value == "YESS" && frm.elements["ALERTADDRESS"].value == '') {
            //    elemError(frm.elements["ALERTADDRESS"], "To receive notifications you should register your e-mail via Profile menu, E-mail Administration option and then subscribe for the service.");
            //    return false;
            //}
        }
        if (f == 'frmEditSub')//редакция на съгласие
        {
            if (frm.elements["MODE"].value == "AUTO" && frm.elements["f-acc"].value.length == 0 && frm.elements["f-acc1"].value.length == 0) {
                elemError(frm.elements["f-acc"], "Please, select an account or credit card number.");
                return false;
            }
            if (frm.elements["MODE"].value == "AUTO" && frm.elements["f-acc"].value.length != 0 && frm.elements["f-acc1"].value.length != 0) {
                elemError(frm.elements["f-acc"], "Please, select an account or credit card number.");
                return false;
            }
        }

        if (!ocbxSend.checked) {
            elemErrorSend(ocbxSend, "Please, confirm declarations.");            
            return false;
        }
    }

    return true;

}


function SelOptions_onChange(frmId, selFldId, FldId_toChange) {
    //Използва се за присвояне на стойности в FldId_toChange при избор на selFldId от форма frmId

    var frm = document.getElementById(frmId);
    var selFldId_value = frm.elements[selFldId].value;
    var FldId_toChange_value = '';

    if (frmId == 'frmOpenDeposit') {
        switch (selFldId_value) {
            case '67':
                FldId_toChange_value = '6105';
                break;
            case '68':
                FldId_toChange_value = '6106';
                break;
            case '69':
                FldId_toChange_value = '6107';
                break;
            case '70':
                FldId_toChange_value = '6108';
                break;
        }

        frm.elements[FldId_toChange].value = FldId_toChange_value;
    }

    if (frmId == 'frmPAYMENT') {
        var x = document.getElementById(selFldId);
        var SelIndex = x.selectedIndex;
        var FFF = '';
        FFF = ReturnArrayCountry(SelIndex);
        alert(FFF);
        var str = FFF.split("|");
        var Country57 = str[0];
        alert(Country57);
        var ISO57 = str[1];
        alert(ISO57);
        var ibanlen57 = str[2];
        var ibancode57 = str[3];
        var cISO1_57 = str[4];
        frm.elements[FldId_toChange].value = ISO57;
    }
}

String.prototype.replaceAll = function (find, replace) {
    var str = this;
    return str.replace(new RegExp(find, 'g'), replace);
};

function MakeAccountContractNew(frmId, frmId2, sLNG, CATEGORYCODE) {
    var CNTR = "";
    var sP = "................";
    var frm = document.getElementById(frmId);
    var frm2 = document.getElementById(frmId2);
    var vRef = frm.elements["RefId"].value;
    var vClDep = frm.elements["ClDep"].value;
    var depositArr = vClDep.split("$");
    var ss = vRef.split("_");
    var clName = frm2.elements["CNTR001"].value;

    var accDepNum = ss[0];
    var depCurr = ss[1];
    var strCategory = ss[2];
    var strCategoryEN = ss[2];
    var fromDate = ss[3];
    var clGlId = frm2.elements["CNTR00"].value;
    var ucn = frm2.elements["CNTR020"].value;
    var idCARD = "";
    var idDATEOFISSU = "";
    var idPLACEOFISSU = "";
    var birthdate = "";
    var typeContract = "";
    var glSector = "";
    var valid = "0";

    switch (strCategory) {
        case "РАЗПЛАЩАТЕЛНА СМЕТКА - ОБИКНОВЕНА":
            strCategoryEN = "CURRENT ACCOUNT - SIMPLE";
            break;
        case "РАЗПЛАЩАТЕЛНА СМЕТКА АКТИВНОСТ ЕБ":
            strCategoryEN = "ACTIVITY CURRENT ACCOUNT";
            break;
        case "ОТВОРЕН ДЕПОЗИТ 1М ЛИХВЕНА ЧЕСТОТА":
            strCategoryEN = "OPEN DEPOSIT WITH 1 MONTH PAYMENT FREQUENCY";
            break;
        case "ОТВОРЕН ДЕПОЗИТ 3М ЛИХВЕНА ЧЕСТОТА":
            strCategoryEN = "OPEN DEPOSIT WITH 3 MONTH PAYMENT FREQUENCY";
            break;
        case "ОТВОРЕН ДЕПОЗИТ 6М ЛИХВЕНА ЧЕСТОТА":
            strCategoryEN = "OPEN DEPOSIT WITH 6 MONTH PAYMENT FREQUENCY";
            break;
        case "ОТВОРЕН ДЕПОЗИТ 12М ЛИХВЕНА ЧЕСТОТА":
            strCategoryEN = "OPEN DEPOSIT WITH 12 MONTH PAYMENT FREQUENCY";
            break;
        case "НОВ ОТВОРЕН ДЕПОЗИТ С 1М ЛИХВА":
            strCategoryEN = "NEW OPEN DEPOSIT WITH 1 MONTH INTEREST";
            break;
        case "НОВ ОТВОРЕН ДЕПОЗИТ С 3М ЛИХВА":
            strCategoryEN = "NEW OPEN DEPOSIT WITH 3 MONTHS INTEREST";
            break;
        case "НОВ ОТВОРЕН ДЕПОЗИТ С 6М ЛИХВА":
            strCategoryEN = "NEW OPEN DEPOSIT WITH 6 MONTHS INTEREST";
            break;
        case "НОВ ОТВОРЕН ДЕПОЗИТ С 12М ЛИХВА":
            strCategoryEN = "NEW OPEN DEPOSIT WITH 12 MONTHS INTEREST";
            break;
    }

    for (i = 0; i < depositArr.length; i++) {
        var deposit = depositArr[i].split("|");
        if (deposit.length > 1) {
            if (ss[0] == trim(deposit[1])) {
                clName = trim(deposit[0]);
                accDepNum = trim(deposit[1]);
                if (deposit[2] != "") {
                    fromDate = deposit[2];
                }
                ucn = deposit[3];
                idCARD = deposit[4];
                idDATEOFISSU = deposit[5];
                idPLACEOFISSU = deposit[6];
                typeContract = trim(deposit[7]);
                clGlId = deposit[8];
                birthdate = deposit[9];
                glSector = trim(deposit[10]);
                break;
            }
        }
    }
    var frm2 = document.getElementById(frmId2);
    var countTemplContract = parseInt(frm2.elements["CNTTEMPLCONTR"].value);
    var temp1 = "";
    var vCNTR1 = "";
    var actCNTR = "";
    for (i = 1; i <= countTemplContract; i++) {
        temp1 = trim(frm2.elements["DEPCONTRACT." + i.toString()].value);
        var temp2 = temp1.split("|");
        if ((temp2[2] == "1" || temp2[21] == "true") && ((CATEGORYCODE == "1021" && temp2[0] == "2") || (CATEGORYCODE != "1021" && temp2[0] == "1"))) {
            actCNTR = temp2[3];
        }
        if (temp2[1] == typeContract) {
            vCNTR1 = temp2[3];
            break;
        }
    }
    if (vCNTR1 == "") {
        vCNTR1 = actCNTR;
    }

    if (glSector == "5100" || glSector == "5200" || glSector == "") {
        var vCNTR1 = vCNTR1.replaceAll("@@@str1BG", "ЕГН: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@str1EN", "PERSONAL ID NUMBER: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@ucn", ucn);
        var vCNTR1 = vCNTR1.replaceAll("@@@str2BG", "");
        var vCNTR1 = vCNTR1.replaceAll("@@@str2EN", "");
        var vCNTR1 = vCNTR1.replaceAll("@@@idCARD", "");
    }
    else {
        var vCNTR1 = vCNTR1.replaceAll("@@@str1BG", "ДАТА НА РАЖДАНЕ : ");
        var vCNTR1 = vCNTR1.replaceAll("@@@str1EN", "DATE OF BIRTH: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@ucn", birthdate);
        var vCNTR1 = vCNTR1.replaceAll("@@@str2BG", "НОМЕР НА ПАСПОРТ: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@str2EN", "IDENTITY DOCUMENT: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@idCARD", idCARD);
    }
    var vCNTR1 = vCNTR1.replaceAll("@@@clName", clName);
    var vCNTR1 = vCNTR1.replaceAll("@@@fromDate", fromDate);
    var vCNTR1 = vCNTR1.replaceAll("@@@idAcc", accDepNum);
    var vCNTR1 = vCNTR1.replaceAll("@@@currency", depCurr);
    var vCNTR1 = vCNTR1.replaceAll("@@@strCategoryEN", strCategoryEN);
    var vCNTR1 = vCNTR1.replaceAll("@@@strCategory", strCategory);
    var vCNTR1 = vCNTR1.replaceAll("@@@bicCode", "UBBS BGSF");
    var vCNTR1 = vCNTR1.replaceAll("@@@glId", clGlId);

    CNTR = vCNTR1;
    GetWindow("wnd1", "", CNTR, 20, 10, 788, 1120);
}

function MakeDepAvailContractNew(frmId, frmId2, sLNG) {
    try {
        var CNTR = "";
        var sP = "................";
        var frm = document.getElementById(frmId);
        var frm2 = document.getElementById(frmId2);
        var vRef = frm.elements["RefId"].value;
        var vClDep = frm.elements["ClDep"].value;
        var depositArr = vClDep.split("$");
        var ss = vRef.split("_");
        var clName = frm2.elements["CNTR001"].value;
        var accDepNum = ss[0];
        var fromDate = ss[3];
        var depositMaturityDate = ss[4];
        var amount = ss[2];
        var depositInterestRate = ss[1];
        var depCurr = ss[5];
        var penaltyRate = "";
        var intBase = "";
        var accS = "";
        var accI = "";
        var decl30k = "";
        var typeContract = "";
        var valid = "0";

        for (i = 0; i < depositArr.length; i++) {
            var deposit = depositArr[i].split("|");
            if (deposit.length > 1) {
                if (ss[0] == trim(deposit[1])) {
                    clName = deposit[0];
                    accDepNum = deposit[1];
                    fromDate = deposit[2];
                    depositMaturityDate = deposit[3];
                    amount = deposit[4];
                    depositInterestRate = deposit[5];
                    penaltyRate = deposit[6];
                    intBase = deposit[7];
                    accS = deposit[8];
                    accI = deposit[9];
                    decl30k = deposit[10];
                    typeContract = trim(deposit[11]);
                    depCurr = deposit[12];
                    break;
                }
            }
        }
        var frm2 = document.getElementById(frmId2);
        var countTemplContract = parseInt(frm2.elements["CNTTEMPLCONTR"].value);
        var temp1 = "";
        var vCNTR1 = "";
        var actCNTR = "";
        for (i = 1; i <= countTemplContract; i++) {
            temp1 = trim(frm2.elements["DEPCONTRACT." + i.toString()].value);
            var temp2 = temp1.split("|");
            if (temp2[2] == "1" || temp2[2] == "true") {
                actCNTR = temp2[3];
            }
            if (temp2[1] == typeContract) {
                vCNTR1 = temp2[3];
                break;
            }
        }

        if (vCNTR1 == "") {
            vCNTR1 = actCNTR;
        }

        var vCNTR1 = vCNTR1.replaceAll("@@@clName", clName);
        var vCNTR1 = vCNTR1.replaceAll("@@@idAcc", accDepNum);
        var vCNTR1 = vCNTR1.replaceAll("@@@fromDate", fromDate);

        var vCNTR1 = vCNTR1.replaceAll("@@@depositMaturityDate", depositMaturityDate);
        var vCNTR1 = vCNTR1.replaceAll("@@@amount", amount);
        var vCNTR1 = vCNTR1.replaceAll("@@@depositInterestRate", depositInterestRate);
        var vCNTR1 = vCNTR1.replaceAll("@@@penaltyRate", penaltyRate);
        var vCNTR1 = vCNTR1.replaceAll("@@@intBase", intBase);
        var vCNTR1 = vCNTR1.replaceAll("@@@accS", accS);
        var vCNTR1 = vCNTR1.replaceAll("@@@accI", accI);
        var vCNTR1 = vCNTR1.replaceAll("@@@decl30k", decl30k);
        var vCNTR1 = vCNTR1.replaceAll("@@@currency", depCurr);
        CNTR = vCNTR1;

        GetWindow("wnd1", "", CNTR, 20, 10, 788, 1120);
    }
    catch (e) {
        alert(e);
        return false;
    }
}


function MakeLimitContractNew(frmId, frmId2, sLNG) {
    try {
        var CNTR = "";
        var sP = "................";
        var frm = document.getElementById(frmId);
        var frm2 = document.getElementById(frmId2);
        var vRef = frm.elements["RefId"].value;
        var vClLim = frm.elements["ClLim"].value;
        var depositArr = vClLim.split("$");
        var ss = vRef.split("_");
        var clGlId = frm2.elements["CNTR00"].value;
        var clName = frm2.elements["CNTR001"].value;
        var accDepNum = ss[0];
        var fromDate = "";
        var cardId = "";
        var newLimit = "";
        var oldLimit = "";
        var typeContract = "";
        var ContractId = ss[2];
        var valid = "0";

        for (i = 0; i < depositArr.length; i++) {
            var deposit = depositArr[i].split("|");
            if (deposit.length > 1) {
                if (ss[0] == trim(deposit[1]) && trim(ss[2]) == trim(deposit[8])) {
                    clName = deposit[0];
                    accDepNum = deposit[1];
                    fromDate = deposit[2];
                    cardId = deposit[3];
                    oldLimit = deposit[4];
                    newLimit = deposit[5];
                    typeContract = trim(deposit[6]);
                    clGlId = deposit[7];
                    ContractId = deposit[8];
                    break;
                }
            }
        }

        var frm2 = document.getElementById(frmId2);
        var countTemplContract = parseInt(frm2.elements["CNTTEMPLCONTR"].value);
        var temp1 = "";
        var vCNTR1 = "";
        var actCNTR = "";
        for (i = 1; i <= countTemplContract; i++) {
            temp1 = trim(frm2.elements["DEPCONTRACT." + i.toString()].value);
            var temp2 = temp1.split("|");
            if (temp2[2] == "1" || temp2[2] == "true") {
                actCNTR = temp2[3];
            }
            if (temp2[1] == typeContract) {
                vCNTR1 = temp2[3];
                break;
            }
        }

        if (vCNTR1 == "") {
            vCNTR1 = actCNTR;
        }

        var vCNTR1 = vCNTR1.replaceAll("@@@clName", clName);
        var vCNTR1 = vCNTR1.replaceAll("@@@glId", clGlId);
        var vCNTR1 = vCNTR1.replaceAll("@@@fromDate", fromDate);
        var vCNTR1 = vCNTR1.replaceAll("@@@cardId", cardId);
        var vCNTR1 = vCNTR1.replaceAll("@@@oldLimit", oldLimit);
        var vCNTR1 = vCNTR1.replaceAll("@@@newLimit", newLimit);
        CNTR = vCNTR1;

        GetWindow("wnd1", "", CNTR, 20, 10, 788, 620);
    }
    catch (e) {
        alert(e);
        return false;
    }
}

function MakeDebitCardContractNew(frmId, frmId2, sLNG) {
    try {

        var CNTR = "";
        var frm = document.getElementById(frmId);
        var frm2 = document.getElementById(frmId2);
        var vRef = frm.elements["RefId"].value;
        var vClDCard = frm.elements["ClDCard"].value;
        var debitCardArr = vClDCard.split("$");
        var ss = vRef.split("_");
        var clName = ss[2];
        var glId = "";
        var accDepNum = ss[0];
        var fromDate = ss[1];
        var cardType = "";
        var accS = ss[3];

        var typeContract = "";
        var valid = "0";

        for (i = 0; i < debitCardArr.length; i++) {
            var dcard = debitCardArr[i].split("|");
            if (dcard.length > 1) {
                if (ss[0] == trim(dcard[1])) {
                    clName = dcard[0];
                    glId = dcard[3];
                    fromDate = dcard[2];
                    cardType = dcard[5];
                    accS = dcard[4];
                    break;
                }
            }
        }

        var frm2 = document.getElementById(frmId2);
        var countTemplContract = parseInt(frm2.elements["CNTTEMPLCONTR"].value);
        var temp1 = "";
        var vCNTR1 = "";
        var actCNTR = "";
        for (i = 1; i <= countTemplContract; i++) {
            temp1 = trim(frm2.elements["DEPCONTRACT." + i.toString()].value);
            var temp2 = temp1.split("|");
            if (temp2[2] == "1" || temp2[2] == "true") {
                actCNTR = temp2[3];
            }
            if (temp2[1] == typeContract) {
                vCNTR1 = temp2[3];
                break;
            }
        }

        if (vCNTR1 == "") {
            vCNTR1 = actCNTR;
        }

        var vCNTR1 = vCNTR1.replaceAll("@@@fromDate", fromDate);
        var vCNTR1 = vCNTR1.replaceAll("@@@glId", glId);
        var vCNTR1 = vCNTR1.replaceAll("@@@clName", clName);

        var vCNTR1 = vCNTR1.replaceAll("@@@cardType", cardType);
        var vCNTR1 = vCNTR1.replaceAll("@@@accS", accS);

        CNTR = vCNTR1;

        GetWindow("wnd1", "", CNTR, 20, 10, 788, 1120);
    }
    catch (e) {
        alert(e);
        return false;
    }
}

function MakeRegistrationContractNew(frmId, frmId2, sLNG) {
    var CNTR = "";
    var frm = document.getElementById(frmId);
    var vRef = frm.elements["RefId"].value;
    var ss = vRef.split("_");

    var clUserName = ss[0];
    var regDate = ss[1];
    var name = ss[2];
    var typeContract = ss[4];
    var valReg = frm.elements["ValReg"].value;
    var tempReg = frm.elements["TempReg"].value;

    var valRegArr = valReg.split("|");
    var tempRegArr = tempReg.split("|");

    var countTemplContract = 0;

    var temp1 = "";
    var vCNTR1 = "";
    var actCNTR = "";

    temp1 = frm.elements["REGCONTRACT"].value;
    var temp2 = temp1.split("|");

    if (temp2[2] == "1" || temp2[2] == "true") {
        actCNTR = temp2[3];
    }
    if (temp2[1] == typeContract) {
        vCNTR1 = temp2[3];

    }

    if (vCNTR1 == "") {
        vCNTR1 = actCNTR;
    }


    for (i = 0; i < tempRegArr.length; i++) {
        if (tempRegArr[i] != "Accounts") {
            vCNTR1 = vCNTR1.replaceAll("@@@" + tempRegArr[i], valRegArr[i]);
        }
        else {
            var sAccs = "";
            var tempAcc = tempRegArr[i];
            var valAcc = valRegArr[i];
            if (valAcc != "") {
                var AccSpl = valAcc.split(";");
                for (var i2 = 0; i2 <= AccSpl.length - 1; i2++) {
                    if (AccSpl[i2].length != "") {
                        var AccSplDet = AccSpl[i2].split(",");
                        sAccs = sAccs + "<tr><td>" + AccSplDet[0] + "</td><td>" + AccSplDet[1] + "</td><td>" + AccSplDet[2] + "</td></tr>";
                    }
                }
            }
            else {
                sAccs = sAccs + "<tr>                      <td>&nbsp;                      </td>                      <td>&nbsp;                      </td>                      <td>&nbsp;                      </td>                  </tr>";
            }
            vCNTR1 = vCNTR1.replaceAll("@@@" + tempRegArr[i], sAccs);
        }
    }
    CNTR = vCNTR1;

    var ownd = document.getElementById("wnd1");
    var ottl = document.getElementById("wnd1_t");
    var ocontent = document.getElementById("wnd1_c");
    ocontent.innerHTML = CNTR;
}

function MakeRegistrationContractNewF(frmId, frmId2, sLNG) {
    var CNTR = "";

    var frm = document.getElementById(frmId);
    var vRef = frm.elements["RefId"].value;
    var ss = vRef.split("_");

    var clUserName = ss[0];
    var regDate = ss[1];
    var name = ss[2];
    var typeContract = ss[4];
    var valReg = frm.elements["ValReg"].value;
    var tempReg = frm.elements["TempReg"].value;
    var valRegArr = valReg.split("|");
    var tempRegArr = tempReg.split("|");
    var frm2 = document.getElementById(frmId2);
    var countTemplContract = parseInt(frm2.elements["CNTTEMPLCONTR"].value);
    var temp1 = "";
    var vCNTR1 = "";
    var actCNTR = "";
    for (i = 1; i <= countTemplContract; i++) {
        temp1 = frm2.elements["REGCONTRACT." + i.toString()].value;
        var temp2 = temp1.split("|");

        if (temp2[2] == "1" || temp2[2] == "true") {
            actCNTR = temp2[3];
        }
        if (temp2[1] == typeContract) {
            vCNTR1 = temp2[3];
            break;
        }
    }
    if (vCNTR1 == "") {
        vCNTR1 = actCNTR;
    }


    for (i = 0; i < tempRegArr.length; i++) {
        if (tempRegArr[i] != "Accounts") {
            vCNTR1 = vCNTR1.replaceAll("@@@" + tempRegArr[i], valRegArr[i]);
        }
        else {
            var sAccs = "";
            var tempAcc = tempRegArr[i];
            var valAcc = valRegArr[i];
            if (valAcc != "") {
                var AccSpl = valAcc.split(";");
                for (var i2 = 0; i2 <= AccSpl.length - 1; i2++) {
                    if (AccSpl[i2].length != "") {
                        var AccSplDet = AccSpl[i2].split(",");
                        sAccs = sAccs + "<tr><td>" + AccSplDet[0] + "</td><td>" + AccSplDet[1] + "</td><td>" + AccSplDet[2] + "</td></tr>";
                    }
                }
            }
            else {
                sAccs = sAccs + "<tr>                      <td>&nbsp;                      </td>                      <td>&nbsp;                      </td>                      <td>&nbsp;                      </td>                  </tr>";
            }
            vCNTR1 = vCNTR1.replaceAll("@@@" + tempRegArr[i], sAccs);
        }
    }
    CNTR = vCNTR1;
    GetWindowRe("popup_wnd1", "", CNTR, 0, 0, 0, 0);

    ShowPanel("popup_wnd1", "");
    openPopup("data_popup_wnd1");

}


function iprint(sender) {
    var a = window.open('', '', 'location=1,status=1,scrollbars=1,resizable=1,width=1100,height=600');
    a.document.open("text/html");
    a.document.write(document.getElementById(sender).innerHTML);
    a.document.close();
    a.print();
}

function MakeDepNesNew(frmId, frmId2, sLNG) {
    try {
        CNTR = frmId;

        GetWindow("wnd1", "", CNTR, 20, 10, 788, 1120);
    }
    catch (e) {
        alert(e);
        return false;
    }
}

function MakeDepTemplate(frmId, frmId2, sType) {
    try {
        var frm2 = document.getElementById(frmId2);
        var countTemplContract = parseInt(frm2.elements["CNTTEMPLCONTR"].value);
        var temp1 = "";
        var vCNTR1 = "";
        var idDep = frm2.elements["TYPEACCDEP"].value;
        for (i = 1; i <= countTemplContract; i++) {
            temp1 = trim(frm2.elements["DEPCONTRACT." + i.toString()].value);
            var temp2 = temp1.split("|");

            if (sType == temp2[0]) {
                vCNTR1 = temp2[3];
                break;
            }
        }
        var vCNTR1 = vCNTR1.replaceAll("@@@str1BG", "ЕГН: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@str1EN", "PERSONAL ID NUMBER: ");
        var vCNTR1 = vCNTR1.replaceAll("@@@ucn", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@str2BG", "");
        var vCNTR1 = vCNTR1.replaceAll("@@@str2EN", "");
        var vCNTR1 = vCNTR1.replaceAll("@@@idCARD", "");

        var vCNTR1 = vCNTR1.replaceAll("@@@clName", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@fromDate", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@idAcc", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@currency", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@strCategoryEN", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@strCategory", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@bicCode", "UBBS BGSF");
        var vCNTR1 = vCNTR1.replaceAll("@@@glId", ".........");

        var vCNTR1 = vCNTR1.replaceAll("@@@depositMaturityDate", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@amount", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@depositInterestRate", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@penaltyRate", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@intBase", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@accS", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@accI", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@decl30k", ".........");

        var vCNTR1 = vCNTR1.replaceAll("@@@cardType", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@cardId", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@newLimit", ".........");
        var vCNTR1 = vCNTR1.replaceAll("@@@oldLimit", ".........");

        GetWindowRe("popup_wnd1", sType + "  " + countTemplContract, "", 0, 0, 0, 0);

        ShowPanel("popup_wnd1", "");
        openPopup("data_popup_wnd1");

    }
    catch (e) {
        alert(e);
        return false;
    }

}

function ReturnArrayCountry(SelIndex) {
    var arrayCountry1 = new Array(253);

    arrayCountry1[0] = '||||||';
    arrayCountry1[1] = 'AFGHANISTAN|AF||||AFGHANISTAN|';
    arrayCountry1[2] = 'ALAND ISLANDS|AX||||ALAND ISLANDS|';
    arrayCountry1[3] = 'ALBANIA|AL|28||AL|ALBANIA|';
    arrayCountry1[4] = 'ALGERIA|DZ||||ALGERIA|';
    arrayCountry1[5] = 'AMERICAN SAMOA|AS||||AMERICAN SAMOA|';
    arrayCountry1[6] = 'ANDORRA|AD|24|AD12 0001 2030 2003 5910 0100|AD|ANDORRA|';
    arrayCountry1[7] = 'ANGOLA|AO||||ANGOLA|';
    arrayCountry1[8] = 'ANGUILLA|AI||||ANGUILLA|';
    arrayCountry1[9] = 'ANTARCTICA|AQ||||ANTARCTICA|';
    arrayCountry1[10] = 'AG|AG||||ANTIGUA AND BARBUDA|';
    arrayCountry1[11] = 'ARGENTINA|AR||||ARGENTINA|';
    arrayCountry1[12] = 'ARMENIA|AM||||ARMENIA|';
    arrayCountry1[13] = 'ARUBA|AW||||ARUBA|';
    arrayCountry1[14] = 'AUSTRALIA|AU||||AUSTRALIA|';
    arrayCountry1[15] = 'AUSTRIA|AT|20|АТ61 1904 3002 3457 3201|AT|AUSTRIA|';
    arrayCountry1[16] = 'AZERBAIJAN|AZ|28||AZ|AZERBAIJAN|';
    arrayCountry1[17] = 'BAHAMAS|BS||||BAHAMAS|';
    arrayCountry1[18] = 'BAHRAIN|BH|22||BH|BAHRAIN|';
    arrayCountry1[19] = 'BANGLADESH|BD||||BANGLADESH|';
    arrayCountry1[20] = 'BARBADOS|BB||||BARBADOS|';
    arrayCountry1[21] = 'BELARUS|BY|28||BY|BELARUS|';
    arrayCountry1[22] = 'BELGIUM|BE|16|BE68 5390 0754 7034|BE|BELGIUM|';
    arrayCountry1[23] = 'BELIZE|BZ||||BELIZE|';
    arrayCountry1[24] = 'BENIN|BJ||||BENIN|';
    arrayCountry1[25] = 'BERMUDA|BM||||BERMUDA|';
    arrayCountry1[26] = 'BHUTAN|BT||||BHUTAN|';
    arrayCountry1[27] = 'BOLIVIA|BO||||BOLIVIA|';
    arrayCountry1[28] = 'BQ|BQ||||BQ|';
    arrayCountry1[29] = 'BA|BA|20|BA39 1290 0794 0102 8494|BA|BOSNIA AND HERZEGOVINA|';
    arrayCountry1[30] = 'BOTSWANA|BW||||BOTSWANA|';
    arrayCountry1[31] = 'BOUVET ISLAND|BV||||BOUVET ISLAND|';
    arrayCountry1[32] = 'BRAZIL|BR|29||BR|BRAZIL|';
    arrayCountry1[33] = 'IO|IO||||BRITISH INDIAN OCEAN TERRITORY|';
    arrayCountry1[34] = 'BRUNEI DARUSSALAM|BN||||BRUNEI DARUSSALAM|';
    arrayCountry1[35] = 'BULGARIA|BG|22|BG70UBBS80021111111111|BG|BULGARIA|';
    arrayCountry1[36] = 'BURKINA FASO|BF||||BURKINA FASO|';
    arrayCountry1[37] = 'BURUNDI|BI||||BURUNDI|';
    arrayCountry1[38] = 'CAMBODIA|KH||||CAMBODIA|';
    arrayCountry1[39] = 'CAMEROON|CM||||CAMEROON|';
    arrayCountry1[40] = 'CANADA|CA||||CANADA|';
    arrayCountry1[41] = 'CAPE VERDE|CV||||CAPE VERDE|';
    arrayCountry1[42] = 'CAYMAN ISLANDS|KY||||CAYMAN ISLANDS|';
    arrayCountry1[43] = 'CF|CF||||CENTRAL AFRICAN REPUBLIC|';
    arrayCountry1[44] = 'CHAD|TD||||CHAD|';
    arrayCountry1[45] = 'CHILE|CL||||CHILE|';
    arrayCountry1[46] = 'CHINA|CN||||CHINA|';
    arrayCountry1[47] = 'CHRISTMAS ISLAND|CX||||CHRISTMAS ISLAND|';
    arrayCountry1[48] = 'CC|CC||||COCOS KEELING ISLANDS|';
    arrayCountry1[49] = 'COLOMBIA|CO||||COLOMBIA|';
    arrayCountry1[50] = 'COMOROS|KM||||COMOROS|';
    arrayCountry1[51] = 'CD|CD||||CONGO-THE DEMOCRATIC REPUBLIC OF THE|';
    arrayCountry1[52] = 'CONGO|CG||||CONGO|';
    arrayCountry1[53] = 'COOK ISLANDS|CK||||COOK ISLANDS|';
    arrayCountry1[54] = 'COSTA RICA|CR|22||CR|COSTA RICA|';
    arrayCountry1[55] = 'CI|CI||||COTE D IVOIRE|';
    arrayCountry1[56] = 'CROATIA|HR|21|HR12 1001 0051 8630 0016 0|HR|CROATIA|';
    arrayCountry1[57] = 'CUBA|CU||||CUBA|';
    arrayCountry1[58] = 'CW|CW||||CURACAO|';
    arrayCountry1[59] = 'CYPRUS|CY|28|CY17 0020 0128 0000 0012 0052 7600|CY|CYPRUS|';
    arrayCountry1[60] = 'CZECH REPUBLIC|CZ|24|CZ65 0800 0000 1920 0014 5399|CZ|CZECH REPUBLIC|';
    arrayCountry1[61] = 'DENMARK|DK|18|DK50 0040 0440 1162 43|DK|DENMARK|';
    arrayCountry1[62] = 'DJIBOUTI|DJ||||DJIBOUTI|';
    arrayCountry1[63] = 'DOMINICA|DM||||DOMINICA|';
    arrayCountry1[64] = 'DO|DO|28||DO|DOMINICAN REPUBLIC|';
    arrayCountry1[65] = 'EAST TIMOR|TP||||EAST TIMOR|';
    arrayCountry1[66] = 'ECUADOR|EC||||ECUADOR|';
    arrayCountry1[67] = 'EGYPT|EG|29||EG|EGYPT|';
    arrayCountry1[68] = 'EL SALVADOR|SV|28||SV|EL SALVADOR|';
    arrayCountry1[69] = 'EQUATORIAL GUINEA|GQ||||EQUATORIAL GUINEA|';
    arrayCountry1[70] = 'ERITREA|ER||||ERITREA|';
    arrayCountry1[71] = 'ESTONIA|EE|20|EE38 2200 2210 2014 5685|EE|ESTONIA|';
    arrayCountry1[72] = 'ETHIOPIA|ET||||ETHIOPIA|';
    arrayCountry1[73] = 'FK|FK||||FALKLAND ISLANDS MALVINAS|';
    arrayCountry1[74] = 'FAROE ISLANDS|FO|18|FO97 5432 0388 8999 44|FO|FAROE ISLANDS|';
    arrayCountry1[75] = 'FIJI|FJ||||FIJI|';
    arrayCountry1[76] = 'FINLAND|FI|18|FI21 1234 5600 0007 85|FI|FINLAND|';
    arrayCountry1[77] = 'FX|FX||||FRANCE-METROPOLITAN|';
    arrayCountry1[78] = 'FRANCE|FR|27|FR14 2004 1010 0505 0001 3M02 606|FR|FRANCE|';
    arrayCountry1[79] = 'FRENCH GUIANA|GF||||FRENCH GUIANA|';
    arrayCountry1[80] = 'FRENCH POLYNESIA|PF||||FRENCH POLYNESIA|';
    arrayCountry1[81] = 'TF|TF||||FRENCH SOUTHERN TERRITORIES|';
    arrayCountry1[82] = 'GABON|GA||||GABON|';
    arrayCountry1[83] = 'GAMBIA|GM||||GAMBIA|';
    arrayCountry1[84] = 'GEORGIA|GE|22||GE|GEORGIA|';
    arrayCountry1[85] = 'GERMANY|DE|22|DE89 3704 0044 0532 0130 00|DE|GERMANY|';
    arrayCountry1[86] = 'GHANA|GH||||GHANA|';
    arrayCountry1[87] = 'GIBRALTAR|GI|23|GI75 NWBK 0000 0000 7099 453|GI|GIBRALTAR|';
    arrayCountry1[88] = 'GREECE|GR|27|GR16 0110 1250 0000 0001 2300 695|GR|GREECE|';
    arrayCountry1[89] = 'GREENLAND|GL|18|GL56 0444 9876 5432 10|GL|GREENLAND|';
    arrayCountry1[90] = 'GRENADA|GD||||GRENADA|';
    arrayCountry1[91] = 'GUADELOUPE|GP||||GUADELOUPE|';
    arrayCountry1[92] = 'GUAM|GU||||GUAM|';
    arrayCountry1[93] = 'GUATEMALA|GT|28||GT|GUATEMALA|';
    arrayCountry1[94] = 'GUERNSEY|GG||||GUERNSEY|';
    arrayCountry1[95] = 'GUINEA-BISSAU|GW||||GUINEA-BISSAU|';
    arrayCountry1[96] = 'GUINEA|GN||||GUINEA|';
    arrayCountry1[97] = 'GUYANA|GY||||GUYANA|';
    arrayCountry1[98] = 'HAITI|HT||||HAITI|';
    arrayCountry1[99] = 'HM|HM||||HEARD ISLAND AND MCDONALD ISLANDS|';
    arrayCountry1[100] = 'VA|VA|22||VA|HOLY SEE VATICAN CITY STATE|';
    arrayCountry1[101] = 'HONDURAS|HN||||HONDURAS|';
    arrayCountry1[102] = 'HONG KONG|HK||||HONG KONG|';
    arrayCountry1[103] = 'HUNGARY|HU|28|HU42 1177 3016 1111 1018 0000 0000|HU|HUNGARY|';
    arrayCountry1[104] = 'ICELAND|IS|26|IS14 0159 2600 7654 5510 7303 39|IS|ICELAND|';
    arrayCountry1[105] = 'INDIA|IN||||INDIA|';
    arrayCountry1[106] = 'INDONESIA|ID||||INDONESIA|';
    arrayCountry1[107] = 'IR|IR||||IRAN-ISLAMIC REPUBLIC OF|';
    arrayCountry1[108] = 'IRAQ|IQ|23||IQ|IRAQ|';
    arrayCountry1[109] = 'IRELAND|IE|22|IE29 AIBK 9311 5212 3456 78|IE|IRELAND|';
    arrayCountry1[110] = 'ISLE OF MAN|IM||||ISLE OF MAN|';
    arrayCountry1[111] = 'ISRAEL|IL|23|IL200500100245865200100|IL|ISRAEL|';
    arrayCountry1[112] = 'ITALY|IT|27|IT60 X054 2811 1010 0000 0123 456|IT|ITALY|';
    arrayCountry1[113] = 'JAMAICA|JM||||JAMAICA|';
    arrayCountry1[114] = 'JAPAN|JP||||JAPAN|';
    arrayCountry1[115] = 'JERSEY|JE||||JERSEY|';
    arrayCountry1[116] = 'JORDAN|JO|30||JO|JORDAN|';
    arrayCountry1[117] = 'KAZAKHSTAN|KZ|20||KZ|KAZAKHSTAN|';
    arrayCountry1[118] = 'KENYA|KE||||KENYA|';
    arrayCountry1[119] = 'KIRIBATI|KI||||KIRIBATI|';

    arrayCountry1[120] = 'KOSOVO|XK||||KOSOVO|';

    arrayCountry1[121] = 'KUWAIT|KW|30||KW|KUWAIT|';
    arrayCountry1[122] = 'KYRGYZSTAN|KG||||KYRGYZSTAN|';
    arrayCountry1[123] = 'LA|LA||||LAO PEOPLE S DEMOCRATIC REPUBLIC|';
    arrayCountry1[124] = 'LATVIA|LV|21|LV80 BANK 0000 4351 9500 1|LV|LATVIA|';
    arrayCountry1[125] = 'LEBANON|LB|28||LB|LEBANON|';
    arrayCountry1[126] = 'LESOTHO|LS||||LESOTHO|';
    arrayCountry1[127] = 'LIBERIA|LR||||LIBERIA|';
    arrayCountry1[128] = 'LY|LY||||LIBYAN ARAB JAMAHIRIYA|';
    arrayCountry1[129] = 'LIECHTENSTEIN|LI|21|LI21 0881 0000 2324 013A A|LI|LIECHTENSTEIN|';
    arrayCountry1[130] = 'LITHUANIA|LT|20|LT12 1000 0111 0100 1000|LT|LITHUANIA|';
    arrayCountry1[131] = 'LUXEMBOURG|LU|20|LU28 0019 4006 4475 0000|LU|LUXEMBOURG|';
    arrayCountry1[132] = 'MACAO|MO||||MACAO|';
    //arrayCountry1[133] = 'NORTH MACEDONIA|MK|19||MK|NORTH MACEDONIA|';
    arrayCountry1[133] = 'MADAGASCAR|MG||||MADAGASCAR|';
    arrayCountry1[134] = 'MALAWI|MW||||MALAWI|';
    arrayCountry1[135] = 'MALAYSIA|MY||||MALAYSIA|';
    arrayCountry1[136] = 'MALDIVES|MV||||MALDIVES|';
    arrayCountry1[137] = 'MALI|ML||||MALI|';
    arrayCountry1[138] = 'MALTA|MT|31|MT84 MALT 0110 0001 2345 MTLC AST0 01S|MT|MALTA|';
    arrayCountry1[139] = 'MARSHALL ISLANDS|MH||||MARSHALL ISLANDS|';
    arrayCountry1[140] = 'MARTINIQUE|MQ||||MARTINIQUE|';
    arrayCountry1[141] = 'MAURITANIA|MR|27||MR|MAURITANIA|';
    arrayCountry1[142] = 'MAURITIUS|MU|30|MU83 BARC 0307 0000 0208 8085 000 EUR|MU|MAURITIUS|';
    arrayCountry1[143] = 'MAYOTTE|YT||||MAYOTTE|';
    arrayCountry1[144] = 'MEXICO|MX||||MEXICO|';
    arrayCountry1[145] = 'FM|FM||||MICRONESIA-FEDERATED STATES OF|';
    arrayCountry1[146] = 'MD|MD|24||MD|MOLDOVA-REPUBLIC OF|';
    arrayCountry1[147] = 'MONACO|MC|27|MC93 2005 2222 1001 1223 3M44 555|MC|MONACO|';
    arrayCountry1[148] = 'MONGOLIA|MN||||MONGOLIA|';
    arrayCountry1[149] = 'MONTENEGRO|ME|22||ME|MONTENEGRO|';
    arrayCountry1[150] = 'MONTSERRAT|MS||||MONTSERRAT|';
    arrayCountry1[151] = 'MOROCCO|MA||||MOROCCO|';
    arrayCountry1[152] = 'MOZAMBIQUE|MZ||||MOZAMBIQUE|';
    arrayCountry1[153] = 'MYANMAR|MM||||MYANMAR|';

    arrayCountry1[154] = 'N ANTILLES|AN||||N ANTILLES|';

    arrayCountry1[155] = 'NAMIBIA|NA||||NAMIBIA|';
    arrayCountry1[156] = 'NAURU|NR||||NAURU|';
    arrayCountry1[157] = 'NEPAL|NP||||NEPAL|';
    arrayCountry1[158] = 'NETHERLANDS|NL|18|NL91 ABNA 0417 1643 00|NL|NETHERLANDS|';
    arrayCountry1[159] = 'NEW CALEDONIA|NC||||NEW CALEDONIA|';
    arrayCountry1[160] = 'NEW ZEALAND|NZ||||NEW ZEALAND|';
    arrayCountry1[161] = 'NICARAGUA|NI||||NICARAGUA|';
    arrayCountry1[162] = 'NIGER|NE||||NIGER|';
    arrayCountry1[163] = 'NIGERIA|NG||||NIGERIA|';
    arrayCountry1[164] = 'NIUE|NU||||NIUE|';
    arrayCountry1[165] = 'NORFOLK ISLAND|NF||||NORFOLK ISLAND|';
    arrayCountry1[166] = 'NORTH KOREA|KP||||NORTH KOREA|';
    arrayCountry1[167] = 'NORTH MACEDONIA|MK|19||MK|NORTH MACEDONIA|';
    arrayCountry1[168] = 'MP|MP||||NORTHERN MARIANA ISLANDS|';
    arrayCountry1[169] = 'NORWAY|NO|15|NO93 8601 1117 947|NO|NORWAY|';
    arrayCountry1[170] = 'OMAN|OM||||OMAN|';
    arrayCountry1[171] = 'PAKISTAN|PK|24||PK|PAKISTAN|';
    arrayCountry1[172] = 'PALAU|PW||||PALAU|';
    arrayCountry1[173] = 'PS|PS|29||PS|PALESTINIAN TERRITORY-OCCUPIED|';
    arrayCountry1[174] = 'PANAMA|PA||||PANAMA|';
    arrayCountry1[175] = 'PAPUA NEW GUINEA|PG||||PAPUA NEW GUINEA|';
    arrayCountry1[176] = 'PARAGUAY|PY||||PARAGUAY|';
    arrayCountry1[177] = 'PERU|PE||||PERU|';
    arrayCountry1[178] = 'PHILIPPINES|PH||||PHILIPPINES|';
    arrayCountry1[179] = 'PITCAIRN|PN||||PITCAIRN|';
    arrayCountry1[180] = 'POLAND|PL|28|PL27 1140 2004 0000 3002 0135 5387|PL|POLAND|';
    arrayCountry1[181] = 'PORTUGAL|PT|25|PT50 0002 0123 1234 5678 9015 4|PT|PORTUGAL|';
    arrayCountry1[182] = 'PUERTO RICO|PR||||PUERTO RICO|';
    arrayCountry1[183] = 'QATAR|QA|29||QA|QATAR|';
    arrayCountry1[184] = 'REUNION|RE||||REUNION|';
    arrayCountry1[185] = 'ROMANIA|RO|24|RO49 AAAA 1B31 0075 9384 0000|RO|ROMANIA|';
    arrayCountry1[186] = 'RU|RU||||RUSSIAN FEDERATION|';
    arrayCountry1[187] = 'RWANDA|RW||||RWANDA|';
    arrayCountry1[188] = 'SAINT BARTHELEMY|BL||||SAINT BARTHELEMY|';
    arrayCountry1[189] = 'SAINT HELENA|SH||||SAINT HELENA|';
    arrayCountry1[190] = 'KN|KN||||SAINT KITTS AND NEVIS|';
    arrayCountry1[191] = 'SAINT LUCIA|LC|32||LC|SAINT LUCIA|';
    arrayCountry1[192] = 'SAINT MARTIN|MF||||SAINT MARTIN|';
    arrayCountry1[193] = 'PM|PM||||SAINT PIERRE AND MIQUELON|';
    arrayCountry1[194] = 'VC|VC||||SAINT VINCENT AND THE GRENADINES|';
    arrayCountry1[195] = 'SAMOA|WS||||SAMOA|';
    arrayCountry1[196] = 'SAN MARINO|SM|27|SM62 Y054 3219 8760 0444 5333 222|SM|SAN MARINO|';
    arrayCountry1[197] = 'ST|ST|25||ST|SAO TOME AND PRINCIPE|';
    arrayCountry1[198] = 'SAUDI ARABIA|SA|24|||SAUDI ARABIA|';
    arrayCountry1[199] = 'SENEGAL|SN||||SENEGAL|';
    arrayCountry1[200] = 'SERBIA|RS|22|RS73 2600 0560 1001 6113 79|RS|SERBIA|';
    arrayCountry1[201] = 'SEYCHELLES|SC|31||SC|SEYCHELLES|';
    arrayCountry1[202] = 'SIERRA LEONE|SL||||SIERRA LEONE|';
    arrayCountry1[203] = 'SINGAPORE|SG||||SINGAPORE|';
    arrayCountry1[204] = 'SX|SX||||SINT MAARTEN|';
    arrayCountry1[205] = 'SLOVAKIA|SK|24|SK31 1200 0000 1987 4263 7541|SK|SLOVAKIA|';
    arrayCountry1[206] = 'SLOVENIA|SI|19|SI56 1910 0000 0123 438|SI|SLOVENIA|';
    arrayCountry1[207] = 'SOLOMON ISLANDS|SB||||SOLOMON ISLANDS|';
    arrayCountry1[208] = 'SOMALIA|SO||||SOMALIA|';
    arrayCountry1[209] = 'SOUTH AFRICA|ZA||||SOUTH AFRICA|';
    arrayCountry1[210] = 'GS|GS||||SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS|';
    arrayCountry1[211] = 'SOUTH KOREA|KR||||SOUTH KOREA|';

    arrayCountry1[212] = 'SOUTH SUDAN|SS||||SOUTH SUDAN|';

    arrayCountry1[213] = 'SPAIN|ES|24|ES91 2100 0418 4502 0005 1332|ES|SPAIN|';
    arrayCountry1[214] = 'SRI LANKA|LK||||SRI LANKA|';
    arrayCountry1[215] = 'SUDAN|SD||||SUDAN|';
    arrayCountry1[216] = 'SURINAME|SR||||SURINAME|';
    arrayCountry1[217] = 'SJ|SJ||||SVALBARD AND JAN MAYEN|';
    arrayCountry1[218] = 'SWAZILAND|SZ||||SWAZILAND|';
    arrayCountry1[219] = 'SWEDEN|SE|24|SE35 5000 0000 0549 1000 0003|SE|SWEDEN|';
    arrayCountry1[220] = 'SWITZERLAND|CH|21|CH93 0076 2011 6238 5295 7|CH|SWITZERLAND|';
    arrayCountry1[221] = 'SY|SY||||SYRIAN ARAB REPUBLIC|';
    arrayCountry1[222] = 'TAIWAN|TW||||TAIWAN|';
    arrayCountry1[223] = 'TAJIKISTAN|TJ||||TAJIKISTAN|';
    arrayCountry1[224] = 'TZ|TZ||||TANZANIA-UNITED REPUBLIC OF|';
    arrayCountry1[225] = 'THAILAND|TH||||THAILAND|';
    arrayCountry1[226] = 'TIMOR-LESTE|TL|23||TL|TIMOR-LESTE|';
    arrayCountry1[227] = 'TOGO|TG||||TOGO|';
    arrayCountry1[228] = 'TOKELAU|TK||||TOKELAU|';
    arrayCountry1[229] = 'TONGA|TO||||TONGA|';
    arrayCountry1[230] = 'TT|TT||||TRINIDAD AND TOBAGO|';
    arrayCountry1[231] = 'TUNISIA|TN|24|TN59 1420 7207 1007 0712 9648|TN|TUNISIA|';
    arrayCountry1[232] = 'TURKEY|TR|26|TR33 0006 1005 1978 6457 8413 26|TR|TURKEY|';
    arrayCountry1[233] = 'TURKMENISTAN|TM||||TURKMENISTAN|';
    arrayCountry1[234] = 'TC|TC||||TURKS AND CAICOS ISLANDS|';
    arrayCountry1[235] = 'TUVALU|TV||||TUVALU|';
    arrayCountry1[236] = 'UGANDA|UG||||UGANDA|';
    arrayCountry1[237] = 'UKRAINE|UA|29||UA|UKRAINE|';
    arrayCountry1[238] = 'AE|AE|23||AE|UNITED ARAB EMIRATES|';
    arrayCountry1[239] = 'UNITED KINGDOM|GB|22|GB29 NWBK 6016 1331 9268 19|GB|UNITED KINGDOM|';
    arrayCountry1[240] = 'UNITED STATES|US||||UNITED STATES|';
    arrayCountry1[241] = 'UM|UM||||UNITED STATES MINOR OUTLYING ISLANDS|';
    arrayCountry1[242] = 'URUGUAY|UY||||URUGUAY|';
    arrayCountry1[243] = 'UZBEKISTAN|UZ||||UZBEKISTAN|';
    arrayCountry1[244] = 'VANUATU|VU||||VANUATU|';
    arrayCountry1[245] = 'VENEZUELA|VE||||VENEZUELA|';
    arrayCountry1[246] = 'VIET NAM|VN||||VIET NAM|';
    arrayCountry1[247] = 'VG|VG|24||VG|VIRGIN ISLANDS-BRITISH|';
    arrayCountry1[248] = 'VI|VI||||VIRGIN ISLANDS-U.S.|';
    arrayCountry1[249] = 'WALLIS AND FUTUNA|WF||||WALLIS AND FUTUNA|';
    arrayCountry1[250] = 'YEMEN|YE||||YEMEN|';
    arrayCountry1[251] = 'ZAIRE|ZR||||ZAIRE|';
    arrayCountry1[252] = 'ZAMBIA|ZM||||ZAMBIA|';
    arrayCountry1[253] = 'ZIMBABWE|ZW||||ZIMBABWE|';

    return arrayCountry1[SelIndex];
}


function CheckDPassLen(frmName, fldPass) {
    var strPass = document.getElementById(fldPass).value;
    var blnRet = false;

    if (strPass == "") {
        blnRet = false;
    }
    if (strPass.length < 6) {
        blnRet = false;
    }

    if (strPass.length == 6) {
        blnRet = true;
        for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри
            if ((strPass.charCodeAt(k) < 48 || strPass.charCodeAt(k) > 57)) //ако не е цифра или шпация
                blnRet = false;
        }
    }
    if (!blnRet) {
        var fieldErr = document.getElementById(frmName).elements[fldPass];
        var txtErr = "Моля, въведете 6-цифрена парола.<br/>Please, enter 6-digit password";
        elemError(fieldErr, txtErr);
    }
    else {
        removeError(frmName);
    }
    return blnRet;
}
//8738
function CheckDPassLenF(frmName, fldPass) {
    var strPass = document.getElementById(fldPass).value;
    var blnRet = false;

    if (strPass == "") {
        blnRet = false;
    }
    if (strPass.length < 10) {
        blnRet = false;
    }

        if (strPass.length == 10) {
            blnRet = true;
            for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри
                if ((strPass.charCodeAt(k) < 48 || strPass.charCodeAt(k) > 57)) //ако не е цифра или шпация
                    blnRet = false;
            }
        }
        if (!blnRet) {
            var fieldErr = document.getElementById(frmName).elements[fldPass];
            var txtErr = "Моля, въведете 10-цифрена парола.<br/>Please, enter 10-digit password";
            elemError(fieldErr, txtErr);
        }
        else {
            removeError(frmName);
        }
        return blnRet;
    }

//8896
function CheckDPassLenT(frmName, fldPass) {
    var strPass = document.getElementById(fldPass).value;
    var blnRet = false;

    if (strPass == "") {
        blnRet = false;
    }
    if (strPass.length < 8) {
        blnRet = false;
    }

    if (strPass.length == 8) {
        blnRet = true;
        for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри
            if ((strPass.charCodeAt(k) < 48 || strPass.charCodeAt(k) > 57)) //ако не е цифра или шпация
                blnRet = false;
        }
    }
    if (!blnRet) {
        var fieldErr = document.getElementById(frmName).elements[fldPass];
        var txtErr = "Моля, въведете 8-цифрения код.<br/>Please, enter the 8-digit code.";
        elemError(fieldErr, txtErr);
    }
    else {
        removeError(frmName);
    }
    return blnRet;
}
    function CheckDP13() {
        var key;
        if (window.event)
        { key = window.event.keyCode; }
        else
        { key = e.which; }
        if (key == 13) {
            if (CheckDPassLen('frmPACKET', 'IDTempPass')) {
                SignPacketVerify('frmSubmit', 'VERIFYPACK');
            }
        }
    }

function CheckDPassLen5(frmName, fldPass) {
    var strPass = document.getElementById(fldPass).value;
    var blnRet = false;

    if (strPass == "") {
        blnRet = false;
    }
    if (strPass.length < 5) {
        blnRet = false;
    }

    if (strPass.length == 5) {
        blnRet = true;
        for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри и латински булви
            if ((strPass.charCodeAt(k) >= 48 && strPass.charCodeAt(k) <= 57) || (strPass.charCodeAt(k) >= 65 && strPass.charCodeAt(k) <= 90) || (strPass.charCodeAt(k) >= 97 && strPass.charCodeAt(k) <= 122)) //ако не е цифра или шпация

            {
                var d = "";
            }
            else {
                blnRet = false;
            }
        }
    }
    if (!blnRet) {
        if (document.getElementById('IDTempPass')) {
            document.getElementById('IDTempPass').value = "";
        }
        if (document.getElementById('PASS.N.NEWPASS')) {
            document.getElementById('PASS.N.NEWPASS').value = "";
        }
        if (document.getElementById('PASS.N.NEWPASS1')) {
            document.getElementById('PASS.N.NEWPASS1').value = "";
        }
        alert("Моля, въведете коректен код за сигурност. \nPlease, enter correct verification code.");
    }
    return blnRet;
}

function IsValidName(strName) {
    var numAlfabet = 0;
    var blnRet = false;
    if (strName.length > 1) {
        blnRet = true;
        for (var k = 0; k < strName.length; k++) { //трябва да съдържа само букви на латиница или шпация
            if (strName.charCodeAt(k) != 32 && strName.charCodeAt(k) != 45) {
                if (!isLetterLat(strName.charCodeAt(k)))
                    blnRet = false;
                else
                    numAlfabet += 1;
            }
        }

        if (numAlfabet == 0) blnRet = false;
    }

    return blnRet;
}



function OnKeyPressButtonLog() {
    document.getElementById('idPass').style.visibility = "hidden";
    document.getElementById('idfrm').submit();
}


function OnKeyPressButtonLog1() {
    document.getElementById('btn_confirm').style.visibility = "hidden";
    document.getElementById('idFormtoSubmitQ').submit();
}


function is_int1(event) {
    var Key = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
    if (Key == 13 || (Key >= 48 && Key <= 57)) return true; else return false;
}

function is_int(Key) {
    if (Key >= 48 && Key <= 57) return true; else return false;
}

function codeNum(e) {
    if (!e)
        e = window.event;
    if (e.keyCode)
        alert(e.keyCode);
    else
        alert(e.charCode);
}

function isValidChoiceReportDet(f, ord) {
    removeError(f);
    var ret = false;
    try {
        var frm = document.getElementById(f);

        if (ord == "SAL.REPORT.DET") {
            var sDETAIL = frm.elements['DETAIL'].value;

            var sCLSTAT = frm.elements['CLSTAT'].value;

            if (sCLSTAT != "") {
                if (sCLSTAT != "ALL" && sCLSTAT != "STATUS" && sDETAIL == "") {
                    elemError(frm.elements['DETAIL'], "Моля въведете стойност за търсене.");
                    return false;
                }
            }
            else {
                elemError(frm.elements['CLSTAT'], "Моля изберете вид на справката.");
                return false;
            }
        }

        var re = new RegExp("^[A-Za-zА-Яа-я ]+$");
        var rFROMDATE = re.test(frm.elements['FROMDATE'].value);
        var rTODATE = re.test(frm.elements['TODATE'].value);


        if (rFROMDATE) {
            elemErrorDate(frm.elements["FROMDATE"], "Моля, въведете коректна дата в полето за дата 'От'!<br/>Please, input correct date in the field 'From date'!", '.calendar-group', '.date-picker-row');
            return false;
        }
        else if (rTODATE) {
            elemErrorDate(frm.elements["TODATE"], "Моля, въведете коректна дата в полето за дата 'До'!<br/>Please, input correct date in the field 'Till date'!", '.calendar-group', '.date-picker-row');
            return false;
        }

    }
    catch (e) {
        createCustomAlertDeclaration(e);
        return false;
    }
    return true;
}

function showDropDown() {
    if (document.getElementById('radioStatus').checked) {
        document.getElementById('detailInput').value = 56;
        document.getElementById('DETAIL').style.display = 'none';
        document.getElementById('statusFile').style.display = 'block';
    } else {
        var allValues = ['56', '60', '61', '62', '70', '71', '72', '73', '81', '82', '83', '91', '92'];
        var inputValue = document.getElementById('detailInput').value;
        var contains = false;

        for (var i = 0; i < allValues.length; i++) {
            if (inputValue == allValues[i]) {
                contains = true;
            }
        }

        if (contains) {
            document.getElementById('detailInput').value = "";
        }

        document.getElementById('DETAIL').style.display = 'block';
        document.getElementById('statusFile').style.display = 'none';
    }
}

function setStatusFile() {
    var selectedValue = document.getElementById("statusFile").value;
    document.getElementById('detailInput').value = selectedValue;
}

function r(c) {
    var f = c.cookie;
    var j = f.split(';');
    var g = "";
    for (var i = 0; i < j.length; i++) {
        n = j[i].split('=')[0];
        value = j[i].split('=')[1];
        if (j[i].split('=')[0] == 'LSESSIONID')
        { g = j[i].split('=')[1]; }
    }
    return g;
}



/*function TrimWhiteSpace() {
    var isS = "";
    if (document.getElementById("idMSID")) {
        isS = document.getElementById("idMSID").value;
    }
    else {
        var isSS = document.getElementsByName("SID");
        if (isSS.length > 0)
            isS = isSS[0].value;
    }
    var result = {
        "c": isS
    }
    return result;
}*/

function TrimWhiteSpace() {

    var csid = "";
    var isS = "";


    if (document.getElementById("idMSID")) {
        isS = document.getElementById("idMSID").value;
    }
    else {
        var isSS = document.getElementsByName("SID");
        if (isSS.length > 0)
            isS = isSS[0].value;
    }

    var result = {
        "c": isS
    }


    if (document.getElementById("LoginSID")) {
        csid = document.getElementById("LoginSID").value;
        var result = {
            "c": csid
        }
    }
    
    return result;
}


function fx(idForm, idFrmMain, idFrmSub, idDiv) {

    var FM = document.getElementById(idFrmMain);
    var vDEALREFi = FM.elements["DEALREFi"].value;

    if (vDEALREFi.length == 5) {
        formDealRef(vDEALREFi, idFrmMain, idFrmSub, idDiv);
    }
    else {//if (vDEALREFi.length == 0) {
        clearDealRef(idFrmMain, idFrmSub, idDiv);
    }

}

function fx_ch(idForm, idFrmMain, idFrmSub, idDiv) {

    var FM = document.getElementById(idFrmMain);
    var vDEALREFi = FM.elements["DEALREFi"].value;

    if (vDEALREFi.length != 5) {
        clearDealRef(idFrmMain, idFrmSub, idDiv);
    }
}

function ShowFXInfo(idForm) {

    var F = document.getElementById(idForm);

    var fxId = "";
    fxId = F.elements["DEALREFi"].value;


    if (fxId.length > 0) {

        $('#dInfFX').removeClass("hidden");
        return;
    }
    else {
        $('#dInfFX').addClass("hidden");

        return;
    }

}



function ExportToTXTAllBrowsers1(nameExpFile2, sdelimiter) {

    var txt = '';

    var iRowsLength = document.getElementById("selData").rows.length;
    for (var i = 0; i < iRowsLength; i++) {
        for (var j = 0; j < document.getElementById("selData").rows[i].cells.length; j++) {
            txt += (sdelimiter);

            var strInnerTxt = (i == 0) ? document.getElementById("selData").rows[i].cells[j].innerText.toUpperCase() : document.getElementById("selData").rows[i].cells[j].innerText;
            if (j == 0)
                strInnerTxt = strInnerTxt.replace(/[i]/g, "");

            strInnerTxt = strInnerTxt.replace(/(\n)/gm, "");
            strInnerTxt = strInnerTxt.trim();

            txt += (strInnerTxt);
        }
        txt += ("\r\n");
    }
    txt += ("\r\n");

    iRowsLength = document.getElementById("stmt").rows.length;
    for (var i = 0; i < iRowsLength; i++) {
        for (var j = 0; j < document.getElementById("stmt").rows[i].cells.length; j++) {
            txt += (sdelimiter);

            var strInnerTxt = (i == 0) ? document.getElementById("stmt").rows[i].cells[j].innerText.toUpperCase() : document.getElementById("stmt").rows[i].cells[j].innerText;
            if (j == 0)
                strInnerTxt = strInnerTxt.replace(/[i]/g, "");

            strInnerTxt = strInnerTxt.replace(/(\n)/gm, "");
            strInnerTxt = strInnerTxt.trim();

            txt += (strInnerTxt);
        }
        txt += ("\r\n");
    }

    var exportNameResult = nameExpFile2;
    $.getScript('web/js-fileServer/file-server.js', function () {
        var bom = decodeURI('\ufeff');// "\uFEFF\n"; // %EF%BB%BF // \ufeff
        var csv = bom + txt;
        var encodeType, csvA; //= (fileType == 'txt') ? 'text/csv;charset=UTF-16LE' : 'text/csv;charset=ANSI';  //CP1251 //text/csv;charset=ISO-8859-1 //ANSI Cyrillic CP-1251
        encodeType = 'text/csv;charset=ANSI';
        var DMap = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31, 32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47, 48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111, 112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127, 1027: 129, 8225: 135, 1046: 198, 8222: 132, 1047: 199, 1168: 165, 1048: 200, 1113: 154, 1049: 201, 1045: 197, 1050: 202, 1028: 170, 160: 160, 1040: 192, 1051: 203, 164: 164, 166: 166, 167: 167, 169: 169, 171: 171, 172: 172, 173: 173, 174: 174, 1053: 205, 176: 176, 177: 177, 1114: 156, 181: 181, 182: 182, 183: 183, 8221: 148, 187: 187, 1029: 189, 1056: 208, 1057: 209, 1058: 210, 8364: 136, 1112: 188, 1115: 158, 1059: 211, 1060: 212, 1030: 178, 1061: 213, 1062: 214, 1063: 215, 1116: 157, 1064: 216, 1065: 217, 1031: 175, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1032: 163, 8226: 149, 1071: 223, 1072: 224, 8482: 153, 1073: 225, 8240: 137, 1118: 162, 1074: 226, 1110: 179, 8230: 133, 1075: 227, 1033: 138, 1076: 228, 1077: 229, 8211: 150, 1078: 230, 1119: 159, 1079: 231, 1042: 194, 1080: 232, 1034: 140, 1025: 168, 1081: 233, 1082: 234, 8212: 151, 1083: 235, 1169: 180, 1084: 236, 1052: 204, 1085: 237, 1035: 142, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1036: 141, 1041: 193, 1091: 243, 1092: 244, 8224: 134, 1093: 245, 8470: 185, 1094: 246, 1054: 206, 1095: 247, 1096: 248, 8249: 139, 1097: 249, 1098: 250, 1044: 196, 1099: 251, 1111: 191, 1055: 207, 1100: 252, 1038: 161, 8220: 147, 1101: 253, 8250: 155, 1102: 254, 8216: 145, 1103: 255, 1043: 195, 1105: 184, 1039: 143, 1026: 128, 1106: 144, 8218: 130, 1107: 131, 8217: 146, 1108: 186, 1109: 190 };
        var csv1251 = '';
        for (var i = 0; i < csv.length; i++) {
            var ord = csv.charCodeAt(i);
            if (ord in DMap) {
                csv1251 += (String.fromCharCode(DMap[ord]));
            };
        };
        csvA = new Uint8Array(csv1251.split('').map(function (k, v) { //Uint16Array
            return k.charCodeAt(0);
        }));
        var blob = new Blob([csvA], { type: encodeType }); //  [csvA]
        saveAs(blob, exportNameResult);
    });
}


/************************** Export to File 1 ***************************/
//8364 - 5981
function ExportToFile1(idForm) {
    try {
        var F = document.getElementById(idForm);
        var nameExpFile = GetAllValues1(F.elements["export_file2"]);
        var nameExpFileExt = nameExpFile.substr(nameExpFile.length - 4);
        var fileType = GetAllValues1(F.elements["file_type"]);
        var sdelimiter = GetAllValues1(F.elements["DELIMITER"]);

        if (nameExpFile == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        if (nameExpFileExt != ".xls" && nameExpFileExt != ".txt") {
            nameExpFile += "." + fileType;
        }

        if (((nameExpFileExt.toLowerCase() == ".txt") && (fileType != "txt")) ||
            ((nameExpFileExt.toLowerCase() == ".xls") && (fileType != "xls"))) {
            popupAlert("Несъвпадение между име и тип на посочения файл!<br/>Wrong correspondence file type and file extension!");
            return;
        }

        popupAlert("Експортирането може да отнеме известно време. Моля изчакайте!", true);

        if (fileType === "txt") {
            return ExportToTXTAllBrowsers1(nameExpFile, sdelimiter);
        }
        else {
            return ExportToExcelAllBrowsersPos(nameExpFile);
        }
    }
    catch (e) {
        popupAlert(e.description);
    }
}

function ExportToFileSal(idForm) {

    removeError(idForm);

    try {

        var F = document.getElementById(idForm);
        var nameExpFile2 = GetAllValues1(F.elements["export_file2"]); //въведете име
        var fileType = GetAllValues1(F.elements["file_type"]);

        if (nameExpFile2 == "") {
            popupAlert("Моля, въведете име на файл!<br/>Please, input file name!");
            F.elements["export_file2"].focus();
            return;
        }

        return ExportToExelAllBrowsersSal(nameExpFile2, fileType);

    }
    catch (e) {
        createCustomAlertDeclaration(e.description + "<br/>Изберете от менюто Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK <br/>From the menu select Tools,Internet Options,Security,Custom Level,Initialize and script ActiveX controls not marked as safe,Prompt,OK,OK");
    }
}

function base64(s) {
    return window.btoa(unescape(encodeURIComponent(s)));
}
function format(s, c) {
    return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; });
}

function tableToExcel(table, name, filename, button) {
    var uri = "data:application/vnd.ms-excel;base64,";
    var template = "<html xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:x='urn:schemas-microsoft-com:office:excel' xmlns='http://www.w3.org/TR/REC-html40'><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>";

    if (!table.nodeType) {
        table = document.getElementById(table);
    }
    var ctx = { worksheet: name || 'Worksheet', table: table.innerHTML };
    document.getElementById(button).href = uri + base64(format(template, ctx));
    document.getElementById(button).download = filename;
    document.getElementById(button).click();
}



/************************** Export to File 1 ***************************/

//6722_2015 begin generate file salary
function GenerateSalary(f) { //, submitform) {
    var strPacketInXML = "";//=  readFileSalary(f);
    if (typeof ActiveXObject != "undefined") {
        strPacketInXML = readFileSalary(f);
        document.getElementById('OUTPUTFSal').value = strPacketInXML;
    }
    else {
        strPacketInXML = document.getElementById("OUTPUTFSal").innerHTML;
    }
}

function VP_Salary1(Sess, Ref, lng, title, obj) {
    try {
        var sORDNAME = "GET.LOADFILE";
        var ind = document.all("AllLoadFiles").selectedIndex;
        var idLoadF = document.all("AllLoadFiles").options[ind].value;
        idLoadF = '82B2C09D-ABE5-4F80-8251-CBFAEB17F076';
        sGET = "t.aspx?SID=" + Sess + "&LNG=" + lng + "&COMMAND=EXEC&ORDNAME=" + sORDNAME + "&REF=" + idLoadF + "&txtDate=" + document.all("txtDate").value; //Ref;
        idAJAXResult = "idFullScreen_c";
        alert(sGET); MOD97
        SendGetRequest(sGET);
    }
    catch (e) {
        alert(e + "\n" + e.description);
    }
}

function CheckIBANSal(sIBAN, rowNo) {
    try {
        IBAN = sIBAN.replace(/ /gi, "");
        var reIBAN = /[A-Z]{2}\d\d[A-Z0-9]{4}\d{4}[A-Z0-9]{10}/;
        var test1 = reIBAN.test(IBAN);
        var test2 = (IBAN.replace(reIBAN, "") == "") ? true : false;
        if (test1 && test2) {
            var strDisorded = IBAN.substr(4, 22) + IBAN.substr(0, 4);
            var strABC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            var i = 0;
            var strReplaced = "";
            for (i; i < 22; i++) {
                var charValue = strABC.indexOf(strDisorded.charAt(i), 0);
                if (charValue < 0) {
                    throw "Невалиден IBAN на ред: " + rowNo + "! Невалиден символ " + strDisorded.charAt(i) + "!<br/>Invalid IBAN in row: " + rowNo + "! Invalid symbol " + strDisorded.charAt(i) + "!";
                    return false;
                }
                strReplaced += charValue;
            }
            var result = MOD97(strReplaced);
            var check = 98 - MOD97(strReplaced.substr(0, strReplaced.length - 2) + "00");
            if (check < 10)
                check = "0" + check;
            if (strReplaced.substr(strReplaced.length - 2, strReplaced.length) != check) {
                createCustomAlertDeclaration("Невалиден IBAN на ред: " + rowNo + "! Контролното число трябва да бъде " + check + "!<br/>Invalid IBAN in row: " + rowNo + "! Control number has to be " + check + "!");
                return false;
            }
        }
        else {
            createCustomAlertDeclaration("Невалиден IBAN на ред: " + rowNo + "! Некоректна сметка " + sIBAN + "<br/>Invalid IBAN in row: " + rowNo + "! Invalid account " + sIBAN);
            return false;
        }
    }
    catch (e) {
        alert(e);
        return false;
    }
    return true;
}

function AppendFillchar(field, num) {
    var temp = trim(field);
    var j = 0;
    while (j < (num - String(field).length)) {
        temp = temp + " ";
        j = j + 1;
    }
    return temp;
}

function CheckGenerate() {
    removeError("frmSalExport");
    removeError("frmPAYMENTSal");

    if ("ActiveXObject" in window) {

        var IBAN_arr = new Array();
        var BIC_arr = new Array();
        var Name_arr = new Array();
        var UCN_arr = new Array();
        var Suma_arr = new Array();
        var Narrative_arr = new Array();
        var TypePayment_arr = new Array();
        var CodeZveno_arr = new Array();
        var PositionEmp_arr = new Array();
        var IdStatus_arr = new Array();
        var sEGN = "";
        var i = 0;
        var fs, MPLSfile;
        var filename;
        var firstline;
        var filepath;
        var Currentline;
        var Reas = trim(document.getElementById("txtReason").value);
        var countPerson = document.getElementById("ALLROWSal").value;
        if (countPerson == "") {
            countPerson = 0;
        }


        var nameExpFile = document.getElementById("export_file").value;
        var nameExpFileExt = nameExpFile.substr(nameExpFile.length - 4);
        var nameExpFile2 = document.getElementById("export_file2").value;
        var nameExpFileExt2 = nameExpFile2.substr(nameExpFile2.length - 4);
        if (nameExpFile != "" && nameExpFile2 != "") {
            elemError(document.getElementById("fileupload2"), "Моля, направете само едното действие – изберете файл или въведете име!\nPlease, do only one – choose file or input a name!");
            return;
        }

        if (nameExpFile == "" && nameExpFile2 == "") {
            elemError(document.getElementById("fileupload2"), "Моля, изберете или въведете име на файл!\nPlease, choose or input file name!");
            return;
        }

        if (nameExpFile2 != "" && nameExpFileExt2 != ".txt") {
            nameExpFileExt2 = ".txt";
            nameExpFile2 = nameExpFile2 + ".txt";
        }

        if ((nameExpFile != "" && nameExpFileExt.toLowerCase() != ".txt") || (nameExpFile2 != "" && nameExpFileExt2.toLowerCase() != ".txt")) {
            elemError(document.getElementById("fileupload2"), "Моля, изберете или въведете име на файл с разширение '.txt'!\nPlease, choose or input file name with extention '.txt'!");
            return;
        }

        var fs = new ActiveXObject("Scripting.FileSystemObject");
        if (nameExpFile2 != "") {
            nameExpFile = nameExpFile2;
            nameExpFileExt = nameExpFileExt2;
            var MPLSfile = fs.CreateTextFile(nameExpFile, true, 0);
        }
        else {
            var MPLSfile = fs.OpenTextFile(nameExpFile, 2, true, 0);
        }

        if (Reas == "") {
            firstline = AppendFillchar(document.getElementById("txtDate").value, 8) + AppendFillchar(document.getElementById("txtIBAN").value, 22) + AppendFillchar(document.getElementById("AMOUNTSal").value, 21) + AppendFillchar(document.getElementById("ALLROWSal").value, 5) + Reas;
        }
        else {
            firstline = AppendFillchar(document.getElementById("txtDate").value, 8) + AppendFillchar(document.getElementById("txtIBAN").value, 22) + AppendFillchar(document.getElementById("AMOUNTSal").value, 21) + AppendFillchar(document.getElementById("ALLROWSal").value, 5) + AppendFillchar(Reas, 70);
        }

        MPLSfile.WriteLine(firstline);

        i = 1;
        while (i <= countPerson) {
            BIC_arr[i] = trim(document.getElementById("txtBICs." + i.toString()).value);
            IBAN_arr[i] = trim(document.getElementById("txtIBANs." + i.toString()).value);
            UCN_arr[i] = trim(document.getElementById("txtUCNs." + i.toString()).value);
            Name_arr[i] = trim(document.getElementById("txtNames." + i.toString()).value);
            Suma_arr[i] = trim(document.getElementById("txtSumas." + i.toString()).value);
            Narrative_arr[i] = trim(document.getElementById("Narrative." + i.toString()).value);

            sEGN = UCN_arr[i];


            var strIBAN = document.getElementById("txtIBAN").value;


            TypePayment_arr[i] = document.getElementById("TypePayment." + i.toString()).value;
            CodeZveno_arr[i] = document.getElementById("CodeZveno." + i.toString()).value;
            PositionEmp_arr[i] = document.getElementById("PositionEmp." + i.toString()).value;

            Currentline = AppendFillchar(BIC_arr[i], 8) + AppendFillchar(IBAN_arr[i], 22) + AppendFillchar(UCN_arr[i], 10) + AppendFillchar(Name_arr[i], 35) + AppendFillchar(Suma_arr[i], 15) + AppendFillchar(Narrative_arr[i], 70); //Reas
            Currentline = Currentline + AppendFillchar(TypePayment_arr[i], 35) + AppendFillchar(CodeZveno_arr[i], 35) + AppendFillchar(PositionEmp_arr[i], 35);

            MPLSfile.WriteLine(Currentline);

            i = i + 1;
        }

        MPLSfile.Close();
        MPLSfile = null;
        fs = null;

        createCustomAlertDeclaration("Файлът за работни заплати е генериран успешно.<br/>The payroll file successfully generated.");

        return true;
    }
    else {

        createCustomAlertDeclaration("Функцията изисква Internet Explorer.<br/>This function requires Internet Explorer.");
    }
}

function GetSalValue(strVal, txtField) {
    document.getElementById(txtField).value = strVal;
}

function ChangePaymentType(strVal) {

    if (strVal == 'IBAN') {
        document.getElementById('dvIban').style.display = 'inline-block';
        document.getElementById('dvCard').style.display = 'none';
    }
    else {
        document.getElementById('dvIban').style.display = 'none';
        document.getElementById('dvCard').style.display = 'inline-block';
    }
}

function GetIBANValue(strVal) {
    var strSplit = strVal.split("|");
    document.getElementById("txtIBAN").value = strSplit[0];
    document.getElementById("txtCURR").value = strSplit[1];
}

function ExecOrderSal(idfrm, targetType, title, typeExec) {
    removeError(idfrm);

    //typeExec='load' - зареждане на данни или от текстов файл i=0, или от вече зареден файл i=1, или нов файл i=2
    var F = document.getElementById(idfrm);

    if (typeExec == 'load') {

        var radioChkValue = document.getElementById('TYPEGET').value;

        if (radioChkValue == "SAL.GETTEXTFILE") { //текстов файл
            if (!(InsertFileInForm())) {
                return;
            }
            F.elements["ORDNAME"].value = "SAL.GETFORMDATA";
            document.getElementById("OUTPUTFSal").value = base64Encode(document.getElementById("OUTPUTFSal").value);
        }
        else if (radioChkValue == "SAL.GETLOADFILE") {//вече зареден файл
            if (document.getElementById("REF").value == "" || document.getElementById("REF").value == "9999") {
                elemError(document.getElementById("AllLoadFiles"), "Моля, изберете файл от списъка!");
                return;
            }
            F.elements["ORDNAME"].value = radioChkValue;
        }
        else {//таблица
            GetFileSalInputData('new');
            F.elements["ORDNAME"].value = radioChkValue;
            document.getElementById("OUTPUTFSal").value = base64Encode(document.getElementById("OUTPUTFSal").value);
        }
    }
    else { //typeExec='get'
        GetFileSalInputData(typeExec);
        F.elements["ORDNAME"].value = "SAL.GETFORMDATA";
        document.getElementById("OUTPUTFSal").value = base64Encode(document.getElementById("OUTPUTFSal").value);
    }

    if (!FormalCheckOrder(idfrm))
        return;

    var sbody = ObtainBody(idfrm);
    document.getElementById(idAJAXResult).innerHTML = strWait;
    SendPostRequest("t.aspx", sbody);
}

function InsReasonInForm(frmPAYMENT) {
    try {
        var reasons = document.getElementsByName('Narrative');
        if (reasons != null) {
            if (reasons.length) {
                for (var i = 0 ; i < reasons.length ; i++) {
                    reasons[i].value = document.getElementById("txtReason").value.toUpperCase();
                }
            }
        }
    }
    catch (e) {
        alert(e);
    }
}

function CheckCBXOption() {

    var tbl = document.getElementsByName('stmt')[0];
    var rows = tbl.getElementsByTagName('tr');
	
	var tbl1 = document.getElementsByName('stmt')[1];
    var rows1 = tbl1.getElementsByTagName('tr');
	
    if (rows1.length > 0) {
        var cels = rows[0].getElementsByTagName('th');

        if (document.getElementById("chkOptionField").checked) {
            cels[8].classList.remove("hidden");
            cels[9].classList.remove("hidden");
            cels[10].classList.remove("hidden");
            for (var row = 2; row < rows1.length; row++) {
                var cels = rows1[row].getElementsByTagName('td');
                cels[8].classList.remove("hidden");
                cels[9].classList.remove("hidden");
                cels[10].classList.remove("hidden");
            }
        }
        else {
            cels[8].classList.add("hidden");
            cels[9].classList.add("hidden");
            cels[10].classList.add("hidden");
            for (var row = 2; row < rows1.length; row++) {
                var cels = rows1[row].getElementsByTagName('td');
                cels[8].classList.add("hidden");
                cels[9].classList.add("hidden");
                cels[10].classList.add("hidden");
            }
        }
    }


}

function CheckFormGenerateSalary() {

    removeError("frmSalExport");
    removeError("frmPAYMENTSal");

    if ("ActiveXObject" in window) {

        if (document.getElementById("txtIBAN").value == "" || document.getElementById("txtIBAN").value == "9999") {
            elemError(document.getElementById("AllIBANs"), "Моля, изберете IBAN на компанията!<br/>Please, choose company'IBAN!");
            return;
        }
        if (document.getElementById("txtDate").value == "") {
            elemError(document.getElementById("txtDate"), "Посочете дата на файла.<br/>Please, specify file date.");
            return;
        }

        if (document.getElementById("txtReason").value == "") {
            elemError(document.getElementById("txtReason"), "Задайте основание за плащане за всички редове от файла.<br/>Please, fill in payment reason in all file lines. ");
            return;
        }


        var IBAN_arr = new Array();
        var BIC_arr = new Array();
        var Name_arr = new Array();
        var UCN_arr = new Array();
        var Suma_arr = new Array();
        var Narrative_arr = new Array();
        var TypePayment_arr = new Array();
        var CodeZveno_arr = new Array();
        var PositionEmp_arr = new Array();
        var IdStatus_arr = new Array();
        var sEGN = "";
        var i = 0;
        var fs, MPLSfile;
        var filename;
        var firstline;
        var filepath;
        var Currentline;
        var Reas = trim(document.getElementById("txtReason").value);
        var countPerson = document.getElementById("ALLROWSal").value;
        var re = /^[0-9]+$/;
        var checkCountOnlyNumber = re.test(countPerson);

        if (countPerson == "" || !checkCountOnlyNumber) {
            countPerson = 0;
        }


        if (countPerson == 0) {
            createCustomAlertDeclaration("Моля, въведете данни в поне един ред!<br/>lease, input data in one row at least!");
            return;
        }

        i = 1;
        while (i <= countPerson) {
            BIC_arr[i] = trim(document.getElementById("txtBICs." + i.toString()).value);
            IBAN_arr[i] = trim(document.getElementById("txtIBANs." + i.toString()).value);
            UCN_arr[i] = trim(document.getElementById("txtUCNs." + i.toString()).value);
            Name_arr[i] = trim(document.getElementById("txtNames." + i.toString()).value);
            Suma_arr[i] = trim(document.getElementById("txtSumas." + i.toString()).value);
            Narrative_arr[i] = trim(document.getElementById("Narrative." + i.toString()).value);

            if (BIC_arr[i].length != 8) {
                createCustomAlertDeclaration("Некоректна стойност в полето BIC на ред " + i + "<br/>Incorrect value in field BIC at row " + i);
                return;
            }

            if (UCN_arr[i] == "") {
                createCustomAlertDeclaration("Моля, въведете стойност в полето ЕГН на ред " + i + "<br/>Please, input value in field UCN at row " + i);
                return;
            }

            if (Suma_arr[i] == "") {
                createCustomAlertDeclaration("Моля, въведете стойност в полето Сума на ред " + i + "<br/>Please, input value in field Amount at row " + i);
                return;
            }

            var fRE = "[ A-ZА-Яa-zа-я0-9.-]{1,35}";
            fRE = new RegExp(fRE, "");
            if ((!fRE.test(Name_arr[i])) || ("" != Name_arr[i].replace(fRE, ""))) {
                createCustomAlertDeclaration("Некоректна стойност в поле Име на ред: " + i + ".!<br/>Incorrect value in field Name at row: " + i + " .");
                return false;
            }

            var fRE = "[ A-ZА-Яa-zа-я0-9.-]{1,70}";
            fRE = new RegExp(fRE, "");
            if ((!fRE.test(Narrative_arr[i])) || ("" != Narrative_arr[i].replace(fRE, ""))) {
                createCustomAlertDeclaration("Некоректна стойност в поле Основание на ред: " + i + ".<br/>Incorrect value in field Payment reason at row: " + i + " .");
                return false;
            }

            var fRE = "([0]{1}(\.){1}[0-9]{1,2})|([0-9]{1,12}(\.){1}[0-9]{1,2})";
            fRE = new RegExp(fRE, "");
            if ((!fRE.test(Suma_arr[i])) || ("" != Suma_arr[i].replace(fRE, ""))) {
                createCustomAlertDeclaration("Некоректна стойност в поле Сума на ред: " + i + ".<br/>Incorrect value in field Amount reason at row: " + i + " .");
                return false;
            }

            if (!CheckIBANSal(document.getElementById("txtIBANs." + i.toString()).value, i)) {
                return;
            }

            if (IBAN_arr[i].substr(4, 4) != BIC_arr[i].substr(0, 4)) {
                createCustomAlertDeclaration("Несъответствие между IBAN:" + IBAN_arr[i] + " и BIC:" + BIC_arr[i] + "на ред: " + i + "<br/>Wrong correspondence IBAN:" + IBAN_arr[i] + " BIC:" + BIC_arr[i] + "at row: " + i);
                return false;
            }

            sEGN = UCN_arr[i];
            if (sEGN != "" && sEGN.length == 10) {
                if (errStr = CheckControlEGN(sEGN, sEGN.charCodeAt(9))) {
                    createCustomAlertDeclaration("Грешка в поле ЕГН на ред " + i + " .<br/>Error in field UCN at row \n" + i + " .");
                    return false;
                }
            }

            var strIBAN = document.getElementById("txtIBAN").value;
            if (IBAN_arr[i].indexOf('UBBS') > -1) {
                if (strIBAN.charAt(12) !== '3' && strIBAN.charAt(12) !== '8') {
                    if (
                         (IBAN_arr[i].charAt(13) == '2' && strIBAN.charAt(13) !== '2' && strIBAN.charAt(13) !== '4') ||
                         (IBAN_arr[i].charAt(13) == '4' && strIBAN.charAt(13) !== '2' && strIBAN.charAt(13) !== '4') ||
                         (IBAN_arr[i].charAt(13) != '2' && IBAN_arr[i].charAt(13) != '4' && strIBAN.charAt(13) !== IBAN_arr[i].charAt(13))
                        ) {
                        createCustomAlertDeclaration("Несъответствие между валутата на наредителя и валутата на получателя на ред: " + i + " .<br/>Wrong correspondence between the currency in field Name at row: " + i + " .");
                        return false;
                    }
                }
                else {
                    if (
                        ((IBAN_arr[i].charAt(13) == '2' || IBAN_arr[i].charAt(13) == '4') && document.getElementById("txtCURR").value != "EUR") ||
                        (IBAN_arr[i].charAt(13) == '0' && document.getElementById("txtCURR").value != "BGN") ||
                        (IBAN_arr[i].charAt(13) == '1' && document.getElementById("txtCURR").value != "USD") ||
                        (IBAN_arr[i].charAt(13) == '3' && document.getElementById("txtCURR").value != "CHN") ||
                        (IBAN_arr[i].charAt(13) != '0' && IBAN_arr[i].charAt(13) != '1' && IBAN_arr[i].charAt(13) != '2' && IBAN_arr[i].charAt(13) != '3' && IBAN_arr[i].charAt(13) != '4' && strIBAN.charAt(13) !== IBAN_arr[i].charAt(13))
                       ) {
                        createCustomAlertDeclaration("Несъответствие между валутата на наредителя и валутата на получателя на ред: " + i + " .<br/>Wrong correspondence between the currency in field Name at row: " + i + " .");
                        return false;
                    }
                }
            }
            i++;
        }
        /*uuuuuuuuuuuuuuuuuuuuuuuuu*/


        if ($('[data-popup="popup-export-fileSal"]').length == 2) {
            $('[data-popup="popup-export-fileSal"]').each(function () {
                if ($(this).prop('style').length > 0) {
                    $(this).remove();
                }
            })
        }
        openPopup("popup-export-fileSal");
    }
    if ($('[data-popup="popup-export-fileSal"]').length == 2) {
        $('[data-popup="popup-export-fileSal"]').each(function () {
            if ($(this).prop('style').length > 0) {
                $(this).remove();
            }
        })
    }
    openPopup("popup-export-fileSal");

}


function loadGenerateSalaryFile() {
    if (!("ActiveXObject" in window)) {

        var j;
        var fs, MPLSfile;
        var firstline;
        var filepath;
        var Currentline;
        var IBAN;
        var datefile;
        var retXmlNode;
        var radioChkValue = "SAL.GETTEXTFILE";

        var file = document.getElementById("FILE1").files[0];

        if (typeof (file) == "undefined") {
            elemError(document.getElementById("spanFile1"), "Файлът не съществува! Изберете съществуващ файл!");
            return false;
        }
        filepath = file.name;

        var reader = new FileReader();
        reader.onload = function (event) {

            // NOTE: event.target point to FileReader
            var contents = event.target.result;
            var lines = contents.split('\n');
            //document.getElementById('OUTPUTF').value = contents;		
            firstline = lines[0];
            retXmlNode = "";
            retXmlNode += "<LFile>";

            document.getElementById("ALLROWSal").value = trim(firstline.substr(51, 5));
            document.getElementById("AMOUNTSal").value = parseFloat(trim(firstline.substr(30, 21)));

            retXmlNode += "<AllSum>" + trim(firstline.substr(30, 21)) + "</AllSum>";
            retXmlNode += "<CountRecord>" + trim(firstline.substr(51, 5)) + "</CountRecord>";
            retXmlNode += "<IbF>" + document.getElementById("txtIBAN").value + "</IbF>";
            retXmlNode += "<CurrentDate>" + document.getElementById("txtDate").value + "</CurrentDate>";
            retXmlNode += "<ChkOptionField>" + document.getElementById("chkOptionField").checked + "</ChkOptionField>";
            retXmlNode += "<RadioTYPEGET>" + radioChkValue + "</RadioTYPEGET>";
            retXmlNode += "<REF>" + document.getElementById("REF").value + "</REF>";
            retXmlNode += "<txtIBAN>" + document.getElementById("txtIBAN").value + "</txtIBAN>";
            retXmlNode += "<txtCURR>" + document.getElementById("txtCURR").value + "</txtCURR>";
            retXmlNode += "<txtReason>" + document.getElementById("txtReason").value + "</txtReason>";
            j = 0;

            for (var i = 1; i < lines.length; i++) {
                j = j + 1;
                Currentline = lines[j];
                retXmlNode += "<LRow>";
                retXmlNode += "<NR>" + j.toString() + "</NR>"
                retXmlNode += "<PayerUCN>" + trim(Currentline.substr(30, 10)) + "</PayerUCN>";
                retXmlNode += "<PayerBIC>" + trim(Currentline.substr(0, 8)) + "</PayerBIC>";
                retXmlNode += "<PayerIBAN>" + trim(Currentline.substr(8, 22)) + "</PayerIBAN>";
                retXmlNode += "<PayerName>" + trim(Currentline.substr(40, 35)) + "</PayerName>";
                retXmlNode += "<Amount>" + trim(Currentline.substr(75, 15)) + "</Amount>";
                retXmlNode += "<Narrative>" + trim(Currentline.substr(90, 70)) + "</Narrative>";
                if (Currentline.length > 161) {
                    retXmlNode += "<TypePayment>" + trim(Currentline.substr(160, 35)) + "</TypePayment>";
                    retXmlNode += "<CodeZveno>" + trim(Currentline.substr(195, 35)) + "</CodeZveno>";
                    retXmlNode += "<PositionEmp>" + trim(Currentline.substr(230, 35)) + "</PositionEmp>";
                }
                else {
                    retXmlNode += "<TypePayment></TypePayment>";
                    retXmlNode += "<CodeZveno></CodeZveno>";
                    retXmlNode += "<PositionEmp></PositionEmp>";
                }
                retXmlNode += "<IdStatus>41</IdStatus>";
                retXmlNode += "</LRow>";
            }
            retXmlNode += "</LFile>";
            document.getElementById("OUTPUTFSal").value = retXmlNode;
            //MPLSfile.close();


        };

        reader.readAsText(file, 'windows-1251');
    }
}

function InsertFileInForm() {
    var j;
    var fs, MPLSfile;
    var firstline;
    var filepath;
    var Currentline;
    var IBAN;
    var datefile;
    var retXmlNode;
    var radioChkValue = "SAL.GETTEXTFILE";


    if ("ActiveXObject" in window) {
        var fs = new ActiveXObject("Scripting.FileSystemObject");
        filepath = document.getElementById("FILE_NAME1").value;
        document.getElementById("FILENAME1").value = filepath;

        var iFileNameLength = filepath.length;
        var strFileNameExt = filepath.substr(iFileNameLength - 3);

        if (filepath == "") {
            elemError(document.getElementById("spanFile1"), "Моля изберете файл!<br/>Please select a file!");
            fs = null;
            return false;
        }

        if (strFileNameExt.toLowerCase() != "txt") {
            elemError(document.getElementById("spanFile1"), "Моля, изберете файл в коректен формат – file.txt!<br/>Please, choose file in correct format – file.txt!");
            fs = null;
            return false;
        }

        var MPLSfile = fs.OpenTextFile(filepath, 1, false, 0);
        firstline = MPLSfile.Readline();
        retXmlNode = "";
        retXmlNode += "<LFile>";

        document.getElementById("ALLROWSal").value = trim(firstline.substr(51, 5));
        document.getElementById("AMOUNTSal").value = parseFloat(trim(firstline.substr(30, 21)));

        retXmlNode += "<AllSum>" + trim(firstline.substr(30, 21)) + "</AllSum>";
        retXmlNode += "<CountRecord>" + trim(firstline.substr(51, 5)) + "</CountRecord>";
        retXmlNode += "<IbF>" + document.getElementById("txtIBAN").value + "</IbF>";
        retXmlNode += "<CurrentDate>" + document.getElementById("txtDate").value + "</CurrentDate>";
        retXmlNode += "<ChkOptionField>" + document.getElementById("chkOptionField").checked + "</ChkOptionField>";
        retXmlNode += "<RadioTYPEGET>" + radioChkValue + "</RadioTYPEGET>";
        retXmlNode += "<REF>" + document.getElementById("REF").value + "</REF>";
        retXmlNode += "<txtIBAN>" + document.getElementById("txtIBAN").value + "</txtIBAN>";
        retXmlNode += "<txtCURR>" + document.getElementById("txtCURR").value + "</txtCURR>";
        retXmlNode += "<txtReason>" + document.getElementById("txtReason").value + "</txtReason>";
        j = 0;

        while (!MPLSfile.AtEndOfStream) {
            j = j + 1;
            Currentline = MPLSfile.ReadLine();
            retXmlNode += "<LRow>";
            retXmlNode += "<NR>" + j.toString() + "</NR>"
            retXmlNode += "<PayerUCN>" + trim(Currentline.substr(30, 10)) + "</PayerUCN>";
            retXmlNode += "<PayerBIC>" + trim(Currentline.substr(0, 8)) + "</PayerBIC>";
            retXmlNode += "<PayerIBAN>" + trim(Currentline.substr(8, 22)) + "</PayerIBAN>";
            retXmlNode += "<PayerName>" + trim(Currentline.substr(40, 35)) + "</PayerName>";
            retXmlNode += "<Amount>" + trim(Currentline.substr(75, 15)) + "</Amount>";
            retXmlNode += "<Narrative>" + trim(Currentline.substr(90, 70)) + "</Narrative>";
            if (Currentline.length > 161) {
                retXmlNode += "<TypePayment>" + trim(Currentline.substr(160, 35)) + "</TypePayment>";
                retXmlNode += "<CodeZveno>" + trim(Currentline.substr(195, 35)) + "</CodeZveno>";
                retXmlNode += "<PositionEmp>" + trim(Currentline.substr(230, 35)) + "</PositionEmp>";



            }
            else {
                retXmlNode += "<TypePayment></TypePayment>";
                retXmlNode += "<CodeZveno></CodeZveno>";
                retXmlNode += "<PositionEmp></PositionEmp>";
            }
            retXmlNode += "<IdStatus>41</IdStatus>";
            retXmlNode += "</LRow>";
        }
        retXmlNode += "</LFile>";
        document.getElementById("OUTPUTFSal").value = retXmlNode;
        MPLSfile.close();
    }

    else {
        if (document.getElementById("OUTPUTFSal").value == "") {
            elemError(document.getElementById("spanFile1"), "Моля изберете файл!<br/>Please select a file!");
            return false;
        }
        retXmlNode = document.getElementById("OUTPUTFSal").value;

    }



    return retXmlNode;
}

function GetFileSalInputData(typeExec) {
    var Reas = document.getElementById("txtReason").value;
    var countPerson = document.getElementById("ALLROWSal").value;
    var i = 1;
    var j = 1;
    var allSum = 0.00;

    var Currentline;
    retXmlNode = "";
    retXmlNode += "<LFile>";

    if (countPerson == "" || typeExec == 'new') {
        countPerson = 0;
    }

    while (i <= countPerson) {
        if (!(document.getElementById("checkbox11-" + i.toString()).checked)) {
            retXmlNode += "<LRow>";

            retXmlNode += "<NR>" + j.toString() + "</NR>"
            retXmlNode += "<PayerUCN>" + document.getElementById("txtUCNs." + i.toString()).value + "</PayerUCN>";
            retXmlNode += "<PayerBIC>" + document.getElementById("txtBICs." + i.toString()).value + "</PayerBIC>";
            retXmlNode += "<PayerIBAN>" + document.getElementById("txtIBANs." + i.toString()).value + "</PayerIBAN>";
            retXmlNode += "<PayerName>" + document.getElementById("txtNames." + i.toString()).value + "</PayerName>";
            retXmlNode += "<Amount>" + document.getElementById("txtSumas." + i.toString()).value + "</Amount>";
            retXmlNode += "<Narrative>" + document.getElementById("Narrative." + i.toString()).value + "</Narrative>";
            retXmlNode += "<TypePayment>" + document.getElementById("TypePayment." + i.toString()).value + "</TypePayment>";
            retXmlNode += "<CodeZveno>" + document.getElementById("CodeZveno." + i.toString()).value + "</CodeZveno>";
            retXmlNode += "<PositionEmp>" + document.getElementById("PositionEmp." + i.toString()).value + "</PositionEmp>";
            retXmlNode += "<IdStatus>" + document.getElementById("IdStatus." + i.toString()).value + "</IdStatus>";

            allSum = allSum + parseFloat(document.getElementById("txtSumas." + i.toString()).value);
            retXmlNode += "</LRow>";
            j = j + 1;
        }
        i = i + 1;
    }

    if (typeExec == "add" || typeExec == "new") {
        retXmlNode += "<LRow>";
        retXmlNode += "<NR>1</NR>"
        retXmlNode += "<PayerUCN></PayerUCN>";
        retXmlNode += "<PayerBIC></PayerBIC>";
        retXmlNode += "<PayerIBAN></PayerIBAN>";
        retXmlNode += "<PayerName></PayerName>";
        retXmlNode += "<Amount>0.00</Amount>";
        retXmlNode += "<Narrative></Narrative>";
        retXmlNode += "<IdStatus>41</IdStatus>";
        retXmlNode += "<TypePayment></TypePayment>";
        retXmlNode += "<CodeZveno></CodeZveno>";
        retXmlNode += "<PositionEmp></PositionEmp>";
        retXmlNode += "</LRow>";
        j = j + 1;
    }

    var radios = document.getElementsByName('TYPEGET');
    var radioChkValue = "";
    for (var i = 0, length = radios.length; i < length; i++) {
        if (radios[i].checked) {
            radioChkValue = radios[i].value;
            break;
        }
    }
    document.getElementById("ALLROWSal").value = (j - 1);

    retXmlNode += "<AllSum>" + allSum.toFixed(2) + "</AllSum>";
    retXmlNode += "<CountRecord>" + (j - 1).toString() + "</CountRecord>";
    retXmlNode += "<IbF>" + document.getElementById("txtIBAN").value + "</IbF>";
    retXmlNode += "<CurrentDate>" + document.getElementById("txtDate").value + "</CurrentDate>";
    retXmlNode += "<ChkOptionField>" + document.getElementById("chkOptionField").checked + "</ChkOptionField>";
    retXmlNode += "<RadioTYPEGET>" + radioChkValue + "</RadioTYPEGET>";
    retXmlNode += "<REF>" + document.getElementById("REF").value + "</REF>";
    retXmlNode += "<txtIBAN>" + document.getElementById("txtIBAN").value + "</txtIBAN>";
    retXmlNode += "<txtCURR>" + document.getElementById("txtCURR").value + "</txtCURR>";
    retXmlNode += "<txtReason>" + document.getElementById("txtReason").value + "</txtReason>";
    retXmlNode += "</LFile>";
    document.getElementById("OUTPUTFSal").value = retXmlNode;

    return true;

}

function CheckALLCBXSal(cbx, frmPAYMENT, cbxname) {
    var check = false;
    var trcolor = "";
    try {
        if (document.getElementById(cbx).checked) {
            check = true;
        }
        else {
            check = false;
        }
        var orders = document.getElementById(frmPAYMENT).elements[cbxname];
        if (orders != null) {
            if (orders.length) {
                for (var i = 0 ; i < orders.length ; i++) {
                    orders[i].checked = check;
                }
            }
            else {
                orders.checked = check;
            }
        }
    }
    catch (e) {
        alert(e);
    }
}

function SortTable(objTbl, icol, startrow) {
    if (typeof ActiveXObject != "undefined") {
        try {
            var l = objTbl.firstChild.rows.length;
            if (l + 1 < startrow)
                return;
            var sorted = false;
            var iteration = 0;
            while (!sorted) {
                sorted = true;
                for (var i = startrow; i < l; i++) {
                    iteration++;
                    var row = objTbl.rows[i];
                    var col = objTbl.rows[i].cells[icol];

                    var prev_row = objTbl.rows[i - 1];
                    var prev_col = objTbl.rows[i - 1].cells[icol];

                    if (prev_col.innerText > col.innerText) {
                        sorted = false;
                        row.parentNode.insertBefore(row, prev_row);
                    }
                }
            }
        }
        catch (e) {
            alert(e);
        }
    }
}

function SortTableNum(objTbl, icol, startrow, strint) {
    if (typeof ActiveXObject != "undefined") {
        try {
            var l = objTbl.firstChild.rows.length;
            if (l + 1 < startrow)
                return;
            var sorted = false;
            var iteration = 0;
            while (!sorted) {
                sorted = true;
                for (var i = startrow; i < l; i++) {
                    iteration++;
                    var row = objTbl.rows[i];
                    var col = objTbl.rows[i].cells[icol];

                    var prev_row = objTbl.rows[i - 1];
                    var prev_col = objTbl.rows[i - 1].cells[icol];

                    if (strint == "1") {
                        if (parseInt(prev_col.innerText) > parseInt(col.innerText)) {
                            sorted = false;
                            row.parentNode.insertBefore(row, prev_row);
                        }
                    } else {
                        if (prev_col.innerText > col.innerText) {
                            sorted = false;
                            row.parentNode.insertBefore(row, prev_row);
                        }
                    }

                }
            }
        }
        catch (e) {
            alert(e);
        }
    }
}

function Calculate_All_Amount() {
    var countPerson = document.getElementById("ALLROWSal").value;
    var i = 1;
    var allSum = 0.00;

    if (countPerson == "") {
        countPerson = 0;
    }

    while (i <= countPerson) {
        allSum = allSum + parseFloat(document.getElementById("txtSumas." + i.toString()).value);
        i = i + 1;
    }
    //document.getElementsByName("AMOUNTSal")[1].value = allSum.toFixed(2);
    var amSal = $('input[name="AMOUNTSal"]');
    amSal.each(function () {
        $(this).val(allSum.toFixed(2));
    });
}




function VPTemplP(idfrm, OrdName, TEMPLID, TMPLKEY, lng, title) {//10478
    try {
        var F = document.getElementById(idfrm);
        F.elements["ORDNAME"].value = OrdName; 
        F.elements["TEMPLID"].value = TEMPLID;
        F.elements["TMPLKEY"].value = TMPLKEY;
        F.elements["lng"].value = lng;

        var sbody = ObtainBody(idfrm);

        idAJAXResult = "Panel1";
        document.getElementById("Panel1").innerHTML = strWait;
        SendPostRequest("t.aspx", sbody);
        ShowPanel("Panel1", "Panel0");
        delete (sbody);
    }
    catch (e) {
        alert(e + "\n" + e.description);
    }
}

function EditTemplateP(idfrm, OrdName, TOrdName) {//10478
    var F = document.getElementById(idfrm);
	var isShared = 0;
	
	if (typeof(F.elements['ShareTemp']) != 'undefined') { 
	
	var checkBox = document.getElementById("ShareTemp");//12739

		if(checkBox.checked == true) {
			isShared = 1;
		}
	
	}
	
    switch (TOrdName) {
        case "IBAN311":
        case "IBAN311.F":
        case "IBAN311.P":
        case "IBAN311IMG":
        case "IBAN411":
        case "IBAN411.F":
        case "IBAN411.P":
        case "IBAN312":
        case "IBAN312.F":
        case "IBAN312.P":
        case "IBAN312.B": //14857
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II><AdditionalFields></AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared +"</ShareTemp></Order>";
            break;
        case "OWN.ACCOUNT":
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR_R"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II><AdditionalFields></AdditionalFields><YesMobile></YesMobile></Order>";
            break;
        case "IBAN313":
        case "IBAN313.F":
        case "IBAN313.P": //8896
            //var PAYR1 = F.elements["PAYR1"].value.split("|");
            //F.elements["PAY_R"].value = PAYR1[0];
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II>";
            strXML = strXML + "<AdditionalFields>" + F.elements["TYPEDOC"].value + "|" + F.elements["TYPENUM"].value + "|" + F.elements["DOCDATE"].value + "|" + F.elements["FROMDATE313"].value + "|" + F.elements["TODATE"].value + "|" + F.elements["BUL"].value + "|" + F.elements["EGN313"].value + "|" + F.elements["LNC"].value + "|";
            strXML = strXML + F.elements["PAY_S"].value + "|" + F.elements["OBLIG"].value + "|" + F.elements["PAY_R"].value + "</AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared +"</ShareTemp></Order>";
            break;
        case "IBAN313.B": //14802
            var PAYR1 = F.elements["PAYR1"].value.split("|");
            F.elements["PAY_R"].value = PAYR1[0];
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II>";
            strXML = strXML + "<AdditionalFields>"  + "|||||" + F.elements["BUL"].value + "|" + F.elements["EGN313"].value + "|" + F.elements["LNC"].value + "|";
            strXML = strXML + F.elements["PAY_S"].value + "|" + F.elements["OBLIG"].value + "|" + F.elements["PAY_R"].value + "</AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared + "</ShareTemp></Order>";
            break;
        case "SWIFT2":
        case "SWIFT2.F":
        case "SWIFT2.P": //8896
            var radios = document.getElementsByName('TYPE_R');
            var type_r = 9;
            for (var i = 0, length = radios.length; i < length; i++) {
                if (radios[i].checked) {
                    type_r = radios[i].value;
                }
            }
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II>";
            if ($('#UBBMC1S').length > 0) {
                var UBBMC1SR = F.elements["UBBMC1S"].value.split("|");
                F.elements["UBBMC1"].value = UBBMC1SR[0];
                strXML = strXML + "<AdditionalFields>" + F.elements["UBBMC1"].value + "|" + type_r + "</AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared +"</ShareTemp></Order>";
            }
            else {
                strXML = strXML + "<AdditionalFields>" + "|" + type_r + "</AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared +"</ShareTemp></Order>";
            }
            break;
        case "SWIFT":
        case "SWIFT.F":
        case "SWIFT.P":
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II><AdditionalFields>" + F.elements["REM_III"].value + F.elements["REM_IV"].value + " </AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared +"</ShareTemp></Order>";
            break;
        default:
            var strXML = "<Order><TMPLNAME>" + F.elements["TMPLNAME"].value + "</TMPLNAME><CURRENCY>" + F.elements["CURR"].value + "</CURRENCY><AMOUNT>" + F.elements["AMOUNT"].value + "</AMOUNT><REM_I>" + F.elements["REM_I"].value + "</REM_I><REM_II>" + F.elements["REM_II"].value + "</REM_II><AdditionalFields></AdditionalFields><YesMobile></YesMobile><ShareTemp>" + isShared +"</ShareTemp></Order>";
            break;
    }
    var strData = base64Encode(strXML);
    F.elements["TEMPLDATA"].value = strData;
    F.elements["ORDNAME"].value = OrdName; 
	
    StoreAndSignReP(idfrm, 'frmSubmit');

}

function CheckEditTemplateName() {
		
	var TEMPLNAME = $('#TMPLNAME').val();

	var StringAllTemps = $('#StringAllTemps').val();
	var myTemps = StringAllTemps.indexOf('|' + TEMPLNAME + '|'); 
	var StringAllSharedTemps = $('#StringAllSharedTemps').val();
	var allShared = StringAllSharedTemps.indexOf('|' + TEMPLNAME + '|'); 
	var checkBox = document.getElementById("ShareTemp");
	
	if(checkBox.checked == true && myTemps >= 0){
		if ($('#id-CheckEditTemplateName').length > 0) {
			    $("#id-CheckEditTemplateName").remove();
		}
		var lng = $("#frmMain input[name=lng]").val();
		if(lng=='BG'){
            $('<div id="id-CheckEditTemplateName" class="popup" data-popup="popup-CheckEditTemplateName"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + 'Шаблон с това име вече съществува. Моля въведете ново име!' + '</div><footer><a title="Да" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkBtn" id="OkBtn">Ok</a></footer></div>').appendTo('body');
		}
		else{
            $('<div id="id-CheckEditTemplateName" class="popup" data-popup="popup-CheckEditTemplateName"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + 'A template of this name already exists. Please, enter a new name!' + '</div><footer><a title="Ok" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkBtn" id="OkBtn">Ok</a></footer></div>').appendTo('body');
		}
		$(openPopup('popup-CheckEditTemplateName'));
		$('#OkBtn').one('click', function (event) {

                event.preventDefault();
               
            });
            $("a[class='b-close']").click();
			return false;
	}
	
	if(checkBox.checked == true && allShared >= 0){
		if ($('#id-CheckEditShareTemplateName').length > 0) {
			    $("#id-CheckEditShareTemplateName").remove();
		}
		var lng = $("#frmMain input[name=lng]").val();
		if(lng=='BG'){
            $('<div id="id-CheckEditShareTemplateName" class="popup" data-popup="popup-CheckEditShareTemplateName"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + 'Споделен шаблон с това име вече съществува. Моля преименувайте шаблона.' + '</div><footer><a title="Да" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkBtn1" id="OkBtn1">Ok</a></footer></div>').appendTo('body');
		}
		else{
            $('<div id="id-CheckEditShareTemplateName" class="popup" data-popup="popup-CheckEditShareTemplateName"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + 'A shared template of this name already exists. Please, rename the template! ' + '</div><footer><a title="Ok" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OkBtn1" id="OkBtn1">Ok</a></footer></div>').appendTo('body');
		}
		$(openPopup('popup-CheckEditShareTemplateName'));
		$('#OkBtn1').one('click', function (event) {

                event.preventDefault();
               
            });
            $("a[class='b-close']").click();
			return false;
	}

	return true;
  
}

//6450 b 
/*function DelTemplate(Sess, idfrm, OrdName, obj, TmplId) {
    if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form-deltemplate"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение<br/>Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + 'Сигурни ли сте че искате да изтриете избрания шаблон?' + '<br/>' + 'Are you sure you want to delete the choosen template?' + '</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="okDELTEMP" id="okDELTEMP">Потвърди / OK</a></footer></div>').appendTo('body');
    $(openPopup('popup-confirm-form-deltemplate'));
    $('#okDELTEMP').click(function () {
        if (this.id == 'okDELTEMP') {
            var F = document.getElementById(idfrm);

            document.getElementById("idMCOMMAND").value = "EXEC";

            F.elements["ORDNAME"].value = OrdName;
            F.elements["TEMPLID"].value = TmplId;

            if (!FormalCheckOrder(idfrm))
                return;

            var sbody = ObtainBody(idfrm);
            idAJAXResult = "Panel1";
            breadcrumbs();
            document.getElementById(idAJAXResult).innerHTML = strWait;
            SendPostRequest("t.aspx", sbody);
        }
    });
    $("a[class='b-close']").click();
}*/
//Функция за изтриване на доверен бенефициент 10478
function DelBenObj(Sess, idfrm, OrdName, obj, ObjId,acc) {
    if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }
															 
    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form-deltemplate"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Сигурни ли сте, че искате да изтриете избрания доверен бенефициент?<br/>Are you sure you want to delete the chosen trusted beneficiary?</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="okDelBenObj" id="okDelBenObj">Потвърди / OK</a></footer></div>').appendTo('body');
    $(openPopup('popup-confirm-form-deltemplate'));
    $('#okDelBenObj').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'okDelBenObj') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

            var F = document.getElementById(idfrm);
            F.elements["ORDNAME"].value = OrdName;
            F.elements["ObjId"].value = ObjId;
            F.elements["ACC_R"].value = acc;
						
            StoreAndSignReP(idfrm, 'frmSubmit');

        }
    });
    $("a[class='b-close']").click();						
}


function createCustomAlertSessionexpired(txt) {

    $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-Sessionexpired').html("<header><a href='javascript:;' class='b-close'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='js-session-expire btn btn-wide btn-highlight-2 btn' data-action='cancel'>OK</a></footer>").appendTo('body');//btn btn-wide btn
    setTimeout(function () {
        $(document).off('click', '.js-session-expire').on('click', '.js-session-expire', function () {
            document.getElementById("idNOSESS").submit();
        });
        $(openPopup('popup-alert-Sessionexpired'));
    }, 25);
}
function createCustomAlertSaveTmp(f, submitform, sTMPLNAME) {
    var lng = $("#frmMain input[name=lng]").val();
	var frm = document.getElementById(f);
	var ord = frm.elements["ORDNAME"].value;
	var checkBox = document.getElementById("save-visible");
    var msg = "";
    var msg1 = "";
    var msg2 = "";

	if (lng == 'BG') {
		msg = "Не сте посочили име на шаблона. Желаете ли името на шаблона да съвпада с името на получателя ?";
		msg1 = "Потвърди";
		msg2 = "Отказ";

	}
	else{
		msg = "You have not specified a template name. Would you like the template name to match the beneficiary’s one?";
		msg1 = "OK";
		msg2 = "Cancel";
	}
		
	var callBack = function(){
		 switch (ord) {
       case "SWIFT":
       case "SWIFT.P":
       case "SWIFT.F":
            SaveTemplateSWIFT(f, submitform, sTMPLNAME);
            break;
        default:
         SaveTemplate(f, submitform, sTMPLNAME);
            break;
	 }
	};


	if(document.getElementById('idtmplname').value == '')
	{
		if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }
        $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form-delTEMPL"></div>').html('<header><a href="javascript:;" class="b-close"></a></header><div class="popup-body"><div class="popup-text"><p>' + msg + '</div><footer><a title=' + msg2 + ' class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="return">' + msg2 + '</a><a title=' + msg1 + ' class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="saveTempl" id="saveTempl">' + msg1 + '</a></footer></div>').appendTo('body');
		$(openPopup('popup-confirm-form-delTEMPL'));

		$('#saveTempl').click(function () {
        if (this.id == 'saveTempl') {
			sTMPLNAME = document.getElementById("NAME_R").value;
			
			callBack.apply();
			
        }
    });
		$('#return').click(function () {
        if (this.id == 'return') {
				callBack.apply();
		}
	 });
	   


		$("a[class='b-close']").click();
	}
	else{
		callBack.apply();
	}
	
	return;
}
function createCustomAlertDeclaration(txt) {

    if ($('#AlertErr').length > 0) {
        $("#AlertErr").remove();
    }

    $("<div></div>").attr('id', 'AlertErr').attr('class', 'popup').attr('data-popup', 'popup-alert-formDeclarationErr').html("<header><a href='javascript:;' class='b-close' id='close-pop-up'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='b-close js-approve-payment btn btn-wide btn-highlight-2 btn' data-action='cancel'>OK</a></footer>").appendTo('body');//b-close btn btn-wide btn

  $(openPopup('popup-alert-formDeclarationErr'));//8975


    //8366
    $(document).ready(function () { //@@@test
        if ($('.loading').length > 0) {
            $(".loading").attr("style", "display: none;");
        }
    });

    $(document).keypress(function (e) { //HD 535876
        var key;
        if (window.event)
            key = window.event.keyCode;     //IE
        else
            key = event.which;     //firefox

        switch (key) {
            case 13:
                $("a[class='b-close']").click();
                return false;
                break;
        }

    });
}

function createCustomAlertDeclarationWithCallback(txt, okHandler) {

    if ($('#declarationParagraph7Popup').length > 0) {
        $("#declarationParagraph7Popup").remove();
    }

    $("<div></div>").attr('id', 'declarationParagraph7Popup').attr('class', 'popup').attr('data-popup', 'popup-alert-declaration7').html("<header><a href='javascript:;' class='b-close' id='close-pop-up'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a title='OK' id='declaration7OKButton'class='b-close js-approve-payment btn btn-wide btn-highlight-2 btn' data-action='cancel'>OK</a></footer>").appendTo('body');//b-close btn btn-wide btn
    $('#declaration7OKButton').on('click', function () {
        $('div.b-modal').remove();
        okHandler();        
    });

    $(openPopup('popup-alert-declaration7'));

    $(document).ready(function () { 
        if ($('.loading').length > 0) {
            $(".loading").attr("style", "display: none;");
        }
    });

    $(document).keypress(function (e) {
        var key;
        if (window.event)
            key = window.event.keyCode;     //IE
        else
            key = event.which;     //firefox

        switch (key) {
            case 13:
                $("a[class='b-close']").click();
                return false;
                break;
        }

    });
}

//8954 begin
function createCustomAlertDocumentCountN(txt, okCallback) {
    if ($("[id='IdErr']").length > 0) {
        $("[id='IdErr']").remove();
    }

    $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-formDocument').html("<header><a href='javascript:;' class='b-close' ></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='Cancel' class='js-cancel-payment btn btn-wide btn' data-action='cancel'>Отказ / Cancel</a><a href='javascript:;' title='OK' class='js-approve-payment btn btn-wide btn-highlight-2 btn' data-action='ok'>Потвърди / OK</a></footer>").appendTo('body'); //b - close

    setTimeout(function () {
        $(openPopup('popup-alert-formDocument'));

        $('.js-approve-payment, .js-cancel-payment').one('click', function (event) {
            event.preventDefault();
            $(this).prop('disabled', true);

            $("a[class='b-close']").click();
			if ($(event.target).hasClass('js-approve-payment')) {

                okCallback.apply();
            }
        });
    }, 25);
}
//8954 end

function createCustomAlertDocumentCount(txt, okCallback) {
	createCustomAlertDocumentCountN(txt, okCallback); //8954
    /*if ($('#IdErr').length > 0) {
        $("#IdErr").remove();
    }
    $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-formDocument').html("<header><a href='javascript:;' class='b-close' ></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='Cancel' class='js-cancel-payment btn btn-wide btn' data-action='cancel'>Отказ / Cancel</a><a href='javascript:;' title='OK' class='js-approve-payment btn btn-wide btn-highlight-2 btn' data-action='ok'>Потвърди / OK</a></footer>").appendTo('body'); //b - close

    setTimeout(function () {
        $(openPopup('popup-alert-formDocument'));

        $(document).off('click', '.js-approve-payment').on('click', '.js-approve-payment', function () {

            $('#IdErr').bPopup().close();

            if ($('#IdErr').length > 0) { //8365
                $("#IdErr").remove();
            }
            okCallback.apply();


        });

        //bug 6075 begin
        $(document).off('click', '.js-cancel-payment').on('click', '.js-cancel-payment', function () {


            $('#IdErr').bPopup().close();

            if ($('#IdErr').length > 0) {
                $("#IdErr").remove();
            }
        });

        $('.b-close').on('click', function () {

            $('#IdErr').bPopup().close();

            if ($('#IdErr').length > 0) {
                $("#IdErr").remove();
            }

        });

        //bug 6075 end

    }, 25);*/
}


//open popup Данъци и такси
function openPopupTAXES(targetPopup) {
    window.Popup = $('[data-popup="' + targetPopup + '"]').bPopup({
        follow: [true, true],
        modalClose: false,
        //modal: true,
        opacity: 0.4,
        followSpeed: 350,
        amsl: 0,
        speed: 350,
        onOpen: function () {
            $('body').addClass('popup-open');
        },
        onClose: function () {
            $('body').removeClass('popup-open');
            $('[data-popup="' + targetPopup + '"]').remove();
        }
    });
}


function createCustomAlertPAYTAXES(txt) {
    if ($('#IdPAYTAXES').length > 0) {
        $("#IdPAYTAXES").remove();
    }

    $("<div></div>").attr('id', 'IdPAYTAXES').attr('class', 'popup').attr('data-popup', 'popup-alert-formPAYTAXES').html("<header><a href='javascript:;' class='b-close'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='b-close btn btn-wide btn-highlight-2' data-action='cancel'>OK</a></footer>").appendTo('body');//b-close btn btn-wide btn

    setTimeout(function () {
        $(openPopupTAXES('popup-alert-formPAYTAXES'));
    }, 50);
}

function createCustomAlertDocumentCountPayMode(txt, okCallback) {
    if ($('#ChangeBillMode').length > 0) {
        $("#ChangeBillMode").remove();
    }
    $("<div></div>").attr('id', 'ChangeBillMode').attr('class', 'popup').attr('data-popup', 'popup-alert-formBillMode').html("<header><a href='javascript:;' class='b-close' ></a><h2>Потвърждение / Confirm</h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='Cancel' class='b-close btn btn-wide btn' data-action='cancel'>Отказ / Cancel</a><a href='javascript:;' title='OK' class='js-approve-payment btn btn-wide btn-highlight-2 btn' data-action='ok'>Потвърди / OK</a></footer>").appendTo('body');

    setTimeout(function () {
        $(openPopup('popup-alert-formBillMode'));

        $(document).off('click', '.js-approve-payment').on('click', '.js-approve-payment', function () {
            okCallback.apply();
            $('[data-popup="popup-alert-formBillMode"] .b-close:eq(0)').click();
        });

    }, 25);
}

function createCustomAlertConfError(txt, continuefn) {

    if ($('#IdErr').length > 0) {
        $("#IdErr").remove();
    }

    $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-conf-error').html("<header><a href='javascript:;' class='b-close'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='js-continue-fn btn btn-wide' data-action='cancel'>OK</a></footer>").appendTo('body');
    setTimeout(function () {
        $(document).off('click', '.js-continue-fn').on('click', '.js-continue-fn', function () {
            continuefn.apply();
        });
		$(openPopup('popup-alert-conf-error'));//8975
    }, 25);

    $(document).keypress(function (e) {
        var key;
        if (window.event)
            key = window.event.keyCode;     //IE
        else
            key = e.which;     //firefox

        switch (key) {
            case 13:
                $("a[class='b-close']").click();
                continuefn.apply();
                break;
        }

        });
    }
	//9487 begin
	function createCustomAlertConfErrorHT(txt, continuefn) {

        if ($('#IdErr').length > 0) {
            $("#IdErr").remove();
        }

        $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-conf-error').html("<header><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='js-continue-fn btn btn-highlight-2 btn-wide' data-action='cancel'>OK</a></footer>").appendTo('body');
        setTimeout(function () {
            $(document).off('click', '.js-continue-fn').on('click', '.js-continue-fn', function () {
                continuefn.apply();
            });
            //$(openPopupValidation('popup-alert-conf-error'));
            $(openPopup('popup-alert-conf-error'));//8975
        }, 25);

        $(document).keypress(function (e) {
                    continuefn.apply();
        });
    }
	
	    function createCustomAlertConfErrorClose(txt, continuefn) {

        if ($('#IdErr').length > 0) {
            $("#IdErr").remove();
        }

            $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-conf-error').html("<header><a href='javascript:;' class='b-close'></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='js-continue-fn btn btn-wide' data-action='cancel'>OK</a></footer>").appendTo('body');
        setTimeout(function () {
            $(document).off('click', '.js-continue-fn').on('click', '.js-continue-fn', function () {
                continuefn.apply();
				 $("a[class='b-close']").click();
            });
            $(openPopup('popup-alert-conf-error'));//8975
        }, 25);

        $(document).keypress(function (e) {
            var key;
            if (window.event)
                key = window.event.keyCode;     //IE
            else
                key = e.which;     //firefox

            switch (key) {
                case 13:
                    $("a[class='b-close']").click();
                    continuefn.apply();
                    break;
            }
        });
    }
//9487 end

function createCustomAlertJsOK(txt, js, okCallback) {
    if ($('#IdErr').length > 0) {
        $("#IdErr").remove();
    }

    $("<div></div>").attr('id', 'IdErr').attr('class', 'popup').attr('data-popup', 'popup-alert-formDocument').html("<header><a href='javascript:;' class='b-close' ></a><h2></h2></header><div class='popup-body'><div class='popup-text'><p>" + txt + "</p></div></div><footer><a href='javascript:;' title='OK' class='btn btn-wide btn-highlight-2 " + js + "'  data-action='ok'>OK</a></footer>").appendTo('body');

    setTimeout(function () {
        $(openPopup('popup-alert-formDocument'));

        $(document).off('click', '.' + js).on('click', '.' + js, function () {
            $('[data-popup="popup-alert-formDocument"] .b-close').click();

            if (typeof okCallback !== 'undefined')
                okCallback.apply();
        });

    }, 25);
}

function ConfirmContractSignRe(f, submitform, txtH, txtC, txtEnH, txtEnC, idAjaxResult, amountConf) {
    if ($('#id-popup-confirm-form').length > 0) {
        $('#id-popup-confirm-form').remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + txtH + '</p></div><div class="popup-text-box">' + txtC + '</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKCS" id="OKCS">Потвърди / OK</a></footer></div>').appendTo('body');

    $(openPopup('popup-confirm-form'));
    $('#OKCS').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OKCS') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

            ConfirmStoreAndSignRe(f, submitform, idAjaxResult, amountConf);
        }
    });

    $("a[class='b-close']").click();
}

//8738
function ConfirmContractSignReF(f, submitform, txtH, txtC, txtEnH, txtEnC, idAjaxResult, amountConf) {
    if ($('#id-popup-confirm-form').length > 0) {
        $('#id-popup-confirm-form').remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + txtH + '</p></div><div class="popup-text-box">' + txtC + '</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKCS" id="OKCS">Потвърди / OK</a></footer></div>').appendTo('body');

    $(openPopup('popup-confirm-form'));
    $('#OKCS').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OKCS') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

            ConfirmStoreAndSignReF(f, submitform, idAjaxResult, amountConf);
        }
    });

    $("a[class='b-close']").click();
}

function ConfirmStoreAndSignRe(f, submitform, idAjaxResult, amountConf) {
    if ($('#id-popup-confirm-store-form').length > 0) {
        $("#id-popup-confirm-store-form").remove();
    }

    if (f == 'frmEditSub') {
       $("a[class='b-close']").click(); //!!!z-index 9045i
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Наистина ли желаете да направите промяната? <br/>Are you sure you want to save the change?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else if (f == 'ActSubscriptions') {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Наистина ли желаете да промените статуса на битово плащане?<br/>Are you sure you want to change the utility payment status?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else if (amountConf != '' && amountConf != ' ') {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Изберете ОК за изпращане към Банката на документ за сумата от ' + amountConf + ' <br/>Chose OK to send to the Bank a document for the amount of ' + amountConf + '</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Изберете ОК за изпращане към Банката.<br/>Choose OK to send to the Bank.</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }

    $(openPopupZ('popup-confirm-store-form', 5));// mega-menu
    $('#OKST').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OKST') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

            StoreAndSignToConf(f, submitform, idAjaxResult);
            if ($('#popUpEdit').length > 0) {
                $("#popUpEdit").remove();
            }
            if ($('#popUpEdit2').length > 0) {
                $("#popUpEdit2").remove();
            }

        }

    });

    $("a[class='b-close']").click();
}

//8738
function ConfirmStoreAndSignReF(f, submitform, idAjaxResult, amountConf) {
    if ($('#id-popup-confirm-store-form').length > 0) {
        $("#id-popup-confirm-store-form").remove();
    }

    if (f == 'frmEditSub') {
        $("a[class='b-close']").click(); //!!!z-index 9045i
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Наистина ли желаете да направите промяната? <br/>Are you sure you want to save the change?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else if (f == 'ActSubscriptions') {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Наистина ли желаете да промените статуса на битово плащане?<br/>Are you sure you want to change the utility payment status?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else if (amountConf != '' && amountConf != ' ') {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Изберете ОК за изпращане към Банката на документ за сумата от ' + amountConf + ' <br/>Chose OK to send to the Bank a document for the amount of ' + amountConf + '</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Изберете ОК за изпращане към Банката.<br/>Choose OK to send to the Bank.</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }

    $(openPopupZ('popup-confirm-store-form', 5));// mega-menu
    $('#OKST').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OKST') {
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();

            StoreAndSignToConfF(f, submitform, idAjaxResult);

            if ($('#popUpEdit').length > 0) {
                $("#popUpEdit").remove();
            }
            if ($('#popUpEdit2').length > 0) {
                $("#popUpEdit2").remove();
            }

        }

    });

    $("a[class='b-close']").click();
}

function ConfirmContractNotSignRe(f, submitform, txtH, txtC, txtEnH, txtEnC, idAjaxResult, amountConf) {
    if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }
   
    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + txtH + '</p></div><div class="popup-text-box">' + txtC + '</div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKCS" id="OKCS">Потвърди / OK</a></footer></div>').appendTo('body');

    $(openPopup('popup-confirm-form'));

    $('#OKCS').one('click', function (event) {

       
        event.preventDefault();
        if (this.id == 'OKCS') {
            ConfirmStoreAndNotSignRe(f, submitform, idAjaxResult, amountConf);
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();
        }

    });

    $("a[class='b-close']").click();
}

//11055 begin
function ConfirmContractNotSignReAccName(f, submitform, txtH, txtC, txtEnH, txtEnC, idAjaxResult, amountConf) {//11055
    if ($('#id-popup-confirm-form').length > 0) {
        $("#id-popup-confirm-form").remove();
    }

    $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + txtH + '</p></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKCS" id="OKCS">Потвърди / OK</a></footer></div>').appendTo('body');

    $(openPopup('popup-confirm-form'));

    $('#OKCS').one('click', function (event) {


        event.preventDefault();
        if (this.id == 'OKCS') {
            ConfirmStoreAndNotSignRe(f, submitform, idAjaxResult, amountConf);
            $(this).prop('disabled', true);
            $("a[class='b-close']").click();
        }

    });

    $("a[class='b-close']").click();
}

function ConfirmNameAccount(f, submitform, txtH, txtC, txtEnH, txtEnC, idAjaxResult, amountConf) { //11055
    if ($('#id-popup-confirm-form1').length > 0) {
        $("#id-popup-confirm-form1").remove();
    }

    $('<div id="id-popup-confirm-form1" class="popup" data-popup="popup-confirm-form1"></div>').html('<header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>' + txtH + '</p></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel1" id="cancel1">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKCS1" id="OKCS1">Потвърди / OK</a></footer></div>').appendTo('body');
	

    $(openPopup('popup-confirm-form1'));

    $('#OKCS1').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OKCS1') {

            var F = document.getElementById(f);

           

            var lastActId = GetAllValues(F.elements["lastActId"]);
            var actId = GetAllValues(F.elements["ActId"]);
            var lastChangesName = GetAllValues(F.elements["pName"]);
            var strConfirmC1 = "";
            var strConfirmEn1 = "";

          if (lastActId != actId) {

              var strConfirm1 = 'Внимание!' + '</br>'
           + 'Вие извършвате промяна по име на сметка, което е зададено от потребител <b>' + lastChangesName + '</b>.</br>'
           + 'Сигурни ли сте, че желаете да продължите?' + '</br>'
		   + 'Attention!' + '</br>'
           + 'You are changing the account name that is set by user <b>' + lastChangesName + '</b>.</br>'
           + 'Are you sure you want to continue?';

           var strConfirmEnC1 = '';

           ConfirmContractNotSignReAccName(f, submitform, strConfirm1, strConfirmC1, strConfirmEn1, strConfirmEnC1, idAjaxResult, '');

         }
         else
         {
              ConfirmStoreAndNotSignRe(f, submitform, idAjaxResult, amountConf);
              $(this).prop('disabled', true);
              $("a[class='b-close']").click();
         }
       
            
        }

    });

    $("a[class='b-close']").click();
}
//11055 end

function ConfirmStoreAndNotSignRe(f, submitform, idAjaxResult, amountConf) {
    if ($('#id-popup-confirm-store-form').length > 0) {
        $("#id-popup-confirm-store-form").remove();
    }
    if (f == 'frmEditAcc') {
        $("a[class='b-close']").click(); //!!!z-index 9045i
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Наистина ли желаете да направите промяната? <br/>Are you sure you want to change the payment mode?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else if (f == 'ActSubscriptions') {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Наистина ли желаете да промените статуса на битово плащане?<br/>Are you sure you want to change the utility payment status?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else if (amountConf != '') {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Изберете ОК за изпращане към Банката на документ за сумата от ' + amountConf + ' <br/>Chose OK to send to the Bank a document for the amount of ' + amountConf + '</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }
    else {
        $('<div id="id-popup-confirm-store-form" class="popup" data-popup="popup-confirm-store-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p>Изберете ОК за изпращане към Банката.<br/>Choose OK to send to the Bank.</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKST" id="OKST">Потвърди / OK</a></footer></div>').appendTo('body');
    }

    $(openPopupZ('popup-confirm-store-form', 5));// mega-menu
    $('#OKST').one('click', function (event) {
        event.preventDefault();
        if (this.id == 'OKST') {
            StoreAndNotSignToConf(f, submitform, idAjaxResult);

            $(this).prop('disabled', true);
            $("a[class='b-close']").click();
        }

    });
    $("a[class='b-close']").click();
}

function createCustomAlertInnerHTML(txt1, submitform) {//8975
    if ($('#ConfLast').length != 0) {
        $('#ConfLast').remove();
    }
    $("<div></div>").attr('id', 'ConfLast').attr('class', 'popup').attr('data-popup', 'popup-alert-form1').html("<header class='with-controls'><a  href='javascript:;' class='b-close'></a><h2>Трансакции чакащи осчетоводяване<br>Transactions pending for processing</h2><div class='extra-controls'><a href='javascript:;' title='print' class='icon-30 icon-print' onclick=\"iprintTD('ConfLast')\"></a></div></header><div class='popup-body'><div class='popup-text'><p>" + txt1 + "</p></div></div>").appendTo('body');//<footer><a title='Отказ' class='b-close btn btn-wide btn' href='javascript:;' data-action='cancel' id='cancel'>Cancel</a><a title='Потвърди' class='b-close btn btn-highlight-2 btn-wide' href='javascript:;' data-action='ok' id='ok'>OK</a></footer>
    $(openPopup('popup-alert-form1'));
    return true;
}

function ValidateDepActivity(idfrm) {
    var F = document.getElementById(idfrm);
    var txtErr = "";
    var fieldErr = "";

    if (F.elements["CURR"].value == "" || F.elements["CURR"].value == "0") {
        txtErr = "Моля, изберете валута!<br/>Please, choose currency!";
        fieldErr = F.elements["CURR"];
        elemError(fieldErr, txtErr);

        return false;
    }
    if (!F.elements["send"].checked) {
        txtErr = "Моля, потвърдете декларациите.<br/>Please, confirm declarations.";
        fieldErr = F.elements["send"];
        elemErrorSend(fieldErr, txtErr);

        return false;
    }
    return true;
}

function removeError(idfrm) {
    if ($('.form-error', $('#' + idfrm)).length > 0) {
        $('.form-error', $('#' + idfrm)).remove();
        $('.has-error', $('#' + idfrm)).removeClass('has-error');
    }
}

function elemError(fieldErr, txtErr) {
    var elem = $(fieldErr);
    elem.parents('.field').append($('<span class="help-block form-error">' + txtErr + '</span>'));
    elem.parent().addClass('has-error');
    elem.focus();
}

function elemErrorNotF(fieldErr, txtErr) {
    var elem = $(fieldErr);
    elem.parents('.field').append($('<span class="help-block form-error">' + txtErr + '</span>'));
    elem.parent().addClass('has-error');
}

function elemErrorSend(fieldErr, txtErr) {
    var elem = $(fieldErr);
    elem.parent().append($('<span class="help-block form-error">' + txtErr + '</span>'));
    elem.parent().addClass('has-error');
    elem.focus();
}

function elemErrorDate(fieldErr, txtErr, pClass, cClass) {
    var elem = $(fieldErr);
    elem.parent().parent().append($('<span class="help-block form-error">' + txtErr + '</span>'));
    elem.parent().addClass('has-error');
}

function elemErrorR(fieldErr, txtErr) {
    var elem = $(fieldErr);
    elem.parents('.field-custom-check-radio').append($('<span class="help-block form-error">' + txtErr + '</span>'));
    elem.parent().addClass('has-error');
    elem.focus();
}

function ValidateDECL30K(val, idfrm) {
    removeError(idfrm);
    $(val).val(function () {
        return this.value.toUpperCase();
    })

}

function ValidateDepAvailableOpen(idfrm) {
    var F = document.getElementById(idfrm);
    var txtErr = "";
    var fieldErr = "";
    if (F.elements["ACC_TYPE"].value == "" || F.elements["ACC_TYPE"].value == "0") {
        txtErr = "Моля, изберете вид депозит!<br/>Please, choose term deposit type!";
        fieldErr = F.elements["ACC_TYPE"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "" || F.elements["CURR"].value == "-1" || F.elements["sACC_S"].value == "" || F.elements["sACC_S"].value == "0") {
        txtErr = "Моля, изберете сметка!<br/>Please, choose account!";
        fieldErr = F.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if ((F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) < 3000) && F.elements["CURR"].value == "BGN") {//9326
        //txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        txtErr = "Минимална сума за откриване 3 000 BGN или 1500 EUR/USD<br/>Minimum opening amount is 3 000 BGN or 1500 EUR/USD";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if ((F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) < 1500) && F.elements["CURR"].value != "BGN") {//9326
        //txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        txtErr = "Минимална сума за откриване 3 000 BGN или 1500 EUR/USD<br/>Minimum opening amount is 3 000 BGN or 1500 EUR/USD";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if ((F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) > 199999.99) && F.elements["CURR"].value == "BGN") {//13052
        //txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        txtErr = "Максимална сума за откриване 199 999.99 BGN<br/>Maximum opening amount is 199 999.99 BGN";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if ((F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) > 99999.99) && F.elements["CURR"].value != "BGN") {//13052
        //txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        txtErr = "Максимална сума за откриване 99 999.99 EUR/USD<br/>Maximum opening amount is 99 999.99 EUR/USD";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["ACC_I"].value == "" || F.elements["CURR_I"].value == "" || F.elements["sACC_I"].value == "") {
        txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }

    if (parseFloat(F.elements["AMOUNT"].value) >= 30000) {
        var frmDECL30 = F.elements["DECL30K"].value;

        if (trim(frmDECL30).length < 5) {
            fieldErr = F.elements["DECL30K"];
            txtErr = "Моля, попълнете декларацията по чл.66, ал.2 от ЗМИП, чл.47, ал.1 от ППЗМИП!<br/>Please, fill in the DECLARATION under Art.66, para 2 on the Law of the Measures against Money laundering  (LMML) and art.47, Para 1 of the Regulations for the Application  of LMML!";
            elemError(fieldErr, txtErr);
            return false;
        }
        else {
            var re = /^[ A-ZА-Яa-zа-я0-9 /\.;=@%\-_*\\\(\)\|\+]+$/;
            var test1 = re.test(frmDECL30);

            if (!test1) {
                fieldErr = F.elements["DECL30K"];
                txtErr = "Недопустим символ в поле 'ДЕКЛАРАЦИЯ за произход на паричните средства'!<br/>Incorrect symbol in field 'DECLARATION for money origin according'!";
                elemError(fieldErr, txtErr);
                return false;
            }
        }
    }

    if (!F.elements["send"].checked) {
        txtErr = "Моля, потвърдете декларациите.<br/>Please, confirm declarations.";
        fieldErr = F.elements["send"];
        elemErrorSend(fieldErr, txtErr);

        return false;
    }
    return true;
}

function ValidateRepayCCard(idfrm) {

    var txtErr = "";
    var fieldErr = "";
    var F = document.getElementById(idfrm);

    if (F.elements["INST_PERIOD"].value == "0") {
        txtErr = "Моля, изберете брой вноски!<br/>Please select number of installments!";
        fieldErr = F.elements["INST_PERIOD"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["INT_RATE"].value == "" || F.elements["TOLLAGE"].value == "" || F.elements["MONTHLY_PAYMENT"].value == "") {
        txtErr = "Моля, изберете брой вноски!<br/>Please select number of installments!";
        fieldErr = F.elements["INST_PERIOD"];
        elemError(fieldErr, txtErr);
        return false;
    }

    return true;
}
//8365
function SetPAYR(idfrm, OrdName) {
    if (document.getElementById("PAYR1").value != "") {
        var PayR1 = document.getElementById("PAYR1").value.split("|");
        document.getElementById("PAY_R").value = PayR1[0];
    }

    //8365 - Vili
    if (OrdName == "IBAN313" || OrdName == "IBAN313.F" || OrdName == "IBAN313.P" || OrdName == "IBAN313.B") {//11201  //14802+
        if (document.getElementById("PAYS1").value != "") {
            var PayS1 = document.getElementById("PAYS1").value.split("|");
            document.getElementById("PAY_S").value = PayS1[0];
        }
        else {
            var accS = document.getElementById("ACC_S").value;
            if (accS.substring(12, 13) != 8) {
                document.getElementById("PAY_S").value = "";
            }
        }
        var typePay = $('#frmPAYMENT #PAY_S').val(); 
    }
}

function SetPAYData(idfrm) {

    if (document.getElementById("PAYR1").value != "") {
        var PayR1 = document.getElementById("PAYR1").value.split("|");
        document.getElementById("PAY_R").value = PayR1[0];
    }
    if (document.getElementById("PAYS1").value != "") {
        var PayR1 = document.getElementById("PAYS1").value.split("|");
        document.getElementById("PAY_S").value = PayR1[0];
    }
    if (document.getElementById("BICR1").value != "") {
        var PayR1 = document.getElementById("BICR1").value.split(" - ");
        document.getElementById("BIC_R").value = PayR1[0];
    }
}

function ValidateDebitCard(idfrm) {
    var F = document.getElementById(idfrm);
    var chosen = false;
    var txtErr = "";
    var fieldErr = "";

    if (F.elements["BR"].value == "0" || F.elements["BR"].value == "") {
        txtErr = "Моля, изберете банков клон за получаване на картата!<br/>Please, choose delivery branch!";
        fieldErr = F.elements["BR"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (typeof F.elements["radio"].length == 'undefined' && typeof F.elements["radio"] != 'undefined') {
        if (F.elements["radio-1"].checked) {
            chosen = true;
            F.elements["CARDT"].value = F.elements["radio-1"].value;
        }
    } else {
        for (i = 0; i < F.elements["radio"].length; i++) {
            if (F.elements["radio"][i].checked) {
                chosen = true;
                F.elements["CARDT"].value = F.elements["radio"][i].value;
            }
        }
    }

    if (chosen == false) {
        txtErr = "Моля, изберете вид карта!<br/>Please, choose card type!";
        fieldErr = F.elements["CARDT"];
        elemErrorR(fieldErr, txtErr);
        return false;
    }

    if (F.elements["valMNAME"].value == 'true') {
        if (trim(F.elements["MAIDEN_NAME"].value).length < 5) {
            txtErr = "Моля, въведете моминска фамилия на майката!<br/>Please, enter maiden name!";
            fieldErr = F.elements["MAIDEN_NAME"];
            elemError(fieldErr, txtErr);
            return false;
        }
        else {
            var re = /^[A-ZА-Я\-]+$/;
            var test1 = re.test(F.elements["MAIDEN_NAME"].value);

            if (!test1) {
                txtErr = "Недопустим символ в поле 'Моминска фамилия на майката'!<br/>Incorrect symbol in field 'Maiden name'!";
                fieldErr = F.elements["MAIDEN_NAME"];
                elemError(fieldErr, txtErr);
                return false;
            }
        }
    }

    return true;
}

//използва се за ордер BALANCE
function PrepOrder1(idfrm, OrdName, OrdTitle, OrdInfo, obj, event) {

    hint = OrdInfo;
    lhint = OrdTitle;
    var frm = document.getElementById(idfrm);

    var strACC = frm.elements["ACCOUNT"].value;
    if ("" == strACC) return false;
    document.getElementById("idMBASE64XML").value = "";
    idAJAXResult = "popup_wndB_c";

    document.getElementById("COMMAND").value = "EXEC";
    document.getElementById("ORDNAME").value = OrdName;

    var btn = $(event.target);
    var parent;
    var lng = $("#frmMain input[name=lng]").val();

    $('a.has-loading').each(function () {
        $(this).html($(this).data('obj'));
        $(this).removeClass('has-loading');
    });

    parent = btn.parent();
    parent.data('obj', btn.parent().html());
    parent.addClass('has-loading');
    if (lng == 'EN') {
        parent.html('loading...');
    }
    else {
        parent.html('зареждане...');
    }
    var sbody = ObtainBody(idfrm);

    GetWindowRe("popup_wndB", OrdTitle + "  " + strACC, "", 0, 0, 0, 0);
    SendPostRequestAc("t.aspx", sbody, function () {

        openPopup("data_popup_wndB");
        parent.html(parent.data('obj'));


    });
}

function PrepOrderRATES(OrdName, OrdTitle, OrdInfo, obj, event) {

    idAJAXResult = "popup_wnd2_c";
    document.getElementById("idMCOMMAND").value = "EXEC";
    document.getElementById("idMORDNAME").value = OrdName;

    GetWindowRe("popup_wnd2", OrdTitle, "", 0, 0, 0, 0);

    var sbody = ObtainBody("frmMain");
    SendPostRequest("t.aspx", sbody);
}


function PrepOrderHome(OrdName, OrdTitle, OrdInfo, TypeAccDep, AP) {
    hint = OrdInfo;
    lhint = OrdTitle;
    document.getElementById("idMCOMMAND").value = "EXEC";
    document.getElementById("idMORDNAME").value = OrdName;
    document.getElementById("CRDAP").value = AP;


    if (OrdName == "STMTCARDS") {
        var strXML = "<Order><CRDAP>" + AP + "</CRDAP></Order>";
        var sbody = ObtainBody("frmMain");
        idAJAXResult = "idFullScreen_c";
        showBigScreen("idFullScreen", OrdTitle);
        SendPostRequest("t.aspx", sbody);
        document.getElementById("idFullScreen_c").innerHTML = strWait;
    }
    else {
        document.getElementById("TYPEACCDEP").value = TypeAccDep;
        var strXML = "<Order><TYPEACCDEP>" + TypeAccDep + "</TYPEACCDEP><CRDAP>" + AP + "</CRDAP></Order>";
        var sbody = ObtainBody("frmMain");
        idAJAXResult = "Panel1_c";
        document.getElementById("Panel1_c").innerHTML = strWait;
        document.getElementById("Panel1_t").innerHTML = OrdTitle;
        SendPostRequest("t.aspx", sbody);
        ShowPanel("Panel1", "Panel0");
    }
}

function PrepOrderHomeRe(OrdName, OrdTitle, OrdInfo, TypeAccDep, AP) {
    //hint = OrdInfo;
    //lhint = OrdTitle;
    document.getElementById("idMCOMMAND").value = "EXEC";
    document.getElementById("idMORDNAME").value = OrdName;
    document.getElementById("CRDAP").value = AP;

    setTimeout(function () {
        if (OrdName == "STMTCARDS") {
            var strXML = "<Order><CRDAP>" + AP + "</CRDAP></Order>";
            var sbody = ObtainBody("frmMain");
            idAJAXResult = "Panel1";
            SendPostRequest("t.aspx", sbody);
            ShowPanel("Panel1", "Panel0");
            document.getElementById("Panel1").innerHTML = strWait;
        }
        else {

            document.getElementById("TYPEACCDEP").value = TypeAccDep;
            var strXML = "<Order><TYPEACCDEP>" + TypeAccDep + "</TYPEACCDEP><CRDAP>" + AP + "</CRDAP></Order>";
            var sbody = ObtainBody("frmMain");
            idAJAXResult = "Panel1";
            document.getElementById("Panel1").innerHTML = strWait;
            SendPostRequest("t.aspx", sbody);
            ShowPanel("Panel1", "Panel0");

        }
    }, 250);
}

function setGetCardRE(idForm, CardNum, Status, panId) {//9215 , Task 15062-2023, added 'frmModifyKong' instead of 'frmModifyDM'

    var F = document.getElementById(idForm);
    var card = trim(CardNum);
    var cardN = card.substring(0, card.indexOf("|"));

    if (idForm == 'frmGetCard') {

        if ($('#id-popup-confirm-form').length > 0) {
            $("#id-popup-confirm-form").remove();
        }

        if (Status == "AC") {
            F.elements["CARD.NO"].value = card;
            F.elements["Status"].value = "TC";
            $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Сигурни ли сте, че искате да блокирате карта   ' + cardN + ' ?<br/>Are you sure you want to block card   ' + cardN + ' ?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKBA" id="OKBA">Потвърди / OK</a></footer></div>').appendTo('body');
        }
        else {
            F.elements["CARD.NO"].value = card;
            F.elements["Status"].value = "AC";
            $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Сигурни ли сте, че искате да активирате карта  ' + cardN + ' ?<br/>Are you sure you want to activate card  ' + cardN + ' ?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKBA" id="OKBA">Потвърди / OK</a></footer></div>').appendTo('body');
        }

        $(openPopup('popup-confirm-form'));
        $('#OKBA').one('click', function (event) {
            event.preventDefault();
            if (this.id == 'OKBA') {
                ConfirmStoreAndNotSignRe('frmGetCard', 'frmSubmit', 'Panel1', '');
                $(this).prop('disabled', true);
                $("a[class='b-close']").click();
            }

        });

        $("a[class='b-close']").click();
    }

    if (idForm == 'frmModifyKong') {  //Task 15062-2023
        var card = trim(CardNum);
        var cardNXN = trim(CardNum);

        if ($('#id-popup-confirm-form').length > 0) {
            $("#id-popup-confirm-form").remove();
        }
        F.elements["cards"].value = "usw/" + panId + "/block";  //usw/BG138247961/block
        F.elements["customers"].value = F.elements["GLOBUSID"].value;
        F.elements["CARD.NO"].value = card;
        if (Status == "AC") {
            F.elements["cdStatus"].value = "TC";
            $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Сигурни ли сте, че искате да блокирате карта   ' + cardNXN + ' ?<br/>Are you sure you want to block card   ' + cardNXN + ' ?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKBA" id="OKBA">Потвърди / OK</a></footer></div>').appendTo('body');
        }
        else {
            F.elements["cdStatus"].value = "AC";
            $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Сигурни ли сте, че искате да активирате карта  ' + cardNXN + ' ?<br/>Are you sure you want to activate card  ' + cardNXN + ' ?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKBA" id="OKBA">Потвърди / OK</a></footer></div>').appendTo('body');
        }

        $(openPopup('popup-confirm-form'));
        $('#OKBA').one('click', function (event) {
            event.preventDefault();
            if (this.id == 'OKBA') {
                ConfirmStoreAndNotSignRe('frmModifyKong', 'frmSubmit', 'Panel1', '');
                $(this).prop('disabled', true);
                $("a[class='b-close']").click();
            }
        });

        $("a[class='b-close']").click();
    }


    //if (idForm == 'frmModifyDM') {//9215
    //    var card = trim(CardNum);
    //    var cardN = card.substring(0, card.indexOf("*"));
    //    var cardNN = card.substring(card.length - 3, card.length);
    //    var cardX = cardN.concat('XXXXXXX');
    //    var cardNXN = cardX.concat(cardNN);

    //    if ($('#id-popup-confirm-form').length > 0) {
    //        $("#id-popup-confirm-form").remove();
    //    }

    //    if (Status == "AC") {
    //        F.elements["v_pan_id"].value = panId;
    //        F.elements["BLKreason"].value = "BR-11";
    //        F.elements["mt"].value = "rq-26";
    //        $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Сигурни ли сте, че искате да блокирате карта   ' + cardNXN + ' ?<br/>Are you sure you want to block card   ' + cardNXN + ' ?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKBA" id="OKBA">Потвърди / OK</a></footer></div>').appendTo('body');
    //    }
    //    else {
    //        F.elements["v_pan_id"].value = panId;
    //        F.elements["BLKreason"].value = "BR-11";//добавено е само, за да мине джава скрипт функцията MakeXMLif, да не е празно, реално не се подава
    //        F.elements["mt"].value = "rq-27";
    //        $('<div id="id-popup-confirm-form" class="popup" data-popup="popup-confirm-form"><header><a href="javascript:;" class="b-close"></a><h2>Потвърждение / Confirm</h2></header><div class="popup-body"><div class="popup-text"><p> Сигурни ли сте, че искате да активирате карта  ' + cardNXN + ' ?<br/>Are you sure you want to activate card  ' + cardNXN + ' ?</p></div></div><footer><a title="Отказ" class="b-close btn btn-wide btn" href="javascript:;" data-action="cancel" id="cancel">Отказ / Cancel</a><a title="Потвърди" class="b-close btn btn-highlight-2 btn-wide" href="javascript:;" data-action="OKBA" id="OKBA">Потвърди / OK</a></footer></div>').appendTo('body');
    //    }

    //    $(openPopup('popup-confirm-form'));
    //    $('#OKBA').one('click', function (event) {
    //        event.preventDefault();
    //        if (this.id == 'OKBA') {
    //            ConfirmStoreAndNotSignRe('frmModifyDM', 'frmSubmit', 'Panel1', '');
    //            $(this).prop('disabled', true);
    //            $("a[class='b-close']").click();
    //        }

    //    });

    //    $("a[class='b-close']").click();
    //}

}

function getRadioValue77(idFrm, radioName, A1, V2) {
    var ret1;
    var val1;
    var Elem = document.getElementById(idFrm).elements[radioName];
    if (Elem != null) {
        var count = Elem.length;
        if (typeof (count) == typeof (2)) {
            for (var i = 0; i < count; i++) {
                if (Elem[i] != null && Elem[i].value != "" && Elem[i].value != "undefined")
                    if (Elem[i].checked) {
                        ret1 = Elem[i].value;
                        val1 = Elem[i].nextSibling.value;

                        document.getElementById(idFrm).elements[A1].value = ret1;
                        document.getElementById(idFrm).elements[V2].value = val1;
                    }
            }
        }
    }

}

function makeCheck1(idFrm, row, radio, A1, V2) {
    document.getElementById(radio).checked = true;
    if (current != "") {
        document.getElementById(current).style.background = "#f5f7f9";
    }
    document.getElementById(row).style.background = "#bbc8e4";
    current = row;
    document.getElementById(idFrm).elements[A1].value = document.getElementById(idFrm).elements[radio].value;
    document.getElementById(idFrm).elements[V2].value = document.getElementById(idFrm).elements[radio].nextSibling.value;
}

function formDealRef(vDEALREFi, idFrmMain, idFrmSub, idDiv) {
    var enddt = new Date();
    var startdt = new Date(enddt.getFullYear(), 0, 0); //yyyy,mm,dd
    var diff = enddt - startdt;
    var oneDay = 1000 * 60 * 60 * 24;                   //milliseconds in 1 day
    var julday = Math.floor(diff / oneDay);
    var yy = enddt.getFullYear().toString().substr(2, 2);

    var strJulday = "00" + julday;
    strJulday = strJulday.substr(strJulday.length - 3);

    document.getElementById(idFrmMain).elements["DEALREF"].value = "FX" + yy + (strJulday) + vDEALREFi;
    document.getElementById(idFrmSub).elements["FX_ID"].value = "FX" + yy + (strJulday) + vDEALREFi;

    GetIbanSal(idFrmSub, idFrmSub, idDiv);
}

function clearDealRef(idFrmMain, idFrmSub, idDiv) {

    if (document.getElementById(idFrmMain).elements["DEALREF"]) {
        document.getElementById(idFrmMain).elements["DEALREF"].value = "";
    }
    if (document.getElementById(idFrmSub).elements["FX_ID"]) {
        document.getElementById(idFrmSub).elements["FX_ID"].value = "";
    }

    var node = document.getElementById(idDiv);
    while (node.hasChildNodes()) {
        node.removeChild(node.firstChild);
    }

}


function ValidateFXExchange(idForm) {
    var F = document.getElementById(idForm);
    var check = false;
    var currPairs = "";
    var accPairs = "";
    var acc = "";
    var curr = "";

    var fxAcc1 = $('select[name=FXACC1]').map(function () {
        return { selVal: this.value };
    }).get();
    var fxAcc2 = $('select[name=FXACC2]').map(function () {
        return { selVal: this.value };
    }).get();

    var fxCurr1 = $('input[name=FXCURR1]').map(function () {
        return { selVal: this.value };
    }).get();

    var fxCurr2 = $('input[name=FXCURR2]').map(function () {
        return { selVal: this.value };
    }).get();

    var fxSendD = $('input[name=FXsendD]').map(function () {
        return { check: this.checked };
    }).get();

    for (i = 0; i < fxSendD.length; i++) {
        if (fxSendD[i].check) {
            check = true;

            if (acc == "") {
                acc = fxAcc1[i].selVal;
                curr = fxCurr1[i].selVal;
            }

            if (fxAcc1[i].selVal && fxAcc2[i].selVal) {

                currPairs += fxCurr1[i].selVal + "_" + fxCurr2[i].selVal + "|";
                accPairs += fxAcc1[i].selVal + "_" + fxAcc2[i].selVal + "|";
            }
            else {
                createCustomAlertDeclaration("Моля да изберете сметки за избраните валутни двойки!<br/>Please choose accounts for the chosen currency pairs!");
                return false;
            }
        }
    }

    if (!check) {
        createCustomAlertDeclaration("Моля изберете поне една от възможните валутни двойки!<br/>Please check at least one of the possible currency pairs!");
        return false;
    }

    F.elements["CURRS"].value = currPairs;
    F.elements["ACCS"].value = accPairs;
    F.elements["ACC_S"].value = acc;
    F.elements["CURR_S"].value = curr;

    return true;
}


function LogInUT(Page) {
    var F = document.getElementById(Page);
    var ordName = F.elements["ORDNAME"].value;

    document.getElementById("idMCOMMAND").value = "EXECUT";
    document.getElementById("idMORDNAME").value = ordName;
    var sbody = ObtainBody("frmFXExchange");
    idAJAXResult = "Panel1";
    breadcrumbs();
    document.getElementById("Panel1").innerHTML = strWait;
    SendPostRequest("t.aspx", sbody);
    ShowPanel("Panel1", "Panel0");

}

var uTradeLink;
function openUT(link) {
    try {
        uTradeLink = link;
        var receiver = window.open("https://ebb.ubb.bg/WebTradeClient/index.html", 'wnd', 'title=no,scrollbars=yes,location=no,directories=no,status=no,menubar=no,resizable=yes,toolbar=no');
        if (receiver == null)
            createCustomAlertDeclaration("Моля изключете блокирането на „изкачащи“ прозорци. <br/><br/> Please torn off the pop-up blocker.");
    }
    catch (e) {
        createCustomAlertDeclaration(e + "<br/>" + e.description);
    }
}

//8883 begin
function clearRequest(idDiv) {
    var myNode = document.getElementById(idDiv);
    while (myNode.firstChild) {
        myNode.removeChild(myNode.firstChild);
    }

}

function ShowTypeRequest(idForm, category, idDiv) {
    clearRequest(idDiv); //clear request template
    $("input:radio[name='REQUEST']").prop("checked", false);  //uncheck radio button
}

function GetRequest(idReq, idfrm, idDiv) {
    clearRequest(idDiv);

    var F = document.getElementById(idfrm);
    F.elements["ORDNAME"].value = idReq;

    GetIbanSal(idfrm, idfrm, idDiv);
    return true;

}




function ValidateReqCTranDraw(idfrm) {
    var F = document.getElementById(idfrm);

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка!<br/>Please, choose account!";
        fieldErr = F.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) <= 0) {
        txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["CURR"].value == "" || F.elements["CURR"].value == "0") {
        txtErr = "Моля, изберете валута!<br/>Please, choose currency!";
        fieldErr = F.elements["CURR"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (!isDate(F.elements["FROMDATE"].value)) {
        txtErr = "Грешно посочена дата. Моля попълнете дд/мм/гггг!<br/>Wrong date. Please, use the dd/mm/yyyy format!";
        fieldErr = F.elements["FROMDATE"];
        elemErrorNotF(fieldErr, txtErr);
        return false;
    }
    if (F.elements["SERVICEBR"].value == "" || F.elements["SERVICEBR"].value == "0") {
        txtErr = "Моля, изберете клон!<br/>Please, choose branch!";
        fieldErr = F.elements["SERVICEBR"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["COMMENT"].value.length > 256) {
        txtErr = "Разрешените специални символи в текстовите полета са , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Максималната дължина е 256 символа.<br/>Allowed special  symbols for text fields:  , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Maximum character length: 256.";
        fieldErr = F.elements["COMMENT"];
        elemError(fieldErr, txtErr);
        return false;
    }

    return true;
}

function ValidateReqTranSwiftChg(idfrm) {
    var F = document.getElementById(idfrm);

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка!<br/>Please, choose account!";
        fieldErr = F.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["REF"].value == "FT") {
        txtErr = "Моля, въведете референция на банката!<br/>Please, fill out the bank reference!";
        fieldErr = F.elements["REF"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["REF"].value.length > 16 || F.elements["REF"].value.length < 5) {
        txtErr = "Моля, въведете коректна референция на банката!<br/>Please, fill out the correct bank reference!";
        fieldErr = F.elements["REF"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) <= 0) {
        txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["CURR"].value == "" || F.elements["CURR"].value == "0") {
        txtErr = "Моля, изберете валута!<br/>Please, choose currency!";
        fieldErr = F.elements["CURR"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (!isDate(F.elements["FROMDATE"].value)) {
        txtErr = "Грешно посочена дата. Моля попълнете дд/мм/гггг!<br/>Wrong date. Please, use the dd/mm/yyyy format!";
        fieldErr = F.elements["FROMDATE"];
        elemErrorNotF(fieldErr, txtErr);
        return false;
    }
    if (trim(F.elements["DETAIL"].value) == "") {
        txtErr = "Моля, попълнете полето за корекция/допълнение!<br/>Please, fill out the correction/addition field!";
        fieldErr = F.elements["DETAIL"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["DETAIL"].value.length > 256) {
        txtErr = "Разрешените специални символи в текстовите полета са , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Максималната дължина е 256 символа.\nAllowed special  symbols for text fields:  , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Maximum character length: 256.";
        fieldErr = F.elements["DETAIL"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["COMMENT"].value.length > 256) {
        txtErr = "Разрешените специални символи в текстовите полета са , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Максималната дължина е 256 символа.\nAllowed special  symbols for text fields:  , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Maximum character length: 256.";
        fieldErr = F.elements["COMMENT"];
        elemError(fieldErr, txtErr);
        return false;
    }

    return true;
}

function ValidateReqTranRefusal(idfrm) {
    var F = document.getElementById(idfrm);

    if (F.elements["ACC_S"].value == "" || F.elements["CURR_S"].value == "") {
        txtErr = "Моля, изберете сметка!<br/>Please, choose account!";
        fieldErr = F.elements["sACC_S"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["REF"].value == "FT") {
        txtErr = "Моля, въведете референция на банката!<br/>Please, fill out the bank reference!";
        fieldErr = F.elements["REF"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["REF"].value.length > 16 || F.elements["REF"].value.length < 5) {
        txtErr = "Моля, въведете коректна референция на банката!<br/>Please, fill out the correct bank reference!";
        fieldErr = F.elements["REF"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["DATE"].value != F.elements["REF"].value.substr(2, 5)) {
        txtErr = "Искане за отказ на нареден превод се приема само в работния ден, в който е извършен превода!<br/>Fund transfer cancellation requests are accepted only within the business day of their effecting!";
        fieldErr = F.elements["REF"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["AMOUNT"].value == "" || parseFloat(F.elements["AMOUNT"].value) <= 0) {
        txtErr = "Моля, въведете сума!<br/>Please, enter amount!";
        fieldErr = F.elements["AMOUNT"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["CURR"].value == "" || F.elements["CURR"].value == "0") {
        txtErr = "Моля, изберете валута!<br/>Please, choose currency!";
        fieldErr = F.elements["CURR"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (!isDate(F.elements["FROMDATE"].value)) {
        txtErr = "Грешно посочена дата. Моля попълнете дд/мм/гггг!<br/>Wrong date. Please, use the dd/mm/yyyy format!";
        fieldErr = F.elements["FROMDATE"];
        elemError(fieldErr, txtErr);
        return false;
    }
    if (F.elements["COMMENT"].value.length > 256) {
        txtErr = "Разрешените специални символи в текстовите полета са , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Максималната дължина е 256 символа.<br/>Allowed special  symbols for text fields:  , ' / . ; : = @ % - _ * \ ( ) | + ? ! . Maximum character length: 256.";
        fieldErr = F.elements["COMMENT"];
        elemError(fieldErr, txtErr);
        return false;
    }

    return true;
}

//8883 end

function Test_chkbox(idForm, idDiv) {
    var f = document.getElementById(idForm);
    var d = document.getElementById(idDiv);
    alert("idForm=" + idForm + ", idDiv=" + idDiv);

    alert("f=" + f + ", d=" + d);

    var x = document.getElementById("chk_box1").value;
    alert("x=" + x);

    var x1 = f.elements["chk_box1"].value;
    alert("x1=" + x1);

    var all = document.getElementsByTagName("div");
    alert("max=" + all.length);

    return;
}

function numberThousandFormat(num) {
    var n = num.toString(), p = n.indexOf('.');
    return n.replace(/\d(?=(?:\d{3})+(?:\.|$))/g, function ($0, i) {
        return p < 0 || i < p ? ($0 + ',') : $0;
    });
}

function CheckALLCBXbyId(cbx) {
    var check = false;
    var trcolor = "";
    try {
        if (document.getElementById(cbx + "0").checked) {
            check = true;
            trcolor = "#bbc8e4";
        }

        else {
            check = false;
            trcolor = "#f5f7f9";
        }

        for (i = 1; i < 10000; i++) {
            var ocbx = document.getElementById(cbx + i);
            if (null == ocbx)
                break;
            ocbx.checked = check;
            ocbx.parentNode.parentNode.style.background = trcolor;
        }
    }
    catch (e) {
        alert(e);
    }
}

function getBNSTAT(idForm, Nf, BN, Scr, t) {
    var F = document.getElementById(Nf).value;
    try {
        if (document.getElementById(Nf).value == "ALL") {
            F = "ALL";
        }
        if (document.getElementById(Nf).value == "PROCESSED") {
            F = "PROCESSED";
        }
        if (document.getElementById(Nf).value == "UNPROCESSED") {
            F = "UNPROCESSED";
        }
        document.getElementById(BN).value = F;
        ExecOrder('frmORDER', Scr, t);
    }
    catch (e) {
        alert(e);
    }
}

function CheckALLCBXbyIdRe(cbx) {
    var check = false;
    var trcolor = "";
    var cnt = document.getElementsByName("BillInfProc")[0].rows.length;
    try {
        if (document.getElementById(cbx + "0").checked) {
            check = true;
            trcolor = "#bbc8e4";
        }
        else {
            check = false;
            trcolor = "#f5f7f9";
        }

        for (i = 1; i < cnt + 1; i++) {
            var ocbx = document.getElementById(cbx + i);
            if (null == ocbx)
                break;
            ocbx.checked = check;
            ocbx.parentNode.parentNode.style.background = trcolor;
        }
    }
    catch (e) {
        alert(e);
    }
}

function CheckDPassLenS(frmName, fldPass) {
    var strPass = document.getElementById(fldPass).value;
    var blnRet = false;

    if (strPass == "") {
        blnRet = false;
    }
    if (strPass.length != 6) {
        blnRet = false;
    }

    if (strPass.length == 6) {
        blnRet = true;
        for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри и латински булви
            if ((strPass.charCodeAt(k) >= 48 && strPass.charCodeAt(k) <= 57) || (strPass.charCodeAt(k) >= 65 && strPass.charCodeAt(k) <= 90) || (strPass.charCodeAt(k) >= 97 && strPass.charCodeAt(k) <= 122)) //ако не е цифра или шпация
            {
                var d = "";
            }
            else {
                blnRet = false;
            }
        }
    }
    if (!blnRet) {
        if (document.getElementById('IDTempPass')) {
            document.getElementById('IDTempPass').value = "";
        }
        if (document.getElementById('PASS.N.NEWPASS')) {
            document.getElementById('PASS.N.NEWPASS').value = "";
        }
        if (document.getElementById('PASS.N.NEWPASS1')) {
            document.getElementById('PASS.N.NEWPASS1').value = "";
        }
        alert("Моля, въведете коректен код за сигурност. \nPlease, enter correct verification code.");
    }
    return blnRet;
}


function EnterKeyC(e) {
    var key;

    if (window.event) {
        key = window.event.keyCode;     //IE
    }
    else {
        key = e.which;     //firefox
    }
    if ((key >= 48 && key <= 122) || key == 8) {
        return true;
    }
    else {
        return false;
    }
    return true;
}

function NewCertReqSMS(idfrm) {
    var frm = document.getElementById(idfrm);
    var fieldErr = "";
    var txtErr = "";

    fieldErr = frm.elements['EMAIL'];
    txtErr = "Моля, въведете валиден e-mail.\n Please, enter valid e-mail.";
    elemError(fieldErr, txtErr);
    return false;

}

function NewCertReqSMS2(idfrm) {
    var frm = document.getElementById(idfrm);
    var fieldErr = "";
    var txtErr = "";

    fieldErr = frm.elements['NAME_S'];
    txtErr = "Моля, въведете име на латиница.\n Please, enter name on roman alphabet.";
    elemError(fieldErr, txtErr);
    return false;

}

//9487
function CheckDPassLenHT(frmName, fldPass) {//9487
    var strPass = document.getElementById(fldPass).value;
    var blnRet = true;

	var len = 8;
	var fieldErr = "";
    var txtErr = "";
	
	fieldErr = document.getElementById(frmName).elements[fldPass];
    txtErr = "Моля, въведете 8-цифрения код.<br/>Please, enter the 8-digit code.";
	
	if(frmName == "frmActivateHT1")
	{
		len=11;
		txtErr = "Моля, въведете 11-цифрен код.<br/>Please, enter 11-digit code.";
		if(document.getElementById('sn').value == "")
		{
			blnRet =false;
			txtErr = "Моля, въведете серийния номер на устройството.<br/>Please, enter the device serial number.";
			fieldErr = document.getElementById(frmName).elements['sn'];
		}
		else if(document.getElementById('sn').value != document.getElementById('fizNumber').value)
		{
			blnRet =false;
			txtErr = "Въведеният сериен номер на устройство е грешен. Моля, въведете серийния номер от гърба на устройството без интервали и тирета.<br/>The serial number of the device you have entered is wrong. Please, enter the serial number from the reverse side of the device without spacing and dashes.";//9486
			fieldErr = document.getElementById(frmName).elements['sn'];
		}

	}

    if (strPass == "") {
        blnRet = false;
    }
    if (strPass.length < len) {
        blnRet = false;
    }

    if (strPass.length == len) {
        for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри
            if ((strPass.charCodeAt(k) < 48 || strPass.charCodeAt(k) > 57)) //ако не е цифра или шпация
                blnRet = false;
        }
    }
    if (!blnRet) {
        elemError(fieldErr, txtErr);
    }
    else {
        removeError(frmName);
    }
	

    return blnRet;
}

//9486
function CheckDPassLenHTSMS(frmName, fldPass) {
    var F = document.getElementById(frmName);
    var strPass = document.getElementById(fldPass).value;
    var blnRet = true;

    var len = 8;
    var fieldErr = "";
    var txtErr = "";

    fieldErr = document.getElementById(frmName).elements[fldPass];
    txtErr = "Моля, въведете 8-цифрения код.<br/>Please, enter the 8-digit code.";

    if (frmName == "frmActivateHT1") {
        len = 11;
        txtErr = "Моля, въведете 11-цифрен код.<br/>Please, enter 11-digit code.";
        if (F.elements["SN"].value == "") {
            blnRet = false;
            txtErr = "Моля, въведете серийния номер на устройството.<br/>Please, enter the device serial number.";
            fieldErr = F.elements["SN"];
        }
    }

    if (strPass == "" || strPass.length < len) {
        blnRet = false;
    }

    if (strPass.length == len) {
        //blnRet = true;
        for (var k = 0; k < strPass.length; k++) { //трябва да съдържа само цифри
            if ((strPass.charCodeAt(k) < 48 || strPass.charCodeAt(k) > 57)) //ако не е цифра или шпация
                blnRet = false;
        }
    }
    if (!blnRet) {
        elemError(fieldErr, txtErr);
    }
    else {
        removeError(frmName);
    }

    return blnRet;
}
//e-notification begin 10634
function validFormENotification(f, f1, isCardTbl) {
    // removeError(f);

    if ($("div[id^='IdErr']").length > 0) { //8954
        $("div[id^='IdErr']").remove();
    }

    var frm = document.getElementById(f);

    var errMess = "";
    var cntCanalForNot = 0;
    var cntEvent = 0;
    var cntForChange = 0;

    if (isCardTbl == 0) {
        if (frm.elements["hidCanalForNot"].value == "") {
            createCustomAlertDeclaration("Моля изберете канал за известия.<br/>Please, select an Event.");
            return false;
        }
        if (frm.elements["hidEvent"].value == "" && frm.elements["hidCanalForNot"].value != 0) {
            createCustomAlertDeclaration("Моля изберете събитие.<br/>Please, select an Event.");
            return false;
        }

    }
    if (isCardTbl == 1) {
        if (frm.elements["hidCanalForNot"].value == "") {
            createCustomAlertDeclaration("Моля изберете канал за известия.");
            return false;
        }
    }

    if (isCardTbl == 3) {
        if (document.all.EMAIL_ADDR.value != "" && IsValidEmail(document.all.EMAIL_ADDR.value)) {
            document.all.EMAIL.value = document.all.EMAIL_ADDR.value;
        }
        else {
            if (document.all.EMAIL_EBANK.value != "" && IsValidEmail(document.all.EMAIL_EBANK.value)) {
                document.all.EMAIL.value = document.all.EMAIL_EBANK.value;
            }

            else {
                document.all.EMAIL.value = "";
            }
        }


        var accENotTable = document.all.listAccountsENot;

        for (var i = 1; i < accENotTable.rows.length; i++) { //сметки

            if (accENotTable.rows[i].cells.length > 1) {
                if (accENotTable.rows[i].cells[2].getElementsByTagName("a")[0].style.display == "none") {
                    cntForChange++;
                    if (typeof (frm.elements["selTypeEvent"][i - 1].selectedIndex) == "undefined" && frm.elements["selTypeEvent"].selectedIndex == "0" && frm.elements["selTypeNotification"].selectedIndex != "0") {
                        createCustomAlertDeclaration("Моля, изберете събитие на ред " + i + ".<br/>Please, select an Event on line " + i + ".");
                        return false;
                    }
                    else if (frm.elements["selTypeEvent"][i - 1].selectedIndex == "0" && frm.elements["selTypeNotification"][i - 1].selectedIndex != "0") {
                        createCustomAlertDeclaration("Моля, изберете събитие на ред " + i + ".<br/>Please, select an Event on line " + i + ".");
                        return false;
                    }
                }
            }
        }

        var cardENotTable = document.all.listCardsENot;
        var frm1 = document.getElementById(f1);
        for (var i = 1; i < cardENotTable.rows.length; i++) { //карти
            if (cardENotTable.rows[i].cells.length > 1) {
                if (cardENotTable.rows[i].cells[4].getElementsByTagName("a")[0].style.display == "none") {
                    cntForChange++;
                }
            }
            /*15174-2023: var e = cardENotTable.rows[i].cells[8].getElementsByTagName("select")[0];*/ //12765 безплатни смс
            var sv = cardENotTable.rows[i].cells[5].getElementsByTagName("select")[0];
            //15174-2023: if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "ДА" && e.options[e.selectedIndex].text == "ДА" && sv.options[sv.selectedIndex].text == "Без известяване") {
            if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "ДА" && sv.options[sv.selectedIndex].text == "Без известяване") {
                createCustomAlertDeclaration("За да разрешите изпращането на безплатни SMS е необходимо да промените начина на известяване към SMS или Viber.");
                return false;
            }
            //15174-2023: if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "YES" && e.options[e.selectedIndex].text == "YES" && sv.options[sv.selectedIndex].text == "Without notification") {
            if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "YES" && sv.options[sv.selectedIndex].text == "Without notification") {
                createCustomAlertDeclaration("In order to allow sending free SMS messages you need to change the notification channel to SMS or Viber.");
                return false;
            } //12765 end
            //Task 12765 - 2021, 13264-2021 corrections begin   
            if (cardENotTable.rows[i].cells[4].getElementsByTagName("a")[0].style.display == "none") {
                //15174-2023: if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "ДА" && e.options[e.selectedIndex].text == "НЕ" && sv.options[sv.selectedIndex].text == "Без известяване") {
                if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "ДА" && sv.options[sv.selectedIndex].text == "Без известяване") {
                    createCustomAlertDeclaration("За карти с активирани PUSH нотификации може да направите промяна към SMS или Viber известяване. Деактивиране на PUSH е възможно само през приложението ОББ Мобайл.");
                    return false;
                }
                //15174-2023:if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "YES" && e.options[e.selectedIndex].text == "NO" && sv.options[sv.selectedIndex].text == "Without notification") {
                if (cardENotTable.rows[i].cells[7].firstElementChild.defaultValue == "YES" && sv.options[sv.selectedIndex].text == "Without notification") {
                    createCustomAlertDeclaration("For cards with activated PUSH you can make a change to SMS or Viber notification. Deactivation of PUSH is possible only through UBB Mobile.");
                    return false;
                }
            }  //13264-2021 if...
            //Task 12765 - 2021, corr end
        }
        if (document.all.eNotPaymAcc.selectedIndex == "0" && (document.all.chbSMS.checked == true || document.all.chbViber.checked == true)) {
            createCustomAlertDeclaration("Моля, изберете сметка за таксуване.<br/>Please, select an account to be charged.");
            return false;
        }
        if (document.all.selSMS.selectedIndex == "0" && document.all.chbSMS.checked == true) {
            createCustomAlertDeclaration("Моля, изберете пакет за SMS.<br/>Please, select an SMS Notifications package.");
            return false;
        }
        if (document.all.selViber.selectedIndex == "0" && document.all.chbViber.checked == true) {
            createCustomAlertDeclaration("Моля, изберете пакет за Viber.<br/>Please, select an Viber Notifications package.");
            return false;
        }
        if ((document.all.chbSMS.checked == true || document.all.chbViber.checked == true) && document.all.MOBILE.value == "") {
            createCustomAlertDeclaration("Необходимо е да актуализирате номера на мобилния си телефон в клон на банката.<br/>You need to update your mobile phone number at a bank branch.");
            return false;
        }
        if (document.all.send.checked == false) {
            createCustomAlertDeclaration("Моля, потвърдете декларациите.<br/>Please, confirm the declaration statements.");
            return false;
        }


        if (cntForChange == 0) {
            createCustomAlertDeclaration("Няма промяна");
            return false;
        }



    }

    return true;
}
function fillTableENot(fOut, fIn)
{
    var frmIn = document.getElementById(fIn);
	var frmOut = document.getElementById(fOut);
	
	if(fIn == 'frmNotAccount')
	{
		$('#'+ fIn +' select[name="selTypeNotification"]').each(function() {
			if (!$(this).closest('td').hasClass("yellowRow")) {
			$(this).val(frmOut.elements["hidCanalForNot"].value).change();
			}
		});
		$('#'+ fIn +' select[name="selTypeEvent"]').each(function() {
			if (!$(this).closest('td').hasClass("yellowRow")) {
			$(this).val(frmOut.elements["hidEvent"].value).change();
			}
		});
		$('#'+ fIn +' input[name="inpMinAmount"]').each(function() {
			if (!$(this).closest('td').hasClass("yellowRow")) {
			$(this).val(frmOut.elements["inpMinSum"].value).change();
			}
		});
		$('#'+ fIn +' select[name="selMBalance"]').each(function() {
			if (!$(this).closest('td').hasClass("yellowRow")) {
			$(this).val(frmOut.elements["hidMonthBal"].value).change();
			}
		});
		$('#'+ fIn +' a[name="EditDescBtn"]').each(function() {
			if (!$(this).closest('td').hasClass("yellowRow")) {
			$(this).click();
			}
        });
	}
	else
	{
		$('#'+ fIn +' select[name="selTypeNotificationC"]').each(function() {
			$(this).val(frmOut.elements["hidCanalForNot"].value).change();
		});
		$('#'+ fIn +' input[name="inpMinAmountC"]').each(function() {
			if($(this).val(frmOut.elements["hidCanalForNot"].value) == 0)
				$(this).val('').change();
			else
				$(this).val(frmOut.elements["inpMinSum"].value).change();
        });
        //Task 15174 - 2023: remove column
		//$('#'+ fIn +' select[name="selFreeSmsC"]').each(function() {
		//	if($(this).val(frmOut.elements["hidCanalForNot"].value) == 0)
		//		$(this).val(1).change();
		//	else
		//	$(this).val(frmOut.elements["hidFreeSMS"].value).change();
		//});
		$('#'+ fIn +' a[name="EditDescBtnC"]').each(function() {
			$(this).click();
        });
	}
	

      $("a[class='b-close']").click();
}

function SignENotification(f, fAc, submitform) {
	 var F = document.getElementById('frmPayNot');
	var strtempxml =  "";
	var accENotTable =document.all.listAccountsENot;
	var forInOut = 0;
	
            for (var i = 1; i < accENotTable.rows.length; i++) { //сметки
				if(accENotTable.rows[i].cells[2].getElementsByTagName("a")[0].style.display == "none")
				{
					if(accENotTable.rows[i].cells[4].getElementsByTagName("select")[0].selectedIndex == 3 && accENotTable.rows[i].cells[3].getElementsByTagName("select")[0].selectedIndex != 0)
				{
					F.elements["EVENT"].value = 'CREDIT';
					if (!EnterDataToTransferFormENot(accENotTable.rows[i], 'E.NOTIFICATIONS.ACC')) {
					}
					else {
						strtempxml += MakeXML('frmPayNot');
					}
				
					F.elements["EVENT"].value = 'DEBIT';
					if (!EnterDataToTransferFormENot(accENotTable.rows[i], 'E.NOTIFICATIONS.ACC')) {
					}
					else {
						strtempxml += MakeXML('frmPayNot');
					}	
				}
				//if(accENotTable.rows[i].cells[6].getElementsByTagName("select")[0].selectedIndex == 1  && accENotTable.rows[i].cells[3].getElementsByTagName("select")[0].selectedIndex != 0)
                if (accENotTable.rows[i].cells[7].getElementsByTagName("select")[0].selectedIndex == 1 && accENotTable.rows[i].cells[3].getElementsByTagName("select")[0].selectedIndex != 0)   //14532-2023
                {
					F.elements["EVENT"].value = 'MONTHLY';
					if (!EnterDataToTransferFormENot(accENotTable.rows[i], 'E.NOTIFICATIONS.ACC')) {
					}
					else {
						strtempxml += MakeXML('frmPayNot');
					}	
					F.elements["EVENT"].value = "";
					if(accENotTable.rows[i].cells[4].getElementsByTagName("select")[0].selectedIndex == 1 || accENotTable.rows[i].cells[4].getElementsByTagName("select")[0].selectedIndex == 2)
					{
						if (!EnterDataToTransferFormENot(accENotTable.rows[i], 'E.NOTIFICATIONS.ACC')) {
					}
					else {
						strtempxml += MakeXML('frmPayNot');
					}	
					}
							
                    }
                //IBAN	ВАЛУТА	ПРОМЯНА	ИЗВЕСТЯВАНЕ=cells[3]	СЪБИТИЕ=cells[4]	МИН. СУМА	PUSH=cells[6]	МЕСЕЧЕН БАЛ=cells[7]
				//if(accENotTable.rows[i].cells[4].getElementsByTagName("select")[0].selectedIndex != 3 && accENotTable.rows[i].cells[6].getElementsByTagName("select")[0].selectedIndex != 1)
                    if (accENotTable.rows[i].cells[4].getElementsByTagName("select")[0].selectedIndex != 3 && accENotTable.rows[i].cells[7].getElementsByTagName("select")[0].selectedIndex != 1) //14532-2023
                    {
				
					
					if (!EnterDataToTransferFormENot(accENotTable.rows[i], 'E.NOTIFICATIONS.ACC')) {
                }
                else {
                    strtempxml += MakeXML('frmPayNot');
				}
				F.elements["EVENT"].value = "";
				}
				}
			}
			
			 for (var i = 1; i < listCardsENot.rows.length; i++) {//карти
				if(listCardsENot.rows[i].cells.length > 1 && listCardsENot.rows[i].cells[4].getElementsByTagName("a")[0].style.display == "none")
				{
				
					if (!EnterDataToTransferFormENot(listCardsENot.rows[i], 'E.NOTIFICATIONS.CARD')) {
                }
                else {
                    strtempxml += MakeXML('frmPayNot');
				}
				}
			}
			
			//selViber
			if( document.getElementById('selSMS').selectedIndex != 0)
			{
				F.elements["PACKAGE"].value = document.getElementById('selSMS').value;
			if (!EnterDataToTransferFormENot(listCardsENot.rows[i], 'E.NOTIFICATIONS.PAYM')) {
                }
                else {
                    strtempxml += MakeXML('frmPayNot');
				}
			}
			if( document.getElementById('selViber').selectedIndex != 0)
			{
				F.elements["PACKAGE"].value = document.getElementById('selViber').value;
			if (!EnterDataToTransferFormENot(listCardsENot.rows[i], 'E.NOTIFICATIONS.PAYM')) {
                }
                else {
                    strtempxml += MakeXML('frmPayNot');
				}
			}
			
			
			var correctXMLStr = FormENotUnreg('frmPayNot', "") + strtempxml;
			
		  var errorXMLStr = FormENot('frmPayNot', ""); //form import order



        var submfrmImp = document.getElementById(submitform);
        submfrmImp.elements["COMMAND"].value = "ENOT";
        submfrmImp.elements["SEND"].value = "Off";
        //if (F.elements["send"].checked)
            submfrmImp.elements["SEND"].value = "on";

        xmltoSEND = "<Packet/>";
        ElemGuid = document.getElementById("idPacket");

        xmltoSEND = "<Packet id=\"" + ElemGuid.value.toUpperCase() + "\">" + correctXMLStr + "<SubPacket>" + errorXMLStr + "</SubPacket></Packet>";
        correctXMLStr = null;
        errorXMLStr = null;


        createCustomAlertDocumentCount("Изберете ОК за изпращане към банката.<br/>Choose OK to send to the Bank.", function () {

            try {
                SerialNumber = document.getElementById("idMSERIALNUMBER").value;
                xmltoSEND = CRLF(xmltoSEND);

                submfrmImp.elements["BASE64SIGN"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["BASE64XML"].value = base64Encode(xmltoSEND);
                submfrmImp.elements["ENCODING"].value = "Windows-1251";

                BASE64XMLtoSEND = null;
                xmltoSEND = null;


                breadcrumbs();

                idAJAXResult = "Panel1";
                document.getElementById("Panel1").innerHTML = strWait;

                sbody = ObtainBody1(submitform);
                SendPostRequest1("t.aspx", sbody);

                sbody = null;

            }
            catch (e) {
                createCustomAlertHeaderAndTxt("Възникна грешка / Error", e + " <br/> " + e.description);
            }

        });
    return true;
}

function EnterDataToTransferFormENot(accENotTableRow, ORDNAME) //ss, 
{
    try {

        var F = document.getElementById('frmPayNot');
		var eventStr ="";
		var channalStr ="";
		var isFree ="";
		
		 switch (ORDNAME) {
            case "E.NOTIFICATIONS.ACC":
		
      if(accENotTableRow.cells[4].getElementsByTagName("select")[0].selectedIndex == 1)
					eventStr = "CREDIT";
				else if(accENotTableRow.cells[4].getElementsByTagName("select")[0].selectedIndex == 2)
					eventStr = "DEBIT";
		switch(accENotTableRow.cells[3].getElementsByTagName("select")[0].selectedIndex)
		{
			case 1: channalStr ="SMS"; break;
			case 2: channalStr ="VIBER"; break;
			case 3: channalStr ="EMAIL"; break;
			        default: channalStr ="NO"; break;
		}

        F.elements["ORDNAME"].value = ORDNAME;// + free;
			if(F.elements["EVENT"].value == "" || channalStr == "NO")
				F.elements["EVENT"].value = (channalStr == "NO") ? "NO" : eventStr;
                F.elements["CONTRACT.REF"].value = accENotTableRow.cells[0].getElementsByTagName("input")[0].value;
				F.elements["IBAN"].value = accENotTableRow.cells[0].getElementsByTagName("input")[1].value;
				if(F.elements["EVENT"].value =="MONTHLY")
					F.elements["MINAMOUNT"].value = 0.00;
				else
					F.elements["MINAMOUNT"].value = (accENotTableRow.cells[5].getElementsByTagName("input")[0].value == "") ? 0 : accENotTableRow.cells[5].getElementsByTagName("input")[0].value;
                F.elements["CHANNEL"].value = channalStr;
				F.elements["id"].value = NextGuid(F.elements["id"].value);
				F.elements["REGID"].value =   accENotTableRow.cells[3].getElementsByTagName("input")[0].value;
				F.elements["CURRENCY"].value = accENotTableRow.cells[0].getElementsByTagName("input")[2].value;
				F.elements["AccCategory"].value = accENotTableRow.cells[0].getElementsByTagName("input")[3].value;
				if(F.elements["DeactAccs"].value.indexOf("," + accENotTableRow.cells[0].getElementsByTagName("input")[0].value) == -1)
					F.elements["DeactAccs"].value += "," + accENotTableRow.cells[0].getElementsByTagName("input")[0].value;
                break;
				
             case "E.NOTIFICATIONS.CARD":  //12765
				//  if(accENotTableRow.cells[8].getElementsByTagName("select")[0].selectedIndex == 0)
				//	isFree = "1";
				//else if(accENotTableRow.cells[8].getElementsByTagName("select")[0].selectedIndex == 1)
					isFree = "0";
				switch(accENotTableRow.cells[5].getElementsByTagName("select")[0].selectedIndex)
				{
					case 1: channalStr ="SMS"; break;
					case 2: channalStr ="VIBER"; break;
					case 3: channalStr ="EMAIL"; break;
			          default: channalStr ="NO"; break;
				}
				F.elements["ORDNAME"].value = ORDNAME;// + free;
				F.elements["MaskedCardNumber"].value = accENotTableRow.cells[0].getElementsByTagName("input")[0].value.replace(/\s/g, "");
				F.elements["AP"].value = accENotTableRow.cells[0].getElementsByTagName("input")[1].value;
				
                if (F.elements["AP"].value.substring(0, 2) == "AP") {
                     F.elements["CardNumber"].value = null;
                }
                else {
                     F.elements["CardNumber"].value = accENotTableRow.cells[0].getElementsByTagName("input")[2].value;  
                }
               
                F.elements["MINAMOUNT"].value = (accENotTableRow.cells[6].getElementsByTagName("input")[0].value == "") ? 0 : accENotTableRow.cells[6].getElementsByTagName("input")[0].value;
                F.elements["CHANNEL"].value = channalStr;
				F.elements["IsFree"].value = isFree;
				F.elements["id"].value = NextGuid(F.elements["id"].value);
                break;
				case "E.NOTIFICATIONS.PAYM":
			var currAndDao = document.getElementById('eNotPaymAcc').value.split("|");
				F.elements["ORDNAME"].value = ORDNAME;// + free;
				F.elements["IBANPaym"].value = currAndDao[0];
				F.elements["CURRENCYPaym"].value = currAndDao[1];
				F.elements["DAOPaym"].value = currAndDao[2];//.substr(0,3);
				F.elements["Acc15Paym"].value = currAndDao[3];
				if(F.elements["PACKAGE"].value == "")
					F.elements["PACKAGE"].value = "0";
				F.elements["id"].value = NextGuid(F.elements["id"].value);
                break;
				
            default:
                break;
		}
	
    }
    catch (e) {
        return false;
    }

    return true;
}

function FormENot(f, free) {
    var F = document.getElementById(f);

    F.elements["ORDNAME"].value = "E.NOTIFICATIONS.EXEC";
    F.elements["id"].value = NextGuid(F.elements["id"].value);

    return MakeXML(f);
}
function FormENotUnreg(f, free) {
    var F = document.getElementById(f);

    F.elements["ORDNAME"].value = "E.NOTIFICATIONS.UNREG";
	 F.elements["id"].value = NextGuid(F.elements["id"].value);

    return MakeXML(f);
}
//e-notification end 10634

//11055
function ChangeAccountName(f)
{
   
    var form = document.getElementById(f);
    var name = form.elements["NAME_ACC"].value.trim();
    var newName = form.elements["NEW_NAME_ACC"].value;

    if (form.elements["sACC_S"].value == "" ) {
        txtErr = "Моля, изберете сметка!<br/>Please, choose account!";
        fieldErr = document.getElementById("sACC_S");
        elemError(fieldErr, txtErr);
        return false;
    }


    if (newName.length <= 0) {

        txtErr = "Моля, въведете ново име на сметка." + "<br/>" + "Please, input new account name.";
        fieldErr = document.getElementById("NEW_NAME_ACC");
        elemError(fieldErr, txtErr);
        return false;
    }

  
    var re = /[ A-ZА-Я0-9 /\.;=%\-*\\\(\)\|\+]{1,35}/;
     var test1 = re.test(newName);
     if (!test1) {
         txtErr = "Недопустим символ в поле 'Ново име на сметка'!" + "<br/>" + "Incorrect symbol in field 'New account name'!";
         fieldErr = document.getElementById("NEW_NAME_ACC");
         elemError(fieldErr, txtErr);
         return false;
     }

    
    

    return true;
}

function fillAccountInformation(acc,f) {

    var accV = acc.value.toString();
    var accArray = acc.value.split("|");
    var selectedAcc = "";
	var selectedAcc15="";

    var selectedAccName = "";
    var selectedActId = "";
	
	 var form = document.getElementById(f);
    
	
  

    if (accArray[0].value != "") {
        selectedAcc = accArray[0]; // ime ot select lista
    }
	
	if (accArray[2].value != "") {
        selectedAcc15 = accArray[2]; 
		form.elements["GlAcc15"].value = selectedAcc15.trim();
    }
	

    var allAccount = form.elements["hfAccountName"];
    var allAccountArr;




    for (var i = 0, length = allAccount.length; i < length; i++) {

        if (allAccount[i].value != null && typeof (allAccount[i].value) != "undefined" && typeof (allAccount[i].value) != "") {
            allAccountArr = allAccount[i].value.split("|");


            if (selectedAcc == allAccountArr[0]) {

             
                form.elements["ACC_NUMBER"].value = allAccountArr[0];
                form.elements["lastActId"].value = allAccountArr[1].toString();
                form.elements["pName"].value = allAccountArr[2].toString();
                form.elements["NAME_ACC"].value = allAccount[i].text.toString();
				 

            }
        }



    }


    UBB.initInputFieldStyles();
}

//11055
//10476 start
function AmountDisplay(val)
{
	 var curr = "";
	 
	if($("#CURR").val() != undefined)
		curr = $("#CURR").val();
	else if ($("#CURR_ALL").val() != undefined)
		curr = $("#CURR_ALL").val();
	else if($("#sCURR_ALL").val() != undefined)
        curr = $("#sCURR_ALL").val();
    else if ($("#CURR_TF").val() != undefined)
        curr = $("#CURR_TF").val();
	else
		curr = $("#CURR_S").val();

    if (val.indexOf("," !== -1)){
        val = val.replace(/,/g, '.');
    }

    if (curr != "" && RATE[curr] * val >= 30000 && val != "" && val != null) {
        $("#DEC").removeClass("hidden");
        $("#AMOUNT2").val(val);
        $("#CURR2").val(curr); 
    }
    else {   
	$("#DECL30K").val('');
	$('#chbDeclData').prop('checked', false);        
        $("#DEC").addClass("hidden");
    }
}

function viewCURR(val) {
	
    var amt = $("#AMOUNT").val();
    if(amt == undefined)
	{
		if($("#AMOUNT_RS").val() != undefined)
        		amt = $("#AMOUNT_RS").val();
    		else if($("#TOTALVALUE").val() != undefined)
            amt = $("#TOTALVALUE").val();
        else if ($("#AMOUNT_TF").val() != undefined)
            amt = $("#AMOUNT_TF").val();
	}
    if (val != "" && val != null && amt != "" && RATE[val] * amt >= 30000) {
        $("#DEC").removeClass("hidden");
        $("#CURR2").val(val);       
        $("#AMOUNT2").val(amt);
    }
    else {
        $("#DECL30K").val('');
        $('#chbDeclData').prop('checked', false);
        $("#DEC").addClass("hidden");
    }
   
}

function changeGETIN411Choose(radioValue) { 

        var x = document.getElementById(radioValue).innerText;
		var isFreeD = $('#isFreeDecl').val();
		var chkDecl = $('#chkDecl').val();
        if (Number(x.replace(/,/g,'')) >= 30000 && x != "" && x != null && isFreeD !=1 && chkDecl !=0) {
            $("#DEC").removeClass("hidden");                       
            document.getElementById("AMOUNT2").value = x;        
            document.getElementById("CURR2").value = 'BGN';
        }
        else { 
		$("#DECL30K1").val('');
		$('#chbDeclData').prop('checked', false);		
            	$("#DEC").addClass("hidden");         
        }                            
    
}
function displayAMT(frmId) { 
 $(document).ready(function () {
	var frm = document.getElementById(frmId);
	var Elem =frm.elements['AMOUNT'].value;
	
		if (frmId == 'frmPAYMENT') {		  
      if (Elem!=''){
		  AmountDisplay(Elem);	  
	  
      }	  
	  $('#f-template').on('change', function (){				
		var allresponse =  $(this).val();
		var splitresponse = allresponse.split('|');
		var response = splitresponse[4];
		 AmountDisplay(response);	 
							    
	  });	  
	  }	
	  
     });	 
}
//10476 end

// 15876 Декларация по наредба 28
function NR28Display() {
    var curr = "";
    var amt = $("#AMOUNT").val();
    var eu = $("#CNTRY_EU").val();
    var ctry = document.getElementById('COUNTRY').value;

    if (eu != "1") {
        if ($("#CURR").val() != undefined)
            curr = $("#CURR").val();
        else if ($("#CURR_ALL").val() != undefined)
            curr = $("#CURR_ALL").val();
        else if ($("#sCURR_ALL").val() != undefined)
            curr = $("#sCURR_ALL").val();
        else
            curr = $("#CURR_S").val();

        if (curr != "" && RATE[curr] * amt >= 30000 && amt != "" && amt != null && ctry != "" && eu != "1") {
            $("#DeclNR28").removeClass("hidden");
            $("#isDeclNR28").prop('checked', true);
        }
        else {
            $("#DeclNR28").addClass("hidden");
            $("#isDeclNR28").prop('checked', false);
        }
    }
    else {
        $("#DeclNR28").addClass("hidden");
        $("#isDeclNR28").prop('checked', false);
    }
}

function NR28ClearFields(control) {

    switch (control) {
        case 'chkBoxYES.nrb28.ri2':
            document.getElementById('nrb28.ri2.1').value = '';
            document.getElementById('chkBox.nrb28.ri2.1').checked = '';
            document.getElementById('nrb28.ri2.2').value = '';
            document.getElementById('chkBox.nrb28.ri2.2').checked = '';
            document.getElementById('nrb28.ri2.3').value = '';
            document.getElementById('chkBox.nrb28.ri2.3').checked = '';
            document.break;
        case 'chkBoxNO.nrb28.ri2':
            document.getElementById('nrb28.ri2n').value = '';
            document.getElementById('chkBoxYES.nrb28.ri3').checked = '';
            document.getElementById('chkBoxNO.nrb28.ri3').checked = '';
            document.getElementById('nrb28.rii1').value = '';
            document.getElementById('nrb28.rii2').value = '';
            document.getElementById('chkBoxYES.nrb28.rii3').checked = '';
            document.getElementById('chkBoxNO.nrb28.rii3').checked = '';
            $('#frmDeclNR28 #countriesSiddoSeL').attr('selectedIndex', '-1').find("option:selected").prop('selected', false).change().trigger('select2:select');
            document.getElementById('countriesSiddo').value = '';
            document.getElementById('chkBoxYES.nrb28.rii4').checked = '';
            document.getElementById('chkBoxNO.nrb28.rii4').checked = '';
            break;
        case 'chkBox.nrb28.ri2.1':
            document.getElementById('nrb28.ri2.1').value = '';
            break;
        case 'chkBox.nrb28.ri2.2':
            document.getElementById('nrb28.ri2.2').value = '';
            break;
        case 'chkBox.nrb28.ri2.3':
            document.getElementById('nrb28.ri2.3').value = '';
            break;
        case 'chkBoxNO.nrb28.ri3':
            document.getElementById('nrb28.rii1').value = '';
            document.getElementById('nrb28.rii2').value = '';
            document.getElementById('chkBoxYES.nrb28.rii3').checked = '';
            document.getElementById('chkBoxNO.nrb28.rii3').checked = '';
            $('#frmDeclNR28 #countriesSiddoSeL').attr('selectedIndex', '-1').find("option:selected").prop('selected', false).change().trigger('select2:select');
            document.getElementById('countriesSiddo').value = '';
            document.getElementById('chkBoxYES.nrb28.rii4').checked = '';
            document.getElementById('chkBoxNO.nrb28.rii4').checked = '';
            break;
        case 'chkBoxNO.nrb28.rii3':
            $('#frmDeclNR28 #countriesSiddoSeL').attr('selectedIndex', '-1').find("option:selected").prop('selected', false).change().trigger('select2:select');
            document.getElementById('countriesSiddo').value = '';
            break;
        default:
    }

}

function NR28SetAmount() {
    document.getElementById('nrb28.ri1.sum').value = document.getElementById("AMOUNT").value;
}

function NR28SetCurrency(eventValCurr) {
    document.getElementById('nrb28.ri1.curr').value = eventValCurr;
}

function SaveDeclNR28(f1, DocId, f, submitform, idAjaxResult) {
    try {
        var frm = document.getElementById(f1);
        frm.elements['DOCID'].value = DocId;

        var sbody = ObtainBody(f1);
        idAJAXResult = "divResultDecl";
        SendPostRequestAc("t.aspx", sbody, function () {
            StoreAndSignToConfP(f, submitform, idAjaxResult);
        });
    }
    catch (e) {
        createCustomAlertDeclaration(e);
    }
}

function CheckNrbR12Rules() {

    let nr28r21 = document.getElementById("chkBox.nrb28.ri2.1");
    let nr28r22 = document.getElementById("chkBox.nrb28.ri2.2");
    let nr28r23 = document.getElementById("chkBox.nrb28.ri2.3");

    if (nr28r23.checked) {
        console.log(nr28r22);
        document.getElementById("chkBox.nrb28.ri2.1").disabled = true;
        document.getElementById("chkBox.nrb28.ri2.2").disabled = true;
    }
    else {
        document.getElementById("chkBox.nrb28.ri2.1").disabled = false;
        document.getElementById("chkBox.nrb28.ri2.2").disabled = false;
    }

    if (nr28r21.checked || nr28r22.checked) {
        document.getElementById("chkBox.nrb28.ri2.3").disabled = true;
    }
    else {
        document.getElementById("chkBox.nrb28.ri2.3").disabled = false;
    }
}
// 15876 Декларация по наредба 28 -----

// OOBT-353 Load Target status
function bic_ch(idFrmMain, idFrmSub, idDiv) {

    var FM = document.getElementById(idFrmMain);
    var FS = document.getElementById(idFrmSub);
    FS.elements["BIC_R"].value = FM.elements["BIC_R"].value;
    var BIC_R = FM.elements["BIC_R"].value;

    if (BIC_R != '') {
        GetIbanSal(idFrmMain, idFrmSub, idDiv);
    }

    setTimeout(function () {
        bic_curr_ch()
    }, 1800);

}

function bic_curr_ch() {

    var curr = "";
    if ($("#CURR").val() != undefined)
        curr = $("#CURR").val();

    var bic = "";
    if ($("#TARGET_BIC").val() != undefined)
        bic = $("#TARGET_BIC").val();

    if (curr == "EUR" && bic == '1') {
        document.getElementById('BK.TO.BK.INFO').removeAttribute('disabled');
    }
    else {
        document.getElementById('BK.TO.BK.INFO').setAttribute('disabled', 'disabled');
        document.getElementById('BK.TO.BK.INFO').checked = '';
    }

    sepa_inst_ch(); // OOBT-1514
}
// OOBT-353 ----------------------

// OOBT-1514 Load Sepa inst status
function sepa_inst_ch() {

    var sepaElem = document.getElementById('SEPA.INSTANT');
    var sepaElemChecked = sepaElem.checked;

    if (CheckSepaInstConditions()) {
        sepaElem.removeAttribute('disabled');
        removeError('frmPAYMENT');
    }
    else {
        sepaElem.setAttribute('disabled', 'disabled');
        sepaElem.checked = '';
        SetSepaInstFields(); // OOBT-2408

        target_ch();
        valuedate_ch();

        if (sepaElemChecked) 
            elemErrorSend(sepaElem, 'Преводът не отговаря на условията за SEPA Незабавен превод.<br/>The transfer is not corresponding with the conditions for SEPA Instant transfer.');
    }
}

function sepa_inst_warning() {

    if (!CheckSepaInstConditions()) {
        var sepaElem = document.getElementById('SEPA.INSTANT');
        var target = document.getElementById('BK.TO.BK.INFO').checked;
        var valuedate = document.getElementById('VALUEDATE').value;

        if (target)
            elemErrorSend(sepaElem, 'Опция ЕКСПРЕСЕН (TARGET2) не е допустима заедно с опция SEPA Незабавен превод.<br/>EXPRESS (TARGET2) is not allowed together with an option SEPA Instant transfer.');
        else {
            if (valuedate != '')
                elemErrorSend(sepaElem, 'Бъдещ вальор не се допуска за SEPA Незабавен превод.<br/>Future date is not allowed for SEPA Instant transfer.');
        }
    }
}

function target_warning() {

    if (CheckSepaInstConditions()) {
        var sepa = document.getElementById('SEPA.INSTANT').checked;
        var targetElem = document.getElementById('BK.TO.BK.INFO');

        if (sepa)
            elemErrorSend(targetElem, 'Опция ЕКСПРЕСЕН (TARGET2) не е допустима заедно с опция SEPA Незабавен превод.<br/>EXPRESS (TARGET2) is not allowed together with an option SEPA Instant transfer.');
    }
}

function target_ch() {
    var sepa = document.getElementById('SEPA.INSTANT').checked;
    var targetElem = document.getElementById('BK.TO.BK.INFO');
    if (sepa) {
        targetElem.setAttribute('disabled', 'disabled');
    }
    else {
        var curr = "";
        if ($("#CURR").val() != undefined)
            curr = $("#CURR").val();

        var bic = "";
        if ($("#TARGET_BIC").val() != undefined)
            bic = $("#TARGET_BIC").val();

        if (curr == "EUR" && bic == '1') {
            targetElem.removeAttribute('disabled');
        }
        removeError('frmPAYMENT');
    }
}

// OOBT-1797 ---------------------
function valuedate_warning() {

    if (CheckSepaInstConditions()) {
        var sepa = document.getElementById('SEPA.INSTANT').checked;
        var valuedate = document.getElementById('VALUEDATE');

        if (sepa)
            elemError(valuedate, 'Бъдещ вальор не се допуска за SEPA Незабавен превод.<br/>Future date is not allowed for SEPA Instant transfer.');
    }
}

function valuedate_ch() {
    var sepa = document.getElementById('SEPA.INSTANT').checked;
    var valuedate = document.getElementById('VALUEDATE');

    if (sepa) {
        valuedate.setAttribute('disabled', 'disabled');
        $('#divValueDate').addClass("disabled");
    }
    else {
        valuedate.removeAttribute('disabled');
        $('#divValueDate').removeClass("disabled");
        removeError('frmPAYMENT');
    }
}

function setClearEvent() {
    $("#divValueDate .field-close.js-field-close").click(function () { clearValueDate() });
}

function clearValueDate() {
    document.getElementById('VALUEDATE').value = '';
    sepa_inst_ch();
}
// OOBT - 1797 ---------------------

function CheckSepaInstConditions() {
    var curr = "";
    if ($("#CURR").val() != undefined)
        curr = $("#CURR").val();

    var sepa = "";
    if ($("#SEPA_INST_BIC").val() != undefined)
        sepa = $("#SEPA_INST_BIC").val();

    var amount = 0;
    if ($("#AMOUNT").val() != undefined)
        amount = $("#AMOUNT").val();

    var charges = document.getElementById('radio-5').checked; //SHA

    var ul = document.getElementById('UL');
    var ulDecl = document.getElementById('rbN').checked;

    var target = document.getElementById('BK.TO.BK.INFO').checked;

    var valueDate = document.getElementById('VALUEDATE').value;

    return curr == "EUR" && sepa == '1' && amount <= 15000 && charges &&
        (ul == null || ul != null && ulDecl == true) && !target && valueDate == ''
}
// OOBT-1514 ---------------------

// OOBT-1602 ---------------------
function SetSepaInstFields() {
    var sepa = document.getElementById('SEPA.INSTANT').checked;
    var sepaInput = document.getElementById('LOC_INSTRUMENT');
    var globusInput = document.getElementById('REPR_CUS_NUMBER');
    var phoneInput = document.getElementById('REPR_TEL_NUMBER');
    if (sepa) {
        sepaInput.value = "INST";
        globusInput.value = document.getElementById('idMGLOBUSID').value;
        phoneInput.value = document.getElementById('idCLPHONE').value;
    }
    else {
        sepaInput.value = "";
        globusInput.value = "";
        phoneInput.value = "";
    }
}
// OOBT-1602 ---------------------


//OOBT - 167----
function handlePenDcFCheckboxClick(event, checkboxElement, idTable) {
    event.stopPropagation();

    var sumCell = checkboxElement.closest('tr').querySelector('td.amttosum');

    if (checkboxElement.checked) {
        sumCell.classList.add('sumAmt');
    } else {
        sumCell.classList.remove('sumAmt');
    }

    if (idTable != 'stmt') {
        var sumCellOrig = checkboxElement.closest('tr').querySelector('td.amttosumorig');
        if (checkboxElement.checked) {
            sumCellOrig.classList.add('sumAmtOrig');
        } else {
            sumCellOrig.classList.remove('sumAmtOrig');
        }
    }


    calculatePenDFSumAndAmount(idTable);
}

function handlePenDFMarkAll(markAllCheckboxes,idTable) {
    var isChecked = markAllCheckboxes.checked;

    document.querySelectorAll('#'+idTable+ ' tbody tr').forEach(function (row) {
        if (idTable != 'stmt') {
            var checkbox = row.querySelector('td label > .chck[type="checkbox"]');
        }
        else {
            var checkbox = row.querySelector('td label > .row-checkbx[type="checkbox"]');
        }

        if (checkbox) {
            var sumCell = row.querySelector('td.amttosum');

            if (isChecked) {
                sumCell.classList.add('sumAmt');
                checkbox.checked = true;
            } else {
                sumCell.classList.remove('sumAmt');
                checkbox.checked = false;
            }
            if (idTable != 'stmt') {
                var sumCellOrig = row.querySelector('td.amttosumorig');
                if (isChecked) {
                    sumCellOrig.classList.add('sumAmtOrig');
                    checkbox.checked = true;
                } else {
                    sumCellOrig.classList.remove('sumAmtOrig');
                    checkbox.checked = false;
                }
            }
        }
    });
    calculatePenDFSumAndAmount(idTable);
}

function calculatePenDFSumAndAmount(idTable) {
    var totalSum = 0;
    var totalSumOrig = 0;
    var selectedRows = 0;

    document.querySelectorAll('#'+idTable+' td.sumAmt').forEach(function (cell) {
        var value = parseFloat(cell.textContent.replace(/,/g, '')) || 0;
        totalSum += value;
    });


    if (idTable != 'stmt') {
        document.querySelectorAll('#' + idTable + ' td.sumAmtOrig').forEach(function (cell) {
            var value = parseFloat(cell.textContent.replace(/,/g, '')) || 0;
            totalSumOrig += value;
        });

        document.querySelectorAll('#' + idTable + ' tr .chck[type="checkbox"]:checked').forEach(function () {
            selectedRows++;
        });

        var formattedSumOrig = formatNumber(totalSumOrig);
        document.querySelectorAll('#total-selected-sum-amount-orig')[1].textContent = formattedSumOrig;
     }
    else {
        document.querySelectorAll('#' + idTable + ' tr .row-checkbx[type="checkbox"]:checked').forEach(function () {
            selectedRows++;
        });
    }
    
    var formattedSum = formatNumber(totalSum);
    

    document.querySelectorAll('#total-selected-sum-amount')[1].textContent = formattedSum;
    document.querySelectorAll('#total-selected-rows')[1].textContent = selectedRows;
    
}

function formatNumber(number) {
    return new Intl.NumberFormat('en-US', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    }).format(number);
}
//OOBT - 167----
