var DeWeb = window.DeWeb || {};

DeWeb.Config = {
    Initialized: false,
    DateFormats: []
}
if (!String.prototype.startsWith) {
    String.prototype.startsWith = function (searchString, position) {
        position = position || 0;
        return this.indexOf(searchString, position) === position;
    };
}

// Adding STRING replaceAll function which is usefull
if (!String.prototype.replaceAll) {
    String.prototype.replaceAll = function (search, replacement) {
        var target = this;
        return target.split(search).join(replacement);
    };
}

function twoDigit(number) {
    var twodigit = number >= 10 ? number : "0" + number.toString();
    return twodigit;
}

function escapeAccountChars(account) {
    account = account ? account : '';
    if (typeof (account) !== 'string')
        account = new String(account);
    account = account.replace(/\./g, '\\.');
    return account;
}

function InMemoryCache() {
    if ("instance" in arguments.callee)
        throw "new instance is not desired";
    var simpleCache = {};

    this.set = function (key, data) {
        simpleCache[key] = data;
    };

    this.get = function (key) {
        return simpleCache[key];
    };
};


Object.defineProperty(InMemoryCache, "instance", { value: new InMemoryCache(), writable: false });
DeWeb.Enums = DeWeb.Enums || {
    UiContentPlacementEnum: {
        POPUPNARROW: 0,
        POPUPWIDE: 1,
        INLINE: 2,
        POPUPSIDE: 3,
        props: {
            0: { container: "popup-content-narrow" },
            1: { container: "popup-content-wide" },
            2: { container: "page-content" },
            3: { container: "popup-content-side" }
        }
    },
    SubProcessTypeEnum: {
        POPUP: 1,
        INLINE: 2,
        REDIRECT: 3
    },
    StateActionTypeEnum: {
        REFRESHFILTER: 0,
        REFRESHCURRENTPAGE: 1,
        REDIRECT: 2,
        SUBMITCUSTOMFORM: 3,
        TRIGGERCUSTOMEVENT: 4,
        CLOSEPOPUP: 5
    },
    MessagesDisplayEnum: {
        TOAST: 0,
        POPUP: 1,
        CUSTOM: 2,
    },
    ButtonActionType: {
        Save: 1,
        Back: 2,
        Forward: 3,
        Abort: 4,
        Download: 5,
        Custom: 6,
        SubProcess: 7,
        Link: 8,
        FieldAction: 9,
    },
}

DeWeb.Helpers = {
    GetQueryStringValue: function (key) {
        return unescape(window.location.search.replace(new RegExp("^(?:.*[&\\?]" + escape(key).replace(/[\.\+\*]/g, "\\$&") + "(?:\\=([^&]*))?)?.*$", "i"), "$1"));
    },
    GetQueryStringValueFromUrl: function (key, url) {
        return unescape(url.replace(new RegExp("^(?:.*[&\\?]" + escape(key).replace(/[\.\+\*]/g, "\\$&") + "(?:\\=([^&]*))?)?.*$", "i"), "$1"));
    },
    PushSingleQueryInHistory: function (queryName, queryValue) {
        if (history.pushState) {
            var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + '?' + queryName + '=' + queryValue;
            window.history.pushState({ path: newurl }, '', newurl);
            return true;
        }
        return false;
    }
}

DeWeb.Popups = DeWeb.Popups ||
    [
        {
            id: "p2pconfirm",
            href: "Applications/BecomeAClient",
            width: "wide"
        }
    ];


window.log = function () {
    log.history = log.history || [];   // store logs to an array for reference
    log.history.push(arguments);
    if (this.console) {
        arguments.callee = arguments.callee.caller;
        var newarr = [].slice.call(arguments);
        (typeof console.log === 'object' ? log.apply.call(console.log, console, newarr) : console.log.apply(console, newarr));
    }
};

// make it safe to use console.log always
(function (b) { function c() { } for (var d = "assert,count,debug,dir,dirxml,error,exception,group,groupCollapsed,groupEnd,info,log,timeStamp,profile,profileEnd,time,timeEnd,trace,warn".split(","), a; a = d.pop();) { b[a] = b[a] || c } })((function () {
    try { console.log(); return window.console; } catch (err) { return window.console = {}; }
})());

//CORE

$(document).ajaxError(function (event, jqxhr, settings, thrownError) {
    if (jqxhr.statusText == "abort") {
        return;
    }
    var errorLink = "";
    switch (jqxhr.status) {
        case 500:
            {
                errorLink = "Error/Index";
                break;
            }
        case 404:
            {
                errorLink = "Error/NotFound";
                break;
            }
        case 403:
            {
                errorLink = "Error/AccessDenied";
                break;
            }
        default:
            {
                errorLink = "Error/Index";
                break;
            }
    }

    $.get(DeWeb.Config.BasePath + errorLink, function (data) {
        settings.success(data);
    });

});

//prototypes

var noBlockWait = function (checker, exec) {
    if (isFunction(checker)) {
        if (checker()) {
            return exec();
        } else {
            setTimeout(function () {
                noBlockWait(checker, exec);
            }, 50)
        };
    }
}
Array.prototype.anyMatch = Array.prototype.anyMatch || function (checker) {
    if (isFunction(checker)) {
        for (var i = 0; i < this.length; i++) {
            if (checker(this[i])) {
                return true;
            };
        }
    }
}
Array.prototype.firstMatch = Array.prototype.firstMatch || function (checker) {
    if (isFunction(checker)) {
        for (var i = 0; i < this.length; i++) {
            if (checker(this[i])) {
                return this[i];
            };
        }
    }
    return null;
}


function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
}

DeWeb.Utilities = DeWeb.Utilities || {};
DeWeb.Events = DeWeb.Events || {};
DeWeb.Intros = DeWeb.Intros || [];


DeWeb.LoadUtilities = function (context) {
    if (context === undefined) {
        context = $(document);
    }
    // Blocked menu items
    var accessdeniedhrefs1 = context.find('[href="#accessdenied"]').each(function () { $(this).css('display', 'none'); });
    var accessdeniedhrefs2 = context.find('[data-href="#accessdenied"]').each(function () { $(this).css('display', 'none'); });

    context.find('*[data-utility][data-is-priority]').each(function () {
        var that = $(this);
        var loadedUtilities = [];
        loadedUtilities = that.data('loaded-utilities') || loadedUtilities;
        var nrUtilities = that.attr('data-utility');

        if (that.parents().hasClass("no-utilities")) {
            return;
        }

        $.each(nrUtilities.split(" "), function (index, utilityName) {
            var alreadyLoaded = false;

            if (loadedUtilities.length) {
                for (var i = 0; i < loadedUtilities.length; i++) {
                    if (loadedUtilities[i] && loadedUtilities[i] === utilityName) {
                        alreadyLoaded = true;
                    }
                }
            }

            if (!alreadyLoaded) {
                try {
                    var MethodClass = DeWeb.Utilities[utilityName],
                        initializedMethod = new MethodClass(that);
                    loadedUtilities.push(utilityName);
                    that.data('loaded-utilities', loadedUtilities);
                }
                catch (e) {
                    console.log(utilityName + " " + e);
                }
            }
        });
    });

    context.find('*[data-utility]').each(function () {
        var that = $(this),
            utilities = that.attr('data-utility');

        var loadedUtilities = [];
        loadedUtilities = that.data('loaded-utilities') || loadedUtilities;

        if (that.data('is-priority')) {
            return;
        }

        if (that.parents().hasClass("no-utilities")) {
            return;
        }

        $.each(utilities.split(" "), function (index, utilityName) {
            var alreadyLoaded = false;
            if (loadedUtilities.length) {
                for (var i = 0; i < loadedUtilities.length; i++) {
                    if (loadedUtilities[i] && loadedUtilities[i] === utilityName) {
                        alreadyLoaded = true;
                    }
                }
            }

            if (!alreadyLoaded) {
                try {
                    var MethodClass = DeWeb.Utilities[utilityName],
                        initializedMethod = new MethodClass(that);
                    loadedUtilities.push(utilityName);
                    that.data('loaded-utilities', loadedUtilities);
                }
                catch (e) {
                    console.log(utilityName + " " + e);
                }
            }
        });
    });
};

DeWeb.onReady = function () {
    /*** CONTINUE ***/
    DeWeb.LoadUtilities();
    DeWeb.Forms.Init();
    $(document).trigger('initial-utilities-loaded');
    $('html').removeClass('no-js').addClass('js');
    DeWeb.Functionalities.SetHotkeys();
};

$(document).ready(function () {
    DeWeb.onReady();
});

(function () {
    var $;

    $ = window.jQuery || window.Zepto || window.$;

    $.fn.fancySelect = function (opts) {
        var isiOS, settings;
        if (opts == null) {
            opts = {};
        }
        settings = $.extend({
            forceiOS: false,
            includeBlank: false,
            optionTemplate: function (optionEl) {
                return optionEl.text();
            },
            triggerTemplate: function (optionEl) {
                return optionEl.text();
            }
        }, opts);
        isiOS = !!navigator.userAgent.match(/iP(hone|od|ad)/i);
        return this.each(function () {
            var copyOptionsToList, disabled, options, sel, trigger, updateTriggerText, wrapper;
            sel = $(this);
            if (sel.hasClass('fancified') || sel[0].tagName !== 'SELECT') {
                return;
            }
            sel.addClass('fancified');
            sel.css({
                width: 1,
                height: 1,
                display: 'block',
                position: 'absolute',
                top: 0,
                left: 0,
                opacity: 0
            });
            sel.wrap('<div class="fancy-select">');
            wrapper = sel.parent();
            if (sel.data('class')) {
                wrapper.addClass(sel.data('class'));
            }
            wrapper.append('<div class="trigger">');
            if (!(isiOS && !settings.forceiOS)) {
                wrapper.append('<ul class="options">');
            }
            trigger = wrapper.find('.trigger');
            options = wrapper.find('.options');
            disabled = sel.prop('disabled');
            if (disabled) {
                wrapper.addClass('disabled');
            }
            updateTriggerText = function () {
                var triggerHtml;
                triggerHtml = settings.triggerTemplate(sel.find(':selected'));
                return trigger.html(triggerHtml);
            };
            sel.on('blur.fs', function () {
                if (trigger.hasClass('open')) {
                    return setTimeout(function () {
                        return trigger.trigger('close.fs');
                    }, 120);
                }
            });
            trigger.on('close.fs', function () {
                trigger.removeClass('open');
                return options.removeClass('open');
            });
            trigger.on('click.fs', function () {
                var offParent, parent;
                if (!disabled) {
                    trigger.toggleClass('open');
                    if (isiOS && !settings.forceiOS) {
                        if (trigger.hasClass('open')) {
                            return sel.focus();
                        }
                    } else {
                        if (trigger.hasClass('open')) {
                            parent = trigger.parent();
                            offParent = parent.offsetParent();
                            if ((parent.offset().top + parent.outerHeight() + options.outerHeight() + 20) > $(window).height() + $(window).scrollTop()) {
                                options.addClass('overflowing');
                            } else {
                                options.removeClass('overflowing');
                            }
                        }
                        options.toggleClass('open');
                        if (!isiOS) {
                            return sel.focus();
                        }
                    }
                }
            });
            sel.on('enable', function () {
                sel.prop('disabled', false);
                wrapper.removeClass('disabled');
                disabled = false;
                return copyOptionsToList();
            });
            sel.on('disable', function () {
                sel.prop('disabled', true);
                wrapper.addClass('disabled');
                return disabled = true;
            });
            sel.on('change.fs', function (e) {
                if (e.originalEvent && e.originalEvent.isTrusted) {
                    return e.stopPropagation();
                } else {
                    return updateTriggerText();
                }
            });
            sel.on('keydown', function (e) {
                var hovered, newHovered, w;
                w = e.which;
                hovered = options.find('.hover');
                hovered.removeClass('hover');
                if (!options.hasClass('open')) {
                    if (w === 13 || w === 32 || w === 38 || w === 40) {
                        e.preventDefault();
                        return trigger.trigger('click.fs');
                    }
                } else {
                    if (w === 38) {
                        e.preventDefault();
                        if (hovered.length && hovered.index() > 0) {
                            hovered.prev().addClass('hover');
                        } else {
                            options.find('li:last-child').addClass('hover');
                        }
                    } else if (w === 40) {
                        e.preventDefault();
                        if (hovered.length && hovered.index() < options.find('li').length - 1) {
                            hovered.next().addClass('hover');
                        } else {
                            options.find('li:first-child').addClass('hover');
                        }
                    } else if (w === 27) {
                        e.preventDefault();
                        trigger.trigger('click.fs');
                    } else if (w === 13 || w === 32) {
                        e.preventDefault();
                        hovered.trigger('mousedown.fs');
                    } else if (w === 9) {
                        if (trigger.hasClass('open')) {
                            trigger.trigger('close.fs');
                        }
                    }
                    newHovered = options.find('.hover');
                    if (newHovered.length) {
                        options.scrollTop(0);
                        return options.scrollTop(newHovered.position().top - 12);
                    }
                }
            });
            options.on('mousedown.fs', 'li', function (e) {
                var clicked;
                clicked = $(this);
                sel.val(clicked.data('raw-value'));
                if (!isiOS) {
                    sel.trigger('blur.fs').trigger('focus.fs');
                }
                options.find('.selected').removeClass('selected');
                clicked.addClass('selected');
                trigger.addClass('selected');
                return sel.val(clicked.data('raw-value')).trigger('change.fs').trigger('blur.fs').trigger('focus.fs');
            });
            options.on('mouseenter.fs', 'li', function () {
                var hovered, nowHovered;
                nowHovered = $(this);
                hovered = options.find('.hover');
                hovered.removeClass('hover');
                return nowHovered.addClass('hover');
            });
            options.on('mouseleave.fs', 'li', function () {
                return options.find('.hover').removeClass('hover');
            });
            copyOptionsToList = function () {
                var selOpts;
                updateTriggerText();
                if (isiOS && !settings.forceiOS) {
                    return;
                }
                selOpts = sel.find('option');
                return sel.find('option').each(function (i, opt) {
                    var optHtml;
                    opt = $(opt);
                    if (!opt.prop('disabled') && (opt.val() || settings.includeBlank)) {
                        optHtml = settings.optionTemplate(opt);
                        if (opt.prop('selected')) {
                            return options.append("<li data-raw-value=\"" + (opt.val()) + "\" class=\"selected\">" + optHtml + "</li>");
                        } else {
                            return options.append("<li data-raw-value=\"" + (opt.val()) + "\">" + optHtml + "</li>");
                        }
                    }
                });
            };
            sel.on('update.fs', function () {
                wrapper.find('.options').empty();
                return copyOptionsToList();
            });
            return copyOptionsToList();
        });
    };

}).call(this);
(function ($, window, document, undefined) {

    var methods = {

        init: function (options) {

            var defaults = $.extend({
                image: null,
                width: 50,
                height: 50,
                disabled: false
            }, options);

            return this.each(function () {

                var $this = $(this);

                var $thisImage = defaults.image;
                var dataImage = $this.data('sdb-image');
                if (dataImage) {
                    $thisImage = dataImage;
                }

                $this.wrap('<div >').css({ 'display': 'none' });

                var buttonClass = $this.attr('class');
                var buttonClick = $this.attr('onclick');

                var $thisParent = $this.parent('div');

                $thisParent.addClass(buttonClass);
                $thisParent.attr('onclick', buttonClick);

                var uncheckedPos = 0;
                var checkedPos = -(defaults.height);
                if ($this.is(':disabled')) {
                    uncheckedPos = -(defaults.height * 2);
                    checkedPos = -(defaults.height * 3);
                }

                $this.on('disableBtn', function () {
                    $this.attr('disabled', 'disabled');
                    uncheckedPos = -(defaults.height * 2);
                    checkedPos = -(defaults.height * 3);
                    $this.trigger('resetBackground');
                });

                $this.on('enableBtn', function () {
                    $this.removeAttr('disabled');
                    uncheckedPos = 0;
                    checkedPos = -(defaults.height);
                    $this.trigger('resetBackground');
                });

                $this.on('resetBackground', function () {
                    if ($this.is(':checked')) {
                        $thisParent.css({
                            backgroundPosition: '0 ' + checkedPos + "px"
                        });
                    }
                    else {
                        $thisParent.css({
                            backgroundPosition: '0 ' + uncheckedPos + "px"
                        });
                    }
                });

                $this.trigger('resetBackground');

                if ($this.is(':checkbox')) {
                    $thisParent.on('click', function () {
                        if (!($this.is(':disabled'))) {
                            $this.change();
                        }
                    });

                    $thisParent.addClass('styledCheckbox');

                    $this.on('change', function () {
                        if ($this.prop('checked')) {
                            $this.prop("checked", false);
                            $thisParent.removeClass('checked');
                            var form = $(this).parents('#form_ChooseLinksForm');
                            if (form.length > 0) {
                                var listItems = $thisParent.closest(".notification-wraper").children().eq(2).children();
                                if (listItems.length > 1) {
                                    for (var i = 0; i < listItems.length; i++) {
                                        var className = listItems[i].children[1].children[0].children[0].className.replace('checked ', '');
                                        listItems[i].children[1].children[0].children[0].className = className;
                                        className = listItems[i].children[1].children[0].children[0].children[0].className.replace('checked ', '');
                                        listItems[i].children[1].children[0].children[0].children[0].className = className;
                                        className = listItems[i].children[2].children[0].children[0].children[0].className.replace('checked ', '');
                                        listItems[i].children[2].children[0].children[0].children[0].className = className;
                                        className = listItems[i].children[2].children[0].children[0].children[0].children[0].className.replace('checked ', '');
                                        listItems[i].children[2].children[0].children[0].children[0].children[0].className = className;
                                        listItems[i].children[2].children[0].children[0].children[0].children[0].value = 'False';
                                    }
                                }
                            }
                            /*
							$thisParent.css({
								backgroundPosition: '0 ' + uncheckedPos + "px"
							});
							*/
                        }
                        else {
                            $this.prop("checked", true);
                            $thisParent.addClass('checked');
                            /*
							$thisParent.css({
								backgroundPosition:  '0 ' + checkedPos + "px"
							});
							*/
                        }
                    });

                }
                else if ($this.is(':radio')) {

                    $thisParent.addClass('styledRadio');

                    var $thisName = $this.attr('name');

                    $thisParent.on('click', function () {
                        if (!($this.prop('checked')) && !($this.is(':disabled'))) {
                            $this.change();
                        }
                    });


                    $this.on('change', function () {
                        if ($this.prop('checked')) {
                            $this.prop("checked", false);
                            $thisParent.css({
                                backgroundPosition: '0 ' + uncheckedPos + "px"
                            });
                        }
                        else {
                            $this.prop("checked", true);
                            $thisParent.css({
                                backgroundPosition: '0 ' + checkedPos + "px"
                            });

                            var otherRadioBtns = $('input[name="' + $thisName + '"]').not($this);
                            otherRadioBtns.trigger('radioSwitch');
                        }
                    });

                    $this.on('radioSwitch', function () {
                        $thisParent.css({
                            backgroundPosition: '0 ' + uncheckedPos + "px"
                        });

                    });

                    var $thisId = $(this).attr('id');
                    var $thisLabel = $('label[for="' + $thisId + '"]');
                    $thisLabel.on('click', function () {
                        $thisParent.trigger('click');
                    });
                }

                if (!$.support.leadingWhitespace) {
                    var $thisId = $(this).attr('id');
                    var $thisLabel = $('label[for="' + $thisId + '"]');
                    $thisLabel.on('click', function () {
                        $thisParent.trigger('click');
                    });
                }

            });

        },
        check: function () {
            return this.each(function () {
                var $this = $(this);
                if (!methods.isChecked($this)) {
                    $this.change();
                }
            });
        },
        uncheck: function () {
            return this.each(function () {
                var $this = $(this);
                if (methods.isChecked($this)) {
                    $this.change();
                }
            });
        },
        toggle: function () {
            return this.each(function () {
                var $this = $(this);
                $this.change();
            });
        },
        disable: function () {
            return this.each(function () {
                var $this = $(this);
                $this.trigger('disableBtn');
            });
        },
        enable: function () {
            return this.each(function () {
                var $this = $(this);
                $this.trigger('enableBtn');
            });
        },
        isChecked: function ($this) {
            if ($this.prop('checked')) {
                return true;
            }
            return false;
        }
    };

    $.fn.screwDefaultButtons = function (method, options) {

        // Method calling logic
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist on jQuery.screwDefaultButtons');
        }

    };

    return this;

})(jQuery);

DeWeb.Utilities.dewebInit = function ($this) {
    var decimalSep = $this.data('decimal-sep');
    var groupSep = $this.data('group-sep');
    var dateFormat = $this.data('date-format');
    var culture = $this.data('culture');
    var googleApiKey = $this.data('google-api-key');
    var googleClientId = $this.data('google-client-id');
    var defaultContainer = $this.data('default-container');
    var defaultPopupContainer = $this.data('default-popup-container');
    var basePath = $this.data('base-path');

    DeWeb.Config = DeWeb.Config || {};
    DeWeb.Config.Initialized = true;

    DeWeb.Config.DecimalSeparator = decimalSep;
    DeWeb.Config.GroupSeparator = groupSep;
    DeWeb.Config.Culture = culture;
    DeWeb.Config.DateFormat = dateFormat;
    DeWeb.Config.DefaultContainer = defaultContainer;
    DeWeb.Config.DefaultPopupContainer = defaultPopupContainer;
    DeWeb.Config.BasePath = basePath;
    DeWeb.Config.GoogleApiKey = googleApiKey;
    DeWeb.Config.GoogleCliendId = googleClientId;

    var queryPopup = DeWeb.Helpers.GetQueryStringValue('popup');
    if (queryPopup) {
        try {

            var popup = DeWeb.Popups.firstMatch(function (elem) {
                return elem.id === queryPopup;
            });

            if (popup) {
                $.get(basePath + popup.href,
                    function (data) {
                        DeWeb.Ui.ShowPopup(data, popup.width);
                    });
            }
        } catch (e) {
            console.log(e);
        }
    }
}
DeWeb.Utilities.discardAllFlows = function ($this) {
    $this.on('click', function () {
        $.post(DeWeb.Config.BasePath + '/dialog/uiflow/DeleteAllFlows', function (data) {
            DeWeb.Ui.ClearNotifications();
        });
        window.location.reload();
    });
};
DeWeb.Utilities.resumeFlow = function ($this) {

    $this.on('click', function () {
        var href = $this.data('href');
        var processhref = $this.data('flow-href');
        if (processhref) {
            var placement = DeWeb.Helpers.GetQueryStringValueFromUrl('uiplacement', processhref);
            if (placement) {
                var placementInt = parseInt(placement);
                switch (placementInt) {
                    case DeWeb.Enums.UiContentPlacementEnum.INLINE:
                        {
                            window.location = href;
                            break;
                        }
                    case DeWeb.Enums.UiContentPlacementEnum.POPUPWIDE:
                        {
                            $.get(href).done(function (data) {
                                if (data) {
                                    DeWeb.Ui.ShowPopup(data, 'wide');
                                }
                            });
                            break;
                        }
                    case DeWeb.Enums.UiContentPlacementEnum.POPUPNARROW:
                        {
                            $.get(href).done(function (data) {
                                if (data) {
                                    DeWeb.Ui.ShowPopup(data, 'narrow');
                                }
                            });
                            break;
                        }

                    case DeWeb.Enums.UiContentPlacementEnum.POPUPSIDE:
                        {
                            $.get(href).done(function (data) {
                                if (data) {
                                    DeWeb.Ui.ShowPopup(data, 'side');
                                }
                            });
                            break;
                        }
                    default:
                        {
                            break;
                        }
                }
            }
        }

    });

}

DeWeb.Forms = new function () {
    var formprefix = "form_",
        init = function () {
            var $submittingButton = {};
            //mark the button submitting the form;
            $(document).on('click', 'form :submit', function () {

                var $thisForm = $(this).parents('form:first');
                $(":submit", $(this).parents("form")).removeAttr("clicked");
                $(this).attr("clicked", "true");

                var validator = $thisForm.data('validator');
                if (validator) {
                    $submittingButton = $("input[type=submit][clicked=true]");

                    if ($submittingButton.length) {
                        var shouldValidate = $submittingButton.data('validate').toLowerCase() === 'true';

                        if (!shouldValidate) {
                            $thisForm.removeData("validator").removeData("unobtrusiveValidation");
                            return;
                        }

                        var validationGroups = $submittingButton.data('validation-groups');
                        if (validationGroups) {
                            var validateGroups = validationGroups.split(',');

                            $thisForm.find(':input').each(function () {
                                var $thisField = $(this);
                                var $groupParent = $thisField.parents('.deweb-group:first');

                                if ($groupParent.length) {
                                    var groupId = $groupParent.data('group-id');
                                    var validateThis = false;
                                    if (groupId) {
                                        for (var i = 0; i < validateGroups.length; i++) {
                                            if (validateGroups[i] === groupId) {
                                                validateThis = true;
                                            }
                                        }

                                        if (validateThis) {
                                            return;
                                        }
                                    }
                                }

                                var inputName = $thisField.attr('name');
                                var rule = $thisForm.data("validator").settings.rules[inputName];
                                if (rule) {
                                    $thisForm.data("validator").settings.rules[inputName].required = false;
                                }

                                return;
                            });
                            //$('.deweb-group').each(function () {
                            //    var $thisGroup = $(this);
                            //    var validateThis = false;
                            //    var groupId = $thisGroup.data('group-id');
                            //    if (groupId) {
                            //        for (var i = 0; i < validateGroups.length; i++) {
                            //            if (validateGroups[i] === groupId) {
                            //                validateThis = true;
                            //            }
                            //        }

                            //        if (!validateThis) {
                            //            $thisGroup.find(':input').each( function () {
                            //                var $thisInput = $(this);
                            //                var inputName = $thisInput.attr('name');
                            //                var rule = $thisForm.data("validator").settings.rules[inputName];
                            //                $thisForm.data("validator").settings.rules[inputName].required = false;
                            //            });
                            //        }
                            //    }
                            //});
                        }
                    }
                }
            });
            $("form").each(function () {
                var validator = $(this).data('validator');
                if (validator) {
                    if ($(this).hasClass('no-validation')) {
                        $(this).removeData("validator").removeData("unobtrusiveValidation");
                        return;
                    }

                    validator.settings.errorPlacement = function (error, element) {
                        var parent = element.parents('.group-inner').first();
                        parent.find('.error-msg').remove();

                        if (error.text()) {
                            parent.addClass('error');
                            element.after('<p class="error-msg">' + error.text() + '</p>');
                        } else {
                            parent.removeClass('error');
                        }
                    };
                }
            });
        },
        submitForm = function (formId) {
            var form = $("#" + formprefix + formId);

            form.submit();
            //form.validate();
            //if (form.valid()) {
            //    //BlockUI();
            //    form.submit();
            //}
        },
        setAction = function (formId, actionid) {
            if (formId) {
                var prefix = formprefix;
                if (formId.startsWith(formprefix)) {
                    prefix = '';
                }
                var form = $("#" + prefix + formId);
                //var tempElement = $("<input type='hidden'/>");
                //tempElement.attr("name", actionid).val(actionid);
                //tempElement.attr("id", actionid).val("ActionId");
                //console.log(tempElement);
                //tempElement.appendTo(form);
                var action = form.find("#" + actionid).click();
                //form.submit();
            }
        },
        setFormFieldValueAndSubmit = function (formId, fieldId, value) {



            var form = $("#" + formprefix + formId);


            if ($("[id='" + fieldId + "']").length > 1) {
                form.find("#" + fieldId).val(value);
            }
            else {
                $("#" + fieldId).val(value);
            }

            form.submit();
            //form.validate();
            //if (form.valid()) {
            //    //BlockUI();
            //    form.submit();
            //}
        },
        setFormFieldsValuesAndSubmit = function (formId, keyValueArray) {
            var form = $('#' + formprefix + formId);
            for (var i = 0; i < keyValueArray.length; i++) {
                form.find('#' + keyValueArray[i].Key).val(keyValueArray[i].Value);
            }
            form.submit();
        },
        setFormFieldValue = function (formId, fieldId, value) {
            var form = $("#" + formprefix + formId);
            //$("#" + fieldId).val(value);
            form.find("#" + fieldId).val(value);
        },
        applySorting = function (sortColumn, sortAscending, formId) {
            var form = $("#" + formprefix + formId);
            form.find("#Sort").val(sortColumn);
            form.find("#Smer").val(sortAscending);
            //BlockUI();
            form.submit();
        },
        doPost = function (url, params) {
            var $div = $("<div>").css("display", "none");
            var $form = $("<form method='POST'/>").attr("action", url);
            $.each(params, function (name, value) {
                $("<input type='hidden'>")
                    .attr("name", name)
                    .attr("value", value)
                    .appendTo($form);
            });
            $form.appendTo($div);
            $div.appendTo("body");
            $form.submit();
        };
    return {
        submit: submitForm,
        submitForm: setFormFieldValueAndSubmit,
        submitFormsMultiFields: setFormFieldsValuesAndSubmit,
        setFieldValue: setFormFieldValue,
        doPost: doPost,
        applySorting: applySorting,
        setAction: setAction,
        Init: init
    };
};

function FormSubmit(actionid) {
    setTimeout(function () {
        var form = $('form');
        var tempElement = $("<input type='hidden'/>");
        tempElement.attr("name", actionid).val(actionid);
        tempElement.attr("id", actionid).val("ActionId");
        tempElement.appendTo(form);
        //BlockUI();
        form.submit();
    }, 100);
}

DeWeb.AjaxForms = new function () {
    var realReplace = function (data, element) {
        var searchPrefix = "#";

        if (!$(searchPrefix + element).length && $("." + element).length) {
            searchPrefix = ".";
        }

        $(document).find(searchPrefix + element).replaceWith(data.responseText);
    };
    var onAjaxBegin = function (selector, xhr) {
        try {
            if (xhr) {
                if (window[selector + '_XmlHttpRequest']) {
                    var oldXhr = window[selector + '_XmlHttpRequest'];
                    if (oldXhr.readyState != 4) {
                        oldXhr.abort();
                    }
                }
                window[selector + '_XmlHttpRequest'] = xhr;
            }
        } catch (e) { }

        DeWeb.Ui.BlockElement(selector);
    };

    var onAjaxSuccess = function (selector) {
        DeWeb.Ui.UnBlockElement(selector);
    };

    var onAjaxFailure = function (selector) {
        DeWeb.Ui.UnBlockElement(selector);
    };

    var onAjaxComplete = function (element) {
        var searchPrefix = "#";

        if (!$(searchPrefix + element).length && $("." + element).length) {
            searchPrefix = ".";
        }
        DeWeb.LoadUtilities($(searchPrefix + element));
    };
    return {
        OnAjaxSuccess: onAjaxSuccess,
        OnAjaxFailure: onAjaxFailure,
        OnAjaxBegin: onAjaxBegin,
        OnAjaxComplete: onAjaxComplete,
        RealReplace: realReplace
    };
};

//On done typing!!!!!!!!!!!!!!!
; (function ($) {
    $.fn.extend({
        donetyping: function (callback, timeout) {
            timeout = timeout || 1e3; // 1 second default timeout
            var timeoutReference,
                doneTyping = function (el) {
                    if (!timeoutReference) return;
                    timeoutReference = null;
                    callback.call(el);
                };
            return this.each(function (i, el) {
                var $el = $(el);
                // Chrome Fix (Use keyup over keypress to detect backspace)
                // thank you @palerdot
                $el.is(':input') && $el.on('keyup keypress paste', function (e) {
                    // This catches the backspace button in chrome, but also prevents
                    // the event from triggering too preemptively. Without this line,
                    // using tab/shift+tab will make the focused element fire the callback.
                    if (e.type == 'keyup' && e.keyCode != 8) return;

                    // Check if timeout has been set. If it has, "reset" the clock and
                    // start over again.
                    if (timeoutReference) clearTimeout(timeoutReference);
                    timeoutReference = setTimeout(function () {
                        // if we made it here, our timeout has elapsed. Fire the
                        // callback
                        doneTyping(el);
                    }, timeout);
                }).on('blur', function () {
                    // If we can, fire the event since we're leaving the field
                    doneTyping(el);
                });
            });
        }
    });
})(jQuery);

DeWeb.Ui = new function () {
    var popupTypes = ['wide', 'narrow', 'side'];
    var hidePopup = function (afterHiding) {
        var $body = $('body');
        if ($body.hasClass('popup-open')) {
            for (var i = 0; i < popupTypes.length; i++) {
                var type = popupTypes[i];

                $body.removeClass('popup-open-' + type);
            }
            $body.removeClass('popup-open');
            $('.modal-container').fadeOut(500);
            $('.modal-inbox').fadeOut(500);
            $('.popup-box.active').fadeOut(500).removeClass('active');
            $('.side-popup.active').fadeOut(500).removeClass('active');

            $('.side-modal').fadeOut(500);
            $('.side-modal-popup.active').removeClass('active');

            if (isFunction(afterHiding)) {
                setTimeout(function () {
                    afterHiding();
                },
                    500);
            }
        } else {
            if (isFunction(afterHiding)) {
                setTimeout(function () {
                    afterHiding();
                },
                    500);
            }
        }
    };

    var showPopup = function (data, popupType) {

        var popup = '#popup-content';

        if (popupType) {
            popup = popup + "-" + popupType;
        }

        var $popup = $(popup);

        if ($popup.length) {
            hidePopup(function () {
                $('body').addClass('popup-open');
                $('body').addClass('popup-open-' + popupType);

                if (popupType === "wide") {
                    $('.modal-container').fadeIn(500);
                    $popup.fadeIn(500).addClass('active');
                    $popup.html(data);
                }

                if (popupType === "narrow") {
                    $('.modal-container').fadeIn(500);
                    $popup.fadeIn(500).addClass('active');
                    $popup.html(data);
                }

                if (popupType === "side") {
                    $popup.html(data);
                    $popup.addClass('active');
                    $popup.parents('.side-modal').addClass('active').fadeIn(300);
                }

                if ($(window).width() < 600) {
                    $('html, body').animate({
                        scrollTop: 0,
                    }, 500);
                }

                DeWeb.AjaxForms.OnAjaxComplete(popup.replace('#', ''));
            });;
        }
        else {
            console.log('no popup container!');
        }
    };
    var showNotification = function (notificationOptions) {
        var defaultOptions = {
            color: "green",
            iconClass: "icon-check-1",
            content: '',
            title: '',
            prependTo: '#main',
            id: 'current-notification',
            keepOthers: false,
            scrollToTop: true
        };
        var options = $.extend(defaultOptions, notificationOptions);

        if (!options.content) {
            return;
        }

        if (options.isFaulty) {
            options.color = 'red';
            options.iconClass = 'icon-alert-1';
        }

        if (!options.keepOthers) {
            clearNotifications();
        }
        var newNotification = $('#notification-template').html();
        newNotification = newNotification
            .replace('{color}', options.color)
            .replace('{icon-class}', options.iconClass)
            .replace('{notification-title}', options.title ? options.title : "")
            .replace('{notification-content}', $('<p>').html(options.content).html())
            .replace('{notification-id}', options.id ? options.id : "");

        $(options.prependTo).prepend(newNotification);

        var element = $('#' + options.id).slideDown(300);

        if (options.scrollToTop) {
            $('html, body').animate({ scrollTop: 0 }, 'slow');
        }

        DeWeb.LoadUtilities(element);
    };
    var clearNotifications = function () {
        $('.notification').slideUp(300, function () {
            $(this).remove();
        });
    };
    var blockUi = function () {
        $.blockUI({
            message: '<div class="cssload-container"><div class="cssload-speeding-wheel"></div></div>',
            css: { background: 'rgba(255, 255, 255, 0.9)', border: "none" },
            overlayCSS: { background: 'rgba(255, 255, 255, 0.9)', backgroundColor: 'rgba(255, 255, 255, 0.9)', }
        });
    };
    var unblockUi = function () {
        $.unblockUI();
    };
    var blockElement = function (selector) {
        var searchPrefix = "#";

        if (!$(searchPrefix + selector).length && $("." + selector).length) {
            searchPrefix = ".";
        }

        $(searchPrefix + selector).block({
            message: '<div class="cssload-container"><div class="cssload-speeding-wheel"></div></div>',
            css: { background: 'rgba(255, 255, 255, 0.9)', border: "none" },
            overlayCSS: { background: 'rgba(255, 255, 255, 0.9)', backgroundColor: 'rgba(255, 255, 255, 0.9)', }
        });
    };
    var unblockElement = function (selector) {
        var searchPrefix = "#";

        if (!$(searchPrefix + selector).length && $("." + selector).length) {
            searchPrefix = ".";
        }

        $(searchPrefix + selector).unblock();
    };
    return {
        ShowNotification: showNotification,
        ClearNotifications: clearNotifications,
        BlockUi: blockUi,
        UnblockUi: unblockUi,
        BlockElement: blockElement,
        UnBlockElement: unblockElement,
        ShowPopup: showPopup,
        HidePopup: hidePopup
    };
};
DeWeb.Pages = {};
DeWeb.Pages.TransactionsList = new function () {
    var _formId = '';
    var _statusFieldId = '';
    var $form = null;
    var $statusField = null;
    var init = function (formId, statusFieldId) {
        _formId = formId;
        _statusFieldId = statusFieldId;
        $form = $('#' + _formId);
        $statusField = $('#' + _statusFieldId);

        var TransactionList =
        {
            Id: "TransactionList",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        postForm();
                        break;

                }
            }
        };

        ebs.AddListener(TransactionList);
    };

    var postForm = function () {
        $form.submit();
    };
    var changeStatus = function (status) {
        $statusField.val(status);
        postForm();
    };
    return {
        Init: init,
        ChangeStatus: changeStatus
    };
};


function doGet(href, replaceContainerId, loadingElement) {
    onAjaxBegin(loadingElement);
    $.get(href).done(function (data) {
        if (data) {
            onAjaxSuccess(loadingElement);
            $('#' + replaceContainerId).html(data);
        } else {
            onAjaxFailure(loadingElement);
        }
    });
}
function ShowErrorDialog(dialogTitle, dialogMessage) {
    var kendoWindow = $("<div />").kendoWindow({
        title: dialogTitle,
        resizable: false,
        modal: true,
        width: 300
    });
    kendoWindow.data("kendoWindow")
        .content(dialogMessage)
        .center().open();
};

DeWeb.Functionalities = DeWeb.Functionalities || {};

DeWeb.Functionalities.Signalr = new function () {
    var connectionStates = ["connecting", "connected", "reconnecting", "disconnected"];

    var getState = function (state) {
        return connectionStates[state];
    }

    var startConnection = function (connection, ondone, onerror) {
        if (getState(connection.state) !== "connected") {
            connection.start()
                .done(function () {
                    console.log("connection started. Id=" + connection.id + ". Transport=" + connection.transport.name);
                    if (isFunction(ondone)) {
                        ondone(connection);
                    }
                })
                .fail(function (error) {
                    onerror(error);
                    console.log(error);
                });
        }
    }

    return {
        GetStateName: getState,
        StartConnection: startConnection
    }
}

DeWeb.Functionalities.SetHotkeys = function () {
    /*** EXTDE-419 Suppressing form submit when on text area to allow multiple lines on textarea. ***/
    /*** This part suppresses number of new lines in textarea based on data-max-lines (coalesced to 4 - most cases in SDD - if not present)!!! ***/
    $(document).keydown(function (e) {
        if ($(e.target).is("textarea")
            && (e.keyCode || e.which) == 13) {
            var lines = new String($(e.target).val() || '').split("\n").length;
            if (!$(e.target).data("max-lines"))
                $(e.target).data("max-lines", 4); // Coalesce to 4 max lines if data-max-lines not present.
            var maxLines = $(e.target).data("max-lines");
            if (lines === maxLines || lines > maxLines) { // The > condition is for misconfigured max-lines (e.g. 0 value) situations.
                e.stopPropagation();
                return false;
            } else {
                lines++;
            }
        }
    });
    $(document).keydown(function (e) {
        if (e.keyCode == 27) {
            if ($('body').hasClass('popup-open')) {
                DeWeb.Ui.HidePopup();
            }
        } else if (e.keyCode == 13) {
            if ($('body').hasClass('popup-open')) {
                var $popupForm = $('.popup-box.active').find('*[data-process-form="True"]');
                if ($popupForm.length) {
                    var $fwButton = $popupForm
                        .find('*[data-action-type="' + DeWeb.Enums.ButtonActionType.Forward + '"]');

                    if ($fwButton.length) {
                        e.preventDefault();
                        e.stopPropagation();
                        $fwButton.click();
                        return false;
                    }
                }
            } else {
                if ($('*[data-process-form="True"]').length) {
                    var fwButton = $('*[data-process-form="True"]')
                        .find('*[data-action-type="' + DeWeb.Enums.ButtonActionType.Forward + '"]');
                    /*** EXTDE-419 Suppressing form submit when on text area to allow multiple lines on textarea. ***/
                    /*** This part suppresses form submit on text area!!! ***/
                    if ($(e.target).is("textarea")) {
                        e.preventDefault();
                    }
                    /*** Continue as before. ***/
                    else if (fwButton.length) {
                        e.preventDefault();
                        e.stopPropagation();
                        fwButton.click();
                        return false;
                    }
                }
            }
        }
    });


};

DeWeb.Functionalities.AtmBranchMap = new function () {

    var selfLocationImg = {};
    var locationImg = {};
    var atmLocationImg = {};
    var atmAndBranchLocationImg = {};
    var currentFilter = {
        facilityType: "all",
        searchText: ''
    };
    var MAPTYPE = "";
    var map = {};
    var mainInfobox = {};
    var baseContentPath;
    var markers = [];
    var initMap = function (loadFromUrl, bPath, mapType, facilitiesJson) {
        baseContentPath = bPath;

        selfLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-4.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        locationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-2.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        atmLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-1.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        atmAndBranchLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-1.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        var map_canvas = {};
        if (mapType == "transfermap") {
            map_canvas = document.getElementById('map-canvas-small');

        }
        else {
            var map_canvas = document.getElementById('map-canvas');

        }


        var styles = [
            {
                "stylers": [
                    { "saturation": -100 }, { "lightness": -14 }, { "gamma": 0.73 }
                ]
            }
        ];

        if (mapType === "preloginatmbranch" || mapType === "transfermap") {
            styles = [
                { "featureType": "administrative.province", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "landscape", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 65 }, { "visibility": "on" }] }, { "featureType": "poi", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 51 }, { "visibility": "simplified" }] }, { "featureType": "road", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "road.arterial", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 30 }, { "visibility": "on" }] }, { "featureType": "road.local", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 40 }, { "visibility": "on" }] }, { "featureType": "transit", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "water", "elementType": "geometry", "stylers": [{ "hue": "#ffff00" }, { "lightness": -25 }, { "saturation": -97 }] }, { "featureType": "water", "elementType": "labels", "stylers": [{ "visibility": "on" }, { "lightness": -25 }, { "saturation": -100 }] }
            ];
        }

        if (mapType === "becomeaclientmap") {
            styles = [
                { "featureType": "administrative.province", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "landscape", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 65 }, { "visibility": "on" }] }, { "featureType": "poi", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 51 }, { "visibility": "simplified" }] }, { "featureType": "road", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "road.arterial", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 30 }, { "visibility": "on" }] }, { "featureType": "road.local", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 40 }, { "visibility": "on" }] }, { "featureType": "transit", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "water", "elementType": "geometry", "stylers": [{ "hue": "#ffff00" }, { "lightness": -25 }, { "saturation": -97 }] }, { "featureType": "water", "elementType": "labels", "stylers": [{ "visibility": "on" }, { "lightness": -25 }, { "saturation": -100 }] }
            ];
        }

        var groupByCoordinates = function (xs, key) {
            var items = [], base;
            $.each(xs, function (index, val) {
                if (val != null && val.coordinates != null) {
                    key = val['coordinates']['lat'] + "," + val['coordinates']['long'];
                    if (!items[key]) {
                        items[key] = 0;
                    }
                    items[key] += "," + val['id'];
                }

            });
            return items;
        };
        var getMixedFacilities = function (facilitiesJson, groupedFacilities) {
            var realfacilities = [];
            for (var i in groupedFacilities) {
                var groupstring = groupedFacilities[i];
                var groupedidexes = [];
                try {
                    groupedidexes = groupstring.split(',');
                }
                catch (exception) {
                    break;
                }
                if (groupedidexes.length != 0) {
                    groupedidexes.splice(0, 1);
                    var result = $.grep(facilitiesJson, function (e) { return e.id == groupedidexes[0]; });
                    result[0].kind = "branch";
                    realfacilities.push(result[0]);
                }
            }
            return realfacilities;
        }


        //infobox
        mainInfobox = new InfoBox({
            content: '',
            disableAutoPan: false,
            maxWidth: 200,
            pixelOffset: new google.maps.Size(20, -100),
            zIndex: null,
            boxStyle: {
                background: "",
                opacity: 1
            },
            closeBoxMargin: "10px 10px 0 0",
            closeBoxURL: baseContentPath + "img/icons/close.png",
            pane: "floatPane",
            enableEventPropagation: false,
            infoBoxClearance: new google.maps.Size(1, 1),
        });

        var geocodeLatLng = function (geocoder, map, latlng, callback) {
            geocoder.geocode({ 'location': latlng }, function (results, status) {
                if (status === google.maps.GeocoderStatus.OK) {
                    if (results[1]) {
                        callback(results);
                    } else {
                        console.log('No results found');
                    }
                } else {
                    console.log('Geocoder failed due to: ' + status);
                }
            });
        };
        var map_options = {
            /*** EXTDE-210 - set on Bucharest ***/
            center: new google.maps.LatLng(44.4325, 26.103889),

            zoom: 12,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: false,
            draggable: !("ontouchend" in document),
            styles: styles,
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_BOTTOM
            },
            mapTypeControlOptions: {
                position: google.maps.ControlPosition.BOTTOM_LEFT
            }
        };
        map = new google.maps.Map(map_canvas, map_options);
        map["fullscreen"] = false;
        map["infoBoxInView"] = false;
        map["infoBoxOpen"] = false;
        google.maps.event.addListener(map, 'bounds_changed', onBoundsChanged);
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var pos = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                //todo insert icon self
                if (mapType != "transfermap" || facilitiesJson == null) {
                    map.setCenter(pos);
                }

                var geocoder = new google.maps.Geocoder;
                geocodeLatLng(geocoder, map, pos, function (results) {
                    addMyMarker(results, selfLocationImg, pos);
                });
            }, function () {
                //handleLocationError(true, infoWindow, map.getCenter());
            });
        } else {
            // Browser doesn't support Geolocation
            //handleLocationError(false, infoWindow, map.getCenter());
        }

        getPosition();

        function lat(callback) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var lat = position.coords.latitude;
                var lon = position.coords.longitude;
                currentPosition = {
                    lat: lat, lng: lon
                };
                callback.call(null, lat, lon);
            }, function (error) {
                console.log("Something went wrong: ", error);
                var retposs = {
                    lat: 'Current +',
                    lng: 'Location'
                };
                facilities(retposs);
            });
        }

        function getPosition() {
            lat(function (latitude, longitude) {
                var retposs = {
                    lat: latitude,
                    lng: longitude
                };
                facilities(retposs);
            });
        }

        function facilities(retposs) {
            if (!facilitiesJson) {
                $.ajax({
                    type: "GET",
                    url: loadFromUrl,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var items = response;
                        var groupedFacilities = groupByCoordinates(items);
                        realfacilities = getMixedFacilities(items, groupedFacilities);
                        addBankMarkers(realfacilities, locationImg, retposs);
                    }
                });
            } else {
                var items = facilitiesJson;
                if (items.length == undefined) {
                    addPaymentGeo(items);
                }
                else {
                    var groupedFacilities = groupByCoordinates(items);
                    realfacilities = getMixedFacilities(items, groupedFacilities);
                    addBankMarkers(items, locationImg, retposs);
                }
            }
        }
    };

    function onBoundsChanged()
    {
        if (map.fullscreen &&
            (!(map.getDiv().firstChild.clientHeight == window.innerHeight) || !(map.getDiv().firstChild.clientWidth == window.innerWidth)))
        {
            map.fullscreen = false;
            if (map.infoBoxInView && map.infoBoxOpen) {
                map.setCenter(mainInfobox.position_);
                window.setTimeout(function () {
                    mainInfobox.panBox_();
                    updateinfoBoxInView(map);
                }, 500)
            }
        }

        else if (!map.fullscreen && map.getDiv().firstChild.clientHeight == window.innerHeight && map.getDiv().firstChild.clientWidth == window.innerWidth)
        {
            map.fullscreen = true;
            updateinfoBoxInView(map);
        }

        else
        {
            updateinfoBoxInView(map);
        }
        
    }

    function updateinfoBoxInView(map)
    {
        if (map.infoBoxOpen) {
            map.infoBoxInView = map.getBounds().contains(mainInfobox.position_);
        }
    }


    var addPaymentGeo = function (item) {
        newLocationInmg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-3.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        var position = new google.maps.LatLng(item.lat, item.long);
        var marker = new google.maps.Marker({
            position: position,
            icon: newLocationInmg,
            map: map,
        });
        markers.push(marker);
        map.setCenter(new google.maps.LatLng(item.lat, item.long));
    }
    var searchOperation = function (map, markersGmap) {

        google.maps.event.addListenerOnce(map, 'idle', function () {
            $("input[type=search]")
                .on("keyup",
                    function () {
                        var searchText = $(this).val().toLowerCase();
                        if (searchText === "") {
                            for (var i = 0; i < markersGmap.length; i++) {
                                markersGmap[i].marker.setVisible(true);

                            }
                            return;
                        }

                        var availablePins = [];

                        for (var index in markersGmap) {
                            var markerObj = markersGmap[index];

                            var name = "";
                            var address = "";

                            if (markerObj.name != undefined) {
                                name = markerObj.name.toLowerCase();
                            }
                            else {
                                continue;
                            }
                            if (markerObj.address != undefined) {
                                address = markerObj.address.toLowerCase();
                                availablePins.push(markerObj.address);
                            }
                            else {
                                continue;
                            }
                            if (name.indexOf(searchText) < 0 && address.indexOf(searchText) < 0) {

                                markerObj.marker.setVisible(false);
                                mainInfobox.close();


                            } else {

                                markerObj.marker.setVisible(true);
                            }
                        }
                        $(".pins-search").autocomplete({
                            source: availablePins
                        });
                    });

        });



    }
    var addBankMarkers = function (items, locationImg, retposs) {

        for (var i = 0; i < items.length; i++) {

            var item = items[i];
            if (item.coordinates == null || item.coordinates.long == null || item.coordinates.lat == null) {
                continue;
            }


            var position = new google.maps.LatLng(item.coordinates.lat, item.coordinates.long);
            var infoboxContent = getInfoBoxContent(item, retposs);

            var icon = locationImg;
            if (item.kind === "atm") {
                icon = atmLocationImg;
            }
            if (item.kind == "atm/branch") {
                icon = atmAndBranchLocationImg;
            }
            var markerDescription = {
                type: item.kind,
                address: formatAddressString(item),
                name: item.name,
                id: item.id
            };
            addMarker(map, icon, infoboxContent, position, markerDescription);
        }

        searchOperation(map, markers);
    };

    var addMyMarker = function (results, selfLocationImg, position) {

        var result = '';
        if (results[0] != null) {
            result = results[0];
        }
        var t = document.getElementById("infobox-template");
        var div = document.createElement("div");
        div.innerHTML = t.innerHTML;
        $(div).find(".link-to-map").remove();
        $(div).find(".details-transfer").remove();
        var infoboxTemplate = div.innerHTML;
        var content = infoboxTemplate.replace("{infobox-id}", "self")
            .replace("{location-title}", "Your location.")
            .replace("{location-info}", result.formatted_address);

        addMarker(map, selfLocationImg, content, position, { type: 'self' });
    };

    var addMarker = function (addtoMap, icon, infoboxContent, position, markerDescription) {
        var markerObj = {
            type: markerDescription.type,
            address: markerDescription.address,
            name: markerDescription.name,
            marker: new google.maps.Marker({
                position: position,
                map: addtoMap,
                icon: icon
            })
        };

        google.maps.event.addListener(markerObj.marker, 'click', function () {
            mainInfobox.close();
            mainInfobox.setContent(infoboxContent);
            mainInfobox.open(addtoMap, this);
            if (markerDescription.type != "self") {
                setTimeout(function () {
                    DeWeb.LoadUtilities($("#map-view"));
                }, 200);
            }

        });


        markers.push(markerObj);
    };
    var formatAddressString = function (facility) {
        var address = '';
        var facAddress = facility.address;
        if (facAddress == null) return address;

        if (facAddress.formatted != null) {
            address = facAddress.formatted;
        } else {
            if (facAddress.street != null) {
                address = (facAddress.street + " ") + (facAddress.locality);

            }
            else {
                return facAddress;
            }
        }

        if (facAddress.country != null) {
            address += "<br>" + facAddress.country;
        }
        return address;
    };

    var getInfoBoxContent = function (data, retposs) {
        var infoboxTemplate = $('#infobox-template').html();
        var content = infoboxTemplate.replace("{infobox-id}", data.id)
            .replace("{location-title}", data.name + " | " + data.kind)
            .replace("{location-info}", formatAddressString(data))
            .replace("{location-long}", data.coordinates.long)
            .replace("{location-lat}", data.coordinates.lat)
            .replace("{mylocation-lat}", retposs.lat)
            .replace("{mylocation-long}", retposs.lng)

        return content;
    };
    var handleLocationError = function (browserHasGeolocation, infoWindow, pos) {
        infoWindow.setPosition(pos);
        infoWindow.setContent(browserHasGeolocation ?
            'Error: The Geolocation service failed.' :
            'Error: Your browser doesn\'t support geolocation.');
    };

    var filterMap = function (filter) {
        if (filter && filter.facilityType) {
            currentFilter.facilityType = filter.facilityType;
        }

        if (filter && filter.searchText != null) {
            currentFilter.searchText = filter.searchText;
        }

        var performSearch = function (data, searchText) {
            if (!searchText || searchText === '' || data.Kind === 'self') {
                return true;
            }

            if (data.address) {
                if (data.address.toLowerCase().indexOf(searchText.toLowerCase()) > -1) {
                    return true;
                }
            }

            if (data.name) {
                if (data.name.toLowerCase().indexOf(searchText.toLowerCase()) > -1) {
                    return true;
                }
            }


            return false;
        };
        if (currentFilter) {
            for (var i = 0; i < markers.length; i++) {
                var markerObj = markers[i];
                if (currentFilter.facilityType !== "all" && markerObj.Kind !== currentFilter.facilityType && markerObj.Kind !== "self") {
                    markerObj.marker.setVisible(false);
                } else {
                    if (performSearch(markerObj, currentFilter.searchText)) {
                        markerObj.marker.setVisible(true);
                    } else {
                        markerObj.marker.setVisible(false);
                    }
                }
            }
        }
    };
    var getCurrentFilter = function () {
        return currentFilter;
    };
    return {
        Init: initMap,
        Filter: filterMap,
        CurrentFilter: getCurrentFilter
    };
};

//---------------------------------------------------------------------------------------
//---АccountTextBox
//---------------------------------------------------------------------------------------
function isAlpha(str) {
    return /[a-zA-Z]+/.test(str);
}
function FormatAccount(e) {

    var event = e ? e : window.event;
    var element = event.target || window.event.srcElement;
    if (!isAlpha(element.value)) {
        var arr = element.value.split('-');
        var str = new String();
        for (var i = 0; i < arr.length; i++) str += arr[i];
        if (str.length >= 5) {
            var bankPrefix = str.substr(0, 3);
            var rest = str.substring(3);
            var rest2 = new String();
            for (var i = 0; i < 15 - rest.length; i++) rest2 += "0";
            rest2 += rest;
            var account = bankPrefix + "-" + rest2.substr(0, 13) + "-" + rest2.substr(13, 2);
            element.value = account;
        }
    }
}
//Exchange currency slider
function ChangeExchangeAccount(data, dataAttr) {
    var sourceAccountHtmlId = "SourceAccount";//data.data(dataAttr);
    var hiddenInput = $('#' + sourceAccountHtmlId);
    var selAccountNumber = data.container.find('.swiper-slide-active').data('accountnumber');
    hiddenInput.val(selAccountNumber);
    if (typeof (OnChangeAccount) == "function") {
        OnChangeAccount(data, dataAttr);
    }
};
function ChangeExchangeAccountTo(data, dataAttr) {
    var sourceAccountHtmlId = "DestinationAccount"; //data.data(dataAttr);
    var hiddenInput = $('#' + sourceAccountHtmlId);
    var selAccountNumber = data.container.find('.swiper-slide-active').data('accountnumber');
    hiddenInput.val(selAccountNumber);
};
function FormatAccountTextBoxKeyPress2(e) {
    var CharEnabled = "0123456789n";
    var event = e ? e : window.event;
    var element = event.target || window.event.srcElement;
    event.returnValue = true;
    if (isAlpha(element.value)) return true;
    var pressedKey = String.fromCharCode(event.keyCode);

    if (event.keyCode == "8" || event.keyCode == "37" || event.keyCode == "39" ||
        event.keyCode == "46" || event.keyCode == "32" ||
        event.keyCode == "96" || event.keyCode == "97" || event.keyCode == "98" ||
        event.keyCode == "99" || event.keyCode == "100" || event.keyCode == "101" ||
        event.keyCode == "102" || event.keyCode == "103" || event.keyCode == "104" ||
        event.keyCode == "105" || event.keyCode == "16" || event.keyCode == "109") {
        event.returnValue = true;
        return true;
    }
    if (CharEnabled.indexOf(pressedKey) != -1) {
        event.returnValue = true;
        return true;
    }
    if (event.keyCode == "9") {
        var arr = element.value.split('-');
        var str = new String();
        for (var i = 0; i < arr.length; i++) str += arr[i];
        if (str.length >= 5) {
            var bankPrefix = str.substr(0, 3);
            var rest = str.substring(3);
            var rest2 = new String();
            for (var i = 0; i < 15 - rest.length; i++) rest2 += "0";
            rest2 += rest;
            var account = bankPrefix + "-" + rest2.substr(0, 13) + "-" + rest2.substr(13, 2);
            element.value = account;
        }
        event.returnValue = true;
        return true;
    }
}
//----------------------------------------------------------------------------------------------------
function FormatAccountTextBoxClick(e) {
    var event = e ? e : window.event;
    var element = event.target || window.event.srcElement;
    if (isAlpha(element.value)) return;
    var position = doGetCaretPosition(element);
    var indexes = GetDelimiterPositions(element.value, new Array('-', '.'));
    if (position > indexes[1] && position < element.value.length) {
        var substr = element.value.substring(indexes[0] + 1, indexes[1]);
        var posFirstUnderline = substr.indexOf("_");
        if (posFirstUnderline != -1) {
            var substr1 = substr.substring(0, posFirstUnderline);
            var substr2 = substr.substring(posFirstUnderline);
            var substr21 = new String();
            for (var i = 0; i < substr2.length; i++) {
                if (substr2.charAt(i) == '_') {
                    substr21 += "0";
                } else {
                    substr21 += substr2.charAt(i).toString();
                }
            }
            var implantString = substr21 + substr1;
            element.value =
                element.value.substring(0, indexes[0] + 1).concat(implantString,
                    element.value.substring(indexes[1]));
            setCaretPosition(element, position);
        }
    }
}
//---------------------------------------------------------------------------------------
function doGetCaretPosition(ctrl) {
    var CaretPos = 0; // IE Support
    if (document.selection) {
        ctrl.focus();
        var Sel = document.selection.createRange();
        Sel.moveStart('character', -ctrl.value.length);
        CaretPos = Sel.text.length;
    }
    // Firefox support
    else if (ctrl.selectionStart || ctrl.selectionStart == '0')
        CaretPos = ctrl.selectionStart;
    return (CaretPos);
}
//---------------------------------------------------------------------------------------
function setCaretPosition(ctrl, pos) {
    if (ctrl.setSelectionRange) {
        ctrl.focus();
        ctrl.setSelectionRange(pos, pos);
    }
    else if (ctrl.createTextRange) {
        var range = ctrl.createTextRange();
        range.collapse(true);
        range.moveEnd('character', pos);
        range.moveStart('character', pos);
        range.select();
    }
}
//---------------------------------------------------------------------------------------
function GetDelimiterPositions(account, delimiters) {
    var returnArray = new Array();
    for (var i = 0; i < account.length; i++) {
        for (var j = 0; j < delimiters.length; j++) {
            if (account.charAt(i) == delimiters[j]) {
                returnArray.push(i);
            }
        }
    }
    return returnArray;
}
//---------------------------------------------------------------------------------------
var opts = {
    lines: 13, // The number of lines to draw
    length: 13, // The length of each line
    width: 6, // The line thickness
    radius: 14, // The radius of the inner circle
    corners: 1, // Corner roundness (0..1)
    rotate: 0, // The rotation offset
    direction: 1, // 1: clockwise, -1: counterclockwise
    color: ['#00ACE7'], // #rgb or #rrggbb or array of colors
    speed: 1, // Rounds per second
    trail: 60, // Afterglow percentage
    shadow: false, // Whether to render a shadow
    hwaccel: false, // Whether to use hardware acceleration
    className: 'spinner', // The CSS class to assign to the spinner
    zIndex: 2e9, // The z-index (defaults to 2000000000)
    top: '50%', // Top position relative to parent
    left: '50%' // Left position relative to parent
};
//var spinner = new Spinner(opts).spin();
function UnblockUI() {

};

(function ($) { $.fn.collapsible = function (cmd, arg) { if (typeof cmd == 'string') { return $.fn.collapsible.dispatcher[cmd](this, arg); } return $.fn.collapsible.dispatcher['_create'](this, cmd); }; $.fn.collapsible.dispatcher = { _create: function (obj, arg) { createCollapsible(obj, arg); }, toggle: function (obj) { toggle(obj, loadOpts(obj)); return obj; }, open: function (obj) { open(obj, loadOpts(obj)); return obj; }, close: function (obj) { close(obj, loadOpts(obj)); return obj; }, collapsed: function (obj) { return collapsed(obj, loadOpts(obj)); } }; function createCollapsible(obj, options) { var opts = $.extend({}, $.fn.collapsible.defaults, options); var opened = new Array(); obj.each(function () { var $this = $(this); saveOpts($this, opts); if (opts.bind == 'mouseenter') { $this.bind('mouseenter', function (e) { e.preventDefault(); toggle($this, opts); }); } if (opts.bind == 'mouseover') { $this.bind('mouseover', function (e) { e.preventDefault(); toggle($this, opts); }); } if (opts.bind == 'click') { $this.bind('click', function (e) { e.preventDefault(); toggle($this, opts); }); } if (opts.bind == 'dblclick') { $this.bind('dblclick', function (e) { e.preventDefault(); toggle($this, opts); }); } id = $this.attr('id'); if (!useCookies(opts)) { dOpenIndex = inDefaultOpen(id, opts); if (dOpenIndex === false) { $this.addClass(opts.cssClose); $this.next().hide(); } else { $this.addClass(opts.cssOpen); $this.next().show(); opened.push(id); } } else { if (issetCookie(opts)) { cookieIndex = inCookie(id, opts); if (cookieIndex === false) { $this.addClass(opts.cssClose); $this.next().hide(); } else { $this.addClass(opts.cssOpen); $this.next().show(); opened.push(id); } } else { dOpenIndex = inDefaultOpen(id, opts); if (dOpenIndex === false) { $this.addClass(opts.cssClose); $this.next().hide(); } else { $this.addClass(opts.cssOpen); $this.next().show(); opened.push(id); } } } }); if (opened.length > 0 && useCookies(opts)) { setCookie(opened.toString(), opts); } else { setCookie('', opts); } return obj; }; function loadOpts($this) { return $this.data('collapsible-opts'); } function saveOpts($this, opts) { return $this.data('collapsible-opts', opts); } function collapsed($this, opts) { return $this.hasClass(opts.cssClose); } function close($this, opts) { $this.addClass(opts.cssClose).removeClass(opts.cssOpen); opts.animateOpen($this, opts); if (useCookies(opts)) { id = $this.attr('id'); unsetCookieId(id, opts); } } function open($this, opts) { $this.removeClass(opts.cssClose).addClass(opts.cssOpen); opts.animateClose($this, opts); if (useCookies(opts)) { id = $this.attr('id'); appendCookie(id, opts); } } function toggle($this, opts) { if (collapsed($this, opts)) { open($this, opts); } else { close($this, opts); } return false; } function useCookies(opts) { if (!$.cookie || opts.cookieName == '') { return false; } return true; } function appendCookie(value, opts) { if (!useCookies(opts)) { return false; } if (!issetCookie(opts)) { setCookie(value, opts); return true; } if (inCookie(value, opts)) { return true; } cookie = $.cookie(opts.cookieName); cookie = unescape(cookie); cookieArray = cookie.split(','); cookieArray.push(value); setCookie(cookieArray.toString(), opts); return true; } function unsetCookieId(value, opts) { if (!useCookies(opts)) { return false; } if (!issetCookie(opts)) { return true; } cookieIndex = inCookie(value, opts); if (cookieIndex === false) { return true; } cookie = $.cookie(opts.cookieName); cookie = unescape(cookie); cookieArray = cookie.split(','); cookieArray.splice(cookieIndex, 1); setCookie(cookieArray.toString(), opts); } function setCookie(value, opts) { if (!useCookies(opts)) { return false; } $.cookie(opts.cookieName, value, opts.cookieOptions); } function inCookie(value, opts) { if (!useCookies(opts)) { return false; } if (!issetCookie(opts)) { return false; } cookie = unescape($.cookie(opts.cookieName)); cookieArray = cookie.split(','); cookieIndex = $.inArray(value, cookieArray); if (cookieIndex == -1) { return false; } return cookieIndex; } function issetCookie(opts) { if (!useCookies(opts)) { return false; } if ($.cookie(opts.cookieName) == null) { return false; } return true; } function inDefaultOpen(id, opts) { defaultOpen = getDefaultOpen(opts); index = $.inArray(id, defaultOpen); if (index == -1) { return false; } return index; } function getDefaultOpen(opts) { defaultOpen = new Array(); if (opts.defaultOpen != '') { defaultOpen = opts.defaultOpen.split(','); } return defaultOpen; } $.fn.collapsible.defaults = { cssClose: 'collapse-close', cssOpen: 'collapse-open', cookieName: 'collapsible', cookieOptions: { path: '/', expires: 7, domain: '', secure: '' }, defaultOpen: '', speed: 'slow', bind: 'click', animateOpen: function (elem, opts) { elem.next().slideUp(opts.speed); }, animateClose: function (elem, opts) { elem.next().slideDown(opts.speed); } }; })(jQuery);


function UnblockUI() {
    EA.onReady();
};

function BlockUI() {

};


function UnblockElement(element) {
    try {
        $("#" + element).unblock();
    } catch (e) {
    }
}






function Redirect(url) {
    if (!url)
        return false;
    window.location = url;
}
//------------ string prototype ------------
String.prototype.toPhoneFormat = function (countryCode) {
    phoneNumber = this;
    if (phoneNumber[0] === "0") {
        phoneNumber = countryCode + phoneNumber.substr(1, phoneNumber.length);
    }

    return phoneNumber.toString();
};

function loadMainContent(url) {
    if (url == undefined) return;
    $('body').addClass('new-page-loading');
    setTimeout(function () {
        $.get(url + '?ajax=true').done(function (data) {
            $('.main-content').html(data);
            setTimeout(function () {
                $('body').removeClass('new-page-loading').addClass('new-page-loaded');
                EA.LoadMethod($('.page-content'));
            }, 200);
            setTimeout(function () {
                $('body').removeClass('new-page-loaded');
            }, 500);
        });
    }, 800);
}
function loadPopupWithMarkup(data, skipInitialization) {
    var d = 200;
    var html = $('html');
    var body = $('body');
    var bodyHeight = $('body').height();
    var modalHeight = $('.modal-container').height();
    var windowHeight = $(window).height();
    $('.modal-container').css({ 'min-height': 'auto' });
    showModal();

    if (typeof (skipInitialization) == "undefined") {
        skipInitialization = false;
    }



    $(EA.modalWrapper).transition({ 'opacity': '0', 'transform': 'translate3d(-300px,0,0)', delay: 0 }, 500, 'ease', function () {
        $(EA.modalWrapper).transition({ 'transform': 'translate3d(300px,0,0)', delay: 0 }, 0, 'ease', function () {

            setTimeout(function () {
                //$('.popup-box').removeClass('loading').addClass('showing');
                $('html, body').animate({ scrollTop: 0 }, 'slow');
                $('.popup-box').html(data);
                $('input').placeholder();
            }, d);

            setTimeout(function () { initializeOnLoadPopup(skipInitialization) }, d + 200);
            $(EA.modalWrapper).transition({ 'opacity': '1', 'transform': 'translate3d(0,0,0)', delay: 500 }, 500, 'ease', function () { });

        });
    });


}
function UpdateBreadCrumbs(button, isMain) {
    var $breadCrumbs = $('#bread-crumbs-navigation');
    if (typeof isMain === "undefined" || isMain == null) {
        isMain = false;
    }
    $breadCrumbs.find('li').each(function () {
        if (!$(this).hasClass('main-breadcrumb')) {
            $(this).remove();
        }
    });
    if (!isMain) {
        if (typeof button !== "undefined" && button != null) {
            $button = $(button);
            var href = $button.data('href') || $button.prop('href');
            var text = $button.data('title') || $button.text();
            $breadCrumbs.append("<li><a href='" + href + "'>" + text + "</a></li>");
        }
    }
    $data = $breadCrumbs.data("tips");
    $.get($data, function (data) {
        $(data).prependTo(".main-content").fadeIn("slow");
    });
}
//--------------------------------------------------------------------------------------------------------------
function ValidateTextBox(e) {
    var hasErrors = false;
    var error = "";
    var field = $(e.target);
    if (field.attr("data-val-required")) {
        if (!field.val()) {
            hasErrors = true;
            error += field.attr("data-val-required-message");
        }
    }

    if (field.attr("data-val-regex") && field.val()) {
        var regEx = new RegExp(field.attr("data-val-regex"));
        if (!regEx.test(field.val())) {
            hasErrors = true;
            error += field.attr("data-val-regex-message");
        }
    }

    if ((field.attr("data-val-min-length") || field.attr("data-val-max-length")) && field.val()) {
        var minLength = parseInt(field.attr("data-val-min-length"));
        var maxLength = parseInt(field.attr("data-val-max-length"));
        var length = field.val().length;
        if (length < minLength || length > maxLength) {
            hasErrors = true;
            error += field.attr("data-val-invalid-length-message");
        }
    }

    if (hasErrors) {
        var parentField = field.hasClass("k-input") ? field.parent().parent() : field.parent();
        var grandparentField = parentField.parent();
        if (!parentField.find(".error-icon").length) {
            $("<i class='error-icon'></i>").appendTo(parentField);
            var errorMsg = $("<div class='error-msg'></div>");
            errorMsg.appendTo(parentField);
            errorMsg.html("<p/>");
        }
        parentField.find(".error-msg").find("p").html(error);
        field.closest(".group").addClass('error-active');
    }
    else {
        field.closest(".group").removeClass('error-active');
        field.closest(".group").find('.error-icon').remove();
        field.closest(".group").find('.error-msg').remove();
    }
}
//--------------------------------------------------------------------------------------------------------------
function ValidateNumericBox(e) {
    var hasErrors = false;
    var error = "";
    var field = $(e.target);
    if (field.attr("data-val-required")) {
        if (!field.val()) {
            hasErrors = true;
            error += field.attr("data-val-required-message");
        }
    }
    if (hasErrors) {
        var parentField = field.parent();
        if (!parentField.find(".error-icon").length) {
            $("<i class='error-icon error-left-2'></i>").appendTo(parentField);
            $("<div class='error-msg error-left-2'><p>" + error + "</p></div>").appendTo(parentField);
        }
        else {
            parentField.find(".error-msg").html(error);
        }
        field.parent().parent().addClass('error-active');
    }
    else {
        field.parent().parent().removeClass('error-active');
        field.parent().parent().find('.error-icon').remove();
        field.parent().parent().find('.error-msg').remove();
    }
}


function UpdateCurrencyDropDown(currencyPickerId, currencyToExclude, aggregateCurrencies) {

}

//-------------------------------------------------------------------------------------------
function EventBrokerService() {
    this.Subscribers = new Array();
    this.RaiseEvent = function (sender, eventArgs) {
        for (var i = 0; i < that.Subscribers.length; i++) {
            var listener = that.Subscribers[i];
            if (listener && typeof (listener.AcceptEvent) == "function") {
                listener.AcceptEvent(sender, eventArgs);
            }

        }
    };
    this.AddListener = function (listener) {
        if (typeof (listener.Id) == "undefined") return;
        if (typeof (listener.AcceptEvent) != "function") return;
        for (var i = 0; i < that.Subscribers.length; i++) {
            if (listener.Id == that.Subscribers[i].Id)
                return;
        }
        that.Subscribers.push(listener);
    };
    var that = this;
}

//-------------------------------------------------------------------------------------------
var ebs = new EventBrokerService();
//-------------------------------------------------------------------------------------------

String.prototype.trunc =
    function (n, useWordBoundary) {
        var toLong = this.length > n,
            s_ = toLong ? this.substr(0, n - 1) : this;
        s_ = useWordBoundary && toLong ? s_.substr(0, s_.lastIndexOf(' ')) : s_;
        return toLong ? s_ + '&hellip;' : s_;
    };


//-------------------------------------------------------------------------------------------
function isNumber(evt) {
    evt = (evt) ? evt : window.event;
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
}
//-------------------------------------------------------------------------------------------
// ----- PJAX BROWSING HISTORY THIRD PARTY FRAMEWORK -----

//$(document).pjax('a[data-pjax]', '[data-pjax-container]', {
//    type: "GET",
//    push: true,
//    timeout: 20000
//});

//$(document).on('pjax:send', function (e) {
//    onAjaxBegin('main-content');
//});

//$(document).on('pjax:end', function (e) {
//    onAjaxSuccess('main-content');
//    UpdateBreadCrumbs(e.relatedTarget);
//});

//$(document).on('pjax:error', function (e) {
//    onAjaxFailure('main-content');
//    UpdateBreadCrumbs(e.relatedTarget);
//});

//$(document).on('pjax:timeout', function (event) {
//    event.preventDefault();
//});


//-------- Short UID for javascript ---------
function generateShortUID() {
    return ("0000" + (Math.random() * Math.pow(36, 4) << 0).toString(36)).slice(-4);
}
//--------- Reference number keypress handler --------------
function OnReferenceNumberKeyPress(e) {
    //alert(e.which);
    var a = [];
    var k = e.which;
    for (i = 48; i < 58; i++)
        a.push(i);
    for (i = 65; i <= 90; i++)
        a.push(i);
    for (i = 97; i <= 122; i++)
        a.push(i);
    a.push(45);
    a.push(8);
    a.push(0);
    if (!($.inArray(k, a) >= 0))
        e.preventDefault();
}
//--------- Reference number keypress handler --------------

var DeWebUtilities = {};


DeWeb.Ui.Dashboard = new function () {
    var _controller = "Home";
    var _baseUri = '';
    var _saveAction = 'SaveLayout';
    var _resetAction = 'ResetLayout';
    var init = function (baseUri) {
        _baseUri = baseUri;
        console.log('initiated');
        $('#reset-layout').on('click', function () {
            DeWeb.Ui.BlockUi();
            resetLayout();
        });

        $('.remove-widget').on('click', function () {
            var $this = $(this);

            var widget = $this.parents('li.widget');
            if (widget) {
                removeWidget(widget);
            }
        });
        $(".container .sortable-widgets-container").on("sortupdate", function (event, ui) {
            console.log('changed');
            saveLayout();
        });
    };
    var removeWidget = function ($widget) {
        $widget.remove();
        saveLayout();
        $(".container .sortable-widgets-container").sortable("refresh");
        $(".container .sortable-widgets-container").sortable("refreshPositions");
    };
    var resetLayout = function () {
        $.ajax(
            {
                type: "post",
                data: "ZoneId=1",
                url: _baseUri + _controller + '/' + _resetAction,
                success: function (e) {
                    location.reload();
                }
            }
        );
    };
    var saveLayout = function (reload) {
        var postDataArray = [];
        var i = 1;

        $(".container .sortable-widgets-container").find(".widget").each(function (index, entry) {
            var postDataItem = new Object();
            postDataItem["PartId"] = $(entry).attr("data-partid");
            postDataItem["ZoneId"] = $(entry).attr("data-zoneid");
            postDataItem["UserPartId"] = $(entry).attr("data-userpartid");
            postDataItem["PositionX"] = i;
            postDataItem["PartSizeId"] = $(entry).attr("data-part-size-id");
            if (postDataItem.PartId) {
                postDataArray.push(postDataItem);
                i++;
            }
        });

        $.ajax
            (
                {
                    type: "post",
                    url: _baseUri + _controller + '/' + _saveAction,
                    data: "Parts=" + JSON.stringify(postDataArray),
                    success: function () {
                        if (reload) {
                            location.reload();
                        }
                    }
                }
            );
    };
    return {
        Init: init,
        Save: saveLayout,
        Reset: resetLayout
    };
};

DeWeb.Utilities.resumePreviousProcess = function ($this) {
    var id = $this.data('id');
    var formId = $this.data('form-id');

    $this.on('click', function () {
        var $form = $('#form_' + formId);
        var updateSelector = $form.data('ajax-update');
        var $updateContent = $(updateSelector);

        DeWeb.AjaxForms.OnAjaxBegin(updateSelector.replace('#', ''));

        $.get($form.attr('action') + '?workitemid=' + id, function (data) {
            $updateContent.html(data);
            DeWeb.AjaxForms.OnAjaxSuccess(updateSelector.replace('#', ''));
            DeWeb.AjaxForms.OnAjaxComplete(updateSelector.replace('#', ''));
            DeWeb.Ui.ClearNotifications();
        });
    });
}
DeWeb.Utilities.discardPreviousProcess = function ($this) {
    var id = $this.data('id');
    $this.on('click', function () {
        $.get(window.location.origin + '/dialog/uiflow/deletesavedflow' + '?workItemId=' + id, function (data) {
            DeWeb.Ui.ClearNotifications();
        });
        window.location.reload();
    });
}
DeWeb.Events.updateAccountPicker = function (sa, item) {
    // Update of account picker field - cached in localStorage
    pickers = $(document).find('*[data-utility="accountPickerFormField"]');

    if (pickers.length) {
        accNo = $("#" + $(pickers[0]).data("field-id")).val();
        localStorage['account-picker-selected-account'] = accNo;
        localStorage['account-picker-filter'] = $($("[data-group=acc-filters].active")[0]).data("accountkind");
        localStorage['account-picker-selected-account'] = accNo;
    }
    else {
        dashboardpickers = $(document).find('*[data-utility="accountSlider"]');
        if (dashboardpickers.length) {
            accNo = $("#" + $(dashboardpickers[0]).data("accsel")).val();
            localStorage['account-picker-selected-account'] = accNo;
            localStorage['account-picker-filter'] = $($("[data-group=acc-filters].active")[0]).data("accountkind");
        }
    }


}
DeWeb.Utilities.executeStateActions = function ($this) {
    var stateActions = $this.data('state-actions');
    var customEvt = "";
    if (stateActions.length) {
        for (var i = 0; i < stateActions.length; i++) {
            var sa = stateActions[i];
            if (sa.StateActionType == DeWeb.Enums.StateActionTypeEnum.TRIGGERCUSTOMEVENT || sa.StateActionType == DeWeb.Enums.StateActionTypeEnum.REDIRECT) {
                customEvt = sa.CustomValue;
            }
            switch (sa.StateActionType) {
                case DeWeb.Enums.StateActionTypeEnum.REFRESHFILTER:
                    {
                        setTimeout(function () {
                            var $filters = $(document).find('*[data-filter-form="True"]');
                            if ($filters.length) {
                                $filters.each(function (e) {
                                    var $that = $(this);
                                    $that.submit();
                                });
                            }
                        }, sa.DelayInMs);

                        break;
                    }
                case DeWeb.Enums.StateActionTypeEnum.REFRESHCURRENTPAGE:
                    {
                        setTimeout(function () {
                            window.location.reload();
                        }, sa.DelayInMs);

                        break;
                    }
                case DeWeb.Enums.StateActionTypeEnum.REDIRECT:
                    {
                        setTimeout(function () {
                            window.location = sa.CustomValue;
                        },
                            sa.DelayInMs);

                        break;
                    }
                case DeWeb.Enums.StateActionTypeEnum.TRIGGERCUSTOMEVENT:
                    {
                        setTimeout(function () {
                            var event = DeWeb.Events[customEvt];
                            console.log(sa.CustomValue);
                            if (event) {
                                if (isFunction(event)) {
                                    event(sa, $this);
                                }
                            }
                        }, sa.DelayInMs);
                        break;
                    }
                case DeWeb.Enums.StateActionTypeEnum.SUBMITCUSTOMFORM:
                    {
                        setTimeout(function () {
                            var $submittingForm = $('#' + sa.CustomValue);
                            if (!$submittingForm.length) {
                                $submittingForm = $('#form_' + sa.CustomValue);
                            }

                            if (!$submittingForm.length) {
                                $submittingForm.submit();
                            }
                        }, sa.DelayInMs);

                        break;
                    }
                case DeWeb.Enums.StateActionTypeEnum.CLOSEPOPUP:
                    {
                        setTimeout(function () {
                            DeWeb.Ui.HidePopup();
                        }, sa.DelayInMs);

                        break;
                    }
                default:
                    {
                        break;
                    }
            }
        }
    }
};

DeWeb.Utilities.processMessages = function ($this) {
    var title = $this.data('title');
    var faulty = $this.data('is-faulty');
    var messages = $this.data('messages');
    var messageType = $this.data('message-type');
    var customRender = $this.data('custom-render');
    var placement = $this.data('placement');

    var messagesArray = messages.split(',');

    if (messagesArray.length) {
        for (var i = 0; i < messagesArray.length; i++) {
            if (messagesArray[i]) {
                var options = {
                    isFaulty: faulty,
                    title: title,
                    content: messagesArray[i],
                    displayType: messageType,
                    placement: placement
                };

                if (!customRender) {
                    DeWeb.Ui.ShowNotification(options);
                } else {
                    DeWeb.Events[customRender](options);
                }
            }
        }
    }
}

DeWeb.Utilities.subProcessManager = function ($this) {
    var subProcessInfo = $this.data('subprocess-info');
    var subProcesses = $this.data('subprocesses');
    var refreshContent = DeWeb.Config.DefaultContainer;
    var subProcessHref = $this.data('subprocess-href');
    var returnUrl = $this.data('return-url');
    var parentContainer = DeWeb.Enums.UiContentPlacementEnum.props[DeWeb.Enums.UiContentPlacementEnum[$this.data('parent-placement').toUpperCase()]].container
    var subProcessType = DeWeb.Enums.SubProcessTypeEnum.INLINE;

    // added to disable multiple click on continue button and starting authorization process again
    if (subProcessHref.indexOf("Authorization") != -1) {
        var formID = $this.data('form-id');
        var continueBtn = $("#form_" + formID).find("[data-action-type='3']");
        if (continueBtn) {
            continueBtn.prop('disabled', true);
        }
    }

    if (subProcesses) {
        var subProcess = subProcesses.firstMatch(function (elem) { return elem.StartNow === true });

        if (subProcess) {
            if (subProcess.ContainerId) {
                refreshContent = subProcess.ContainerId;
            } else {
                refreshContent = DeWeb.Enums.UiContentPlacementEnum.props[subProcess.Placement].container;
            }

            DeWeb.AjaxForms.OnAjaxBegin(refreshContent);
            try {
                DeWeb.Ui.BlockElement(parentContainer);
                $(document).on("subprocessStarted", function () {
                    DeWeb.Ui.UnBlockElement(parentContainer);
                });
            } catch (e) {
                console.log(e)
            }

            if (subProcess.Type === DeWeb.Enums.SubProcessTypeEnum.POPUP) {
                var popupSize = "narrow";
                if (subProcess.Placement === DeWeb.Enums.UiContentPlacementEnum.POPUPWIDE) {
                    popupSize = "wide";
                }
                //
                if (subProcess.Placement === DeWeb.Enums.UiContentPlacementEnum.POPUPSIDE) {
                    popupSize = "side";
                }
                $.get(subProcessHref, function (data) {
                    DeWeb.Ui.ShowPopup(data, popupSize, subProcess.Style);
                    $(document).trigger("subprocessStarted");
                });

            } else if (subProcess.Type === DeWeb.Enums.SubProcessTypeEnum.REDIRECT) {
                window.location = subProcessHref;
                DeWeb.AjaxForms.OnAjaxComplete(refreshContent);
            } else {
                $.get(subProcessHref, function (data) {
                    $("#" + refreshContent).html(data);
                    DeWeb.AjaxForms.OnAjaxComplete(refreshContent);
                });
            }
        }
    }

    if (subProcessInfo && subProcessInfo.ParentProcessInformed && subProcessInfo.ReportToProcess) {
        if (subProcessInfo.ParentPlacement === DeWeb.Enums.UiContentPlacementEnum.INLINE) {
            $.get(subProcessInfo.ReturnUrl,
                function (data) {
                    $('#' + subProcessInfo.ParentContainerId).html(data);
                    DeWeb.Ui.HidePopup();
                    DeWeb.AjaxForms.OnAjaxComplete(subProcessInfo.ParentContainerId);
                });
        } else {
            var parentPopupSize = "narrow";
            if (subProcessInfo.ParentPlacement === DeWeb.Enums.UiContentPlacementEnum.POPUPWIDE) {
                parentPopupSize = "wide";
            }

            $.get(subProcessInfo.ReturnUrl, function (data) {
                DeWeb.Ui.ShowPopup(data, parentPopupSize);
            });
        }
    }
}

DeWeb.Utilities.ddSelect = function ($this) {
    var trigger = $this;
    var firstTimeChange = true;

    trigger.ddslick({
        onSelected: function (data) {
            var name = $(trigger).attr('name');
            var select = "input[name=" + name + "]";
            var hidden = $(select);

            if (hidden.length > 0) {
                if (!firstTimeChange) {
                    hidden.trigger('change');
                }
                firstTimeChange = false;
            }
        }
    });

};

DeWeb.Utilities.triggerhints = function ($this) {
    var introId = $this.data('hint-id');
    $this.on('click', function () {
        DeWeb.Functionalities.StartHints(introId);
    });
}
DeWeb.Utilities.triggerhintsforicon = function ($this) {
    $('.menu-btn').click(function () {
        $('.profile-bar-side a').toggle();
        e.preventDefault();
    });
    $(window).bind("resize", function () {
        console.log($(this).width())
        if ($(this).width() < 1201) {
            $('.profile-bar-side a').removeClass('showmenu')
        }
        else {
            $('.profile-bar-side a').addClass('showmenu')
        }
    })
    //var introId = $this.data('hint-id');
    //$this.on('click', function () {
    //    DeWeb.Functionalities.StartHints(introId);
    //});
}
DeWeb.Utilities.formInit = function ($this) {
    $(document).on('initial-utilities-loaded', function () {
        DeWeb.Functionalities.PrepareHints($this);
        //DeWeb.Functionalities.StartHints($this.attr('id'));
    });
}

DeWeb.Functionalities.PrepareHints = function ($form) {
    var steps = [];
    var intro = introJs();

    $form.find('.field-hint').each(function () {
        var $fh = $(this);
        var forField = $fh.data('for-field');
        var hintText = $fh.data('hint');
        var position = $fh.data('position');

        if (!position) {
            position = null;
        }

        steps.push({
            element: '#' + forField,
            intro: hintText,
            position: position
        });
    });

    intro.setOptions({
        steps: steps
    });




    var hint = {
        IntroId: $form.attr('id'),
        IntroJs: intro
    }

    DeWeb.Intros.push(hint);
};


DeWeb.Functionalities.StartHints = function (hintId) {
    if (DeWeb.Intros && DeWeb.Intros.length) {
        for (var i = 0; i < DeWeb.Intros.length; i++) {
            var dwIntro = DeWeb.Intros[i];
            if (hintId) {
                if (dwIntro.IntroId === hintId) {
                    dwIntro.IntroJs.start();
                    break;
                }
            } else {
                dwIntro.IntroJs.start();
            }
        }
    }
};

DeWeb.Utilities.tabPicker = function ($this) {
    var $field = $('#' + $this.data('field-id'));

    $this.find('a').on('click', function () {
        $this.find('li').each(function () {
            $(this).removeClass('active');
        });

        $(this).parent('li').addClass('active');

        $field.val($(this).data('value'));

        var $form = $field.parents('form');
        $form.submit();
    });
}



DeWeb.Utilities.popupFromHtml = function ($this) {
    var pType = $this.data('popup-type');
    var contentContainerId = $this.data('content-container-id');
    if (!pType) {
        pType = 'wide';
    }

    $this.on('click', function (evt) {

        evt.preventDefault();
        DeWeb.Ui.ShowPopup($('#' + contentContainerId).html(), pType);
    });
}

DeWeb.Utilities.popupFromLink = function ($this) {
    $this.css('cursor', 'pointer');
    var pHref = $this.data('href');
    var pType = $this.data('popup-type');
    if (!pType) {
        pType = 'wide';
    }
    //if (pType == "inline") {
    //    window.location = pHref;
    //}
    $this.on('click', function (evt) {
        evt.preventDefault();
        $.get($this.data('href'), function (data) {
            DeWeb.Ui.ShowPopup(data, pType);
        });
    });
}

DeWeb.Utilities.showMorePaging = function ($this)
{
    var defaultPageSize = 5;
    var $pageSizeField = $('#' + $this.data('pagesize-id'));
    var $pageNumberField = $('#' + $this.data('pagenumber-id'));
    var $forms = $this.parents().find('form');
    var $form = null;
    var showMore = $this.data('show-more');
    var totalCount = parseInt($this.data('total-count'));
    var pageNumber = parseInt($pageNumberField.val());
    var pageSize = parseInt($pageSizeField.val());

    if (isNaN(pageSize)) {
        pageSize = defaultPageSize;
    }
    console.log(pageSize);
    console.log(totalCount);


    $forms.each(function (e) {
        var formId = $(this).prop('id');
        //if (formId.startsWith('form_')) {
        if (formId.startsWith('form_') || formId.startsWith('filter_'))
        {
            $form = $(this);
            return;
        }
    });
    $form.off('submit').on('submit', function () {
        if ($(this).attr('data-showing-more')) {

            var dateFrom = $form.find("[name=DateFrom_ID]").val();
            return true;
        }

        $pageSizeField.val(defaultPageSize);

        return true;
    });

    $this.off('click');

    if (pageSize < totalCount) {
        $this.on('click', function () {
            var toShow = pageSize + parseInt(showMore);
            $pageSizeField.val(toShow);
            if ($form.find("[name=PageSize]").length >= 1) {
                $("[name=PageSize]").each(function () { $(this).val(toShow); });
            }
            $form.attr('data-showing-more', true);

            var $sortByField = $('#SortBy_ID');
            var $sortOrderField = $('#SortOrder_ID');
            var currentSort = $sortByField.val();
            var currentOrder = $sortOrderField.val();

            $form.find("[name=SortBy_ID]").val(currentSort);
            $form.find("[name=SortOrder_ID]").val(currentOrder);
            $form.submit();

            if (toShow > totalCount) {
                $this.hide();
            }
        });
    } else {
        $this.hide();
    }
}

DeWeb.Utilities.openPopupFromLink = function ($this) {
    alert('USE "popupFromLink" utility!');
    // USE "popupFromLink" utility!


    //$this.click(function (e) {
    //    e.preventDefault();
    //    var width = "narrow";
    //    var dataWidth = $(this).data('popup-type');
    //    if (dataWidth) {
    //        width = dataWidth;
    //    }

    //    var popupSelector = '#popup-content-' + width;

    //    var href = $(this).data('href');
    //    $.get(href, function (data) {
    //        if (!$('body').hasClass('popup-open')) {
    //            $('body').addClass('popup-open');
    //            $('.modal-container').fadeIn(500);
    //            $(popupSelector).html(data);
    //            $(popupSelector).fadeIn(500).addClass('active');
    //        } else {
    //            $(popupSelector).fadeOut(500).removeClass('active');
    //            $(popupSelector).fadeIn(500).addClass('active');
    //        }
    //        DeWeb.AjaxForms.OnAjaxComplete(popupSelector.replace("#", ""));
    //    });
    //});
};

DeWeb.Utilities.openSidePopupById = function ($this) {
    alert('USE "popupFromHtml" utility!');
    // USE "popupFromHtml" utility!


    //$this.click(function (e) {
    //    e.preventDefault();
    //    var href = $(this).data('href');
    //    var popupId = $(this).data('popup-id');
    //    var popupSelector = '#' + popupId;
    //    $.get(href, function (data) {
    //        if (!$('body').hasClass(popupId + '-open')) {
    //            $('body').addClass(popupId + '-open');
    //            $(popupSelector).fadeIn(500);
    //            $(popupSelector).html(data);
    //            var inboxContent = $(popupSelector).find('.side-popup').first();
    //            $(popupSelector).find('.side-popup').first().fadeIn(500).addClass('active');
    //        } else {
    //            $(popupSelector).fadeOut(500).removeClass('active');
    //            $(popupSelector).fadeIn(500).addClass('active');
    //        }

    //        if ($(window).width() < 600) {
    //            $('html, body').animate({
    //                scrollTop: 0,
    //            }, 500);
    //        }
    //    });
    //});
};

DeWeb.Utilities.accountViews = function ($this) {

    var listItem = $('.list-item .inner');

    $this.click(function () {
        var tabId = $(this).data('tab');
        if ($(this).data("tab") == "2") {
            $("[data-method=arrows]").hide();
        } else {
            $("[data-method=arrows]").show();
        }

        if (!$(this).hasClass('active')) {
            $(this).addClass('active').siblings().removeClass('active');
            $('.account-tab.active').removeClass('active');
            $('.account-tab.tab-' + $(this).addClass('active').siblings().data("tab")).css('display', 'none');

            setTimeout(function () {
                $('.account-tab.tab-' + tabId).addClass('active');
                $('.account-tab.tab-' + tabId).css('display', 'block');
            }, 500);
        }
    });

};
DeWeb.Utilities.accountSlider = function ($this) {
    //Change Account Transactions
    var AccountPicker =
    {
        Id: "AccountPicker",
        ChangeAccount: function (account, currentIndex, kind) {
            ebs.RaiseEvent(AccountPicker, { CommandName: 'AccountChanged', Account: account, Kind: kind });
        }
    };
    ebs.AddListener(AccountPicker);


    var ViewChangedCatch =
    {
        Id: "ViewChangedCatchId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'ViewChanged':
                    if (args.ViewName == "slider") {
                        deinit(args.Account, args.Kind);
                    }
                    break;
            }
        }
    };

    $(document).ready(function () {
        ebs.AddListener(ViewChangedCatch);

    });



    //Variables
    var slider = $this,
        wrap = slider.parent(),
        slides = slider.find('.slide');
    var initialize = slides;
    var $accFilters = $("[data-group=acc-filters]");
    var $selectedAccountField = $("#" + $this.data("accsel"));
    //Functions
    var slideInFocus = function (slides) {
        var selectedSlide = $("#selected-account").val();
        var focus = 0;
        if (selectedSlide == undefined || selectedSlide == "") {
            focus = 1;
        }
        if (slides.length < 2) {
            focus = 0;
        }
        else {
            for (var i = 0; i < slides.length; i++) { 
                if (slides.eq(i).data("accno") == selectedSlide) {
                    focus = i;
                    break;
                }
            }
        }

        return focus;
    };

    var slideInFocusOther = function (slides) { //need to make 2nd in order to work on Internet Explorer
        var selectedSlide = $("#selected-account").val();
        var focus = 0;
        if (selectedSlide == undefined || selectedSlide == "") {
            focus = 1;
        }
        if (slides.length < 2) {
            focus = 0;
        }
        else {
            for (var i = 0; i < slides.length; i++) {
                if (slides[i].dataset == undefined && slides[i].data("accno") == selectedSlide) {
                    focus = i;
                    break;
                }
            }
        }
        return focus;
    };
    
    var getSlickSettings = function (focusSlide) {
        return {
            centerMode: true,
            slidesToShow: 1,
            initialSlide: focusSlide,
            arrows: false,
            variableWidth: true,
            dots: true,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 480,
                    settings: {
                        centerPadding: '50px'
                    }
                }
            ]
        }
    };
    var focusSlide = slideInFocus(slides);

    var deinit = function (acc, kind) {
        var $mainSlider = $this;
        $mainSlider.slick('unslick');
        var slides = $mainSlider.children();
        if (acc != undefined && acc != null) {
            var accs;
            var count;
            if (slides.length > 1) {
                for (var i = 0; i < slides.length; i++) {
                    if (slides.eq(i).data("acckind") == kind && slides.eq(i).data("accno") == acc) {
                        $mainSlider.slick(getSlickSettings(i));
                        DeWeb.LoadUtilities($mainSlider);
                        $selectedAccountField.val(acc);
                        AccountPicker.ChangeAccount(acc, i, kind);
                        break;
                    }
                }
            }
            else {
                $mainSlider.slick(getSlickSettings(0));
                DeWeb.LoadUtilities($mainSlider);
                AccountPicker.ChangeAccount($selectedAccountField.val(), slides.length, kind);
            }
        }
        else if (slides.length == 1) {
            $mainSlider.slick(getSlickSettings(0));
            DeWeb.LoadUtilities($mainSlider);
            AccountPicker.ChangeAccount($selectedAccountField.val(), 0, kind);
        }
        else {
            $mainSlider.slick(getSlickSettings(1));
            DeWeb.LoadUtilities($mainSlider);
            AccountPicker.ChangeAccount($selectedAccountField.val(), 1, kind);
        }
    }

    var filterSlides = function (acckind) {
        //Variables
        var currentSlider = [];
        var $mainSlider = $this;
        var noFilter = (acckind.length === 1 && acckind[0] === "");
        //Functions 
        var addSlide = function ($obj) {
            $mainSlider.slick('slickAdd', $obj);
            currentSlider.push($obj);
        };
        var removeSlide = function ($obj) {
            $mainSlider.slick('slickRemove', $(".slide").index($mainSlider.children().find("[data-accno=" + escapeAccountChars($obj.data("accno")) + "]")));

        };
        //Filter
        initialize.each(function () {
            var isDebitCard = $(this).data("acckind") === "debit-card";
            var isKind = acckind.indexOf($(this).data("acckind")) > -1;
            if ((noFilter && !isDebitCard) || (!noFilter && isKind)) {
                addSlide($(this));
            }
            if ((noFilter && isDebitCard) || (!noFilter && !isKind)) {
                removeSlide($(this));
            }
        });

        var focus = slideInFocusOther(currentSlider);
        //If cards
        //if (acckind.indexOf("credit-card-account") > -1) {
        //    $("[data-text-for=card]").css("display", "block");
        //    $("[data-text-for=credit-account]").css('display', 'none');
        //} else {
        //    $("[data-text-for=card]").css("display", "none");
        //    $("[data-text-for=credit-account]").css('display', 'block');
        //}
        //Slick-unslick-loadUtilities
        $selectedAccountField.val($(currentSlider[focus]).data("accountnumber"));
        $mainSlider.slick('unslick');
        $mainSlider.slick(getSlickSettings(focus));
        DeWeb.LoadUtilities($mainSlider);
        AccountPicker.ChangeAccount($selectedAccountField.val(), focus);
    };
    //Slick
    $selectedAccountField.val($(slides[focusSlide]).data("accountnumber"));
    slider.slick(getSlickSettings(focusSlide));
    //Listeners
    $(slider).on('afterChange', function (event, slick, currentSlide) {
        var accSlide = $(slick.$slides[currentSlide]);
        //var selectedAccount = accSlide.data("accountnumber");
        var selectedAccount = accSlide.data("accno");
        var kind = accSlide.data("acckind");
        AccountPicker.ChangeAccount(selectedAccount, currentSlide, kind);
    });
    $('.slider-button-prev').click(function () {
        slider.slick('slickPrev');
    });
    $('.slider-button-next').click(function () {
        slider.slick('slickNext');
    });
    $accFilters.on("click", function () {
        $(this).siblings().removeClass();
        $(this).addClass("active");
        filterSlides($(this).data("accountkind").split(','));
    });
    //On load
    //$this.show();
    // open appropriate account picker for reatil/corporate user
    $('ul.list-options-side').find($(".active")).click();
    AccountPicker.ChangeAccount($("#selected-account").val());
    //   $("#all-account-types").trigger("click");
};
//FORM FIELDS

DeWeb.Utilities.accountPickerFormField = function ($this) {
    var resolveViewType = function () {
        if ($("#ViewType_ID").length > 0) {

            $("#ViewType_ID").val("list-view");
            $("[name=PageSize]").each(function () { $(this).val('10'); });

        }
    };
    var AccountPicker =
    {
        Id: "AccountPicker",
        ChangeAccount: function (account, currentSlide) {
            //For Transaction Post Form
            
            var $selectedSlide = $(".slide[data-slick-index=" + currentSlide + "]");

            resolveViewType();
            
            if ($selectedSlide.data("cardnumber") != undefined && $selectedSlide.data("cardnumber") != "") {
                $("[name=Accounts_ID]").val($selectedSlide.data("accountnumber"));
                $("[name=Cards_ID]").val($selectedSlide.data("cardnumber"));
                $("[name=CardSettlementAccountId]").val($selectedSlide.data("accountnumber"));
            } else {
                $("[name=Cards_ID]").val("");

            }
            //if ($selectedSlide.data("acckind") === "debit-card") {
            //
            //    account = $selectedSlide.data("accno");
            //
            //}
            account = escapeAccountChars(account);
            var accSlide = $(".slide[data-accountnumber=" + account + "]");
            var currencyCode = accSlide.data("currency");
            var kind = accSlide.data("acckind");
            ebs.RaiseEvent(AccountPicker, {
                CommandName: 'AccountChanged',
                Account: account.replaceAll('\\', ''),
                Currency: currencyCode,
                AccField: $this.attr("id"),
                Kind: kind
            });
        },
        ChangeCurrency: function (account_curr) {
            ebs.RaiseEvent(AccountPicker,
                {
                    CommandName: 'CurrencyChanged',
                    Currency: account_curr,
                    AccField: $this.attr("id")
                });
        }
    };
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            swipeToSlide: true,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }

    
    ebs.AddListener(AccountPicker);
    var fieldId = $this.data('field-id');

    var slider = $this,
        wrap = slider.parent(),
        slides = slider.find('.slide');
    var i = -1;
    var selected = 2;
    slides.each(function () {
        i = i + 1;
        var fieldVal = $("#" + $this.data("field-id")).val();
        if ($(this).data("accountnumber") == fieldVal || $(this).data("cardnumber") == fieldVal || $(this).data("accno") == fieldVal) {

            selected = i;
            return false;
        }
    });

    if (slides.length < 1) {
        wrap.addClass('single-slide');
        $this.addClass('slick-initialized');
    } else {
        if (slides.length == 2 || slides.length == 3) {

            var clonedSliders = slides.clone();
            var i = 0;
            slides.each(function () {
                var $thisSlide = $(this);

                if ($thisSlide.attr('id')) {
                    $thisSlide.attr('id', $thisSlide.attr('id') + '_original');
                } else {
                    $thisSlide.attr('id', i + '_original');
                }
                i++;
            });
            i = 0;
            clonedSliders.each(function () {
                var $cloned = $(this);
                $cloned.css("visibility", "hidden");

                if ($cloned.attr('id')) {
                    $cloned.attr('id', $cloned.attr('id') + '_cloned');
                } else {
                    $cloned.attr('id', i + '_cloned');
                }
                i++;
            })
                .appendTo(slider);
        }
        //Kesirano
        if (localStorage['account-picker-selected-account'] != "") {
            i = -1;
            slides.each(function () {
                i = i + 1;
                if ($(this).data("accountnumber") == localStorage['account-picker-selected-account'] || $(this).data("cardnumber") == localStorage['account-picker-selected-account']) {
                    $("#" + $this.data("field-id")).val(localStorage['account-picker-selected-account']);
                    selected = i;
                    $("#Accounts_ID").val(localStorage['account-picker-selected-account']);


                }
            });
        }

        DeWeb.LoadUtilities($this);
        slider.slick(getSlickSettings(selected));
        setTimeout(function () {
            if ($("#Accounts_ID").val()) {
                AccountPicker.ChangeAccount($("#Accounts_ID").val(), selected);
                localStorage['account-picker-selected-account'] = "";
                if (localStorage['account-picker-filter'] != "") {
                    $("[data-accountkind='" + localStorage['account-picker-filter'] + "']").trigger("click");
                    localStorage['account-picker-filter'] = "";
                }
                else {
                    //$("#all-account-types").trigger("click");
                }
            }

        }, 100);



    }

    var hideMockDotds = function () {        // hide extra dots for mobile view
        var dots = $('.account-small-slider .slick-dots').children();
        if (dots.length > 0) {
            var slicks = $('.account-small-slider .slick-list').children().children();
            var reg = RegExp('_cloned$');
            for (var i = 0; i < slicks.length; i++) {
                if (reg.test(slicks[i].id)) {
                    dots[i].style.display = 'none';
                }
            }
        }
    }
    hideMockDotds();
    
    var initialize = slides;
    var filterSlides = function (acckind, indic) {
        var $mainSlider = $this;

        var currentSlides = [];
        //remove mock slides if needed
        var mockFirst = 0;
        var firstTime = true;
        $mainSlider.find(".slide").each(function () {
            if ($(this).attr("id")) {
                if (firstTime) {
                    mockFirst = $(".slide").index($mainSlider.children().find("#" + $(this).attr("id")));
                    firstTime = false;
                }
                $mainSlider.slick('slickRemove', mockFirst);
            }
        });

        initialize.each(function () {
            if (acckind.length === 1 && acckind[0] === "") {

                if ($(this).data("acckind") !== "debit-card" && $(this).data("acckind") !== "credit-card-account") {
                    $mainSlider.slick('slickAdd', $(this));
                    currentSlides.push($(this));
                } else {
                    var commonAttribute = $(this).data("accountnumber");
                    commonAttribute = escapeAccountChars(commonAttribute);
                    var indextoRemove = $(".slide").index($mainSlider.children()
                        .find("[data-accountnumber=" + commonAttribute + "]"));
                    $mainSlider.slick('slickRemove', indextoRemove);
                }
            } else {
                if (acckind.indexOf($(this).data("acckind")) > -1) {
                    console.log($(this).data("accountnumber"));
                    $mainSlider.slick('slickAdd', $(this));
                    currentSlides.push($(this));
                } else {
                    var commonAttribute = $(this).data("accountnumber");
                    commonAttribute = escapeAccountChars(commonAttribute);
                    var indextoRemove = $(".slide").index($mainSlider.children()
                        .find("[data-accountnumber=" + commonAttribute + "]"));
                    $mainSlider.slick('slickRemove', indextoRemove);
                }
            }


        });

        // add mockslides 
        if (currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }

        }
        $mainSlider.slick('unslick');
        var i = -1;
        var focus = 1;
        if (currentSlides.length == 2 || currentSlides.length == 1) {
            focus = 0;
        }
        if ($("[name=Cards_ID]").val()) {

            var cardNo = $("[name=Cards_ID]").val();

            //var selectedSlide = $("[data-accountnumber=" + cardNo + "]");
            $("#Accounts_ID").val(cardNo);
        }
        if (acckind.length === 1 && acckind[0] === "") {
            $(currentSlides).each(function () {
                i = i + 1;
                if ($(this).data("accountnumber") == $("#" + $this.data("field-id")).val()) {

                    focus = i;

                }
            });
        }
        if ($("#" + $this.data("field-id")).val()) {
            var i = -1;
            $(currentSlides).each(function () {
                i = i + 1;
                if ($(this).data("accountnumber") == $("#" + $this.data("field-id")).val() || $(this).data("cardnumber") == $("#" + $this.data("field-id")).val()) {

                    focus = i;

                }
            });
        }

        //if (acckind.indexOf("credit-card-account") > -1) {
        //    $("[data-text-for=card]").css("display", "block");
        //    $("[data-text-for=credit-account]").css('display', 'none');
        //} else {
        //    $("[data-text-for=card]").css("display", "none");
        //    $("[data-text-for=credit-account]").css('display', 'block');
        //}
        
        var selectedAccount = $("#selected-account").val();
        var focus = 0;
        if (selectedAccount != undefined) {
            var slides = $(".slide");
            for (var i = 0; i < slides.length; i++) {
                if (slides.eq(i).data("accno") == selectedAccount) {
                    focus = i;
                }
            }
        }
        else {
            focus = selected;
        }
        
        var selectedAccount = $(currentSlides[focus]).data("accountnumber");
        $mainSlider.slick(getSlickSettings(focus));
        DeWeb.LoadUtilities($mainSlider.parent());
        $("#Accounts_ID").val(selectedAccount);
        if (indic) {
            AccountPicker.ChangeAccount($("#Accounts_ID").val(), focus);
        }

        hideMockDotds();

    };

    $this.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
        if ($this.find('[data-slick-index=' + nextSlide + ']').attr("id") != undefined && ($this.find('[data-slick-index=' + nextSlide + ']').attr("id").indexOf("cloned") !== -1)) {
            event.preventDefault();
            return;
        }
    });


    $this.on('afterChange',
        function (event, slick, currentSlide) {
            var selectedAccount = $(slick.$slides[currentSlide]).data("accountnumber");

            $('#' + fieldId).val(selectedAccount);
            //Change Account
            AccountPicker.ChangeAccount(selectedAccount, currentSlide);
            //ChangeCurrency
            var currencies = [];
            $(slick.$slides[currentSlide]).children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            })
            AccountPicker.ChangeCurrency(currencies);
            hideMockDotds();
        });
    $('.slider-button-prev-' + fieldId)
        .click(function () {
            $this.slick('slickPrev');
        });

    $('.slider-button-next-' + fieldId)
        .click(function () {

            if ($this.find("div.slick-center").next().attr("id") != undefined && ($this.find("div.slick-center").next().attr("id").indexOf("cloned") !== -1)) {
                return;
            }
            $this.slick('slickNext');
        });

    $("[data-group=acc-filters]").on("click", function (event, value) {
        var acckind = $(this).data("accountkind").split(',');
        $(this).siblings().removeClass();
        $(this).addClass("active");
        if (value == undefined) {
            value = true;
        }
        filterSlides(acckind, value);
    });
};


DeWeb.Utilities.sdCheckbox = function ($this) {
    $this.screwDefaultButtons();
}

DeWeb.Utilities.checkBoxFormField = function ($this) {
    $this.screwDefaultButtons();

    var changeAction = $this.data('changed-action');
    var formId = $this.data('form-id');

    if (changeAction && formId) {

        $this.change(function () {
            DeWeb.Forms.setAction(formId, changeAction);
        });
    }

}

DeWeb.Utilities.checkBoxFormFieldSlide = function ($this) {
    $this.screwDefaultButtons();
}
function parseDate(dateString, parser) {
    var mindate = dateString;
    if (parser == ".") {
        var minDateArr = dateString.split(parser);
        mindate = minDateArr[1] + parser + minDateArr[0] + parser + minDateArr[2];
    }
    var date = new Date(mindate);
    return date;
}
DeWeb.Utilities.datePickerFormField = function ($this) {
    var dateFormat = $this.data('date-format');
    var value = $this.val();
    $this.datepicker({
        dateFormat: dateFormat,
        firstDay: 1,
        minDate: new Date(parseInt($this.data('min-date'))),
        maxDate: new Date(parseInt($this.data('max-date')))
    });

    $this.datepicker({
        dateFormat: dateFormat,
        firstDay: 1,
        minDate: new Date(parseInt($this.data('min-date'))),
        maxDate: new Date(parseInt($this.data('max-date')))
    });

    $this.datepicker('setDate', value);
    $this.click(function (event, value) {
        $this.datepicker('setDate', value);
    });
    $this.closest('.date-wrap').click(function () {
        $this.focus();
    });
};
DeWeb.Utilities.timePickerFormField = function ($this) {
    $this.timepicker({
        timeSeparator: ':',
        showLeadingZero: true,
        showMinutesLeadingZero: true,
        showPeriod: false,
        showPeriodLabels: true,
        periodSeparator: ' ',
        defaultTime: $this.data("value"),
        showOn: 'focus',
        button: null,

        // Localization
        hourText: 'h',             // Define the locale text for "Hours"
        minuteText: 'min',         // Define the locale text for "Minute"
        amPmText: ['', ''],       // Define the locale text for periods

        // Position
        myPosition: 'left top',       // Corner of the dialog to position, used with the jQuery UI Position utility if present.
        atPosition: 'left bottom',    // Corner of the input to position



        hours: {
            starts: 0,
            ends: 23
        },
        minutes: {
            starts: 0,
            ends: 55,
            interval: 15,
            manual: []
        },
        rows: 4,
        showHours: true,
        showMinutes: true,
    });
};

DeWeb.Utilities.passwordFormField = function ($this) {

}

DeWeb.Utilities.qrCodeField = function ($this) {
    var qrCode = $this.data('qr-code');
    var whenScanDone = function (referenceId) {
        var $form = $this.parents('*[data-process-form="True"]').first();
        if ($form.length) {
            var $fwButton = $form
                .find('*[data-action-type="' + DeWeb.Enums.ButtonActionType.Forward + '"]');

            if ($fwButton.length) {
                $fwButton.click();
                return false;
            }
        }
    }

    initializeQrCodeScan(qrCode, whenScanDone);
}
DeWeb.Utilities.textBoxFormField = function ($this) {
    var isMultiline = $this.data('multiline');
    var selectedDoAction = $this.data('text-changed-action') + '';
    var content = $this.val();
    $this.blur(function () {
        if ($this.val() !== content) {
            if (selectedDoAction) {
                var $form = $this.parents('form:first');
                DeWeb.Forms.setAction($form.attr('id').replace("form_", ""), selectedDoAction);
            }
        }
    });
}
DeWeb.Utilities.comboBox = function ($this) {

    var sourceUrl = $this.data('source-url');
    var cascadeFrom = $this.data('source-cascade-from');
    var $cascadeFromField = $('#' + cascadeFrom);
    var cascadeFieldVal = $cascadeFromField.val();
    var placeholderTxt = $this.data('placeholder');
    var oldVal = $this.val();
    var searchMode = $this.data('search-mode');
    var newValueAllowed = $this.data('new-value-allowed');
    var selectedDoAction = $this.data("changed-action");
    var OnChangedEvent;
    var onChangedEventName = $this.data('selected-event');
    if (onChangedEventName) {
        OnChangedEvent = DeWeb.Events[onChangedEventName];
    }
    var initiateSelectize = function () {
        var thisSelectize = $this.data('selectize');

        if (!thisSelectize) {
            var $selectize = $this.selectize({
                options: [],
                placeholder: placeholderTxt.toUpperCase(),
                create: newValueAllowed,
                selectOnTab: true,
                onChange: function (value) {
                    var selectedText = '';
                    var $selectedOpt = $this.find('option:selected').first();
                    if ($selectedOpt.length) {
                        $('#Input_' + $this.prop('id')).val($selectedOpt.text());;
                    }


                    if (selectedDoAction) {
                        var $form = $this.parents('form:first');
                        DeWeb.Forms.setAction($form.attr('id').replace("form_", ""), selectedDoAction);
                    }
                    if (OnChangedEvent) {
                        OnChangedEvent($this);
                    }
                },
                onBlur: function (value) {
                    console.log("onBlur " + value);
                }
            });

            $this.data('init-done', true);

            if (searchMode && searchMode.toLowerCase() === "startswith") {
                $selectize[0].selectize.settings.score = function (search) {
                    //startswith
                    return function (option) {
                        if (accent_fold(option.text.toLowerCase()).lastIndexOf(accent_fold(search.toLowerCase()), 0) === 0) {
                            return 1;
                        }
                        return 0;
                    }
                }
            }

            if ($cascadeFromField.length) {
                noBlockWait(function () { return $cascadeFromField.data('init-done') }, function () {
                    if ($cascadeFromField.data('selectize')) {
                        $cascadeFromField.data('selectize').on('change', function () {
                            getData();
                        });
                    }
                });

            }
        }
    }



    var populateFromData = function (data) {
        var thisSelectize = $this.data('selectize');

        var options = [];
        $this.find('option').remove();
        $this.prepend('<option value="">None</option>');
        if (data) {
            for (var i = 0; i < data.length; i++) {
                var item = data[i];
                var $option = $('<option>').text(item.Text).attr('value', item.Value);
                if (item.Value != null && oldVal != null && item.Value.trim() === oldVal.trim()) {
                    $option.prop('selected', true);
                }
                $this.append($option);

                var option = {
                    text: item.Text,
                    value: item.Value,
                    selected: item.Value === oldVal
                }
                options.push(option);
            }
        }

        if (thisSelectize) {
            thisSelectize.clear();
            thisSelectize.clearOptions();
            thisSelectize.renderCache['option'] = {};
            thisSelectize.renderCache['item'] = {};
            thisSelectize.addOption(options);
        }
    }

    var clear = function () {
        $this.find('option').remove();
        var thisSelectize = $this.data('selectize');
        if (thisSelectize) {
            thisSelectize.clear();
            thisSelectize.clearOptions();
            thisSelectize.renderCache['option'] = {};
            thisSelectize.renderCache['item'] = {};
        }
    }
    var disable = function () {
        var thisSelectize = $this.data('selectize');
        if (thisSelectize) {
            thisSelectize.disable();
        }
    }

    var enable = function () {
        var thisSelectize = $this.data('selectize');
        if (thisSelectize) {
            thisSelectize.enable();
        }
    }
    var getAndCache = function (sourceUrl, queryParam, callback) {
        var lsData = InMemoryCache.instance.get(sourceUrl + queryParam);
        if (lsData) {
            callback(JSON.parse(lsData));
        } else {
            $.post(sourceUrl + queryParam,
                function (data) {
                    InMemoryCache.instance.set(sourceUrl + queryParam, JSON.stringify(data));
                    callback(data);
                });
        }
    }

    var getData = function () {
        disable();
        if (sourceUrl) {
            var cascadeEncoded = encodeURIComponent($cascadeFromField.val());
            if (cascadeFrom) {
                if (cascadeEncoded) {
                    getAndCache(sourceUrl, cascadeEncoded, function (data) {
                        populateFromData(data);
                        initiateSelectize();
                        enable();
                    });
                } else {
                    clear();
                    initiateSelectize();
                    enable();
                }
            } else if (!cascadeFrom) {
                getAndCache(sourceUrl, '', function (data) {
                    populateFromData(data);
                    initiateSelectize();
                    enable();
                });
            } else {
                initiateSelectize();
                enable();
            }

        } else {
            initiateSelectize();
            enable();
        }
    }

    getData();

    var clearCascadings = function ($input) {

        var $form = $input.parents('form').first();
        var cascadeFrom = $input.prop('name');

        while ($form.find("*[data-source-cascade-from='" + cascadeFrom + "']").length) {
            var $cascader = $form.find("*[data-source-cascade-from='" + cascadeFrom + "']").first();
            var $cascaderInput = $('#Input_' + $cascader.prop('name'));

            $cascader.val('');
            $cascaderInput.val('');

            cascadeFrom = $cascader.prop('name');
        }
    }

    //$.widget("custom.combobox", {
    //    _create: function () {
    //        this.wrapper = $("<span>")
    //          .addClass("custom-combobox")
    //          .insertAfter(this.element);
    //        this.selectionChangedHandlers = new Array();
    //        this.element.hide();
    //        this._createAutocomplete();
    //        this._createShowAllButton();
    //    },

    //    _createAutocomplete: function () {
    //        var that = this;
    //        var selected = this.element.children(":selected"),
    //          value = selected.val() ? selected.text() : "";
    //        var minLength = value.length + 1;
    //        var inputFieldIdValue = $this.data("input-field-pefix") + $this.attr("id");
    //        this.input = $("<input type='text' class='size-s' id='" + inputFieldIdValue + "' name='" + inputFieldIdValue + "' placeholder='" + placeholderTxt + "'/>")
    //          .insertBefore(this.element)
    //          .val(value)
    //          .attr("title", "")
    //          //.addClass("custom-combobox-input ui-widget ui-widget-content ui-state-default ui-corner-left")
    //          .autocomplete({
    //              delay: 0,
    //              minLength: minLength,
    //              source: $.proxy(this, "_source"),
    //              open: function (event, ui) {
    //                  if ($this.attr("data-drop-down-width")) {
    //                      $(this).autocomplete("widget").css({ "width": $this.attr("data-drop-down-width") });
    //                  }

    //              }
    //          })
    //          .tooltip({
    //              classes: {
    //                  "ui-tooltip": "ui-state-highlight"
    //              }
    //          });

    //        this._on(this.input, {
    //            autocompleteselect: function (event, ui) {
    //                console.log("autocompleteselect fired!");
    //                clearCascadings(this.element);
    //                ui.item.option.selected = true;
    //                this._trigger("select", event, {
    //                    item: ui.item.option
    //                });
    //            },

    //            autocompletechange: "_removeIfInvalid"
    //        });

    //        setTimeout(function () {
    //            that.input.autocomplete('option', 'minLength', 1);
    //        }, 200);
    //    },

    //    _createShowAllButton: function () {
    //        var input = this.input,
    //          wasOpen = false;

    //        //$("<a>")
    //        //  .attr("tabIndex", -1)
    //        //  .attr("title", "Show All Items")
    //        //  .tooltip()
    //        //  .appendTo(this.wrapper)
    //        //  .button({
    //        //      icons: {
    //        //          primary: "ui-icon-triangle-1-s"
    //        //      },
    //        //      text: false
    //        //  })
    //        //  .removeClass("ui-corner-all")
    //        //  .addClass("custom-combobox-toggle ui-corner-right")
    //        //  .on("mousedown", function () {
    //        //      wasOpen = input.autocomplete("widget").is(":visible");
    //        //  })
    //        //  .on("click", function () {
    //        //      input.trigger("focus");

    //        //      // Close if already visible
    //        //      if (wasOpen) {
    //        //          return;
    //        //      }

    //        //      // Pass empty string as value to search for, displaying all results
    //        //      input.autocomplete("search", "");
    //        //  });
    //    },

    //    _source: function (request, response) {
    //        var matcher = $this.data("search-mode") == "Contains" ? new RegExp($.ui.autocomplete.escapeRegex(accent_fold(request.term)), "i") : new RegExp("^" + accent_fold(request.term), "i");
    //        //var matcher = new RegExp("^" + accent_fold(request.term), "i");
    //        response(this.element.children("option").map(function () {
    //            var text = $(this).text();

    //            if (this.value && (!request.term || matcher.test(accent_fold(text))))
    //                return {
    //                    label: text,
    //                    value: text,
    //                    option: this
    //                };
    //        }));
    //    },

    //    _removeIfInvalid: function (event, ui) {

    //        console.log("autocompletechange");

    //        var autocomplete = this;

    //        clearCascadings(autocomplete.element);

    //        // Search for a match (case-insensitive)


    //        // Selected an item, nothing to do
    //        if (ui.item) {
    //            //console.log("ui.item.value=" + ui.item.value);
    //            $this.trigger("change");
    //            return;
    //        }

    //        var value = this.input.val(),
    //        valueLowerCase = accent_fold(value.toLowerCase()),
    //        valid = false;
    //        var matchFound = false;

    //        this.element.children("option").each(function () {
    //            //if ($(this).text().toLowerCase().indexOf(valueLowerCase) != -1) {
    //            var optionText = accent_fold($(this).text().toLowerCase());
    //            if (optionText.toLowerCase() == valueLowerCase) {
    //                this.selected = valid = true;
    //                autocomplete.input.val($(this).text());
    //                $this.trigger("change");
    //                matchFound = true;
    //                return false;
    //            }
    //        });

    //        if (!matchFound) {
    //            this.element.children("option").each(function () {
    //                //if ($(this).text().toLowerCase().indexOf(valueLowerCase) != -1) {
    //                var optionText = accent_fold($(this).text().toLowerCase());
    //                if (optionText.indexOf(valueLowerCase) != -1) {
    //                    this.selected = valid = true;
    //                    autocomplete.input.val($(this).text());
    //                    $this.trigger("change");
    //                    return false;
    //                }
    //            });
    //        }

    //        // Found a match, nothing to do
    //        if (valid) {

    //            return;
    //        }






    //        // Remove invalid value

    //        if ($this.data("new-value-allowed") == "false") {
    //            this.input.val("").attr("title", value + " didn't match any item").tooltip("open");
    //            this.element.val("");
    //            this._delay(function () {
    //                this.input.tooltip("close").attr("title", "");
    //            }, 2500);
    //            this.input.autocomplete("instance").term = "";
    //        } else {
    //            var parentForm = $this.closest("form");
    //            parentForm.submit(function () {
    //                var inputFieldIdValue = $this.data("input-field-pefix") + $this.attr("id");
    //                var enteredValue = $("#" + inputFieldIdValue).val();
    //                var option = $("<option selected/>");
    //                option.text(enteredValue);
    //                option.attr("value", enteredValue);
    //                $this.append(option);
    //            });
    //        }


    //    },

    //    _destroy: function () {
    //        this.wrapper.remove();
    //        this.element.show();
    //    }
    //});
    //$this.combobox({ change: function() {
    //    console.log("combobox changed");


    //} });



    //if ($this.data("source-cascade-from") != "" && $("#" + $this.data("source-cascade-from")).length) {
    //    var cascadeFrom = $("#" + $this.data("source-cascade-from"));
    //    $(document).on("change", "#" + $this.data("source-cascade-from"), function () {
    //        if ($(this).val() != "" && $(this).val() != "0") {
    //            $.ajax({
    //                type: "post",
    //                data: {},
    //                url: $this.data("source-url") + escape($(this).val()),
    //                success: function (data) {
    //                    $this.find("option").remove();
    //                    for (var i = 0; i < data.length; i++) {
    //                        $this.append('<option value="' + data[i].Value + '">' + data[i].Text + '</option>')
    //                    }
    //                }
    //            });
    //        } else {
    //            $this.find("options").remove();
    //        }
    //    });

    //    $(document).ready(function () {
    //        if (cascadeFrom.val() != "" && cascadeFrom.val() != "0") {
    //            $.ajax({
    //                type: "post",
    //                url: $this.attr("data-source-url") + escape(cascadeFrom.val()),
    //                success: function (data) {
    //                    var selectedOption = $this.find("option[selected]").val();
    //                    for (var i = 0; i < data.length; i++) {
    //                        if (selectedOption != data[i].Value) {
    //                            var option = $('<option value="' + data[i].Value + '">' + data[i].Text + '</option>');
    //                            $this.append(option);
    //                        }
    //                    }

    //                }
    //            });
    //        } else {
    //            $this.find("options").remove();
    //        }
    //    });
    //}



}


DeWeb.Utilities.inputSlider = function ($this) {
    var uiSlider = $this;
    var min = $this.data('min');
    var max = $this.data('max');
    var value = $this.data('value');
    var step = $this.data('step');
    var $referentField = $("#" + $this.data("key"));

    // functions
    var getSliderSettings = function (type) {
        if (type === "False") {
            return {
                range: "min",
                value: value,
                step: step,
                min: min,
                max: max,
                slide: function (event, ui) {
                    if ($this.data("type") == "Decimal") {
                        $referentField.autoNumeric('set', ui.value);

                    } else {
                        $referentField.val(ui.value);
                    }
                }
            };
        } else {
            return {
                range: true,
                min: min,
                max: max,
                values: [min, max],
                slide: function (event, ui) {
                    var keys = $this.data("key").split(',');
                    $("#" + keys[0]).val(ui.values[0]);
                    $("#" + keys[1]).val(ui.values[1]);
                }
            };
        }

    }
    var colorCircles = function (value) {
        var realMinAmount = min;

        $('.slider-circle').each(function () {
            var $this = $(this);

            var currentAmount = parseFloat($this.data('step-amount'));

            if (currentAmount > realMinAmount) {
                if (value >= (currentAmount)) {
                    $this.removeClass('gray');
                    $this.addClass('red');
                } else {
                    $this.removeClass('red');
                    $this.addClass('gray');
                }
            } else {
                $this.removeClass('gray');
                $this.addClass('red');
            }
        });
    }
    var addCommas = function (nStr) {
        nStr += '';
        x = nStr.split('.');
        x1 = x[0];
        x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ',' + '$2');
        }
        return x1 + x2;
    }



    uiSlider.slider(getSliderSettings($this.data("range")));

    // Listeners
    $referentField.blur(function () {
        var val = $referentField.val();
        if ($this.data("type") === "Decimal") {
            val = $referentField.autoNumeric('get');
        }

        uiSlider.slider("option", "value", val);
        uiSlider.slider("option", "value", val);
    });

};

DeWeb.Utilities.MakeSliderSteps = function ($this) {

    var realMinAmount = parseFloat($this.data('real-min-amount'));
    var sliderNumberOfSteps = parseFloat($this.data('number-of-steps'));
    var sliderMinAmount = parseFloat($this.data('slider-min-amount'));
    var sliderMaxAmount = parseFloat($this.data('slider-max-amount'));
    var difference = sliderMaxAmount - sliderMinAmount;
    var stepSize = difference / sliderNumberOfSteps;
    var positionReductionNum = 15 / 2;
    if ($(window).width() < 980) {
        positionReductionNum = 15;
    }
    var canSlide = true;

    var $slider = $('.slider-1');

    var sliderWidth = $slider.width();

    var left = 0;
    for (var i = 0; i <= sliderNumberOfSteps; i++) {
        var currentAmount = realMinAmount;
        if (i != 0) currentAmount = i * stepSize + realMinAmount;
        if (i > 0) {
            left += Math.ceil((sliderWidth / sliderNumberOfSteps));
        } else {
            currentAmount = sliderMinAmount;
        }

        var slideCircleClass = "gray";

        window.setAmountOnClick = function (value) {
            var input = $this.parents('.group').prev().prev().find('.slider-input');
            input.autoNumeric('set', value);
            var $slider = $('.slider-1');
            $slider.slider("option", "value", value);
            colorCircles(value);
        }


        var $circleStep = $('.slider-circle.circle-' + i);
        if (!$circleStep.length) {
            $circleStep = $('<div class="slider-circle">').addClass('circle-' + i);
            $circleStep.addClass(slideCircleClass).css('left', left - positionReductionNum);
            if ($(window).width() < 980) {
                $circleStep.addClass(slideCircleClass).css('left', left + positionReductionNum);
            }
            $circleStep.attr("data-step-amount", currentAmount);
            $circleStep.attr("onclick", 'setAmountOnClick(' + currentAmount + ')');
            $circleStep.insertAfter($slider);
        } else {
            $circleStep.css('left', left);
        }



        var colorCircles = function (value) {
            $('.slider-circle').each(function () {
                var $this = $(this);

                var currentAmount = parseFloat($this.data('step-amount'));

                if (currentAmount > realMinAmount) {
                    if (value >= (currentAmount)) {
                        $this.removeClass('gray');
                        $this.addClass('red');
                    } else {
                        $this.removeClass('red');
                        $this.addClass('gray');
                    }
                } else {
                    $this.removeClass('gray');
                    $this.addClass('red');
                }
            });
        };
        var input = $this.parents('.group').prev().prev().find(".slider-input");

        var val = input.autoNumeric('get');
        colorCircles(val);
    }
}

DeWeb.Utilities.FollowSliderSteps = function ($this) {
    $(window).on('resize', function (event) {
        var realMinAmount = parseFloat($this.data('real-min-amount'));
        var sliderNumberOfSteps = parseFloat($this.data('number-of-steps'));
        var sliderMinAmount = parseFloat($this.data('slider-min-amount'));
        var sliderMaxAmount = parseFloat($this.data('slider-max-amount'));
        var difference = sliderMaxAmount - sliderMinAmount;
        var stepSize = difference / sliderNumberOfSteps;
        var positionReductionNum = 15 / 2;
        if ($(window).width() <= 980) {
            positionReductionNum = 15;
        }
        var canSlide = true;
        var left = 0;

        var $slider = $('.slider-1');
        var sliderWidth = $slider.width();

        var slideCircleClass = "gray";
        for (var i = 0; i <= sliderNumberOfSteps; i++) {
            var currentAmount = realMinAmount;
            if (i != 0) currentAmount = i * stepSize + realMinAmount;
            if (i > 0) {
                left += Math.ceil((sliderWidth / sliderNumberOfSteps));
            } else {
                currentAmount = sliderMinAmount;
            }
            var $circleStep = $('.slider-circle.circle-' + i);
            $circleStep.addClass(slideCircleClass).css('left', left - positionReductionNum);
            if ($(window).width() < 980) {
                $circleStep.addClass(slideCircleClass).css('left', left + positionReductionNum);
            }
        }

        var value = $slider.slider("option", "value");


        $('.slider-circle').each(function () {
            var $this = $(this);

            var currentAmount = parseFloat($this.data('step-amount'));

            if (currentAmount > realMinAmount) {
                if (value >= (currentAmount)) {
                    $this.removeClass('gray');
                    $this.addClass('red');
                } else {
                    $this.removeClass('red');
                    $this.addClass('gray');
                }
            } else {
                $this.removeClass('gray');
                $this.addClass('red');
            }
        });
    });
}

DeWeb.Utilities.comboBoxFormField = function ($this) {

    var placeholderTxt = $this.data('placeholder');
    var isDynamic = false;

    $.widget("custom.combobox", {
        _create: function () {
            this.wrapper = $("<span>")
                .addClass("custom-combobox")
                .insertAfter(this.element);
            this.selectionChangedHandlers = new Array();
            this.element.hide();
            this._createAutocomplete();
            this._createShowAllButton();
        },

        _createAutocomplete: function () {
            var selected = this.element.children(":selected"),
                value = selected.val() ? selected.text() : "";

            var inputFieldIdValue = $this.data("input-field-pefix") + $this.attr("id");
            this.input = $("<input type='text' class='input-1' id='" + inputFieldIdValue + "' name='" + inputFieldIdValue + "' placeholder='" + placeholderTxt + "'/>")
                .insertBefore(this.element)
                .val(value)
                .attr("title", "")
                //.addClass("custom-combobox-input ui-widget ui-widget-content ui-state-default ui-corner-left")
                .autocomplete({
                    delay: 0,
                    minLength: 1,
                    source: $.proxy(this, "_source"),
                    open: function (event, ui) {
                        $(this).autocomplete("widget").css({ "z-index": "1000" });
                        if ($this.attr("data-drop-down-width")) {
                            $(this).autocomplete("widget").css({ "width": $this.attr("data-drop-down-width") });
                        }

                    }
                })
                .tooltip({
                    classes: {
                        "ui-tooltip": "ui-state-highlight"
                    }
                });

            this._on(this.input, {
                autocompleteselect: function (event, ui) {
                    ui.item.option.selected = true;
                    this._trigger("select", event, {
                        item: ui.item.option
                    });
                },

                autocompletechange: "_removeIfInvalid"
            });
            var inputField = this.input;
            //For closing on click
            $(document).bind('click', function (event) {
                if (isDynamic) {
                    if (($(event.target).attr("id") != inputField.attr("id"))) {
                        $("#ui-id-1").hide();
                        $(".ui-menu-item").hide();
                    }
                }

            });



            //For dymanic input selection

            $(document).on("click", "li", function () {
                if (isDynamic) {
                    var id = inputField.attr("id");
                    var changedValue = "";
                    var txt = $("#" + id).val();
                    var select = $("#" + id.replace("Input_", ""));
                    select.children().each(function () {
                        if ($(this).text() == txt) {
                            changedValue = $(this).val();
                            $("#" + id).val($(this).text());

                        }
                    });
                    var onChangedText = $this.data("on-change");
                    window[onChangedText](changedValue, function (result) { data = result; });
                    return false;
                }


            });

            this.input.on("change", function (event) {
                console.log("On combobox input change");
                var inputField = $(event.target);
                var txt = inputField.val();
                var id = inputField.attr("id");
                var select = $("#" + id.replace("Input_", ""));
                /*var option = select.find("option:contains('" + txt + "')");
                if (option.length) {
                    option.attr("selected", "selected");
                    select.trigger("change");
                    inputField.val(option.text());
                }*/
                select.find("option").each(function (index, element) {
                    var option = $(element);
                    if (option.html().toLowerCase().trim().indexOf(txt.toLowerCase().trim()) != -1 && txt != "") {
                        option.attr("selected", "selected");
                        select.trigger("change");
                        inputField.val(option.text());
                        return false;
                    }
                });
            });
        },

        _createShowAllButton: function () {
            var input = this.input,
                wasOpen = false;

            //$("<a>")
            //  .attr("tabIndex", -1)
            //  .attr("title", "Show All Items")
            //  .tooltip()
            //  .appendTo(this.wrapper)
            //  .button({
            //      icons: {
            //          primary: "ui-icon-triangle-1-s"
            //      },
            //      text: false
            //  })
            //  .removeClass("ui-corner-all")
            //  .addClass("custom-combobox-toggle ui-corner-right")
            //  .on("mousedown", function () {
            //      wasOpen = input.autocomplete("widget").is(":visible");
            //  })
            //  .on("click", function () {
            //      input.trigger("focus");

            //      // Close if already visible
            //      if (wasOpen) {
            //          return;
            //      }

            //      // Pass empty string as value to search for, displaying all results
            //      input.autocomplete("search", "");
            //  });
        },

        _source: function (request, response) {
            var matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
            var select = this.element;
            if (select.children().length == 0 && !isDynamic) {
                isDynamic = true;
            }
            if (isDynamic) {
                var $input = $("#Input_" + $this.attr("id"));
                $input.unbind().donetyping(function () {
                    var onInputText = $this.data("changed-action");
                    var data = null;
                    function mapresult(data) {
                        select.children().remove();
                        for (index in data) {
                            select.append($('<option>', { value: data[index]['label'], text: data[index]['value'] }));
                        }
                        response(select.children("option").map(function () {
                            var text = $(this).text();
                            if (true)
                                return {
                                    label: text,
                                    value: text,
                                    option: this
                                };
                        }));

                    }
                    window[onInputText]($input.val(), function (result) { data = result; mapresult(data); });

                });
            }
            response(this.element.children("option").map(function () {
                var text = $(this).text();
                if (this.value && (!request.term || matcher.test(text)))
                    return {
                        label: text,
                        value: text,
                        option: this
                    };
            }));
        },

        _removeIfInvalid: function (event, ui) {

            // Selected an item, nothing to do
            if (ui.item) {
                //console.log("ui.item.value=" + ui.item.value);
                $this.trigger("change");
                return;
            }

            // Search for a match (case-insensitive)
            var value = this.input.val(),
                valueLowerCase = value.toLowerCase(),
                valid = false;
            this.element.children("option").each(function () {
                if ($(this).text().toLowerCase() === valueLowerCase) {
                    this.selected = valid = true;
                    return false;
                }
            });

            // Found a match, nothing to do
            if (valid) {
                return;
            }

            // Remove invalid value

            if ($this.attr("data-new-value-allowed") == "false") {
                this.input.val("").attr("title", value + " didn't match any item").tooltip("open");
                this.element.val("");
                this._delay(function () {
                    this.input.tooltip("close").attr("title", "");
                }, 2500);
                this.input.autocomplete("instance").term = "";
            } else {
                var parentForm = $this.closest("form");
                parentForm.submit(function () {
                    var inputFieldIdValue = $this.data("input-field-pefix") + $this.attr("id");
                    var enteredValue = $("#" + inputFieldIdValue).val();
                    var option = $("<option selected/>");
                    option.text(enteredValue);
                    option.attr("value", enteredValue);
                    $this.append(option);
                });
            }


        },

        _destroy: function () {
            this.wrapper.remove();
            this.element.show();
        }
    });
    $this.combobox({ change: function () { console.log("combobox changed"); } });
    if ($this.attr("data-source-cascade-from") != "" && $("#" + $this.attr("data-source-cascade-from")).length) {
        var cascadeFrom = $("#" + $this.attr("data-source-cascade-from"));
        cascadeFrom.on("change", function () {
            console.log("cascadeFrom change!!!")
            if (cascadeFrom.val() != "" && cascadeFrom.val() != "0") {
                $.ajax({
                    type: "post",
                    data: {},
                    url: $this.attr("data-source-url") + escape(cascadeFrom.val()),
                    success: function (data) {
                        $this.find("option").remove();
                        for (var i = 0; i < data.length; i++) {
                            $this.append('<option value="' + data[i].Value + '">' + data[i].Text + '</option>')
                        }
                    }
                });
            } else {
                $this.find("options").remove();
            }
        });

        $(document).ready(function () {
            console.log("cascade is called from document.ready!!!")
            if (cascadeFrom.val() != "" && cascadeFrom.val() != "0") {
                $.ajax({
                    type: "post",
                    url: $this.attr("data-source-url") + escape(cascadeFrom.val()),
                    success: function (data) {
                        var selectedOption = $this.find("option[selected]").val();
                        for (var i = 0; i < data.length; i++) {
                            if (selectedOption != data[i].Value) {
                                var option = $('<option value="' + data[i].Value + '">' + data[i].Text + '</option>');
                                $this.append(option);
                            }
                        }

                    }
                });
            } else {
                $this.find("options").remove();
            }
        });
    }



}


function changeData(data) {

    for (var i = 0; i < data.length; i++) {

        if (data[i].hasOwnProperty("Name")) {
            data[i]["Text"] = data[i]["Name"];
            delete data[i]["Name"];
        }
        if (data[i].hasOwnProperty("PlaceName")) {
            data[i]["Description"] = data[i]["PlaceName"];
            delete data[i]["PlaceName"];
        }
    }
    return data;
}


DeWeb.Utilities.replaceText = function ($this)
{
    if (screen.width < 450)
    {
        var getPath = $this.context.baseUri;
        if ($this.context.baseUri == null)
        {
            getPath = $this.context.baseURI;
        }
        if (getPath.includes("BillPresentment"))
        {
            var textValue = $this.context.textContent;
            if (textValue.length > 15)
            {
                var newTextValue = textValue.substring(0, 12) + "...";
                $this.context.textContent = newTextValue;
            }
            $this.context.style.fontSize = "12px";
        }
        else if (getPath.includes("PersonalBeneficiaries"))
        {
            var textValue = $this.context.textContent;
            if (textValue.length > 10)
            {
                var newTextValue = textValue.substring(0, 9) + "...";
                $this.context.textContent = newTextValue;
            }
        }
        else if (getPath.includes("Drafts"))
        {
            var textValue = $this.context.textContent;
            if (textValue.length > 15)
            {
                var newTextValue = textValue.substring(0, 12) + "...";
                $this.context.textContent = newTextValue;
            }
        }
    }
}





DeWeb.Utilities.autoCompleteFormField = function ($this) {
    var source = $this.data('source');
    var isLive = $this.data('is-live').toLowerCase() === "true";
    var queryBy = $this.data('query-by');
    var renderEventName = $this.data('render-event');
    var selectEventName = $this.data('select-event');
    var aSource;
    var loadAutocomplete = false;
    var RenderMethod = null;
    var SelectMethod = null;
    var TemplateMethod = null;

    if (renderEventName) {
        RenderMethod = DeWeb.Events[renderEventName];
    }

    if (selectEventName) {
        SelectMethod = DeWeb.Events[selectEventName];
    }
    var selectedDoAction = $this.data('text-changed-action') + ''; // faster tostring


    function initAutocomplete(callback) {
        if (isLive) {
            loadAutocomplete = true;
            aSource = function (request, response) {
                var liveSource = '';
                if (queryBy) {
                    liveSource = source + "?" + queryBy + "=" + request.term;
                }
                $.get(liveSource, function (data) {
                    response(data);
                });
            };
            callback();
        } else {
            $.get(source, function (data) {
                if (source.indexOf("Streets") != -1) {
                    data = changeData(data.Items);
                }

                aSource = function (request, response) {
                    var matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
                    var array = $.grep(data, function (value) {
                        if (typeof (value[queryBy]) != 'undefined') {
                            return matcher.test(value[queryBy]);
                        }
                        return matcher.test(value.Text) || matcher.test(value.Description);
                    });
                    response(array);
                };

                loadAutocomplete = true;
                callback();
            });
        }
    }
    $this.click
    initAutocomplete(function () {
        $this.autocomplete({
            source: aSource,

            minLenght: 2,
            select: function (event, ui) {

                if (isFunction(SelectMethod)) {
                    var initialized = new SelectMethod(ui.item);
                } else {
                    $this.val(ui.item.Text);


                }

                if (selectedDoAction) {

                    var $form = $this.parents('form:first');
                    DeWeb.Forms.setAction($form.attr('id').replace("form_", ""), selectedDoAction);
                }
                return false;
            }
        }).autocomplete("instance")._renderItem = function (ul, item) {
            if (isFunction(RenderMethod)) {
                return new RenderMethod(ul, item);
            }

            if (item.hasOwnProperty("StreetCode")) {
                var municipalityName = $("#Municipalities_ID").val();
                if (municipalityName == "" || municipalityName != item.Description) return;
            }
            return $("<li>")
                .append("<div><p>" + item.Text + "</p><p>" + item.Description + "</p></div>")
                .appendTo(ul);
        };
    });

}

DeWeb.Utilities.decimalFormField = function ($this) {

    var minValue = parseFloat($this.data('min-value') || "0");
    var maxValue = parseFloat($this.data('max-value') || "10000000000000");

    var grpSep = DeWeb.Config.GroupSeparator;
    var decSep = DeWeb.Config.DecimalSeparator;

    var currentValue = parseFloat($this.val() || "0.00");

    $this.autoNumeric('init',
        {
            aSep: grpSep,
            aDec: decSep,
            mDec: 2,
            vMin: minValue,
            vMax: maxValue
        });

    if (currentValue < minValue) {
        currentValue = minValue;
        $this.autoNumeric('set', currentValue);
    }
    if (currentValue > maxValue) {
        currentValue = maxValue;
        $this.autoNumeric('set', currentValue);
    }

    $this.attr("autocomplete", "off"); // Kill browser autocomplete (it stores string values, not always in correct format).


    // on change
    var changeAction = $this.data('changed-action');
    var formId = $this.data('form-id');

    if (changeAction && formId) {
        $this.change(function () {
            DeWeb.Forms.setAction(formId, changeAction);
        });
    }
}

DeWeb.Utilities.integerFormField = function ($this) {
    var minValue = $this.data('min-value') || "0";
    var maxValue = $this.data('max-value') || "1000000000";
    var grpSep = DeWeb.Config.GroupSeparator;
    $this.autoNumeric('init',
        {
            aSep: grpSep,
            vMin: parseInt(minValue),
            vMax: parseInt(maxValue)
        });
}

DeWeb.Utilities.radioFormField = function ($this) {
    var changeAction = $this.data('changed-action');
    var formId = $this.data('form-id');

    $this.screwDefaultButtons({
        image: "url(../../img/icons-2x/radio-1.jpg)",
        width: 20,
        height: 20
    });

    if (changeAction && formId) {
        $this.change(function () {
            DeWeb.Forms.setAction(formId, changeAction);
        });
    }
};
DeWeb.Utilities.onActionChange = function ($this) {
    var changeAction = $this.data('selection-changed-action');
    var formId = $this.data('form-id');
    if (changeAction && formId) {
        $this.change(function (e, val) {
            $this.val(val);
            DeWeb.Forms.setAction(formId, changeAction);
        });
    }
};
DeWeb.Utilities.setAction = function ($this) {
    $this.on('click', function () {
        var formId = $this.data('form-id');
        if (!formId) {
            var $parentForm = $this.parents('form');
            if ($parentForm.length) {
                formId = $parentForm.first().attr('id');
            }
        }
        DeWeb.Forms.setAction(formId, $this.data('action'));
    });
}
DeWeb.Utilities.setValueAndAction = function ($this) {
    $this.on('click', function () {
        var formId = $this.data('form-id');
        if (!formId) {
            var $parentForm = $this.parents('form');
            if ($parentForm.length) {
                formId = $parentForm.first().attr('id');
            }
        }
        DeWeb.Forms.setFieldValue(formId, $this.data('field-id'), $this.data('value'));
        DeWeb.Forms.setAction(formId, $this.data('action'));
    });
}

DeWeb.Utilities.selectFormField = function ($this) {
    var formId = $this.data('form-id');
    var trigger = $this;
    var firstTimeChange = true;
    var OnChangedEvent;
    var onChangedEventName = $this.data('selected-event');
    var selectedDoAction = $this.data('selection-changed-action') + ''; // faster tostring

    if (onChangedEventName) {
        OnChangedEvent = DeWeb.Events[onChangedEventName];
    }

    $this.on('change', function (e, value) {

        if (OnChangedEvent) {
            OnChangedEvent($this, e);
        }

    });


    trigger.ddslick({

        onSelected: function (data) {
            var name = $(trigger).attr('name');
            var select = "input[name=" + name + "]";
            var hidden = $(select);

            if (hidden.length > 0) {
                if (OnChangedEvent) {
                    OnChangedEvent(hidden, data);
                }

                if (!firstTimeChange) {
                    hidden.trigger('change');
                    if (selectedDoAction) {
                        var $form = hidden.parents('form:first');
                        DeWeb.Forms.setAction($form.attr('id').replace("form_", ""), selectedDoAction);
                    }
                }
                firstTimeChange = false;
            }
        }
    });
    $("input[name=" + $(trigger).attr('name') + "]").on('ddslickChanged', function(e, data) {
        if (selectedDoAction) {
            DeWeb.Forms.setAction(formId.replace("form_", ""), selectedDoAction);
        }
    });

};


DeWeb.Utilities.selectOpenOptionsField = function ($this) {
    //On click perfrom selecting option!
    $this.children().each(function () {
        if ($(this).data("status") == "selected") {
            $(this).css('border', "solid 2px #209ac7");
            var id = $(this).data("value");
            $("#" + $this.attr("id").replace("values_", "")).val(id);
        }
    });
    $this.children().click(function () {
        $this.children().css("border", "");
        $(this).css('border', "solid 2px #209ac7");
        var id = $(this).data("value");
        $("#" + $this.attr("id").replace("values_", "")).val(id);

    });
};


DeWeb.Utilities.sorter = function ($this)
{
    var table = $this.closest('.custom-table');
    var $form = $this.parents().children().closest("form")
    var sortBy = $this.data('sort-by');
    var order = 'desc';
    var $sortByField = $('#SortBy_ID');
    var $sortOrderField = $('#SortOrder_ID');

    if ($sortByField.length && $sortOrderField)
    {
        var currentSort = $sortByField.val();
        var currentOrder = $sortOrderField.val();
        var $currentSorter = $('*[data-sort-by="' + currentSort + '"]');

        if ($currentSorter.length)
        {
            if (currentOrder === 'asc') {
                $currentSorter.removeClass('down').addClass('up');
            } else if (currentOrder === 'desc') {
                $currentSorter.removeClass('up').addClass('down');
            }
        }
    }

    $this.click(function ()
    {
        var $forms = $this.parents().find('form');
        var $filter = null;
        $forms.each(function (e)
        {
            var formId = $(this).prop('id');
            if (formId.indexOf('form_filter')!=-1)
            {
                $filter = $(this);
                return;
            }
        });

        var dateFrom = $filter.find("[name=DateFrom_ID]").val();
        var dateTo = $filter.find("[name=DateTo_ID]").val();
        var amountLow = $filter.find("[name=AmountLow_ID]").val();
        var amountHigh = $filter.find("[name=AmountHigh_ID]").val();
        var filterDescription = $filter.find("[name=Description_ID]").val();
        var partyName = $filter.find("[name=PartyName_ID]").val();
        var partyIdentifier = $filter.find("[name=PartyIdentifier_ID]").val();


        if ($(this).hasClass('down'))
        {

            $(this).removeClass('down').addClass('up');
            order = 'asc';
        } else if ($(this).hasClass('up'))
        {
            $(this).removeClass('up').addClass('down');
            order = 'desc';
        } else
        {
            table.find('.order').removeClass('down up');
            $(this).addClass('down');
            order = 'desc';
        }

        if ($sortByField.length)
        {
            $sortByField.val(sortBy);
        }

        if ($sortOrderField.length)
        {
            $sortOrderField.val(order);
        }
        $form.find("[name=DateFrom_ID]").val(dateFrom);
        $form.find("[name=DateTo_ID]").val(dateTo);
        $form.find("[name=AmountLow_ID]").val(amountLow);
        $form.find("[name=AmountHigh_ID]").val(amountHigh);
        $form.find("[name=Description_ID]").val(filterDescription);
        $form.find("[name=PartyName_ID]").val(partyName);
        $form.find("[name=PartyIdentifier_ID]").val(partyIdentifier);

        $form.submit();
    });
};
DeWeb.Utilities.fetchMultiAuth = function ($this) {


    var formId = $this.parents("form").attr('id');
    DeWeb.Ui.BlockUi();
    var $form = $('#' + formId);
    var id = $form.find("#existingworkitemId").val();
    var updateSelector = $form.data('ajax-update');
    var $updateContent = $(updateSelector);
    if (id != "" && $form != null && $updateContent != null) {
        $.get($form.attr('action') + '?workitemid=' + id, function (data) {
            $updateContent.html(data);
            DeWeb.AjaxForms.OnAjaxSuccess(updateSelector.replace('#', ''));
            DeWeb.AjaxForms.OnAjaxComplete(updateSelector.replace('#', ''));
            DeWeb.Ui.UnblockUi();
            DeWeb.Ui.ClearNotifications();
        });
    }

}


DeWeb.Utilities.fileUploadFormField = function ($this) {
    var $container = $this.parents('.custom-file-upload').first();
    var uploadPath = $this.data('upload-path');
    var btn = $this.siblings('.button-upload');
    var $nameContainer = $this.parent().siblings('.file-name');
    var uploadEventName = $this.data('upload-event');
    var uploadEvent = DeWeb.Events[uploadEventName];
    var formId = $this.data('form-id');
    var allowMultiple = $this.data('allow-multiple');

    var maximumFileSize = $this.data('maximum-file-size');
    var allowedExtensions = $this.data('allowed-extensions');

    var maximumFileSizeError = $this.data('maximum-file-size-error');
    var allowedExtensionsError = $this.data('allowed-extensions-error');

    var uploadedData = $this.data('existing-files');
    var uploadedSplitted = [];
    if (uploadedData) {
        uploadedSplitted = uploadedData.split(',');
    }

    //$this.change(function () {
    //    $(this).next().find('span.file-name').text(this.value.replace(/^.*[\\\/]/, ''));
    //});
    //btn.click(function (e) {
    //    e.preventDefault();
    //    $(this).siblings('.upload-file').click();
    //});

    var max_file_size = '10mb';
    if (typeof (maximumFileSize) == "number" && maximumFileSize > 0) {
        max_file_size = (maximumFileSize / 1024 / 1024) + 'mb';
    }
    var mime_types = [];
    if (allowedExtensions) {
        mime_types.push({ title: "Allowed files", extensions: allowedExtensions });
    } else {
        mime_types.push({ title: "Image files", extensions: "jpg,gif,png,pdf" });
        mime_types.push({ title: "Zip files", extensions: "zip,xls,xml,txt,docx" })
    }

    var uploader = new plupload.Uploader({
        runtimes: 'html5,html4',

        browse_button: $this.get(0), // you can pass in id...
        container: $container.get(0), // ... or DOM Element itself

        url: uploadPath,

        filters: {
            max_file_size: max_file_size,
            mime_types: mime_types
        },
        preinit: {
            Init: function (up) {
                // create a new file array for plupload queue
                if (uploadedSplitted.length) {
                    var uploadedCount = 0;
                    var files = new Array();

                    // create a new file object
                    for (var i = 0; i < uploadedSplitted.length; i++) {
                        if (uploadedSplitted[i]) {
                            var f = new plupload.File(uploadedSplitted[i], uploadedSplitted[i], 0);
                            f.status = plupload.DONE;
                            f.percent = 100;
                            files.push(f);
                            uploadedCount++;
                        }
                    }
                    // append files to our array
                    up.files = files;
                    // create a new QueueProgress and configure
                    var queueprogress = new plupload.QueueProgress();
                    queueprogress.size = uploadedCount;
                    queueprogress.uploaded = uploadedCount;
                    queueprogress.percent = 100;

                    // set uploader queue process and reload ui
                    up.total = queueprogress;
                    up.trigger("QueueChanged");
                    up.refresh();
                }

            }
        },
        init: {
            PostInit: function () {
                $this.val('');
                if (uploadedSplitted.length) {
                    $nameContainer.prop('placeholder', uploadedSplitted[0]);
                }
            },

            FilesAdded: function (up, files) {
                DeWeb.Ui.BlockUi();
                plupload.each(files, function (file) {
                    //document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></div>';
                    $nameContainer.prop('placeholder', file.name);

                });

                uploader.start();
            },

            UploadProgress: function (up, file) {
                //document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
            },
            FileUploaded: function (uploader, file, response) {
                if (response && response.response) {
                    var responseobject = JSON.parse(response.response);
                    if (allowMultiple) {
                        $('#' + $this.attr('id')).val($('#' + $this.attr('id')).val() + "," + responseobject.fileid + ":" + responseobject.filename);
                    } else {
                        $('#' + $this.attr('id')).val(responseobject.fileid + ":" + responseobject.filename);
                    }

                    if (isFunction(uploadEvent)) {
                        uploadEvent({ DocumentName: responseobject.filename, FormId: formId, DocumentId: $this.attr('id') });
                    }
                }
                else {
                    $nameContainer.prop('placeholder', "");
                }
                DeWeb.Ui.UnblockUi();
            },
            Error: function (up, err) {
                DeWeb.Ui.UnblockUi();

                var errorMessage = err.message;
                if (err.code == plupload.FILE_SIZE_ERROR && maximumFileSizeError) {
                    errorMessage = maximumFileSizeError;
                }
                if (err.code == plupload.FILE_EXTENSION_ERROR && allowedExtensionsError) {
                    errorMessage = allowedExtensionsError;
                }

                if ($nameContainer.hasClass("file-name")) {
                    $nameContainer.parents('.group-inner').addClass('error');
                    $nameContainer.parents('.group-inner').find('.error-msg').remove();
                    $nameContainer.parents('.group-inner').append('<p class="error-msg">' + errorMessage + '</p>')
                } else {
                    $nameContainer.find('.group-inner').addClass('error');
                    $nameContainer.find('.group-inner').find('.error-msg').remove();
                    $nameContainer.find('.group-inner').append('<p class="error-msg">' + errorMessage + '</p>')

                }
            }
        }
    });

    uploader.init();
};
DeWeb.Utilities.transferMap = function ($this) {

    var bPath = $this.data('content-path');
    var displayOn = $this.data('display-on');
    var realFacilities = [];
    var facilitiesJson = $this.data('facilities-json');
    var br = 0;
    for (var i = 0; i < facilitiesJson.length; i++) {
        if (facilitiesJson[i] == null) {
            continue;
        }
        realFacilities[br] = facilitiesJson[i];
        br = br + 1;
    }
    DeWeb.Functionalities.AtmBranchMap.Init("", bPath, "transfermap", facilitiesJson);

};

DeWeb.Utilities.RenderFooter = function ($this) {
    var id = $this.data("id");
    var $replContent = $('#' + id);
    var linkTo = $this.data("link");
    $.ajax({
        url: linkTo,
        success: function (markup) {
            $replContent.append(markup);
        }
    });
}
DeWeb.Utilities.processMessages = function ($this) {
    var title = $this.data('title');
    var faulty = $this.data('is-faulty');
    var messages = $this.data('messages');
    var messageType = $this.data('message-type');
    var customRender = $this.data('custom-render');
    var placement = $this.data('placement');

    $('.toast-notification').slideUp(300, function () {
        $(this).remove();
    });
    if (messages) {
        var messagesArray = messages.split(';');
        if (messagesArray.length) {

            if (!customRender) {
                if (placement !== DeWeb.Enums.UiContentPlacementEnum.INLINE) {
                    for (var i = 0; i < messagesArray.length; i++) {
                        if (messagesArray[i]) {
                            var options = {
                                isFaulty: faulty,
                                title: title,
                                content: messagesArray[i],
                                displayType: messageType,
                                placement: placement
                            };
                            DeWeb.Ui.ShowNotification(options);
                        }
                    }
                } else {
                    var template = DeWeb.Ui.Templates.PopupNotificationTemplate;
                    var paragraphAr = [];

                    for (var i = 0; i < messagesArray.length; i++) {
                        if (messagesArray[i]) {
                            paragraphAr.push('<p>' + messagesArray[i] + '</p>');
                        }
                    }
                    var newNotification = template
                        .replace('{suc')
                        .replace('{color}', '')
                        .replace('{icon-class}', faulty ? "icon -x" : "icon -success")
                        .replace('{notification-title}', title ? title : "")
                        .replace('{notification-content}', paragraphAr.join(''));

                    DeWeb.Ui.ShowPopup(newNotification, "narrow");
                }
            } else {
                for (var i = 0; i < messagesArray.length; i++) {
                    if (messagesArray[i]) {
                        var options = {
                            isFaulty: faulty,
                            title: title,
                            content: messagesArray[i],
                            displayType: messageType,
                            placement: placement
                        };
                        DeWeb.Events[customRender](options);
                    }
                }
            }
        }
    }
}


DeWeb.Utilities.imageUploadFormField = function ($this) {
    var uploadPath = $this.data('upload-path');
    var getPath = $this.data('get-path') + "?fileName=";
    var uploadedData = $this.data('existing-files');
    var uploadedSplitted = [];

    var btn = $this.siblings('.upload-btn');
    var $nameContainer = $this.siblings('.name-wrapper').find('.file-name');
    var $imageContainer = $('#uploaded-image');


    if (uploadedData) {
        uploadedSplitted = uploadedData.split(',');
    }

    var uploader = new plupload.Uploader({
        runtimes: 'html5,html4',

        browse_button: btn.get(0), // you can pass in id...
        //container: $this.get(0), // ... or DOM Element itself

        url: uploadPath,
        resize: {
            width: 300,
            height: 300,
        },
        filters: {
            max_file_size: '10mb',
            mime_types: [
                { title: "Image files", extensions: "jpg,gif,png" },
                { title: "Zip files", extensions: "zip" }
            ]
        },
        preinit: {
            Init: function (up) {
                // create a new file array for plupload queue
                if (uploadedSplitted.length) {
                    var uploadedCount = 0;
                    var files = new Array();

                    // create a new file object
                    for (var i = 0; i < uploadedSplitted.length; i++) {
                        if (uploadedSplitted[i]) {
                            var f = new plupload.File(uploadedSplitted[i], uploadedSplitted[i], 0);
                            f.status = plupload.DONE;
                            f.percent = 100;
                            files.push(f);
                            uploadedCount++;
                        }
                    }
                    // append files to our array
                    up.files = files;

                    // create a new QueueProgress and configure
                    var queueprogress = new plupload.QueueProgress();
                    queueprogress.size = uploadedCount;
                    queueprogress.uploaded = uploadedCount;
                    queueprogress.percent = 100;

                    // set uploader queue process and reload ui
                    up.total = queueprogress;
                    up.trigger("QueueChanged");
                    up.refresh();
                }

            }
        },
        init: {
            PostInit: function () {
                $this.val('');
                if (uploadedSplitted.length) {
                    $nameContainer.text(uploadedSplitted[0]);
                }
            },

            FilesAdded: function (up, files) {
                plupload.each(files, function (file) {
                    //document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></div>';
                    $nameContainer.text(file.name);
                });

                uploader.start();
            },

            UploadProgress: function (up, file) {
                //document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
            },
            FileUploaded: function (uploader, file, response) {
                if (response) {
                    var responseobject = JSON.parse(response.response);
                    console.log($imageContainer);
                    $imageContainer.show();
                    $imageContainer.attr("src", getPath + responseobject.fileid);
                    $('#' + $this.attr('id')).val(responseobject.fileid + ":" + responseobject.filename);
                }
            },
            Error: function (up, err) {
                document.getElementById('console').innerHTML += "\nError #" + err.code + ": " + err.message;
            }
        }
    });

    uploader.init();
};

//END FORM FIELDS




DeWeb.Utilities.selectMenu = function ($this) {


    var trigger = $this;
    var CurrencyChanger =
    {
        Id: "CurrencyChange",
        CurrencyChange: function (currency) {
            ebs.RaiseEvent(CurrencyChanger, { CommandName: 'CurrencyChanged', Currency: currency });
        }
    };
    ebs.AddListener(CurrencyChanger);
    trigger.selectmenu({
        change: function (event, ui) {

            $(trigger)
                .children()
                .each(function () {
                    if (this.selected) {
                        $("p#" + $(this).data("accountnumber") + "[name=available-amount]").text($(this).data("amount"));
                        CurrencyChanger.CurrencyChange($(this).text());
                    }
                });
        }
    }
    );


};
DeWeb.Utilities.customselectMenu = function ($this) {
    var trigger = $this;
    trigger.selectmenu({
        change: function (event, ui) {
            $(trigger)
                .children()
                .each(function () {
                    if (this.selected)
                        $("p#" + $(this).data("accountnumber") + "[name=available-amount]")
                            .text($(this).data("amount"));
                });

        }
    }
    );

}

DeWeb.Utilities.selectField = function ($this) {

    var trigger = $this;
    var parent = trigger.parent();

    trigger.ddslick();

    if (trigger.is(':disabled')) {
        parent.addClass('disabled').find('input').remove();
    }
};

DeWeb.Utilities.accountTabs = function ($this) {

    var listItem = $('.list-item .inner');

    $this.click(function () {
        var tabId = $(this).data('tab');
        // console.log(tabId);
        if (!$(this).hasClass('active')) {
            $(this).addClass('active').siblings().removeClass('active');
            $('.account-tab.active').removeClass('active');
            setTimeout(function () {
                $('.account-tab.tab-' + tabId).addClass('active');
            }, 500);
        }
    });

};

DeWeb.Utilities.showOrHide = function ($this) {

    var list = $("li.list-item");
    var sliderHeight;
    var accountWidget = $('#promo-dashboard');
    var listHeight;
    var accountSlider = $('#account-slider');
    var accountList = $("#account-list");
    function heightDetect() {
        sliderHeight = accountSlider.height() + 100;
        listHeight = accountList.height() + 60;
    };

    function heightSet() {
        if ($('.tab-1').hasClass('active')) {
            $('#promo-dashboard').css('height', sliderHeight);
        } else if ($('.tab-2').hasClass('active')) {
            $('#promo-dashboard').css('height', listHeight);
        }
    };
    $this.click(function () {
        if ($this.data("command") == "show") {
            list.each(function () {
                $(this).show();
            });
            $this.data("command", "hide");
            $("#title").text($this.data("hide-label"));

        } else {
            for (var i = 5; i < list.length; i++) {
                $(list[i]).hide();
            }
            $("#title").text($this.data("show-label"));
            $this.data("command", "show");
            heightDetect();
            heightSet();
        }

    });


};
DeWeb.Utilities.renderReport = function ($this) {
    $this.off('click').on('click', function (e) {
        e.preventDefault();
        DeWeb.Ui.BlockUi();
        var format = $this.data('format');
        var parameters = $this.data('parameters');
        var template = $this.data('template');
        var href = $this.data('href');

        var formData = "format=" + format;
        formData += "&template=" + template;

        var byDateFrom = false;
        var byDateTo = false;
        var pageNumberIndex = -1;
        var pageSizeIndex = -1;
        var index = 0;

        for (var i = parameters.length - 1; i >= 0; i--)
        {

            if (!byDateFrom && (parameters[i].Name == 'DateFrom') && parameters[i].Value != null) {
                byDateFrom = true;
            }

            else if (!byDateTo && (parameters[i].Name == 'DateTo') && parameters[i].Value != null) {
                byDateTo = true;
            }

            else if (parameters[i].Name == 'PageNumber') {
                pageNumberIndex = i;
            }

            else if (parameters[i].Name == 'PageSize') {
                pageSizeIndex = i;
            }

            else
            {
                formData += "&parameters[" + index + "].Name=" + parameters[i].Name;
                formData += "&parameters[" + index + "].Value=" + parameters[i].Value;
                index++;
                pageNumberIndex--;
                pageSizeIndex--;
                parameters.splice(i, 1);
            }
        }

        //if the list is searched by date it should return all results with that filter
        if ((byDateFrom || byDateTo) && pageNumberIndex > -1 && pageSizeIndex > -1) {
            parameters[pageNumberIndex].Value = 1;
            parameters[pageSizeIndex].Value = 2147483647;
        }

        if (parameters.length > 0)
        {
            for (var i = parameters.length - 1; i >= 0; i--) {
                formData += "&parameters[" + index + "].Name=" + parameters[i].Name;
                formData += "&parameters[" + index + "].Value=" + parameters[i].Value;
                index++;
            }
        }
    
        if (template=="Payment_Transfers" && byDateFrom && !byDateTo)
        {
            var date = new Date();
            date.setDate(date.getDate()+1);
            var month = date.getMonth()+1;
            var day = date.getDate();
            var year = date.getFullYear();
            formData += "&parameters[" + index + "].Name=DateTo";
            formData += "&parameters[" + index + "].Value="+('0'+month).slice(-2)+"/"+('0'+day).slice(-2)+"/"+year;
            index++;
        }

        $.ajax({
            type: "post",
            data: formData,
            url: href + '/PrepareReport',
            success: function (data) {
                var src = href + '/DownloadReport/' + data.id;
                //timer in case iframe never loads
                var renderReportTimeout = window.setTimeout(function () {
                    DeWeb.Ui.UnblockUi();
                }, 10000);

                $('.download-iframe').remove();
                var frame = '<iframe width="0" id="download-iframe" class="download-iframe" height="0" src="' + src + '"></iframe>';
                $('#page-content').append("<div style=\"display:none;\">" + frame + "</div>");
                document.getElementById('download-iframe').onload = function () {
                    //iframe has loaded something, cancel the timer
                    console.log("iframe loaded...");
                    window.clearTimeout(renderReportTimeout);
                    DeWeb.Ui.UnblockUi();
                }
            },
            error: function () {
                DeWeb.Ui.UnblockUi();
            }
        });
    });
}
DeWeb.Utilities.checkBoxListFormField = function ($this) {
    $this.screwDefaultButtons();
    $this.parent().click(function () {
        var formFieldVal = $("#" + $this.data("id")).val();
        var thisVal = $this.data("value");
        if ($(this).hasClass("checked") && formFieldVal.indexOf(thisVal) === -1) {
            $("#" + $this.data("id")).val(formFieldVal + "," + thisVal);
        }
        if (!$(this).hasClass("checked") && formFieldVal.indexOf(thisVal) !== -1) {
            var str = formFieldVal.replace(thisVal, "");
            str = str.replace(/,\s*$/, "");
            $("#" + $this.data("id")).val(str);
        }

    });
};

DeWeb.Utilities.selectAllCheckBoxes = function ($this) {
    var selector = $this.data('container-selector');
    var $container = $(selector);

    $this.on('change', function () {
        if ($container.length) {
            if ($this.get(0).checked) {
                $.each($container.find('.checkbox-1'), function () {
                    var $chc = $(this);
                    $chc.screwDefaultButtons('check');
                });

            } else {
                $.each($container.find('.checkbox-1'), function () {
                    var $chc = $(this);
                    $chc.screwDefaultButtons('uncheck');
                });
            }
        }
    });
};

DeWeb.Utilities.accountWidgetSize = function ($this) {
    var AccountWidget =
    {
        Id: "AccountWidgetId",
        ChangeView: function (viewName, accountInFocus, kind) {
            ebs.RaiseEvent(AccountWidget, { CommandName: 'ViewChanged', Account: accountInFocus, ViewName: viewName, Kind: kind });
        }
    };
    ebs.AddListener(AccountWidget);

    var accountSlider = $('#account-slider');
    var accountList = $('#account-list');
    var tabBtnSide = $('ul.list-options-side').children();
    var tabBtn = $('ul.list-options').children();

    var sliderHeight;
    var listHeight;
    var activeTab = "slider";

    var heightSet = function () {

        if (activeTab === "slider") {
            var picker = $('#accountsPicker').height();
            var slider = $('#account-slider').height() + 30;
            var height;

            if (picker && $(window).width() >= 720) {
                height = 345;
            }
            else {
                height = picker ? picker : slider; 
            }
            $this.css({ 'height': height });
        }
        else {
            var accountList = $('#account-list').height() + 60;
            $this.css({ 'height': accountList });
        }
    };

    var scrollTo = function () {

        var listItems = $('.account-list .list-item');
        var counter = 0;
        if (listItems.length > 2) {
            for (var i = 0; i < listItems.length; i++) {
                var selected = listItems[i];
                if (selected.classList.contains('selected')) {
                    counter = i;
                    break;
                }
            }
            var selected = $('.account-list .list-item.selected');
            var listItemHeight = selected.height();

            var height = listItemHeight * counter;

            $('.account-list').find('#mCSB_2').animate({ scrollTop: height }, 1000);
        }
    };

    //Change view
    tabBtn.click(function () {
        var silderTabId = $(this).data('tab');
        var selectedHorizontalAccount = escapeAccountChars($('body').find('div.slick-center').data('accountnumber'));
        if (tabId === 2) {
            var selectedType = $("#slider-carousel-side").find(".active").attr("id");
            if (selectedType == 'credit-card-account,credit-facility-account') {
                selectedType = selectedType.split(',')[0];
            }
            var selectedAccount = $(".slick-list").find(".slick-current").data("accountnumber");
            var slider = $("#slider-list-side").find("#" + selectedType);
            $("[name=slider]").hide();
            activeTab = "list";
            var accno = $("#selected-account").val();
            if (accno == undefined)
                accno = $("#" + $(this).data('card-field')).val();
            $("li[data-accountnumber=" + escapeAccountChars(accno) + "]").addClass("selected").siblings().removeClass('selected');
            AccountWidget.ChangeView("list", accno);
        } else {            
            var selectedType = $("#slider-list-side").find(".active").attr("id");
            var selectedAccount = $(".slick-list").find(".slick-current").data("accountnumber");
            var slider = $("#slider-carousel-side").find("#" + selectedType);
            $("[name=slider]").show();
            // var accno = 
            //$("#promo-dashboard").removeClass().addClass("");

            var accno = $("#selected-account").val();
            // Treba da mi fokus bude na drugom
            AccountWidget.ChangeView("slider", accno);
            activeTab = "slider";
        }
        if (!$(this).hasClass('active')) {
            $(this).addClass('active').siblings().removeClass('active');
            $('.account-tab.tab-' + $(this).addClass('active').siblings().data("tab")).css('display', 'none');
            $('.account-tab.tab-' + tabId).css('display', 'block');
        }
        $('body').find('li.list-item').removeClass('selected');
        var selectedVerticalAccount = $('body').find('li.list-item[data-accountnumber=' + selectedHorizontalAccount + ']');
        selectedVerticalAccount.addClass('selected');
        slider.click();
        heightSet();
    });
    tabBtnSide.click(function () {
        var tabId = $(this).data('tab');
        var selectedTab = "";
        var kind = "";
        var acc = "";
        if (tabId === 2) {        

            var selectedSlideListType = $("#slider-carousel-side").find(".active").attr("id");
            var selectedSlideKind = kind = $(".slick-list").find(".slick-current").data("acckind");
            var slidersList = $('ul.account-list').find('.list-item');

            var selectedSliderSlide = $(".slick-list").find(".slick-current").data("accno");
            acc = selectedSliderSlide;
            if (selectedSlideListType != undefined) {
                var slider = $("#slider-list-side").find("#" + selectedSlideListType);
                $("[name=slider]").hide();
                selectedTab = selectedSlideListType;
                activeTab = "list";
                var st = $('#slider-list-side').children();
                for (var t = 0; t < st.length; t++) {

                    if (st[t].id == selectedTab) {

                        st[t].classList.add('active');
                    }
                    else {
                        st[t].classList.remove('active')
                    }
                }
                slider.click();
            }
            $("#selected-account").val(selectedSliderSlide);
            $('#Accounts_ID').val(selectedSliderSlide);
            $('#Cards_ID').val(selectedSliderSlide);
            slidersList.removeClass('selected')
            $('ul.account-list [data-accno="' + selectedSliderSlide + '"][data-acckind="' + selectedSlideKind + '"]').addClass('selected');
            

            AccountWidget.ChangeView("slider", selectedSliderSlide, selectedSlideKind);

        }
        else {
            
            var selectedType = $("#slider-list-side").find(".active").attr("id");
            var selectedSlideKind = kind = $(".account-list").find(".list-item.selected").data('acckind');
            var slidersList = $('ul.account-list').find('.list-item');

            var selectedListSlide = $(".account-list").find(".list-item.selected").data('accno');
            if (selectedListSlide == null && selectedSlideKind == null) {                
                selectedListSlide = $("#selected-account").val();
                for (i = 0; i < slidersList.length; i++) {
                    if (slidersList.eq(i).data("accno") == selectedListSlide) {
                        selectedSlideKind = slidersList.eq(i).data("acckind");
                    }
                }
            }
            acc = selectedListSlide;
            if (selectedType != undefined) {
                var slider = $("#slider-carousel-side").find("#" + selectedType);
                $("[name=slider]").show();
                selectedTab = selectedType;
                activeTab = "slider";
                var st = $('#slider-carousel-side').children();
                for (var t = 0; t < st.length; t++) {

                    if (st[t].id == selectedTab) {

                        st[t].classList.add('active');
                    }
                    else {
                        st[t].classList.remove('active')
                    }
                }
                slider.click();
            }       
            $("#selected-account").val(selectedListSlide);
            $('#Accounts_ID').val(selectedListSlide);
            $('#Cards_ID').val(selectedListSlide);

            AccountWidget.ChangeView("slider", selectedListSlide, selectedSlideKind);
            slidersList.removeClass('selected');
            $('ul.account-list [data-acckind="' + selectedSlideKind + '"][data-accno="' + selectedListSlide + '"]').addClass('selected');
        }
        if (!$(this).hasClass('active')) {
            $(this).addClass('active').siblings().removeClass('active');
            $('.account-tab.tab-' + $(this).addClass('active').siblings().data("tab")).css('display', 'none');
            $('.account-tab.tab-' + tabId).css('display', 'block');
        }

        heightSet();
        var list = $('ul.account-list').find(".list-item.selected");
        if (list.data("acckind") == kind && list.data("accno") == acc) {
            list.addClass('selected');
            list.click();
            }
        else {
            list.removeClass('selected');
        }

        scrollTo();
    });


    //// Show and hide list item view for button showOrHide
    //var listItem = accountList.find('.list-item');
    //var listLength = listItem.length;
    //for (var i = 5; i < listLength; i++) {
    //    $(listItem[i]).hide();
    //};

    //$('.more-list').click(function () {
    //    listItem = accountList.find('.list-item');

    //    if ($(this).css("display") === "none") {
    //        for (i = 5; i < listLength; i++) {
    //            listItem.eq(i).fadeIn();
    //        };
    //        heightDetect();
    //        heightSet();
    //        $(this).addClass('active');
    //    } else {
    //        $(this).removeClass('active');
    //        for (i = 5; i < listLength; i++) {
    //            listItem.eq(i).slideUp(300);
    //        };
    //        setTimeout(function () {
    //            heightDetect();
    //            heightSet();
    //        }, 400);
    //    }

    //});

    $(window).resize(function () {
        heightSet();
    });
};

DeWeb.Utilities.customCheckbox1 = function ($this) {
    $this.screwDefaultButtons();
};
DeWeb.Utilities.closeNotification = function ($this) {

    $this.click(function (e) {
        e.preventDefault();
        $(this).closest('.notification').slideUp(300);
    });

};

menuFocus = function ($this) {
    if ($this !== undefined) {
        var target = ($this).parents(".page-dashboard");
        var offset = $this[0].offsetTop;
        if ($this.hasClass('open')) {
            $('html, body').animate({
                scrollTop: $this.offset().top
            }, 1000);
        }
        else {
            $('html, body').animate({
                scrollTop: -$this.offset().top
            }, 1000);
        }
    }
};

focusAccountListView = function () {
    var target = $(".selected").parents(".mCustomScrollbar");
    target.mCustomScrollbar("scrollTo", $(".selected"), {
        scrollInertia: 3000
    });
};

DeWeb.Utilities.customScroll = function ($this) {
    $this.mCustomScrollbar({
        scrollInertia: 250,
    });
    //focusAccountListView();
};

DeWeb.Utilities.accountTabs = function ($this) {

    var listItem = $('.list-item .inner');

    $this.click(function () {
        var tabId = $(this).data('tab');
        // console.log(tabId);
        if (!$(this).hasClass('active')) {
            $(this).addClass('active').siblings().removeClass('active');
            $('.account-tab.active').removeClass('active');
            setTimeout(function () {
                $('.account-tab.tab-' + tabId).addClass('active');
            }, 500);
        }
    });

};

DeWeb.Utilities.closeInbox = function ($this) {

    function close() {
        $('body').removeClass('inbox-open');
        $('.modal-inbox').fadeOut(500);
        $('.inbox-popup.active').removeClass('active');
    }

    $this.click(function (e) {
        e.preventDefault();
        close();
    });

    $('.inbox-inner').click(function () {
        close();
    });
    $('.inbox-popup').click(function (e) {
        e.stopPropagation();
    });
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            if ($('body').hasClass('inbox-open')) {
                close();
            }
        }
    });
};
DeWeb.Utilities.toggleOptions = function ($this) {
    $this.click(function (e) {
        e.preventDefault();
        $this.toggleClass('active');
        $this.closest('.widget-slat').find('.expanable').slideToggle(300);
    });
}

DeWeb.Utilities.accountSlider2 = function ($this) {

    var slider = $this,
        wrap = slider.parent();
    slides = slider.find('.slide');

    if (slides.length < 2) {
        wrap.addClass('single-slide');
    } else {
        if (slides.length == 2 || slides.length == 3) {
            console.log(slides.length);
            slides.clone().appendTo(slider);
        }

        slider.slick({
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: 1,
            infinite: true,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]

        });

        slider.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
            var items = slider.find('.slide');
            EA.LoadMethod(items);
        });

        $('.slider-button-prev').click(function () {
            slider.slick('slickPrev');
        });
        $('.slider-button-next').click(function () {
            slider.slick('slickNext');
        });
    }

};


DeWeb.Utilities.closeNotification = function ($this) {

    $this.click(function (e) {
        e.preventDefault();
        $(this).closest('.notification').slideUp(300);
    });

};

DeWeb.Utilities.closePopup = function ($this) {

    //function close() {
    //    $('body').removeClass('popup-open');
    //    $('.modal-container').fadeOut(500);
    //    $('.popup-box.active').fadeOut(500).removeClass('active');
    //}

    //$this.click(function (e) {
    //    e.preventDefault();
    //    close();
    //});

    //$('.modal-inner').click(function () {
    //    close();
    //});
    //$('.popup-box').click(function (e) {
    //    e.stopPropagation();
    //});
    //$(document).keyup(function (e) {
    //    if (e.keyCode == 27) {
    //        if ($('body').hasClass('popup-open')) {
    //            close();
    //        }
    //    }
    //});
};
function doGet(href, replaceContainerId, loadingElement) {
    onAjaxBegin(loadingElement);
    $.get(href).done(function (data) {
        if (data) {
            onAjaxSuccess(loadingElement);
            $('#' + replaceContainerId).html(data);
        } else {
            onAjaxFailure(loadingElement);
        }
    });
}
DeWeb.Utilities.doGet = function ($this) {
    var id = $this.attr('id');
    var href = $this.data('href');
    DeWeb.AjaxForms.OnAjaxBegin(id);
    $.get(href).done(function (data) {
        if (data) {
            $('#' + id).html(data);
            DeWeb.AjaxForms.OnAjaxSuccess(id);
            DeWeb.LoadUtilities($('#' + id));
        } else {
            DeWeb.AjaxForms.OnAjaxFailure(id);
        }
    });
};

DeWeb.Utilities.updateExchangeRateBaselineCurrency = function ($this) {
    $this.on('change', function () {
        DeWeb.Utilities.doGet($("select option:selected"));
    });
};

DeWeb.Utilities.submitFormOnChange = function ($this) {
    var form = $this.data("formid");
    form = "form_" + form;

    $this.change(function () {
        $("#" + form).submit();
    });
};

DeWeb.Utilities.submitFormOnEnter = function ($this) {
    var form = $this.data("formid");
    form = "form_" + form;

    $($this).keypress(function (e) {
        if (e.which == 13) {
            $("#" + form).submit()
            return false;
        }
    });
};



DeWeb.Utilities.radioField = function ($this) {
    $this.screwDefaultButtons({
        image: "url(img/icons-2x/radio-1.jpg)",
        width: 20,
        height: 20
    });
};


DeWeb.Utilities.dateInput = function ($this) {

    // Date input
    $this.datepicker({
        dateFormat: "dd/mm/yy",
        firstDay: 1,
    });
};

DeWeb.Utilities.dropdownTrigger = function ($this) {

    $this.click(function (e) {
        e.preventDefault();

        if (!$(this).parent().hasClass('active')) {
            $(this).parent().addClass('active');
        } else {
            $(this).parent().removeClass('active');
        }
    });
    $('html, body').click(function () {
        $('.grid-option.active').removeClass('active');

    });

    $('.option-dropdown').click(function (event) {
        event.stopPropagation();
    });
};

DeWeb.Utilities.accountList = function ($this) {
    
    var AccountPicker =
    {
        Id: "AccountPicker",
        ChangeAccount: function (account) {
            
            var selected = $('ul.account-list').find('.list-item.selected').data('accno')
            if (account != selected) {
                account = selected;
            }
            account = escapeAccountChars(account);

            //if ($(".slide[data-accountnumber=" + account + "]").data("acckind") === "debit-card") {
            //    account = $(".slide[data-accountnumber=" + account + "]").data("accno");
            //}
            
            //if ($('ul.account-list').find('.list-item.selected').data('acckind') === "credit-card-account") {                
            //    var cardNo = account.split("-")[1];
            //    $("[name=Cards_ID]").val(account.split("-")[1]);
            //    $("[name=CardSettlementAccountId]").val(account.split("-")[0]);
            //    $("#selected-account").val(account);
            //    ebs.RaiseEvent(AccountPicker, { CommandName: 'AccountChanged', Account: cardNo.replaceAll('\\', '') });
            //}

            var kind = $('ul.account-list').find('.list-item.selected').data('acckind');
            if (kind === "debit-card" || kind === "credit-card-account") {
                var cardNo = account.split("-")[1];
                $("[name=Cards_ID]").val(cardNo);
                $("[name=CardSettlementAccountId]").val(account.split("-")[0]);
                $("#selected-account").val(account);
                ebs.RaiseEvent(AccountPicker, { CommandName: 'AccountChanged', Account: account.replaceAll('\\', ''), Kind: kind});
            }
            else {
                $("#selected-account").val(account);
                $('#Accounts_ID').val(account);
                ebs.RaiseEvent(AccountPicker, { CommandName: 'AccountChanged', Account: account.replaceAll('\\', '') });
            }
        }
    };
    ebs.AddListener(AccountPicker);
    var ViewChangedCatch =
    {
        Id: "ViewChangedCatchId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'ViewChanged':
                    if (args.ViewName == "list") {
                        $("li[data-accno=" + args.Account + "]").addClass("selected").siblings().removeClass('selected');
                    }
                    break;
            }
        }
    };

    $(document).ready(function () {
        ebs.AddListener(ViewChangedCatch);

    });

    // remove sortable list option -- only making bugs..
    //$(".tab-2.gridster ul").sortable({
    //    cursor: "move",
    //    forcePlaceholderSize: true,

    //    // animation speed
    //    sortAnimateDuration: 200,

    //    // enable sort animation
    //    sortAnimate: true
    //});

    //$(".tab-2.gridster ul").disableSelection();
    //// Disable on mobile
    //function sortableToggle() {
    //    if ($(window).width() > 980) {
    //        $(".tab-2.gridster ul").sortable("option", "handle", false);
    //    } else {
    //        $(".tab-2.gridster ul").sortable("option", "handle", ".drag");
    //    }
    //}

    //sortableToggle();
    //$(window).resize(function () {
    //    sortableToggle();
    //})

    //Init selection 
    var accno = $("#selected-account").val();

    // Item selection
    $('.list-item').click(function () {
        $(this).addClass('selected').siblings().removeClass('selected');
        //$("#selected-account").val($(this).data("accountnumber"));
        AccountPicker.ChangeAccount($("#selected-account").val(), null);
    });
};
DeWeb.Utilities.favoriteToggle = function ($this) {

    $this.click(function (e) {
        e.preventDefault();
        $(this).parent().toggleClass('active');
    });

};

//DeWeb.Utilities.googleContacts = function($this) {
DeWeb.Utilities.googleContactsSlider = function ($this) {
    var peopleForSlider = [];
    var people = [];

    function handleClientLoad() {
        // Load the API client and auth2 library
        gapi.load('client:auth2', initClient);
    }

    function initClient() {
        gapi.client.init({
            apiKey: DeWeb.Config.GoogleApiKey,
            discoveryDocs: ["https://people.googleapis.com/$discovery/rest?version=v1"],
            clientId: DeWeb.Config.GoogleCliendId,
            scope: 'profile https://www.googleapis.com/auth/contacts.readonly'
        })
            .then(function () {
                gapi.auth2.getAuthInstance().isSignedIn.listen(updateSigninStatus);
                updateSigninStatus(gapi.auth2.getAuthInstance().isSignedIn.get());
            });
    }

    function updateSigninStatus(isSignedIn) {
        if (isSignedIn) {
            makeApiCall();
        } else {
            handleAuthClick();
        }
    }

    function handleAuthClick(event) {
        gapi.auth2.getAuthInstance().signIn();
    }

    function handleSignoutClick(event) {
        gapi.auth2.getAuthInstance().signOut();
    }

    function makeApiCall() {
        gapi.client.people.people.connections.list({
            'resourceName': 'people/me',
            'pageSize': 500,
            'sortOrder': 'FIRST_NAME_ASCENDING',
            'requestMask': {
                'includeField': 'person.names,person.numbers,person.emailAddresses'
            }
        })
            .then(function (resp) {
                var batchArray = [];
                for (var i = 0; i < resp.result.connections.length; i++) {
                    batchArray.push(resp.result.connections[i].resourceName);
                    if (batchArray.length == 50) {
                        gapi.client.people.people.getBatchGet({
                            'resourceNames': batchArray,
                            'pageSize': 500,
                            'requestMask': {
                                'includeField': 'person.names,person.numbers,person.emailAddresses'
                            }
                        })
                            .then(function (response) {
                                for (var j = 0; j < response.result.responses.length; j++) {
                                    people.push(response.result.responses[j].person);
                                }
                            },
                                function (reason) {
                                    console.log('Error: ' + reason.result.error.message);
                                });
                        batchArray = [];
                    }
                }
                gapi.client.people.people.getBatchGet({
                    'resourceNames': batchArray,
                    'pageSize': 500,
                    'requestMask': {
                        'includeField': 'person.names,person.numbers,person.emailAddresses'
                    }
                })
                    .then(function (response) {
                        for (var j = 0; j < response.result.responses.length; j++) {
                            people.push(response.result.responses[j].person);
                        }
                        for (var k = 0; k < people.length; k++) {
                            if (people[k].names &&
                                people[k].names.length > 0 &&
                                people[k].phoneNumbers &&
                                people[k].phoneNumbers.length > 0 &&
                                people[k].photos &&
                                people[k].photos.length > 0) {
                                var show = false;
                                for (var l = 0; l < people[k].phoneNumbers.length; l++) {
                                    var phoneNumber = people[k].phoneNumbers[l].canonicalForm;
                                    if (phoneNumber != null && phoneNumber.indexOf('+3816') > -1)
                                        show = true;
                                }
                                if (show) {
                                    peopleForSlider.push(people[k]);
                                }
                            }
                        }
                        peopleForSlider.sort(SortByName);
                        window.cachedPeople = peopleForSlider;

                        putSlider();
                    },
                        function (reason) {
                            console.log('Error: ' + reason.result.error.message);
                        });
            },
                function (reason) {
                    console.log('Error: ' + reason.result.error.message);
                });

    }

    function SortByName(personA, personB) {
        var aName = personA.names[0].displayName.toLowerCase();
        var bName = personB.names[0].displayName.toLowerCase();
        return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
    }


    function putSlider() {
        var slider = $('<div class="group uk-width-10-10"><div class="hint-picure-wrapper contact-picker-wrapper"><ul class="hint-pictures" data-utility="avatarSelect" id="contacts-picker"></div></div>');
        var sliderItem = $('<li><img class="circle-img contact-img" src="#"></li>');

        for (var i = 0; i < window.cachedPeople.length; i++) {
            var person = window.cachedPeople[i];
            var slClone = sliderItem.clone().find('img').first().attr('src', person.photos[0].url);

            if (person.phoneNumbers.length) {
                slClone.data('phone', person.phoneNumbers[0].canonicalForm);
                slClone.data('name', person.names[0].displayName);
            }
            slider.find('ul').first().append(slClone);
        }

        var $parentContainer = $this.parents('.custom-form').first();

        $parentContainer.prepend(slider);

        $('.contact-img').on('click', function () {
            $('.contact-img').removeClass('selected');
            $(this).addClass('selected');
            $('#CreditorName_ID').val($(this).data('name'));;
            $('#CreditorIdentifier_ID').val($(this).data('phone'));;
        });

        $('#contacts-picker').slick({
            centerMode: true,
            centerPadding: '60px',
            slidesToShow: 13,
            swipeToSlide: true,
            arrows: false,
            responsive: [
                {
                    breakpoint: 768,
                    settings: {
                        arrows: false,
                        centerMode: true,
                        centerPadding: '40px',
                        slidesToShow: 3
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        arrows: false,
                        centerMode: true,
                        centerPadding: '40px',
                        slidesToShow: 1
                    }
                }
            ]
        });
    }
    $('#contactIconCreditor img').on('click', function () {
        handleClientLoad();
    });
}

DeWeb.Utilities.menuTrigger = function ($this) {

    var body = $('body');
    var trigger = $('.menu-btn');

    $this.click(function () {
        if (!$(this).hasClass('active')) {
            body.addClass('menu-open fixed-height');
            trigger.addClass('active');
        } else {
            body.removeClass('menu-open');
            trigger.removeClass('active');
            // $('.mobile-menu .main-nav li.active').removeClass('active').find('.subnav').slideUp(300);
            setTimeout(function () {
                body.removeClass('fixed-height');
            }, 200);
        }
    });

    $(window).resize(function () {
        if ($(window).width() > 980) {
            if (body.hasClass('menu-open')) {
                trigger.removeClass('active');
                body.removeClass('mobile-open');
                setTimeout(function () {
                    body.removeClass('fixed-height');
                }, 200);
                // $('.mobile-menu .main-nav li.active').removeClass('active').find('.subnav').slideUp(300);
            }
        }
    });

};
DeWeb.Utilities.preloginSlider = function ($this) {
    var slider = $this;
    var images = $this.data('images');
    slider.slick({
        slidesToShow: 1,
        arrows: false,
        dots: true,
        infinite: false,
        fade: true,
        cssEase: 'linear',
        autoplay: true,
        autoplaySpeed: 15000
    });
    $(slider).on('beforeChange', function (event, slick, currentSlide, nextSlide) {
        $(".slide .inner").each(function () {
            if ($(this).parent().data("slick-index") == nextSlide) {
                $(this).css('display', "block");
            }
            else {
                $(this).css("display", "none");

            }
        });
        $('#' + $this.data('cover-id')).attr('src', images[nextSlide]);
        $('#' + $this.data('cover-id') + '-mobile').attr('src', images[nextSlide]);
    });

};

DeWeb.Utilities.geolocationMap = function ($this) {

    var location1 = new google.maps.LatLng(44.4325, 26.103889);
    var location2 = new google.maps.LatLng(44.4325, 26.103889);
    var map;

    function initialize() {
        var map_canvas = document.getElementById('geolocation-map');

        var styles = [
            { "featureType": "water", "elementType": "geometry.fill", "stylers": [{ "color": "#d3d3d3" }] }, { "featureType": "transit", "stylers": [{ "color": "#808080" }, { "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "geometry.stroke", "stylers": [{ "visibility": "on" }, { "color": "#b3b3b3" }] }, { "featureType": "road.highway", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "road.local", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#ffffff" }, { "weight": 1.8 }] }, { "featureType": "road.local", "elementType": "geometry.stroke", "stylers": [{ "color": "#d7d7d7" }] }, { "featureType": "poi", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#ebebeb" }] }, { "featureType": "administrative", "elementType": "geometry", "stylers": [{ "color": "#a7a7a7" }] }, { "featureType": "road.arterial", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "road.arterial", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "landscape", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#efefef" }] }, { "featureType": "road", "elementType": "labels.text.fill", "stylers": [{ "color": "#696969" }] }, { "featureType": "administrative", "elementType": "labels.text.fill", "stylers": [{ "visibility": "on" }, { "color": "#737373" }] }, { "featureType": "poi", "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] }, { "featureType": "poi", "elementType": "labels", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.arterial", "elementType": "geometry.stroke", "stylers": [{ "color": "#d6d6d6" }] }, { "featureType": "road", "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] }, {}, { "featureType": "poi", "elementType": "geometry.fill", "stylers": [{ "color": "#dadada" }] }
        ];

        var infoboxes = [];

        var map_options = {
            /*** EXTDE-210 - set on Bucharest ***/
            center: new google.maps.LatLng(44.4325, 26.103889),
            zoom: 16,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: false,
            draggable: !("ontouchend" in document),
            styles: styles,
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_BOTTOM
            },
            mapTypeControlOptions: {
                position: google.maps.ControlPosition.BOTTOM_LEFT
            }
        }

        map = new google.maps.Map(map_canvas, map_options)

        var locImg1 = new google.maps.MarkerImage(
            'img/icons/pin-3.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        /* location1 */
        var markerLoc1 = new google.maps.Marker({
            position: location1,
            map: map,
            icon: locImg1,
        });

        /* location2 */
        var markerLoc2 = new google.maps.Marker({
            position: location2,
            map: map,
            icon: locImg1,
        });

    }

    google.maps.event.addDomListener(window, 'load', initialize);

    $('.map-init').click(function () {
        google.maps.event.trigger(map, 'resize');
    });

};



DeWeb.Utilities.atmBranchWidget = function ($this) {
    $(function () {
        var sourceHref = $this.data('source');
        var ctPath = $this.data('content-path');

        DeWeb.Functionalities.AtmBranchMap.Init(sourceHref, ctPath, "widget");

        //$('#text-search').on('keypress', function (event) {
        //    if (event.which === 13 || event.keyCode === 13) {
        //        var text = $('#text-search').val();
        //        textSearchMap(text);
        //        return false;
        //    }
        //});

        //var textSearchMap = function (text) {
        //    var filter = {
        //        searchText: text.trim()
        //    }
        //    DeWebUtilities.AtmBranchMap.Filter(filter);
        //}
    });

}

DeWeb.Utilities.openInbox = function ($this) {
    //'USE "popupFromLink" utility!'
    alert('USE "popupFromLink" utility!');

    //$this.click(function (e) {
    //    e.preventDefault();

    //    var inboxId = $(this).data('inbox');

    //    if (!$('body').hasClass('inbox-open')) {
    //        $('.modal-inbox').fadeIn(500);
    //        $('body').addClass('inbox-open');
    //        $('.inbox-' + inboxId).addClass('active');
    //    } else {
    //        $('.inbox-popup.active').removeClass('active');

    //        $('.inbox-' + inboxId).addClass('active');
    //    }

    //    if ($(window).width() < 600) {
    //        $('html, body').animate({
    //            scrollTop: 0,
    //        }, 500);
    //    }

    //});
};

DeWeb.Utilities.optionsTrigger = function ($this) {
    $this.click(function () {
        $(this).next().slideToggle(300);

    });
    $('html, body').click(function () {
        $this.next().slideUp(300);
    });

    $this.click(function (e) {
        e.stopPropagation();
    });

};

DeWeb.Utilities.optionsTriggerDashboard = function ($this) {

    $this.click(function () {
        var listItem = ($this).parents(':eq(2)');
        if (listItem.hasClass('selected')) {
            var counter = 0;
            if ($this.siblings('.options-list').css('display') === 'block') { //opened
                if ($(this).hasClass('open')) {
                    var acclist = $this.parent().parent().parent().parent().children();
                    var filterKind = $('#account-list .slider-tabs').find('.active').data('accountkind').split(',');
                    var count = 0;
                    for (j = 0; j < filterKind.length; j++) {
                        var accKind = $('ul.account-list [data-acckind="' + filterKind[j] + '"]');
                        count += accKind.length;
                    }
                    if (count > 3 && (acclist[acclist.length - 1].className.endsWith('selected') || acclist[acclist.length - 2].className.endsWith('selected'))) { //set bigger height for the last 2 accounts
                        var height = $this.parent().parent().parent().parent().height() - 100;
                        $this.parent().parent().parent().parent().css('height', height);
                        $(this).siblings().eq(3).slideUp(300);
                        $(this).siblings().eq(3).css('display', 'none');
                        $this.removeClass('open');
                    }
                    else {
                        $(this).siblings().eq(3).slideUp(300);
                        $(this).siblings().eq(3).css('display', 'none');
                        $this.removeClass('open');
                    }
                }
            }
            else { // closed
                $(this).siblings().eq(3).slideToggle(300);
                $(this).siblings().eq(3).css('display', 'block');
                $this.addClass('open');

                var acclist = $this.parent().parent().parent().parent().children();
                var filterKind = $('#account-list .slider-tabs').find('.active').data('accountkind').split(',');
                var accounts = new Array();
                var count = 0;
                for (j = 0; j < filterKind.length; j++) {
                    var accKind = $('ul.account-list [data-acckind="' + filterKind[j] + '"]');
                    count += accKind.length;                    
                }
                if (count > 3 && (acclist[acclist.length - 1].className.endsWith('selected') || acclist[acclist.length - 2].className.endsWith('selected'))) {
                    var height = $this.parent().parent().parent().parent().height() + 100;
                    $this.parent().parent().parent().parent().css('height', height);
                    $this.parent().parent().parent().parent().parent().animate({ scrollTop: 100 });
                }
            }
        }
    });
    $('html, body').click(function () {
        $('.options-list').slideUp(300);
        if ($(".drag").hasClass("open")) {
            var height = $this.parent().parent().parent().parent().height() - 100;
            $this.parent().parent().parent().parent().css('height', height);
            $(".drag").removeClass('open');
        }
    });

    $('.drag').click(function (e) {
        e.stopPropagation();
    });

};

DeWeb.Utilities.productSlider = function ($this) {

    var slider = $this;

    slider.slick({
        // centerMode: true,
        slidesToShow: 1,
        arrows: false,
        dots: true,
        infinite: false,
        centerPadding: '0px',
        fade: true,
        cssEase: 'linear'
    });

    $('.slider-button-prev').click(function () {
        slider.slick('slickPrev');
    });
    $('.slider-button-next').click(function () {
        slider.slick('slickNext');
    });

};

DeWeb.Utilities.sortableWidgets = function ($this) {

    var sort = $this;
    sort.sortable({
        cursor: "move",
        forcePlaceholderSize: true,
        handle: '.drag-handle',

        update: function () {
            DeWeb.Ui.Dashboard.Save();
        },

        // animation speed
        sortAnimateDuration: 200,

        // enable sort animation
        sortAnimate: true
    });


};

DeWeb.Utilities.preloginBg = function ($this) {
    var userAgent, ieReg, ie;
    userAgent = window.navigator.userAgent;
    ieReg = /msie|Trident.*rv[ :]*11\./gi;
    ie = ieReg.test(userAgent);

    if (ie) {
        var img = document.getElementsByClassName("page-cover");
        var bg = img[0].children[0];
        bg.style.width = '100%';
        bg.style.height = 'auto';
    }
}

DeWeb.Utilities.subnavMobile = function ($this) {
    $this.click(function (e) {
        e.preventDefault();
        //$(this).next().toggle();
        $(this).parent().toggleClass('open-mobile');
        $(this).parent().siblings().removeClass('open-mobile');
    });
};

DeWeb.Utilities.subnavTrigger = function ($this) {

    $this.hover(function (e) {
        if ($(window).width() > 1200) {
            e.preventDefault();
            //$(this).parent().toggleClass('open').siblings('open').removeClass('open');
            $(this).parent().toggleClass('open');
            $(this).parent().siblings().removeClass('open');
        }
    });

    $this.click(function (e) {
        e.preventDefault();
        $(this).parent().toggleClass('open');
        $(this).parent().siblings().removeClass('open');
        DeWeb.Utilities.submenuTransparent($this.siblings(1));
    });

    $('html, body').click(function () {
        $('.main-nav .open').removeClass('open');
        DeWeb.Utilities.submenuTransparent($this.siblings(1));
    });

    $('.main-nav').click(function (e) {
        e.stopPropagation();
    });

    $('.submenu').hover(function (e) {
        if ($(window).width() > 1200) {

            if (e.type == 'mouseenter') {
                $(this).parent().addClass('open');
                var c = $(this).siblings().children().eq(0)[0].className;
                var reg = new RegExp('.-white$');
                if (!reg.test(c)) {
                    var iconclass = c + '-white';
                    $(this).siblings().children().eq(0).removeClass(c);
                    $(this).siblings().children().eq(0).addClass(iconclass);
                }
            }
            else {
                $(this).parent().removeClass('open');
                var c = $(this).siblings().children().eq(0)[0].className;
                var reg = new RegExp('.-white$');
                var className = $(this).parent().eq(0)[0].className.substring(0, 6);
                if (className != 'active') {
                    if (reg.test(c)) {
                        var iconclass = c.substring(0, c.length - 6);
                        $(this).siblings().children().eq(0).removeClass(c);
                        $(this).siblings().children().eq(0).addClass(iconclass);
                    }
                }
            }
        }
    });
};

DeWeb.Utilities.hasMenuHover = function ($this) {
    $this.hover(function (e) {
        if ($(window).width() > 1200) {
            if (e.type == 'mouseenter') {
                var c = $(this).children().eq(0).children().eq(0)[0].className;
                var reg = new RegExp('.-white$');
                var className = $(this).eq(0)[0].className.substring(0, 6);
                if (className != 'active') {
                    if (!reg.test(c)) {
                        var iconclass = c + '-white';
                        $(this).children().eq(0).children().eq(0).removeClass(c);
                        $(this).children().eq(0).children().eq(0).addClass(iconclass);
                    }
                    DeWeb.Utilities.submenuTransparent($this.children().eq(1));
                }
                else {
                    DeWeb.Utilities.active($this);
                    DeWeb.Utilities.submenuTransparent($this.children().eq(1));
                }
            }
            else {
                var c = $(this).children().eq(0).children().eq(0)[0].className;
                var reg = new RegExp('.-white$');
                var className = $(this).eq(0)[0].className.substring(0, 6);
                if (className != 'active') {
                    if (reg.test(c)) {
                        var iconclass = c.substring(0, c.length - 6);
                        $(this).children().eq(0).children().eq(0).removeClass(c);
                        $(this).children().eq(0).children().eq(0).addClass(iconclass);
                    }
                    DeWeb.Utilities.submenuTransparent($this.children().eq(1));
                }
                else {
                    DeWeb.Utilities.active($this);
                    DeWeb.Utilities.submenuTransparent($this.children().eq(1));
                }
            }
        }
    });

    $this.click(function (e) {
        if ($(window).width() < 1200) {
            if (e.type == 'click') {
                var c = $(this).children().eq(0).children().eq(0)[0].className;
                var reg = new RegExp('.-white$');
                var className = $(this).eq(0)[0].className.substring(0, 6);
                var childs = $this.siblings().children().children("i");
                var i;
                if (className != 'active') {
                    for (i = 0; i < childs.length; i++) {
                        if (reg.test(childs[i].className)) {
                            if (childs[i].parentElement.parentElement.className.substring(0, 6) != 'active') {
                                var childName = childs[i].className;
                                var iconclass = childName.substring(0, childName.length - 6);
                                childs[i].className = iconclass;
                            }
                        }
                    }
                    if (!reg.test(c)) {
                        var iconclass = c + '-white';
                        $(this).children().eq(0).children().eq(0).removeClass(c);
                        $(this).children().eq(0).children().eq(0).addClass(iconclass);
                        menuFocus($this);
                    }
                    else {
                        var iconclass = c.substring(0, c.length - 6);
                        $(this).children().eq(0).children().eq(0).removeClass(c);
                        $(this).children().eq(0).children().eq(0).addClass(iconclass);
                        menuFocus($this);
                    }
                    DeWeb.Utilities.submenuTransparent($this.children().eq(1));

                }
                else {
                    DeWeb.Utilities.active($this);
                    DeWeb.Utilities.submenuTransparent($this.children().eq(1));
                }
            }
        }
    });

};

DeWeb.Utilities.active = function ($this) {
    var c = $this.children().eq(0).children().eq(0)[0].className;
    var reg = new RegExp('.-white$');
    if (!reg.test(c)) {
        var iconclass = c + '-white';
        $this.children().eq(0).children().eq(0).removeClass(c);
        $this.children().eq(0).children().eq(0).addClass(iconclass);
        $this.children().eq(0).children().eq(1).css("color", "#209cd8");
        $this.children().eq(0).children().eq(1).css("font-weight", "600");
    }
};

DeWeb.Utilities.hideSearch = function ($this) {
    $this.on('input', function (e) {
        if ($(this).children('input')[0].value != '') {
            $(this).children('button').css('display', 'none');
        }
        else {
            $(this).children('button').css('display', '');
        }
    });
}

DeWeb.Utilities.videoSize = function ($this) {

    var video = $this;

    var videoResize = function () {
        var videoWidth = $this.data('width');
        var videoHeight = $this.data('height');
        var videoRatio = videoWidth / videoHeight;
        var windowWidth = $(window).width();
        var windowHeight = $(window).height();
        var windowRatio = windowWidth / windowHeight;

        if (videoRatio > windowRatio) {
            var videoWidth2 = windowHeight * videoRatio;
            video.css({ 'width': videoWidth2 });
            video.css({ 'height': windowHeight });
        }
        else {
            var videoHeight2 = videoHeight * videoRatio;
            video.css({ 'width': windowWidth });
            video.css({ 'height': 'auto' });
        }
    };
    if ($(window).width() > 720) {
        videoResize();
    }

    $(window).resize(function () {
        if ($(window).width() > 720) {
            videoResize();
        } else {
            video.css({ 'width': '', 'height': '' });
        }
    });
};

DeWeb.Utilities.submenuTransparent = function ($this) {
    var titleSubmenu = $(".title-submenu");
    titleSubmenu.css("display", "");
    if ($(window).width() < 1200) {
        var header = $("#page-header-left");
        var submenu = $(".submenu li a");
        if (header.width() > 70) {
            $this.css("position", "relative");
            $this.css("width", "100%");
            $this.css("margin-left", "0px");
            $this.css("min-height", "0px");
            titleSubmenu.css("display", "none")
            submenu.css("text-indent", "0px");
            $("#page-header-left .main-nav .has-menu.open p").css("border-bottom", "none");

        }
        else {
            $this.css("position", "fixed");
            $this.css("width", "260px");
            $this.css("top", "0");
            $this.css("margin-left", "65px");
            submenu.css("text-indent", "10px");
            $this.css("min-height", "950px");
            titleSubmenu.css("display", "")
        }

    }
    else {
        $this.css("margin-left", "255px");
        $this.css("width", "250px");
        $this.css("position", "fixed");
        $this.css("min-height", "980px");
        titleSubmenu.css("display", "");
    }
};

DeWeb.Utilities.avatarSelect = function ($this) {

    var avatar = $this;
    var current = $("#selected").text().trim();
    $this.find("[data-choice='" + current + "']").addClass('active');


    avatar.find("li").click(function (e) {

        e.preventDefault();
        avatar.find("li").removeClass('active');
        if (!$(this).hasClass('active')) {
            //$('.safety-avatar-selection ul li').removeClass('selected');
            $(this).addClass('active');
            $(this).parent().prev().val($(this).attr("data-choice"));
        }
        //} else {
        //    $('.safety-avatar-selection ul li').removeClass('selected');
        //    $(this).parent().addClass('selected');
        //}
    });
    //$(document).on("click", "img", function () {
    //    $("img").css("border", "");
    //    $(this).css('border', "solid 5px #209ac7");
    //});
};
DeWeb.Utilities.closeModal = function ($this) {
    $this.on("click", function (e) {
        e.preventDefault();
        DeWeb.Ui.HidePopup();
    });
};

function closeP() {
    $('body').removeClass('popup-open');
    $('.modal-inbox').fadeOut(500);
    $('.popup-box.active').fadeOut(500).removeClass('active');

    $(document).ready(function () {
        $("#popup-content-side").animate({ right: '250px' });
    });
}
DeWeb.Utilities.GetAccounts = function ($this) {
    var $replContent = $('#' + "accountsPicker");
    var Accurl = $this.data("link");
    DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
    $.ajax({
        url: Accurl,
        success: function (markup) {

            $replContent.html(markup);
            DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
            DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
        }
    });
}
DeWeb.Utilities.FilterAccounts = function ($this) {



    if ($("li[data-group=acc-filters].active").length === 0) {
        $("li[name=allAccounts]").addClass("active");
    }

    $this.click(function () {
        $("#FilterId").val($(this).data("filter"));
        $("#form_FilterFormId").submit();
    });
}
DeWeb.Utilities.LastTransaction = function ($this) {

    $.ajax({
        url: $this.data("link"),
        success: function (jsonTransaction) {
            try {
                var transaction = jsonTransaction[0];
                console.log($this.children());
                if (transaction != undefined) {
                    console.log($this.data("label"));
                    var oldText = $this.data("label");
                    $this.text(oldText + " | " + transaction['Description']);

                }

            } catch (e) {
                console.log(e);
            }

        }
    });


}


//DeWeb.Utilities.openFilter = function ($this) {
//    $this.click(function (e) {
//        e.preventDefault();
//        //$('body').addClass('-overlay-active');
//        var nodeSelector = $(this).attr('data-filter-node');
//        $(nodeSelector).css("display","block");

//    });
//};

DeWeb.Utilities.openFilter = function ($this) {
    $this.click(function (e) {
        e.preventDefault();
        $('body').addClass('-overlay-active');
        var nodeSelector = $(this).attr('data-filter-node');
        $(nodeSelector).addClass('active');

    });
};

DeWeb.Utilities.openDetails = function ($this) {
    //'USE "popupFromLink OR popupFromHtml" utility!'
    alert('USE "popupFromLink OR popupFromHtml" utility!');
    //$this.click(function (e) {
    //    e.preventDefault();
    //    var url = $this.data("href");

    //    var nodeSelector = $(this).attr('data-filter-node');
    //    var nodeId = nodeSelector.substr(1);
    //    DeWeb.AjaxForms.OnAjaxBegin(nodeId);
    //    $.ajax({
    //        url: url,
    //        success: function (markup) {
    //            $(nodeSelector).addClass('active');
    //            $(nodeSelector).html(markup);
    //            $('body').addClass('-overlay-active');
    //            DeWeb.AjaxForms.OnAjaxSuccess(nodeId);
    //            DeWeb.AjaxForms.OnAjaxComplete(nodeId);
    //        }
    //    });


    //});
}

DeWeb.Utilities.closeFilter = function ($this) {
    $this.click(function (e) {
        e.preventDefault();
        $('body').removeClass('-overlay-active');
        $(this).closest('.transaction-nav').removeClass('active');
    });
}

DeWeb.Utilities.openSideModal = function ($this) {
    //'USE "popupFromLink OR popupFromHtml" utility!'
    alert('USE "popupFromLink OR popupFromHtml" utility!');

    //$this.click(function(e){
    //    e.preventDefault();

    //    var nodeSelector = $(this).attr('data-filter-node');
    //    $(nodeSelector).addClass('active');
    //    var url = $this.data("href");

    //    var nodeId = nodeSelector.substr(1);
    //    DeWeb.AjaxForms.OnAjaxBegin(nodeId);
    //    $.ajax({
    //        url: url,
    //        success: function(markup) {
    //            $(nodeSelector).addClass('active');
    //            $(nodeSelector).html(markup);
    //            $('body').addClass('-overlay-active');
    //            DeWeb.AjaxForms.OnAjaxSuccess(nodeId);
    //            DeWeb.AjaxForms.OnAjaxComplete(nodeId);
    //        }
    //    });

    //    $(nodeSelector).parents('.side-modal').addClass('active').fadeIn(300);
    //    if($(window).width() < 600){
    //        $('html, body').animate({
    //            scrollTop: 0,
    //        }, 500);
    //    }

    //});

}

DeWeb.Utilities.calculateFilterFormInnerHeight = function ($this) {
    $('.form_filter .content-inner').innerHeight(window.innerHeight - 115);
}

$(document).ready(function () {
    DeWeb.Utilities.calculateFilterFormInnerHeight();
    $(window).on('resize', function () {
        DeWeb.Utilities.calculateFilterFormInnerHeight();
    });
});

DeWeb.Utilities.reloadCaptcha = function ($this) {
    var refreshButton = $this;
    refreshButton.click(function (e) {
        var captchaImage = $("#" + refreshButton.data("image-id"));
        var captchaImageSrc = captchaImage.attr("src");
        captchaImageSrc = captchaImageSrc.replace("reloadCaptcha=false", "reloadCaptcha=true");
        captchaImageSrc += "&v1=1";
        captchaImage.attr("src", captchaImageSrc);
    });
};

DeWeb.Utilities.googleMapContact = function ($this) {

    var location1 = new google.maps.LatLng(44.8037939, 20.4187798);

    var map;

    function initialize() {
        var map_canvas = document.getElementById('map-canvas-small');

        var styles = [
            { "featureType": "administrative.province", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "landscape", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 65 }, { "visibility": "on" }] }, { "featureType": "poi", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 51 }, { "visibility": "simplified" }] }, { "featureType": "road", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "road.arterial", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 30 }, { "visibility": "on" }] }, { "featureType": "road.local", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 40 }, { "visibility": "on" }] }, { "featureType": "transit", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "water", "elementType": "geometry", "stylers": [{ "hue": "#ffff00" }, { "lightness": -25 }, { "saturation": -97 }] }, { "featureType": "water", "elementType": "labels", "stylers": [{ "visibility": "on" }, { "lightness": -25 }, { "saturation": -100 }] }
        ];

        var infoboxes = [];

        var map_options = {
            /*** EXTDE-210 - set on Bucharest ***/
            center: new google.maps.LatLng(44.4325, 26.103889),
            zoom: 16,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: false,
            draggable: !("ontouchend" in document),
            styles: styles,
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_BOTTOM
            },
            mapTypeControlOptions: {
                position: google.maps.ControlPosition.BOTTOM_LEFT
            }
        }

        map = new google.maps.Map(map_canvas, map_options)

        var locImg1 = new google.maps.MarkerImage(
            'img/icons/pin-2.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        var locImg2 = new google.maps.MarkerImage(
            'img/icons/pin-2.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        /* location1 */
        var markerLoc1 = new google.maps.Marker({
            position: location1,
            map: map,
            icon: locImg1,
        });

        //infobox
        infoboxes['infobox0'] = new InfoBox({
            content: document.getElementById("infobox1"),
            disableAutoPan: false,
            maxWidth: 200,
            pixelOffset: new google.maps.Size(20, -100),
            zIndex: null,
            boxStyle: {
                background: "",
                opacity: 1,
            },
            closeBoxMargin: "10px 10px 0 0",
            closeBoxURL: "img/icons/close.png",
            infoBoxClearance: new google.maps.Size(1, 1)
        });

        var n = $('.infobox').length;


        google.maps.event.addListener(markerLoc1, 'click', function () {
            for (i = 0; i < n; i++) {
                infoboxes['infobox' + i].close();
            };
            infoboxes['infobox0'].open(map, this);
        });

    }

    google.maps.event.addDomListener(window, 'load', initialize);

};

DeWeb.Utilities.closeSideModal = function ($this) {

    function close() {
        $('.side-modal').fadeOut(500);
        $('.side-modal-popup.active').removeClass('active');
    }

    $this.click(function (e) {
        e.preventDefault();
        close();
    });

    $('.side-modal-inner')
        .click(function () {
            close();
        });

    $('.side-modal-popup')
        .click(function (e) {
            e.stopPropagation();
        });

    $('.side-modal').click(function (e) {
        close();
    });
    $('body').removeClass('-overlay-active');

};

DeWeb.Utilities.atmBranchWidget2 = function ($this) {

    var sourceHref = $this.data('source');
    var ctPath = $this.data('content-path');
    DeWeb.Functionalities.AtmBranchMap2.Init(sourceHref, ctPath, "widget");

    $('#text-search').on('keypress', function (event) {
        if (event.which === 13 || event.keyCode === 13) {
            var text = $('#text-search').val();
            textSearchMap(text);
            return false;
        }
    });

    var textSearchMap = function (text) {
        var filter = {
            searchText: text.trim()
        }

        DeWeb.Functionalities.AtmBranchMap2.Filter(filter);
    }


}

DeWeb.Functionalities.AtmBranchMap2 = new function () {

    var selfLocationImg = {};
    var locationImg = {};
    var atmLocationImg = {};
    var currentFilter = {
        facilityType: "all",
        searchText: ''
    };

    var map = {};
    var mainInfobox = {};
    var baseContentPath;
    var markers = [];
    var initMap = function (loadFromUrl, bPath, mapType, facilitiesJson) {
        baseContentPath = bPath;
        markers = [];
        selfLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-4.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        locationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-2.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        atmLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-1.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        var map_canvas = document.getElementById('widget-map-canvas2');

        var styles = [
            {
                "stylers": [
                    { "saturation": -100 }, { "lightness": -14 }, { "gamma": 0.73 }
                ]
            }
        ];

        if (mapType === "preloginatmbranch") {
            styles = [
                { "featureType": "administrative.province", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "landscape", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 65 }, { "visibility": "on" }] }, { "featureType": "poi", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 51 }, { "visibility": "simplified" }] }, { "featureType": "road", "elementType": "all", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "road.arterial", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 30 }, { "visibility": "on" }] }, { "featureType": "road.local", "elementType": "all", "stylers": [{ "saturation": -100 }, { "lightness": 40 }, { "visibility": "on" }] }, { "featureType": "transit", "elementType": "all", "stylers": [{ "saturation": -100 }, { "visibility": "simplified" }] }, { "featureType": "water", "elementType": "geometry", "stylers": [{ "hue": "#ffff00" }, { "lightness": -25 }, { "saturation": -97 }] }, { "featureType": "water", "elementType": "labels", "stylers": [{ "visibility": "on" }, { "lightness": -25 }, { "saturation": -100 }] }
            ];
        }
        //infobox

        infoBoxClearance: new google.maps.Size(1, 1)
        mainInfobox = new InfoBox({
            content: '',
            disableAutoPan: false,
            maxWidth: 200,
            pixelOffset: new google.maps.Size(20, -100),
            zIndex: null,
            boxStyle: {
                background: "",
                opacity: 1
            },
            closeBoxMargin: "10px 10px 0 0",
            closeBoxURL: baseContentPath + "img/icons/close.png",
            infoBoxClearance: new google.maps.Size(1, 1)
        });

        //var myOptions = ;
        var geocodeLatLng = function (geocoder, map, latlng, callback) {
            geocoder.geocode({ 'location': latlng }, function (results, status) {
                if (status === google.maps.GeocoderStatus.OK) {
                    if (results[1]) {
                        callback(results);
                    } else {
                        console.log('No results found');
                    }
                } else {
                    console.log('Geocoder failed due to: ' + status);
                }
            });
        };

        var map_options = {
            /*** EXTDE-210 - set on Bucharest ***/
            center: new google.maps.LatLng(44.4325, 26.103889),
            zoom: 12,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: false,
            draggable: !("ontouchend" in document),
            styles: styles,
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_BOTTOM
            },
            mapTypeControlOptions: {
                position: google.maps.ControlPosition.BOTTOM_LEFT
            }
        }
            ;
        map = new google.maps.Map(map_canvas, map_options);
        map["fullscreen"] = false;
        map["infoBoxInView"] = false;
        map["infoBoxOpen"] = false;
        google.maps.event.addListener(map, 'bounds_changed', onBoundsChanged);
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var pos = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                //todo insert icon self
                map.setCenter(pos);

                var geocoder = new google.maps.Geocoder;
                geocodeLatLng(geocoder, map, pos, function (results) {
                    addMyMarker(results, selfLocationImg, pos);
                });
            }, function () {
                //handleLocationError(true, infoWindow, map.getCenter());
            });
        } else {
            // Browser doesn't support Geolocation
            //handleLocationError(false, infoWindow, map.getCenter());
        }

        getPosition();

        function lat(callback) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var lat = position.coords.latitude;
                var lon = position.coords.longitude;
                currentPosition = {
                    lat: lat, lng: lon
                };
                callback.call(null, lat, lon);
            }, function (error) {
                console.log("Something went wrong: ", error);
                var retposs = {
                    lat: 'Current +',
                    lng: 'Location'
                };
                facilities(retposs);
            });
        }

        function getPosition() {
            lat(function (latitude, longitude) {
                var retposs = {
                    lat: latitude,
                    lng: longitude
                };
                facilities(retposs);
            });
        }

        function facilities(retposs)
        {
            if (!facilitiesJson) {
                $.ajax({
                    type: "GET",
                    url: loadFromUrl,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var items = response;
                        addBankMarkers(items, locationImg, retposs);
                    }
                });
            } else {
                var items = facilitiesJson;

                addBankMarkers(items, locationImg, retposs);
            }
        }

    };

    function onBoundsChanged() {
        if (map.fullscreen &&
            (!(map.getDiv().firstChild.clientHeight == window.innerHeight) || !(map.getDiv().firstChild.clientWidth == window.innerWidth))) {
            map.fullscreen = false;
            if (map.infoBoxInView && map.infoBoxOpen) {
                map.setCenter(mainInfobox.position_);
                window.setTimeout(function () {
                    mainInfobox.panBox_();
                    updateinfoBoxInView(map);
                }, 500)
            }
        }

        else if (!map.fullscreen && map.getDiv().firstChild.clientHeight == window.innerHeight && map.getDiv().firstChild.clientWidth == window.innerWidth) {
            map.fullscreen = true;
            updateinfoBoxInView(map);
        }

        else {
            updateinfoBoxInView(map);
        }

    }

    function updateinfoBoxInView(map) {
        if (map.infoBoxOpen) {
            map.infoBoxInView = map.getBounds().contains(mainInfobox.position_);
        }
    }

    var searchOperation = function (map, markersGmap) {

        $("input[type=search]")
            .on("keyup",
                function () {
                    var searchText = $(this).val().toLowerCase();

                    if (searchText === "") {

                        for (var index in markersGmap) {
                            markersGmap[index].marker.setVisible(true);
                        }
                        return;
                    }

                    for (var index in markersGmap) {
                        var markerObj = markersGmap[index];
                        var name = markersGmap[index].name.toLowerCase();

                        if (name.indexOf(searchText) < 0) {

                            markerObj.marker.setVisible(false);
                            mainInfobox.close();
                        } else {

                            markerObj.marker.setVisible(true);
                        }
                    }
                });



    }
    var addBankMarkers = function (items, locationImg, retposs) {
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item == null || item.coordinates == null || item.coordinates.long == null || item.coordinates.lat == null) {

                continue;
            }
            var position = new google.maps.LatLng(item.coordinates.lat, item.coordinates.long);
            var infoboxContent = getInfoBoxContent(item, retposs);
            var icon = locationImg;
            if (item.kind === "ATM") {
                icon = atmLocationImg;
            }
            var markerDescription = {
                type: item.kind,
                address: formatAddressString(item),
                name: item.name
            };

            addMarker(map, icon, infoboxContent, position, markerDescription);


        }

        searchOperation(map, markers);
    };


    var addMyMarker = function (results, selfLocationImg, position) {
        var result = '';
        if (results[0] != null) {
            result = results[0];
        }
        var t = document.getElementById("infobox-template2");
        var div = document.createElement("div");
        div.innerHTML = t.innerHTML;
        $(div).find(".link-to-map").remove();
        var infoboxTemplate = div.innerHTML;
        var content = infoboxTemplate.replace("{infobox-id}", "self")
            .replace("{location-title}", "Your location.")
            .replace("{location-info}", result.formatted_address);

        addMarker(map, selfLocationImg, content, position, { type: 'self' });
    };

    var addMarker = function (addtoMap, icon, infoboxContent, position, markerDescription) {

        var markerObj = {
            type: markerDescription.kind,
            address: markerDescription.address,
            name: markerDescription.name,
            marker: new google.maps.Marker({
                position: position,
                map: addtoMap,
                icon: icon
            })
        };

        google.maps.event.addListener(markerObj.marker, 'click', function () {
            mainInfobox.close();
            mainInfobox.setContent(infoboxContent);
            mainInfobox.open(addtoMap, this);
        });

        markers.push(markerObj);
    };

    var formatAddressString = function (facility) {
        var address = '';
        var facAddress = facility.address;
        if (facAddress != undefined) {
            if (facAddress.formatted != undefined) {
                address = facility.address.formatted;
            } else {
                address = (facAddress.street + " ") + (facAddress.locality);
            }

            if (facAddress.country != null) {
                address += "<br>" + facAddress.country;
            }
        }

        return address;
    };


    var getInfoBoxContent = function (data, retposs) {
        var infoboxTemplate = $('#infobox-template2').html();
        var content = infoboxTemplate.replace("{infobox-id}", data.id)
            .replace("{location-title}", data.name + " | " + data.kind)
            .replace("{location-info}", formatAddressString(data))
            .replace("{location-long}", data.coordinates.long)
            .replace("{location-lat}", data.coordinates.lat)
            .replace("{mylocation-lat}", retposs.lat)
            .replace("{mylocation-long}", retposs.lng);

        return content;
    };
    var handleLocationError = function (browserHasGeolocation, infoWindow, pos) {
        infoWindow.setPosition(pos);
        infoWindow.setContent(browserHasGeolocation ?
            'Error: The Geolocation service failed.' :
            'Error: Your browser doesn\'t support geolocation.');
    };

    var filterMap = function (filter) {


        if (filter && filter.facilityType) {
            currentFilter.facilityType = filter.facilityType;
        }

        if (filter && filter.searchText != null) {
            currentFilter.searchText = filter.searchText;
        }

        var performSearch = function (data, searchText) {
            if (!searchText || searchText === '' || data.Kind === 'self') {
                return true;
            }

            if (data.address) {
                if (data.address.toLowerCase().indexOf(searchText.toLowerCase()) > -1) {
                    return true;
                }
            }

            if (data.name) {
                if (data.name.toLowerCase().indexOf(searchText.toLowerCase()) > -1) {
                    return true;
                }
            }


            return false;
        };

        if (currentFilter) {
            for (var i = 0; i < markers.length; i++) {

                var markerObj = markers[i];

                if (currentFilter.facilityType !== "all" && markerObj.Kind !== currentFilter.facilityType && markerObj.Kind !== "self") {
                    markerObj.marker.setVisible(false);
                } else {
                    if (performSearch(markerObj, currentFilter.searchText)) {
                        markerObj.marker.setVisible(true);
                    } else {
                        markerObj.marker.setVisible(false);
                    }
                }
            }
        }
    };
    var getCurrentFilter = function () {
        return currentFilter;
    };
    return {
        Init: initMap,
        Filter: filterMap,
        CurrentFilter: getCurrentFilter
    };
};

DeWeb.Utilities.mapList = function ($this) {

    $this.click(function () {
        if (!$(this).parent().hasClass('active')) {
            $(this).parent().siblings('.active').removeClass('active').find('.hidden-content').slideUp(300);
            $(this).parent().addClass('active').find('.hidden-content').slideDown(300);
        } else {
            $(this).parent().removeClass('active').find('.hidden-content').slideUp(300);
        }
    });

};


DeWeb.Utilities.barView = function ($this) {

    $(function () {
        var colorsIncome = ['#eb0255', '#239bc8', '#2d4050'];
        var colorsOutcome = ['#ff6600', '#00b33c', '#6600cc'];
        var today = new Date();
        var dayStart = today.setDate(today.getDate() - $this.data("bins"));
        var currencies = $this.data("currency");
        var minvalue = Math.min.apply(null, [Math.min.apply(null, $this.data("income-values")), Math.min.apply(null, $this.data("outcome-values"))]);
        var maxvalue = Math.max.apply(null, [Math.max.apply(null, $this.data("income-values")), Math.max.apply(null, $this.data("outcome-values"))]);
        var count = $this.data("income-values").length + $this.data("outcome-values").length;
        var series = $this.data("series-names").split(',');
        dataSeries = [];
        for (var i = 0; i < $this.data('income-values').length; i++) {
            dataSeries.push({
                pointStart: Date.UTC(parseInt($this.data("year")), parseInt($this.data("month")), 1, 0, 0, 0),
                pointInterval: 24 * 3600 * 1000,
                name: series[0] + "/" + currencies[i],
                data: $this.data("income-values")[i],
                color: colorsIncome[i],

            });
        }
        for (var j = 0; j < $this.data('outcome-values').length; j++) {
            dataSeries.push({
                pointStart: Date.UTC(parseInt($this.data("year")), parseInt($this.data("month")), 1, 0, 0, 0),
                pointInterval: 24 * 3600 * 1000,
                name: series[1] + "/" + currencies[j],
                data: $this.data("outcome-values")[j],
                color: colorsOutcome[j],
            });
        }
        Highcharts.chart('bar-view', {
            chart: {
                type: 'column'
            },
            colors: ['#eb0255', '#239bc8', '#2d4050', '#ff6600', '#00b33c', '#6600cc'],
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            legend: {
                enabled: false
            },
            xAxis: {
                type: 'datetime',
                tickInterval: 24 * 3600 * 1000,
                dateTimeLabelFormats: { // don't display the dummy year
                    month: '%b',
                    day: '%e',
                },
            },
            yAxis: {
                title: {
                    text: ''
                },
                labels: {
                    formatter: function () {
                        return Highcharts.numberFormat(this.value, 0, ',', '.');
                    },
                }
            },
            tooltip: {
                pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b><br/>',
                style: {
                    fontFamily: 'geomanist',
                    textAlign: 'center',
                    fontSize: '16px',
                    color: '#239bc8',
                    fontWeight: '500',
                    lineHeight: '20px',
                },
                valueDecimals: 2,
                split: true
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
                    }
                },
                series: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function () {
                                var dateClicked = new Date(this.x).toLocaleDateString(undefined, {
                                    day: '2-digit',
                                    month: '2-digit',
                                    year: 'numeric'
                                });
                                var linkButton = $("#list-by-date");
                                var loadFromUrl = linkButton.data("url-action") + "&DateFrom=" + dateClicked + "&DateTo=" + dateClicked;
                                linkButton.data("href", loadFromUrl);
                                linkButton.trigger('click');
                            }
                        }
                    }
                }
            },
            series: dataSeries
        });
    });

};



DeWeb.Utilities.balanceEvolution = function ($this) {

    $(function () {

        var colors = ['#eb0255', '#239bc8', '#2d4050']; //test colors
        seriesBalance = [];
        for (i in $this.data('balance-values')) {
            seriesBalance.push({
                name: $this.data("series-names") + "/" + $this.data("currency")[i],
                data: $this.data("balance-values")[i],
                color: colors[i],

            });
        }



        Highcharts.chart('balance-evolution-chart', {
            chart: {
                type: 'areaspline'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            legend: {
                enabled: false
            },
            xAxis: {
                type: 'datetime'
            },
            yAxis: {
                title: {
                    text: ''
                },
                labels: {
                    formatter: function () {
                        return Highcharts.numberFormat(this.value, 0, ',', '.');
                    },
                }
            },
            tooltip: {
                pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b><br/>',
                style: {
                    fontFamily: 'geomanist',
                    textAlign: 'center',
                    fontSize: '16px',
                    color: '#239bc8',
                    fontWeight: '500',
                    lineHeight: '20px',
                },
                valueDecimals: 2,
                split: true
            },
            plotOptions: {
                areaspline: {
                    fillOpacity: 0,
                    pointInterval: 86400000, //one day in miliseconds
                    pointStart: Date.UTC(parseInt($this.data("year")), parseInt($this.data("month")), 1, 0, 0, 0),
                    marker: {
                        enabled: false,
                    }
                },
                series: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function () {
                                var dateClicked = new Date(this.x).toLocaleDateString(undefined, {
                                    day: '2-digit',
                                    month: '2-digit',
                                    year: 'numeric'
                                });
                                var linkButton = $("#list-by-date");
                                var loadFromUrl = linkButton.data("url-action") + "&DateFrom=" + dateClicked + "&DateTo=" + dateClicked;
                                linkButton.data("href", loadFromUrl);
                                linkButton.trigger('click');
                            }
                        }
                    }
                }
            },
            series: seriesBalance
        });
    });

};






















DeWeb.Utilities.tabControl = function ($this) {
    var navigateOnId = $this.data('navigate-on-id');
    var $navigateOn = $('#' + navigateOnId);
    if ($navigateOn.length) {
        $this.on('click', '.tab-navigator', function (e) {
            e.preventDefault();
            e.stopPropagation();

            var $tab = $(this);
            var href = $tab.attr('href') || $tab.data('href');
            DeWeb.AjaxForms.OnAjaxBegin(navigateOnId);
            if (href) {

                $.get(href, function (data) {
                    $navigateOn.html(data);
                    $this.find('.tab-navigator').removeClass('active');
                    $this.find('li').removeClass('active');
                    $tab.addClass('active');
                    $tab.parent().addClass('active');
                    DeWeb.AjaxForms.OnAjaxComplete(navigateOnId);
                    DeWeb.Helpers.PushSingleQueryInHistory("tab", $tab.data('tab-name'));

                });
            }
        });

        var gotoTab = DeWeb.Helpers.GetQueryStringValue("tab");
        var $shouldPreload = null;

        if (gotoTab) {
            $shouldPreload = $this.find('*[data-tab-name="' + gotoTab + '"]:first');
        }

        if (!$shouldPreload || !$shouldPreload.length) {
            $shouldPreload = $this.find('*[data-preloaded-tab]:first');
        }

        if ($shouldPreload && $shouldPreload.length) {
            var href = $shouldPreload.attr('href') || $shouldPreload.data('href');
            if (href) {
                DeWeb.AjaxForms.OnAjaxBegin(navigateOnId);

                $.get(href, function (data) {
                    $navigateOn.html(data);
                    $this.find('.tab-navigator').removeClass('active');
                    $this.find('li').removeClass('active');
                    $shouldPreload.addClass('active');
                    $shouldPreload.parent().addClass('active');
                    DeWeb.AjaxForms.OnAjaxComplete(navigateOnId);

                    DeWeb.Helpers.PushSingleQueryInHistory("tab", $shouldPreload.data('tab-name'));
                });
            }
        }
    }
}

DeWeb.Utilities.selectNavigator = function ($this) {

    var navigateOnId = $this.data('navigate-on-id');
    var $navigateOn = $('#' + navigateOnId);
    if ($navigateOn.length) {
        $('#selectedOption').on('change', function (e) {
            e.preventDefault();
            e.stopPropagation();
            var $tab = $(this).val();
            DeWeb.AjaxForms.OnAjaxBegin(navigateOnId);

            if ($tab) {
                $.get($tab, function (data) {
                    $navigateOn.html(data);
                    $this.find('.tab-navigator').addClass('active');
                    //$this.addClass('active');
                    //$tab.parent().addClass('active');
                    DeWeb.AjaxForms.OnAjaxComplete(navigateOnId);
                    //DeWeb.Helpers.PushSingleQueryInHistory("tab", $tab.data('tab-name'));
                });
            }
        });

        var gotoTab = DeWeb.Helpers.GetQueryStringValue("tab");
        var $shouldPreload = null;

        if (gotoTab) {
            $shouldPreload = $this.find('*[data-tab-name="' + gotoTab + '"]:first');
        }

        if (!$shouldPreload || !$shouldPreload.length) {
            $shouldPreload = $this.find('*[data-preloaded-tab]:first');
        }

        if ($shouldPreload && $shouldPreload.length) {
            var href = $shouldPreload.attr('href') || $shouldPreload.data('href');
            if (href) {
                DeWeb.AjaxForms.OnAjaxBegin(navigateOnId);

                $.get(href, function (data) {
                    $navigateOn.html(data);
                    $this.find('.tab-navigator').removeClass('active');
                    $shouldPreload.addClass('active');
                    $shouldPreload.parent().addClass('active');
                    DeWeb.AjaxForms.OnAjaxComplete(navigateOnId);
                    DeWeb.Helpers.PushSingleQueryInHistory("tab", $shouldPreload.data('tab-name'));
                });
            }
        }
    }
}
DeWeb.Utilities.accordianShowHidden = function ($this) {

    $this.click(function () {
        if ($(this).next('.hidden').hasClass('active')) {
            $('.accordian-wrapper .hidden').removeClass('active').slideUp();
        } else {
            $('.accordian-wrapper .hidden').removeClass('active').slideUp();
            $(this).next('.hidden').addClass('active').slideDown();
        }
    });

    $this.click(function () {
        if ($(this).hasClass('active')) {
            $('.accordian-title').removeClass('active');
        } else {
            $('.accordian-title').removeClass('active');
            $(this).addClass('active');
        }
    });

}
DeWeb.Utilities.triggerWideTabs = function ($this) {

    $this.click(function (e) {
        $(this).next('.wide-tabs').fadeToggle(300);
    });

}

DeWeb.Utilities.customSelect3 = function ($this) {
    $this.dropkick();

};

DeWeb.Utilities.accordianShowHidden = function ($this) {

    $this.click(function () {
        if ($(this).next('.hidden').hasClass('active')) {
            $('.accordian-wrapper .hidden').removeClass('active').slideUp();
        } else {
            $('.accordian-wrapper .hidden').removeClass('active').slideUp();
            $(this).next('.hidden').addClass('active').slideDown();
        }
    });

    $this.click(function () {
        if ($(this).hasClass('active')) {
            $('.accordian-title').removeClass('active');
        } else {
            $('.accordian-title').removeClass('active');
            $(this).addClass('active');
        }
    });

}
DeWeb.Utilities.checkBoxFIeld = function ($this) {
    $this.screwDefaultButtons();
};

DeWeb.Utilities.checkboxTriggerHidden = function ($this) {
    if ($this.hasClass("checked")) {
        hidden = $this.parent().parent().parent().parent().children()[2];
        $(hidden).css("display", "block");
    }
    $this.change(function () {

        $(this).parents('.notification-trigger').next('.hidden').slideToggle();

    });

};
DeWeb.Utilities.customSelect3 = function ($this) {

    $this.dropkick();

};

DeWeb.Utilities.valueInput = function ($this) {

    var input1 = $this;
    var val1;

    input1.keydown(function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
            // Allow: Ctrl+A, Command+A
            (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
            // Allow: home, end, left, right, down, up
            (e.keyCode >= 35 && e.keyCode <= 40)) {
            // let it happen, don't do anything
            return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
    });


    input1.focus(function (event) {
        input1.val(input1.val().replace(/\./g, ''));
        input1.val(input1.val().replace(/\,00/g, ''));
    });

    function format(comma, period) {
        comma = comma || ',';
        period = period || '.';
        var split = this.toString().split('.');
        var numeric = split[0];
        var decimal = split.length > 1 ? period + split[1] : '';
        var reg = /(\d+)(\d{3})/;
        while (reg.test(numeric)) {
            numeric = numeric.replace(reg, '$1' + comma + '$2');
        }
        return numeric + decimal;
    }

    input1.blur(function () {
        if ($this.val() != '') {
            $(this).val(format.call($(this).val().split(' ').join(''), '.', '.') + ',00');

        }
    });



};

DeWeb.Utilities.calculator = function ($this) {

    $(document).ready(function () {
        $($this).click(function () {
            var $firstCurrency = $("div#first").find("li.dk-option.currencyName.dk-option-selected").text();
            var $secondCurrency = $("div#second").find("li.dk-option.currencyName.dk-option-selected").text();
            var $typedAmount = $("input.input-1.ui-autocomplete-input.typedAmount").val();
            var $FirstCurrencyValue = $("[data-currency=" + $firstCurrency + "]").text();
            var $SecondCurrencyValue = $("[data-currency=" + $secondCurrency + "]").text();
            var $FirstOneAmount = $("[data-amount=" + $firstCurrency + "]").data("unit");
            var $floatedFirstCurrencyValue = parseFloat($FirstCurrencyValue);
            var $floatedFirstOneAmount = parseFloat($FirstOneAmount);
            var $FirstOnlyOne = $floatedFirstCurrencyValue / $floatedFirstOneAmount;
            var $parsedFirstOnlyOne = parseFloat($FirstOnlyOne);
            var $result = $parsedFirstOnlyOne * $typedAmount;
            var $secondOneAmount = $("[data-amount=" + $secondCurrency + "]").data("unit");
            var $floatedSecondOneAmount = parseFloat($secondOneAmount);
            var $floatedSecondCurrencyValue = parseFloat($SecondCurrencyValue);
            var $secondOnlyOne = $floatedSecondCurrencyValue / $floatedSecondOneAmount;
            var $finalresult = $result / $secondOnlyOne;
            $("p.value").empty();
            $("p.value").append($finalresult);
        });
    });

};
DeWeb.Utilities.switchAccounts = function ($this) {

    $this.on("change", function () {
        var Rurl = $this.data("href") + "?partyId=" + $(this).val();
        DeWeb.Ui.BlockUi();
        $.ajax({
            url: Rurl,
            type: "GET",
            success: function (json) {
                location.reload();
            },
            error: function() {
                alert('custoemr switch error');
            }
        });

    });
};
DeWeb.Utilities.readMessage = function ($this) {
    $($this).click(function () {
        var notReaded = $(document).find('a[data-message-status=not-readed]').find('span');
        var readed = $(document).find('a[data-message-status=readed]').find('span');
        var unreadedIconNumber = $("body").find(".mCSB_container").find("span[data-additional-title='New messages']");
        var readIcon = $this.find('div.msg-unread');

        if (readIcon.length == 1) {
            readIcon.removeClass('msg-unread');
            readIcon.addClass('msg-read');

            $this.find("span.message-title").css('font-weight', 'normal');
            notReaded.text(notReaded.text() - 1);
            readed.text(readed.text() - 0 + 1);
            unreadedIconNumber.text(unreadedIconNumber.text() - 1);
        }

    });
};

DeWeb.Utilities.navLeftToggle = function ($this) {

    $('.menu-btn').on('click', function (e) {
        $('#page-header-left').toggleClass('mobile');
        if ($('#page-header-left').hasClass('mobile')) {
            $('#main-side').css("min-height", $('#page-header-left').height());
        }
        else {
            $('#main-side').css('min-height', 'auto');
        }
        e.preventDefault();
        menuFocus();
    });
};

DeWeb.Utilities.yourLocation = function ($this) {
    var x = document.getElementById("distance-lat");
    var y = document.getElementById("distance-long");

    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition);
    } else {
        x.innerHTML = "Geolocation is not supported by this browser.";
    }

    function showPosition(position) {
        x.innerHTML = position.coords.latitude;
        y.innerHTML = position.coords.longitude;
    }
};

DeWeb.Utilities.locationDistance = function ($this) {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition);
    } else {
    }

    function showPosition(position) {

        lat1 = position.coords.latitude;
        long1 = position.coords.longitude;
        lat2 = parseFloat($this.data("lat"));
        long2 = parseFloat($this.data("lng"));
        var R = 6371;
        var dLat = deg2rad(lat2 - lat1);
        var dLon = deg2rad(long2 - long1);
        var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) * Math.sin(dLon / 2) * Math.sin(dLon / 2);
        var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        var d = R * c;
        d = d.toFixed(2)

        $this.find(".distance").text(d + " km");
    }


    function deg2rad(deg) {
        return deg * (Math.PI / 180)
    }
};

DeWeb.Utilities.changeAccountDetails = function ($this) {
    $this.click(function (e) {
        var accountNumber = $(this).find('p').first().text();
        $('body').find("input#Accounts_ID").val("");
        var selectedAccount = $('body').find("input#Accounts_ID").val(accountNumber);
    });
};
DeWeb.Utilities.changeCardDetails = function ($this) {
    $this.click(function (e) {
        var accountNumber = $this.data("cardnumber");
        $('body').find("input#Cards_ID").val("");
        var selectedAccount = $('body').find("input#Cards_ID").val(accountNumber);
    });
};

DeWeb.Utilities.textLimit = function ($this) {
    var $limit = $this.attr('data-limit');
    var $text = $this.html();
    var $shortText = $text.substr(0, $limit);
    if ($text.length > $limit) {
        $this.html($shortText + "...");
    }
    else {
        $this.html($shortText);
    }
};

DeWeb.Utilities.closeUrgentMessageSection = function ($this) {
    $this.click(function () {
        $('.close-btn').click();
    })
};

DeWeb.Utilities.cardSelectAccount = function ($this) {
    var $parent = $this.parent();
    var $cardDiv = $parent.find('div#Cards_ID');
    var $AccountDiv = $parent.find('div#Accounts_ID');
    var $cardDivLis = $cardDiv.find('li');
    $cardDivLis.addClass("card");

    $('li.card').click(function ($this) {
        var $card = $this.find('input.dd-option-value').val();
        var $cardValue = $('.side-modal').find("input[name='Cards_ID']").val();
    });
};

DeWeb.Utilities.reloadCurrentPage = function ($this) {
    $this.click(function () {
        location.reload();
    })
};

DeWeb.Utilities.changeAccountTypeInListView = function ($this) {
    $this.click(function () {
        var accountKind = $this.data('accountkind');
        var accountList = $('ul.account-list');
        if (accountKind != "") {
            accountList.find('li.list-item').css('display', 'none');
            var selectedAccountKindsArray = accountKind.split(',');
            for (i = 0; i < selectedAccountKindsArray.length; i++) {
                var clickedAccountKind = selectedAccountKindsArray[i];
                accountList.find('[data-acckind="' + clickedAccountKind + '"]').css('display', 'block');
            }
        }
        else {
            accountList.find('li.list-item').css('display', 'block');
        }
        $('div.more-list').css('display', 'none');
        var selectedAccountNumber = $('#Accounts_ID').val();
        accountList.find('li.list-item').removeClass('selected');
        accountList.find('[data-accountnumber="' + selectedAccountNumber + '"]').addClass('selected');
    })
};

DeWeb.Utilities.changeCardTypeInListView = function ($this) {
    $this.click(function () {
         
        var accountKind = $this.data('accountkind');
        var accountList = $('ul.account-list');
        if (accountKind != "") {
            accountList.find('li.list-item').css('display', 'none');
            var selectedAccountKindsArray = accountKind.split(',');
            for (i = 0; i < selectedAccountKindsArray.length; i++) {
                var clickedAccountKind = selectedAccountKindsArray[i];
                accountList.find('[data-acckind="' + clickedAccountKind + '"]').css('display', 'block');
            }
        }
        else {
            accountList.find('li.list-item').css('display', 'block');
        }
        $('div.more-list').css('display', 'none');
        var selectedAccountNumber = $('#Cards_ID').val();
        accountList.find('li.list-item').removeClass('selected');
        accountList.find('[data-accountnumber="' + selectedAccountNumber + '"]').addClass('selected');
    });
};

DeWeb.Utilities.changeCardTypeInListViewCards = function ($this) {
    $this.click(function () {
        
        var accountKind = $this.data('accountkind');
        var accountList = $('ul.account-list');
        if (accountKind != "") {
            accountList.find('li.list-item').css('display', 'none');
            var selectedAccountKindsArray = accountKind.split(',');
            for (i = 0; i < selectedAccountKindsArray.length; i++) {
                var clickedAccountKind = selectedAccountKindsArray[i];
                accountList.find('[data-acckind="' + clickedAccountKind + '"]').css('display', 'block');
            }
        }
        else {
            accountList.find('li.list-item').css('display', 'block');
        }
        $('div.more-list').css('display', 'none');
        var selectedAccountNumber = $('#Cards_ID').val();
        accountList.find('li.list-item').removeClass('selected');
        var kind = $('#account-slider').find('.slide.slick-slide.slick-current.slick-center').data('acckind');
        var selectedSliderAccount = $('#account-slider').find('.slide.slick-slide.slick-current.slick-center').data('accno');
        if (kind == "credit-card-account" || kind == "credit-facility-account") {
            accountList.find('[data-accno="' + selectedSliderAccount + '"]').addClass('selected');
        }
        else {
            accountList.find('[data-accountnumber="' + selectedAccountNumber + '"]').addClass('selected');
        }
        var sliderCarousel = $('#slider-carousel-side');
        var sliderList = $('#slider-list-side');
        for (var i = 0; i < sliderCarousel.children().length; i++) {
            if (sliderCarousel.children()[i].id == $this.attr('id')) {
                sliderCarousel.children()[i].classList.add('active');
            }
            else {
                sliderCarousel.children()[i].classList.remove('active')
            }
        }
        for (var i = 0; i < sliderList.children().length; i++) {
            if (sliderList.children()[i].id == $this.attr('id')) {
                sliderList.children()[i].classList.add('active');
            }
            else {
                sliderList.children()[i].classList.remove('active')
            }
        }
    });
};

DeWeb.Utilities.changeAccountTypeInListViewDashboard = function ($this) {
    $this.click(function () {
        var accountKind = $this.data('accountkind');
        var accountList = $('ul.account-list');
        var filteredAccs = new Array();
        if (accountKind != "") {
            accountList.find('li.list-item').css('display', 'none');
            var selectedAccountKindsArray = accountKind.split(',');
            for (i = 0; i < selectedAccountKindsArray.length; i++) {
                var clickedAccountKind = selectedAccountKindsArray[i];
                var currentAccounts = accountList.find('[data-acckind="' + clickedAccountKind + '"]');
                currentAccounts.css('display', 'block');
                for (var j = 0; j < currentAccounts.length; j++) {
                    filteredAccs.push(currentAccounts[j]);
                }
            }
        }
        else {
            accountList.find('li.list-item').css('display', 'block');
        }
        $('#account-list .list-item').find('.drag.open').removeClass('open');
        $('div.more-list').css('display', 'none');
        var selectedAccountNumber = $('input#selected-account').val();
        accountList.find('li.list-item').removeClass('selected');
        if (accountKind == "term-loan-account,credit-line-account" || accountKind == "credit-card-account,credit-facility-account") {
            var selectedAccountKindsArray = accountKind.split(',');
            filteredAccs[0].classList.add('selected');
        }
        else {
            accountList.find('[data-accountnumber="' + selectedAccountNumber + '"]').addClass('selected');
        }
    })
};

DeWeb.Utilities.checkCallbackStatus = function ($this) {
    var callbackStatus = false;
    var url = $this.data('url');
    var workItemId = $this.data('work-item-id');
    function pollMessages() {
        $.ajax({
            url: url,
            data: { workItemId: workItemId },
            success: function (data) {
                try {
                    callbackStatus = data.Success;
                    if (callbackStatus) {
                        $this.click();
                        window.callbackProcessed = true;
                    }
                } catch (e) {
                    console.log(e);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {

            },
            dataType: "json",
            complete: function () {
                if (!callbackStatus) {
                    if ($.contains(window.document, $this[0])) {
                        setTimeout(pollMessages, 1000);
                    }
                }
            }
        });
    };
    
    if (window.callbackProcessed !== true) {
        pollMessages();
    }

    window.callbackProcessed = false;
};

DeWeb.Utilities.checkPushCallbackStatus = function ($this) {
    var callbackStatus = false;
    var url = $this.data('url');
    var workItemId = $this.data('work-item-id');
    function pollMessages() {
        $.ajax({
            url: url,
            data: { workItemId: workItemId },
            success: function (data) {
                try {
                    callbackStatus = data.Success;
                    if (callbackStatus) {
                        $this.click();
                    }
                } catch (e) {
                    console.log(e);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {

            },
            dataType: "json",
            complete: function () {
                if (!callbackStatus) {
                    if ($.contains(window.document, $this[0])) {
                        setTimeout(pollMessages, 1000);
                    }


                }
            }
        });
    };
    pollMessages();
};


DeWeb.Utilities.resetInactivityTimer = function ($this) {
    $this.click(function () {
        var updateUrl = $this.data('update-url');
        $.ajax({
            url: updateUrl,
            success: function (result) {
                try {
                    if (result.IsSuccesfull === true || result.IsSuccesfull == undefined) {
                        if (result !== undefined) {
                            $('#current-notification').remove();
                        }
                    }
                } catch (e) {
                    console.log(e);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
            },
            dataType: "json"
        });
    });
};

/*
 Highcharts JS v5.0.10 (2017-03-31)

 (c) 2009-2016 Torstein Honsi

 License: www.highcharts.com/license
*/
(function (L, a) { "object" === typeof module && module.exports ? module.exports = L.document ? a(L) : a : L.Highcharts = a(L) })("undefined" !== typeof window ? window : this, function (L) {
    L = function () {
        var a = window, B = a.document, A = a.navigator && a.navigator.userAgent || "", H = B && B.createElementNS && !!B.createElementNS("http://www.w3.org/2000/svg", "svg").createSVGRect, G = /(edge|msie|trident)/i.test(A) && !window.opera, r = !H, f = /Firefox/.test(A), l = f && 4 > parseInt(A.split("Firefox/")[1], 10); return a.Highcharts ? a.Highcharts.error(16, !0) : {
            product: "Highcharts",
            version: "5.0.10", deg2rad: 2 * Math.PI / 360, doc: B, hasBidiBug: l, hasTouch: B && void 0 !== B.documentElement.ontouchstart, isMS: G, isWebKit: /AppleWebKit/.test(A), isFirefox: f, isTouchDevice: /(Mobile|Android|Windows Phone)/.test(A), SVG_NS: "http://www.w3.org/2000/svg", chartCount: 0, seriesTypes: {}, symbolSizes: {}, svg: H, vml: r, win: a, charts: [], marginNames: ["plotTop", "marginRight", "marginBottom", "plotLeft"], noop: function () { }
        }
    }(); (function (a) {
        var B = [], A = a.charts, H = a.doc, G = a.win; a.error = function (r, f) {
            r = a.isNumber(r) ? "Highcharts error #" +
                r + ": www.highcharts.com/errors/" + r : r; if (f) throw Error(r); G.console && console.log(r)
        }; a.Fx = function (a, f, l) { this.options = f; this.elem = a; this.prop = l }; a.Fx.prototype = {
            dSetter: function () { var a = this.paths[0], f = this.paths[1], l = [], q = this.now, k = a.length, u; if (1 === q) l = this.toD; else if (k === f.length && 1 > q) for (; k--;) u = parseFloat(a[k]), l[k] = isNaN(u) ? a[k] : q * parseFloat(f[k] - u) + u; else l = f; this.elem.attr("d", l, null, !0) }, update: function () {
                var a = this.elem, f = this.prop, l = this.now, q = this.options.step; if (this[f + "Setter"]) this[f +
                    "Setter"](); else a.attr ? a.element && a.attr(f, l, null, !0) : a.style[f] = l + this.unit; q && q.call(a, l, this)
            }, run: function (a, f, l) { var r = this, k = function (a) { return k.stopped ? !1 : r.step(a) }, u; this.startTime = +new Date; this.start = a; this.end = f; this.unit = l; this.now = this.start; this.pos = 0; k.elem = this.elem; k.prop = this.prop; k() && 1 === B.push(k) && (k.timerId = setInterval(function () { for (u = 0; u < B.length; u++) B[u]() || B.splice(u--, 1); B.length || clearInterval(k.timerId) }, 13)) }, step: function (a) {
                var f = +new Date, r, q = this.options; r = this.elem;
                var k = q.complete, u = q.duration, d = q.curAnim, c; if (r.attr && !r.element) r = !1; else if (a || f >= u + this.startTime) { this.now = this.end; this.pos = 1; this.update(); a = d[this.prop] = !0; for (c in d) !0 !== d[c] && (a = !1); a && k && k.call(r); r = !1 } else this.pos = q.easing((f - this.startTime) / u), this.now = this.start + (this.end - this.start) * this.pos, this.update(), r = !0; return r
            }, initPath: function (r, f, l) {
                function q(a) {
                    var b, e; for (t = a.length; t--;) b = "M" === a[t] || "L" === a[t], e = /[a-zA-Z]/.test(a[t + 3]), b && e && a.splice(t + 1, 0, a[t + 1], a[t + 2], a[t + 1], a[t +
                        2])
                } function k(a, e) { for (; a.length < p;) { a[0] = e[p - a.length]; var h = a.slice(0, b);[].splice.apply(a, [0, 0].concat(h)); D && (h = a.slice(a.length - b), [].splice.apply(a, [a.length, 0].concat(h)), t--) } a[0] = "M" } function u(a, e) { for (var c = (p - a.length) / b; 0 < c && c--;) h = a.slice().splice(a.length / w - b, b * w), h[0] = e[p - b - c * b], z && (h[b - 6] = h[b - 2], h[b - 5] = h[b - 1]), [].splice.apply(a, [a.length / w, 0].concat(h)), D && c-- } f = f || ""; var d, c = r.startX, n = r.endX, z = -1 < f.indexOf("C"), b = z ? 7 : 3, p, h, t; f = f.split(" "); l = l.slice(); var D = r.isArea, w = D ? 2 : 1, e;
                z && (q(f), q(l)); if (c && n) { for (t = 0; t < c.length; t++) if (c[t] === n[0]) { d = t; break } else if (c[0] === n[n.length - c.length + t]) { d = t; e = !0; break } void 0 === d && (f = []) } f.length && a.isNumber(d) && (p = l.length + d * w * b, e ? (k(f, l), u(l, f)) : (k(l, f), u(f, l))); return [f, l]
            }
        }; a.extend = function (a, f) { var r; a || (a = {}); for (r in f) a[r] = f[r]; return a }; a.merge = function () {
            var r, f = arguments, l, q = {}, k = function (u, d) {
                var c, n; "object" !== typeof u && (u = {}); for (n in d) d.hasOwnProperty(n) && (c = d[n], a.isObject(c, !0) && "renderTo" !== n && "number" !== typeof c.nodeType ?
                    u[n] = k(u[n] || {}, c) : u[n] = d[n]); return u
            }; !0 === f[0] && (q = f[1], f = Array.prototype.slice.call(f, 2)); l = f.length; for (r = 0; r < l; r++) q = k(q, f[r]); return q
        }; a.pInt = function (a, f) { return parseInt(a, f || 10) }; a.isString = function (a) { return "string" === typeof a }; a.isArray = function (a) { a = Object.prototype.toString.call(a); return "[object Array]" === a || "[object Array Iterator]" === a }; a.isObject = function (r, f) { return r && "object" === typeof r && (!f || !a.isArray(r)) }; a.isNumber = function (a) { return "number" === typeof a && !isNaN(a) }; a.erase =
            function (a, f) { for (var r = a.length; r--;) if (a[r] === f) { a.splice(r, 1); break } }; a.defined = function (a) { return void 0 !== a && null !== a }; a.attr = function (r, f, l) { var q, k; if (a.isString(f)) a.defined(l) ? r.setAttribute(f, l) : r && r.getAttribute && (k = r.getAttribute(f)); else if (a.defined(f) && a.isObject(f)) for (q in f) r.setAttribute(q, f[q]); return k }; a.splat = function (r) { return a.isArray(r) ? r : [r] }; a.syncTimeout = function (a, f, l) { if (f) return setTimeout(a, f, l); a.call(0, l) }; a.pick = function () {
                var a = arguments, f, l, q = a.length; for (f =
                    0; f < q; f++) if (l = a[f], void 0 !== l && null !== l) return l
            }; a.css = function (r, f) { a.isMS && !a.svg && f && void 0 !== f.opacity && (f.filter = "alpha(opacity\x3d" + 100 * f.opacity + ")"); a.extend(r.style, f) }; a.createElement = function (r, f, l, q, k) { r = H.createElement(r); var u = a.css; f && a.extend(r, f); k && u(r, { padding: 0, border: "none", margin: 0 }); l && u(r, l); q && q.appendChild(r); return r }; a.extendClass = function (r, f) { var l = function () { }; l.prototype = new r; a.extend(l.prototype, f); return l }; a.pad = function (a, f, l) {
                return Array((f || 2) + 1 - String(a).length).join(l ||
                    0) + a
            }; a.relativeLength = function (a, f) { return /%$/.test(a) ? f * parseFloat(a) / 100 : parseFloat(a) }; a.wrap = function (a, f, l) { var q = a[f]; a[f] = function () { var a = Array.prototype.slice.call(arguments), u = arguments, d = this; d.proceed = function () { q.apply(d, arguments.length ? arguments : u) }; a.unshift(q); a = l.apply(this, a); d.proceed = null; return a } }; a.getTZOffset = function (r) { var f = a.Date; return 6E4 * (f.hcGetTimezoneOffset && f.hcGetTimezoneOffset(r) || f.hcTimezoneOffset || 0) }; a.dateFormat = function (r, f, l) {
                if (!a.defined(f) || isNaN(f)) return a.defaultOptions.lang.invalidDate ||
                    ""; r = a.pick(r, "%Y-%m-%d %H:%M:%S"); var q = a.Date, k = new q(f - a.getTZOffset(f)), u, d = k[q.hcGetHours](), c = k[q.hcGetDay](), n = k[q.hcGetDate](), z = k[q.hcGetMonth](), b = k[q.hcGetFullYear](), p = a.defaultOptions.lang, h = p.weekdays, t = p.shortWeekdays, D = a.pad, q = a.extend({
                        a: t ? t[c] : h[c].substr(0, 3), A: h[c], d: D(n), e: D(n, 2, " "), w: c, b: p.shortMonths[z], B: p.months[z], m: D(z + 1), y: b.toString().substr(2, 2), Y: b, H: D(d), k: d, I: D(d % 12 || 12), l: d % 12 || 12, M: D(k[q.hcGetMinutes]()), p: 12 > d ? "AM" : "PM", P: 12 > d ? "am" : "pm", S: D(k.getSeconds()), L: D(Math.round(f %
                            1E3), 3)
                    }, a.dateFormats); for (u in q) for (; -1 !== r.indexOf("%" + u);) r = r.replace("%" + u, "function" === typeof q[u] ? q[u](f) : q[u]); return l ? r.substr(0, 1).toUpperCase() + r.substr(1) : r
            }; a.formatSingle = function (r, f) { var l = /\.([0-9])/, q = a.defaultOptions.lang; /f$/.test(r) ? (l = (l = r.match(l)) ? l[1] : -1, null !== f && (f = a.numberFormat(f, l, q.decimalPoint, -1 < r.indexOf(",") ? q.thousandsSep : ""))) : f = a.dateFormat(r, f); return f }; a.format = function (r, f) {
                for (var l = "{", q = !1, k, u, d, c, n = [], z; r;) {
                    l = r.indexOf(l); if (-1 === l) break; k = r.slice(0,
                        l); if (q) { k = k.split(":"); u = k.shift().split("."); c = u.length; z = f; for (d = 0; d < c; d++) z = z[u[d]]; k.length && (z = a.formatSingle(k.join(":"), z)); n.push(z) } else n.push(k); r = r.slice(l + 1); l = (q = !q) ? "}" : "{"
                } n.push(r); return n.join("")
            }; a.getMagnitude = function (a) { return Math.pow(10, Math.floor(Math.log(a) / Math.LN10)) }; a.normalizeTickInterval = function (r, f, l, q, k) {
                var u, d = r; l = a.pick(l, 1); u = r / l; f || (f = k ? [1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8, 10] : [1, 2, 2.5, 5, 10], !1 === q && (1 === l ? f = a.grep(f, function (a) { return 0 === a % 1 }) : .1 >= l && (f = [1 / l])));
                for (q = 0; q < f.length && !(d = f[q], k && d * l >= r || !k && u <= (f[q] + (f[q + 1] || f[q])) / 2); q++); return d = a.correctFloat(d * l, -Math.round(Math.log(.001) / Math.LN10))
            }; a.stableSort = function (a, f) { var l = a.length, q, k; for (k = 0; k < l; k++) a[k].safeI = k; a.sort(function (a, d) { q = f(a, d); return 0 === q ? a.safeI - d.safeI : q }); for (k = 0; k < l; k++) delete a[k].safeI }; a.arrayMin = function (a) { for (var f = a.length, l = a[0]; f--;) a[f] < l && (l = a[f]); return l }; a.arrayMax = function (a) { for (var f = a.length, l = a[0]; f--;) a[f] > l && (l = a[f]); return l }; a.destroyObjectProperties =
                function (a, f) { for (var l in a) a[l] && a[l] !== f && a[l].destroy && a[l].destroy(), delete a[l] }; a.discardElement = function (r) { var f = a.garbageBin; f || (f = a.createElement("div")); r && f.appendChild(r); f.innerHTML = "" }; a.correctFloat = function (a, f) { return parseFloat(a.toPrecision(f || 14)) }; a.setAnimation = function (r, f) { f.renderer.globalAnimation = a.pick(r, f.options.chart.animation, !0) }; a.animObject = function (r) { return a.isObject(r) ? a.merge(r) : { duration: r ? 500 : 0 } }; a.timeUnits = {
                    millisecond: 1, second: 1E3, minute: 6E4, hour: 36E5,
                    day: 864E5, week: 6048E5, month: 24192E5, year: 314496E5
                }; a.numberFormat = function (r, f, l, q) { r = +r || 0; f = +f; var k = a.defaultOptions.lang, u = (r.toString().split(".")[1] || "").length, d, c; -1 === f ? f = Math.min(u, 20) : a.isNumber(f) || (f = 2); c = (Math.abs(r) + Math.pow(10, -Math.max(f, u) - 1)).toFixed(f); u = String(a.pInt(c)); d = 3 < u.length ? u.length % 3 : 0; l = a.pick(l, k.decimalPoint); q = a.pick(q, k.thousandsSep); r = (0 > r ? "-" : "") + (d ? u.substr(0, d) + q : ""); r += u.substr(d).replace(/(\d{3})(?=\d)/g, "$1" + q); f && (r += l + c.slice(-f)); return r }; Math.easeInOutSine =
                    function (a) { return -.5 * (Math.cos(Math.PI * a) - 1) }; a.getStyle = function (r, f) { return "width" === f ? Math.min(r.offsetWidth, r.scrollWidth) - a.getStyle(r, "padding-left") - a.getStyle(r, "padding-right") : "height" === f ? Math.min(r.offsetHeight, r.scrollHeight) - a.getStyle(r, "padding-top") - a.getStyle(r, "padding-bottom") : (r = G.getComputedStyle(r, void 0)) && a.pInt(r.getPropertyValue(f)) }; a.inArray = function (a, f) { return f.indexOf ? f.indexOf(a) : [].indexOf.call(f, a) }; a.grep = function (a, f) { return [].filter.call(a, f) }; a.find = function (a,
                        f) { return [].find.call(a, f) }; a.map = function (a, f) { for (var l = [], q = 0, k = a.length; q < k; q++) l[q] = f.call(a[q], a[q], q, a); return l }; a.offset = function (a) { var f = H.documentElement; a = a.getBoundingClientRect(); return { top: a.top + (G.pageYOffset || f.scrollTop) - (f.clientTop || 0), left: a.left + (G.pageXOffset || f.scrollLeft) - (f.clientLeft || 0) } }; a.stop = function (a, f) { for (var l = B.length; l--;) B[l].elem !== a || f && f !== B[l].prop || (B[l].stopped = !0) }; a.each = function (a, f, l) { return Array.prototype.forEach.call(a, f, l) }; a.addEvent = function (r,
                            f, l) { function q(a) { a.target = a.srcElement || G; l.call(r, a) } var k = r.hcEvents = r.hcEvents || {}; r.addEventListener ? r.addEventListener(f, l, !1) : r.attachEvent && (r.hcEventsIE || (r.hcEventsIE = {}), r.hcEventsIE[l.toString()] = q, r.attachEvent("on" + f, q)); k[f] || (k[f] = []); k[f].push(l); return function () { a.removeEvent(r, f, l) } }; a.removeEvent = function (r, f, l) {
                                function q(a, c) { r.removeEventListener ? r.removeEventListener(a, c, !1) : r.attachEvent && (c = r.hcEventsIE[c.toString()], r.detachEvent("on" + a, c)) } function k() {
                                    var a, c; if (r.nodeName) for (c in f ?
                                        (a = {}, a[f] = !0) : a = d, a) if (d[c]) for (a = d[c].length; a--;) q(c, d[c][a])
                                } var u, d = r.hcEvents, c; d && (f ? (u = d[f] || [], l ? (c = a.inArray(l, u), -1 < c && (u.splice(c, 1), d[f] = u), q(f, l)) : (k(), d[f] = [])) : (k(), r.hcEvents = {}))
                            }; a.fireEvent = function (r, f, l, q) {
                                var k; k = r.hcEvents; var u, d; l = l || {}; if (H.createEvent && (r.dispatchEvent || r.fireEvent)) k = H.createEvent("Events"), k.initEvent(f, !0, !0), a.extend(k, l), r.dispatchEvent ? r.dispatchEvent(k) : r.fireEvent(f, k); else if (k) for (k = k[f] || [], u = k.length, l.target || a.extend(l, {
                                    preventDefault: function () {
                                        l.defaultPrevented =
                                            !0
                                    }, target: r, type: f
                                }), f = 0; f < u; f++) (d = k[f]) && !1 === d.call(r, l) && l.preventDefault(); q && !l.defaultPrevented && q(l)
                            }; a.animate = function (r, f, l) {
                                var q, k = "", u, d, c; a.isObject(l) || (q = arguments, l = { duration: q[2], easing: q[3], complete: q[4] }); a.isNumber(l.duration) || (l.duration = 400); l.easing = "function" === typeof l.easing ? l.easing : Math[l.easing] || Math.easeInOutSine; l.curAnim = a.merge(f); for (c in f) a.stop(r, c), d = new a.Fx(r, l, c), u = null, "d" === c ? (d.paths = d.initPath(r, r.d, f.d), d.toD = f.d, q = 0, u = 1) : r.attr ? q = r.attr(c) : (q = parseFloat(a.getStyle(r,
                                    c)) || 0, "opacity" !== c && (k = "px")), u || (u = f[c]), u && u.match && u.match("px") && (u = u.replace(/px/g, "")), d.run(q, u, k)
                            }; a.seriesType = function (r, f, l, q, k) { var u = a.getOptions(), d = a.seriesTypes; u.plotOptions[r] = a.merge(u.plotOptions[f], l); d[r] = a.extendClass(d[f] || function () { }, q); d[r].prototype.type = r; k && (d[r].prototype.pointClass = a.extendClass(a.Point, k)); return d[r] }; a.uniqueKey = function () { var a = Math.random().toString(36).substring(2, 9), f = 0; return function () { return "highcharts-" + a + "-" + f++ } }(); G.jQuery && (G.jQuery.fn.highcharts =
                                function () { var r = [].slice.call(arguments); if (this[0]) return r[0] ? (new (a[a.isString(r[0]) ? r.shift() : "Chart"])(this[0], r[0], r[1]), this) : A[a.attr(this[0], "data-highcharts-chart")] }); H && !H.defaultView && (a.getStyle = function (r, f) {
                                    var l = { width: "clientWidth", height: "clientHeight" }[f]; if (r.style[f]) return a.pInt(r.style[f]); "opacity" === f && (f = "filter"); if (l) return r.style.zoom = 1, Math.max(r[l] - 2 * a.getStyle(r, "padding"), 0); r = r.currentStyle[f.replace(/\-(\w)/g, function (a, k) { return k.toUpperCase() })]; "filter" ===
                                        f && (r = r.replace(/alpha\(opacity=([0-9]+)\)/, function (a, k) { return k / 100 })); return "" === r ? 1 : a.pInt(r)
                                }); Array.prototype.forEach || (a.each = function (a, f, l) { for (var q = 0, k = a.length; q < k; q++) if (!1 === f.call(l, a[q], q, a)) return q }); Array.prototype.indexOf || (a.inArray = function (a, f) { var l, q = 0; if (f) for (l = f.length; q < l; q++) if (f[q] === a) return q; return -1 }); Array.prototype.filter || (a.grep = function (a, f) { for (var l = [], q = 0, k = a.length; q < k; q++) f(a[q], q) && l.push(a[q]); return l }); Array.prototype.find || (a.find = function (a, f) {
                                    var l,
                                        q = a.length; for (l = 0; l < q; l++) if (f(a[l], l)) return a[l]
                                })
    })(L); (function (a) {
        var B = a.each, A = a.isNumber, H = a.map, G = a.merge, r = a.pInt; a.Color = function (f) { if (!(this instanceof a.Color)) return new a.Color(f); this.init(f) }; a.Color.prototype = {
            parsers: [{ regex: /rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/, parse: function (a) { return [r(a[1]), r(a[2]), r(a[3]), parseFloat(a[4], 10)] } }, {
                regex: /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/, parse: function (a) {
                    return [r(a[1]),
                    r(a[2]), r(a[3]), 1]
                }
            }], names: { white: "#ffffff", black: "#000000" }, init: function (f) {
                var l, q, k, u; if ((this.input = f = this.names[f && f.toLowerCase ? f.toLowerCase() : ""] || f) && f.stops) this.stops = H(f.stops, function (d) { return new a.Color(d[1]) }); else if (f && "#" === f[0] && (l = f.length, f = parseInt(f.substr(1), 16), 7 === l ? q = [(f & 16711680) >> 16, (f & 65280) >> 8, f & 255, 1] : 4 === l && (q = [(f & 3840) >> 4 | (f & 3840) >> 8, (f & 240) >> 4 | f & 240, (f & 15) << 4 | f & 15, 1])), !q) for (k = this.parsers.length; k-- && !q;) u = this.parsers[k], (l = u.regex.exec(f)) && (q = u.parse(l));
                this.rgba = q || []
            }, get: function (a) { var f = this.input, q = this.rgba, k; this.stops ? (k = G(f), k.stops = [].concat(k.stops), B(this.stops, function (u, d) { k.stops[d] = [k.stops[d][0], u.get(a)] })) : k = q && A(q[0]) ? "rgb" === a || !a && 1 === q[3] ? "rgb(" + q[0] + "," + q[1] + "," + q[2] + ")" : "a" === a ? q[3] : "rgba(" + q.join(",") + ")" : f; return k }, brighten: function (a) { var f, q = this.rgba; if (this.stops) B(this.stops, function (k) { k.brighten(a) }); else if (A(a) && 0 !== a) for (f = 0; 3 > f; f++) q[f] += r(255 * a), 0 > q[f] && (q[f] = 0), 255 < q[f] && (q[f] = 255); return this }, setOpacity: function (a) {
                this.rgba[3] =
                    a; return this
            }
        }; a.color = function (f) { return new a.Color(f) }
    })(L); (function (a) {
        var B, A, H = a.addEvent, G = a.animate, r = a.attr, f = a.charts, l = a.color, q = a.css, k = a.createElement, u = a.defined, d = a.deg2rad, c = a.destroyObjectProperties, n = a.doc, z = a.each, b = a.extend, p = a.erase, h = a.grep, t = a.hasTouch, D = a.inArray, w = a.isArray, e = a.isFirefox, x = a.isMS, C = a.isObject, E = a.isString, m = a.isWebKit, y = a.merge, I = a.noop, K = a.pick, J = a.pInt, g = a.removeEvent, F = a.stop, Q = a.svg, N = a.SVG_NS, P = a.symbolSizes, O = a.win; B = a.SVGElement = function () { return this };
        B.prototype = {
            opacity: 1, SVG_NS: N, textProps: "direction fontSize fontWeight fontFamily fontStyle color lineHeight width textAlign textDecoration textOverflow textOutline".split(" "), init: function (a, g) { this.element = "span" === g ? k(g) : n.createElementNS(this.SVG_NS, g); this.renderer = a }, animate: function (v, g, b) { g = a.animObject(K(g, this.renderer.globalAnimation, !0)); 0 !== g.duration ? (b && (g.complete = b), G(this, v, g)) : (this.attr(v, null, b), g.step && g.step.call(this)); return this }, colorGradient: function (v, g, b) {
                var e = this.renderer,
                    h, c, m, M, F, x, d, C, t, p, n, k = [], R; v.radialGradient ? c = "radialGradient" : v.linearGradient && (c = "linearGradient"); if (c) {
                        m = v[c]; F = e.gradients; d = v.stops; p = b.radialReference; w(m) && (v[c] = m = { x1: m[0], y1: m[1], x2: m[2], y2: m[3], gradientUnits: "userSpaceOnUse" }); "radialGradient" === c && p && !u(m.gradientUnits) && (M = m, m = y(m, e.getRadialAttr(p, M), { gradientUnits: "userSpaceOnUse" })); for (n in m) "id" !== n && k.push(n, m[n]); for (n in d) k.push(d[n]); k = k.join(","); F[k] ? p = F[k].attr("id") : (m.id = p = a.uniqueKey(), F[k] = x = e.createElement(c).attr(m).add(e.defs),
                            x.radAttr = M, x.stops = [], z(d, function (v) { 0 === v[1].indexOf("rgba") ? (h = a.color(v[1]), C = h.get("rgb"), t = h.get("a")) : (C = v[1], t = 1); v = e.createElement("stop").attr({ offset: v[0], "stop-color": C, "stop-opacity": t }).add(x); x.stops.push(v) })); R = "url(" + e.url + "#" + p + ")"; b.setAttribute(g, R); b.gradient = k; v.toString = function () { return R }
                    }
            }, applyTextOutline: function (v) {
                var g = this.element, b, e, c, h, m; -1 !== v.indexOf("contrast") && (v = v.replace(/contrast/g, this.renderer.getContrast(g.style.fill))); v = v.split(" "); e = v[v.length - 1];
                if ((c = v[0]) && "none" !== c && a.svg) {
                    this.fakeTS = !0; v = [].slice.call(g.getElementsByTagName("tspan")); this.ySetter = this.xSetter; c = c.replace(/(^[\d\.]+)(.*?)$/g, function (a, v, g) { return 2 * v + g }); for (m = v.length; m--;) b = v[m], "highcharts-text-outline" === b.getAttribute("class") && p(v, g.removeChild(b)); h = g.firstChild; z(v, function (a, v) {
                        0 === v && (a.setAttribute("x", g.getAttribute("x")), v = g.getAttribute("y"), a.setAttribute("y", v || 0), null === v && g.setAttribute("y", 0)); a = a.cloneNode(1); r(a, {
                            "class": "highcharts-text-outline",
                            fill: e, stroke: e, "stroke-width": c, "stroke-linejoin": "round"
                        }); g.insertBefore(a, h)
                    })
                }
            }, attr: function (a, g, b, e) {
                var v, c = this.element, h, m = this, M; "string" === typeof a && void 0 !== g && (v = a, a = {}, a[v] = g); if ("string" === typeof a) m = (this[a + "Getter"] || this._defaultGetter).call(this, a, c); else {
                    for (v in a) g = a[v], M = !1, e || F(this, v), this.symbolName && /^(x|y|width|height|r|start|end|innerR|anchorX|anchorY)$/.test(v) && (h || (this.symbolAttr(a), h = !0), M = !0), !this.rotation || "x" !== v && "y" !== v || (this.doTransform = !0), M || (M = this[v +
                        "Setter"] || this._defaultSetter, M.call(this, g, v, c), this.shadows && /^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(v) && this.updateShadows(v, g, M)); this.doTransform && (this.updateTransform(), this.doTransform = !1)
                } b && b(); return m
            }, updateShadows: function (a, g, b) { for (var v = this.shadows, e = v.length; e--;) b.call(v[e], "height" === a ? Math.max(g - (v[e].cutHeight || 0), 0) : "d" === a ? this.d : g, a, v[e]) }, addClass: function (a, g) {
                var v = this.attr("class") || ""; -1 === v.indexOf(a) && (g || (a = (v + (v ? " " : "") + a).replace("  ", " ")),
                    this.attr("class", a)); return this
            }, hasClass: function (a) { return -1 !== r(this.element, "class").indexOf(a) }, removeClass: function (a) { r(this.element, "class", (r(this.element, "class") || "").replace(a, "")); return this }, symbolAttr: function (a) { var v = this; z("x y r start end width height innerR anchorX anchorY".split(" "), function (g) { v[g] = K(a[g], v[g]) }); v.attr({ d: v.renderer.symbols[v.symbolName](v.x, v.y, v.width, v.height, v) }) }, clip: function (a) {
                return this.attr("clip-path", a ? "url(" + this.renderer.url + "#" + a.id + ")" :
                    "none")
            }, crisp: function (a, g) { var v, b = {}, e; g = g || a.strokeWidth || 0; e = Math.round(g) % 2 / 2; a.x = Math.floor(a.x || this.x || 0) + e; a.y = Math.floor(a.y || this.y || 0) + e; a.width = Math.floor((a.width || this.width || 0) - 2 * e); a.height = Math.floor((a.height || this.height || 0) - 2 * e); u(a.strokeWidth) && (a.strokeWidth = g); for (v in a) this[v] !== a[v] && (this[v] = b[v] = a[v]); return b }, css: function (a) {
                var v = this.styles, g = {}, e = this.element, c, h = "", m = !v, F = ["textOutline", "textOverflow", "width"]; a && a.color && (a.fill = a.color); if (v) for (c in a) a[c] !==
                    v[c] && (g[c] = a[c], m = !0); if (m) { v && (a = b(v, g)); v = this.textWidth = a && a.width && "auto" !== a.width && "text" === e.nodeName.toLowerCase() && J(a.width); this.styles = a; v && !Q && this.renderer.forExport && delete a.width; if (x && !Q) q(this.element, a); else { v = function (a, v) { return "-" + v.toLowerCase() }; for (c in a) -1 === D(c, F) && (h += c.replace(/([A-Z])/g, v) + ":" + a[c] + ";"); h && r(e, "style", h) } this.added && ("text" === this.element.nodeName && this.renderer.buildText(this), a && a.textOutline && this.applyTextOutline(a.textOutline)) } return this
            }, strokeWidth: function () {
                return this["stroke-width"] ||
                    0
            }, on: function (a, g) { var v = this, e = v.element; t && "click" === a ? (e.ontouchstart = function (a) { v.touchEventFired = Date.now(); a.preventDefault(); g.call(e, a) }, e.onclick = function (a) { (-1 === O.navigator.userAgent.indexOf("Android") || 1100 < Date.now() - (v.touchEventFired || 0)) && g.call(e, a) }) : e["on" + a] = g; return this }, setRadialReference: function (a) { var v = this.renderer.gradients[this.element.gradient]; this.element.radialReference = a; v && v.radAttr && v.animate(this.renderer.getRadialAttr(a, v.radAttr)); return this }, translate: function (a,
                g) { return this.attr({ translateX: a, translateY: g }) }, invert: function (a) { this.inverted = a; this.updateTransform(); return this }, updateTransform: function () {
                    var a = this.translateX || 0, g = this.translateY || 0, e = this.scaleX, b = this.scaleY, c = this.inverted, h = this.rotation, m = this.element; c && (a += this.width, g += this.height); a = ["translate(" + a + "," + g + ")"]; c ? a.push("rotate(90) scale(-1,1)") : h && a.push("rotate(" + h + " " + (m.getAttribute("x") || 0) + " " + (m.getAttribute("y") || 0) + ")"); (u(e) || u(b)) && a.push("scale(" + K(e, 1) + " " + K(b, 1) + ")");
                    a.length && m.setAttribute("transform", a.join(" "))
                }, toFront: function () { var a = this.element; a.parentNode.appendChild(a); return this }, align: function (a, g, e) {
                    var v, b, c, h, m = {}; b = this.renderer; c = b.alignedObjects; var F, x; if (a) { if (this.alignOptions = a, this.alignByTranslate = g, !e || E(e)) this.alignTo = v = e || "renderer", p(c, this), c.push(this), e = null } else a = this.alignOptions, g = this.alignByTranslate, v = this.alignTo; e = K(e, b[v], b); v = a.align; b = a.verticalAlign; c = (e.x || 0) + (a.x || 0); h = (e.y || 0) + (a.y || 0); "right" === v ? F = 1 : "center" ===
                        v && (F = 2); F && (c += (e.width - (a.width || 0)) / F); m[g ? "translateX" : "x"] = Math.round(c); "bottom" === b ? x = 1 : "middle" === b && (x = 2); x && (h += (e.height - (a.height || 0)) / x); m[g ? "translateY" : "y"] = Math.round(h); this[this.placed ? "animate" : "attr"](m); this.placed = !0; this.alignAttr = m; return this
                }, getBBox: function (a, g) {
                    var v, e = this.renderer, c, h = this.element, m = this.styles, F, x = this.textStr, y, M = e.cache, C = e.cacheKeys, t; g = K(g, this.rotation); c = g * d; F = m && m.fontSize; void 0 !== x && (t = x.toString(), -1 === t.indexOf("\x3c") && (t = t.replace(/[0-9]/g,
                        "0")), t += ["", g || 0, F, m && m.width, m && m.textOverflow].join()); t && !a && (v = M[t]); if (!v) {
                            if (h.namespaceURI === this.SVG_NS || e.forExport) { try { (y = this.fakeTS && function (a) { z(h.querySelectorAll(".highcharts-text-outline"), function (v) { v.style.display = a }) }) && y("none"), v = h.getBBox ? b({}, h.getBBox()) : { width: h.offsetWidth, height: h.offsetHeight }, y && y("") } catch (X) { } if (!v || 0 > v.width) v = { width: 0, height: 0 } } else v = this.htmlGetBBox(); e.isSVG && (a = v.width, e = v.height, m && "11px" === m.fontSize && 17 === Math.round(e) && (v.height = e = 14),
                                g && (v.width = Math.abs(e * Math.sin(c)) + Math.abs(a * Math.cos(c)), v.height = Math.abs(e * Math.cos(c)) + Math.abs(a * Math.sin(c)))); if (t && 0 < v.height) { for (; 250 < C.length;) delete M[C.shift()]; M[t] || C.push(t); M[t] = v }
                        } return v
                }, show: function (a) { return this.attr({ visibility: a ? "inherit" : "visible" }) }, hide: function () { return this.attr({ visibility: "hidden" }) }, fadeOut: function (a) { var v = this; v.animate({ opacity: 0 }, { duration: a || 150, complete: function () { v.attr({ y: -9999 }) } }) }, add: function (a) {
                    var v = this.renderer, g = this.element,
                        e; a && (this.parentGroup = a); this.parentInverted = a && a.inverted; void 0 !== this.textStr && v.buildText(this); this.added = !0; if (!a || a.handleZ || this.zIndex) e = this.zIndexSetter(); e || (a ? a.element : v.box).appendChild(g); if (this.onAdd) this.onAdd(); return this
                }, safeRemoveChild: function (a) { var v = a.parentNode; v && v.removeChild(a) }, destroy: function () {
                    var a = this, g = a.element || {}, e = a.renderer.isSVG && "SPAN" === g.nodeName && a.parentGroup, b, c; g.onclick = g.onmouseout = g.onmouseover = g.onmousemove = g.point = null; F(a); a.clipPath && (z(a.element.ownerSVGElement.querySelectorAll("[clip-path]"),
                        function (v) { -1 < v.getAttribute("clip-path").indexOf(a.clipPath.element.id) && v.removeAttribute("clip-path") }), a.clipPath = a.clipPath.destroy()); if (a.stops) { for (c = 0; c < a.stops.length; c++) a.stops[c] = a.stops[c].destroy(); a.stops = null } a.safeRemoveChild(g); for (a.destroyShadows(); e && e.div && 0 === e.div.childNodes.length;) g = e.parentGroup, a.safeRemoveChild(e.div), delete e.div, e = g; a.alignTo && p(a.renderer.alignedObjects, a); for (b in a) delete a[b]; return null
                }, shadow: function (a, g, e) {
                    var v = [], b, c, h = this.element, m, F,
                        x, y; if (!a) this.destroyShadows(); else if (!this.shadows) { F = K(a.width, 3); x = (a.opacity || .15) / F; y = this.parentInverted ? "(-1,-1)" : "(" + K(a.offsetX, 1) + ", " + K(a.offsetY, 1) + ")"; for (b = 1; b <= F; b++) c = h.cloneNode(0), m = 2 * F + 1 - 2 * b, r(c, { isShadow: "true", stroke: a.color || "#000000", "stroke-opacity": x * b, "stroke-width": m, transform: "translate" + y, fill: "none" }), e && (r(c, "height", Math.max(r(c, "height") - m, 0)), c.cutHeight = m), g ? g.element.appendChild(c) : h.parentNode.insertBefore(c, h), v.push(c); this.shadows = v } return this
                }, destroyShadows: function () {
                    z(this.shadows ||
                        [], function (a) { this.safeRemoveChild(a) }, this); this.shadows = void 0
                }, xGetter: function (a) { "circle" === this.element.nodeName && ("x" === a ? a = "cx" : "y" === a && (a = "cy")); return this._defaultGetter(a) }, _defaultGetter: function (a) { a = K(this[a], this.element ? this.element.getAttribute(a) : null, 0); /^[\-0-9\.]+$/.test(a) && (a = parseFloat(a)); return a }, dSetter: function (a, g, e) { a && a.join && (a = a.join(" ")); /(NaN| {2}|^$)/.test(a) && (a = "M 0 0"); e.setAttribute(g, a); this[g] = a }, dashstyleSetter: function (a) {
                    var v, g = this["stroke-width"];
                    "inherit" === g && (g = 1); if (a = a && a.toLowerCase()) { a = a.replace("shortdashdotdot", "3,1,1,1,1,1,").replace("shortdashdot", "3,1,1,1").replace("shortdot", "1,1,").replace("shortdash", "3,1,").replace("longdash", "8,3,").replace(/dot/g, "1,3,").replace("dash", "4,3,").replace(/,$/, "").split(","); for (v = a.length; v--;) a[v] = J(a[v]) * g; a = a.join(",").replace(/NaN/g, "none"); this.element.setAttribute("stroke-dasharray", a) }
                }, alignSetter: function (a) { this.element.setAttribute("text-anchor", { left: "start", center: "middle", right: "end" }[a]) },
            opacitySetter: function (a, g, e) { this[g] = a; e.setAttribute(g, a) }, titleSetter: function (a) { var v = this.element.getElementsByTagName("title")[0]; v || (v = n.createElementNS(this.SVG_NS, "title"), this.element.appendChild(v)); v.firstChild && v.removeChild(v.firstChild); v.appendChild(n.createTextNode(String(K(a), "").replace(/<[^>]*>/g, ""))) }, textSetter: function (a) { a !== this.textStr && (delete this.bBox, this.textStr = a, this.added && this.renderer.buildText(this)) }, fillSetter: function (a, g, e) {
                "string" === typeof a ? e.setAttribute(g,
                    a) : a && this.colorGradient(a, g, e)
            }, visibilitySetter: function (a, g, e) { "inherit" === a ? e.removeAttribute(g) : e.setAttribute(g, a) }, zIndexSetter: function (a, g) { var v = this.renderer, e = this.parentGroup, b = (e || v).element || v.box, c, h = this.element, m; c = this.added; var F; u(a) && (h.zIndex = a, a = +a, this[g] === a && (c = !1), this[g] = a); if (c) { (a = this.zIndex) && e && (e.handleZ = !0); g = b.childNodes; for (F = 0; F < g.length && !m; F++) e = g[F], c = e.zIndex, e !== h && (J(c) > a || !u(a) && u(c) || 0 > a && !u(c) && b !== v.box) && (b.insertBefore(h, e), m = !0); m || b.appendChild(h) } return m },
            _defaultSetter: function (a, g, e) { e.setAttribute(g, a) }
        }; B.prototype.yGetter = B.prototype.xGetter; B.prototype.translateXSetter = B.prototype.translateYSetter = B.prototype.rotationSetter = B.prototype.verticalAlignSetter = B.prototype.scaleXSetter = B.prototype.scaleYSetter = function (a, g) { this[g] = a; this.doTransform = !0 }; B.prototype["stroke-widthSetter"] = B.prototype.strokeSetter = function (a, g, e) {
            this[g] = a; this.stroke && this["stroke-width"] ? (B.prototype.fillSetter.call(this, this.stroke, "stroke", e), e.setAttribute("stroke-width",
                this["stroke-width"]), this.hasStroke = !0) : "stroke-width" === g && 0 === a && this.hasStroke && (e.removeAttribute("stroke"), this.hasStroke = !1)
        }; A = a.SVGRenderer = function () { this.init.apply(this, arguments) }; A.prototype = {
            Element: B, SVG_NS: N, init: function (a, g, b, c, h, F) {
                var v; c = this.createElement("svg").attr({ version: "1.1", "class": "highcharts-root" }).css(this.getStyle(c)); v = c.element; a.appendChild(v); -1 === a.innerHTML.indexOf("xmlns") && r(v, "xmlns", this.SVG_NS); this.isSVG = !0; this.box = v; this.boxWrapper = c; this.alignedObjects =
                    []; this.url = (e || m) && n.getElementsByTagName("base").length ? O.location.href.replace(/#.*?$/, "").replace(/<[^>]*>/g, "").replace(/([\('\)])/g, "\\$1").replace(/ /g, "%20") : ""; this.createElement("desc").add().element.appendChild(n.createTextNode("Created with Highcharts 5.0.10")); this.defs = this.createElement("defs").add(); this.allowHTML = F; this.forExport = h; this.gradients = {}; this.cache = {}; this.cacheKeys = []; this.imgCount = 0; this.setSize(g, b, !1); var x; e && a.getBoundingClientRect && (g = function () {
                        q(a, { left: 0, top: 0 });
                        x = a.getBoundingClientRect(); q(a, { left: Math.ceil(x.left) - x.left + "px", top: Math.ceil(x.top) - x.top + "px" })
                    }, g(), this.unSubPixelFix = H(O, "resize", g))
            }, getStyle: function (a) { return this.style = b({ fontFamily: '"Lucida Grande", "Lucida Sans Unicode", Arial, Monotype, sans-serif', fontSize: "12px" }, a) }, setStyle: function (a) { this.boxWrapper.css(this.getStyle(a)) }, isHidden: function () { return !this.boxWrapper.getBBox().width }, destroy: function () {
                var a = this.defs; this.box = null; this.boxWrapper = this.boxWrapper.destroy(); c(this.gradients ||
                    {}); this.gradients = null; a && (this.defs = a.destroy()); this.unSubPixelFix && this.unSubPixelFix(); return this.alignedObjects = null
            }, createElement: function (a) { var g = new this.Element; g.init(this, a); return g }, draw: I, getRadialAttr: function (a, g) { return { cx: a[0] - a[2] / 2 + g.cx * a[2], cy: a[1] - a[2] / 2 + g.cy * a[2], r: g.r * a[2] } }, getSpanWidth: function (a, g) { var v = a.getBBox(!0).width; !Q && this.forExport && (v = this.measureSpanWidth(g.firstChild.data, a.styles)); return v }, applyEllipsis: function (a, g, e, b) {
                var v = this.getSpanWidth(a, g),
                    c = v > b, v = e, h, m = 0, F = e.length, x = function (a) { g.removeChild(g.firstChild); a && g.appendChild(n.createTextNode(a)) }; if (c) { for (; m <= F;) h = Math.ceil((m + F) / 2), v = e.substring(0, h) + "\u2026", x(v), v = this.getSpanWidth(a, g), m === F ? m = F + 1 : v > b ? F = h - 1 : m = h; 0 === F && x("") } return c
            }, buildText: function (a) {
                var g = a.element, e = this, v = e.forExport, b = K(a.textStr, "").toString(), c = -1 !== b.indexOf("\x3c"), m = g.childNodes, F, x, y, t, d = r(g, "x"), C = a.styles, p = a.textWidth, k = C && C.lineHeight, w = C && C.textOutline, u = C && "ellipsis" === C.textOverflow, f = C && "nowrap" ===
                    C.whiteSpace, E = C && C.fontSize, D, I, l = m.length, C = p && !a.added && this.box, P = function (a) { var v; v = /(px|em)$/.test(a && a.style.fontSize) ? a.style.fontSize : E || e.style.fontSize || 12; return k ? J(k) : e.fontMetrics(v, a.getAttribute("style") ? a : g).h }; D = [b, u, f, k, w, E, p].join(); if (D !== a.textCache) {
                        for (a.textCache = D; l--;) g.removeChild(m[l]); c || w || u || p || -1 !== b.indexOf(" ") ? (F = /<.*class="([^"]+)".*>/, x = /<.*style="([^"]+)".*>/, y = /<.*href="(http[^"]+)".*>/, C && C.appendChild(g), b = c ? b.replace(/<(b|strong)>/g, '\x3cspan style\x3d"font-weight:bold"\x3e').replace(/<(i|em)>/g,
                            '\x3cspan style\x3d"font-style:italic"\x3e').replace(/<a/g, "\x3cspan").replace(/<\/(b|strong|i|em|a)>/g, "\x3c/span\x3e").split(/<br.*?>/g) : [b], b = h(b, function (a) { return "" !== a }), z(b, function (b, c) {
                                var m, h = 0; b = b.replace(/^\s+|\s+$/g, "").replace(/<span/g, "|||\x3cspan").replace(/<\/span>/g, "\x3c/span\x3e|||"); m = b.split("|||"); z(m, function (b) {
                                    if ("" !== b || 1 === m.length) {
                                        var C = {}, k = n.createElementNS(e.SVG_NS, "tspan"), w, E; F.test(b) && (w = b.match(F)[1], r(k, "class", w)); x.test(b) && (E = b.match(x)[1].replace(/(;| |^)color([ :])/,
                                            "$1fill$2"), r(k, "style", E)); y.test(b) && !v && (r(k, "onclick", 'location.href\x3d"' + b.match(y)[1] + '"'), q(k, { cursor: "pointer" })); b = (b.replace(/<(.|\n)*?>/g, "") || " ").replace(/&lt;/g, "\x3c").replace(/&gt;/g, "\x3e"); if (" " !== b) {
                                                k.appendChild(n.createTextNode(b)); h ? C.dx = 0 : c && null !== d && (C.x = d); r(k, C); g.appendChild(k); !h && I && (!Q && v && q(k, { display: "block" }), r(k, "dy", P(k))); if (p) {
                                                    C = b.replace(/([^\^])-/g, "$1- ").split(" "); w = 1 < m.length || c || 1 < C.length && !f; var D = [], M, z = P(k), l = a.rotation; for (u && (t = e.applyEllipsis(a,
                                                        k, b, p)); !u && w && (C.length || D.length);) a.rotation = 0, M = e.getSpanWidth(a, k), b = M > p, void 0 === t && (t = b), b && 1 !== C.length ? (k.removeChild(k.firstChild), D.unshift(C.pop())) : (C = D, D = [], C.length && !f && (k = n.createElementNS(N, "tspan"), r(k, { dy: z, x: d }), E && r(k, "style", E), g.appendChild(k)), M > p && (p = M)), C.length && k.appendChild(n.createTextNode(C.join(" ").replace(/- /g, "-"))); a.rotation = l
                                                } h++
                                            }
                                    }
                                }); I = I || g.childNodes.length
                            }), t && a.attr("title", a.textStr), C && C.removeChild(g), w && a.applyTextOutline && a.applyTextOutline(w)) : g.appendChild(n.createTextNode(b.replace(/&lt;/g,
                                "\x3c").replace(/&gt;/g, "\x3e")))
                    }
            }, getContrast: function (a) { a = l(a).rgba; return 510 < a[0] + a[1] + a[2] ? "#000000" : "#FFFFFF" }, button: function (a, g, e, c, m, h, F, C, t) {
                var v = this.label(a, g, e, t, null, null, null, null, "button"), d = 0; v.attr(y({ padding: 8, r: 2 }, m)); var p, n, k, w; m = y({ fill: "#f7f7f7", stroke: "#cccccc", "stroke-width": 1, style: { color: "#333333", cursor: "pointer", fontWeight: "normal" } }, m); p = m.style; delete m.style; h = y(m, { fill: "#e6e6e6" }, h); n = h.style; delete h.style; F = y(m, { fill: "#e6ebf5", style: { color: "#000000", fontWeight: "bold" } },
                    F); k = F.style; delete F.style; C = y(m, { style: { color: "#cccccc" } }, C); w = C.style; delete C.style; H(v.element, x ? "mouseover" : "mouseenter", function () { 3 !== d && v.setState(1) }); H(v.element, x ? "mouseout" : "mouseleave", function () { 3 !== d && v.setState(d) }); v.setState = function (a) { 1 !== a && (v.state = d = a); v.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-" + ["normal", "hover", "pressed", "disabled"][a || 0]); v.attr([m, h, F, C][a || 0]).css([p, n, k, w][a || 0]) }; v.attr(m).css(b({ cursor: "default" },
                        p)); return v.on("click", function (a) { 3 !== d && c.call(v, a) })
            }, crispLine: function (a, g) { a[1] === a[4] && (a[1] = a[4] = Math.round(a[1]) - g % 2 / 2); a[2] === a[5] && (a[2] = a[5] = Math.round(a[2]) + g % 2 / 2); return a }, path: function (a) { var g = { fill: "none" }; w(a) ? g.d = a : C(a) && b(g, a); return this.createElement("path").attr(g) }, circle: function (a, g, e) { a = C(a) ? a : { x: a, y: g, r: e }; g = this.createElement("circle"); g.xSetter = g.ySetter = function (a, g, e) { e.setAttribute("c" + g, a) }; return g.attr(a) }, arc: function (a, g, e, b, c, m) {
                C(a) ? (b = a, g = b.y, e = b.r, a = b.x) :
                    b = { innerR: b, start: c, end: m }; a = this.symbol("arc", a, g, e, e, b); a.r = e; return a
            }, rect: function (a, g, e, b, c, m) { c = C(a) ? a.r : c; var v = this.createElement("rect"); a = C(a) ? a : void 0 === a ? {} : { x: a, y: g, width: Math.max(e, 0), height: Math.max(b, 0) }; void 0 !== m && (a.strokeWidth = m, a = v.crisp(a)); a.fill = "none"; c && (a.r = c); v.rSetter = function (a, g, e) { r(e, { rx: a, ry: a }) }; return v.attr(a) }, setSize: function (a, g, e) {
                var b = this.alignedObjects, v = b.length; this.width = a; this.height = g; for (this.boxWrapper.animate({ width: a, height: g }, {
                    step: function () {
                        this.attr({
                            viewBox: "0 0 " +
                                this.attr("width") + " " + this.attr("height")
                        })
                    }, duration: K(e, !0) ? void 0 : 0
                }); v--;) b[v].align()
            }, g: function (a) { var g = this.createElement("g"); return a ? g.attr({ "class": "highcharts-" + a }) : g }, image: function (a, g, e, c, m) { var v = { preserveAspectRatio: "none" }; 1 < arguments.length && b(v, { x: g, y: e, width: c, height: m }); v = this.createElement("image").attr(v); v.element.setAttributeNS ? v.element.setAttributeNS("http://www.w3.org/1999/xlink", "href", a) : v.element.setAttribute("hc-svg-href", a); return v }, symbol: function (a, g, e, c, m,
                h) {
                var v = this, F, x = this.symbols[a], y = u(g) && x && this.symbols[a](Math.round(g), Math.round(e), c, m, h), C = /^url\((.*?)\)$/, d, t; x ? (F = this.path(y), F.attr("fill", "none"), b(F, { symbolName: a, x: g, y: e, width: c, height: m }), h && b(F, h)) : C.test(a) && (d = a.match(C)[1], F = this.image(d), F.imgwidth = K(P[d] && P[d].width, h && h.width), F.imgheight = K(P[d] && P[d].height, h && h.height), t = function () { F.attr({ width: F.width, height: F.height }) }, z(["width", "height"], function (a) {
                    F[a + "Setter"] = function (a, g) {
                        var e = {}, b = this["img" + g], v = "width" === g ? "translateX" :
                            "translateY"; this[g] = a; u(b) && (this.element && this.element.setAttribute(g, b), this.alignByTranslate || (e[v] = ((this[g] || 0) - b) / 2, this.attr(e)))
                    }
                }), u(g) && F.attr({ x: g, y: e }), F.isImg = !0, u(F.imgwidth) && u(F.imgheight) ? t() : (F.attr({ width: 0, height: 0 }), k("img", {
                    onload: function () {
                        var a = f[v.chartIndex]; 0 === this.width && (q(this, { position: "absolute", top: "-999em" }), n.body.appendChild(this)); P[d] = { width: this.width, height: this.height }; F.imgwidth = this.width; F.imgheight = this.height; F.element && t(); this.parentNode && this.parentNode.removeChild(this);
                        v.imgCount--; if (!v.imgCount && a && a.onload) a.onload()
                    }, src: d
                }), this.imgCount++)); return F
            }, symbols: {
                circle: function (a, g, e, b) { return this.arc(a + e / 2, g + b / 2, e / 2, b / 2, { start: 0, end: 2 * Math.PI, open: !1 }) }, square: function (a, g, e, b) { return ["M", a, g, "L", a + e, g, a + e, g + b, a, g + b, "Z"] }, triangle: function (a, g, e, b) { return ["M", a + e / 2, g, "L", a + e, g + b, a, g + b, "Z"] }, "triangle-down": function (a, g, e, b) { return ["M", a, g, "L", a + e, g, a + e / 2, g + b, "Z"] }, diamond: function (a, g, e, b) { return ["M", a + e / 2, g, "L", a + e, g + b / 2, a + e / 2, g + b, a, g + b / 2, "Z"] }, arc: function (a,
                    g, e, b, c) { var v = c.start, m = c.r || e, h = c.r || b || e, F = c.end - .001; e = c.innerR; b = c.open; var x = Math.cos(v), y = Math.sin(v), C = Math.cos(F), F = Math.sin(F); c = c.end - v < Math.PI ? 0 : 1; m = ["M", a + m * x, g + h * y, "A", m, h, 0, c, 1, a + m * C, g + h * F]; u(e) && m.push(b ? "M" : "L", a + e * C, g + e * F, "A", e, e, 0, c, 0, a + e * x, g + e * y); m.push(b ? "" : "Z"); return m }, callout: function (a, g, e, b, c) {
                        var m = Math.min(c && c.r || 0, e, b), h = m + 6, v = c && c.anchorX; c = c && c.anchorY; var F; F = ["M", a + m, g, "L", a + e - m, g, "C", a + e, g, a + e, g, a + e, g + m, "L", a + e, g + b - m, "C", a + e, g + b, a + e, g + b, a + e - m, g + b, "L", a + m, g + b, "C",
                            a, g + b, a, g + b, a, g + b - m, "L", a, g + m, "C", a, g, a, g, a + m, g]; v && v > e ? c > g + h && c < g + b - h ? F.splice(13, 3, "L", a + e, c - 6, a + e + 6, c, a + e, c + 6, a + e, g + b - m) : F.splice(13, 3, "L", a + e, b / 2, v, c, a + e, b / 2, a + e, g + b - m) : v && 0 > v ? c > g + h && c < g + b - h ? F.splice(33, 3, "L", a, c + 6, a - 6, c, a, c - 6, a, g + m) : F.splice(33, 3, "L", a, b / 2, v, c, a, b / 2, a, g + m) : c && c > b && v > a + h && v < a + e - h ? F.splice(23, 3, "L", v + 6, g + b, v, g + b + 6, v - 6, g + b, a + m, g + b) : c && 0 > c && v > a + h && v < a + e - h && F.splice(3, 3, "L", v - 6, g, v, g - 6, v + 6, g, e - m, g); return F
                    }
            }, clipRect: function (g, e, b, c) {
                var m = a.uniqueKey(), h = this.createElement("clipPath").attr({ id: m }).add(this.defs);
                g = this.rect(g, e, b, c, 0).add(h); g.id = m; g.clipPath = h; g.count = 0; return g
            }, text: function (a, g, e, b) {
                var c = !Q && this.forExport, m = {}; if (b && (this.allowHTML || !this.forExport)) return this.html(a, g, e); m.x = Math.round(g || 0); e && (m.y = Math.round(e)); if (a || 0 === a) m.text = a; a = this.createElement("text").attr(m); c && a.css({ position: "absolute" }); b || (a.xSetter = function (a, g, e) {
                    var b = e.getElementsByTagName("tspan"), c, m = e.getAttribute(g), h; for (h = 0; h < b.length; h++) c = b[h], c.getAttribute(g) === m && c.setAttribute(g, a); e.setAttribute(g,
                        a)
                }); return a
            }, fontMetrics: function (a, g) { a = a || g && g.style && g.style.fontSize || this.style && this.style.fontSize; a = /px/.test(a) ? J(a) : /em/.test(a) ? parseFloat(a) * (g ? this.fontMetrics(null, g.parentNode).f : 16) : 12; g = 24 > a ? a + 3 : Math.round(1.2 * a); return { h: g, b: Math.round(.8 * g), f: a } }, rotCorr: function (a, g, e) { var b = a; g && e && (b = Math.max(b * Math.cos(g * d), 4)); return { x: -a / 3 * Math.sin(g * d), y: b } }, label: function (e, c, m, h, F, x, C, d, t) {
                var v = this, p = v.g("button" !== t && "label"), n = p.text = v.text("", 0, 0, C).attr({ zIndex: 1 }), k, w, E = 0, f = 3,
                    D = 0, I, q, l, Q, N, K = {}, J, r, M = /^url\((.*?)\)$/.test(h), P = M, R, S, O, U; t && p.addClass("highcharts-" + t); P = M; R = function () { return (J || 0) % 2 / 2 }; S = function () {
                        var a = n.element.style, g = {}; w = (void 0 === I || void 0 === q || N) && u(n.textStr) && n.getBBox(); p.width = (I || w.width || 0) + 2 * f + D; p.height = (q || w.height || 0) + 2 * f; r = f + v.fontMetrics(a && a.fontSize, n).b; P && (k || (p.box = k = v.symbols[h] || M ? v.symbol(h) : v.rect(), k.addClass(("button" === t ? "" : "highcharts-label-box") + (t ? " highcharts-" + t + "-box" : "")), k.add(p), a = R(), g.x = a, g.y = (d ? -r : 0) + a), g.width =
                            Math.round(p.width), g.height = Math.round(p.height), k.attr(b(g, K)), K = {})
                    }; O = function () { var a = D + f, g; g = d ? 0 : r; u(I) && w && ("center" === N || "right" === N) && (a += { center: .5, right: 1 }[N] * (I - w.width)); if (a !== n.x || g !== n.y) n.attr("x", a), void 0 !== g && n.attr("y", g); n.x = a; n.y = g }; U = function (a, g) { k ? k.attr(a, g) : K[a] = g }; p.onAdd = function () { n.add(p); p.attr({ text: e || 0 === e ? e : "", x: c, y: m }); k && u(F) && p.attr({ anchorX: F, anchorY: x }) }; p.widthSetter = function (g) { I = a.isNumber(g) ? g : null }; p.heightSetter = function (a) { q = a }; p["text-alignSetter"] =
                        function (a) { N = a }; p.paddingSetter = function (a) { u(a) && a !== f && (f = p.padding = a, O()) }; p.paddingLeftSetter = function (a) { u(a) && a !== D && (D = a, O()) }; p.alignSetter = function (a) { a = { left: 0, center: .5, right: 1 }[a]; a !== E && (E = a, w && p.attr({ x: l })) }; p.textSetter = function (a) { void 0 !== a && n.textSetter(a); S(); O() }; p["stroke-widthSetter"] = function (a, g) { a && (P = !0); J = this["stroke-width"] = a; U(g, a) }; p.strokeSetter = p.fillSetter = p.rSetter = function (a, g) { "fill" === g && a && (P = !0); U(g, a) }; p.anchorXSetter = function (a, g) {
                            F = a; U(g, Math.round(a) -
                                R() - l)
                        }; p.anchorYSetter = function (a, g) { x = a; U(g, a - Q) }; p.xSetter = function (a) { p.x = a; E && (a -= E * ((I || w.width) + 2 * f)); l = Math.round(a); p.attr("translateX", l) }; p.ySetter = function (a) { Q = p.y = Math.round(a); p.attr("translateY", Q) }; var W = p.css; return b(p, {
                            css: function (a) { if (a) { var g = {}; a = y(a); z(p.textProps, function (e) { void 0 !== a[e] && (g[e] = a[e], delete a[e]) }); n.css(g) } return W.call(p, a) }, getBBox: function () { return { width: w.width + 2 * f, height: w.height + 2 * f, x: w.x - f, y: w.y - f } }, shadow: function (a) { a && (S(), k && k.shadow(a)); return p },
                            destroy: function () { g(p.element, "mouseenter"); g(p.element, "mouseleave"); n && (n = n.destroy()); k && (k = k.destroy()); B.prototype.destroy.call(p); p = v = S = O = U = null }
                        })
            }
        }; a.Renderer = A
    })(L); (function (a) {
        var B = a.attr, A = a.createElement, H = a.css, G = a.defined, r = a.each, f = a.extend, l = a.isFirefox, q = a.isMS, k = a.isWebKit, u = a.pInt, d = a.SVGRenderer, c = a.win, n = a.wrap; f(a.SVGElement.prototype, {
            htmlCss: function (a) {
                var b = this.element; if (b = a && "SPAN" === b.tagName && a.width) delete a.width, this.textWidth = b, this.updateTransform(); a && "ellipsis" ===
                    a.textOverflow && (a.whiteSpace = "nowrap", a.overflow = "hidden"); this.styles = f(this.styles, a); H(this.element, a); return this
            }, htmlGetBBox: function () { var a = this.element; "text" === a.nodeName && (a.style.position = "absolute"); return { x: a.offsetLeft, y: a.offsetTop, width: a.offsetWidth, height: a.offsetHeight } }, htmlUpdateTransform: function () {
                if (this.added) {
                    var a = this.renderer, b = this.element, c = this.translateX || 0, h = this.translateY || 0, d = this.x || 0, n = this.y || 0, w = this.textAlign || "left", e = { left: 0, center: .5, right: 1 }[w], x = this.styles;
                    H(b, { marginLeft: c, marginTop: h }); this.shadows && r(this.shadows, function (a) { H(a, { marginLeft: c + 1, marginTop: h + 1 }) }); this.inverted && r(b.childNodes, function (e) { a.invertChild(e, b) }); if ("SPAN" === b.tagName) {
                        var C = this.rotation, f = u(this.textWidth), m = x && x.whiteSpace, y = [C, w, b.innerHTML, this.textWidth, this.textAlign].join(); y !== this.cTT && (x = a.fontMetrics(b.style.fontSize).b, G(C) && this.setSpanRotation(C, e, x), H(b, { width: "", whiteSpace: m || "nowrap" }), b.offsetWidth > f && /[ \-]/.test(b.textContent || b.innerText) && H(b, {
                            width: f +
                                "px", display: "block", whiteSpace: m || "normal"
                        }), this.getSpanCorrection(b.offsetWidth, x, e, C, w)); H(b, { left: d + (this.xCorr || 0) + "px", top: n + (this.yCorr || 0) + "px" }); k && (x = b.offsetHeight); this.cTT = y
                    }
                } else this.alignOnAdd = !0
            }, setSpanRotation: function (a, b, p) { var h = {}, d = q ? "-ms-transform" : k ? "-webkit-transform" : l ? "MozTransform" : c.opera ? "-o-transform" : ""; h[d] = h.transform = "rotate(" + a + "deg)"; h[d + (l ? "Origin" : "-origin")] = h.transformOrigin = 100 * b + "% " + p + "px"; H(this.element, h) }, getSpanCorrection: function (a, b, c) {
                this.xCorr =
                    -a * c; this.yCorr = -b
            }
        }); f(d.prototype, {
            html: function (a, b, c) {
                var h = this.createElement("span"), d = h.element, p = h.renderer, k = p.isSVG, e = function (a, e) { r(["opacity", "visibility"], function (b) { n(a, b + "Setter", function (a, b, c, h) { a.call(this, b, c, h); e[c] = b }) }) }; h.textSetter = function (a) { a !== d.innerHTML && delete this.bBox; d.innerHTML = this.textStr = a; h.htmlUpdateTransform() }; k && e(h, h.element.style); h.xSetter = h.ySetter = h.alignSetter = h.rotationSetter = function (a, e) { "align" === e && (e = "textAlign"); h[e] = a; h.htmlUpdateTransform() };
                h.attr({ text: a, x: Math.round(b), y: Math.round(c) }).css({ fontFamily: this.style.fontFamily, fontSize: this.style.fontSize, position: "absolute" }); d.style.whiteSpace = "nowrap"; h.css = h.htmlCss; k && (h.add = function (a) {
                    var b, c = p.box.parentNode, m = []; if (this.parentGroup = a) {
                        if (b = a.div, !b) {
                            for (; a;) m.push(a), a = a.parentGroup; r(m.reverse(), function (a) {
                                var x, d = B(a.element, "class"); d && (d = { className: d }); b = a.div = a.div || A("div", d, {
                                    position: "absolute", left: (a.translateX || 0) + "px", top: (a.translateY || 0) + "px", display: a.display,
                                    opacity: a.opacity, pointerEvents: a.styles && a.styles.pointerEvents
                                }, b || c); x = b.style; f(a, { on: function () { h.on.apply({ element: m[0].div }, arguments); return a }, translateXSetter: function (e, g) { x.left = e + "px"; a[g] = e; a.doTransform = !0 }, translateYSetter: function (e, g) { x.top = e + "px"; a[g] = e; a.doTransform = !0 } }); e(a, x)
                            })
                        }
                    } else b = c; b.appendChild(d); h.added = !0; h.alignOnAdd && h.htmlUpdateTransform(); return h
                }); return h
            }
        })
    })(L); (function (a) {
        var B, A, H = a.createElement, G = a.css, r = a.defined, f = a.deg2rad, l = a.discardElement, q = a.doc,
            k = a.each, u = a.erase, d = a.extend; B = a.extendClass; var c = a.isArray, n = a.isNumber, z = a.isObject, b = a.merge; A = a.noop; var p = a.pick, h = a.pInt, t = a.SVGElement, D = a.SVGRenderer, w = a.win; a.svg || (A = {
                docMode8: q && 8 === q.documentMode, init: function (a, b) {
                    var e = ["\x3c", b, ' filled\x3d"f" stroked\x3d"f"'], c = ["position: ", "absolute", ";"], m = "div" === b; ("shape" === b || m) && c.push("left:0;top:0;width:1px;height:1px;"); c.push("visibility: ", m ? "hidden" : "visible"); e.push(' style\x3d"', c.join(""), '"/\x3e'); b && (e = m || "span" === b || "img" === b ?
                        e.join("") : a.prepVML(e), this.element = H(e)); this.renderer = a
                }, add: function (a) { var e = this.renderer, b = this.element, c = e.box, m = a && a.inverted, c = a ? a.element || a : c; a && (this.parentGroup = a); m && e.invertChild(b, c); c.appendChild(b); this.added = !0; this.alignOnAdd && !this.deferUpdateTransform && this.updateTransform(); if (this.onAdd) this.onAdd(); this.className && this.attr("class", this.className); return this }, updateTransform: t.prototype.htmlUpdateTransform, setSpanRotation: function () {
                    var a = this.rotation, b = Math.cos(a * f), c =
                        Math.sin(a * f); G(this.element, { filter: a ? ["progid:DXImageTransform.Microsoft.Matrix(M11\x3d", b, ", M12\x3d", -c, ", M21\x3d", c, ", M22\x3d", b, ", sizingMethod\x3d'auto expand')"].join("") : "none" })
                }, getSpanCorrection: function (a, b, c, h, m) {
                    var e = h ? Math.cos(h * f) : 1, x = h ? Math.sin(h * f) : 0, d = p(this.elemHeight, this.element.offsetHeight), t; this.xCorr = 0 > e && -a; this.yCorr = 0 > x && -d; t = 0 > e * x; this.xCorr += x * b * (t ? 1 - c : c); this.yCorr -= e * b * (h ? t ? c : 1 - c : 1); m && "left" !== m && (this.xCorr -= a * c * (0 > e ? -1 : 1), h && (this.yCorr -= d * c * (0 > x ? -1 : 1)), G(this.element,
                        { textAlign: m }))
                }, pathToVML: function (a) { for (var e = a.length, b = []; e--;) n(a[e]) ? b[e] = Math.round(10 * a[e]) - 5 : "Z" === a[e] ? b[e] = "x" : (b[e] = a[e], !a.isArc || "wa" !== a[e] && "at" !== a[e] || (b[e + 5] === b[e + 7] && (b[e + 7] += a[e + 7] > a[e + 5] ? 1 : -1), b[e + 6] === b[e + 8] && (b[e + 8] += a[e + 8] > a[e + 6] ? 1 : -1))); return b.join(" ") || "x" }, clip: function (a) { var e = this, b; a ? (b = a.members, u(b, e), b.push(e), e.destroyClip = function () { u(b, e) }, a = a.getCSS(e)) : (e.destroyClip && e.destroyClip(), a = { clip: e.docMode8 ? "inherit" : "rect(auto)" }); return e.css(a) }, css: t.prototype.htmlCss,
                safeRemoveChild: function (a) { a.parentNode && l(a) }, destroy: function () { this.destroyClip && this.destroyClip(); return t.prototype.destroy.apply(this) }, on: function (a, b) { this.element["on" + a] = function () { var a = w.event; a.target = a.srcElement; b(a) }; return this }, cutOffPath: function (a, b) { var e; a = a.split(/[ ,]/); e = a.length; if (9 === e || 11 === e) a[e - 4] = a[e - 2] = h(a[e - 2]) - 10 * b; return a.join(" ") }, shadow: function (a, b, c) {
                    var e = [], m, d = this.element, t = this.renderer, x, n = d.style, g, F = d.path, k, C, w, f; F && "string" !== typeof F.value && (F =
                        "x"); C = F; if (a) {
                            w = p(a.width, 3); f = (a.opacity || .15) / w; for (m = 1; 3 >= m; m++) k = 2 * w + 1 - 2 * m, c && (C = this.cutOffPath(F.value, k + .5)), g = ['\x3cshape isShadow\x3d"true" strokeweight\x3d"', k, '" filled\x3d"false" path\x3d"', C, '" coordsize\x3d"10 10" style\x3d"', d.style.cssText, '" /\x3e'], x = H(t.prepVML(g), null, { left: h(n.left) + p(a.offsetX, 1), top: h(n.top) + p(a.offsetY, 1) }), c && (x.cutOff = k + 1), g = ['\x3cstroke color\x3d"', a.color || "#000000", '" opacity\x3d"', f * m, '"/\x3e'], H(t.prepVML(g), null, null, x), b ? b.element.appendChild(x) :
                                d.parentNode.insertBefore(x, d), e.push(x); this.shadows = e
                        } return this
                }, updateShadows: A, setAttr: function (a, b) { this.docMode8 ? this.element[a] = b : this.element.setAttribute(a, b) }, classSetter: function (a) { (this.added ? this.element : this).className = a }, dashstyleSetter: function (a, b, c) { (c.getElementsByTagName("stroke")[0] || H(this.renderer.prepVML(["\x3cstroke/\x3e"]), null, null, c))[b] = a || "solid"; this[b] = a }, dSetter: function (a, b, c) {
                    var e = this.shadows; a = a || []; this.d = a.join && a.join(" "); c.path = a = this.pathToVML(a); if (e) for (c =
                        e.length; c--;) e[c].path = e[c].cutOff ? this.cutOffPath(a, e[c].cutOff) : a; this.setAttr(b, a)
                }, fillSetter: function (a, b, c) { var e = c.nodeName; "SPAN" === e ? c.style.color = a : "IMG" !== e && (c.filled = "none" !== a, this.setAttr("fillcolor", this.renderer.color(a, c, b, this))) }, "fill-opacitySetter": function (a, b, c) { H(this.renderer.prepVML(["\x3c", b.split("-")[0], ' opacity\x3d"', a, '"/\x3e']), null, null, c) }, opacitySetter: A, rotationSetter: function (a, b, c) {
                    c = c.style; this[b] = c[b] = a; c.left = -Math.round(Math.sin(a * f) + 1) + "px"; c.top = Math.round(Math.cos(a *
                        f)) + "px"
                }, strokeSetter: function (a, b, c) { this.setAttr("strokecolor", this.renderer.color(a, c, b, this)) }, "stroke-widthSetter": function (a, b, c) { c.stroked = !!a; this[b] = a; n(a) && (a += "px"); this.setAttr("strokeweight", a) }, titleSetter: function (a, b) { this.setAttr(b, a) }, visibilitySetter: function (a, b, c) { "inherit" === a && (a = "visible"); this.shadows && k(this.shadows, function (e) { e.style[b] = a }); "DIV" === c.nodeName && (a = "hidden" === a ? "-999em" : 0, this.docMode8 || (c.style[b] = a ? "visible" : "hidden"), b = "top"); c.style[b] = a }, xSetter: function (a,
                    b, c) { this[b] = a; "x" === b ? b = "left" : "y" === b && (b = "top"); this.updateClipping ? (this[b] = a, this.updateClipping()) : c.style[b] = a }, zIndexSetter: function (a, b, c) { c.style[b] = a }
            }, A["stroke-opacitySetter"] = A["fill-opacitySetter"], a.VMLElement = A = B(t, A), A.prototype.ySetter = A.prototype.widthSetter = A.prototype.heightSetter = A.prototype.xSetter, A = {
                Element: A, isIE8: -1 < w.navigator.userAgent.indexOf("MSIE 8.0"), init: function (a, b, c) {
                    var e, m; this.alignedObjects = []; e = this.createElement("div").css({ position: "relative" }); m = e.element;
                    a.appendChild(e.element); this.isVML = !0; this.box = m; this.boxWrapper = e; this.gradients = {}; this.cache = {}; this.cacheKeys = []; this.imgCount = 0; this.setSize(b, c, !1); if (!q.namespaces.hcv) { q.namespaces.add("hcv", "urn:schemas-microsoft-com:vml"); try { q.createStyleSheet().cssText = "hcv\\:fill, hcv\\:path, hcv\\:shape, hcv\\:stroke{ behavior:url(#default#VML); display: inline-block; } " } catch (y) { q.styleSheets[0].cssText += "hcv\\:fill, hcv\\:path, hcv\\:shape, hcv\\:stroke{ behavior:url(#default#VML); display: inline-block; } " } }
                },
                isHidden: function () { return !this.box.offsetWidth }, clipRect: function (a, b, c, h) {
                    var e = this.createElement(), p = z(a); return d(e, {
                        members: [], count: 0, left: (p ? a.x : a) + 1, top: (p ? a.y : b) + 1, width: (p ? a.width : c) - 1, height: (p ? a.height : h) - 1, getCSS: function (a) {
                            var b = a.element, c = b.nodeName, g = a.inverted, e = this.top - ("shape" === c ? b.offsetTop : 0), m = this.left, b = m + this.width, h = e + this.height, e = { clip: "rect(" + Math.round(g ? m : e) + "px," + Math.round(g ? h : b) + "px," + Math.round(g ? b : h) + "px," + Math.round(g ? e : m) + "px)" }; !g && a.docMode8 && "DIV" === c &&
                                d(e, { width: b + "px", height: h + "px" }); return e
                        }, updateClipping: function () { k(e.members, function (a) { a.element && a.css(e.getCSS(a)) }) }
                    })
                }, color: function (b, c, h, d) {
                    var e = this, p, t = /^rgba/, n, x, g = "none"; b && b.linearGradient ? x = "gradient" : b && b.radialGradient && (x = "pattern"); if (x) {
                        var F, w, f = b.linearGradient || b.radialGradient, C, u, v, D, q, l = ""; b = b.stops; var z, E = [], r = function () {
                            n = ['\x3cfill colors\x3d"' + E.join(",") + '" opacity\x3d"', v, '" o:opacity2\x3d"', u, '" type\x3d"', x, '" ', l, 'focus\x3d"100%" method\x3d"any" /\x3e'];
                            H(e.prepVML(n), null, null, c)
                        }; C = b[0]; z = b[b.length - 1]; 0 < C[0] && b.unshift([0, C[1]]); 1 > z[0] && b.push([1, z[1]]); k(b, function (g, b) { t.test(g[1]) ? (p = a.color(g[1]), F = p.get("rgb"), w = p.get("a")) : (F = g[1], w = 1); E.push(100 * g[0] + "% " + F); b ? (v = w, D = F) : (u = w, q = F) }); if ("fill" === h) if ("gradient" === x) h = f.x1 || f[0] || 0, b = f.y1 || f[1] || 0, C = f.x2 || f[2] || 0, f = f.y2 || f[3] || 0, l = 'angle\x3d"' + (90 - 180 * Math.atan((f - b) / (C - h)) / Math.PI) + '"', r(); else {
                            var g = f.r, A = 2 * g, B = 2 * g, G = f.cx, V = f.cy, L = c.radialReference, T, g = function () {
                                L && (T = d.getBBox(), G += (L[0] -
                                    T.x) / T.width - .5, V += (L[1] - T.y) / T.height - .5, A *= L[2] / T.width, B *= L[2] / T.height); l = 'src\x3d"' + a.getOptions().global.VMLRadialGradientURL + '" size\x3d"' + A + "," + B + '" origin\x3d"0.5,0.5" position\x3d"' + G + "," + V + '" color2\x3d"' + q + '" '; r()
                            }; d.added ? g() : d.onAdd = g; g = D
                        } else g = F
                    } else t.test(b) && "IMG" !== c.tagName ? (p = a.color(b), d[h + "-opacitySetter"](p.get("a"), h, c), g = p.get("rgb")) : (g = c.getElementsByTagName(h), g.length && (g[0].opacity = 1, g[0].type = "solid"), g = b); return g
                }, prepVML: function (a) {
                    var b = this.isIE8; a = a.join("");
                    b ? (a = a.replace("/\x3e", ' xmlns\x3d"urn:schemas-microsoft-com:vml" /\x3e'), a = -1 === a.indexOf('style\x3d"') ? a.replace("/\x3e", ' style\x3d"display:inline-block;behavior:url(#default#VML);" /\x3e') : a.replace('style\x3d"', 'style\x3d"display:inline-block;behavior:url(#default#VML);')) : a = a.replace("\x3c", "\x3chcv:"); return a
                }, text: D.prototype.html, path: function (a) { var b = { coordsize: "10 10" }; c(a) ? b.d = a : z(a) && d(b, a); return this.createElement("shape").attr(b) }, circle: function (a, b, c) {
                    var e = this.symbol("circle");
                    z(a) && (c = a.r, b = a.y, a = a.x); e.isCircle = !0; e.r = c; return e.attr({ x: a, y: b })
                }, g: function (a) { var b; a && (b = { className: "highcharts-" + a, "class": "highcharts-" + a }); return this.createElement("div").attr(b) }, image: function (a, b, c, h, m) { var e = this.createElement("img").attr({ src: a }); 1 < arguments.length && e.attr({ x: b, y: c, width: h, height: m }); return e }, createElement: function (a) { return "rect" === a ? this.symbol(a) : D.prototype.createElement.call(this, a) }, invertChild: function (a, b) {
                    var c = this; b = b.style; var e = "IMG" === a.tagName && a.style;
                    G(a, { flip: "x", left: h(b.width) - (e ? h(e.top) : 1), top: h(b.height) - (e ? h(e.left) : 1), rotation: -90 }); k(a.childNodes, function (b) { c.invertChild(b, a) })
                }, symbols: {
                    arc: function (a, b, c, h, m) { var e = m.start, d = m.end, p = m.r || c || h; c = m.innerR; h = Math.cos(e); var t = Math.sin(e), g = Math.cos(d), F = Math.sin(d); if (0 === d - e) return ["x"]; e = ["wa", a - p, b - p, a + p, b + p, a + p * h, b + p * t, a + p * g, b + p * F]; m.open && !c && e.push("e", "M", a, b); e.push("at", a - c, b - c, a + c, b + c, a + c * g, b + c * F, a + c * h, b + c * t, "x", "e"); e.isArc = !0; return e }, circle: function (a, b, c, h, m) {
                        m && r(m.r) &&
                            (c = h = 2 * m.r); m && m.isCircle && (a -= c / 2, b -= h / 2); return ["wa", a, b, a + c, b + h, a + c, b + h / 2, a + c, b + h / 2, "e"]
                    }, rect: function (a, b, c, h, m) { return D.prototype.symbols[r(m) && m.r ? "callout" : "square"].call(0, a, b, c, h, m) }
                }
            }, a.VMLRenderer = B = function () { this.init.apply(this, arguments) }, B.prototype = b(D.prototype, A), a.Renderer = B); D.prototype.measureSpanWidth = function (a, b) { var c = q.createElement("span"); a = q.createTextNode(a); c.appendChild(a); G(c, b); this.box.appendChild(c); b = c.offsetWidth; l(c); return b }
    })(L); (function (a) {
        function B() {
            var k =
                a.defaultOptions.global, f = q.moment; if (k.timezone) { if (f) return function (a) { return -f.tz(a, k.timezone).utcOffset() }; a.error(25) } return k.useUTC && k.getTimezoneOffset
        } function A() {
            var k = a.defaultOptions.global, f, d = k.useUTC, c = d ? "getUTC" : "get", n = d ? "setUTC" : "set"; a.Date = f = k.Date || q.Date; f.hcTimezoneOffset = d && k.timezoneOffset; f.hcGetTimezoneOffset = B(); f.hcMakeTime = function (a, b, c, h, t, n) { var p; d ? (p = f.UTC.apply(0, arguments), p += r(p)) : p = (new f(a, b, l(c, 1), l(h, 0), l(t, 0), l(n, 0))).getTime(); return p }; G("Minutes Hours Day Date Month FullYear".split(" "),
                function (a) { f["hcGet" + a] = c + a }); G("Milliseconds Seconds Minutes Hours Date Month FullYear".split(" "), function (a) { f["hcSet" + a] = n + a })
        } var H = a.color, G = a.each, r = a.getTZOffset, f = a.merge, l = a.pick, q = a.win; a.defaultOptions = {
            colors: "#7cb5ec #434348 #90ed7d #f7a35c #8085e9 #f15c80 #e4d354 #2b908f #f45b5b #91e8e1".split(" "), symbols: ["circle", "diamond", "square", "triangle", "triangle-down"], lang: {
                loading: "Loading...", months: "January February March April May June July August September October November December".split(" "),
                shortMonths: "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "), weekdays: "Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "), decimalPoint: ".", numericSymbols: "kMGTPE".split(""), resetZoom: "Reset zoom", resetZoomTitle: "Reset zoom level 1:1", thousandsSep: " "
            }, global: { useUTC: !0, VMLRadialGradientURL: "http://code.highcharts.com/5.0.10/gfx/vml-radial-gradient.png" }, chart: {
                borderRadius: 0, defaultSeriesType: "line", ignoreHiddenSeries: !0, spacing: [10, 10, 15, 10], resetZoomButton: {
                    theme: { zIndex: 20 },
                    position: { align: "right", x: -10, y: 10 }
                }, width: null, height: null, borderColor: "#335cad", backgroundColor: "#ffffff", plotBorderColor: "#cccccc"
            }, title: { text: "Chart title", align: "center", margin: 15, widthAdjust: -44 }, subtitle: { text: "", align: "center", widthAdjust: -44 }, plotOptions: {}, labels: { style: { position: "absolute", color: "#333333" } }, legend: {
                enabled: !0, align: "center", layout: "horizontal", labelFormatter: function () { return this.name }, borderColor: "#999999", borderRadius: 0, navigation: { activeColor: "#003399", inactiveColor: "#cccccc" },
                itemStyle: { color: "#333333", fontSize: "12px", fontWeight: "bold" }, itemHoverStyle: { color: "#000000" }, itemHiddenStyle: { color: "#cccccc" }, shadow: !1, itemCheckboxStyle: { position: "absolute", width: "13px", height: "13px" }, squareSymbol: !0, symbolPadding: 5, verticalAlign: "bottom", x: 0, y: 0, title: { style: { fontWeight: "bold" } }
            }, loading: { labelStyle: { fontWeight: "bold", position: "relative", top: "45%" }, style: { position: "absolute", backgroundColor: "#ffffff", opacity: .5, textAlign: "center" } }, tooltip: {
                enabled: !0, animation: a.svg, borderRadius: 3,
                dateTimeLabelFormats: { millisecond: "%A, %b %e, %H:%M:%S.%L", second: "%A, %b %e, %H:%M:%S", minute: "%A, %b %e, %H:%M", hour: "%A, %b %e, %H:%M", day: "%A, %b %e, %Y", week: "Week from %A, %b %e, %Y", month: "%B %Y", year: "%Y" }, footerFormat: "", padding: 8, snap: a.isTouchDevice ? 25 : 10, backgroundColor: H("#f7f7f7").setOpacity(.85).get(), borderWidth: 1, headerFormat: '\x3cspan style\x3d"font-size: 10px"\x3e{point.key}\x3c/span\x3e\x3cbr/\x3e', pointFormat: '\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e {series.name}: \x3cb\x3e{point.y}\x3c/b\x3e\x3cbr/\x3e',
                shadow: !0, style: { color: "#333333", cursor: "default", fontSize: "12px", pointerEvents: "none", whiteSpace: "nowrap" }
            }, credits: { enabled: !0, href: "http://www.highcharts.com", position: { align: "right", x: -10, verticalAlign: "bottom", y: -5 }, style: { cursor: "pointer", color: "#999999", fontSize: "9px" }, text: "Highcharts.com" }
        }; a.setOptions = function (k) { a.defaultOptions = f(!0, a.defaultOptions, k); A(); return a.defaultOptions }; a.getOptions = function () { return a.defaultOptions }; a.defaultPlotOptions = a.defaultOptions.plotOptions; A()
    })(L);
    (function (a) {
        var B = a.arrayMax, A = a.arrayMin, H = a.defined, G = a.destroyObjectProperties, r = a.each, f = a.erase, l = a.merge, q = a.pick; a.PlotLineOrBand = function (a, f) { this.axis = a; f && (this.options = f, this.id = f.id) }; a.PlotLineOrBand.prototype = {
            render: function () {
                var a = this, f = a.axis, d = f.horiz, c = a.options, n = c.label, z = a.label, b = c.to, p = c.from, h = c.value, t = H(p) && H(b), D = H(h), w = a.svgElem, e = !w, x = [], C, E = c.color, m = q(c.zIndex, 0), y = c.events, x = { "class": "highcharts-plot-" + (t ? "band " : "line ") + (c.className || "") }, I = {}, r = f.chart.renderer,
                    J = t ? "bands" : "lines", g = f.log2lin; f.isLog && (p = g(p), b = g(b), h = g(h)); D ? (x = { stroke: E, "stroke-width": c.width }, c.dashStyle && (x.dashstyle = c.dashStyle)) : t && (E && (x.fill = E), c.borderWidth && (x.stroke = c.borderColor, x["stroke-width"] = c.borderWidth)); I.zIndex = m; J += "-" + m; (E = f.plotLinesAndBandsGroups[J]) || (f.plotLinesAndBandsGroups[J] = E = r.g("plot-" + J).attr(I).add()); e && (a.svgElem = w = r.path().attr(x).add(E)); if (D) x = f.getPlotLinePath(h, w.strokeWidth()); else if (t) x = f.getPlotBandPath(p, b, c); else return; if (e && x && x.length) {
                        if (w.attr({ d: x }),
                            y) for (C in c = function (g) { w.on(g, function (b) { y[g].apply(a, [b]) }) }, y) c(C)
                    } else w && (x ? (w.show(), w.animate({ d: x })) : (w.hide(), z && (a.label = z = z.destroy()))); n && H(n.text) && x && x.length && 0 < f.width && 0 < f.height && !x.flat ? (n = l({ align: d && t && "center", x: d ? !t && 4 : 10, verticalAlign: !d && t && "middle", y: d ? t ? 16 : 10 : t ? 6 : -4, rotation: d && !t && 90 }, n), this.renderLabel(n, x, t, m)) : z && z.hide(); return a
            }, renderLabel: function (a, f, d, c) {
                var n = this.label, k = this.axis.chart.renderer; n || (n = {
                    align: a.textAlign || a.align, rotation: a.rotation, "class": "highcharts-plot-" +
                        (d ? "band" : "line") + "-label " + (a.className || "")
                }, n.zIndex = c, this.label = n = k.text(a.text, 0, 0, a.useHTML).attr(n).add(), n.css(a.style)); c = [f[1], f[4], d ? f[6] : f[1]]; f = [f[2], f[5], d ? f[7] : f[2]]; d = A(c); k = A(f); n.align(a, !1, { x: d, y: k, width: B(c) - d, height: B(f) - k }); n.show()
            }, destroy: function () { f(this.axis.plotLinesAndBands, this); delete this.axis; G(this) }
        }; a.AxisPlotLineOrBandExtension = {
            getPlotBandPath: function (a, f) {
                var d = this.getPlotLinePath(f, null, null, !0), c = this.getPlotLinePath(a, null, null, !0), n = this.horiz, k = 1; a =
                    a < this.min && f < this.min || a > this.max && f > this.max; c && d ? (a && (c.flat = c.toString() === d.toString(), k = 0), c.push(n && d[4] === c[4] ? d[4] + k : d[4], n || d[5] !== c[5] ? d[5] : d[5] + k, n && d[1] === c[1] ? d[1] + k : d[1], n || d[2] !== c[2] ? d[2] : d[2] + k)) : c = null; return c
            }, addPlotBand: function (a) { return this.addPlotBandOrLine(a, "plotBands") }, addPlotLine: function (a) { return this.addPlotBandOrLine(a, "plotLines") }, addPlotBandOrLine: function (f, q) {
                var d = (new a.PlotLineOrBand(this, f)).render(), c = this.userOptions; d && (q && (c[q] = c[q] || [], c[q].push(f)),
                    this.plotLinesAndBands.push(d)); return d
            }, removePlotBandOrLine: function (a) { for (var k = this.plotLinesAndBands, d = this.options, c = this.userOptions, n = k.length; n--;) k[n].id === a && k[n].destroy(); r([d.plotLines || [], c.plotLines || [], d.plotBands || [], c.plotBands || []], function (c) { for (n = c.length; n--;) c[n].id === a && f(c, c[n]) }) }
        }
    })(L); (function (a) {
        var B = a.correctFloat, A = a.defined, H = a.destroyObjectProperties, G = a.isNumber, r = a.merge, f = a.pick, l = a.deg2rad; a.Tick = function (a, f, l, d) {
            this.axis = a; this.pos = f; this.type = l || ""; this.isNew =
                !0; l || d || this.addLabel()
        }; a.Tick.prototype = {
            addLabel: function () {
                var a = this.axis, k = a.options, l = a.chart, d = a.categories, c = a.names, n = this.pos, z = k.labels, b = a.tickPositions, p = n === b[0], h = n === b[b.length - 1], c = d ? f(d[n], c[n], n) : n, d = this.label, b = b.info, t; a.isDatetimeAxis && b && (t = k.dateTimeLabelFormats[b.higherRanks[n] || b.unitName]); this.isFirst = p; this.isLast = h; k = a.labelFormatter.call({ axis: a, chart: l, isFirst: p, isLast: h, dateTimeLabelFormat: t, value: a.isLog ? B(a.lin2log(c)) : c }); A(d) ? d && d.attr({ text: k }) : (this.labelLength =
                    (this.label = d = A(k) && z.enabled ? l.renderer.text(k, 0, 0, z.useHTML).css(r(z.style)).add(a.labelGroup) : null) && d.getBBox().width, this.rotation = 0)
            }, getLabelSize: function () { return this.label ? this.label.getBBox()[this.axis.horiz ? "height" : "width"] : 0 }, handleOverflow: function (a) {
                var k = this.axis, q = a.x, d = k.chart.chartWidth, c = k.chart.spacing, n = f(k.labelLeft, Math.min(k.pos, c[3])), c = f(k.labelRight, Math.max(k.pos + k.len, d - c[1])), z = this.label, b = this.rotation, p = { left: 0, center: .5, right: 1 }[k.labelAlign], h = z.getBBox().width,
                    t = k.getSlotWidth(), D = t, w = 1, e, x = {}; if (b) 0 > b && q - p * h < n ? e = Math.round(q / Math.cos(b * l) - n) : 0 < b && q + p * h > c && (e = Math.round((d - q) / Math.cos(b * l))); else if (d = q + (1 - p) * h, q - p * h < n ? D = a.x + D * (1 - p) - n : d > c && (D = c - a.x + D * p, w = -1), D = Math.min(t, D), D < t && "center" === k.labelAlign && (a.x += w * (t - D - p * (t - Math.min(h, D)))), h > D || k.autoRotation && (z.styles || {}).width) e = D; e && (x.width = e, (k.options.labels.style || {}).textOverflow || (x.textOverflow = "ellipsis"), z.css(x))
            }, getPosition: function (a, f, l, d) {
                var c = this.axis, n = c.chart, k = d && n.oldChartHeight ||
                    n.chartHeight; return { x: a ? c.translate(f + l, null, null, d) + c.transB : c.left + c.offset + (c.opposite ? (d && n.oldChartWidth || n.chartWidth) - c.right - c.left : 0), y: a ? k - c.bottom + c.offset - (c.opposite ? c.height : 0) : k - c.translate(f + l, null, null, d) - c.transB }
            }, getLabelPosition: function (a, f, u, d, c, n, z, b) {
                var p = this.axis, h = p.transA, t = p.reversed, k = p.staggerLines, w = p.tickRotCorr || { x: 0, y: 0 }, e = c.y; A(e) || (e = 0 === p.side ? u.rotation ? -8 : -u.getBBox().height : 2 === p.side ? w.y + 8 : Math.cos(u.rotation * l) * (w.y - u.getBBox(!1, 0).height / 2)); a = a + c.x +
                    w.x - (n && d ? n * h * (t ? -1 : 1) : 0); f = f + e - (n && !d ? n * h * (t ? 1 : -1) : 0); k && (u = z / (b || 1) % k, p.opposite && (u = k - u - 1), f += p.labelOffset / k * u); return { x: a, y: Math.round(f) }
            }, getMarkPath: function (a, f, l, d, c, n) { return n.crispLine(["M", a, f, "L", a + (c ? 0 : -l), f + (c ? l : 0)], d) }, renderGridLine: function (a, f, l) {
                var d = this.axis, c = d.options, n = this.gridLine, k = {}, b = this.pos, p = this.type, h = d.tickmarkOffset, t = d.chart.renderer, D = p ? p + "Grid" : "grid", w = c[D + "LineWidth"], e = c[D + "LineColor"], c = c[D + "LineDashStyle"]; n || (k.stroke = e, k["stroke-width"] = w, c && (k.dashstyle =
                    c), p || (k.zIndex = 1), a && (k.opacity = 0), this.gridLine = n = t.path().attr(k).addClass("highcharts-" + (p ? p + "-" : "") + "grid-line").add(d.gridGroup)); if (!a && n && (a = d.getPlotLinePath(b + h, n.strokeWidth() * l, a, !0))) n[this.isNew ? "attr" : "animate"]({ d: a, opacity: f })
            }, renderMark: function (a, k, l) {
                var d = this.axis, c = d.options, n = d.chart.renderer, q = this.type, b = q ? q + "Tick" : "tick", p = d.tickSize(b), h = this.mark, t = !h, D = a.x; a = a.y; var w = f(c[b + "Width"], !q && d.isXAxis ? 1 : 0), c = c[b + "Color"]; p && (d.opposite && (p[0] = -p[0]), t && (this.mark = h = n.path().addClass("highcharts-" +
                    (q ? q + "-" : "") + "tick").add(d.axisGroup), h.attr({ stroke: c, "stroke-width": w })), h[t ? "attr" : "animate"]({ d: this.getMarkPath(D, a, p[0], h.strokeWidth() * l, d.horiz, n), opacity: k }))
            }, renderLabel: function (a, k, l, d) {
                var c = this.axis, n = c.horiz, q = c.options, b = this.label, p = q.labels, h = p.step, t = c.tickmarkOffset, D = !0, w = a.x; a = a.y; b && G(w) && (b.xy = a = this.getLabelPosition(w, a, b, n, p, t, d, h), this.isFirst && !this.isLast && !f(q.showFirstLabel, 1) || this.isLast && !this.isFirst && !f(q.showLastLabel, 1) ? D = !1 : !n || c.isRadial || p.step || p.rotation ||
                    k || 0 === l || this.handleOverflow(a), h && d % h && (D = !1), D && G(a.y) ? (a.opacity = l, b[this.isNew ? "attr" : "animate"](a)) : b.attr("y", -9999), this.isNew = !1)
            }, render: function (a, k, l) { var d = this.axis, c = d.horiz, n = this.getPosition(c, this.pos, d.tickmarkOffset, k), q = n.x, b = n.y, d = c && q === d.pos + d.len || !c && b === d.pos ? -1 : 1; l = f(l, 1); this.isActive = !0; this.renderGridLine(k, l, d); this.renderMark(n, l, d); this.renderLabel(n, k, l, a) }, destroy: function () { H(this, this.axis) }
        }
    })(L); (function (a) {
        var B = a.addEvent, A = a.animObject, H = a.arrayMax, G = a.arrayMin,
            r = a.AxisPlotLineOrBandExtension, f = a.color, l = a.correctFloat, q = a.defaultOptions, k = a.defined, u = a.deg2rad, d = a.destroyObjectProperties, c = a.each, n = a.extend, z = a.fireEvent, b = a.format, p = a.getMagnitude, h = a.grep, t = a.inArray, D = a.isArray, w = a.isNumber, e = a.isString, x = a.merge, C = a.normalizeTickInterval, E = a.pick, m = a.PlotLineOrBand, y = a.removeEvent, I = a.splat, K = a.syncTimeout, J = a.Tick; a.Axis = function () { this.init.apply(this, arguments) }; a.Axis.prototype = {
                defaultOptions: {
                    dateTimeLabelFormats: {
                        millisecond: "%H:%M:%S.%L", second: "%H:%M:%S",
                        minute: "%H:%M", hour: "%H:%M", day: "%e. %b", week: "%e. %b", month: "%b '%y", year: "%Y"
                    }, endOnTick: !1, labels: { enabled: !0, style: { color: "#666666", cursor: "default", fontSize: "11px" }, x: 0 }, minPadding: .01, maxPadding: .01, minorTickLength: 2, minorTickPosition: "outside", startOfWeek: 1, startOnTick: !1, tickLength: 10, tickmarkPlacement: "between", tickPixelInterval: 100, tickPosition: "outside", title: { align: "middle", style: { color: "#666666" } }, type: "linear", minorGridLineColor: "#f2f2f2", minorGridLineWidth: 1, minorTickColor: "#999999",
                    lineColor: "#ccd6eb", lineWidth: 1, gridLineColor: "#e6e6e6", tickColor: "#ccd6eb"
                }, defaultYAxisOptions: { endOnTick: !0, tickPixelInterval: 72, showLastLabel: !0, labels: { x: -8 }, maxPadding: .05, minPadding: .05, startOnTick: !0, title: { rotation: 270, text: "Values" }, stackLabels: { enabled: !1, formatter: function () { return a.numberFormat(this.total, -1) }, style: { fontSize: "11px", fontWeight: "bold", color: "#000000", textOutline: "1px contrast" } }, gridLineWidth: 1, lineWidth: 0 }, defaultLeftAxisOptions: { labels: { x: -15 }, title: { rotation: 270 } },
                defaultRightAxisOptions: { labels: { x: 15 }, title: { rotation: 90 } }, defaultBottomAxisOptions: { labels: { autoRotation: [-45], x: 0 }, title: { rotation: 0 } }, defaultTopAxisOptions: { labels: { autoRotation: [-45], x: 0 }, title: { rotation: 0 } }, init: function (a, b) {
                    var g = b.isX; this.chart = a; this.horiz = a.inverted ? !g : g; this.isXAxis = g; this.coll = this.coll || (g ? "xAxis" : "yAxis"); this.opposite = b.opposite; this.side = b.side || (this.horiz ? this.opposite ? 0 : 2 : this.opposite ? 1 : 3); this.setOptions(b); var c = this.options, e = c.type; this.labelFormatter = c.labels.formatter ||
                        this.defaultLabelFormatter; this.userOptions = b; this.minPixelPadding = 0; this.reversed = c.reversed; this.visible = !1 !== c.visible; this.zoomEnabled = !1 !== c.zoomEnabled; this.hasNames = "category" === e || !0 === c.categories; this.categories = c.categories || this.hasNames; this.names = this.names || []; this.plotLinesAndBandsGroups = {}; this.isLog = "logarithmic" === e; this.isDatetimeAxis = "datetime" === e; this.positiveValuesOnly = this.isLog && !this.allowNegativeLog; this.isLinked = k(c.linkedTo); this.ticks = {}; this.labelEdge = []; this.minorTicks =
                            {}; this.plotLinesAndBands = []; this.alternateBands = {}; this.len = 0; this.minRange = this.userMinRange = c.minRange || c.maxZoom; this.range = c.range; this.offset = c.offset || 0; this.stacks = {}; this.oldStacks = {}; this.stacksTouched = 0; this.min = this.max = null; this.crosshair = E(c.crosshair, I(a.options.tooltip.crosshairs)[g ? 0 : 1], !1); var h; b = this.options.events; -1 === t(this, a.axes) && (g ? a.axes.splice(a.xAxis.length, 0, this) : a.axes.push(this), a[this.coll].push(this)); this.series = this.series || []; a.inverted && g && void 0 === this.reversed &&
                                (this.reversed = !0); this.removePlotLine = this.removePlotBand = this.removePlotBandOrLine; for (h in b) B(this, h, b[h]); this.lin2log = c.linearToLogConverter || this.lin2log; this.isLog && (this.val2lin = this.log2lin, this.lin2val = this.lin2log)
                }, setOptions: function (a) { this.options = x(this.defaultOptions, "yAxis" === this.coll && this.defaultYAxisOptions, [this.defaultTopAxisOptions, this.defaultRightAxisOptions, this.defaultBottomAxisOptions, this.defaultLeftAxisOptions][this.side], x(q[this.coll], a)) }, defaultLabelFormatter: function () {
                    var g =
                        this.axis, c = this.value, e = g.categories, h = this.dateTimeLabelFormat, m = q.lang, d = m.numericSymbols, m = m.numericSymbolMagnitude || 1E3, v = d && d.length, p, t = g.options.labels.format, g = g.isLog ? Math.abs(c) : g.tickInterval; if (t) p = b(t, this); else if (e) p = c; else if (h) p = a.dateFormat(h, c); else if (v && 1E3 <= g) for (; v-- && void 0 === p;) e = Math.pow(m, v + 1), g >= e && 0 === 10 * c % e && null !== d[v] && 0 !== c && (p = a.numberFormat(c / e, -1) + d[v]); void 0 === p && (p = 1E4 <= Math.abs(c) ? a.numberFormat(c, -1) : a.numberFormat(c, -1, void 0, "")); return p
                }, getSeriesExtremes: function () {
                    var a =
                        this, b = a.chart; a.hasVisibleSeries = !1; a.dataMin = a.dataMax = a.threshold = null; a.softThreshold = !a.isXAxis; a.buildStacks && a.buildStacks(); c(a.series, function (g) {
                            if (g.visible || !b.options.chart.ignoreHiddenSeries) {
                                var c = g.options, e = c.threshold, m; a.hasVisibleSeries = !0; a.positiveValuesOnly && 0 >= e && (e = null); if (a.isXAxis) c = g.xData, c.length && (g = G(c), w(g) || g instanceof Date || (c = h(c, function (a) { return w(a) }), g = G(c)), a.dataMin = Math.min(E(a.dataMin, c[0]), g), a.dataMax = Math.max(E(a.dataMax, c[0]), H(c))); else if (g.getExtremes(),
                                    m = g.dataMax, g = g.dataMin, k(g) && k(m) && (a.dataMin = Math.min(E(a.dataMin, g), g), a.dataMax = Math.max(E(a.dataMax, m), m)), k(e) && (a.threshold = e), !c.softThreshold || a.positiveValuesOnly) a.softThreshold = !1
                            }
                        })
                }, translate: function (a, b, c, e, h, m) {
                    var g = this.linkedParent || this, F = 1, p = 0, d = e ? g.oldTransA : g.transA; e = e ? g.oldMin : g.min; var t = g.minPixelPadding; h = (g.isOrdinal || g.isBroken || g.isLog && h) && g.lin2val; d || (d = g.transA); c && (F *= -1, p = g.len); g.reversed && (F *= -1, p -= F * (g.sector || g.len)); b ? (a = (a * F + p - t) / d + e, h && (a = g.lin2val(a))) :
                        (h && (a = g.val2lin(a)), a = F * (a - e) * d + p + F * t + (w(m) ? d * m : 0)); return a
                }, toPixels: function (a, b) { return this.translate(a, !1, !this.horiz, null, !0) + (b ? 0 : this.pos) }, toValue: function (a, b) { return this.translate(a - (b ? 0 : this.pos), !0, !this.horiz, null, !0) }, getPlotLinePath: function (a, b, c, e, h) {
                    var g = this.chart, m = this.left, F = this.top, p, d, t = c && g.oldChartHeight || g.chartHeight, f = c && g.oldChartWidth || g.chartWidth, n; p = this.transB; var y = function (a, b, g) { if (a < b || a > g) e ? a = Math.min(Math.max(b, a), g) : n = !0; return a }; h = E(h, this.translate(a,
                        null, null, c)); a = c = Math.round(h + p); p = d = Math.round(t - h - p); w(h) ? this.horiz ? (p = F, d = t - this.bottom, a = c = y(a, m, m + this.width)) : (a = m, c = f - this.right, p = d = y(p, F, F + this.height)) : n = !0; return n && !e ? null : g.renderer.crispLine(["M", a, p, "L", c, d], b || 1)
                }, getLinearTickPositions: function (a, b, c) { var g, e = l(Math.floor(b / a) * a); c = l(Math.ceil(c / a) * a); var h = []; if (this.single) return [b]; for (b = e; b <= c;) { h.push(b); b = l(b + a); if (b === g) break; g = b } return h }, getMinorTickPositions: function () {
                    var a = this, b = a.options, e = a.tickPositions, h = a.minorTickInterval,
                        m = [], p = a.pointRangePadding || 0, v = a.min - p, p = a.max + p, d = p - v; if (d && d / h < a.len / 3) if (a.isLog) c(this.paddedTicks, function (b, g, c) { g && m.push.apply(m, a.getLogTickPositions(h, c[g - 1], c[g], !0)) }); else if (a.isDatetimeAxis && "auto" === b.minorTickInterval) m = m.concat(a.getTimeTicks(a.normalizeTimeTickInterval(h), v, p, b.startOfWeek)); else for (b = v + (e[0] - v) % h; b <= p && b !== m[0]; b += h) m.push(b); 0 !== m.length && a.trimTicks(m); return m
                }, adjustForMinRange: function () {
                    var a = this.options, b = this.min, e = this.max, h, m = this.dataMax - this.dataMin >=
                        this.minRange, p, v, d, t, f, n; this.isXAxis && void 0 === this.minRange && !this.isLog && (k(a.min) || k(a.max) ? this.minRange = null : (c(this.series, function (a) { t = a.xData; for (v = f = a.xIncrement ? 1 : t.length - 1; 0 < v; v--) if (d = t[v] - t[v - 1], void 0 === p || d < p) p = d }), this.minRange = Math.min(5 * p, this.dataMax - this.dataMin))); e - b < this.minRange && (n = this.minRange, h = (n - e + b) / 2, h = [b - h, E(a.min, b - h)], m && (h[2] = this.isLog ? this.log2lin(this.dataMin) : this.dataMin), b = H(h), e = [b + n, E(a.max, b + n)], m && (e[2] = this.isLog ? this.log2lin(this.dataMax) : this.dataMax),
                            e = G(e), e - b < n && (h[0] = e - n, h[1] = E(a.min, e - n), b = H(h))); this.min = b; this.max = e
                }, getClosest: function () { var a; this.categories ? a = 1 : c(this.series, function (b) { var g = b.closestPointRange, c = b.visible || !b.chart.options.chart.ignoreHiddenSeries; !b.noSharedTooltip && k(g) && c && (a = k(a) ? Math.min(a, g) : g) }); return a }, nameToX: function (a) {
                    var b = D(this.categories), g = b ? this.categories : this.names, c = a.options.x, e; a.series.requireSorting = !1; k(c) || (c = !1 === this.options.uniqueNames ? a.series.autoIncrement() : t(a.name, g)); -1 === c ? b ||
                        (e = g.length) : e = c; void 0 !== e && (this.names[e] = a.name); return e
                }, updateNames: function () { var a = this; 0 < this.names.length && (this.names.length = 0, this.minRange = void 0, c(this.series || [], function (b) { b.xIncrement = null; if (!b.points || b.isDirtyData) b.processData(), b.generatePoints(); c(b.points, function (g, c) { var e; g.options && (e = a.nameToX(g), void 0 !== e && e !== g.x && (g.x = e, b.xData[c] = e)) }) })) }, setAxisTranslation: function (a) {
                    var b = this, g = b.max - b.min, h = b.axisPointRange || 0, m, p = 0, v = 0, d = b.linkedParent, t = !!b.categories, f =
                        b.transA, n = b.isXAxis; if (n || t || h) m = b.getClosest(), d ? (p = d.minPointOffset, v = d.pointRangePadding) : c(b.series, function (a) { var g = t ? 1 : n ? E(a.options.pointRange, m, 0) : b.axisPointRange || 0; a = a.options.pointPlacement; h = Math.max(h, g); b.single || (p = Math.max(p, e(a) ? 0 : g / 2), v = Math.max(v, "on" === a ? 0 : g)) }), d = b.ordinalSlope && m ? b.ordinalSlope / m : 1, b.minPointOffset = p *= d, b.pointRangePadding = v *= d, b.pointRange = Math.min(h, g), n && (b.closestPointRange = m); a && (b.oldTransA = f); b.translationSlope = b.transA = f = b.options.staticScale || b.len /
                            (g + v || 1); b.transB = b.horiz ? b.left : b.bottom; b.minPixelPadding = f * p
                }, minFromRange: function () { return this.max - this.range }, setTickInterval: function (b) {
                    var g = this, e = g.chart, h = g.options, m = g.isLog, d = g.log2lin, v = g.isDatetimeAxis, t = g.isXAxis, f = g.isLinked, n = h.maxPadding, y = h.minPadding, x = h.tickInterval, D = h.tickPixelInterval, I = g.categories, q = g.threshold, u = g.softThreshold, r, K, J, A; v || I || f || this.getTickAmount(); J = E(g.userMin, h.min); A = E(g.userMax, h.max); f ? (g.linkedParent = e[g.coll][h.linkedTo], e = g.linkedParent.getExtremes(),
                        g.min = E(e.min, e.dataMin), g.max = E(e.max, e.dataMax), h.type !== g.linkedParent.options.type && a.error(11, 1)) : (!u && k(q) && (g.dataMin >= q ? (r = q, y = 0) : g.dataMax <= q && (K = q, n = 0)), g.min = E(J, r, g.dataMin), g.max = E(A, K, g.dataMax)); m && (g.positiveValuesOnly && !b && 0 >= Math.min(g.min, E(g.dataMin, g.min)) && a.error(10, 1), g.min = l(d(g.min), 15), g.max = l(d(g.max), 15)); g.range && k(g.max) && (g.userMin = g.min = J = Math.max(g.min, g.minFromRange()), g.userMax = A = g.max, g.range = null); z(g, "foundExtremes"); g.beforePadding && g.beforePadding(); g.adjustForMinRange();
                    !(I || g.axisPointRange || g.usePercentage || f) && k(g.min) && k(g.max) && (d = g.max - g.min) && (!k(J) && y && (g.min -= d * y), !k(A) && n && (g.max += d * n)); w(h.softMin) && (g.min = Math.min(g.min, h.softMin)); w(h.softMax) && (g.max = Math.max(g.max, h.softMax)); w(h.floor) && (g.min = Math.max(g.min, h.floor)); w(h.ceiling) && (g.max = Math.min(g.max, h.ceiling)); u && k(g.dataMin) && (q = q || 0, !k(J) && g.min < q && g.dataMin >= q ? g.min = q : !k(A) && g.max > q && g.dataMax <= q && (g.max = q)); g.tickInterval = g.min === g.max || void 0 === g.min || void 0 === g.max ? 1 : f && !x && D === g.linkedParent.options.tickPixelInterval ?
                        x = g.linkedParent.tickInterval : E(x, this.tickAmount ? (g.max - g.min) / Math.max(this.tickAmount - 1, 1) : void 0, I ? 1 : (g.max - g.min) * D / Math.max(g.len, D)); t && !b && c(g.series, function (a) { a.processData(g.min !== g.oldMin || g.max !== g.oldMax) }); g.setAxisTranslation(!0); g.beforeSetTickPositions && g.beforeSetTickPositions(); g.postProcessTickInterval && (g.tickInterval = g.postProcessTickInterval(g.tickInterval)); g.pointRange && !x && (g.tickInterval = Math.max(g.pointRange, g.tickInterval)); b = E(h.minTickInterval, g.isDatetimeAxis && g.closestPointRange);
                    !x && g.tickInterval < b && (g.tickInterval = b); v || m || x || (g.tickInterval = C(g.tickInterval, null, p(g.tickInterval), E(h.allowDecimals, !(.5 < g.tickInterval && 5 > g.tickInterval && 1E3 < g.max && 9999 > g.max)), !!this.tickAmount)); this.tickAmount || (g.tickInterval = g.unsquish()); this.setTickPositions()
                }, setTickPositions: function () {
                    var a = this.options, b, c = a.tickPositions, e = a.tickPositioner, h = a.startOnTick, m = a.endOnTick; this.tickmarkOffset = this.categories && "between" === a.tickmarkPlacement && 1 === this.tickInterval ? .5 : 0; this.minorTickInterval =
                        "auto" === a.minorTickInterval && this.tickInterval ? this.tickInterval / 5 : a.minorTickInterval; this.single = this.min === this.max && k(this.min) && !this.tickAmount && !1 !== a.allowDecimals; this.tickPositions = b = c && c.slice(); !b && (b = this.isDatetimeAxis ? this.getTimeTicks(this.normalizeTimeTickInterval(this.tickInterval, a.units), this.min, this.max, a.startOfWeek, this.ordinalPositions, this.closestPointRange, !0) : this.isLog ? this.getLogTickPositions(this.tickInterval, this.min, this.max) : this.getLinearTickPositions(this.tickInterval,
                            this.min, this.max), b.length > this.len && (b = [b[0], b.pop()]), this.tickPositions = b, e && (e = e.apply(this, [this.min, this.max]))) && (this.tickPositions = b = e); this.paddedTicks = b.slice(0); this.trimTicks(b, h, m); this.isLinked || (this.single && (this.min -= .5, this.max += .5), c || e || this.adjustTickAmount())
                }, trimTicks: function (a, b, c) {
                    var g = a[0], e = a[a.length - 1], h = this.minPointOffset || 0; if (!this.isLinked) {
                        if (b && -Infinity !== g) this.min = g; else for (; this.min - h > a[0];) a.shift(); if (c) this.max = e; else for (; this.max + h < a[a.length - 1];) a.pop();
                        0 === a.length && k(g) && a.push((e + g) / 2)
                    }
                }, alignToOthers: function () { var a = {}, b, e = this.options; !1 === this.chart.options.chart.alignTicks || !1 === e.alignTicks || this.isLog || c(this.chart[this.coll], function (g) { var c = g.options, c = [g.horiz ? c.left : c.top, c.width, c.height, c.pane].join(); g.series.length && (a[c] ? b = !0 : a[c] = 1) }); return b }, getTickAmount: function () {
                    var a = this.options, b = a.tickAmount, c = a.tickPixelInterval; !k(a.tickInterval) && this.len < c && !this.isRadial && !this.isLog && a.startOnTick && a.endOnTick && (b = 2); !b && this.alignToOthers() &&
                        (b = Math.ceil(this.len / c) + 1); 4 > b && (this.finalTickAmt = b, b = 5); this.tickAmount = b
                }, adjustTickAmount: function () { var a = this.tickInterval, b = this.tickPositions, c = this.tickAmount, e = this.finalTickAmt, h = b && b.length; if (h < c) { for (; b.length < c;) b.push(l(b[b.length - 1] + a)); this.transA *= (h - 1) / (c - 1); this.max = b[b.length - 1] } else h > c && (this.tickInterval *= 2, this.setTickPositions()); if (k(e)) { for (a = c = b.length; a--;) (3 === e && 1 === a % 2 || 2 >= e && 0 < a && a < c - 1) && b.splice(a, 1); this.finalTickAmt = void 0 } }, setScale: function () {
                    var a, b; this.oldMin =
                        this.min; this.oldMax = this.max; this.oldAxisLength = this.len; this.setAxisSize(); b = this.len !== this.oldAxisLength; c(this.series, function (b) { if (b.isDirtyData || b.isDirty || b.xAxis.isDirty) a = !0 }); b || a || this.isLinked || this.forceRedraw || this.userMin !== this.oldUserMin || this.userMax !== this.oldUserMax || this.alignToOthers() ? (this.resetStacks && this.resetStacks(), this.forceRedraw = !1, this.getSeriesExtremes(), this.setTickInterval(), this.oldUserMin = this.userMin, this.oldUserMax = this.userMax, this.isDirty || (this.isDirty =
                            b || this.min !== this.oldMin || this.max !== this.oldMax)) : this.cleanStacks && this.cleanStacks()
                }, setExtremes: function (a, b, e, h, m) { var g = this, p = g.chart; e = E(e, !0); c(g.series, function (a) { delete a.kdTree }); m = n(m, { min: a, max: b }); z(g, "setExtremes", m, function () { g.userMin = a; g.userMax = b; g.eventArgs = m; e && p.redraw(h) }) }, zoom: function (a, b) {
                    var g = this.dataMin, c = this.dataMax, e = this.options, h = Math.min(g, E(e.min, g)), e = Math.max(c, E(e.max, c)); if (a !== this.min || b !== this.max) this.allowZoomOutside || (k(g) && (a < h && (a = h), a > e && (a = e)),
                        k(c) && (b < h && (b = h), b > e && (b = e))), this.displayBtn = void 0 !== a || void 0 !== b, this.setExtremes(a, b, !1, void 0, { trigger: "zoom" }); return !0
                }, setAxisSize: function () {
                    var a = this.chart, b = this.options, c = b.offsets || [0, 0, 0, 0], e = this.horiz, h = E(b.width, a.plotWidth - c[3] + c[1]), m = E(b.height, a.plotHeight - c[0] + c[2]), p = E(b.top, a.plotTop + c[0]), b = E(b.left, a.plotLeft + c[3]), c = /%$/; c.test(m) && (m = Math.round(parseFloat(m) / 100 * a.plotHeight)); c.test(p) && (p = Math.round(parseFloat(p) / 100 * a.plotHeight + a.plotTop)); this.left = b; this.top = p;
                    this.width = h; this.height = m; this.bottom = a.chartHeight - m - p; this.right = a.chartWidth - h - b; this.len = Math.max(e ? h : m, 0); this.pos = e ? b : p
                }, getExtremes: function () { var a = this.isLog, b = this.lin2log; return { min: a ? l(b(this.min)) : this.min, max: a ? l(b(this.max)) : this.max, dataMin: this.dataMin, dataMax: this.dataMax, userMin: this.userMin, userMax: this.userMax } }, getThreshold: function (a) {
                    var b = this.isLog, g = this.lin2log, c = b ? g(this.min) : this.min, b = b ? g(this.max) : this.max; null === a ? a = c : c > a ? a = c : b < a && (a = b); return this.translate(a, 0,
                        1, 0, 1)
                }, autoLabelAlign: function (a) { a = (E(a, 0) - 90 * this.side + 720) % 360; return 15 < a && 165 > a ? "right" : 195 < a && 345 > a ? "left" : "center" }, tickSize: function (a) { var b = this.options, g = b[a + "Length"], c = E(b[a + "Width"], "tick" === a && this.isXAxis ? 1 : 0); if (c && g) return "inside" === b[a + "Position"] && (g = -g), [g, c] }, labelMetrics: function () { return this.chart.renderer.fontMetrics(this.options.labels.style && this.options.labels.style.fontSize, this.ticks[0] && this.ticks[0].label) }, unsquish: function () {
                    var a = this.options.labels, b = this.horiz,
                        e = this.tickInterval, h = e, m = this.len / (((this.categories ? 1 : 0) + this.max - this.min) / e), p, d = a.rotation, t = this.labelMetrics(), f, n = Number.MAX_VALUE, y, w = function (a) { a /= m || 1; a = 1 < a ? Math.ceil(a) : 1; return a * e }; b ? (y = !a.staggerLines && !a.step && (k(d) ? [d] : m < E(a.autoRotationLimit, 80) && a.autoRotation)) && c(y, function (a) { var b; if (a === d || a && -90 <= a && 90 >= a) f = w(Math.abs(t.h / Math.sin(u * a))), b = f + Math.abs(a / 360), b < n && (n = b, p = a, h = f) }) : a.step || (h = w(t.h)); this.autoRotation = y; this.labelRotation = E(p, d); return h
                }, getSlotWidth: function () {
                    var a =
                        this.chart, b = this.horiz, c = this.options.labels, e = Math.max(this.tickPositions.length - (this.categories ? 0 : 1), 1), h = a.margin[3]; return b && 2 > (c.step || 0) && !c.rotation && (this.staggerLines || 1) * this.len / e || !b && (h && h - a.spacing[3] || .33 * a.chartWidth)
                }, renderUnsquish: function () {
                    var a = this.chart, b = a.renderer, h = this.tickPositions, m = this.ticks, p = this.options.labels, d = this.horiz, v = this.getSlotWidth(), t = Math.max(1, Math.round(v - 2 * (p.padding || 5))), f = {}, n = this.labelMetrics(), y = p.style && p.style.textOverflow, k, w = 0, D, l; e(p.rotation) ||
                        (f.rotation = p.rotation || 0); c(h, function (a) { (a = m[a]) && a.labelLength > w && (w = a.labelLength) }); this.maxLabelLength = w; if (this.autoRotation) w > t && w > n.h ? f.rotation = this.labelRotation : this.labelRotation = 0; else if (v && (k = { width: t + "px" }, !y)) for (k.textOverflow = "clip", D = h.length; !d && D--;) if (l = h[D], t = m[l].label) t.styles && "ellipsis" === t.styles.textOverflow ? t.css({ textOverflow: "clip" }) : m[l].labelLength > v && t.css({ width: v + "px" }), t.getBBox().height > this.len / h.length - (n.h - n.f) && (t.specCss = { textOverflow: "ellipsis" }); f.rotation &&
                            (k = { width: (w > .5 * a.chartHeight ? .33 * a.chartHeight : a.chartHeight) + "px" }, y || (k.textOverflow = "ellipsis")); if (this.labelAlign = p.align || this.autoLabelAlign(this.labelRotation)) f.align = this.labelAlign; c(h, function (a) { var b = (a = m[a]) && a.label; b && (b.attr(f), k && b.css(x(k, b.specCss)), delete b.specCss, a.rotation = f.rotation) }); this.tickRotCorr = b.rotCorr(n.b, this.labelRotation || 0, 0 !== this.side)
                }, hasData: function () { return this.hasVisibleSeries || k(this.min) && k(this.max) && !!this.tickPositions }, addTitle: function (a) {
                    var b =
                        this.chart.renderer, c = this.horiz, g = this.opposite, e = this.options.title, h; this.axisTitle || ((h = e.textAlign) || (h = (c ? { low: "left", middle: "center", high: "right" } : { low: g ? "right" : "left", middle: "center", high: g ? "left" : "right" })[e.align]), this.axisTitle = b.text(e.text, 0, 0, e.useHTML).attr({ zIndex: 7, rotation: e.rotation || 0, align: h }).addClass("highcharts-axis-title").css(e.style).add(this.axisGroup), this.axisTitle.isNew = !0); this.axisTitle[a ? "show" : "hide"](!0)
                }, generateTick: function (a) {
                    var b = this.ticks; b[a] ? b[a].addLabel() :
                        b[a] = new J(this, a)
                }, getOffset: function () {
                    var a = this, b = a.chart, e = b.renderer, h = a.options, m = a.tickPositions, p = a.ticks, d = a.horiz, t = a.side, f = b.inverted ? [1, 0, 3, 2][t] : t, n, y, w = 0, x, D = 0, l = h.title, C = h.labels, q = 0, I = b.axisOffset, b = b.clipOffset, u = [-1, 1, 1, -1][t], z, r = h.className, K = a.axisParent, J = this.tickSize("tick"); n = a.hasData(); a.showAxis = y = n || E(h.showEmpty, !0); a.staggerLines = a.horiz && C.staggerLines; a.axisGroup || (a.gridGroup = e.g("grid").attr({ zIndex: h.gridZIndex || 1 }).addClass("highcharts-" + this.coll.toLowerCase() +
                        "-grid " + (r || "")).add(K), a.axisGroup = e.g("axis").attr({ zIndex: h.zIndex || 2 }).addClass("highcharts-" + this.coll.toLowerCase() + " " + (r || "")).add(K), a.labelGroup = e.g("axis-labels").attr({ zIndex: C.zIndex || 7 }).addClass("highcharts-" + a.coll.toLowerCase() + "-labels " + (r || "")).add(K)); if (n || a.isLinked) c(m, function (b, c) { a.generateTick(b, c) }), a.renderUnsquish(), !1 === C.reserveSpace || 0 !== t && 2 !== t && { 1: "left", 3: "right" }[t] !== a.labelAlign && "center" !== a.labelAlign || c(m, function (a) { q = Math.max(p[a].getLabelSize(), q) }),
                            a.staggerLines && (q *= a.staggerLines, a.labelOffset = q * (a.opposite ? -1 : 1)); else for (z in p) p[z].destroy(), delete p[z]; l && l.text && !1 !== l.enabled && (a.addTitle(y), y && (w = a.axisTitle.getBBox()[d ? "height" : "width"], x = l.offset, D = k(x) ? 0 : E(l.margin, d ? 5 : 10))); a.renderLine(); a.offset = u * E(h.offset, I[t]); a.tickRotCorr = a.tickRotCorr || { x: 0, y: 0 }; e = 0 === t ? -a.labelMetrics().h : 2 === t ? a.tickRotCorr.y : 0; D = Math.abs(q) + D; q && (D = D - e + u * (d ? E(C.y, a.tickRotCorr.y + 8 * u) : C.x)); a.axisTitleMargin = E(x, D); I[t] = Math.max(I[t], a.axisTitleMargin +
                                w + u * a.offset, D, n && m.length && J ? J[0] + u * a.offset : 0); h = h.offset ? 0 : 2 * Math.floor(a.axisLine.strokeWidth() / 2); b[f] = Math.max(b[f], h)
                }, getLinePath: function (a) { var b = this.chart, c = this.opposite, g = this.offset, e = this.horiz, h = this.left + (c ? this.width : 0) + g, g = b.chartHeight - this.bottom - (c ? this.height : 0) + g; c && (a *= -1); return b.renderer.crispLine(["M", e ? this.left : h, e ? g : this.top, "L", e ? b.chartWidth - this.right : h, e ? g : b.chartHeight - this.bottom], a) }, renderLine: function () {
                    this.axisLine || (this.axisLine = this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),
                        this.axisLine.attr({ stroke: this.options.lineColor, "stroke-width": this.options.lineWidth, zIndex: 7 }))
                }, getTitlePosition: function () {
                    var a = this.horiz, b = this.left, c = this.top, e = this.len, h = this.options.title, m = a ? b : c, p = this.opposite, d = this.offset, t = h.x || 0, f = h.y || 0, n = this.chart.renderer.fontMetrics(h.style && h.style.fontSize, this.axisTitle).f, e = { low: m + (a ? 0 : e), middle: m + e / 2, high: m + (a ? e : 0) }[h.align], b = (a ? c + this.height : b) + (a ? 1 : -1) * (p ? -1 : 1) * this.axisTitleMargin + (2 === this.side ? n : 0); return {
                        x: a ? e + t : b + (p ? this.width :
                            0) + d + t, y: a ? b + f - (p ? this.height : 0) + d : e + f
                    }
                }, renderMinorTick: function (a) { var b = this.chart.hasRendered && w(this.oldMin), c = this.minorTicks; c[a] || (c[a] = new J(this, a, "minor")); b && c[a].isNew && c[a].render(null, !0); c[a].render(null, !1, 1) }, renderTick: function (a, b) { var c = this.isLinked, g = this.ticks, e = this.chart.hasRendered && w(this.oldMin); if (!c || a >= this.min && a <= this.max) g[a] || (g[a] = new J(this, a)), e && g[a].isNew && g[a].render(b, !0, .1), g[a].render(b) }, render: function () {
                    var a = this, b = a.chart, e = a.options, h = a.isLog, p = a.lin2log,
                        d = a.isLinked, t = a.tickPositions, f = a.axisTitle, n = a.ticks, y = a.minorTicks, k = a.alternateBands, w = e.stackLabels, x = e.alternateGridColor, D = a.tickmarkOffset, l = a.axisLine, C = a.showAxis, q = A(b.renderer.globalAnimation), I, E; a.labelEdge.length = 0; a.overlap = !1; c([n, y, k], function (a) { for (var b in a) a[b].isActive = !1 }); if (a.hasData() || d) a.minorTickInterval && !a.categories && c(a.getMinorTickPositions(), function (b) { a.renderMinorTick(b) }), t.length && (c(t, function (b, c) { a.renderTick(b, c) }), D && (0 === a.min || a.single) && (n[-1] || (n[-1] =
                            new J(a, -1, null, !0)), n[-1].render(-1))), x && c(t, function (c, e) { E = void 0 !== t[e + 1] ? t[e + 1] + D : a.max - D; 0 === e % 2 && c < a.max && E <= a.max + (b.polar ? -D : D) && (k[c] || (k[c] = new m(a)), I = c + D, k[c].options = { from: h ? p(I) : I, to: h ? p(E) : E, color: x }, k[c].render(), k[c].isActive = !0) }), a._addedPlotLB || (c((e.plotLines || []).concat(e.plotBands || []), function (b) { a.addPlotBandOrLine(b) }), a._addedPlotLB = !0); c([n, y, k], function (a) {
                                var c, e, g = [], h = q.duration; for (c in a) a[c].isActive || (a[c].render(c, !1, 0), a[c].isActive = !1, g.push(c)); K(function () {
                                    for (e =
                                        g.length; e--;) a[g[e]] && !a[g[e]].isActive && (a[g[e]].destroy(), delete a[g[e]])
                                }, a !== k && b.hasRendered && h ? h : 0)
                            }); l && (l[l.isPlaced ? "animate" : "attr"]({ d: this.getLinePath(l.strokeWidth()) }), l.isPlaced = !0, l[C ? "show" : "hide"](!0)); f && C && (f[f.isNew ? "attr" : "animate"](a.getTitlePosition()), f.isNew = !1); w && w.enabled && a.renderStackTotals(); a.isDirty = !1
                }, redraw: function () { this.visible && (this.render(), c(this.plotLinesAndBands, function (a) { a.render() })); c(this.series, function (a) { a.isDirty = !0 }) }, keepProps: "extKey hcEvents names series userMax userMin".split(" "),
                destroy: function (a) { var b = this, e = b.stacks, g, h = b.plotLinesAndBands, m, p; a || y(b); for (g in e) d(e[g]), e[g] = null; c([b.ticks, b.minorTicks, b.alternateBands], function (a) { d(a) }); if (h) for (a = h.length; a--;) h[a].destroy(); c("stackTotalGroup axisLine axisTitle axisGroup gridGroup labelGroup cross".split(" "), function (a) { b[a] && (b[a] = b[a].destroy()) }); for (m in b.plotLinesAndBandsGroups) b.plotLinesAndBandsGroups[m] = b.plotLinesAndBandsGroups[m].destroy(); for (p in b) b.hasOwnProperty(p) && -1 === t(p, b.keepProps) && delete b[p] },
                drawCrosshair: function (a, b) {
                    var c, e = this.crosshair, g = E(e.snap, !0), h, m = this.cross; a || (a = this.cross && this.cross.e); this.crosshair && !1 !== (k(b) || !g) ? (g ? k(b) && (h = this.isXAxis ? b.plotX : this.len - b.plotY) : h = a && (this.horiz ? a.chartX - this.pos : this.len - a.chartY + this.pos), k(h) && (c = this.getPlotLinePath(b && (this.isXAxis ? b.x : E(b.stackY, b.y)), null, null, null, h) || null), k(c) ? (b = this.categories && !this.isRadial, m || (this.cross = m = this.chart.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-" + (b ? "category " :
                        "thin ") + e.className).attr({ zIndex: E(e.zIndex, 2) }).add(), m.attr({ stroke: e.color || (b ? f("#ccd6eb").setOpacity(.25).get() : "#cccccc"), "stroke-width": E(e.width, 1) }), e.dashStyle && m.attr({ dashstyle: e.dashStyle })), m.show().attr({ d: c }), b && !e.width && m.attr({ "stroke-width": this.transA }), this.cross.e = a) : this.hideCrosshair()) : this.hideCrosshair()
                }, hideCrosshair: function () { this.cross && this.cross.hide() }
            }; n(a.Axis.prototype, r)
    })(L); (function (a) {
        var B = a.Axis, A = a.Date, H = a.dateFormat, G = a.defaultOptions, r = a.defined,
            f = a.each, l = a.extend, q = a.getMagnitude, k = a.getTZOffset, u = a.normalizeTickInterval, d = a.pick, c = a.timeUnits; B.prototype.getTimeTicks = function (a, q, b, p) {
                var h = [], t = {}, n = G.global.useUTC, w, e = new A(q - Math.abs(k(q))), x = A.hcMakeTime, C = a.unitRange, E = a.count, m; if (r(q)) {
                    e[A.hcSetMilliseconds](C >= c.second ? 0 : E * Math.floor(e.getMilliseconds() / E)); if (C >= c.second) e[A.hcSetSeconds](C >= c.minute ? 0 : E * Math.floor(e.getSeconds() / E)); if (C >= c.minute) e[A.hcSetMinutes](C >= c.hour ? 0 : E * Math.floor(e[A.hcGetMinutes]() / E)); if (C >= c.hour) e[A.hcSetHours](C >=
                        c.day ? 0 : E * Math.floor(e[A.hcGetHours]() / E)); if (C >= c.day) e[A.hcSetDate](C >= c.month ? 1 : E * Math.floor(e[A.hcGetDate]() / E)); C >= c.month && (e[A.hcSetMonth](C >= c.year ? 0 : E * Math.floor(e[A.hcGetMonth]() / E)), w = e[A.hcGetFullYear]()); if (C >= c.year) e[A.hcSetFullYear](w - w % E); if (C === c.week) e[A.hcSetDate](e[A.hcGetDate]() - e[A.hcGetDay]() + d(p, 1)); w = e[A.hcGetFullYear](); p = e[A.hcGetMonth](); var y = e[A.hcGetDate](), I = e[A.hcGetHours](); if (A.hcTimezoneOffset || A.hcGetTimezoneOffset) m = (!n || !!A.hcGetTimezoneOffset) && (b - q > 4 * c.month ||
                            k(q) !== k(b)), e = e.getTime(), e = new A(e + k(e)); n = e.getTime(); for (q = 1; n < b;) h.push(n), n = C === c.year ? x(w + q * E, 0) : C === c.month ? x(w, p + q * E) : !m || C !== c.day && C !== c.week ? m && C === c.hour ? x(w, p, y, I + q * E) : n + C * E : x(w, p, y + q * E * (C === c.day ? 1 : 7)), q++; h.push(n); C <= c.hour && 1E4 > h.length && f(h, function (a) { 0 === a % 18E5 && "000000000" === H("%H%M%S%L", a) && (t[a] = "day") })
                } h.info = l(a, { higherRanks: t, totalRange: C * E }); return h
            }; B.prototype.normalizeTimeTickInterval = function (a, d) {
                var b = d || [["millisecond", [1, 2, 5, 10, 20, 25, 50, 100, 200, 500]], ["second",
                    [1, 2, 5, 10, 15, 30]], ["minute", [1, 2, 5, 10, 15, 30]], ["hour", [1, 2, 3, 4, 6, 8, 12]], ["day", [1, 2]], ["week", [1, 2]], ["month", [1, 2, 3, 4, 6]], ["year", null]]; d = b[b.length - 1]; var p = c[d[0]], h = d[1], t; for (t = 0; t < b.length && !(d = b[t], p = c[d[0]], h = d[1], b[t + 1] && a <= (p * h[h.length - 1] + c[b[t + 1][0]]) / 2); t++); p === c.year && a < 5 * p && (h = [1, 2, 5]); a = u(a / p, h, "year" === d[0] ? Math.max(q(a / p), 1) : 1); return { unitRange: p, count: a, unitName: d[0] }
            }
    })(L); (function (a) {
        var B = a.Axis, A = a.getMagnitude, H = a.map, G = a.normalizeTickInterval, r = a.pick; B.prototype.getLogTickPositions =
            function (a, l, q, k) {
                var f = this.options, d = this.len, c = this.lin2log, n = this.log2lin, z = []; k || (this._minorAutoInterval = null); if (.5 <= a) a = Math.round(a), z = this.getLinearTickPositions(a, l, q); else if (.08 <= a) for (var d = Math.floor(l), b, p, h, t, D, f = .3 < a ? [1, 2, 4] : .15 < a ? [1, 2, 4, 6, 8] : [1, 2, 3, 4, 5, 6, 7, 8, 9]; d < q + 1 && !D; d++) for (p = f.length, b = 0; b < p && !D; b++) h = n(c(d) * f[b]), h > l && (!k || t <= q) && void 0 !== t && z.push(t), t > q && (D = !0), t = h; else l = c(l), q = c(q), a = f[k ? "minorTickInterval" : "tickInterval"], a = r("auto" === a ? null : a, this._minorAutoInterval,
                    f.tickPixelInterval / (k ? 5 : 1) * (q - l) / ((k ? d / this.tickPositions.length : d) || 1)), a = G(a, null, A(a)), z = H(this.getLinearTickPositions(a, l, q), n), k || (this._minorAutoInterval = a / 5); k || (this.tickInterval = a); return z
            }; B.prototype.log2lin = function (a) { return Math.log(a) / Math.LN10 }; B.prototype.lin2log = function (a) { return Math.pow(10, a) }
    })(L); (function (a) {
        var B = a.dateFormat, A = a.each, H = a.extend, G = a.format, r = a.isNumber, f = a.map, l = a.merge, q = a.pick, k = a.splat, u = a.syncTimeout, d = a.timeUnits; a.Tooltip = function () {
            this.init.apply(this,
                arguments)
        }; a.Tooltip.prototype = {
            init: function (a, d) { this.chart = a; this.options = d; this.crosshairs = []; this.now = { x: 0, y: 0 }; this.isHidden = !0; this.split = d.split && !a.inverted; this.shared = d.shared || this.split }, cleanSplit: function (a) { A(this.chart.series, function (c) { var d = c && c.tt; d && (!d.isActive || a ? c.tt = d.destroy() : d.isActive = !1) }) }, getLabel: function () {
                var a = this.chart.renderer, d = this.options; this.label || (this.split ? this.label = a.g("tooltip") : (this.label = a.label("", 0, 0, d.shape || "callout", null, null, d.useHTML,
                    null, "tooltip").attr({ padding: d.padding, r: d.borderRadius }), this.label.attr({ fill: d.backgroundColor, "stroke-width": d.borderWidth }).css(d.style).shadow(d.shadow)), this.label.attr({ zIndex: 8 }).add()); return this.label
            }, update: function (a) { this.destroy(); this.init(this.chart, l(!0, this.options, a)) }, destroy: function () { this.label && (this.label = this.label.destroy()); this.split && this.tt && (this.cleanSplit(this.chart, !0), this.tt = this.tt.destroy()); clearTimeout(this.hideTimer); clearTimeout(this.tooltipTimeout) },
            move: function (a, d, f, b) { var c = this, h = c.now, t = !1 !== c.options.animation && !c.isHidden && (1 < Math.abs(a - h.x) || 1 < Math.abs(d - h.y)), n = c.followPointer || 1 < c.len; H(h, { x: t ? (2 * h.x + a) / 3 : a, y: t ? (h.y + d) / 2 : d, anchorX: n ? void 0 : t ? (2 * h.anchorX + f) / 3 : f, anchorY: n ? void 0 : t ? (h.anchorY + b) / 2 : b }); c.getLabel().attr(h); t && (clearTimeout(this.tooltipTimeout), this.tooltipTimeout = setTimeout(function () { c && c.move(a, d, f, b) }, 32)) }, hide: function (a) {
                var c = this; clearTimeout(this.hideTimer); a = q(a, this.options.hideDelay, 500); this.isHidden || (this.hideTimer =
                    u(function () { c.getLabel()[a ? "fadeOut" : "hide"](); c.isHidden = !0 }, a))
            }, getAnchor: function (a, d) {
                var c, b = this.chart, p = b.inverted, h = b.plotTop, t = b.plotLeft, n = 0, w = 0, e, x; a = k(a); c = a[0].tooltipPos; this.followPointer && d && (void 0 === d.chartX && (d = b.pointer.normalize(d)), c = [d.chartX - b.plotLeft, d.chartY - h]); c || (A(a, function (a) { e = a.series.yAxis; x = a.series.xAxis; n += a.plotX + (!p && x ? x.left - t : 0); w += (a.plotLow ? (a.plotLow + a.plotHigh) / 2 : a.plotY) + (!p && e ? e.top - h : 0) }), n /= a.length, w /= a.length, c = [p ? b.plotWidth - w : n, this.shared &&
                    !p && 1 < a.length && d ? d.chartY - h : p ? b.plotHeight - n : w]); return f(c, Math.round)
            }, getPosition: function (a, d, f) {
                var b = this.chart, c = this.distance, h = {}, t = f.h || 0, n, k = ["y", b.chartHeight, d, f.plotY + b.plotTop, b.plotTop, b.plotTop + b.plotHeight], e = ["x", b.chartWidth, a, f.plotX + b.plotLeft, b.plotLeft, b.plotLeft + b.plotWidth], x = !this.followPointer && q(f.ttBelow, !b.inverted === !!f.negative), l = function (a, b, e, g, m, d) {
                    var p = e < g - c, f = g + c + e < b, n = g - c - e; g += c; if (x && f) h[a] = g; else if (!x && p) h[a] = n; else if (p) h[a] = Math.min(d - e, 0 > n - t ? n : n - t);
                    else if (f) h[a] = Math.max(m, g + t + e > b ? g : g + t); else return !1
                }, E = function (a, b, e, g) { var m; g < c || g > b - c ? m = !1 : h[a] = g < e / 2 ? 1 : g > b - e / 2 ? b - e - 2 : g - e / 2; return m }, m = function (a) { var b = k; k = e; e = b; n = a }, y = function () { !1 !== l.apply(0, k) ? !1 !== E.apply(0, e) || n || (m(!0), y()) : n ? h.x = h.y = 0 : (m(!0), y()) }; (b.inverted || 1 < this.len) && m(); y(); return h
            }, defaultFormatter: function (a) { var c = this.points || k(this), d; d = [a.tooltipFooterHeaderFormatter(c[0])]; d = d.concat(a.bodyFormatter(c)); d.push(a.tooltipFooterHeaderFormatter(c[0], !0)); return d }, refresh: function (a,
                d) {
                var c, b = this.options, p, h = a, t, f = {}, n = []; c = b.formatter || this.defaultFormatter; var f = this.shared, e; clearTimeout(this.hideTimer); this.followPointer = k(h)[0].series.tooltipOptions.followPointer; t = this.getAnchor(h, d); d = t[0]; p = t[1]; !f || h.series && h.series.noSharedTooltip ? f = h.getLabelConfig() : (A(h, function (a) { a.setState("hover"); n.push(a.getLabelConfig()) }), f = { x: h[0].category, y: h[0].y }, f.points = n, h = h[0]); this.len = n.length; f = c.call(f, this); e = h.series; this.distance = q(e.tooltipOptions.distance, 16); !1 === f ? this.hide() :
                    (c = this.getLabel(), this.isHidden && c.attr({ opacity: 1 }).show(), this.split ? this.renderSplit(f, a) : (c.attr({ text: f && f.join ? f.join("") : f }), c.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-" + q(h.colorIndex, e.colorIndex)), c.attr({ stroke: b.borderColor || h.color || e.color || "#666666" }), this.updatePosition({ plotX: d, plotY: p, negative: h.negative, ttBelow: h.ttBelow, h: t[2] || 0 })), this.isHidden = !1)
            }, renderSplit: function (c, d) {
                var f = this, b = [], p = this.chart, h = p.renderer, t = !0, n = this.options, k, e = this.getLabel();
                A(c.slice(0, d.length + 1), function (a, c) {
                    c = d[c - 1] || { isHeader: !0, plotX: d[0].plotX }; var w = c.series || f, m = w.tt, y = c.series || {}, x = "highcharts-color-" + q(c.colorIndex, y.colorIndex, "none"); m || (w.tt = m = h.label(null, null, null, "callout").addClass("highcharts-tooltip-box " + x).attr({ padding: n.padding, r: n.borderRadius, fill: n.backgroundColor, stroke: c.color || y.color || "#333333", "stroke-width": n.borderWidth }).add(e)); m.isActive = !0; m.attr({ text: a }); m.css(n.style); a = m.getBBox(); y = a.width + m.strokeWidth(); c.isHeader ? (k = a.height,
                        y = Math.max(0, Math.min(c.plotX + p.plotLeft - y / 2, p.chartWidth - y))) : y = c.plotX + p.plotLeft - q(n.distance, 16) - y; 0 > y && (t = !1); a = (c.series && c.series.yAxis && c.series.yAxis.pos) + (c.plotY || 0); a -= p.plotTop; b.push({ target: c.isHeader ? p.plotHeight + k : a, rank: c.isHeader ? 1 : 0, size: w.tt.getBBox().height + 1, point: c, x: y, tt: m })
                }); this.cleanSplit(); a.distribute(b, p.plotHeight + k); A(b, function (a) {
                    var b = a.point, c = b.series; a.tt.attr({
                        visibility: void 0 === a.pos ? "hidden" : "inherit", x: t || b.isHeader ? a.x : b.plotX + p.plotLeft + q(n.distance,
                            16), y: a.pos + p.plotTop, anchorX: b.isHeader ? b.plotX + p.plotLeft : b.plotX + c.xAxis.pos, anchorY: b.isHeader ? a.pos + p.plotTop - 15 : b.plotY + c.yAxis.pos
                    })
                })
            }, updatePosition: function (a) { var c = this.chart, d = this.getLabel(), d = (this.options.positioner || this.getPosition).call(this, d.width, d.height, a); this.move(Math.round(d.x), Math.round(d.y || 0), a.plotX + c.plotLeft, a.plotY + c.plotTop) }, getDateFormat: function (a, f, k, b) {
                var c = B("%m-%d %H:%M:%S.%L", f), h, t, n = { millisecond: 15, second: 12, minute: 9, hour: 6, day: 3 }, w = "millisecond"; for (t in d) {
                    if (a ===
                        d.week && +B("%w", f) === k && "00:00:00.000" === c.substr(6)) { t = "week"; break } if (d[t] > a) { t = w; break } if (n[t] && c.substr(n[t]) !== "01-01 00:00:00.000".substr(n[t])) break; "week" !== t && (w = t)
                } t && (h = b[t]); return h
            }, getXDateFormat: function (a, d, f) { d = d.dateTimeLabelFormats; var b = f && f.closestPointRange; return (b ? this.getDateFormat(b, a.x, f.options.startOfWeek, d) : d.day) || d.year }, tooltipFooterHeaderFormatter: function (a, d) {
                var c = d ? "footer" : "header"; d = a.series; var b = d.tooltipOptions, p = b.xDateFormat, h = d.xAxis, t = h && "datetime" ===
                    h.options.type && r(a.key), c = b[c + "Format"]; t && !p && (p = this.getXDateFormat(a, b, h)); t && p && (c = c.replace("{point.key}", "{point.key:" + p + "}")); return G(c, { point: a, series: d })
            }, bodyFormatter: function (a) { return f(a, function (a) { var c = a.series.tooltipOptions; return (c.pointFormatter || a.point.tooltipFormatter).call(a.point, c.pointFormat) }) }
        }
    })(L); (function (a) {
        var B = a.addEvent, A = a.attr, H = a.charts, G = a.color, r = a.css, f = a.defined, l = a.doc, q = a.each, k = a.extend, u = a.fireEvent, d = a.offset, c = a.pick, n = a.removeEvent, z = a.splat,
            b = a.Tooltip, p = a.win; a.Pointer = function (a, b) { this.init(a, b) }; a.Pointer.prototype = {
                init: function (a, d) { this.options = d; this.chart = a; this.runChartClick = d.chart.events && !!d.chart.events.click; this.pinchDown = []; this.lastValidTouch = {}; b && d.tooltip.enabled && (a.tooltip = new b(a, d.tooltip), this.followTouchMove = c(d.tooltip.followTouchMove, !0)); this.setDOMEvents() }, zoomOption: function (a) {
                    var b = this.chart, h = b.options.chart, d = h.zoomType || "", b = b.inverted; /touch/.test(a.type) && (d = c(h.pinchType, d)); this.zoomX = a = /x/.test(d);
                    this.zoomY = d = /y/.test(d); this.zoomHor = a && !b || d && b; this.zoomVert = d && !b || a && b; this.hasZoom = a || d
                }, normalize: function (a, b) { var c, h; a = a || p.event; a.target || (a.target = a.srcElement); h = a.touches ? a.touches.length ? a.touches.item(0) : a.changedTouches[0] : a; b || (this.chartPosition = b = d(this.chart.container)); void 0 === h.pageX ? (c = Math.max(a.x, a.clientX - b.left), b = a.y) : (c = h.pageX - b.left, b = h.pageY - b.top); return k(a, { chartX: Math.round(c), chartY: Math.round(b) }) }, getCoordinates: function (a) {
                    var b = { xAxis: [], yAxis: [] }; q(this.chart.axes,
                        function (c) { b[c.isXAxis ? "xAxis" : "yAxis"].push({ axis: c, value: c.toValue(a[c.horiz ? "chartX" : "chartY"]) }) }); return b
                }, getKDPoints: function (a, b, d) {
                    var h = [], e, p, f; q(a, function (a) { e = a.noSharedTooltip && b; p = !b && a.directTouch; a.visible && !p && c(a.options.enableMouseTracking, !0) && (f = a.searchPoint(d, !e && 0 > a.options.findNearestPointBy.indexOf("y"))) && f.series && h.push(f) }); h.sort(function (a, c) {
                        var e = a.distX - c.distX, h = a.dist - c.dist, m = (c.series.group && c.series.group.zIndex) - (a.series.group && a.series.group.zIndex);
                        return 0 !== e && b ? e : 0 !== h ? h : 0 !== m ? m : a.series.index > c.series.index ? -1 : 1
                    }); if (b && h[0] && !h[0].series.noSharedTooltip) for (a = h.length; a--;) (h[a].x !== h[0].x || h[a].series.noSharedTooltip) && h.splice(a, 1); return h
                }, getPointFromEvent: function (a) { a = a.target; for (var b; a && !b;) b = a.point, a = a.parentNode; return b }, getHoverData: function (b, d, p, f, e, n) {
                    var h = b, t = d, m; f ? e ? (m = [], q(p, function (a) {
                        var b = a.noSharedTooltip && e, d = !e && a.directTouch; a.visible && !b && !d && c(a.options.enableMouseTracking, !0) && (a = a.searchKDTree({
                            clientX: h.clientX,
                            plotY: h.plotY
                        }, !b && 1 === a.kdDimensions)) && a.series && m.push(a)
                    }), 0 === m.length && (m = [h])) : m = [h] : t && !t.stickyTracking ? (e || (p = [t]), m = this.getKDPoints(p, e, n), h = a.find(m, function (a) { return a.series === t })) : (b = a.grep(p, function (a) { return a.stickyTracking }), m = this.getKDPoints(b, e, n), t = (h = m[0]) && h.series, e && (m = this.getKDPoints(p, e, n))); m.sort(function (a, b) { return a.series.index - b.series.index }); return { hoverPoint: h, hoverSeries: t, hoverPoints: m }
                }, runPointActions: function (b, d) {
                    var h = this.chart, p = h.tooltip, e = p ? p.shared :
                        !1, f = d || h.hoverPoint, t = f && f.series || h.hoverSeries; d = this.getHoverData(f, t, h.series, !!d || !e && t && t.directTouch, e, b); var n, m, f = d.hoverPoint; n = (t = d.hoverSeries) && t.tooltipOptions.followPointer; m = (e = e && f && !f.series.noSharedTooltip) ? d.hoverPoints : f ? [f] : []; if (f && (f !== h.hoverPoint || p && p.isHidden)) {
                            q(h.hoverPoints || [], function (b) { -1 === a.inArray(b, m) && b.setState() }); q(m || [], function (a) { a.setState("hover") }); if (h.hoverSeries !== t) t.onMouseOver(); t && !t.directTouch && (h.hoverPoint && h.hoverPoint.firePointEvent("mouseOut"),
                                f.firePointEvent("mouseOver")); h.hoverPoints = m; h.hoverPoint = f; p && p.refresh(e ? m : f, b)
                        } else n && p && !p.isHidden && (f = p.getAnchor([{}], b), p.updatePosition({ plotX: f[0], plotY: f[1] })); this.unDocMouseMove || (this.unDocMouseMove = B(l, "mousemove", function (b) { var c = H[a.hoverChartIndex]; if (c) c.pointer.onDocumentMouseMove(b) })); q(h.axes, function (a) { c(a.crosshair.snap, !0) ? q(m, function (c) { c.series[a.coll] === a && a.drawCrosshair(b, c) }) : a.drawCrosshair(b) })
                }, reset: function (a, b) {
                    var c = this.chart, h = c.hoverSeries, e = c.hoverPoint,
                        d = c.hoverPoints, p = c.tooltip, f = p && p.shared ? d : e; a && f && q(z(f), function (b) { b.series.isCartesian && void 0 === b.plotX && (a = !1) }); if (a) p && f && (p.refresh(f), e && (e.setState(e.state, !0), q(c.axes, function (a) { a.crosshair && a.drawCrosshair(null, e) }))); else { if (e) e.onMouseOut(); d && q(d, function (a) { a.setState() }); if (h) h.onMouseOut(); p && p.hide(b); this.unDocMouseMove && (this.unDocMouseMove = this.unDocMouseMove()); q(c.axes, function (a) { a.hideCrosshair() }); this.hoverX = c.hoverPoints = c.hoverPoint = null }
                }, scaleGroups: function (a,
                    b) { var c = this.chart, h; q(c.series, function (e) { h = a || e.getPlotBox(); e.xAxis && e.xAxis.zoomEnabled && e.group && (e.group.attr(h), e.markerGroup && (e.markerGroup.attr(h), e.markerGroup.clip(b ? c.clipRect : null)), e.dataLabelsGroup && e.dataLabelsGroup.attr(h)) }); c.clipRect.attr(b || c.clipBox) }, dragStart: function (a) { var b = this.chart; b.mouseIsDown = a.type; b.cancelClick = !1; b.mouseDownX = this.mouseDownX = a.chartX; b.mouseDownY = this.mouseDownY = a.chartY }, drag: function (a) {
                        var b = this.chart, c = b.options.chart, h = a.chartX, e = a.chartY,
                            d = this.zoomHor, p = this.zoomVert, f = b.plotLeft, m = b.plotTop, n = b.plotWidth, k = b.plotHeight, l, q = this.selectionMarker, g = this.mouseDownX, u = this.mouseDownY, r = c.panKey && a[c.panKey + "Key"]; q && q.touch || (h < f ? h = f : h > f + n && (h = f + n), e < m ? e = m : e > m + k && (e = m + k), this.hasDragged = Math.sqrt(Math.pow(g - h, 2) + Math.pow(u - e, 2)), 10 < this.hasDragged && (l = b.isInsidePlot(g - f, u - m), b.hasCartesianSeries && (this.zoomX || this.zoomY) && l && !r && !q && (this.selectionMarker = q = b.renderer.rect(f, m, d ? 1 : n, p ? 1 : k, 0).attr({
                                fill: c.selectionMarkerFill || G("#335cad").setOpacity(.25).get(),
                                "class": "highcharts-selection-marker", zIndex: 7
                            }).add()), q && d && (h -= g, q.attr({ width: Math.abs(h), x: (0 < h ? 0 : h) + g })), q && p && (h = e - u, q.attr({ height: Math.abs(h), y: (0 < h ? 0 : h) + u })), l && !q && c.panning && b.pan(a, c.panning)))
                    }, drop: function (a) {
                        var b = this, c = this.chart, h = this.hasPinched; if (this.selectionMarker) {
                            var e = { originalEvent: a, xAxis: [], yAxis: [] }, d = this.selectionMarker, p = d.attr ? d.attr("x") : d.x, n = d.attr ? d.attr("y") : d.y, m = d.attr ? d.attr("width") : d.width, y = d.attr ? d.attr("height") : d.height, l; if (this.hasDragged || h) q(c.axes,
                                function (c) { if (c.zoomEnabled && f(c.min) && (h || b[{ xAxis: "zoomX", yAxis: "zoomY" }[c.coll]])) { var d = c.horiz, g = "touchend" === a.type ? c.minPixelPadding : 0, t = c.toValue((d ? p : n) + g), d = c.toValue((d ? p + m : n + y) - g); e[c.coll].push({ axis: c, min: Math.min(t, d), max: Math.max(t, d) }); l = !0 } }), l && u(c, "selection", e, function (a) { c.zoom(k(a, h ? { animation: !1 } : null)) }); this.selectionMarker = this.selectionMarker.destroy(); h && this.scaleGroups()
                        } c && (r(c.container, { cursor: c._cursor }), c.cancelClick = 10 < this.hasDragged, c.mouseIsDown = this.hasDragged =
                            this.hasPinched = !1, this.pinchDown = [])
                    }, onContainerMouseDown: function (a) { a = this.normalize(a); this.zoomOption(a); a.preventDefault && a.preventDefault(); this.dragStart(a) }, onDocumentMouseUp: function (b) { H[a.hoverChartIndex] && H[a.hoverChartIndex].pointer.drop(b) }, onDocumentMouseMove: function (a) { var b = this.chart, c = this.chartPosition; a = this.normalize(a, c); !c || this.inClass(a.target, "highcharts-tracker") || b.isInsidePlot(a.chartX - b.plotLeft, a.chartY - b.plotTop) || this.reset() }, onContainerMouseLeave: function (b) {
                        var c =
                            H[a.hoverChartIndex]; c && (b.relatedTarget || b.toElement) && (c.pointer.reset(), c.pointer.chartPosition = null)
                    }, onContainerMouseMove: function (b) { var c = this.chart; f(a.hoverChartIndex) && H[a.hoverChartIndex] && H[a.hoverChartIndex].mouseIsDown || (a.hoverChartIndex = c.index); b = this.normalize(b); b.returnValue = !1; "mousedown" === c.mouseIsDown && this.drag(b); !this.inClass(b.target, "highcharts-tracker") && !c.isInsidePlot(b.chartX - c.plotLeft, b.chartY - c.plotTop) || c.openMenu || this.runPointActions(b) }, inClass: function (a, b) {
                        for (var c; a;) {
                            if (c =
                                A(a, "class")) { if (-1 !== c.indexOf(b)) return !0; if (-1 !== c.indexOf("highcharts-container")) return !1 } a = a.parentNode
                        }
                    }, onTrackerMouseOut: function (a) { var b = this.chart.hoverSeries; a = a.relatedTarget || a.toElement; if (!(!b || !a || b.stickyTracking || this.inClass(a, "highcharts-tooltip") || this.inClass(a, "highcharts-series-" + b.index) && this.inClass(a, "highcharts-tracker"))) b.onMouseOut() }, onContainerClick: function (a) {
                        var b = this.chart, c = b.hoverPoint, h = b.plotLeft, e = b.plotTop; a = this.normalize(a); b.cancelClick || (c && this.inClass(a.target,
                            "highcharts-tracker") ? (u(c.series, "click", k(a, { point: c })), b.hoverPoint && c.firePointEvent("click", a)) : (k(a, this.getCoordinates(a)), b.isInsidePlot(a.chartX - h, a.chartY - e) && u(b, "click", a)))
                    }, setDOMEvents: function () {
                        var b = this, c = b.chart.container; c.onmousedown = function (a) { b.onContainerMouseDown(a) }; c.onmousemove = function (a) { b.onContainerMouseMove(a) }; c.onclick = function (a) { b.onContainerClick(a) }; B(c, "mouseleave", b.onContainerMouseLeave); 1 === a.chartCount && B(l, "mouseup", b.onDocumentMouseUp); a.hasTouch && (c.ontouchstart =
                            function (a) { b.onContainerTouchStart(a) }, c.ontouchmove = function (a) { b.onContainerTouchMove(a) }, 1 === a.chartCount && B(l, "touchend", b.onDocumentTouchEnd))
                    }, destroy: function () { var b; this.unDocMouseMove && this.unDocMouseMove(); n(this.chart.container, "mouseleave", this.onContainerMouseLeave); a.chartCount || (n(l, "mouseup", this.onDocumentMouseUp), n(l, "touchend", this.onDocumentTouchEnd)); clearInterval(this.tooltipTimeout); for (b in this) this[b] = null }
            }
    })(L); (function (a) {
        var B = a.charts, A = a.each, H = a.extend, G = a.map,
            r = a.noop, f = a.pick; H(a.Pointer.prototype, {
                pinchTranslate: function (a, f, k, u, d, c) { this.zoomHor && this.pinchTranslateDirection(!0, a, f, k, u, d, c); this.zoomVert && this.pinchTranslateDirection(!1, a, f, k, u, d, c) }, pinchTranslateDirection: function (a, f, k, u, d, c, n, r) {
                    var b = this.chart, p = a ? "x" : "y", h = a ? "X" : "Y", t = "chart" + h, l = a ? "width" : "height", w = b["plot" + (a ? "Left" : "Top")], e, q, C = r || 1, E = b.inverted, m = b.bounds[a ? "h" : "v"], y = 1 === f.length, I = f[0][t], K = k[0][t], J = !y && f[1][t], g = !y && k[1][t], z; k = function () {
                        !y && 20 < Math.abs(I - J) && (C = r ||
                            Math.abs(K - g) / Math.abs(I - J)); q = (w - K) / C + I; e = b["plot" + (a ? "Width" : "Height")] / C
                    }; k(); f = q; f < m.min ? (f = m.min, z = !0) : f + e > m.max && (f = m.max - e, z = !0); z ? (K -= .8 * (K - n[p][0]), y || (g -= .8 * (g - n[p][1])), k()) : n[p] = [K, g]; E || (c[p] = q - w, c[l] = e); c = E ? 1 / C : C; d[l] = e; d[p] = f; u[E ? a ? "scaleY" : "scaleX" : "scale" + h] = C; u["translate" + h] = c * w + (K - c * I)
                }, pinch: function (a) {
                    var l = this, k = l.chart, u = l.pinchDown, d = a.touches, c = d.length, n = l.lastValidTouch, z = l.hasZoom, b = l.selectionMarker, p = {}, h = 1 === c && (l.inClass(a.target, "highcharts-tracker") && k.runTrackerClick ||
                        l.runChartClick), t = {}; 1 < c && (l.initiated = !0); z && l.initiated && !h && a.preventDefault(); G(d, function (a) { return l.normalize(a) }); "touchstart" === a.type ? (A(d, function (a, b) { u[b] = { chartX: a.chartX, chartY: a.chartY } }), n.x = [u[0].chartX, u[1] && u[1].chartX], n.y = [u[0].chartY, u[1] && u[1].chartY], A(k.axes, function (a) {
                            if (a.zoomEnabled) {
                                var b = k.bounds[a.horiz ? "h" : "v"], c = a.minPixelPadding, h = a.toPixels(f(a.options.min, a.dataMin)), d = a.toPixels(f(a.options.max, a.dataMax)), p = Math.max(h, d); b.min = Math.min(a.pos, Math.min(h, d) -
                                    c); b.max = Math.max(a.pos + a.len, p + c)
                            }
                        }), l.res = !0) : l.followTouchMove && 1 === c ? this.runPointActions(l.normalize(a)) : u.length && (b || (l.selectionMarker = b = H({ destroy: r, touch: !0 }, k.plotBox)), l.pinchTranslate(u, d, p, b, t, n), l.hasPinched = z, l.scaleGroups(p, t), l.res && (l.res = !1, this.reset(!1, 0)))
                }, touch: function (l, q) {
                    var k = this.chart, u, d; if (k.index !== a.hoverChartIndex) this.onContainerMouseLeave({ relatedTarget: !0 }); a.hoverChartIndex = k.index; 1 === l.touches.length ? (l = this.normalize(l), (d = k.isInsidePlot(l.chartX - k.plotLeft,
                        l.chartY - k.plotTop)) && !k.openMenu ? (q && this.runPointActions(l), "touchmove" === l.type && (q = this.pinchDown, u = q[0] ? 4 <= Math.sqrt(Math.pow(q[0].chartX - l.chartX, 2) + Math.pow(q[0].chartY - l.chartY, 2)) : !1), f(u, !0) && this.pinch(l)) : q && this.reset()) : 2 === l.touches.length && this.pinch(l)
                }, onContainerTouchStart: function (a) { this.zoomOption(a); this.touch(a, !0) }, onContainerTouchMove: function (a) { this.touch(a) }, onDocumentTouchEnd: function (f) { B[a.hoverChartIndex] && B[a.hoverChartIndex].pointer.drop(f) }
            })
    })(L); (function (a) {
        var B =
            a.addEvent, A = a.charts, H = a.css, G = a.doc, r = a.extend, f = a.noop, l = a.Pointer, q = a.removeEvent, k = a.win, u = a.wrap; if (k.PointerEvent || k.MSPointerEvent) {
                var d = {}, c = !!k.PointerEvent, n = function () { var a, c = []; c.item = function (a) { return this[a] }; for (a in d) d.hasOwnProperty(a) && c.push({ pageX: d[a].pageX, pageY: d[a].pageY, target: d[a].target }); return c }, z = function (b, c, h, d) {
                    "touch" !== b.pointerType && b.pointerType !== b.MSPOINTER_TYPE_TOUCH || !A[a.hoverChartIndex] || (d(b), d = A[a.hoverChartIndex].pointer, d[c]({
                        type: h, target: b.currentTarget,
                        preventDefault: f, touches: n()
                    }))
                }; r(l.prototype, {
                    onContainerPointerDown: function (a) { z(a, "onContainerTouchStart", "touchstart", function (a) { d[a.pointerId] = { pageX: a.pageX, pageY: a.pageY, target: a.currentTarget } }) }, onContainerPointerMove: function (a) { z(a, "onContainerTouchMove", "touchmove", function (a) { d[a.pointerId] = { pageX: a.pageX, pageY: a.pageY }; d[a.pointerId].target || (d[a.pointerId].target = a.currentTarget) }) }, onDocumentPointerUp: function (a) { z(a, "onDocumentTouchEnd", "touchend", function (a) { delete d[a.pointerId] }) },
                    batchMSEvents: function (a) { a(this.chart.container, c ? "pointerdown" : "MSPointerDown", this.onContainerPointerDown); a(this.chart.container, c ? "pointermove" : "MSPointerMove", this.onContainerPointerMove); a(G, c ? "pointerup" : "MSPointerUp", this.onDocumentPointerUp) }
                }); u(l.prototype, "init", function (a, c, h) { a.call(this, c, h); this.hasZoom && H(c.container, { "-ms-touch-action": "none", "touch-action": "none" }) }); u(l.prototype, "setDOMEvents", function (a) { a.apply(this); (this.hasZoom || this.followTouchMove) && this.batchMSEvents(B) });
                u(l.prototype, "destroy", function (a) { this.batchMSEvents(q); a.call(this) })
            }
    })(L); (function (a) {
        var B, A = a.addEvent, H = a.css, G = a.discardElement, r = a.defined, f = a.each, l = a.isFirefox, q = a.marginNames, k = a.merge, u = a.pick, d = a.setAnimation, c = a.stableSort, n = a.win, z = a.wrap; B = a.Legend = function (a, c) { this.init(a, c) }; B.prototype = {
            init: function (a, c) { this.chart = a; this.setOptions(c); c.enabled && (this.render(), A(this.chart, "endResize", function () { this.legend.positionCheckboxes() })) }, setOptions: function (a) {
                var b = u(a.padding,
                    8); this.options = a; this.itemStyle = a.itemStyle; this.itemHiddenStyle = k(this.itemStyle, a.itemHiddenStyle); this.itemMarginTop = a.itemMarginTop || 0; this.padding = b; this.initialItemY = b - 5; this.itemHeight = this.maxItemWidth = 0; this.symbolWidth = u(a.symbolWidth, 16); this.pages = []
            }, update: function (a, c) { var b = this.chart; this.setOptions(k(!0, this.options, a)); this.destroy(); b.isDirtyLegend = b.isDirtyBox = !0; u(c, !0) && b.redraw() }, colorizeItem: function (a, c) {
                a.legendGroup[c ? "removeClass" : "addClass"]("highcharts-legend-item-hidden");
                var b = this.options, d = a.legendItem, f = a.legendLine, p = a.legendSymbol, e = this.itemHiddenStyle.color, b = c ? b.itemStyle.color : e, n = c ? a.color || e : e, k = a.options && a.options.marker, l = { fill: n }, m; d && d.css({ fill: b, color: b }); f && f.attr({ stroke: n }); if (p) { if (k && p.isMarker && (l = a.pointAttribs(), !c)) for (m in l) l[m] = e; p.attr(l) }
            }, positionItem: function (a) {
                var b = this.options, c = b.symbolPadding, b = !b.rtl, d = a._legendItemPos, f = d[0], d = d[1], n = a.checkbox; (a = a.legendGroup) && a.element && a.translate(b ? f : this.legendWidth - f - 2 * c - 4, d); n && (n.x =
                    f, n.y = d)
            }, destroyItem: function (a) { var b = a.checkbox; f(["legendItem", "legendLine", "legendSymbol", "legendGroup"], function (b) { a[b] && (a[b] = a[b].destroy()) }); b && G(a.checkbox) }, destroy: function () { function a(a) { this[a] && (this[a] = this[a].destroy()) } f(this.getAllItems(), function (b) { f(["legendItem", "legendGroup"], a, b) }); f("clipRect up down pager nav box title group".split(" "), a, this); this.display = null }, positionCheckboxes: function (a) {
                var b = this.group && this.group.alignAttr, c, d = this.clipHeight || this.legendHeight,
                    n = this.titleHeight; b && (c = b.translateY, f(this.allItems, function (h) { var e = h.checkbox, f; e && (f = c + n + e.y + (a || 0) + 3, H(e, { left: b.translateX + h.checkboxOffset + e.x - 20 + "px", top: f + "px", display: f > c - 6 && f < c + d - 6 ? "" : "none" })) }))
            }, renderTitle: function () {
                var a = this.padding, c = this.options.title, h = 0; c.text && (this.title || (this.title = this.chart.renderer.label(c.text, a - 3, a - 4, null, null, null, null, null, "legend-title").attr({ zIndex: 1 }).css(c.style).add(this.group)), a = this.title.getBBox(), h = a.height, this.offsetWidth = a.width, this.contentGroup.attr({ translateY: h }));
                this.titleHeight = h
            }, setText: function (b) { var c = this.options; b.legendItem.attr({ text: c.labelFormat ? a.format(c.labelFormat, b) : c.labelFormatter.call(b) }) }, renderItem: function (a) {
                var b = this.chart, c = b.renderer, d = this.options, f = "horizontal" === d.layout, n = this.symbolWidth, e = d.symbolPadding, l = this.itemStyle, q = this.itemHiddenStyle, r = this.padding, m = f ? u(d.itemDistance, 20) : 0, y = !d.rtl, I = d.width, K = d.itemMarginBottom || 0, J = this.itemMarginTop, g = a.legendItem, z = !a.series, Q = !z && a.series.drawLegendSymbol ? a.series : a, A = Q.options,
                    A = this.createCheckboxForItem && A && A.showCheckbox, B = d.useHTML, H = a.options.className; g || (a.legendGroup = c.g("legend-item").addClass("highcharts-" + Q.type + "-series highcharts-color-" + a.colorIndex + (H ? " " + H : "") + (z ? " highcharts-series-" + a.index : "")).attr({ zIndex: 1 }).add(this.scrollGroup), a.legendItem = g = c.text("", y ? n + e : -e, this.baseline || 0, B).css(k(a.visible ? l : q)).attr({ align: y ? "left" : "right", zIndex: 2 }).add(a.legendGroup), this.baseline || (l = l.fontSize, this.fontMetrics = c.fontMetrics(l, g), this.baseline = this.fontMetrics.f +
                        3 + J, g.attr("y", this.baseline)), this.symbolHeight = d.symbolHeight || this.fontMetrics.f, Q.drawLegendSymbol(this, a), this.setItemEvents && this.setItemEvents(a, g, B), A && this.createCheckboxForItem(a)); this.colorizeItem(a, a.visible); this.setText(a); c = g.getBBox(); n = a.checkboxOffset = d.itemWidth || a.legendItemWidth || n + e + c.width + m + (A ? 20 : 0); this.itemHeight = e = Math.round(a.legendItemHeight || c.height || this.symbolHeight); f && this.itemX - r + n > (I || b.spacingBox.width - 2 * r - d.x) && (this.itemX = r, this.itemY += J + this.lastLineHeight +
                            K, this.lastLineHeight = 0); this.maxItemWidth = Math.max(this.maxItemWidth, n); this.lastItemY = J + this.itemY + K; this.lastLineHeight = Math.max(e, this.lastLineHeight); a._legendItemPos = [this.itemX, this.itemY]; f ? this.itemX += n : (this.itemY += J + e + K, this.lastLineHeight = e); this.offsetWidth = I || Math.max((f ? this.itemX - r - m : n) + r, this.offsetWidth)
            }, getAllItems: function () {
                var a = []; f(this.chart.series, function (b) {
                    var c = b && b.options; b && u(c.showInLegend, r(c.linkedTo) ? !1 : void 0, !0) && (a = a.concat(b.legendItems || ("point" === c.legendType ?
                        b.data : b)))
                }); return a
            }, adjustMargins: function (a, c) { var b = this.chart, d = this.options, p = d.align.charAt(0) + d.verticalAlign.charAt(0) + d.layout.charAt(0); d.floating || f([/(lth|ct|rth)/, /(rtv|rm|rbv)/, /(rbh|cb|lbh)/, /(lbv|lm|ltv)/], function (h, e) { h.test(p) && !r(a[e]) && (b[q[e]] = Math.max(b[q[e]], b.legend[(e + 1) % 2 ? "legendHeight" : "legendWidth"] + [1, -1, -1, 1][e] * d[e % 2 ? "x" : "y"] + u(d.margin, 12) + c[e])) }) }, render: function () {
                var a = this, d = a.chart, h = d.renderer, n = a.group, l, q, e, x, u = a.box, r = a.options, m = a.padding; a.itemX = m; a.itemY =
                    a.initialItemY; a.offsetWidth = 0; a.lastItemY = 0; n || (a.group = n = h.g("legend").attr({ zIndex: 7 }).add(), a.contentGroup = h.g().attr({ zIndex: 1 }).add(n), a.scrollGroup = h.g().add(a.contentGroup)); a.renderTitle(); l = a.getAllItems(); c(l, function (a, b) { return (a.options && a.options.legendIndex || 0) - (b.options && b.options.legendIndex || 0) }); r.reversed && l.reverse(); a.allItems = l; a.display = q = !!l.length; a.lastLineHeight = 0; f(l, function (b) { a.renderItem(b) }); e = (r.width || a.offsetWidth) + m; x = a.lastItemY + a.lastLineHeight + a.titleHeight;
                x = a.handleOverflow(x); x += m; u || (a.box = u = h.rect().addClass("highcharts-legend-box").attr({ r: r.borderRadius }).add(n), u.isNew = !0); u.attr({ stroke: r.borderColor, "stroke-width": r.borderWidth || 0, fill: r.backgroundColor || "none" }).shadow(r.shadow); 0 < e && 0 < x && (u[u.isNew ? "attr" : "animate"](u.crisp({ x: 0, y: 0, width: e, height: x }, u.strokeWidth())), u.isNew = !1); u[q ? "show" : "hide"](); a.legendWidth = e; a.legendHeight = x; f(l, function (b) { a.positionItem(b) }); q && n.align(k(r, { width: e, height: x }), !0, "spacingBox"); d.isResizing || this.positionCheckboxes()
            },
            handleOverflow: function (a) {
                var b = this, c = this.chart, d = c.renderer, n = this.options, k = n.y, e = this.padding, c = c.spacingBox.height + ("top" === n.verticalAlign ? -k : k) - e, k = n.maxHeight, l, q = this.clipRect, r = n.navigation, m = u(r.animation, !0), y = r.arrowSize || 12, I = this.nav, K = this.pages, J, g = this.allItems, z = function (a) { a ? q.attr({ height: a }) : q && (b.clipRect = q.destroy(), b.contentGroup.clip()); b.contentGroup.div && (b.contentGroup.div.style.clip = a ? "rect(" + e + "px,9999px," + (e + a) + "px,0)" : "auto") }; "horizontal" !== n.layout || "middle" ===
                    n.verticalAlign || n.floating || (c /= 2); k && (c = Math.min(c, k)); K.length = 0; a > c && !1 !== r.enabled ? (this.clipHeight = l = Math.max(c - 20 - this.titleHeight - e, 0), this.currentPage = u(this.currentPage, 1), this.fullHeight = a, f(g, function (a, b) { var c = a._legendItemPos[1]; a = Math.round(a.legendItem.getBBox().height); var e = K.length; if (!e || c - K[e - 1] > l && (J || c) !== K[e - 1]) K.push(J || c), e++; b === g.length - 1 && c + a - K[e - 1] > l && K.push(c); c !== J && (J = c) }), q || (q = b.clipRect = d.clipRect(0, e, 9999, 0), b.contentGroup.clip(q)), z(l), I || (this.nav = I = d.g().attr({ zIndex: 1 }).add(this.group),
                        this.up = d.symbol("triangle", 0, 0, y, y).on("click", function () { b.scroll(-1, m) }).add(I), this.pager = d.text("", 15, 10).addClass("highcharts-legend-navigation").css(r.style).add(I), this.down = d.symbol("triangle-down", 0, 0, y, y).on("click", function () { b.scroll(1, m) }).add(I)), b.scroll(0), a = c) : I && (z(), this.nav = I.destroy(), this.scrollGroup.attr({ translateY: 1 }), this.clipHeight = 0); return a
            }, scroll: function (a, c) {
                var b = this.pages, f = b.length; a = this.currentPage + a; var p = this.clipHeight, n = this.options.navigation, e = this.pager,
                    k = this.padding; a > f && (a = f); 0 < a && (void 0 !== c && d(c, this.chart), this.nav.attr({ translateX: k, translateY: p + this.padding + 7 + this.titleHeight, visibility: "visible" }), this.up.attr({ "class": 1 === a ? "highcharts-legend-nav-inactive" : "highcharts-legend-nav-active" }), e.attr({ text: a + "/" + f }), this.down.attr({ x: 18 + this.pager.getBBox().width, "class": a === f ? "highcharts-legend-nav-inactive" : "highcharts-legend-nav-active" }), this.up.attr({ fill: 1 === a ? n.inactiveColor : n.activeColor }).css({ cursor: 1 === a ? "default" : "pointer" }), this.down.attr({
                        fill: a ===
                            f ? n.inactiveColor : n.activeColor
                    }).css({ cursor: a === f ? "default" : "pointer" }), c = -b[a - 1] + this.initialItemY, this.scrollGroup.animate({ translateY: c }), this.currentPage = a, this.positionCheckboxes(c))
            }
        }; a.LegendSymbolMixin = {
            drawRectangle: function (a, c) { var b = a.symbolHeight, d = a.options.squareSymbol; c.legendSymbol = this.chart.renderer.rect(d ? (a.symbolWidth - b) / 2 : 0, a.baseline - b + 1, d ? b : a.symbolWidth, b, u(a.options.symbolRadius, b / 2)).addClass("highcharts-point").attr({ zIndex: 3 }).add(c.legendGroup) }, drawLineMarker: function (a) {
                var b =
                    this.options, c = b.marker, d = a.symbolWidth, f = a.symbolHeight, n = f / 2, e = this.chart.renderer, l = this.legendGroup; a = a.baseline - Math.round(.3 * a.fontMetrics.b); var q; q = { "stroke-width": b.lineWidth || 0 }; b.dashStyle && (q.dashstyle = b.dashStyle); this.legendLine = e.path(["M", 0, a, "L", d, a]).addClass("highcharts-graph").attr(q).add(l); c && !1 !== c.enabled && (b = Math.min(u(c.radius, n), n), 0 === this.symbol.indexOf("url") && (c = k(c, { width: f, height: f }), b = 0), this.legendSymbol = c = e.symbol(this.symbol, d / 2 - b, a - b, 2 * b, 2 * b, c).addClass("highcharts-point").add(l),
                        c.isMarker = !0)
            }
        }; (/Trident\/7\.0/.test(n.navigator.userAgent) || l) && z(B.prototype, "positionItem", function (a, c) { var b = this, d = function () { c._legendItemPos && a.call(b, c) }; d(); setTimeout(d) })
    })(L); (function (a) {
        var B = a.addEvent, A = a.animate, H = a.animObject, G = a.attr, r = a.doc, f = a.Axis, l = a.createElement, q = a.defaultOptions, k = a.discardElement, u = a.charts, d = a.css, c = a.defined, n = a.each, z = a.extend, b = a.find, p = a.fireEvent, h = a.getStyle, t = a.grep, D = a.isNumber, w = a.isObject, e = a.isString, x = a.Legend, C = a.marginNames, E = a.merge,
            m = a.Pointer, y = a.pick, I = a.pInt, K = a.removeEvent, J = a.seriesTypes, g = a.splat, F = a.svg, Q = a.syncTimeout, N = a.win, P = a.Renderer, O = a.Chart = function () { this.getArgs.apply(this, arguments) }; a.chart = function (a, b, c) { return new O(a, b, c) }; O.prototype = {
                callbacks: [], getArgs: function () { var a = [].slice.call(arguments); if (e(a[0]) || a[0].nodeName) this.renderTo = a.shift(); this.init(a[0], a[1]) }, init: function (b, c) {
                    var e, g = b.series; b.series = null; e = E(q, b); e.series = b.series = g; this.userOptions = b; b = e.chart; g = b.events; this.margin = [];
                    this.spacing = []; this.bounds = { h: {}, v: {} }; this.callback = c; this.isResizing = 0; this.options = e; this.axes = []; this.series = []; this.hasCartesianSeries = b.showAxes; var d; this.index = u.length; u.push(this); a.chartCount++; if (g) for (d in g) B(this, d, g[d]); this.xAxis = []; this.yAxis = []; this.pointCount = this.colorCounter = this.symbolCounter = 0; this.firstRender()
                }, initSeries: function (b) { var c = this.options.chart; (c = J[b.type || c.type || c.defaultSeriesType]) || a.error(17, !0); c = new c; c.init(this, b); return c }, orderSeries: function (a) {
                    var b =
                        this.series; for (a = a || 0; a < b.length; a++) b[a] && (b[a].index = a, b[a].name = b[a].name || "Series " + (b[a].index + 1))
                }, isInsidePlot: function (a, b, c) { var e = c ? b : a; a = c ? a : b; return 0 <= e && e <= this.plotWidth && 0 <= a && a <= this.plotHeight }, redraw: function (b) {
                    var c = this.axes, e = this.series, g = this.pointer, d = this.legend, m = this.isDirtyLegend, h, f, v = this.hasCartesianSeries, k = this.isDirtyBox, y, l = this.renderer, t = l.isHidden(), q = []; this.setResponsive && this.setResponsive(!1); a.setAnimation(b, this); t && this.cloneRenderTo(); this.layOutTitles();
                    for (b = e.length; b--;) if (y = e[b], y.options.stacking && (h = !0, y.isDirty)) { f = !0; break } if (f) for (b = e.length; b--;) y = e[b], y.options.stacking && (y.isDirty = !0); n(e, function (a) { a.isDirty && "point" === a.options.legendType && (a.updateTotals && a.updateTotals(), m = !0); a.isDirtyData && p(a, "updatedData") }); m && d.options.enabled && (d.render(), this.isDirtyLegend = !1); h && this.getStacks(); v && n(c, function (a) { a.updateNames(); a.setScale() }); this.getMargins(); v && (n(c, function (a) { a.isDirty && (k = !0) }), n(c, function (a) {
                        var b = a.min + "," + a.max;
                        a.extKey !== b && (a.extKey = b, q.push(function () { p(a, "afterSetExtremes", z(a.eventArgs, a.getExtremes())); delete a.eventArgs })); (k || h) && a.redraw()
                    })); k && this.drawChartBox(); p(this, "predraw"); n(e, function (a) { (k || a.isDirty) && a.visible && a.redraw(); a.isDirtyData = !1 }); g && g.reset(!0); l.draw(); p(this, "redraw"); p(this, "render"); t && this.cloneRenderTo(!0); n(q, function (a) { a.call() })
                }, get: function (a) {
                    function c(b) { return b.id === a || b.options && b.options.id === a } var e, g = this.series, d; e = b(this.axes, c) || b(this.series, c);
                    for (d = 0; !e && d < g.length; d++) e = b(g[d].points || [], c); return e
                }, getAxes: function () { var a = this, b = this.options, c = b.xAxis = g(b.xAxis || {}), b = b.yAxis = g(b.yAxis || {}); n(c, function (a, b) { a.index = b; a.isX = !0 }); n(b, function (a, b) { a.index = b }); c = c.concat(b); n(c, function (b) { new f(a, b) }) }, getSelectedPoints: function () { var a = []; n(this.series, function (b) { a = a.concat(t(b.points || [], function (a) { return a.selected })) }); return a }, getSelectedSeries: function () { return t(this.series, function (a) { return a.selected }) }, setTitle: function (a,
                    b, c) { var e = this, g = e.options, d; d = g.title = E({ style: { color: "#333333", fontSize: g.isStock ? "16px" : "18px" } }, g.title, a); g = g.subtitle = E({ style: { color: "#666666" } }, g.subtitle, b); n([["title", a, d], ["subtitle", b, g]], function (a, b) { var c = a[0], g = e[c], d = a[1]; a = a[2]; g && d && (e[c] = g = g.destroy()); a && a.text && !g && (e[c] = e.renderer.text(a.text, 0, 0, a.useHTML).attr({ align: a.align, "class": "highcharts-" + c, zIndex: a.zIndex || 4 }).add(), e[c].update = function (a) { e.setTitle(!b && a, b && a) }, e[c].css(a.style)) }); e.layOutTitles(c) }, layOutTitles: function (a) {
                        var b =
                            0, c, e = this.renderer, g = this.spacingBox; n(["title", "subtitle"], function (a) { var c = this[a], d = this.options[a], m; c && (m = d.style.fontSize, m = e.fontMetrics(m, c).b, c.css({ width: (d.width || g.width + d.widthAdjust) + "px" }).align(z({ y: b + m + ("title" === a ? -3 : 2) }, d), !1, "spacingBox"), d.floating || d.verticalAlign || (b = Math.ceil(b + c.getBBox(d.useHTML).height))) }, this); c = this.titleOffset !== b; this.titleOffset = b; !this.isDirtyBox && c && (this.isDirtyBox = c, this.hasRendered && y(a, !0) && this.isDirtyBox && this.redraw())
                    }, getChartSize: function () {
                        var b =
                            this.options.chart, e = b.width, b = b.height, g = this.renderToClone || this.renderTo; c(e) || (this.containerWidth = h(g, "width")); c(b) || (this.containerHeight = h(g, "height")); this.chartWidth = Math.max(0, e || this.containerWidth || 600); this.chartHeight = Math.max(0, a.relativeLength(b, this.chartWidth) || this.containerHeight || 400)
                    }, cloneRenderTo: function (a) {
                        var b = this.renderToClone, c = this.container; if (a) { if (b) { for (; b.childNodes.length;) this.renderTo.appendChild(b.firstChild); k(b); delete this.renderToClone } } else c && c.parentNode ===
                            this.renderTo && this.renderTo.removeChild(c), this.renderToClone = b = this.renderTo.cloneNode(0), d(b, { position: "absolute", top: "-9999px", display: "block" }), b.style.setProperty && b.style.setProperty("display", "block", "important"), r.body.appendChild(b), c && b.appendChild(c)
                    }, setClassName: function (a) { this.container.className = "highcharts-container " + (a || "") }, getContainer: function () {
                        var b, c = this.options, g = c.chart, d, m; b = this.renderTo; var h = a.uniqueKey(), f; b || (this.renderTo = b = g.renderTo); e(b) && (this.renderTo = b = r.getElementById(b));
                        b || a.error(13, !0); d = I(G(b, "data-highcharts-chart")); D(d) && u[d] && u[d].hasRendered && u[d].destroy(); G(b, "data-highcharts-chart", this.index); b.innerHTML = ""; g.skipClone || b.offsetWidth || this.cloneRenderTo(); this.getChartSize(); d = this.chartWidth; m = this.chartHeight; f = z({ position: "relative", overflow: "hidden", width: d + "px", height: m + "px", textAlign: "left", lineHeight: "normal", zIndex: 0, "-webkit-tap-highlight-color": "rgba(0,0,0,0)" }, g.style); this.container = b = l("div", { id: h }, f, this.renderToClone || b); this._cursor = b.style.cursor;
                        this.renderer = new (a[g.renderer] || P)(b, d, m, null, g.forExport, c.exporting && c.exporting.allowHTML); this.setClassName(g.className); this.renderer.setStyle(g.style); this.renderer.chartIndex = this.index
                    }, getMargins: function (a) {
                        var b = this.spacing, e = this.margin, g = this.titleOffset; this.resetMargins(); g && !c(e[0]) && (this.plotTop = Math.max(this.plotTop, g + this.options.title.margin + b[0])); this.legend.display && this.legend.adjustMargins(e, b); this.extraMargin && (this[this.extraMargin.type] = (this[this.extraMargin.type] ||
                            0) + this.extraMargin.value); this.extraTopMargin && (this.plotTop += this.extraTopMargin); a || this.getAxisMargins()
                    }, getAxisMargins: function () { var a = this, b = a.axisOffset = [0, 0, 0, 0], e = a.margin; a.hasCartesianSeries && n(a.axes, function (a) { a.visible && a.getOffset() }); n(C, function (g, d) { c(e[d]) || (a[g] += b[d]) }); a.setChartSize() }, reflow: function (a) {
                        var b = this, e = b.options.chart, g = b.renderTo, d = c(e.width), m = e.width || h(g, "width"), e = e.height || h(g, "height"), g = a ? a.target : N; if (!d && !b.isPrinting && m && e && (g === N || g === r)) {
                            if (m !==
                                b.containerWidth || e !== b.containerHeight) clearTimeout(b.reflowTimeout), b.reflowTimeout = Q(function () { b.container && b.setSize(void 0, void 0, !1) }, a ? 100 : 0); b.containerWidth = m; b.containerHeight = e
                        }
                    }, initReflow: function () { var a = this, b; b = B(N, "resize", function (b) { a.reflow(b) }); B(a, "destroy", b) }, setSize: function (b, c, e) {
                        var g = this, m = g.renderer; g.isResizing += 1; a.setAnimation(e, g); g.oldChartHeight = g.chartHeight; g.oldChartWidth = g.chartWidth; void 0 !== b && (g.options.chart.width = b); void 0 !== c && (g.options.chart.height =
                            c); g.getChartSize(); b = m.globalAnimation; (b ? A : d)(g.container, { width: g.chartWidth + "px", height: g.chartHeight + "px" }, b); g.setChartSize(!0); m.setSize(g.chartWidth, g.chartHeight, e); n(g.axes, function (a) { a.isDirty = !0; a.setScale() }); g.isDirtyLegend = !0; g.isDirtyBox = !0; g.layOutTitles(); g.getMargins(); g.redraw(e); g.oldChartHeight = null; p(g, "resize"); Q(function () { g && p(g, "endResize", null, function () { --g.isResizing }) }, H(b).duration)
                    }, setChartSize: function (a) {
                        var b = this.inverted, c = this.renderer, e = this.chartWidth, g =
                            this.chartHeight, d = this.options.chart, m = this.spacing, h = this.clipOffset, f, p, k, y; this.plotLeft = f = Math.round(this.plotLeft); this.plotTop = p = Math.round(this.plotTop); this.plotWidth = k = Math.max(0, Math.round(e - f - this.marginRight)); this.plotHeight = y = Math.max(0, Math.round(g - p - this.marginBottom)); this.plotSizeX = b ? y : k; this.plotSizeY = b ? k : y; this.plotBorderWidth = d.plotBorderWidth || 0; this.spacingBox = c.spacingBox = { x: m[3], y: m[0], width: e - m[3] - m[1], height: g - m[0] - m[2] }; this.plotBox = c.plotBox = { x: f, y: p, width: k, height: y };
                        e = 2 * Math.floor(this.plotBorderWidth / 2); b = Math.ceil(Math.max(e, h[3]) / 2); c = Math.ceil(Math.max(e, h[0]) / 2); this.clipBox = { x: b, y: c, width: Math.floor(this.plotSizeX - Math.max(e, h[1]) / 2 - b), height: Math.max(0, Math.floor(this.plotSizeY - Math.max(e, h[2]) / 2 - c)) }; a || n(this.axes, function (a) { a.setAxisSize(); a.setAxisTranslation() })
                    }, resetMargins: function () {
                        var a = this, b = a.options.chart; n(["margin", "spacing"], function (c) { var e = b[c], g = w(e) ? e : [e, e, e, e]; n(["Top", "Right", "Bottom", "Left"], function (e, d) { a[c][d] = y(b[c + e], g[d]) }) });
                        n(C, function (b, c) { a[b] = y(a.margin[c], a.spacing[c]) }); a.axisOffset = [0, 0, 0, 0]; a.clipOffset = [0, 0, 0, 0]
                    }, drawChartBox: function () {
                        var a = this.options.chart, b = this.renderer, c = this.chartWidth, e = this.chartHeight, g = this.chartBackground, d = this.plotBackground, m = this.plotBorder, h, f = this.plotBGImage, n = a.backgroundColor, p = a.plotBackgroundColor, k = a.plotBackgroundImage, y, l = this.plotLeft, t = this.plotTop, q = this.plotWidth, u = this.plotHeight, x = this.plotBox, r = this.clipRect, w = this.clipBox, I = "animate"; g || (this.chartBackground =
                            g = b.rect().addClass("highcharts-background").add(), I = "attr"); h = a.borderWidth || 0; y = h + (a.shadow ? 8 : 0); n = { fill: n || "none" }; if (h || g["stroke-width"]) n.stroke = a.borderColor, n["stroke-width"] = h; g.attr(n).shadow(a.shadow); g[I]({ x: y / 2, y: y / 2, width: c - y - h % 2, height: e - y - h % 2, r: a.borderRadius }); I = "animate"; d || (I = "attr", this.plotBackground = d = b.rect().addClass("highcharts-plot-background").add()); d[I](x); d.attr({ fill: p || "none" }).shadow(a.plotShadow); k && (f ? f.animate(x) : this.plotBGImage = b.image(k, l, t, q, u).add()); r ? r.animate({
                                width: w.width,
                                height: w.height
                            }) : this.clipRect = b.clipRect(w); I = "animate"; m || (I = "attr", this.plotBorder = m = b.rect().addClass("highcharts-plot-border").attr({ zIndex: 1 }).add()); m.attr({ stroke: a.plotBorderColor, "stroke-width": a.plotBorderWidth || 0, fill: "none" }); m[I](m.crisp({ x: l, y: t, width: q, height: u }, -m.strokeWidth())); this.isDirtyBox = !1
                    }, propFromSeries: function () {
                        var a = this, b = a.options.chart, c, e = a.options.series, g, d; n(["inverted", "angular", "polar"], function (m) {
                            c = J[b.type || b.defaultSeriesType]; d = b[m] || c && c.prototype[m];
                            for (g = e && e.length; !d && g--;) (c = J[e[g].type]) && c.prototype[m] && (d = !0); a[m] = d
                        })
                    }, linkSeries: function () { var a = this, b = a.series; n(b, function (a) { a.linkedSeries.length = 0 }); n(b, function (b) { var c = b.options.linkedTo; e(c) && (c = ":previous" === c ? a.series[b.index - 1] : a.get(c)) && c.linkedParent !== b && (c.linkedSeries.push(b), b.linkedParent = c, b.visible = y(b.options.visible, c.options.visible, b.visible)) }) }, renderSeries: function () { n(this.series, function (a) { a.translate(); a.render() }) }, renderLabels: function () {
                        var a = this, b = a.options.labels;
                        b.items && n(b.items, function (c) { var e = z(b.style, c.style), g = I(e.left) + a.plotLeft, d = I(e.top) + a.plotTop + 12; delete e.left; delete e.top; a.renderer.text(c.html, g, d).attr({ zIndex: 2 }).css(e).add() })
                    }, render: function () {
                        var a = this.axes, b = this.renderer, c = this.options, e, g, d; this.setTitle(); this.legend = new x(this, c.legend); this.getStacks && this.getStacks(); this.getMargins(!0); this.setChartSize(); c = this.plotWidth; e = this.plotHeight -= 21; n(a, function (a) { a.setScale() }); this.getAxisMargins(); g = 1.1 < c / this.plotWidth; d =
                            1.05 < e / this.plotHeight; if (g || d) n(a, function (a) { (a.horiz && g || !a.horiz && d) && a.setTickInterval(!0) }), this.getMargins(); this.drawChartBox(); this.hasCartesianSeries && n(a, function (a) { a.visible && a.render() }); this.seriesGroup || (this.seriesGroup = b.g("series-group").attr({ zIndex: 3 }).add()); this.renderSeries(); this.renderLabels(); this.addCredits(); this.setResponsive && this.setResponsive(); this.hasRendered = !0
                    }, addCredits: function (a) {
                        var b = this; a = E(!0, this.options.credits, a); a.enabled && !this.credits && (this.credits =
                            this.renderer.text(a.text + (this.mapCredits || ""), 0, 0).addClass("highcharts-credits").on("click", function () { a.href && (N.location.href = a.href) }).attr({ align: a.position.align, zIndex: 8 }).css(a.style).add().align(a.position), this.credits.update = function (a) { b.credits = b.credits.destroy(); b.addCredits(a) })
                    }, destroy: function () {
                        var b = this, c = b.axes, e = b.series, g = b.container, d, m = g && g.parentNode; p(b, "destroy"); u[b.index] = void 0; a.chartCount--; b.renderTo.removeAttribute("data-highcharts-chart"); K(b); for (d = c.length; d--;) c[d] =
                            c[d].destroy(); this.scroller && this.scroller.destroy && this.scroller.destroy(); for (d = e.length; d--;) e[d] = e[d].destroy(); n("title subtitle chartBackground plotBackground plotBGImage plotBorder seriesGroup clipRect credits pointer rangeSelector legend resetZoomButton tooltip renderer".split(" "), function (a) { var c = b[a]; c && c.destroy && (b[a] = c.destroy()) }); g && (g.innerHTML = "", K(g), m && k(g)); for (d in b) delete b[d]
                    }, isReadyToRender: function () {
                        var a = this; return F || N != N.top || "complete" === r.readyState ? !0 : (r.attachEvent("onreadystatechange",
                            function () { r.detachEvent("onreadystatechange", a.firstRender); "complete" === r.readyState && a.firstRender() }), !1)
                    }, firstRender: function () { var a = this, b = a.options; if (a.isReadyToRender()) { a.getContainer(); p(a, "init"); a.resetMargins(); a.setChartSize(); a.propFromSeries(); a.getAxes(); n(b.series || [], function (b) { a.initSeries(b) }); a.linkSeries(); p(a, "beforeRender"); m && (a.pointer = new m(a, b)); a.render(); if (!a.renderer.imgCount && a.onload) a.onload(); a.cloneRenderTo(!0) } }, onload: function () {
                        n([this.callback].concat(this.callbacks),
                            function (a) { a && void 0 !== this.index && a.apply(this, [this]) }, this); p(this, "load"); p(this, "render"); c(this.index) && !1 !== this.options.chart.reflow && this.initReflow(); this.onload = null
                    }
            }
    })(L); (function (a) {
        var B, A = a.each, H = a.extend, G = a.erase, r = a.fireEvent, f = a.format, l = a.isArray, q = a.isNumber, k = a.pick, u = a.removeEvent; B = a.Point = function () { }; B.prototype = {
            init: function (a, c, f) {
                this.series = a; this.color = a.color; this.applyOptions(c, f); a.options.colorByPoint ? (c = a.options.colors || a.chart.options.colors, this.color = this.color ||
                    c[a.colorCounter], c = c.length, f = a.colorCounter, a.colorCounter++ , a.colorCounter === c && (a.colorCounter = 0)) : f = a.colorIndex; this.colorIndex = k(this.colorIndex, f); a.chart.pointCount++; return this
            }, applyOptions: function (a, c) {
                var d = this.series, f = d.options.pointValKey || d.pointValKey; a = B.prototype.optionsToObject.call(this, a); H(this, a); this.options = this.options ? H(this.options, a) : a; a.group && delete this.group; f && (this.y = this[f]); this.isNull = k(this.isValid && !this.isValid(), null === this.x || !q(this.y, !0)); this.selected &&
                    (this.state = "select"); "name" in this && void 0 === c && d.xAxis && d.xAxis.hasNames && (this.x = d.xAxis.nameToX(this)); void 0 === this.x && d && (this.x = void 0 === c ? d.autoIncrement(this) : c); return this
            }, optionsToObject: function (a) {
                var c = {}, d = this.series, f = d.options.keys, b = f || d.pointArrayMap || ["y"], p = b.length, h = 0, k = 0; if (q(a) || null === a) c[b[0]] = a; else if (l(a)) for (!f && a.length > p && (d = typeof a[0], "string" === d ? c.name = a[0] : "number" === d && (c.x = a[0]), h++); k < p;) f && void 0 === a[h] || (c[b[k]] = a[h]), h++ , k++; else "object" === typeof a &&
                    (c = a, a.dataLabels && (d._hasPointLabels = !0), a.marker && (d._hasPointMarkers = !0)); return c
            }, getClassName: function () { return "highcharts-point" + (this.selected ? " highcharts-point-select" : "") + (this.negative ? " highcharts-negative" : "") + (this.isNull ? " highcharts-null-point" : "") + (void 0 !== this.colorIndex ? " highcharts-color-" + this.colorIndex : "") + (this.options.className ? " " + this.options.className : "") + (this.zone && this.zone.className ? " " + this.zone.className.replace("highcharts-negative", "") : "") }, getZone: function () {
                var a =
                    this.series, c = a.zones, a = a.zoneAxis || "y", f = 0, k; for (k = c[f]; this[a] >= k.value;) k = c[++f]; k && k.color && !this.options.color && (this.color = k.color); return k
            }, destroy: function () { var a = this.series.chart, c = a.hoverPoints, f; a.pointCount--; c && (this.setState(), G(c, this), c.length || (a.hoverPoints = null)); if (this === a.hoverPoint) this.onMouseOut(); if (this.graphic || this.dataLabel) u(this), this.destroyElements(); this.legendItem && a.legend.destroyItem(this); for (f in this) this[f] = null }, destroyElements: function () {
                for (var a = ["graphic",
                    "dataLabel", "dataLabelUpper", "connector", "shadowGroup"], c, f = 6; f--;) c = a[f], this[c] && (this[c] = this[c].destroy())
            }, getLabelConfig: function () { return { x: this.category, y: this.y, color: this.color, colorIndex: this.colorIndex, key: this.name || this.category, series: this.series, point: this, percentage: this.percentage, total: this.total || this.stackTotal } }, tooltipFormatter: function (a) {
                var c = this.series, d = c.tooltipOptions, l = k(d.valueDecimals, ""), b = d.valuePrefix || "", p = d.valueSuffix || ""; A(c.pointArrayMap || ["y"], function (c) {
                    c =
                        "{point." + c; if (b || p) a = a.replace(c + "}", b + c + "}" + p); a = a.replace(c + "}", c + ":,." + l + "f}")
                }); return f(a, { point: this, series: this.series })
            }, firePointEvent: function (a, c, f) { var d = this, b = this.series.options; (b.point.events[a] || d.options && d.options.events && d.options.events[a]) && this.importEvents(); "click" === a && b.allowPointSelect && (f = function (a) { d.select && d.select(null, a.ctrlKey || a.metaKey || a.shiftKey) }); r(this, a, c, f) }, visible: !0
        }
    })(L); (function (a) {
        var B = a.addEvent, A = a.animObject, H = a.arrayMax, G = a.arrayMin, r = a.correctFloat,
            f = a.Date, l = a.defaultOptions, q = a.defaultPlotOptions, k = a.defined, u = a.each, d = a.erase, c = a.extend, n = a.fireEvent, z = a.grep, b = a.isArray, p = a.isNumber, h = a.isString, t = a.merge, D = a.pick, w = a.removeEvent, e = a.splat, x = a.SVGElement, C = a.syncTimeout, E = a.win; a.Series = a.seriesType("line", null, {
                lineWidth: 2, allowPointSelect: !1, showCheckbox: !1, animation: { duration: 1E3 }, events: {}, marker: {
                    lineWidth: 0, lineColor: "#ffffff", radius: 4, states: {
                        hover: { animation: { duration: 50 }, enabled: !0, radiusPlus: 2, lineWidthPlus: 1 }, select: {
                            fillColor: "#cccccc",
                            lineColor: "#000000", lineWidth: 2
                        }
                    }
                }, point: { events: {} }, dataLabels: { align: "center", formatter: function () { return null === this.y ? "" : a.numberFormat(this.y, -1) }, style: { fontSize: "11px", fontWeight: "bold", color: "contrast", textOutline: "1px contrast" }, verticalAlign: "bottom", x: 0, y: 0, padding: 5 }, cropThreshold: 300, pointRange: 0, softThreshold: !0, states: { hover: { animation: { duration: 50 }, lineWidthPlus: 1, marker: {}, halo: { size: 10, opacity: .25 } }, select: { marker: {} } }, stickyTracking: !0, turboThreshold: 1E3, findNearestPointBy: "x"
            },
                {
                    isCartesian: !0, pointClass: a.Point, sorted: !0, requireSorting: !0, directTouch: !1, axisTypes: ["xAxis", "yAxis"], colorCounter: 0, parallelArrays: ["x", "y"], coll: "series", init: function (a, b) {
                        var e = this, d, m, g = a.series, h; e.chart = a; e.options = b = e.setOptions(b); e.linkedSeries = []; e.bindAxes(); c(e, { name: b.name, state: "", visible: !1 !== b.visible, selected: !0 === b.selected }); m = b.events; for (d in m) B(e, d, m[d]); if (m && m.click || b.point && b.point.events && b.point.events.click || b.allowPointSelect) a.runTrackerClick = !0; e.getColor();
                        e.getSymbol(); u(e.parallelArrays, function (a) { e[a + "Data"] = [] }); e.setData(b.data, !1); e.isCartesian && (a.hasCartesianSeries = !0); g.length && (h = g[g.length - 1]); e._i = D(h && h._i, -1) + 1; a.orderSeries(this.insert(g))
                    }, insert: function (a) { var b = this.options.index, c; if (p(b)) { for (c = a.length; c--;) if (b >= D(a[c].options.index, a[c]._i)) { a.splice(c + 1, 0, this); break } -1 === c && a.unshift(this); c += 1 } else a.push(this); return D(c, a.length - 1) }, bindAxes: function () {
                        var b = this, c = b.options, e = b.chart, d; u(b.axisTypes || [], function (m) {
                            u(e[m],
                                function (a) { d = a.options; if (c[m] === d.index || void 0 !== c[m] && c[m] === d.id || void 0 === c[m] && 0 === d.index) b.insert(a.series), b[m] = a, a.isDirty = !0 }); b[m] || b.optionalAxis === m || a.error(18, !0)
                        })
                    }, updateParallelArrays: function (a, b) { var c = a.series, e = arguments, d = p(b) ? function (e) { var g = "y" === e && c.toYData ? c.toYData(a) : a[e]; c[e + "Data"][b] = g } : function (a) { Array.prototype[b].apply(c[a + "Data"], Array.prototype.slice.call(e, 2)) }; u(c.parallelArrays, d) }, autoIncrement: function () {
                        var a = this.options, b = this.xIncrement, c, e = a.pointIntervalUnit,
                            b = D(b, a.pointStart, 0); this.pointInterval = c = D(this.pointInterval, a.pointInterval, 1); e && (a = new f(b), "day" === e ? a = +a[f.hcSetDate](a[f.hcGetDate]() + c) : "month" === e ? a = +a[f.hcSetMonth](a[f.hcGetMonth]() + c) : "year" === e && (a = +a[f.hcSetFullYear](a[f.hcGetFullYear]() + c)), c = a - b); this.xIncrement = b + c; return b
                    }, setOptions: function (a) {
                        var b = this.chart, c = b.options.plotOptions, b = b.userOptions || {}, e = b.plotOptions || {}, d = c[this.type]; this.userOptions = a; c = t(d, c.series, a); this.tooltipOptions = t(l.tooltip, l.plotOptions[this.type].tooltip,
                            b.tooltip, e.series && e.series.tooltip, e[this.type] && e[this.type].tooltip, a.tooltip); this.stickyTracking = D(a.stickyTracking, e[this.type] && e[this.type].stickyTracking, e.series && e.series.stickyTracking, this.tooltipOptions.shared && !this.noSharedTooltip ? !0 : c.stickyTracking); null === d.marker && delete c.marker; this.zoneAxis = c.zoneAxis; a = this.zones = (c.zones || []).slice(); !c.negativeColor && !c.negativeFillColor || c.zones || a.push({
                                value: c[this.zoneAxis + "Threshold"] || c.threshold || 0, className: "highcharts-negative",
                                color: c.negativeColor, fillColor: c.negativeFillColor
                            }); a.length && k(a[a.length - 1].value) && a.push({ color: this.color, fillColor: this.fillColor }); return c
                    }, getCyclic: function (a, b, c) { var e, d = this.chart, g = this.userOptions, m = a + "Index", h = a + "Counter", f = c ? c.length : D(d.options.chart[a + "Count"], d[a + "Count"]); b || (e = D(g[m], g["_" + m]), k(e) || (d.series.length || (d[h] = 0), g["_" + m] = e = d[h] % f, d[h] += 1), c && (b = c[e])); void 0 !== e && (this[m] = e); this[a] = b }, getColor: function () {
                        this.options.colorByPoint ? this.options.color = null : this.getCyclic("color",
                            this.options.color || q[this.type].color, this.chart.options.colors)
                    }, getSymbol: function () { this.getCyclic("symbol", this.options.marker.symbol, this.chart.options.symbols) }, drawLegendSymbol: a.LegendSymbolMixin.drawLineMarker, setData: function (c, e, d, f) {
                        var m = this, g = m.points, k = g && g.length || 0, n, l = m.options, y = m.chart, t = null, q = m.xAxis, x = l.turboThreshold, r = this.xData, w = this.yData, C = (n = m.pointArrayMap) && n.length; c = c || []; n = c.length; e = D(e, !0); if (!1 !== f && n && k === n && !m.cropped && !m.hasGroupedData && m.visible) u(c, function (a,
                            b) { g[b].update && a !== l.data[b] && g[b].update(a, !1, null, !1) }); else {
                            m.xIncrement = null; m.colorCounter = 0; u(this.parallelArrays, function (a) { m[a + "Data"].length = 0 }); if (x && n > x) { for (d = 0; null === t && d < n;) t = c[d], d++; if (p(t)) for (d = 0; d < n; d++) r[d] = this.autoIncrement(), w[d] = c[d]; else if (b(t)) if (C) for (d = 0; d < n; d++) t = c[d], r[d] = t[0], w[d] = t.slice(1, C + 1); else for (d = 0; d < n; d++) t = c[d], r[d] = t[0], w[d] = t[1]; else a.error(12) } else for (d = 0; d < n; d++) void 0 !== c[d] && (t = { series: m }, m.pointClass.prototype.applyOptions.apply(t, [c[d]]), m.updateParallelArrays(t,
                                d)); h(w[0]) && a.error(14, !0); m.data = []; m.options.data = m.userOptions.data = c; for (d = k; d--;) g[d] && g[d].destroy && g[d].destroy(); q && (q.minRange = q.userMinRange); m.isDirty = y.isDirtyBox = !0; m.isDirtyData = !!g; d = !1
                        } "point" === l.legendType && (this.processData(), this.generatePoints()); e && y.redraw(d)
                    }, processData: function (b) {
                        var c = this.xData, e = this.yData, d = c.length, m; m = 0; var g, h, f = this.xAxis, p, k = this.options; p = k.cropThreshold; var n = this.getExtremesFromAll || k.getExtremesFromAll, l = this.isCartesian, k = f && f.val2lin, t = f &&
                            f.isLog, q, x; if (l && !this.isDirty && !f.isDirty && !this.yAxis.isDirty && !b) return !1; f && (b = f.getExtremes(), q = b.min, x = b.max); if (l && this.sorted && !n && (!p || d > p || this.forceCrop)) if (c[d - 1] < q || c[0] > x) c = [], e = []; else if (c[0] < q || c[d - 1] > x) m = this.cropData(this.xData, this.yData, q, x), c = m.xData, e = m.yData, m = m.start, g = !0; for (p = c.length || 1; --p;) d = t ? k(c[p]) - k(c[p - 1]) : c[p] - c[p - 1], 0 < d && (void 0 === h || d < h) ? h = d : 0 > d && this.requireSorting && a.error(15); this.cropped = g; this.cropStart = m; this.processedXData = c; this.processedYData = e; this.closestPointRange =
                                h
                    }, cropData: function (a, b, c, e) { var d = a.length, g = 0, m = d, h = D(this.cropShoulder, 1), f; for (f = 0; f < d; f++) if (a[f] >= c) { g = Math.max(0, f - h); break } for (c = f; c < d; c++) if (a[c] > e) { m = c + h; break } return { xData: a.slice(g, m), yData: b.slice(g, m), start: g, end: m } }, generatePoints: function () {
                        var a = this.options.data, b = this.data, c, d = this.processedXData, h = this.processedYData, g = this.pointClass, f = d.length, p = this.cropStart || 0, k, n = this.hasGroupedData, l, t = [], q; b || n || (b = [], b.length = a.length, b = this.data = b); for (q = 0; q < f; q++) k = p + q, n ? (l = (new g).init(this,
                            [d[q]].concat(e(h[q]))), l.dataGroup = this.groupMap[q]) : (l = b[k]) || void 0 === a[k] || (b[k] = l = (new g).init(this, a[k], d[q])), l && (l.index = k, t[q] = l); if (b && (f !== (c = b.length) || n)) for (q = 0; q < c; q++) q !== p || n || (q += f), b[q] && (b[q].destroyElements(), b[q].plotX = void 0); this.data = b; this.points = t
                    }, getExtremes: function (a) {
                        var c = this.yAxis, e = this.processedXData, d, m = [], g = 0; d = this.xAxis.getExtremes(); var h = d.min, f = d.max, k, n, l, t; a = a || this.stackedYData || this.processedYData || []; d = a.length; for (t = 0; t < d; t++) if (n = e[t], l = a[t], k = (p(l,
                            !0) || b(l)) && (!c.positiveValuesOnly || l.length || 0 < l), n = this.getExtremesFromAll || this.options.getExtremesFromAll || this.cropped || (e[t] || n) >= h && (e[t] || n) <= f, k && n) if (k = l.length) for (; k--;) null !== l[k] && (m[g++] = l[k]); else m[g++] = l; this.dataMin = G(m); this.dataMax = H(m)
                    }, translate: function () {
                        this.processedXData || this.processData(); this.generatePoints(); var a = this.options, b = a.stacking, c = this.xAxis, e = c.categories, d = this.yAxis, g = this.points, h = g.length, f = !!this.modifyValue, n = a.pointPlacement, l = "between" === n || p(n),
                            t = a.threshold, q = a.startFromThreshold ? t : 0, x, u, w, C, E = Number.MAX_VALUE; "between" === n && (n = .5); p(n) && (n *= D(a.pointRange || c.pointRange)); for (a = 0; a < h; a++) {
                                var z = g[a], A = z.x, B = z.y; u = z.low; var H = b && d.stacks[(this.negStacks && B < (q ? 0 : t) ? "-" : "") + this.stackKey], G; d.positiveValuesOnly && null !== B && 0 >= B && (z.isNull = !0); z.plotX = x = r(Math.min(Math.max(-1E5, c.translate(A, 0, 0, 0, 1, n, "flags" === this.type)), 1E5)); b && this.visible && !z.isNull && H && H[A] && (C = this.getStackIndicator(C, A, this.index), G = H[A], B = G.points[C.key], u = B[0], B =
                                    B[1], u === q && C.key === H[A].base && (u = D(t, d.min)), d.positiveValuesOnly && 0 >= u && (u = null), z.total = z.stackTotal = G.total, z.percentage = G.total && z.y / G.total * 100, z.stackY = B, G.setOffset(this.pointXOffset || 0, this.barW || 0)); z.yBottom = k(u) ? d.translate(u, 0, 1, 0, 1) : null; f && (B = this.modifyValue(B, z)); z.plotY = u = "number" === typeof B && Infinity !== B ? Math.min(Math.max(-1E5, d.translate(B, 0, 1, 0, 1)), 1E5) : void 0; z.isInside = void 0 !== u && 0 <= u && u <= d.len && 0 <= x && x <= c.len; z.clientX = l ? r(c.translate(A, 0, 0, 0, 1, n)) : x; z.negative = z.y < (t || 0);
                                z.category = e && void 0 !== e[z.x] ? e[z.x] : z.x; z.isNull || (void 0 !== w && (E = Math.min(E, Math.abs(x - w))), w = x); z.zone = this.zones.length && z.getZone()
                            } this.closestPointRangePx = E
                    }, getValidPoints: function (a, b) { var c = this.chart; return z(a || this.points || [], function (a) { return b && !c.isInsidePlot(a.plotX, a.plotY, c.inverted) ? !1 : !a.isNull }) }, setClip: function (a) {
                        var b = this.chart, c = this.options, e = b.renderer, d = b.inverted, g = this.clipBox, h = g || b.clipBox, m = this.sharedClipKey || ["_sharedClip", a && a.duration, a && a.easing, h.height,
                            c.xAxis, c.yAxis].join(), f = b[m], p = b[m + "m"]; f || (a && (h.width = 0, b[m + "m"] = p = e.clipRect(-99, d ? -b.plotLeft : -b.plotTop, 99, d ? b.chartWidth : b.chartHeight)), b[m] = f = e.clipRect(h), f.count = { length: 0 }); a && !f.count[this.index] && (f.count[this.index] = !0, f.count.length += 1); !1 !== c.clip && (this.group.clip(a || g ? f : b.clipRect), this.markerGroup.clip(p), this.sharedClipKey = m); a || (f.count[this.index] && (delete f.count[this.index], --f.count.length), 0 === f.count.length && m && b[m] && (g || (b[m] = b[m].destroy()), b[m + "m"] && (b[m + "m"] = b[m + "m"].destroy())))
                    },
                    animate: function (a) { var b = this.chart, c = A(this.options.animation), e; a ? this.setClip(c) : (e = this.sharedClipKey, (a = b[e]) && a.animate({ width: b.plotSizeX }, c), b[e + "m"] && b[e + "m"].animate({ width: b.plotSizeX + 99 }, c), this.animate = null) }, afterAnimate: function () { this.setClip(); n(this, "afterAnimate") }, drawPoints: function () {
                        var a = this.points, b = this.chart, c, e, d, g, h = this.options.marker, f, n, k, l, t = this.markerGroup, q = D(h.enabled, this.xAxis.isRadial ? !0 : null, this.closestPointRangePx >= 2 * h.radius); if (!1 !== h.enabled || this._hasPointMarkers) for (e =
                            0; e < a.length; e++) d = a[e], c = d.plotY, g = d.graphic, f = d.marker || {}, n = !!d.marker, k = q && void 0 === f.enabled || f.enabled, l = d.isInside, k && p(c) && null !== d.y ? (c = D(f.symbol, this.symbol), d.hasImage = 0 === c.indexOf("url"), k = this.markerAttribs(d, d.selected && "select"), g ? g[l ? "show" : "hide"](!0).animate(k) : l && (0 < k.width || d.hasImage) && (d.graphic = g = b.renderer.symbol(c, k.x, k.y, k.width, k.height, n ? f : h).add(t)), g && g.attr(this.pointAttribs(d, d.selected && "select")), g && g.addClass(d.getClassName(), !0)) : g && (d.graphic = g.destroy())
                    }, markerAttribs: function (a,
                        b) { var c = this.options.marker, e = a.marker || {}, d = D(e.radius, c.radius); b && (c = c.states[b], b = e.states && e.states[b], d = D(b && b.radius, c && c.radius, d + (c && c.radiusPlus || 0))); a.hasImage && (d = 0); a = { x: Math.floor(a.plotX) - d, y: a.plotY - d }; d && (a.width = a.height = 2 * d); return a }, pointAttribs: function (a, b) {
                            var c = this.options.marker, e = a && a.options, d = e && e.marker || {}, g = this.color, h = e && e.color, f = a && a.color, e = D(d.lineWidth, c.lineWidth); a = a && a.zone && a.zone.color; g = h || a || f || g; a = d.fillColor || c.fillColor || g; g = d.lineColor || c.lineColor ||
                                g; b && (c = c.states[b], b = d.states && d.states[b] || {}, e = D(b.lineWidth, c.lineWidth, e + D(b.lineWidthPlus, c.lineWidthPlus, 0)), a = b.fillColor || c.fillColor || a, g = b.lineColor || c.lineColor || g); return { stroke: g, "stroke-width": e, fill: a }
                        }, destroy: function () {
                            var a = this, b = a.chart, c = /AppleWebKit\/533/.test(E.navigator.userAgent), e, h = a.data || [], g, f, k; n(a, "destroy"); w(a); u(a.axisTypes || [], function (b) { (k = a[b]) && k.series && (d(k.series, a), k.isDirty = k.forceRedraw = !0) }); a.legendItem && a.chart.legend.destroyItem(a); for (e = h.length; e--;) (g =
                                h[e]) && g.destroy && g.destroy(); a.points = null; clearTimeout(a.animationTimeout); for (f in a) a[f] instanceof x && !a[f].survive && (e = c && "group" === f ? "hide" : "destroy", a[f][e]()); b.hoverSeries === a && (b.hoverSeries = null); d(b.series, a); b.orderSeries(); for (f in a) delete a[f]
                        }, getGraphPath: function (a, b, c) {
                            var e = this, d = e.options, g = d.step, h, f = [], m = [], p; a = a || e.points; (h = a.reversed) && a.reverse(); (g = { right: 1, center: 2 }[g] || g && 3) && h && (g = 4 - g); !d.connectNulls || b || c || (a = this.getValidPoints(a)); u(a, function (h, n) {
                                var l = h.plotX,
                                    t = h.plotY, q = a[n - 1]; (h.leftCliff || q && q.rightCliff) && !c && (p = !0); h.isNull && !k(b) && 0 < n ? p = !d.connectNulls : h.isNull && !b ? p = !0 : (0 === n || p ? n = ["M", h.plotX, h.plotY] : e.getPointSpline ? n = e.getPointSpline(a, h, n) : g ? (n = 1 === g ? ["L", q.plotX, t] : 2 === g ? ["L", (q.plotX + l) / 2, q.plotY, "L", (q.plotX + l) / 2, t] : ["L", l, q.plotY], n.push("L", l, t)) : n = ["L", l, t], m.push(h.x), g && m.push(h.x), f.push.apply(f, n), p = !1)
                            }); f.xMap = m; return e.graphPath = f
                        }, drawGraph: function () {
                            var a = this, b = this.options, c = (this.gappedPath || this.getGraphPath).call(this),
                                e = [["graph", "highcharts-graph", b.lineColor || this.color, b.dashStyle]]; u(this.zones, function (c, d) { e.push(["zone-graph-" + d, "highcharts-graph highcharts-zone-graph-" + d + " " + (c.className || ""), c.color || a.color, c.dashStyle || b.dashStyle]) }); u(e, function (e, d) {
                                    var g = e[0], h = a[g]; h ? (h.endX = c.xMap, h.animate({ d: c })) : c.length && (a[g] = a.chart.renderer.path(c).addClass(e[1]).attr({ zIndex: 1 }).add(a.group), h = { stroke: e[2], "stroke-width": b.lineWidth, fill: a.fillGraph && a.color || "none" }, e[3] ? h.dashstyle = e[3] : "square" !== b.linecap &&
                                        (h["stroke-linecap"] = h["stroke-linejoin"] = "round"), h = a[g].attr(h).shadow(2 > d && b.shadow)); h && (h.startX = c.xMap, h.isArea = c.isArea)
                                })
                        }, applyZones: function () {
                            var a = this, b = this.chart, c = b.renderer, e = this.zones, d, g, h = this.clips || [], f, k = this.graph, p = this.area, n = Math.max(b.chartWidth, b.chartHeight), l = this[(this.zoneAxis || "y") + "Axis"], t, q, x = b.inverted, w, r, C, E, z = !1; e.length && (k || p) && l && void 0 !== l.min && (q = l.reversed, w = l.horiz, k && k.hide(), p && p.hide(), t = l.getExtremes(), u(e, function (e, m) {
                                d = q ? w ? b.plotWidth : 0 : w ? 0 :
                                    l.toPixels(t.min); d = Math.min(Math.max(D(g, d), 0), n); g = Math.min(Math.max(Math.round(l.toPixels(D(e.value, t.max), !0)), 0), n); z && (d = g = l.toPixels(t.max)); r = Math.abs(d - g); C = Math.min(d, g); E = Math.max(d, g); l.isXAxis ? (f = { x: x ? E : C, y: 0, width: r, height: n }, w || (f.x = b.plotHeight - f.x)) : (f = { x: 0, y: x ? E : C, width: n, height: r }, w && (f.y = b.plotWidth - f.y)); x && c.isVML && (f = l.isXAxis ? { x: 0, y: q ? C : E, height: f.width, width: b.chartWidth } : { x: f.y - b.plotLeft - b.spacingBox.x, y: 0, width: f.height, height: b.chartHeight }); h[m] ? h[m].animate(f) : (h[m] =
                                        c.clipRect(f), k && a["zone-graph-" + m].clip(h[m]), p && a["zone-area-" + m].clip(h[m])); z = e.value > t.max
                            }), this.clips = h)
                        }, invertGroups: function (a) { function b() { u(["group", "markerGroup"], function (b) { c[b] && (e.renderer.isVML && c[b].attr({ width: c.yAxis.len, height: c.xAxis.len }), c[b].width = c.yAxis.len, c[b].height = c.xAxis.len, c[b].invert(a)) }) } var c = this, e = c.chart, d; c.xAxis && (d = B(e, "resize", b), B(c, "destroy", d), b(a), c.invertGroups = b) }, plotGroup: function (a, b, c, e, d) {
                            var g = this[a], h = !g; h && (this[a] = g = this.chart.renderer.g(b).attr({
                                zIndex: e ||
                                    .1
                            }).add(d), g.addClass("highcharts-series-" + this.index + " highcharts-" + this.type + "-series highcharts-color-" + this.colorIndex + " " + (this.options.className || ""))); g.attr({ visibility: c })[h ? "attr" : "animate"](this.getPlotBox()); return g
                        }, getPlotBox: function () { var a = this.chart, b = this.xAxis, c = this.yAxis; a.inverted && (b = c, c = this.xAxis); return { translateX: b ? b.left : a.plotLeft, translateY: c ? c.top : a.plotTop, scaleX: 1, scaleY: 1 } }, render: function () {
                            var a = this, b = a.chart, c, e = a.options, d = !!a.animate && b.renderer.isSVG && A(e.animation).duration,
                                g = a.visible ? "inherit" : "hidden", h = e.zIndex, f = a.hasRendered, k = b.seriesGroup, p = b.inverted; c = a.plotGroup("group", "series", g, h, k); a.markerGroup = a.plotGroup("markerGroup", "markers", g, h, k); d && a.animate(!0); c.inverted = a.isCartesian ? p : !1; a.drawGraph && (a.drawGraph(), a.applyZones()); a.drawDataLabels && a.drawDataLabels(); a.visible && a.drawPoints(); a.drawTracker && !1 !== a.options.enableMouseTracking && a.drawTracker(); a.invertGroups(p); !1 === e.clip || a.sharedClipKey || f || c.clip(b.clipRect); d && a.animate(); f || (a.animationTimeout =
                                    C(function () { a.afterAnimate() }, d)); a.isDirty = !1; a.hasRendered = !0
                        }, redraw: function () { var a = this.chart, b = this.isDirty || this.isDirtyData, c = this.group, e = this.xAxis, d = this.yAxis; c && (a.inverted && c.attr({ width: a.plotWidth, height: a.plotHeight }), c.animate({ translateX: D(e && e.left, a.plotLeft), translateY: D(d && d.top, a.plotTop) })); this.translate(); this.render(); b && delete this.kdTree }, kdAxisArray: ["clientX", "plotY"], searchPoint: function (a, b) {
                            var c = this.xAxis, e = this.yAxis, d = this.chart.inverted; return this.searchKDTree({
                                clientX: d ?
                                    c.len - a.chartY + c.pos : a.chartX - c.pos, plotY: d ? e.len - a.chartX + e.pos : a.chartY - e.pos
                            }, b)
                        }, buildKDTree: function () {
                            function a(c, e, d) { var g, h; if (h = c && c.length) return g = b.kdAxisArray[e % d], c.sort(function (a, b) { return a[g] - b[g] }), h = Math.floor(h / 2), { point: c[h], left: a(c.slice(0, h), e + 1, d), right: a(c.slice(h + 1), e + 1, d) } } this.buildingKdTree = !0; var b = this, c = -1 < b.options.findNearestPointBy.indexOf("y") ? 2 : 1; delete b.kdTree; C(function () { b.kdTree = a(b.getValidPoints(null, !b.directTouch), c, c); b.buildingKdTree = !1 }, b.options.kdNow ?
                                0 : 1)
                        }, searchKDTree: function (a, b) {
                            function c(a, b, f, m) { var p = b.point, n = e.kdAxisArray[f % m], l, t, q = p; t = k(a[d]) && k(p[d]) ? Math.pow(a[d] - p[d], 2) : null; l = k(a[g]) && k(p[g]) ? Math.pow(a[g] - p[g], 2) : null; l = (t || 0) + (l || 0); p.dist = k(l) ? Math.sqrt(l) : Number.MAX_VALUE; p.distX = k(t) ? Math.sqrt(t) : Number.MAX_VALUE; n = a[n] - p[n]; l = 0 > n ? "left" : "right"; t = 0 > n ? "right" : "left"; b[l] && (l = c(a, b[l], f + 1, m), q = l[h] < q[h] ? l : p); b[t] && Math.sqrt(n * n) < q[h] && (a = c(a, b[t], f + 1, m), q = a[h] < q[h] ? a : q); return q } var e = this, d = this.kdAxisArray[0], g = this.kdAxisArray[1],
                                h = b ? "distX" : "dist"; b = -1 < e.options.findNearestPointBy.indexOf("y") ? 2 : 1; this.kdTree || this.buildingKdTree || this.buildKDTree(); if (this.kdTree) return c(a, this.kdTree, b, b)
                        }
                })
    })(L); (function (a) {
        function B(a, d, c, f, l) {
            var b = a.chart.inverted; this.axis = a; this.isNegative = c; this.options = d; this.x = f; this.total = null; this.points = {}; this.stack = l; this.rightCliff = this.leftCliff = 0; this.alignOptions = {
                align: d.align || (b ? c ? "left" : "right" : "center"), verticalAlign: d.verticalAlign || (b ? "middle" : c ? "bottom" : "top"), y: k(d.y, b ? 4 : c ?
                    14 : -6), x: k(d.x, b ? c ? -6 : 6 : 0)
            }; this.textAlign = d.textAlign || (b ? c ? "right" : "left" : "center")
        } var A = a.Axis, H = a.Chart, G = a.correctFloat, r = a.defined, f = a.destroyObjectProperties, l = a.each, q = a.format, k = a.pick; a = a.Series; B.prototype = {
            destroy: function () { f(this, this.axis) }, render: function (a) {
                var d = this.options, c = d.format, c = c ? q(c, this) : d.formatter.call(this); this.label ? this.label.attr({ text: c, visibility: "hidden" }) : this.label = this.axis.chart.renderer.text(c, null, null, d.useHTML).css(d.style).attr({
                    align: this.textAlign,
                    rotation: d.rotation, visibility: "hidden"
                }).add(a)
            }, setOffset: function (a, d) { var c = this.axis, f = c.chart, k = f.inverted, b = c.reversed, b = this.isNegative && !b || !this.isNegative && b, p = c.translate(c.usePercentage ? 100 : this.total, 0, 0, 0, 1), c = c.translate(0), c = Math.abs(p - c); a = f.xAxis[0].translate(this.x) + a; var h = f.plotHeight, k = { x: k ? b ? p : p - c : a, y: k ? h - a - d : b ? h - p - c : h - p, width: k ? c : d, height: k ? d : c }; if (d = this.label) d.align(this.alignOptions, null, k), k = d.alignAttr, d[!1 === this.options.crop || f.isInsidePlot(k.x, k.y) ? "show" : "hide"](!0) }
        };
        H.prototype.getStacks = function () { var a = this; l(a.yAxis, function (a) { a.stacks && a.hasVisibleSeries && (a.oldStacks = a.stacks) }); l(a.series, function (d) { !d.options.stacking || !0 !== d.visible && !1 !== a.options.chart.ignoreHiddenSeries || (d.stackKey = d.type + k(d.options.stack, "")) }) }; A.prototype.buildStacks = function () {
            var a = this.series, d, c = k(this.options.reversedStacks, !0), f = a.length, l; if (!this.isXAxis) {
                this.usePercentage = !1; for (l = f; l--;) a[c ? l : f - l - 1].setStackedPoints(); for (l = f; l--;) d = a[c ? l : f - l - 1], d.setStackCliffs &&
                    d.setStackCliffs(); if (this.usePercentage) for (l = 0; l < f; l++) a[l].setPercentStacks()
            }
        }; A.prototype.renderStackTotals = function () { var a = this.chart, d = a.renderer, c = this.stacks, f, k, b = this.stackTotalGroup; b || (this.stackTotalGroup = b = d.g("stack-labels").attr({ visibility: "visible", zIndex: 6 }).add()); b.translate(a.plotLeft, a.plotTop); for (f in c) for (k in a = c[f], a) a[k].render(b) }; A.prototype.resetStacks = function () {
            var a = this.stacks, d, c; if (!this.isXAxis) for (d in a) for (c in a[d]) a[d][c].touched < this.stacksTouched ? (a[d][c].destroy(),
                delete a[d][c]) : (a[d][c].total = null, a[d][c].cum = null)
        }; A.prototype.cleanStacks = function () { var a, d, c; if (!this.isXAxis) for (d in this.oldStacks && (a = this.stacks = this.oldStacks), a) for (c in a[d]) a[d][c].cum = a[d][c].total }; a.prototype.setStackedPoints = function () {
            if (this.options.stacking && (!0 === this.visible || !1 === this.chart.options.chart.ignoreHiddenSeries)) {
                var a = this.processedXData, d = this.processedYData, c = [], f = d.length, l = this.options, b = l.threshold, p = l.startFromThreshold ? b : 0, h = l.stack, l = l.stacking, t = this.stackKey,
                    q = "-" + t, w = this.negStacks, e = this.yAxis, x = e.stacks, C = e.oldStacks, E, m, y, A, K, J, g; e.stacksTouched += 1; for (K = 0; K < f; K++) J = a[K], g = d[K], E = this.getStackIndicator(E, J, this.index), A = E.key, y = (m = w && g < (p ? 0 : b)) ? q : t, x[y] || (x[y] = {}), x[y][J] || (C[y] && C[y][J] ? (x[y][J] = C[y][J], x[y][J].total = null) : x[y][J] = new B(e, e.options.stackLabels, m, J, h)), y = x[y][J], null !== g && (y.points[A] = y.points[this.index] = [k(y.cum, p)], r(y.cum) || (y.base = A), y.touched = e.stacksTouched, 0 < E.index && !1 === this.singleStacks && (y.points[A][0] = y.points[this.index +
                        "," + J + ",0"][0])), "percent" === l ? (m = m ? t : q, w && x[m] && x[m][J] ? (m = x[m][J], y.total = m.total = Math.max(m.total, y.total) + Math.abs(g) || 0) : y.total = G(y.total + (Math.abs(g) || 0))) : y.total = G(y.total + (g || 0)), y.cum = k(y.cum, p) + (g || 0), null !== g && (y.points[A].push(y.cum), c[K] = y.cum); "percent" === l && (e.usePercentage = !0); this.stackedYData = c; e.oldStacks = {}
            }
        }; a.prototype.setPercentStacks = function () {
            var a = this, d = a.stackKey, c = a.yAxis.stacks, f = a.processedXData, k; l([d, "-" + d], function (b) {
                for (var d = f.length, h, n; d--;) if (h = f[d], k = a.getStackIndicator(k,
                    h, a.index, b), h = (n = c[b] && c[b][h]) && n.points[k.key]) n = n.total ? 100 / n.total : 0, h[0] = G(h[0] * n), h[1] = G(h[1] * n), a.stackedYData[d] = h[1]
            })
        }; a.prototype.getStackIndicator = function (a, d, c, f) { !r(a) || a.x !== d || f && a.key !== f ? a = { x: d, index: 0, key: f } : a.index++; a.key = [c, d, a.index].join(); return a }
    })(L); (function (a) {
        var B = a.addEvent, A = a.animate, H = a.Axis, G = a.createElement, r = a.css, f = a.defined, l = a.each, q = a.erase, k = a.extend, u = a.fireEvent, d = a.inArray, c = a.isNumber, n = a.isObject, z = a.merge, b = a.pick, p = a.Point, h = a.Series, t = a.seriesTypes,
            D = a.setAnimation, w = a.splat; k(a.Chart.prototype, {
                addSeries: function (a, c, d) { var e, h = this; a && (c = b(c, !0), u(h, "addSeries", { options: a }, function () { e = h.initSeries(a); h.isDirtyLegend = !0; h.linkSeries(); c && h.redraw(d) })); return e }, addAxis: function (a, c, d, h) { var e = c ? "xAxis" : "yAxis", f = this.options; a = z(a, { index: this[e].length, isX: c }); new H(this, a); f[e] = w(f[e] || {}); f[e].push(a); b(d, !0) && this.redraw(h) }, showLoading: function (a) {
                    var b = this, c = b.options, e = b.loadingDiv, d = c.loading, h = function () {
                        e && r(e, {
                            left: b.plotLeft +
                                "px", top: b.plotTop + "px", width: b.plotWidth + "px", height: b.plotHeight + "px"
                        })
                    }; e || (b.loadingDiv = e = G("div", { className: "highcharts-loading highcharts-loading-hidden" }, null, b.container), b.loadingSpan = G("span", { className: "highcharts-loading-inner" }, null, e), B(b, "redraw", h)); e.className = "highcharts-loading"; b.loadingSpan.innerHTML = a || c.lang.loading; r(e, k(d.style, { zIndex: 10 })); r(b.loadingSpan, d.labelStyle); b.loadingShown || (r(e, { opacity: 0, display: "" }), A(e, { opacity: d.style.opacity || .5 }, {
                        duration: d.showDuration ||
                            0
                    })); b.loadingShown = !0; h()
                }, hideLoading: function () { var a = this.options, b = this.loadingDiv; b && (b.className = "highcharts-loading highcharts-loading-hidden", A(b, { opacity: 0 }, { duration: a.loading.hideDuration || 100, complete: function () { r(b, { display: "none" }) } })); this.loadingShown = !1 }, propsRequireDirtyBox: "backgroundColor borderColor borderWidth margin marginTop marginRight marginBottom marginLeft spacing spacingTop spacingRight spacingBottom spacingLeft borderRadius plotBackgroundColor plotBackgroundImage plotBorderColor plotBorderWidth plotShadow shadow".split(" "),
                propsRequireUpdateSeries: "chart.inverted chart.polar chart.ignoreHiddenSeries chart.type colors plotOptions".split(" "), update: function (a, h) {
                    var e, k = { credits: "addCredits", title: "setTitle", subtitle: "setSubtitle" }, m = a.chart, p, n; if (m) {
                        z(!0, this.options.chart, m); "className" in m && this.setClassName(m.className); if ("inverted" in m || "polar" in m) this.propFromSeries(), p = !0; "alignTicks" in m && (p = !0); for (e in m) m.hasOwnProperty(e) && (-1 !== d("chart." + e, this.propsRequireUpdateSeries) && (n = !0), -1 !== d(e, this.propsRequireDirtyBox) &&
                            (this.isDirtyBox = !0)); "style" in m && this.renderer.setStyle(m.style)
                    } for (e in a) { if (this[e] && "function" === typeof this[e].update) this[e].update(a[e], !1); else if ("function" === typeof this[k[e]]) this[k[e]](a[e]); "chart" !== e && -1 !== d(e, this.propsRequireUpdateSeries) && (n = !0) } a.colors && (this.options.colors = a.colors); a.plotOptions && z(!0, this.options.plotOptions, a.plotOptions); l(["xAxis", "yAxis", "series", "colorAxis", "pane"], function (b) {
                        a[b] && l(w(a[b]), function (a, c) {
                            (c = f(a.id) && this.get(a.id) || this[b][c]) && c.coll ===
                                b && c.update(a, !1)
                        }, this)
                    }, this); p && l(this.axes, function (a) { a.update({}, !1) }); n && l(this.series, function (a) { a.update({}, !1) }); a.loading && z(!0, this.options.loading, a.loading); e = m && m.width; m = m && m.height; c(e) && e !== this.chartWidth || c(m) && m !== this.chartHeight ? this.setSize(e, m) : b(h, !0) && this.redraw()
                }, setSubtitle: function (a) { this.setTitle(void 0, a) }
            }); k(p.prototype, {
                update: function (a, c, d, h) {
                    function e() {
                        f.applyOptions(a); null === f.y && p && (f.graphic = p.destroy()); n(a, !0) && (p && p.element && a && a.marker && a.marker.symbol &&
                            (f.graphic = p.destroy()), a && a.dataLabels && f.dataLabel && (f.dataLabel = f.dataLabel.destroy())); l = f.index; k.updateParallelArrays(f, l); t.data[l] = n(t.data[l], !0) || n(a, !0) ? f.options : a; k.isDirty = k.isDirtyData = !0; !k.fixedBox && k.hasCartesianSeries && (g.isDirtyBox = !0); "point" === t.legendType && (g.isDirtyLegend = !0); c && g.redraw(d)
                    } var f = this, k = f.series, p = f.graphic, l, g = k.chart, t = k.options; c = b(c, !0); !1 === h ? e() : f.firePointEvent("update", { options: a }, e)
                }, remove: function (a, b) {
                    this.series.removePoint(d(this, this.series.data),
                        a, b)
                }
            }); k(h.prototype, {
                addPoint: function (a, c, d, h) {
                    var e = this.options, f = this.data, k = this.chart, p = this.xAxis, p = p && p.hasNames && p.names, n = e.data, g, l, t = this.xData, q, w; c = b(c, !0); g = { series: this }; this.pointClass.prototype.applyOptions.apply(g, [a]); w = g.x; q = t.length; if (this.requireSorting && w < t[q - 1]) for (l = !0; q && t[q - 1] > w;) q--; this.updateParallelArrays(g, "splice", q, 0, 0); this.updateParallelArrays(g, q); p && g.name && (p[w] = g.name); n.splice(q, 0, a); l && (this.data.splice(q, 0, null), this.processData()); "point" === e.legendType &&
                        this.generatePoints(); d && (f[0] && f[0].remove ? f[0].remove(!1) : (f.shift(), this.updateParallelArrays(g, "shift"), n.shift())); this.isDirtyData = this.isDirty = !0; c && k.redraw(h)
                }, removePoint: function (a, c, d) {
                    var e = this, h = e.data, f = h[a], k = e.points, p = e.chart, n = function () { k && k.length === h.length && k.splice(a, 1); h.splice(a, 1); e.options.data.splice(a, 1); e.updateParallelArrays(f || { series: e }, "splice", a, 1); f && f.destroy(); e.isDirty = !0; e.isDirtyData = !0; c && p.redraw() }; D(d, p); c = b(c, !0); f ? f.firePointEvent("remove", null, n) :
                        n()
                }, remove: function (a, c, d) { function e() { h.destroy(); f.isDirtyLegend = f.isDirtyBox = !0; f.linkSeries(); b(a, !0) && f.redraw(c) } var h = this, f = h.chart; !1 !== d ? u(h, "remove", null, e) : e() }, update: function (a, c) {
                    var e = this, d = this.chart, h = this.userOptions, f = this.oldType || this.type, p = a.type || h.type || d.options.chart.type, n = t[f].prototype, q = ["group", "markerGroup", "dataLabelsGroup"], g; if (p && p !== f || void 0 !== a.zIndex) q.length = 0; l(q, function (a) { q[a] = e[a]; delete e[a] }); a = z(h, { animation: !1, index: this.index, pointStart: this.xData[0] },
                        { data: this.options.data }, a); this.remove(!1, null, !1); for (g in n) this[g] = void 0; k(this, t[p || f].prototype); l(q, function (a) { e[a] = q[a] }); this.init(d, a); this.oldType = f; d.linkSeries(); b(c, !0) && d.redraw(!1)
                }
            }); k(H.prototype, {
                update: function (a, c) { var e = this.chart; a = e.options[this.coll][this.options.index] = z(this.userOptions, a); this.destroy(!0); this.init(e, k(a, { events: void 0 })); e.isDirtyBox = !0; b(c, !0) && e.redraw() }, remove: function (a) {
                    for (var c = this.chart, e = this.coll, d = this.series, h = d.length; h--;) d[h] && d[h].remove(!1);
                    q(c.axes, this); q(c[e], this); c.options[e].splice(this.options.index, 1); l(c[e], function (a, b) { a.options.index = b }); this.destroy(); c.isDirtyBox = !0; b(a, !0) && c.redraw()
                }, setTitle: function (a, b) { this.update({ title: a }, b) }, setCategories: function (a, b) { this.update({ categories: a }, b) }
            })
    })(L); (function (a) {
        var B = a.color, A = a.each, H = a.map, G = a.pick, r = a.Series, f = a.seriesType; f("area", "line", { softThreshold: !1, threshold: 0 }, {
            singleStacks: !1, getStackPoints: function () {
                var a = [], f = [], k = this.xAxis, r = this.yAxis, d = r.stacks[this.stackKey],
                    c = {}, n = this.points, z = this.index, b = r.series, p = b.length, h, t = G(r.options.reversedStacks, !0) ? 1 : -1, D, w; if (this.options.stacking) {
                        for (D = 0; D < n.length; D++) c[n[D].x] = n[D]; for (w in d) null !== d[w].total && f.push(w); f.sort(function (a, b) { return a - b }); h = H(b, function () { return this.visible }); A(f, function (b, n) {
                            var e = 0, l, m; if (c[b] && !c[b].isNull) a.push(c[b]), A([-1, 1], function (a) {
                                var e = 1 === a ? "rightNull" : "leftNull", k = 0, q = d[f[n + a]]; if (q) for (D = z; 0 <= D && D < p;) l = q.points[D], l || (D === z ? c[b][e] = !0 : h[D] && (m = d[b].points[D]) && (k -=
                                    m[1] - m[0])), D += t; c[b][1 === a ? "rightCliff" : "leftCliff"] = k
                            }); else { for (D = z; 0 <= D && D < p;) { if (l = d[b].points[D]) { e = l[1]; break } D += t } e = r.translate(e, 0, 1, 0, 1); a.push({ isNull: !0, plotX: k.translate(b, 0, 0, 0, 1), x: b, plotY: e, yBottom: e }) }
                        })
                    } return a
            }, getGraphPath: function (a) {
                var f = r.prototype.getGraphPath, k = this.options, l = k.stacking, d = this.yAxis, c, n, z = [], b = [], p = this.index, h, t = d.stacks[this.stackKey], D = k.threshold, w = d.getThreshold(k.threshold), e, k = k.connectNulls || "percent" === l, x = function (c, e, f) {
                    var k = a[c]; c = l && t[k.x].points[p];
                    var m = k[f + "Null"] || 0; f = k[f + "Cliff"] || 0; var n, q, k = !0; f || m ? (n = (m ? c[0] : c[1]) + f, q = c[0] + f, k = !!m) : !l && a[e] && a[e].isNull && (n = q = D); void 0 !== n && (b.push({ plotX: h, plotY: null === n ? w : d.getThreshold(n), isNull: k, isCliff: !0 }), z.push({ plotX: h, plotY: null === q ? w : d.getThreshold(q), doCurve: !1 }))
                }; a = a || this.points; l && (a = this.getStackPoints()); for (c = 0; c < a.length; c++) if (n = a[c].isNull, h = G(a[c].rectPlotX, a[c].plotX), e = G(a[c].yBottom, w), !n || k) k || x(c, c - 1, "left"), n && !l && k || (b.push(a[c]), z.push({ x: c, plotX: h, plotY: e })), k || x(c, c +
                    1, "right"); c = f.call(this, b, !0, !0); z.reversed = !0; n = f.call(this, z, !0, !0); n.length && (n[0] = "L"); n = c.concat(n); f = f.call(this, b, !1, k); n.xMap = c.xMap; this.areaPath = n; return f
            }, drawGraph: function () {
                this.areaPath = []; r.prototype.drawGraph.apply(this); var a = this, f = this.areaPath, k = this.options, u = [["area", "highcharts-area", this.color, k.fillColor]]; A(this.zones, function (d, c) { u.push(["zone-area-" + c, "highcharts-area highcharts-zone-area-" + c + " " + d.className, d.color || a.color, d.fillColor || k.fillColor]) }); A(u, function (d) {
                    var c =
                        d[0], n = a[c]; n ? (n.endX = f.xMap, n.animate({ d: f })) : (n = a[c] = a.chart.renderer.path(f).addClass(d[1]).attr({ fill: G(d[3], B(d[2]).setOpacity(G(k.fillOpacity, .75)).get()), zIndex: 0 }).add(a.group), n.isArea = !0); n.startX = f.xMap; n.shiftUnit = k.step ? 2 : 1
                })
            }, drawLegendSymbol: a.LegendSymbolMixin.drawRectangle
        })
    })(L); (function (a) {
        var B = a.pick; a = a.seriesType; a("spline", "line", {}, {
            getPointSpline: function (a, H, G) {
                var r = H.plotX, f = H.plotY, l = a[G - 1]; G = a[G + 1]; var q, k, u, d; if (l && !l.isNull && !1 !== l.doCurve && !H.isCliff && G && !G.isNull &&
                    !1 !== G.doCurve && !H.isCliff) { a = l.plotY; u = G.plotX; G = G.plotY; var c = 0; q = (1.5 * r + l.plotX) / 2.5; k = (1.5 * f + a) / 2.5; u = (1.5 * r + u) / 2.5; d = (1.5 * f + G) / 2.5; u !== q && (c = (d - k) * (u - r) / (u - q) + f - d); k += c; d += c; k > a && k > f ? (k = Math.max(a, f), d = 2 * f - k) : k < a && k < f && (k = Math.min(a, f), d = 2 * f - k); d > G && d > f ? (d = Math.max(G, f), k = 2 * f - d) : d < G && d < f && (d = Math.min(G, f), k = 2 * f - d); H.rightContX = u; H.rightContY = d } H = ["C", B(l.rightContX, l.plotX), B(l.rightContY, l.plotY), B(q, r), B(k, f), r, f]; l.rightContX = l.rightContY = null; return H
            }
        })
    })(L); (function (a) {
        var B = a.seriesTypes.area.prototype,
            A = a.seriesType; A("areaspline", "spline", a.defaultPlotOptions.area, { getStackPoints: B.getStackPoints, getGraphPath: B.getGraphPath, setStackCliffs: B.setStackCliffs, drawGraph: B.drawGraph, drawLegendSymbol: a.LegendSymbolMixin.drawRectangle })
    })(L); (function (a) {
        var B = a.animObject, A = a.color, H = a.each, G = a.extend, r = a.isNumber, f = a.merge, l = a.pick, q = a.Series, k = a.seriesType, u = a.svg; k("column", "line", {
            borderRadius: 0, crisp: !0, groupPadding: .2, marker: null, pointPadding: .1, minPointLength: 0, cropThreshold: 50, pointRange: null,
            states: { hover: { halo: !1, brightness: .1, shadow: !1 }, select: { color: "#cccccc", borderColor: "#000000", shadow: !1 } }, dataLabels: { align: null, verticalAlign: null, y: null }, softThreshold: !1, startFromThreshold: !0, stickyTracking: !1, tooltip: { distance: 6 }, threshold: 0, borderColor: "#ffffff"
        }, {
                cropShoulder: 0, directTouch: !0, trackerGroups: ["group", "dataLabelsGroup"], negStacks: !0, init: function () { q.prototype.init.apply(this, arguments); var a = this, c = a.chart; c.hasRendered && H(c.series, function (c) { c.type === a.type && (c.isDirty = !0) }) },
                getColumnMetrics: function () {
                    var a = this, c = a.options, f = a.xAxis, k = a.yAxis, b = f.reversed, p, h = {}, t = 0; !1 === c.grouping ? t = 1 : H(a.chart.series, function (b) { var c = b.options, e = b.yAxis, d; b.type === a.type && b.visible && k.len === e.len && k.pos === e.pos && (c.stacking ? (p = b.stackKey, void 0 === h[p] && (h[p] = t++), d = h[p]) : !1 !== c.grouping && (d = t++), b.columnIndex = d) }); var q = Math.min(Math.abs(f.transA) * (f.ordinalSlope || c.pointRange || f.closestPointRange || f.tickInterval || 1), f.len), w = q * c.groupPadding, e = (q - 2 * w) / (t || 1), c = Math.min(c.maxPointWidth ||
                        f.len, l(c.pointWidth, e * (1 - 2 * c.pointPadding))); a.columnMetrics = { width: c, offset: (e - c) / 2 + (w + ((a.columnIndex || 0) + (b ? 1 : 0)) * e - q / 2) * (b ? -1 : 1) }; return a.columnMetrics
                }, crispCol: function (a, c, f, k) { var b = this.chart, d = this.borderWidth, h = -(d % 2 ? .5 : 0), d = d % 2 ? .5 : 1; b.inverted && b.renderer.isVML && (d += 1); this.options.crisp && (f = Math.round(a + f) + h, a = Math.round(a) + h, f -= a); k = Math.round(c + k) + d; h = .5 >= Math.abs(c) && .5 < k; c = Math.round(c) + d; k -= c; h && k && (--c, k += 1); return { x: a, y: c, width: f, height: k } }, translate: function () {
                    var a = this, c =
                        a.chart, f = a.options, k = a.dense = 2 > a.closestPointRange * a.xAxis.transA, k = a.borderWidth = l(f.borderWidth, k ? 0 : 1), b = a.yAxis, p = a.translatedThreshold = b.getThreshold(f.threshold), h = l(f.minPointLength, 5), t = a.getColumnMetrics(), r = t.width, w = a.barW = Math.max(r, 1 + 2 * k), e = a.pointXOffset = t.offset; c.inverted && (p -= .5); f.pointPadding && (w = Math.ceil(w)); q.prototype.translate.apply(a); H(a.points, function (d) {
                            var f = l(d.yBottom, p), k = 999 + Math.abs(f), k = Math.min(Math.max(-k, d.plotY), b.len + k), m = d.plotX + e, n = w, t = Math.min(k, f), q, u =
                                Math.max(k, f) - t; Math.abs(u) < h && h && (u = h, q = !b.reversed && !d.negative || b.reversed && d.negative, t = Math.abs(t - p) > h ? f - h : p - (q ? h : 0)); d.barX = m; d.pointWidth = r; d.tooltipPos = c.inverted ? [b.len + b.pos - c.plotLeft - k, a.xAxis.len - m - n / 2, u] : [m + n / 2, k + b.pos - c.plotTop, u]; d.shapeType = "rect"; d.shapeArgs = a.crispCol.apply(a, d.isNull ? [d.plotX, b.len / 2, 0, 0] : [m, t, n, u])
                        })
                }, getSymbol: a.noop, drawLegendSymbol: a.LegendSymbolMixin.drawRectangle, drawGraph: function () { this.group[this.dense ? "addClass" : "removeClass"]("highcharts-dense-data") },
                pointAttribs: function (a, c) {
                    var d = this.options, k, b = this.pointAttrToOptions || {}; k = b.stroke || "borderColor"; var p = b["stroke-width"] || "borderWidth", h = a && a.color || this.color, l = a[k] || d[k] || this.color || h, q = a[p] || d[p] || this[p] || 0, b = d.dashStyle; a && this.zones.length && (h = (h = a.getZone()) && h.color || a.options.color || this.color); c && (a = f(d.states[c], a.options.states && a.options.states[c] || {}), c = a.brightness, h = a.color || void 0 !== c && A(h).brighten(a.brightness).get() || h, l = a[k] || l, q = a[p] || q, b = a.dashStyle || b); k = {
                        fill: h,
                        stroke: l, "stroke-width": q
                    }; d.borderRadius && (k.r = d.borderRadius); b && (k.dashstyle = b); return k
                }, drawPoints: function () {
                    var a = this, c = this.chart, k = a.options, l = c.renderer, b = k.animationLimit || 250, p; H(a.points, function (d) {
                        var h = d.graphic; if (r(d.plotY) && null !== d.y) { p = d.shapeArgs; if (h) h[c.pointCount < b ? "animate" : "attr"](f(p)); else d.graphic = h = l[d.shapeType](p).add(d.group || a.group); h.attr(a.pointAttribs(d, d.selected && "select")).shadow(k.shadow, null, k.stacking && !k.borderRadius); h.addClass(d.getClassName(), !0) } else h &&
                            (d.graphic = h.destroy())
                    })
                }, animate: function (a) { var c = this, d = this.yAxis, f = c.options, b = this.chart.inverted, k = {}; u && (a ? (k.scaleY = .001, a = Math.min(d.pos + d.len, Math.max(d.pos, d.toPixels(f.threshold))), b ? k.translateX = a - d.len : k.translateY = a, c.group.attr(k)) : (k[b ? "translateX" : "translateY"] = d.pos, c.group.animate(k, G(B(c.options.animation), { step: function (a, b) { c.group.attr({ scaleY: Math.max(.001, b.pos) }) } })), c.animate = null)) }, remove: function () {
                    var a = this, c = a.chart; c.hasRendered && H(c.series, function (c) {
                        c.type ===
                            a.type && (c.isDirty = !0)
                    }); q.prototype.remove.apply(a, arguments)
                }
            })
    })(L); (function (a) { a = a.seriesType; a("bar", "column", null, { inverted: !0 }) })(L); (function (a) {
        var B = a.Series; a = a.seriesType; a("scatter", "line", { lineWidth: 0, findNearestPointBy: "xy", marker: { enabled: !0 }, tooltip: { headerFormat: '\x3cspan style\x3d"color:{point.color}"\x3e\u25cf\x3c/span\x3e \x3cspan style\x3d"font-size: 0.85em"\x3e {series.name}\x3c/span\x3e\x3cbr/\x3e', pointFormat: "x: \x3cb\x3e{point.x}\x3c/b\x3e\x3cbr/\x3ey: \x3cb\x3e{point.y}\x3c/b\x3e\x3cbr/\x3e" } },
            { sorted: !1, requireSorting: !1, noSharedTooltip: !0, trackerGroups: ["group", "markerGroup", "dataLabelsGroup"], takeOrdinalPosition: !1, drawGraph: function () { this.options.lineWidth && B.prototype.drawGraph.call(this) } })
    })(L); (function (a) {
        var B = a.pick, A = a.relativeLength; a.CenteredSeriesMixin = {
            getCenter: function () {
                var a = this.options, G = this.chart, r = 2 * (a.slicedOffset || 0), f = G.plotWidth - 2 * r, G = G.plotHeight - 2 * r, l = a.center, l = [B(l[0], "50%"), B(l[1], "50%"), a.size || "100%", a.innerSize || 0], q = Math.min(f, G), k, u; for (k = 0; 4 > k; ++k) u =
                    l[k], a = 2 > k || 2 === k && /%$/.test(u), l[k] = A(u, [f, G, q, l[2]][k]) + (a ? r : 0); l[3] > l[2] && (l[3] = l[2]); return l
            }
        }
    })(L); (function (a) {
        var B = a.addEvent, A = a.defined, H = a.each, G = a.extend, r = a.inArray, f = a.noop, l = a.pick, q = a.Point, k = a.Series, u = a.seriesType, d = a.setAnimation; u("pie", "line", {
            center: [null, null], clip: !1, colorByPoint: !0, dataLabels: { distance: 30, enabled: !0, formatter: function () { return null === this.y ? void 0 : this.point.name }, x: 0 }, ignoreHiddenPoint: !0, legendType: "point", marker: null, size: null, showInLegend: !1, slicedOffset: 10,
            stickyTracking: !1, tooltip: { followPointer: !0 }, borderColor: "#ffffff", borderWidth: 1, states: { hover: { brightness: .1, shadow: !1 } }
        }, {
                isCartesian: !1, requireSorting: !1, directTouch: !0, noSharedTooltip: !0, trackerGroups: ["group", "dataLabelsGroup"], axisTypes: [], pointAttribs: a.seriesTypes.column.prototype.pointAttribs, animate: function (a) {
                    var c = this, d = c.points, b = c.startAngleRad; a || (H(d, function (a) {
                        var d = a.graphic, f = a.shapeArgs; d && (d.attr({ r: a.startR || c.center[3] / 2, start: b, end: b }), d.animate({ r: f.r, start: f.start, end: f.end },
                            c.options.animation))
                    }), c.animate = null)
                }, updateTotals: function () { var a, d = 0, f = this.points, b = f.length, k, h = this.options.ignoreHiddenPoint; for (a = 0; a < b; a++) k = f[a], 0 > k.y && (k.y = null), d += h && !k.visible ? 0 : k.y; this.total = d; for (a = 0; a < b; a++) k = f[a], k.percentage = 0 < d && (k.visible || !h) ? k.y / d * 100 : 0, k.total = d }, generatePoints: function () { k.prototype.generatePoints.call(this); this.updateTotals() }, translate: function (a) {
                    this.generatePoints(); var c = 0, d = this.options, b = d.slicedOffset, f = b + (d.borderWidth || 0), h, k, q, w = d.startAngle ||
                        0, e = this.startAngleRad = Math.PI / 180 * (w - 90), w = (this.endAngleRad = Math.PI / 180 * (l(d.endAngle, w + 360) - 90)) - e, r = this.points, u = d.dataLabels.distance, d = d.ignoreHiddenPoint, E, m = r.length, y; a || (this.center = a = this.getCenter()); this.getX = function (b, c) { q = Math.asin(Math.min((b - a[1]) / (a[2] / 2 + u), 1)); return a[0] + (c ? -1 : 1) * Math.cos(q) * (a[2] / 2 + u) }; for (E = 0; E < m; E++) {
                            y = r[E]; h = e + c * w; if (!d || y.visible) c += y.percentage / 100; k = e + c * w; y.shapeType = "arc"; y.shapeArgs = {
                                x: a[0], y: a[1], r: a[2] / 2, innerR: a[3] / 2, start: Math.round(1E3 * h) / 1E3, end: Math.round(1E3 *
                                    k) / 1E3
                            }; q = (k + h) / 2; q > 1.5 * Math.PI ? q -= 2 * Math.PI : q < -Math.PI / 2 && (q += 2 * Math.PI); y.slicedTranslation = { translateX: Math.round(Math.cos(q) * b), translateY: Math.round(Math.sin(q) * b) }; h = Math.cos(q) * a[2] / 2; k = Math.sin(q) * a[2] / 2; y.tooltipPos = [a[0] + .7 * h, a[1] + .7 * k]; y.half = q < -Math.PI / 2 || q > Math.PI / 2 ? 1 : 0; y.angle = q; f = Math.min(f, u / 5); y.labelPos = [a[0] + h + Math.cos(q) * u, a[1] + k + Math.sin(q) * u, a[0] + h + Math.cos(q) * f, a[1] + k + Math.sin(q) * f, a[0] + h, a[1] + k, 0 > u ? "center" : y.half ? "right" : "left", q]
                        }
                }, drawGraph: null, drawPoints: function () {
                    var a =
                        this, d = a.chart.renderer, f, b, k, h, l = a.options.shadow; l && !a.shadowGroup && (a.shadowGroup = d.g("shadow").add(a.group)); H(a.points, function (c) {
                            if (null !== c.y) {
                                b = c.graphic; h = c.shapeArgs; f = c.getTranslate(); var p = c.shadowGroup; l && !p && (p = c.shadowGroup = d.g("shadow").add(a.shadowGroup)); p && p.attr(f); k = a.pointAttribs(c, c.selected && "select"); b ? b.setRadialReference(a.center).attr(k).animate(G(h, f)) : (c.graphic = b = d[c.shapeType](h).setRadialReference(a.center).attr(f).add(a.group), c.visible || b.attr({ visibility: "hidden" }),
                                    b.attr(k).attr({ "stroke-linejoin": "round" }).shadow(l, p)); b.addClass(c.getClassName())
                            }
                        })
                }, searchPoint: f, sortByAngle: function (a, d) { a.sort(function (a, b) { return void 0 !== a.angle && (b.angle - a.angle) * d }) }, drawLegendSymbol: a.LegendSymbolMixin.drawRectangle, getCenter: a.CenteredSeriesMixin.getCenter, getSymbol: f
            }, {
                init: function () { q.prototype.init.apply(this, arguments); var a = this, d; a.name = l(a.name, "Slice"); d = function (c) { a.slice("select" === c.type) }; B(a, "select", d); B(a, "unselect", d); return a }, setVisible: function (a,
                    d) { var c = this, b = c.series, f = b.chart, h = b.options.ignoreHiddenPoint; d = l(d, h); a !== c.visible && (c.visible = c.options.visible = a = void 0 === a ? !c.visible : a, b.options.data[r(c, b.data)] = c.options, H(["graphic", "dataLabel", "connector", "shadowGroup"], function (b) { if (c[b]) c[b][a ? "show" : "hide"](!0) }), c.legendItem && f.legend.colorizeItem(c, a), a || "hover" !== c.state || c.setState(""), h && (b.isDirty = !0), d && f.redraw()) }, slice: function (a, f, k) {
                        var b = this.series; d(k, b.chart); l(f, !0); this.sliced = this.options.sliced = A(a) ? a : !this.sliced;
                        b.options.data[r(this, b.data)] = this.options; this.graphic.animate(this.getTranslate()); this.shadowGroup && this.shadowGroup.animate(this.getTranslate())
                    }, getTranslate: function () { return this.sliced ? this.slicedTranslation : { translateX: 0, translateY: 0 } }, haloPath: function (a) { var c = this.shapeArgs; return this.sliced || !this.visible ? [] : this.series.chart.renderer.symbols.arc(c.x, c.y, c.r + a, c.r + a, { innerR: this.shapeArgs.r, start: c.start, end: c.end }) }
            })
    })(L); (function (a) {
        var B = a.addEvent, A = a.arrayMax, H = a.defined, G = a.each,
            r = a.extend, f = a.format, l = a.map, q = a.merge, k = a.noop, u = a.pick, d = a.relativeLength, c = a.Series, n = a.seriesTypes, z = a.stableSort; a.distribute = function (a, c) {
                function b(a, b) { return a.target - b.target } var d, f = !0, k = a, e = [], p; p = 0; for (d = a.length; d--;) p += a[d].size; if (p > c) { z(a, function (a, b) { return (b.rank || 0) - (a.rank || 0) }); for (p = d = 0; p <= c;) p += a[d].size, d++; e = a.splice(d - 1, a.length) } z(a, b); for (a = l(a, function (a) { return { size: a.size, targets: [a.target] } }); f;) {
                    for (d = a.length; d--;) f = a[d], p = (Math.min.apply(0, f.targets) + Math.max.apply(0,
                        f.targets)) / 2, f.pos = Math.min(Math.max(0, p - f.size / 2), c - f.size); d = a.length; for (f = !1; d--;) 0 < d && a[d - 1].pos + a[d - 1].size > a[d].pos && (a[d - 1].size += a[d].size, a[d - 1].targets = a[d - 1].targets.concat(a[d].targets), a[d - 1].pos + a[d - 1].size > c && (a[d - 1].pos = c - a[d - 1].size), a.splice(d, 1), f = !0)
                } d = 0; G(a, function (a) { var b = 0; G(a.targets, function () { k[d].pos = a.pos + b; b += k[d].size; d++ }) }); k.push.apply(k, e); z(k, b)
            }; c.prototype.drawDataLabels = function () {
                var a = this, c = a.options, d = c.dataLabels, k = a.points, l, n, e = a.hasRendered || 0, r, C,
                    E = u(d.defer, !0), m = a.chart.renderer; if (d.enabled || a._hasPointLabels) a.dlProcessOptions && a.dlProcessOptions(d), C = a.plotGroup("dataLabelsGroup", "data-labels", E && !e ? "hidden" : "visible", d.zIndex || 6), E && (C.attr({ opacity: +e }), e || B(a, "afterAnimate", function () { a.visible && C.show(!0); C[c.animation ? "animate" : "attr"]({ opacity: 1 }, { duration: 200 }) })), n = d, G(k, function (b) {
                        var e, h = b.dataLabel, k, g, p, t = b.connector, w = !h, x; l = b.dlOptions || b.options && b.options.dataLabels; if (e = u(l && l.enabled, n.enabled) && null !== b.y) for (g in d =
                            q(n, l), k = b.getLabelConfig(), r = d.format ? f(d.format, k) : d.formatter.call(k, d), x = d.style, p = d.rotation, x.color = u(d.color, x.color, a.color, "#000000"), "contrast" === x.color && (b.contrastColor = m.getContrast(b.color || a.color), x.color = d.inside || 0 > d.distance || c.stacking ? b.contrastColor : "#000000"), c.cursor && (x.cursor = c.cursor), k = { fill: d.backgroundColor, stroke: d.borderColor, "stroke-width": d.borderWidth, r: d.borderRadius || 0, rotation: p, padding: d.padding, zIndex: 1 }, k) void 0 === k[g] && delete k[g]; !h || e && H(r) ? e && H(r) && (h ?
                                k.text = r : (h = b.dataLabel = m[p ? "text" : "label"](r, 0, -9999, d.shape, null, null, d.useHTML, null, "data-label"), h.addClass("highcharts-data-label-color-" + b.colorIndex + " " + (d.className || "") + (d.useHTML ? "highcharts-tracker" : ""))), h.attr(k), h.css(x).shadow(d.shadow), h.added || h.add(C), a.alignDataLabel(b, h, d, null, w)) : (b.dataLabel = h.destroy(), t && (b.connector = t.destroy()))
                    })
            }; c.prototype.alignDataLabel = function (a, c, d, f, k) {
                var b = this.chart, e = b.inverted, h = u(a.plotX, -9999), l = u(a.plotY, -9999), p = c.getBBox(), m, n = d.rotation,
                    q = d.align, t = this.visible && (a.series.forceDL || b.isInsidePlot(h, Math.round(l), e) || f && b.isInsidePlot(h, e ? f.x + 1 : f.y + f.height - 1, e)), D = "justify" === u(d.overflow, "justify"); t && (m = d.style.fontSize, m = b.renderer.fontMetrics(m, c).b, f = r({ x: e ? b.plotWidth - l : h, y: Math.round(e ? b.plotHeight - h : l), width: 0, height: 0 }, f), r(d, { width: p.width, height: p.height }), n ? (D = !1, e = b.renderer.rotCorr(m, n), e = { x: f.x + d.x + f.width / 2 + e.x, y: f.y + d.y + { top: 0, middle: .5, bottom: 1 }[d.verticalAlign] * f.height }, c[k ? "attr" : "animate"](e).attr({ align: q }),
                        h = (n + 720) % 360, h = 180 < h && 360 > h, "left" === q ? e.y -= h ? p.height : 0 : "center" === q ? (e.x -= p.width / 2, e.y -= p.height / 2) : "right" === q && (e.x -= p.width, e.y -= h ? 0 : p.height)) : (c.align(d, null, f), e = c.alignAttr), D ? a.isLabelJustified = this.justifyDataLabel(c, d, e, p, f, k) : u(d.crop, !0) && (t = b.isInsidePlot(e.x, e.y) && b.isInsidePlot(e.x + p.width, e.y + p.height)), d.shape && !n && c.attr({ anchorX: a.plotX, anchorY: a.plotY })); t || (c.attr({ y: -9999 }), c.placed = !1)
            }; c.prototype.justifyDataLabel = function (a, c, d, f, k, l) {
                var b = this.chart, h = c.align, p = c.verticalAlign,
                    n, m, q = a.box ? 0 : a.padding || 0; n = d.x + q; 0 > n && ("right" === h ? c.align = "left" : c.x = -n, m = !0); n = d.x + f.width - q; n > b.plotWidth && ("left" === h ? c.align = "right" : c.x = b.plotWidth - n, m = !0); n = d.y + q; 0 > n && ("bottom" === p ? c.verticalAlign = "top" : c.y = -n, m = !0); n = d.y + f.height - q; n > b.plotHeight && ("top" === p ? c.verticalAlign = "bottom" : c.y = b.plotHeight - n, m = !0); m && (a.placed = !l, a.align(c, null, k)); return m
            }; n.pie && (n.pie.prototype.drawDataLabels = function () {
                var b = this, d = b.data, f, k = b.chart, n = b.options.dataLabels, q = u(n.connectorPadding, 10), e = u(n.connectorWidth,
                    1), r = k.plotWidth, C = k.plotHeight, E, m = n.distance, y = b.center, z = y[2] / 2, B = y[1], H = 0 < m, g, F, L, N, P = [[], []], O, v, M, R, S = [0, 0, 0, 0]; b.visible && (n.enabled || b._hasPointLabels) && (G(d, function (a) { a.dataLabel && a.visible && a.dataLabel.shortened && (a.dataLabel.attr({ width: "auto" }).css({ width: "auto", textOverflow: "clip" }), a.dataLabel.shortened = !1) }), c.prototype.drawDataLabels.apply(b), G(d, function (a) { a.dataLabel && a.visible && (P[a.half].push(a), a.dataLabel._pos = null) }), G(P, function (c, e) {
                        var d, h, p = c.length, t, w, u; if (p) for (b.sortByAngle(c,
                            e - .5), 0 < m && (d = Math.max(0, B - z - m), h = Math.min(B + z + m, k.plotHeight), t = l(c, function (a) { if (a.dataLabel) return u = a.dataLabel.getBBox().height || 21, { target: a.labelPos[1] - d + u / 2, size: u, rank: a.y } }), a.distribute(t, h + u - d)), R = 0; R < p; R++) f = c[R], L = f.labelPos, g = f.dataLabel, M = !1 === f.visible ? "hidden" : "inherit", w = L[1], t ? void 0 === t[R].pos ? M = "hidden" : (N = t[R].size, v = d + t[R].pos) : v = w, O = n.justify ? y[0] + (e ? -1 : 1) * (z + m) : b.getX(v < d + 2 || v > h - 2 ? w : v, e), g._attr = { visibility: M, align: L[6] }, g._pos = {
                                x: O + n.x + ({ left: q, right: -q }[L[6]] || 0), y: v +
                                    n.y - 10
                            }, L.x = O, L.y = v, null === b.options.size && (F = g.getBBox().width, w = null, O - F < q ? (w = Math.round(F - O + q), S[3] = Math.max(w, S[3])) : O + F > r - q && (w = Math.round(O + F - r + q), S[1] = Math.max(w, S[1])), 0 > v - N / 2 ? S[0] = Math.max(Math.round(-v + N / 2), S[0]) : v + N / 2 > C && (S[2] = Math.max(Math.round(v + N / 2 - C), S[2])), g.sideOverflow = w)
                    }), 0 === A(S) || this.verifyDataLabelOverflow(S)) && (this.placeDataLabels(), H && e && G(this.points, function (a) {
                        var c; E = a.connector; if ((g = a.dataLabel) && g._pos && a.visible) {
                            M = g._attr.visibility; if (c = !E) a.connector = E = k.renderer.path().addClass("highcharts-data-label-connector highcharts-color-" +
                                a.colorIndex).add(b.dataLabelsGroup), E.attr({ "stroke-width": e, stroke: n.connectorColor || a.color || "#666666" }); E[c ? "attr" : "animate"]({ d: b.connectorPath(a.labelPos) }); E.attr("visibility", M)
                        } else E && (a.connector = E.destroy())
                    }))
            }, n.pie.prototype.connectorPath = function (a) { var b = a.x, c = a.y; return u(this.options.dataLabels.softConnector, !0) ? ["M", b + ("left" === a[6] ? 5 : -5), c, "C", b, c, 2 * a[2] - a[4], 2 * a[3] - a[5], a[2], a[3], "L", a[4], a[5]] : ["M", b + ("left" === a[6] ? 5 : -5), c, "L", a[2], a[3], "L", a[4], a[5]] }, n.pie.prototype.placeDataLabels =
                function () { G(this.points, function (a) { var b = a.dataLabel; b && a.visible && ((a = b._pos) ? (b.sideOverflow && (b._attr.width = b.getBBox().width - b.sideOverflow, b.css({ width: b._attr.width + "px", textOverflow: "ellipsis" }), b.shortened = !0), b.attr(b._attr), b[b.moved ? "animate" : "attr"](a), b.moved = !0) : b && b.attr({ y: -9999 })) }, this) }, n.pie.prototype.alignDataLabel = k, n.pie.prototype.verifyDataLabelOverflow = function (a) {
                    var b = this.center, c = this.options, f = c.center, k = c.minSize || 80, l, e; null !== f[0] ? l = Math.max(b[2] - Math.max(a[1], a[3]),
                        k) : (l = Math.max(b[2] - a[1] - a[3], k), b[0] += (a[3] - a[1]) / 2); null !== f[1] ? l = Math.max(Math.min(l, b[2] - Math.max(a[0], a[2])), k) : (l = Math.max(Math.min(l, b[2] - a[0] - a[2]), k), b[1] += (a[0] - a[2]) / 2); l < b[2] ? (b[2] = l, b[3] = Math.min(d(c.innerSize || 0, l), l), this.translate(b), this.drawDataLabels && this.drawDataLabels()) : e = !0; return e
                }); n.column && (n.column.prototype.alignDataLabel = function (a, d, f, k, l) {
                    var b = this.chart.inverted, e = a.series, h = a.dlBox || a.shapeArgs, n = u(a.below, a.plotY > u(this.translatedThreshold, e.yAxis.len)), p = u(f.inside,
                        !!this.options.stacking); h && (k = q(h), 0 > k.y && (k.height += k.y, k.y = 0), h = k.y + k.height - e.yAxis.len, 0 < h && (k.height -= h), b && (k = { x: e.yAxis.len - k.y - k.height, y: e.xAxis.len - k.x - k.width, width: k.height, height: k.width }), p || (b ? (k.x += n ? 0 : k.width, k.width = 0) : (k.y += n ? k.height : 0, k.height = 0))); f.align = u(f.align, !b || p ? "center" : n ? "right" : "left"); f.verticalAlign = u(f.verticalAlign, b || p ? "middle" : n ? "top" : "bottom"); c.prototype.alignDataLabel.call(this, a, d, f, k, l); a.isLabelJustified && a.contrastColor && a.dataLabel.css({ color: a.contrastColor })
                })
    })(L);
    (function (a) {
        var B = a.Chart, A = a.each, H = a.pick, G = a.addEvent; B.prototype.callbacks.push(function (a) { function f() { var f = []; A(a.series || [], function (a) { var k = a.options.dataLabels, l = a.dataLabelCollections || ["dataLabel"]; (k.enabled || a._hasPointLabels) && !k.allowOverlap && a.visible && A(l, function (d) { A(a.points, function (a) { a[d] && (a[d].labelrank = H(a.labelrank, a.shapeArgs && a.shapeArgs.height), f.push(a[d])) }) }) }); a.hideOverlappingLabels(f) } f(); G(a, "redraw", f) }); B.prototype.hideOverlappingLabels = function (a) {
            var f =
                a.length, l, q, k, r, d, c, n, z, b, p = function (a, b, c, d, e, f, k, l) { return !(e > a + c || e + k < a || f > b + d || f + l < b) }; for (q = 0; q < f; q++) if (l = a[q]) l.oldOpacity = l.opacity, l.newOpacity = 1; a.sort(function (a, b) { return (b.labelrank || 0) - (a.labelrank || 0) }); for (q = 0; q < f; q++) for (k = a[q], l = q + 1; l < f; ++l) if (r = a[l], k && r && k !== r && k.placed && r.placed && 0 !== k.newOpacity && 0 !== r.newOpacity && (d = k.alignAttr, c = r.alignAttr, n = k.parentGroup, z = r.parentGroup, b = 2 * (k.box ? 0 : k.padding), d = p(d.x + n.translateX, d.y + n.translateY, k.width - b, k.height - b, c.x + z.translateX, c.y +
                    z.translateY, r.width - b, r.height - b))) (k.labelrank < r.labelrank ? k : r).newOpacity = 0; A(a, function (a) { var b, c; a && (c = a.newOpacity, a.oldOpacity !== c && a.placed && (c ? a.show(!0) : b = function () { a.hide() }, a.alignAttr.opacity = c, a[a.isOld ? "animate" : "attr"](a.alignAttr, null, b)), a.isOld = !0) })
        }
    })(L); (function (a) {
        var B = a.addEvent, A = a.Chart, H = a.createElement, G = a.css, r = a.defaultOptions, f = a.defaultPlotOptions, l = a.each, q = a.extend, k = a.fireEvent, u = a.hasTouch, d = a.inArray, c = a.isObject, n = a.Legend, z = a.merge, b = a.pick, p = a.Point, h = a.Series,
            t = a.seriesTypes, D = a.svg; a = a.TrackerMixin = {
                drawTrackerPoint: function () {
                    var a = this, b = a.chart.pointer, c = function (a) { var c = b.getPointFromEvent(a); if (void 0 !== c) c.onMouseOver(a) }; l(a.points, function (a) { a.graphic && (a.graphic.element.point = a); a.dataLabel && (a.dataLabel.div ? a.dataLabel.div.point = a : a.dataLabel.element.point = a) }); a._hasTracking || (l(a.trackerGroups, function (e) {
                        if (a[e]) {
                            a[e].addClass("highcharts-tracker").on("mouseover", c).on("mouseout", function (a) { b.onTrackerMouseOut(a) }); if (u) a[e].on("touchstart",
                                c); a.options.cursor && a[e].css(G).css({ cursor: a.options.cursor })
                        }
                    }), a._hasTracking = !0)
                }, drawTrackerGraph: function () {
                    var a = this, b = a.options, c = b.trackByArea, d = [].concat(c ? a.areaPath : a.graphPath), f = d.length, h = a.chart, k = h.pointer, n = h.renderer, p = h.options.tooltip.snap, q = a.tracker, g, r = function () { if (h.hoverSeries !== a) a.onMouseOver() }, t = "rgba(192,192,192," + (D ? .0001 : .002) + ")"; if (f && !c) for (g = f + 1; g--;) "M" === d[g] && d.splice(g + 1, 0, d[g + 1] - p, d[g + 2], "L"), (g && "M" === d[g] || g === f) && d.splice(g, 0, "L", d[g - 2] + p, d[g - 1]); q ?
                        q.attr({ d: d }) : a.graph && (a.tracker = n.path(d).attr({ "stroke-linejoin": "round", visibility: a.visible ? "visible" : "hidden", stroke: t, fill: c ? t : "none", "stroke-width": a.graph.strokeWidth() + (c ? 0 : 2 * p), zIndex: 2 }).add(a.group), l([a.tracker, a.markerGroup], function (a) { a.addClass("highcharts-tracker").on("mouseover", r).on("mouseout", function (a) { k.onTrackerMouseOut(a) }); b.cursor && a.css({ cursor: b.cursor }); if (u) a.on("touchstart", r) }))
                }
            }; t.column && (t.column.prototype.drawTracker = a.drawTrackerPoint); t.pie && (t.pie.prototype.drawTracker =
                a.drawTrackerPoint); t.scatter && (t.scatter.prototype.drawTracker = a.drawTrackerPoint); q(n.prototype, {
                    setItemEvents: function (a, b, c) {
                        var d = this, e = d.chart.renderer.boxWrapper, f = "highcharts-legend-" + (a.series ? "point" : "series") + "-active"; (c ? b : a.legendGroup).on("mouseover", function () { a.setState("hover"); e.addClass(f); b.css(d.options.itemHoverStyle) }).on("mouseout", function () { b.css(a.visible ? d.itemStyle : d.itemHiddenStyle); e.removeClass(f); a.setState() }).on("click", function (b) {
                            var c = function () {
                                a.setVisible &&
                                    a.setVisible()
                            }; b = { browserEvent: b }; a.firePointEvent ? a.firePointEvent("legendItemClick", b, c) : k(a, "legendItemClick", b, c)
                        })
                    }, createCheckboxForItem: function (a) { a.checkbox = H("input", { type: "checkbox", checked: a.selected, defaultChecked: a.selected }, this.options.itemCheckboxStyle, this.chart.container); B(a.checkbox, "click", function (b) { k(a.series || a, "checkboxClick", { checked: b.target.checked, item: a }, function () { a.select() }) }) }
                }); r.legend.itemStyle.cursor = "pointer"; q(A.prototype, {
                    showResetZoom: function () {
                        var a =
                            this, b = r.lang, c = a.options.chart.resetZoomButton, d = c.theme, f = d.states, h = "chart" === c.relativeTo ? null : "plotBox"; this.resetZoomButton = a.renderer.button(b.resetZoom, null, null, function () { a.zoomOut() }, d, f && f.hover).attr({ align: c.position.align, title: b.resetZoomTitle }).addClass("highcharts-reset-zoom").add().align(c.position, !1, h)
                    }, zoomOut: function () { var a = this; k(a, "selection", { resetSelection: !0 }, function () { a.zoom() }) }, zoom: function (a) {
                        var d, f = this.pointer, h = !1, k; !a || a.resetSelection ? l(this.axes, function (a) {
                            d =
                                a.zoom()
                        }) : l(a.xAxis.concat(a.yAxis), function (a) { var b = a.axis; f[b.isXAxis ? "zoomX" : "zoomY"] && (d = b.zoom(a.min, a.max), b.displayBtn && (h = !0)) }); k = this.resetZoomButton; h && !k ? this.showResetZoom() : !h && c(k) && (this.resetZoomButton = k.destroy()); d && this.redraw(b(this.options.chart.animation, a && a.animation, 100 > this.pointCount))
                    }, pan: function (a, b) {
                        var c = this, d = c.hoverPoints, e; d && l(d, function (a) { a.setState() }); l("xy" === b ? [1, 0] : [1], function (b) {
                            b = c[b ? "xAxis" : "yAxis"][0]; var d = b.horiz, f = a[d ? "chartX" : "chartY"], d = d ?
                                "mouseDownX" : "mouseDownY", h = c[d], k = (b.pointRange || 0) / 2, g = b.getExtremes(), l = b.toValue(h - f, !0) + k, k = b.toValue(h + b.len - f, !0) - k, m = k < l, h = m ? k : l, l = m ? l : k, m = b.toValue(b.toPixels(g.min) - b.minPixelPadding), k = b.toValue(b.toPixels(g.max) + b.minPixelPadding), m = Math.min(g.dataMin, m) - h, g = l - Math.max(g.dataMax, k); b.series.length && 0 > m && 0 > g && (b.setExtremes(h, l, !1, !1, { trigger: "pan" }), e = !0); c[d] = f
                        }); e && c.redraw(!1); G(c.container, { cursor: "move" })
                    }
                }); q(p.prototype, {
                    select: function (a, c) {
                        var e = this, f = e.series, h = f.chart; a = b(a,
                            !e.selected); e.firePointEvent(a ? "select" : "unselect", { accumulate: c }, function () { e.selected = e.options.selected = a; f.options.data[d(e, f.data)] = e.options; e.setState(a && "select"); c || l(h.getSelectedPoints(), function (a) { a.selected && a !== e && (a.selected = a.options.selected = !1, f.options.data[d(a, f.data)] = a.options, a.setState(""), a.firePointEvent("unselect")) }) })
                    }, onMouseOver: function (a) { var b = this.series.chart.pointer; this.firePointEvent("mouseOver"); b.runPointActions(a, this) }, onMouseOut: function () {
                        var a = this.series.chart;
                        this.firePointEvent("mouseOut"); l(a.hoverPoints || [], function (a) { a.setState() }); a.hoverPoints = a.hoverPoint = null
                    }, importEvents: function () { if (!this.hasImportedEvents) { var a = z(this.series.options.point, this.options).events, b; this.events = a; for (b in a) B(this, b, a[b]); this.hasImportedEvents = !0 } }, setState: function (a, c) {
                        var d = Math.floor(this.plotX), e = this.plotY, h = this.series, k = h.options.states[a] || {}, l = f[h.type].marker && h.options.marker, n = l && !1 === l.enabled, p = l && l.states && l.states[a] || {}, r = !1 === p.enabled, g =
                            h.stateMarkerGraphic, t = this.marker || {}, u = h.chart, w = h.halo, z, A = l && h.markerAttribs; a = a || ""; if (!(a === this.state && !c || this.selected && "select" !== a || !1 === k.enabled || a && (r || n && !1 === p.enabled) || a && t.states && t.states[a] && !1 === t.states[a].enabled)) {
                                A && (z = h.markerAttribs(this, a)); if (this.graphic) this.state && this.graphic.removeClass("highcharts-point-" + this.state), a && this.graphic.addClass("highcharts-point-" + a), this.graphic.attr(h.pointAttribs(this, a)), z && this.graphic.animate(z, b(u.options.chart.animation, p.animation,
                                    l.animation)), g && g.hide(); else { if (a && p) { l = t.symbol || h.symbol; g && g.currentSymbol !== l && (g = g.destroy()); if (g) g[c ? "animate" : "attr"]({ x: z.x, y: z.y }); else l && (h.stateMarkerGraphic = g = u.renderer.symbol(l, z.x, z.y, z.width, z.height).add(h.markerGroup), g.currentSymbol = l); g && g.attr(h.pointAttribs(this, a)) } g && (g[a && u.isInsidePlot(d, e, u.inverted) ? "show" : "hide"](), g.element.point = this) } (d = k.halo) && d.size ? (w || (h.halo = w = u.renderer.path().add(A ? h.markerGroup : h.group)), w[c ? "animate" : "attr"]({ d: this.haloPath(d.size) }),
                                        w.attr({ "class": "highcharts-halo highcharts-color-" + b(this.colorIndex, h.colorIndex) }), w.point = this, w.attr(q({ fill: this.color || h.color, "fill-opacity": d.opacity, zIndex: -1 }, d.attributes))) : w && w.point && w.point.haloPath && w.animate({ d: w.point.haloPath(0) }); this.state = a
                            }
                    }, haloPath: function (a) { return this.series.chart.renderer.symbols.circle(Math.floor(this.plotX) - a, this.plotY - a, 2 * a, 2 * a) }
                }); q(h.prototype, {
                    onMouseOver: function () {
                        var a = this.chart, b = a.hoverSeries; if (b && b !== this) b.onMouseOut(); this.options.events.mouseOver &&
                            k(this, "mouseOver"); this.setState("hover"); a.hoverSeries = this
                    }, onMouseOut: function () { var a = this.options, b = this.chart, c = b.tooltip, d = b.hoverPoint; b.hoverSeries = null; if (d) d.onMouseOut(); this && a.events.mouseOut && k(this, "mouseOut"); !c || this.stickyTracking || c.shared && !this.noSharedTooltip || c.hide(); this.setState() }, setState: function (a) {
                        var c = this, d = c.options, f = c.graph, h = d.states, k = d.lineWidth, d = 0; a = a || ""; if (c.state !== a && (l([c.group, c.markerGroup, c.dataLabelsGroup], function (b) {
                            b && (c.state && b.removeClass("highcharts-series-" +
                                c.state), a && b.addClass("highcharts-series-" + a))
                        }), c.state = a, !h[a] || !1 !== h[a].enabled) && (a && (k = h[a].lineWidth || k + (h[a].lineWidthPlus || 0)), f && !f.dashstyle)) for (k = { "stroke-width": k }, f.animate(k, b(c.chart.options.chart.animation, h[a] && h[a].animation)); c["zone-graph-" + d];) c["zone-graph-" + d].attr(k), d += 1
                    }, setVisible: function (a, b) {
                        var c = this, d = c.chart, e = c.legendItem, f, h = d.options.chart.ignoreHiddenSeries, n = c.visible; f = (c.visible = a = c.options.visible = c.userOptions.visible = void 0 === a ? !n : a) ? "show" : "hide"; l(["group",
                            "dataLabelsGroup", "markerGroup", "tracker", "tt"], function (a) { if (c[a]) c[a][f]() }); if (d.hoverSeries === c || (d.hoverPoint && d.hoverPoint.series) === c) c.onMouseOut(); e && d.legend.colorizeItem(c, a); c.isDirty = !0; c.options.stacking && l(d.series, function (a) { a.options.stacking && a.visible && (a.isDirty = !0) }); l(c.linkedSeries, function (b) { b.setVisible(a, !1) }); h && (d.isDirtyBox = !0); !1 !== b && d.redraw(); k(c, f)
                    }, show: function () { this.setVisible(!0) }, hide: function () { this.setVisible(!1) }, select: function (a) {
                        this.selected = a = void 0 ===
                            a ? !this.selected : a; this.checkbox && (this.checkbox.checked = a); k(this, a ? "select" : "unselect")
                    }, drawTracker: a.drawTrackerGraph
                })
    })(L); (function (a) {
        var B = a.Chart, A = a.each, H = a.inArray, G = a.isArray, r = a.isObject, f = a.pick, l = a.splat; B.prototype.setResponsive = function (f) {
            var k = this.options.responsive, l = [], d = this.currentResponsive; k && k.rules && A(k.rules, function (c) { void 0 === c._id && (c._id = a.uniqueKey()); this.matchResponsiveRule(c, l, f) }, this); var c = a.merge.apply(0, a.map(l, function (c) {
                return a.find(k.rules, function (a) {
                    return a._id ===
                        c
                }).chartOptions
            })), l = l.toString() || void 0; l !== (d && d.ruleIds) && (d && this.update(d.undoOptions, f), l ? (this.currentResponsive = { ruleIds: l, mergedOptions: c, undoOptions: this.currentOptions(c) }, this.update(c, f)) : this.currentResponsive = void 0)
        }; B.prototype.matchResponsiveRule = function (a, k) {
            var l = a.condition; (l.callback || function () { return this.chartWidth <= f(l.maxWidth, Number.MAX_VALUE) && this.chartHeight <= f(l.maxHeight, Number.MAX_VALUE) && this.chartWidth >= f(l.minWidth, 0) && this.chartHeight >= f(l.minHeight, 0) }).call(this) &&
                k.push(a._id)
        }; B.prototype.currentOptions = function (a) { function f(a, c, k, q) { var b, d; for (b in a) if (!q && -1 < H(b, ["series", "xAxis", "yAxis"])) for (a[b] = l(a[b]), k[b] = [], d = 0; d < a[b].length; d++) c[b][d] && (k[b][d] = {}, f(a[b][d], c[b][d], k[b][d], q + 1)); else r(a[b]) ? (k[b] = G(a[b]) ? [] : {}, f(a[b], c[b] || {}, k[b], q + 1)) : k[b] = c[b] || null } var q = {}; f(a, this.options, q, 0); return q }
    })(L); return L
});



/*
  Highcharts JS v5.0.10 (2017-03-31)
 Solid angular gauge module

 (c) 2010-2017 Torstein Honsi

 License: www.highcharts.com/license
*/
(function (l) { "object" === typeof module && module.exports ? module.exports = l : l(Highcharts) })(function (l) {
    (function (f) {
        var l = f.pInt, u = f.pick, m = f.each, v = f.isNumber, w = f.wrap, n; w(f.Renderer.prototype.symbols, "arc", function (a, d, e, c, f, g) { a = a(d, e, c, f, g); g.rounded && (c = ((g.r || c) - g.innerR) / 2, g = ["A", c, c, 0, 1, 1, a[12], a[13]], a.splice.apply(a, [a.length - 1, 0].concat(["A", c, c, 0, 1, 1, a[1], a[2]])), a.splice.apply(a, [11, 3].concat(g))); return a }); n = {
            initDataClasses: function (a) {
                var d = this, e = this.chart, c, t = 0, g = this.options; this.dataClasses =
                    c = []; m(a.dataClasses, function (h, b) { h = f.merge(h); c.push(h); h.color || ("category" === g.dataClassColor ? (b = e.options.colors, h.color = b[t++], t === b.length && (t = 0)) : h.color = d.tweenColors(f.color(g.minColor), f.color(g.maxColor), b / (a.dataClasses.length - 1))) })
            }, initStops: function (a) { this.stops = a.stops || [[0, this.options.minColor], [1, this.options.maxColor]]; m(this.stops, function (a) { a.color = f.color(a[1]) }) }, toColor: function (a, d) {
                var e = this.stops, c, f, g = this.dataClasses, h, b; if (g) for (b = g.length; b--;) {
                    if (h = g[b], c = h.from,
                        e = h.to, (void 0 === c || a >= c) && (void 0 === e || a <= e)) { f = h.color; d && (d.dataClass = b); break }
                } else { this.isLog && (a = this.val2lin(a)); a = 1 - (this.max - a) / (this.max - this.min); for (b = e.length; b-- && !(a > e[b][0]);); c = e[b] || e[b + 1]; e = e[b + 1] || c; a = 1 - (e[0] - a) / (e[0] - c[0] || 1); f = this.tweenColors(c.color, e.color, a) } return f
            }, tweenColors: function (a, d, e) {
                var c; d.rgba.length && a.rgba.length ? (a = a.rgba, d = d.rgba, c = 1 !== d[3] || 1 !== a[3], a = (c ? "rgba(" : "rgb(") + Math.round(d[0] + (a[0] - d[0]) * (1 - e)) + "," + Math.round(d[1] + (a[1] - d[1]) * (1 - e)) + "," + Math.round(d[2] +
                    (a[2] - d[2]) * (1 - e)) + (c ? "," + (d[3] + (a[3] - d[3]) * (1 - e)) : "") + ")") : a = d.input || "none"; return a
            }
        }; m(["fill", "stroke"], function (a) { f.Fx.prototype[a + "Setter"] = function () { this.elem.attr(a, n.tweenColors(f.color(this.start), f.color(this.end), this.pos), null, !0) } }); f.seriesType("solidgauge", "gauge", { colorByPoint: !0 }, {
            translate: function () { var a = this.yAxis; f.extend(a, n); !a.dataClasses && a.options.dataClasses && a.initDataClasses(a.options); a.initStops(a.options); f.seriesTypes.gauge.prototype.translate.call(this) }, drawPoints: function () {
                var a =
                    this, d = a.yAxis, e = d.center, c = a.options, t = a.chart.renderer, g = c.overshoot, h = v(g) ? g / 180 * Math.PI : 0, b; v(c.threshold) && (b = d.startAngleRad + d.translate(c.threshold, null, null, null, !0)); this.thresholdAngleRad = u(b, d.startAngleRad); m(a.points, function (b) {
                        var g = b.graphic, k = d.startAngleRad + d.translate(b.y, null, null, null, !0), m = l(u(b.options.radius, c.radius, 100)) * e[2] / 200, p = l(u(b.options.innerRadius, c.innerRadius, 60)) * e[2] / 200, q = d.toColor(b.y, b), r = Math.min(d.startAngleRad, d.endAngleRad), n = Math.max(d.startAngleRad,
                            d.endAngleRad); "none" === q && (q = b.color || a.color || "none"); "none" !== q && (b.color = q); k = Math.max(r - h, Math.min(n + h, k)); !1 === c.wrap && (k = Math.max(r, Math.min(n, k))); r = Math.min(k, a.thresholdAngleRad); k = Math.max(k, a.thresholdAngleRad); k - r > 2 * Math.PI && (k = r + 2 * Math.PI); b.shapeArgs = p = { x: e[0], y: e[1], r: m, innerR: p, start: r, end: k, rounded: c.rounded }; b.startR = m; g ? (b = p.d, g.animate(f.extend({ fill: q }, p)), b && (p.d = b)) : (b.graphic = t.arc(p).addClass("highcharts-point").attr({ fill: q, "sweep-flag": 0 }).add(a.group), "square" !== c.linecap &&
                                b.graphic.attr({ "stroke-linecap": "round", "stroke-linejoin": "round" }), b.graphic.attr({ stroke: c.borderColor || "none", "stroke-width": c.borderWidth || 0 }))
                    })
            }, animate: function (a) { a || (this.startAngleRad = this.thresholdAngleRad, f.seriesTypes.pie.prototype.animate.call(this, a)) }
        })
    })(l)
});
function closePopup() {

    $('body').removeClass('popup-open');
    $('.modal-container').fadeOut(500);
    $('.popup-box.active').fadeOut(500).removeClass('active');
}

$(document).on("click", "a[data-id=apply-for-product]", function (e)
{
    e.preventDefault();
    $('body').removeClass('popup-open');
    $('.modal-container').fadeOut(200);
    $('.popup-box.active').fadeOut(200).removeClass('active');
});

$(document).ajaxSuccess(function () {
    if ($("body.page-postlogin-product-catalogue").length > 0)
    {
        if ($("div.product-slider").length > 1 || $("div#non-featured-content #non-featured-content").length > 0)
        {
            $("div#non-featured-content div.product-slider").remove();
            var filteredContent = $("div#non-featured-content #non-featured-content").children();
            $("div#non-featured-content").children().remove();
            $("div#non-featured-content").append(filteredContent);
        }
    }
});

DeWeb.Utilities.atmBranch = function ($this) {

    var source = $this.data('source');
    var bPath = $this.data('base-path');
    var displayOn = $this.data('display-on');
    var formId = $this.data('form-id');
    var selectName = $this.data('select-name');
    var realfacilities = [];
    var facilitiesJson = $this.data('facilities-json');
    realfacilities = facilitiesJson;
    //if (selectName && $("#" + selectName).val() !== "") {
    //    var br = 0;
    //    for (var i in facilitiesJson) {
    //        var item = facilitiesJson[i];

    //        var itemType = $("#" + selectName).val().toLowerCase().split(',');
    //        for (var i = 0; i < atmbranches.length; i++) {
    //            var item = atmbranches[i];
    //        if () {
    //                realfacilities[br] = facilitiesJson[i];
    //                br = br + 1;
    //            }
    //        }
    //}
    //else {
        
    //    realfacilities = facilitiesJson;
    //}

    DeWeb.Functionalities.AtmBranchMap.Init(source, bPath, displayOn, realfacilities);

    $(document).off('change', 'input[name=typeselect]').on('change', 'input[name=typeselect]', function () {
        var selectedValue = $(this).val();
        $('.col-content').removeClass('active');
        $('.col-content.' + selectedValue).addClass('active');
    });

    $(document).off('change', '[name=' + selectName + ']').on('change', '[name=' + selectName + ']', function () {
        var atmbranches = $('[name=' + selectName + ']').val().split(',');
        //Check if it's list view then don't submit the form just filter
        for (var i = 0; i < atmbranches.length; i++) {
            var item = atmbranches[i];

            if ($(".col-content list").hasClass("active")) {
                $("li.facility-item").each(function () {
                    if ($(this).hasClass("facility-" + item)) {
                        $(this).show();
                    }
                    else {
                        $(this).hide();
                    }
                });
            }
            else {
                $("#form_" + formId).submit();

            }
        }
      
        
    });

    document.getElementById("text-search").addEventListener("search", function (event) {
        var text = $('#text-search').val();
        textSearchMap(text);
    });

    $(document).keypress(
        function (event) {
            if (event.which == '13') {
                event.preventDefault();
            }
        });

    $("#text-search").bind("keypress keyup keydown", function (event) {
        //if (event.which === 13 || event.keyCode === 13) {
            var text = $('#text-search').val();
            textSearchMap(text);
            //return false;
        //}
    });

    var textSearchMap = function (text) {
        var filter = {
            searchText: text.trim()
        }

        DeWeb.Functionalities.AtmBranchMap.Filter(filter);

        $(".map-list .facility-item").filter(function () {
            var value = text != undefined ? text.toLowerCase() : "";
            $(this).toggle($(this).find('.name').text().toLowerCase().indexOf(value) > -1 || $(this).find('.cat-name').text().toLowerCase().indexOf(value) > 1)
        });
    }

    //$(document).on("click", "li.facility-item", function() {

    //    var ch = $(this).find(".skr");
    //    ch.toggleClass("hidden-content");
    //});
}

DeWeb.Utilities.contactMap = function ($this) {
    var source = $this.data('source');
    var ctPath = $this.data('content-path');

    DeWeb.Functionalities.AtmBranchMap.Init(source, ctPath);

};



DeWeb.Utilities.cardLimits = function ($this) {
    var formId = $this.data("form-id");
    var link = $this.data("cards-link");
    DeWeb.Pages.CardLimits.Init(link, formId);
}

DeWeb.Pages.CardLimits = new function () {
    var cardsLink = '';
    var $form = null;
    var contentId = 'credit-card-details';
    var getLimits = function (deviceId) {
        var $replContent = $('#' + contentId);
        console.log(deviceId);
        if (deviceId == "-1") {
            deviceId = $("#CardNumber_ID").val();

        }
        
        console.log(cardsLink);
        DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
        $.ajax({
            url: cardsLink,
            data: { DeviceId: deviceId },
            success: function (markup) {

                $replContent.html(markup);
                DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
            }
        });
    };

    var init = function (link, formId) {

        cardsLink = link;

        $form = $('#' + formId);

        var CardLimits =
        {
            Id: "Limits",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        getLimits(args.Account);
                        break;
                }
            }
        };

        ebs.AddListener(CardLimits);

        getLimits("-1");

    };


    return {
        Init: init
    };
};


DeWeb.Utilities.switchReasons = function ($this) {
    $("[name=BlockadeTypeId]").change(function () {
        $("[name= BlockadeReasonId]").val();
        if ($(this).val() == "1") {
            $("[name= BlockadeReasonId]").val('temporary-blockage');

        }
        else {
            $("[name= BlockadeReasonId]").val('permanent-blockage');
        }
            
    })
};


function getBriefTransactions(accNo, link,replId) {
    $.ajax({
        url: link + "?Accounts="+accNo,
        type: "GET",
        success: function (markup) {

            $("#"+replId).html(markup);
            DeWeb.AjaxForms.OnAjaxSuccess(replId);
            DeWeb.AjaxForms.OnAjaxComplete(replId);
        }
    });
}
DeWeb.Utilities.cardTransationsBrief = function ($this) {
    var CardsTransactionsBrief =
        {
            Id: "CardsTransactionsBriefId",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        getBriefTransactions(args.Account, $this.data("transactions-link"),$this.data("repl-id"));
                        break;
                }
            }
        };
    getBriefTransactions($this.data("initial-acc"), $this.data("transactions-link"), $this.data("repl-id"));

    ebs.AddListener(CardsTransactionsBrief);
}



DeWeb.Utilities.cardsBrief = function ($this) {
    var formId = $this.data("form-id");
    var accountsLink = $this.data("link");
    var limitsLink = $this.data("limits-link");
    var transactionsLink = $this.data("transactions-link");
    DeWeb.Pages.CardsBrief.Init(accountsLink, limitsLink, transactionsLink, formId);
}

DeWeb.Pages.CardsBrief = new function () {
    var _transactionsUrl = '';
    var _accountsUrl = '';
    var $form = null;

    var _accountContentId = 'content-cards';

    var init = function (accountsUrl, limitsUrl, transactionsUrl, formId) {
        _accountsUrl = accountsUrl;
        _limitsUrl = limitsUrl;
        _transactionsUrl = transactionsUrl;

        $form = $('#' + formId);

        var CardsBrief =
        {
            Id: "CardsBrief",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        getBriefDetails();
                        break;
                }
            }
        };

        ebs.AddListener(CardsBrief);
        getBriefDetails();
        getLimits();
        getTransactions();

    };
    var getBriefDetails = function () {

        var $replContent = $('#' + _accountContentId);
        DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
        $.ajax({
            url: _accountsUrl,
            type: "POST",
            data: $form.serialize(),
            success: function (markup) {

                $replContent.html(markup);
                DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
            }
        });
    };

    var getLimits = function () {
        if (_limitsUrl) {
            var $replContent = $('#cards-limits');
            DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
            $.ajax({
                url: _limitsUrl,
                type: "POST",
                data: $form.serialize(),
                success: function (markup) {

                    $replContent.html(markup);
                    DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                    DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
                }
            });
        }
    };

    var getTransactions = function () {
        if (_transactionsUrl);
        {
            var $replContent = $('#transactions-content');
            DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
            $.ajax({
                url: _transactionsUrl,
                type: "POST",
                data: $form.serialize(),
                success: function (markup) {

                    $replContent.html(markup);
                    DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                    DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
                }
            });
        }
    };

    return {
        Init: init
    };
};
function getBriefTransactionsRO(accNo, link, replId, customerCards) {
    var qparams = $.param({
        'accounts': customerCards,
        'cards': accNo
    });
    $.ajax({
        url: link + "?" + qparams,
        type: "GET",
        success: function (markup) {

            $("#" + replId).html(markup);
            DeWeb.AjaxForms.OnAjaxSuccess(replId);
            DeWeb.AjaxForms.OnAjaxComplete(replId);
        }
    });
}
DeWeb.Utilities.cardTransationsBriefRO = function ($this) {
 
    getBriefTransactionsRO($this.data("card-number"), $this.data("transactions-link"),
        $this.data("repl-id"), $this.data("initial-acc"));

};
DeWeb.Utilities.enableInstallmentPlan = function ($this) {

};
// My Profile
$(document).on("change", "[name=select]", function () {

    $('div[data-type=selfcare-info]:not(#' + this.value + ')').hide();
    $("div[data-type=selfcare-info]#" + this.value).show();
})

function closePopup() {

    $('body').removeClass('popup-open');
    $('.modal-container').fadeOut(500);
    $('.popup-box.active').fadeOut(500).removeClass('active');
}


DeWeb.Utilities.filterInformation = function ($this) {
    $this.change(function () {

        var ajaxUrl = $("option[value=" + $(this).val() + "]").data("link");
        window.location.href = ajaxUrl;
    }
  );
}

LinksList = {
    auth: "./UserCredentials",
    device: "../../Device/OwnedDevices/GetList",
    notifications: "../../Correspondence/SelfCare/Index",
    apps: "../../Applications/Applications/GetList",
    mydoc: "./MyDocuments",
    accounts: "../../Dialog/Accounts/Index"
}

DeWeb.Utilities.RenderSections = function ($this) {
    $(document).ready(function () {
        if (true) {
            container = $this.data("container");
           
            
            if (container == "") {
                $("div#navigating-content").show();
                $('div[data-type=selfcare-option]:not(#navigating-content)').hide();
            }
            else {
                var ajaxUrl = "";
                switch (container) {
                    case "apps": {
                        ajaxUrl = LinksList.apps;
                        break;
                    }
                    case "notifications": {
                        ajaxUrl = LinksList.notifications;
                        break;
                    }
                    case "my-doc": {
                        ajaxUrl = LinksList.mydoc;
                        break;
                    }
                    case "device": {
                        ajaxUrl = LinksList.device;
                      
                        break;
                    }
                    case "auth": {
                        ajaxUrl =  LinksList.auth;
                        break;
                    }
                    case "default-account": {
                        ajaxUrl = LinksList.accounts;
                        break;
                    }
                   
                    default: break;
                }
                DeWeb.AjaxForms.OnAjaxBegin(container);
                $.ajax({
                    url: ajaxUrl,
                    success: function (data) {
                        $("#" + container).html(data);
                        DeWeb.AjaxForms.OnAjaxSuccess(container);
                        DeWeb.AjaxForms.OnAjaxComplete(container);
                    }

                });
                $("div#"+container).show();
                $('div[data-type=selfcare-option]:not(#'+container+')').hide();
            }

            $("input[type=submit]").each(function () {
                if ($(this).data("group-position") != "") {
                    $(this).css("width", "50%");
                    $(this).css("float", "right");

                    $("div#" + $(this).data("group-position")).append($(this));
                }

            })
        }
    });

}



//My documents paging

var initial_count = 10;
DeWeb.Utilities.ShowMore = function ($this) {
    $this.click(function () {
        var more = $this.data("show-more");
        var newnumber = more + initial_count;
        if (newnumber > $this.data("total-count")) {
            initial_count = $this.data("total-count");
            $this.css("display","none");
        }
        else {
            initial_count = newnumber;
        }
        $("[data-type=my-document]:lt(" + initial_count + ")").show();

        $("[data-type=my-document]:not(:lt(" + initial_count + "))").hide();
    });
    
}
DeWeb.Utilities.MorePaging = function ($this) {

    $("[data-type=my-document]:not(:lt(" + 10 + "))").hide();


};
DeWeb.Utilities.exchangeList = function ($this) {
    $(document).on("click", ".exchange-list .table-row", function () {
        var ch = $(this).find(".skr");
        ch.toggleClass("hidden-content");
    });
};

DeWeb.Utilities.waitForResponse = function ($this) {
    DeWeb.Ui.BlockElement($this.attr("id"));
    interval = 20000;
    var updateUrl = $this.data("update");
    (function getOffer(firstTime) {
        setTimeout(function () {
            (function getOffer(firstTime) {
                setTimeout(function () {
                    $.ajax({
                        url: updateUrl,
                        success: function (offerObject) {
                            try {
                                DeWeb.Ui.BlockElement($this.attr("id"));

                                if (!offerObject.Direction.startsWith("negotiation")) {
                                    window.location.href = window.location.href + "?workItemId=" + $this.data("workitem-id");

                                }

                            } catch (e) {
                                console.log(e);
                            }


                        },
                        error: function (jqXHR, textStatus, errorThrown) {

                        },
                        dataType: "json",
                        complete: getOffer(false)
                    });
                }, interval);
            })(true);
        }, interval);
    })(true);

};

DeWeb.Utilities.exchangeTransactions = function ($this) {
    var formId = $this.data('form-id');
    $(document).on('submit', '#form_' + formId, function () {
        DeWeb.Ui.HidePopup();
    });
}

DeWeb.Utilities.GetForDate = function ($this) {
    var dateFieldId = $this.data("field");
    var form = $this.data("formid");
    form = "form_" + form;

    $("#" + dateFieldId).change(function () {

        $("#" + form).submit();
    });

};

DeWeb.Utilities.NavigateToAction = function ($this) {


    $this.click(function (e) {

        e.preventDefault();
        var link = $this.data("href");
        window.location = link;
    });


};

DeWeb.Utilities.swipeExchangeOrders = function ($this) {

    $this.click(function () {
        var dir = $this.data("direction");
        var ids = $("#exchangeOrderident").data("exchangeorderlist");
        var current = $this.parent().data("current");
        currentId = ids.indexOf(current.toString());
        if (currentId + parseInt(dir) > ids.length || currentId + parseInt(dir) < 0) {
            return;
        }
        next = ids[currentId + parseInt(dir)];
        $("#" + next).trigger("click");

    });

}

DeWeb.Utilities.negotiationEligibilityCheck = function ($this) {
    var updateUrl = $this.data('update-url');
    var redirectUrl = $this.data('redirect-url');
    var intervalJson = $this.data('interval');
    var urlParam = $this.data('url-param');
    var otherParams = $this.data('other-params');
    (function check(firstTime) {
        var interval = firstTime == true ? 0 : intervalJson;
        setTimeout(function () {
            $.ajax({
                url: updateUrl,
                success: function (result) {
                    try {
                        if (result.IsSuccesfull === true || result.IsSuccesfull == undefined) {
                            if (result !== undefined) {
                                if (result[1] == "offered") {
                                    window.location.replace(window.location.protocol + "//" + window.location.host + redirectUrl + "?" + urlParam + "=" + result[0] + otherParams);
                                }
                            }
                        }
                    } catch (e) {
                        console.log(e);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                },
                dataType: "json",
                complete: check(false)
            });
        }, interval);
    })(true);
}

DeWeb.Utilities.getCurrencyFromSelectedAccount = function ($this) {
    var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
    var currency = selectedSlide.find(".ui-selectmenu-text").text();
    var currencyField = $("#FromCurrency_ID");
    currencyField.val(currency);

    var debtorrAcc = $("#DebitedAccount_ID");
    debtorrAcc.change(function () {
        var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
        var currency = selectedSlide.find(".ui-selectmenu-text").text();
        var currencyField = $("#FromCurrency_ID");
        currencyField.val(currency);

        var currencyPicker = selectedSlide.find("#select-currency-1");
        currencyPicker.change(function () {
            var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
            var currency = selectedSlide.find(".ui-selectmenu-text").text();
            var currencyField = $("#FromCurrency_ID");
            currencyField.val(currency);
        });
    });

    var currencyPicker = selectedSlide.find("#select-currency-1");
    currencyPicker.change(function () {
        var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
        var currency = selectedSlide.find(".ui-selectmenu-text").text();
        var currencyField = $("#FromCurrency_ID");
        currencyField.val(currency);
    });
};

DeWeb.Utilities.repeatExchangeOrder = function ($this) {
    var repeatLink = $("#new-payment");
    repeatLink.attr("onclick", "");
    var exchangeUrl = $this.data("url");
    repeatLink.attr("href", exchangeUrl);
};
/**
 * Utility added by RO team in order to implement custom SDD behavior regarding credited account filtering
 * and currency filtering.
 */
/*** Handles currency selection change to display correct value. ***/
DeWeb.Events.changeDirection = function (sender, e) {
    var loc_sell = $('#Direction_Sell_ID').val();    
    var loc_buy = $('#Direction_Buy_ID').val();
    var cc = sender.val();
    var accid = $("#DebitedAccount_ID").val();
    var currencies = [];
    $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
        currencies.push($(this).val());
    });
    currencies = currencies.filter(Boolean);
    var isDebitedCurrency = false;
    currencies.forEach(function (el) {
        if (el === cc)
            isDebitedCurrency = true;
    });
    $('#Conversion_Direction_ID').val(isDebitedCurrency ? loc_sell : loc_buy);
    $('#Conversion_Direction_ID').css('border', '0px');
    $('#Conversion_Direction_ID').css('text-transform', 'uppercase');
}
/*** Handles credited account change. ***/
var setExchangeCurrency = true;
DeWeb.Utilities.switchCurrenciesExchange = function ($this) {
    creditorSlider = $("#CreditedAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
    //Filter Slides according to debtor account currency
    var filterSlides = function (currencies, indic) {
        var $mainSlider = $("#CreditedAccount_ID_slider");
        var currentSlides = [];
        var mockFirst = 0;
        $mainSlider.find(".slide").each(function () {
            $mainSlider.slick('slickRemove', mockFirst);
        });
        /*** Previous credited account (perhaps from step 2). ***/
        var prevCreditedAccount = null;
        initialize.each(function () {
            if (currencies.indexOf($(this).data("currency")) === -1) {
                $mainSlider.slick('slickAdd', $(this));
                /*** Get jQuery instance in a variable so that we can later find it in the currentSlides array. ***/
                var reference = $(this);
                currentSlides.push(reference);
                var $id = $(this).attr('id');
                try {
                    if (typeof $id != 'undefined')
                    {
                        if ($(this).data("accountnumber") === $("#CreditedAccount_ID").val() &&
                            $(this).attr('id').indexOf('cloned') == -1) {
                            prevCreditedAccount = reference;
                        }
                    }
                    else
                    {
                        if ($(this).data("accountnumber") === $("#CreditedAccount_ID").val())
                        {
                            prevCreditedAccount = reference;
                        }
                    }
                } catch (e) {
                    console.log(e);
                }

            }
        });
        // add mockslides 
        if (currentSlides.length === 1 || currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }
        }
        $mainSlider.slick('unslick');
        /*** Added condition to test if there is no credited account. ***/
        if (currentSlides.length === 0) {
            $("#CreditorAccount_ID").val('');
            $('.slider-button-prev.slider-button-prev-CreditedAccount_ID').attr('style', 'display: none;');
            $('.slider-button-next.slider-button-next-CreditedAccount_ID').attr('style', 'display: none;');
        } else {
            $('.slider-button-prev.slider-button-prev-CreditedAccount_ID').attr('style', '');
            $('.slider-button-next.slider-button-next-CreditedAccount_ID').attr('style', '');
            var i = -1;
            var focus = 1;
            if (currentSlides.length === 1 || currentSlides.length === 2) {
                focus = 0;
            }
            /*** Set previous credited account. ***/
            if (prevCreditedAccount)
                focus = currentSlides.indexOf(prevCreditedAccount);
            var selectedAccount = $(currentSlides[focus]).data("accountnumber");
            $mainSlider.slick(getSlickSettings(focus));
            DeWeb.LoadUtilities($mainSlider.parent());
            /*** If no previous valid credited account, set new value ***/
            if (!prevCreditedAccount)
                $("#CreditedAccount_ID").val(selectedAccount);
        }        
    };
    //Filter Currencies
    var filterCurrencies = function (currencies, id, runFilterSlides) {
        if (currencies == null) {
            var accid = $("#DebitedAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        var creditedCurrencies = [];
        currencies = currencies.filter(Boolean);
        if (currencies.length !== 0 && initialize) {
            if (runFilterSlides)
                filterSlides(currencies, true);
            var accid2 = $("#CreditedAccount_ID").val();
            $(".slide[data-accountnumber=" + accid2 + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
                creditedCurrencies.push($(this).val());
            });            
        }
        currencies = currencies.filter(Boolean);
        creditedCurrencies = creditedCurrencies.filter(Boolean);
        var selectedCurrency = $("input[type=hidden][name=" + id + "]").val();
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');                
                if (setExchangeCurrency) {
                    setExchangeCurrency = false;
                    var firstVal = creditedCurrencies[0];

                    if (firstVal !== selectedCurrency) {
                        $("#" + id).children().find(".dd-selected-text").text(firstVal);
                        $("input[type=hidden][name=" + id + "]").val(firstVal);
                        $(this).parent().addClass("dd-option-selected");
                        $("input[type=hidden][name=" + id + "]").trigger('change');
                        $("input[type=hidden][name=" + id + "]").trigger('ddslickChanged');
                    }
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
        DeWeb.Events.changeDirection($('#ForeignCurrency_Code_ID').children().find('.dd-selected-value'));
    };
    var currency =
    {
        Id: "ForeignCurrency_Code_ID",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
            case 'AccountChanged':
                break;
            case 'CurrencyChanged':
                if (args.AccField.replace("_slider", "") === "DebitedAccount_ID"
                    || args.AccField.replace("_slider", "") === "CreditedAccount_ID") {
                    // filterCurrencies(args.Currency, $this.attr("id"), args.AccField.replace("_slider", "") === "DebitedAccount_ID");
                    setExchangeCurrency = true;
                    filterCurrencies(null, $this.attr("id"), args.AccField.replace("_slider", "") === "DebitedAccount_ID");
                }
                break;
            }
        }
    }

    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"), true);
        ebs.AddListener(currency);

    });
};



DeWeb.Utilities.negotiationEligibilityCheck = function ($this) {
    var updateUrl = $this.data('update-url');
    var redirectUrl = $this.data('redirect-url');
    var intervalJson = $this.data('interval');
    var urlParam = $this.data('url-param');
    var otherParams = $this.data('other-params');
    (function check(firstTime) {
        var interval = firstTime == true ? 0 : intervalJson;
        setTimeout(function () {
            $.ajax({
                url: updateUrl,
                success: function (result) {
                    try {
                        if (result.IsSuccesfull === true || result.IsSuccesfull == undefined) {
                            if (result !== undefined) {
                                if (result[1] == "offered") {
                                    window.location.replace(window.location.protocol + "//" + window.location.host + redirectUrl + "?" + urlParam + "=" + result[0] );
                                }
                            }
                        }
                    } catch (e) {
                        console.log(e);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                },
                dataType: "json",
                complete: check(false)
            });
        }, interval);
    })(true);
}

DeWeb.Utilities.getCurrencyFromSelectedAccount = function ($this) {
    var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
    var currency = selectedSlide.find(".ui-selectmenu-text").text();
    var currencyField = $("#FromCurrency_ID");
    currencyField.val(currency);

    var debtorrAcc = $("#DebitedAccount_ID");
    debtorrAcc.change(function () {
        var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
        var currency = selectedSlide.find(".ui-selectmenu-text").text();
        var currencyField = $("#FromCurrency_ID");
        currencyField.val(currency);
        
        var currencyPicker = selectedSlide.find("#select-currency-1");
        currencyPicker.change(function () {
            var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
            var currency = selectedSlide.find(".ui-selectmenu-text").text();
            var currencyField = $("#FromCurrency_ID");
            currencyField.val(currency);
        });
    });

    var currencyPicker = selectedSlide.find("#select-currency-1");
    currencyPicker.change(function () {
        var selectedSlide = $("#DebitedAccount_ID_slider").find(".slick-center");
        var currency = selectedSlide.find(".ui-selectmenu-text").text();
        var currencyField = $("#FromCurrency_ID");
        currencyField.val(currency);
    });
};

DeWeb.Utilities.disableLimits = function ($this) {
    $this.click(function () {
         
        var selected = $this.children().hasClass("checked");
        if (selected) {
            $("[data-name=" + $this.parent().parent().data("wrapper-for") + "ENABLE]").children().removeClass("checked");
            $this.children().addClass("checked");
        }
        else {
            wrapper = $this.parent().parent();
            nextwrapper = wrapper.next();
            
            var nextSelected = nextwrapper.children()[1];
            if (nextSelected == undefined) {
                nextSelected = $(".notification-wraper").first().children()[1];
            }
            var child = $(nextSelected).children()[1];
            $(child).children().addClass("checked");
        }
        
        var selectedGroupFinal = "";
        $("[data-name=" +$this.parent().parent().data("wrapper-for")+ "ENABLE]").each(function () {
            if ($(this).children().hasClass("checked")) {
                selectedGroupFinal = $(this).data("group-id");
            }
        });
        var limitGroupType = $this.parent().parent().data("wrapper-for") == "domestic-card-use" ? "DomesticGroupId" : "ForeignGroupId";
        $("[name="+limitGroupType+"]").val(selectedGroupFinal);
    });
};


DeWeb.Utilities.cardUsageType = function ($this) {
 


    $this.click(function () {
        $("li").removeClass("active");
        console.log($this.data("show-use"));
        console.log($(".notification-wrapper [data-wrapper-for=" + $this.data("show-use") + "]"));
        $this.addClass("active");
        $(".notification-wraper").css("display", "none");
        $("[data-wrapper-for=" + $this.data("show-use") + "]").css("display","block");
    });
};


DeWeb.Utilities.setCardSwitch = function ($this) {
    var CardSwitch = 
        {
            Id: "CardSwitch",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'CardSwitchChangeCanceled':
                        $('#' + args.Data.id).prop('checked', args.Data.enabled);
                        break;
                }
            }
        };
    ebs.AddListener(CardSwitch);

    $this.on('change', function () {
        DeWeb.Ui.BlockElement('switches_container');
        $.get($this.data('href')).done(function (data) {
            DeWeb.Ui.ShowPopup(data, 'narrow', '');
            DeWeb.Ui.UnBlockElement('switches_container');
        });
    });
}

DeWeb.Utilities.cancelSwitchChange = function ($this) {
    $this.click(function () {
        var swType = $this.data('switch-name');
        if ($("[data-switch-type=" + swType + "]").children().hasClass("checked")) {
            $("[data-switch-type=" + swType + "]").children().removeClass("checked");
            $("[name=" + swType + "]").prop("checked", false);

        }
        else {
            $("[data-switch-type=" + swType + "]").children().addClass("checked");
            $("[name=" + swType + "]").prop("checked", true);
        }
    });
};

$(document).on('click', "#confirmation_card_limits", function (e) {

    e.preventDefault();
    DeWeb.Ui.ShowPopup($('#limit-group-change-confirmation').html(), 'narrow', '');
    $("#popup-content-narrow").removeClass("popup-1");
});
DeWeb.Utilities.saveChanges = function ($this) {
    $this.click(function () {
        formId = "form_" + $this.data("form-id");
        $("#" + formId).submit();
        DeWeb.Ui.HidePopup();
    });

};


DeWeb.Utilities.resetLimits = function ($this) {
    $this.click(function() {
        
        if (!$this.children().hasClass("checked")) {
            $this.parent().next().children().find("[data-type=specific]").each(function () {
                $(this).val("0");
            });

        } else {
            $this.parent().next().children().find("[data-type=specific]").each(function () {

                $(this).val($(this).data("initial-value"));
            });
        }
       


    });

};
DeWeb.Utilities.setCardSwitch2 = function ($this) {
    var CardSwitch =
        {
            Id: "CardSwitch",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'CardSwitchChangeCanceled':
                        $('#' + args.Data.id).prop('checked', !args.Data.enabled);
                        break;
                }
            }
        };
    ebs.AddListener(CardSwitch);

    $this.on('change', function () {
        DeWeb.Ui.BlockElement('switches_container');
        $.get($this.data('href')).done(function (data) {
            DeWeb.Ui.ShowPopup(data, 'narrow', '');
            DeWeb.Ui.UnBlockElement('switches_container');
        });
    });
};

var paging = 1;
//Faq search filtering
function ContainsKeyWords(divelement) {
    var returnVAL = false;
    var searchVal = $("#search-bar-faq").val().toLowerCase();
    if (searchVal == "") return true;
    var content = $(divelement).find($("p"));

    content.each(function () {

        var text = $(this).text().toLowerCase();
        if (text.indexOf(searchVal) != -1) {
            returnVAL = true;
        }

    });
    var contentQ = $(divelement).find($("h4"));
    contentQ.each(function () {

        var text = $(this).text().toLowerCase();
        if (text.indexOf(searchVal) != -1) {
            returnVAL = true;
        }

    });
    return returnVAL;
};



DeWeb.Utilities.filterCategoryQuestions = function ($this) {
    //Faq category filtering 
    
    $(document).on("change", "#"+$this.data("field-id"), function () {
        $form = $("form#form_"+$this.data("form-id"));
        $form.submit();
    })
}
DeWeb.Utilities.triggerGoals = function ($this) {

    $this.click(function (e) {
        e.preventDefault();
        $this.toggleClass('show');
        $this.closest('.pfm-goal').find('.hidden').slideToggle();
    });

};


//Faq search filtering
function ApplyFiltersAndPaging() {


    $("[name=faq]").each(function () {

        if (ContainsKeyWords($(this))) {

            $(this).show();
        }
        else {
            $(this).hide();

        }
    });


}

//Contacts
$(document).on("click", "[data-type=contact]", function ()
{
    var url = $(this).data("url");
    var type = $(this).data("contact");
    if (type == "email")
    {
        url = "mailto:" + url;
        window.open(url, "_blank");
        return;
    }

    if (!url.startsWith("http")) {
        return;
    }
    window.open(url, "_blank");


})

//Faq Search
$(document).on("keyup", "#search-bar-faq", function () {
  
    ApplyFiltersAndPaging();
});


//Contacts
$(function () {
    if ($("body.contacts-prelogin").length > 0)
    {
        markupHide = "postlogin-markup";
        $("[data-type=" + markupHide + "]").remove();
    }
    if ($("body.contacts-postlogin").length > 0)
    {
        markupHide = "prelogin-markup";
        $(".inner").removeClass();
        $("[data-type="+markupHide+"]").remove();
    }
});
//Contact Map
DeWeb.Utilities.contactMap = function ($this) {
    var source = $this.data('source');
    var ctPath = $this.data('content-path');

    DeWeb.Functionalities.AtmBranchMap.Init(source, ctPath);

}

//News details 
DeWeb.Utilities.parseHtml = function ($this) {
    $this.click(function () {
        $("#news-title").text("");
        $("#news-stand").text("");
        $("#news-title").append("<h3>"+$this.data("title")+"</h3>");
        $("#news-stand").append("<h6>" + $this.data("text") + "</h6>");
        $link = $this.data("url");
        $("#news-url").attr("href", $link);
    });
    return true;

};

DeWeb.Utilities.parseNewsHtml = function ($this) {
    $this.click(function () {
        $("#news-title").text("");
        $("#news-stand").text("");
        $("#news-date").text("");
        $("#news-feeder").text("");
        $("#news-image").text("");
        $("#news-number").text("");
        $("#news-title").append($this.data("title"));
        $("#news-stand").append($this.data("text"));
        $("#news-date").append($this.data("date"));
        $("#news-feeder").append($this.data("feeder"));
        $("#news-image").append($this.data("image"));
        $("#news-number").append($this.data("number"));
        $link = $this.data("url");
        $("#news-url").attr("href", $link);
    });
    return true;

};

DeWeb.Utilities.disablePatterns = function ($this) {
    $("#MonthlyOccurenceId").find("[data-class=Opt1]").css("display", "block");
    $("#MonthlyOccurenceId").find("[data-class=Opt2]").css("display", "none");
    $this.parent().click(function() {
        var classy = $this.val();
        var classx = "Opt"+Math.abs(3 - parseInt(classy.replace("Opt", "")));
        $("#MonthlyOccurenceId").find("[data-class=" + classy + "]").css("display", "block");
        $("#MonthlyOccurenceId").find("[data-class=" + classx + "]").css("display", "none");
    }); 

};

DeWeb.Utilities.parseDuration = function ($this) {
    $this.timepicker().on("input change", function (e) {
        var startTime = $("[name=StartTime_ID]").timepicker('getTime');
        var endTime = $("[name=EndTime_ID]").timepicker('getTime');
        var hrspan = Math.abs(endTime.split(':')[0] - startTime.split(':')[0]);
        var minspan = Math.abs(endTime.split(':')[1] - startTime.split(':')[1]);
        var span = hrspan * 60 + minspan;
        $("#Duration_ID").val("PT"+hrspan+ "H" +minspan+ "M");
       
    });
    
};

DeWeb.Utilities.swipeNews = function ($this) {
    var nextButton = ($this).find(".next-box");
    var prevButton = ($this).find(".prev-box");
    nextButton.click(function () {
        var currentNewsText = ($this).find("#news-number").text();
        var currentNews = parseInt(currentNewsText);
        var nextNewsNumber = currentNews + 1;

        $("div[data-number='" + nextNewsNumber + "']").trigger("click");
    });
    prevButton.click(function () {
        var currentNewsText = ($this).find("#news-number").text();
        var currentNews = parseInt(currentNewsText);
        var prevNewsNumber = currentNews - 1;

        $("div[data-number='" + prevNewsNumber + "']").trigger("click");
    });
};
DeWeb.Pages.VirtualInbox = new function () {
    var statusId = '';
    var categoryId = '';
    var messsageStatusId = '';
    var directionId = '';
    var init = function ($viContainer) {
        $(function() {
            var $form = $viContainer.parents('form');
            statusId = $viContainer.data('status-field');
            directionId = $viContainer.data('direction-field');
            messsageStatusId = $viContainer.data('message-status-field');
            categoryId = $viContainer.data('category-field');
            if (statusId) {
                var $statusField = $('#' + statusId);
                var $directionField = $('#' + directionId);
                var $messageStatusField = $('#' + messsageStatusId);
                $('#status-picker').on('click', 'a[data-name=statusForm]', function (evt) {
                    evt.stopPropagation();
                    evt.preventDefault();
                    var $li = $(this);
                    var status = $li.data('statuses');
                    $statusField.val(status);
                    var direction = $li.data('direction');
                    $directionField.val(direction);
                    var messageStatus = $li.data('message-status');
                    $messageStatusField.val(messageStatus);
                    $form.submit();
                });
            }
            if (categoryId) {
                var $categoryField = $('[name=' + categoryId + ']');
                $(document).on('change', '[name=' + categoryId + ']', function () {
                    $form.submit();
                });
            }
        });
    }

    return {
        Init : init
    }
};
DeWeb.Utilities.archiveMsg = function ($this) {
    $this.click(function () {
        $.ajax({
            url: $this.data("href"),
            success: function () {
                try {
                    DeWeb.Ui.HidePopup();
                    $("#popup-content-narrow").removeClass("popup-1");
                    DeWeb.Ui.ShowPopup($('#notification-msg').html(), 'narrow', '');
                } catch (e) {
                    console.log(e);
                }

            }
        });
    });

};
DeWeb.Utilities.virtualInbox = function ($this) {

    DeWeb.Pages.VirtualInbox.Init($this);
}
//Filter read unread and priority messages -- substatuses of received
DeWeb.Utilities.filterMessages = function ($this) {
    $this.click(function () {
        var criteria = $this.data("criteria");
        var status = $("#Statuses_ID").val();

        $("a").removeClass("active");
        $this.addClass("active");
        if (status != "received,archived") {
            $("#Statuses_ID").val("received,archived");
            $("#form_MailboxMessages_GetList_FormId").submit();
        }
        $("div[data-type=msg]").css("display", "block");
        $("div[data-type=msg]").each(function () {
            if ($(this).data(criteria) != "True") {
                $(this).css("display", "none");
            }
            else {
                $(this).css("display", "block");
            }
        });





    });
};

DeWeb.Utilities.openMessageDetails = function ($this) {
    $this.on('click', function(e) {
        $(this).find('i.recived-msg').removeClass('unread').addClass('red');
        e.preventDefault();
        var href = $this.data('details-href');
        if (href) {
            $.get(href, function(data) {
                //DeWeb.Ui.ShowPopup(data, 'wide');
                $('<div class="msg-details-popup">' + data + '</div>').dialog().dialog('show');
                DeWeb.LoadUtilities($('.msg-details-popup'));
            });
        }

    });

}
DeWeb.Utilities.dataCount = function ($this) {
    var updateUrl = $this.data('update-url');
    $.ajax({
        url: updateUrl,
        success: function (dataNum) {
            try {

                $this.text("");

                $this.append("" + dataNum + "");


            } catch (e) {
                console.log(e);
            }


        },
        error: function (jqXHR, textStatus, errorThrown) {

        },
        dataType: "json",
   
    });
};
//Message Count and Notification display! 
DeWeb.Utilities.messagesCount = function ($this) {
    var updateUrl = $this.data('update-url');
    var logoutUrl = $this.data('logout-url');
    var intervalJson = $this.data('interval');
    var redirectUrl = $this.data('redirect-url');
    var mainClass = $('#main-class').data('main-class');
    var prependTo = "#" + mainClass;
    if (intervalJson === undefined) {
        intervalJson === 20000;
    }
    (function pollMessages(firstTime) {
        var interval = firstTime === true ? 0 : intervalJson;
        setTimeout(function () {
            $.ajax({
                url: updateUrl,
                success: function (jsonMailboxUnread) {
                    try {

                        if (jsonMailboxUnread.IsSuccesfull === true || jsonMailboxUnread.IsSuccesfull == undefined) {
                            if (jsonMailboxUnread !== undefined) {
                                if (jsonMailboxUnread[4] === "true") {
                                    //document.cookie = "";
                                    window.location.replace(redirectUrl);
                                }
                                /// set icon unread message count
                                $this.text("" + jsonMailboxUnread[0] + "");
                                if (jsonMailboxUnread[5] !== "") {
                                    var timeOutTime = jsonMailboxUnread[5];
                                    if ($('#current-notification').length === 0) {
                                        window.setTimeout(function () {
                                            DeWeb.Ui.ShowNotification({
                                                isFaulty: false,
                                                title: '',
                                                prependTo: prependTo,
                                                content: $('#info-container-temp').html()
                                            });
                                        }, timeOutTime);
                                    }
                                }
                                else {
                                    if (jsonMailboxUnread[1] != "0" && firstTime) {
                                        var priorityId = jsonMailboxUnread[3];
                                        var text = $this.data("additional-text") + "  " + jsonMailboxUnread[1];
                                        var detailsLink = $this.parent().attr("href") + "/Details" + "/" + priorityId;
                                        var title = "Title: " + jsonMailboxUnread[2];
                                        var iconClick = '<i data-utility="popupFromLink" data-popup-type="side" data-href="' + detailsLink + '" class="icon-mail-3"> </i>';
                                        DeWeb.Ui.ShowNotification({
                                            isFaulty: false,
                                            title: $this.data("additional-title"),
                                            prependTo: '#main',
                                            content: $('<div  id="error-container-temp" style="display: none"><p>' + text + '</p><p>' + iconClick + title + '</p></div>').html()

                                        });

                                    }
                                }
                            }
                        }


                    } catch (e) {
                        console.log(e);
                    }


                },
                error: function (jqXHR, textStatus, errorThrown) {

                },
                dataType: "json",
                complete: pollMessages(false)
            });
        }, interval);
    })(true);
};


DeWeb.Utilities.archiveMessage = function ($this) {

    $this.on('click', function () {
        var archiveUrl = $this.data('archive-url');
        var messageid = $this.data('messageid');
        $.ajax({
            url: archiveUrl,
            type: 'POST',
            data: {
                MessageIds_ID: messageid
            },
            success: function (data) {
                alert('Archived');

            },
            error: function (jqXHR, textStatus, errorThrown) {
                alert('Not Archived');
            },
            dataType: "json"
        });
    });

};
//Mailbox Messages -EDN


//Notification Preferences V2 -START

DeWeb.Utilities.setMediumChecked = function ($this) {
    var checkboxId = $this.data("check-id");
    $this.click(function (event,param) {
      
        if (param != undefined && param== false) {
            $this.children().first().removeClass("checked");
        }
        if (param != undefined && param == true) {
            $this.children().first().addClass("checked");

        }
        $("[type=checkbox]#" + checkboxId).prop("checked", $this.children().first().hasClass("checked"));
        $("[type=checkbox]#" + checkboxId).val($this.children().first().hasClass("checked"));
       
        
    });

}
DeWeb.Utilities.setChildrenPreferences = function ($this) {
    $this.click(function() {

        if (!($this.children().first().hasClass("checked"))) {
            $("[data-id=" + $this.data("group") + "]").each(function() { $(this).trigger("click", [false]); });
        }
    });
}
//Notification Preferences V2 -END
DeWeb.Utilities.mapToField = function ($this) {
    $this.change(function () {
    
        $("#" + $this.data("id")).val($this.val());
    });
}


DeWeb.Utilities.refreshPage = function ($this) {
    $this.click(function () {
        $('#side-modal-inbox').load(document.URL + ' #side-modal-inbox');
    });
}




//SearchBox Mailbox 
DeWeb.Utilities.searchMsgs = function ($this) {
    $this.on("keyup", function () {
        $("[data-type=" + $this.data("objname") + "]").each(function () {
            var actualtxt = $(this).text().toLowerCase();
            var searchtxt = $this.val().toLowerCase();
            if (actualtxt.indexOf(searchtxt) == -1) {
                $(this).css("display", "none");
            }
            else {
                $(this).css("display", "block");

            }
        });
        
    });
};

//Next Message not ok
DeWeb.Utilities.swipeMsg = function ($this) {
    $this.click(function () {
        var dir = $this.data("direction");
        var ids = $("#msgident1").data("msglist");
        var current = $this.parent().data("current");
        currentId = ids.indexOf(current.toString());
        if (currentId + parseInt(dir) > ids.length || currentId + parseInt(dir) < 0) {
            return;
        }
        next = ids[currentId + parseInt(dir)];
        $("#" + next).trigger("click");
        var unreadedMessage = $("#" + next).find("[data-utility='readMessage']");
        if (unreadedMessage.length == 1)
        {
            var nextMessage = $("#" + next).find("p.msg-title");
            nextMessage.find("span").css("font-weight", "normal");
            var readed = $('body').find("[data-message-status='readed']");
            var unread = $('body').find("[data-message-status='not-readed']");
        //    var urgent = $('body').find("[data-message-status='urgent']");
            var readedCount = readed.find('span').text();
            var unreadedCount = unread.find('span').text();
         //   var urgentCount = urgent.find('span').text();
            readed.find('span').text(parseInt(readedCount) + 1);
            unreaded.find('span').text(parseInt(unreadedCount) - 1);
          //  urgent.find('span').text(parseInt(urgentCount) + 1);

        }
    });
   
};
DeWeb.Utilities.getIdsAndRedirect = function ($this) {
    var redirHref = $this.data('redirect-to');
    var query = $this.data('query-param');

    //If HREF AND POPUPTYPE
    var pType = $this.data('popup-type');

    $this.on('click', function () {

        var $collect = $('.id-collection');
        var ids = [];
        if ($collect.length) {
            $collect.each(function () {
                var $that = $(this);
                var id = $that.data('for-id');
                //Only for packages .... 
                if ($this.data("is-auth")) {
                    id = $that.data("for-auth");
                }
                if (id) {
                    if ($that.is(':checkbox')) {
                        if ($that.prop('checked')) {
                            ids.push(id);
                        }
                    } else if ($that.data('selected')) {
                        ids.push(id);
                    }

                }
            });

            if (ids.length && pType && redirHref) {
                var preloadHref = redirHref + "?" + query + "=" + ids.join();
                $.get(preloadHref, function (data) {
                    DeWeb.Ui.ShowPopup(data, pType);
                });
            }
            else if (ids.length && !pType) {
                var preloadHref = redirHref + "?" + query + "=" + ids.join() + "&cmd=preload";
                $.get(preloadHref, function (data) {
                    if (data) {
                        window.location = redirHref + "?" + "workitemid" + "=" + data;
                    }
                });
            }
        }
    });
};



// Set Geolocation
DeWeb.Functionalities.setGeolocationMap = new function () {
    // Map properties
    var selfLocationImg = {};
    var newLocationImg = {};
    var MAPTYPE = "";
    var markers = [];
    var map = {};
    var latid = "";
    var addid = "";
    var mainInfobox = {};
    var initialLocationImg = {};
    var addMarker = function (addtoMap, icon, infoboxContent, position, markerDescription) {
        var markerObj = {
            type: markerDescription.type,
            address: markerDescription.address,
            name: markerDescription.name,
            marker: new google.maps.Marker({
                position: position,
                map: addtoMap,
                icon: icon
            })
        };

        google.maps.event.addListener(markerObj.marker, 'click', function () {
            mainInfobox.close();
            mainInfobox.setContent(infoboxContent);
            mainInfobox.open(addtoMap, this);
        });


        markers.push(markerObj);
        map.setCenter(markerObj.marker.getPosition());
    };
    var preinit = function (bpath) {
        var baseContentPath = bpath;

        mainInfobox = new InfoBox({
            content: '',
            disableAutoPan: false,
            maxWidth: 200,
            pixelOffset: new google.maps.Size(20, -100),
            zIndex: null,
            boxStyle: {
                background: "",
                opacity: 1
            },
            closeBoxMargin: "10px 10px 0 0",
            closeBoxURL: baseContentPath + "img/icons/close.png",
            infoBoxClearance: new google.maps.Size(1, 1)
        });
        // Location pins
        selfLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-4.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        newLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-3.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        initialLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-4.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        var addMarker = function (addtoMap, icon, infoboxContent, position, markerDescription) {
            var markerObj = {
                type: markerDescription.type,
                address: markerDescription.address,
                name: markerDescription.name,
                marker: new google.maps.Marker({
                    position: position,
                    map: addtoMap,
                    icon: icon
                })
            };

            google.maps.event.addListener(markerObj.marker, 'click', function () {
                mainInfobox.close();
                mainInfobox.setContent(infoboxContent);
                mainInfobox.open(addtoMap, this);
            });
            markers.push(markerObj);
            map.setCenter(markerObj.marker.getPosition());
        };
    }
    var init = function (latId, lngId, addId, bpath) {
        latid = latId; lngid = lngId; addid = addId;
        var position = new google.maps.LatLng(parseFloat($("#" + latid).val().replace(',', '.')), parseFloat($("#" + lngid).val().replace(',', '.')));
        var geocoder = new google.maps.Geocoder;

        // Map options and styles
        var map_canvas = document.getElementById('geolocation-map');
        var styles = [
            { "featureType": "water", "elementType": "geometry.fill", "stylers": [{ "color": "#d3d3d3" }] }, { "featureType": "transit", "stylers": [{ "color": "#808080" }, { "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "geometry.stroke", "stylers": [{ "visibility": "on" }, { "color": "#b3b3b3" }] }, { "featureType": "road.highway", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "road.local", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#ffffff" }, { "weight": 1.8 }] }, { "featureType": "road.local", "elementType": "geometry.stroke", "stylers": [{ "color": "#d7d7d7" }] }, { "featureType": "poi", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#ebebeb" }] }, { "featureType": "administrative", "elementType": "geometry", "stylers": [{ "color": "#a7a7a7" }] }, { "featureType": "road.arterial", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "road.arterial", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "landscape", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#efefef" }] }, { "featureType": "road", "elementType": "labels.text.fill", "stylers": [{ "color": "#696969" }] }, { "featureType": "administrative", "elementType": "labels.text.fill", "stylers": [{ "visibility": "on" }, { "color": "#737373" }] }, { "featureType": "poi", "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] }, { "featureType": "poi", "elementType": "labels", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.arterial", "elementType": "geometry.stroke", "stylers": [{ "color": "#d6d6d6" }] }, { "featureType": "road", "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] }, {}, { "featureType": "poi", "elementType": "geometry.fill", "stylers": [{ "color": "#dadada" }] }
        ];

        var map_options = {
            center: new google.maps.LatLng(40.748655, -73.989980),
            zoom: 12,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: false,
            draggable: !("ontouchend" in document),
            styles: styles,
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_BOTTOM
            },
            mapTypeControlOptions: {
                position: google.maps.ControlPosition.BOTTOM_LEFT
            }
        }
        map = new google.maps.Map(map_canvas, map_options);

        // Marker placements
        var addMyMarker = function (results, selfLocationImg, position) {
            var result = '';
            if (results[0] != null) {
                result = results[0];
            }
            var infoboxTemplate = $('#infobox-template').html();
            var content = infoboxTemplate.replace("{infobox-id}", "self")
                .replace("{location-title}", "Your location.")
                .replace("{location-info}", result.formatted_address);

            addMarker(map, selfLocationImg, content, position, { type: 'self' });
        };

        //Add current geolocation if exists

        if (!isNaN(position.lat()) && !isNaN(position.lng())) {

            placeMarker(position, initialLocationImg);
        }




        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var pos = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                //todo insert icon self
                map.setCenter(pos);
                reverseGeocoding(geocoder, map, pos, function (results) {
                    addMyMarker(results, selfLocationImg, pos);
                });
            }, function () {
                //handleLocationError(true, infoWindow, map.getCenter());
            });
        }



        //Click on map - place pin and remember location as potential transfer geolocation
        google.maps.event.addListener(map, "click", function (e) {
            var latLng = e.latLng;
            var lat = latLng.lat();
            var lng = latLng.lng();
            var address = "";
            reverseGeocoding(geocoder, map, latLng, function (results) {
                address = results[0].formatted_address;
                placeData(lat, lng, address);
                placeMarker(e.latLng, newLocationImg);
            });

        });

        $("#noresults").click(function () {
            $("#noresults").slideUp(300);
            $("#noresults").css("display", "none");
        })
    }

    //Geocoding and reverse geocoding
    var reverseGeocoding = function (geocoder, map, latlng, callback) {
        geocoder.geocode({ 'location': latlng }, function (results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
                if (results[0]) {
                    callback(results);
                } else {

                    //$("#noresults").slideDown(300);
                    console.log('No results found');
                }
            } else {
                //$("#noresults").slideDown(300);
                console.log('Geocoder failed due to: ' + status);
            }
        });
    };
    var geocoding = function (geocoder, map, address, callback) {
        geocoder.geocode({ 'address': address }, function (results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
                if (results[0]) {
                    callback(results);
                } else {
                    //$("#noresults").slideDown(300);
                    console.log('No results found');
                }
            } else {
                //$("#noresults").slideDown(300);
                console.log('Geocoder failed due to: ' + status);
            }
        });
    };

    //Helpers
    var removeTemporaryMarkers = function () {
        for (var i = 0; i < markers.length; i++) {
            if (markers[i].type == 'temporary-location') {
                markerObj = markers[i];
                markerObj.marker.setVisible(false);
                markers.slice(i, 1);
            }
        }
    };
    var placeData = function (lat, lng, address) {
        $("#" + latid).val(lat);
        $("#" + lngid).val(lng);
        $("#" + addid).val(address);
    }
    var placeMarker = function (location, icon) {
        removeTemporaryMarkers();
        var type = 'temporary-location';
        var name = '';
        if (icon == initialLocationImg) {
            type = 'current-location';
            name = 'Current transfer geolocation';
        }
        var infoboxTemplate = $('#infobox-template').html();
        var content = infoboxTemplate.replace("{infobox-id}", "geolocation")
            .replace("{location-title}", name)
            .replace("{location-info}", $("#" + addid).val());
        mainInfobox.close();
        addMarker(map, icon, content, location, { type: type });


    }


    //Calls
    var geocodeData = function (textSearch, callback) {
        var geocoder = new google.maps.Geocoder;
        geocoding(geocoder, map, textSearch, function (results) {
            var latlng = results[0].geometry.location;
            reverseGeocoding(geocoder, map, latlng, function (addressResults) {
                callback(addressResults);
                return;
            });

        })


    }
    var reverseGeocodeData = function (LATLNG) {
        var geocoder = new google.maps.Geocoder;
        var array = LATLNG.split(',');
        var lat = parseFloat(array[0]);
        var lng = parseFloat(array[1]);
        var pos = {
            lat: lat,
            lng: lng
        };
        var latlng = new google.maps.LatLng(lat, lng);
        var address = "";
        reverseGeocoding(geocoder, map, pos, function (results) {
            address = results[0].formatted_address;
            placeData(lat, lng, address);
            placeMarker(latlng, newLocationImg);
        });

    }
    return {
        PreInit: preinit,
        Init: init,
        GeocodeData: geocodeData,
        ReverseGeocodeData: reverseGeocodeData
    };

}





DeWeb.Utilities.SetGeo = function ($this) {

    DeWeb.Functionalities.setGeolocationMap.PreInit($this.data("base-path"));
    DeWeb.Functionalities.setGeolocationMap.Init($this.data("lat-id"), $this.data("lng-id"), $this.data("address-id"), $this.data("base-path"));

}

function GeocodeData(textSearch, done) {
    DeWeb.Functionalities.setGeolocationMap.GeocodeData(textSearch,
        function (result) {
            var restoreturn = [];
            for (index in result) {

                if (result[index]["geometry"] != undefined) {
                    var newreturntores = { label: result[index]["geometry"]["location"], value: result[index]["formatted_address"] };
                    restoreturn.push(newreturntores);
                }


            }
            done(restoreturn);
        });

}

function ReverseGeocodeData(geoloc) {
    geoloc = geoloc.substring(1, geoloc.length - 1);
    DeWeb.Functionalities.setGeolocationMap.ReverseGeocodeData(geoloc);

}










// Show Geolocation - transfers get
DeWeb.Utilities.showLocation = function ($this) {
    var source = $this.data('source');
    var bPath = $this.data('content-path');
    displayOn = "widget";
    realfacilities = $this.data("facilities-json");
    DeWeb.Functionalities.AtmBranchMap.Init(source, bPath, displayOn, realfacilities);
};
DeWeb.Utilities.openDetails = function ($this) {
    $("#Remove_account").parent().remove();
    $(".group").removeClass("uk-width-1-4");
    $(".group").addClass("uk-width-1-2");
    $("#NewAccountDetailsGroupId_right").children().after($("#Add_account_info").parent());
    $this.parent().siblings(".group").css("display", "none");
    console.log($this.siblings(".plain-list"));
    $this.parent().parent().parent().parent().find(".plain-list").parent().css("display", "block");
    $this.click(function () {

        if ($this.parent().siblings(".group").is(":visible")) {
            $this.parent().siblings(".group").slideUp(500);
            $this.parent().parent().parent().parent().find(".plain-list").parent().css("display", "block");

        }
        else {
            $this.parent().siblings(".group").slideDown(500);

        }
    });

};



DeWeb.Utilities.switchCurrencies = function ($this) {
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;

        if (currencies == undefined) {
            var accid = $("#DebtorAccount_ID").val();
            $(".slide[data-accountnumber='" + accid + "']").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
        {
            Id: "CurrencyId",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        break;
                    case 'CurrencyChanged':
                        if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                            filterCurrencies(args.Currency, $this.attr("id"));
                        }
                        break;
                }


            }
        }

    $(document).ready(function () {
        filterCurrencies([], $this.attr("id"));
        ebs.AddListener(currency);

    });
};

DeWeb.Utilities.includeInBody = function ($this) {
    var currentText = $("#BodyId_ID").val();
    var newText = $("[data-info=" + $this.data('for') + "]").text();

    $this.click(function () {
        if ($this.children().hasClass("checked")) {

            if (currentText.indexOf(newText) == -1) {
                var freshText = currentText + newText;
                $("#BodyId_ID").val(freshText);
            }
        }
        else {
            if (currentText.indexOf(newText) > -1) {
                var ntext = currentText.replace(newText, "");
                $("#BodyId_ID").val(ntext);
            }
        }

    });
};

DeWeb.Utilities.rememberChecks = function ($this) {
    var chcSelector = $this.data('checkbox-selector');
    
    var $checkboxes = $this.find(chcSelector);
    if (window.checkedBoxes && window.checkedBoxes.length && $checkboxes.length) {
        $.each($checkboxes, function () {
            var $that = $(this);
            for (var i = 0; i < window.checkedBoxes.length; i++) {
                var checked = window.checkedBoxes[i];
                var forId = $that.data('for-id');
                if (checked === forId) {
                    $that.attr('checked', true);
                    $that.addClass('checked');
                }
            }
        });
    }


    $this.on('change', chcSelector, function () {
        var forId = $(this).data('for-id');
        if (this.checked) {
            if (!window.checkedBoxes) {
                window.checkedBoxes = [];
            }
            window.checkedBoxes.push(forId);
        } else {
            if (!window.checkedBoxes) {
                window.checkedBoxes = [];
            }

            var index = window.checkedBoxes.indexOf(forId);
            if (index > -1) {
                window.checkedBoxes.splice(index, 1);
            }
        }
    });
};
DeWeb.Utilities.triggerSubProcess = function ($this) {
    $this.click(function () {
        $("form#form_" +$this.data("parent-form")).find("#" + $this.data("triggeraction")).trigger("click", []);

    });
};
DeWeb.Utilities.selectBeneficiary = function ($this) {
    $this.on('click', function () {
        var benId = $this.data('ben-id');
        var actionid = $this.data('action-id');
        var formId = $this.data('form-id');
        if (!formId) {
            var $parentForm = $this.parents('form');
            if ($parentForm.length) {
                formId = $parentForm.first().attr('id');
            }
        }

        $('#Beneficiary_ID').val(benId);
        DeWeb.Forms.setAction(formId, actionid);
    });
};


DeWeb.Utilities.mapToChoice = function ($this) {
    $this.on("click", function () {
        $("#DraftsId_ID").trigger("change", [$this.data("draft-id")]);

    });
};


DeWeb.Utilities.switchContent = function ($this) {
    var url = $this.data('switch-to-url');
    var replaceContent = $this.data('replace-content');
    var $replace = null;
    if (replaceContent) {
        $replace = $('#' + replaceContent);
    }
    $this.on('click', function () {
        DeWeb.AjaxForms.OnAjaxBegin(replaceContent);
        $.get(url).done(function (data) {
            if (data) {
                $replace.html(data);
                DeWeb.AjaxForms.OnAjaxComplete(replaceContent);
            } else {
                DeWeb.AjaxForms.OnAjaxComplete(replaceContent);
                DeWeb.AjaxForms.OnAjaxFailure(replaceContent);
            }
        });

        DeWeb.Ui.BlockElement(replaceContent);
    });
};


DeWeb.Utilities.getIdsAndRedirect = function ($this) {
    var redirHref = $this.data('redirect-to');
    var query = $this.data('query-param');

    //If HREF AND POPUPTYPE
    var pType = $this.data('popup-type');

    $this.on('click', function () {

        var $collect = $('.id-collection');
        var ids = [];
        if ($collect.length) {
            $collect.each(function () {
                var $that = $(this);
                var id = $that.data('for-id');
                //Only for packages .... 
                if ($this.data("is-auth")) {
                    id = $that.data("for-auth");
                }
                if (id) {
                    if ($that.is(':checkbox')) {
                        if ($that.prop('checked')) {
                            ids.push(id);
                        }
                    } else if ($that.data('selected')) {
                        ids.push(id);
                    }

                }
            });
           
            if (ids.length && pType && redirHref) {
                var preloadHref = redirHref + "?" + query + "=" + ids.join();
                $.get(preloadHref, function (data) {
                    DeWeb.Ui.ShowPopup(data, pType);
                });
            }
            else if (ids.length && !pType) {
                var preloadHref = redirHref + "?" + query + "=" + ids.join() + "&cmd=preload";
                $.get(preloadHref, function (data) {
                    if (data) {
                        window.location = redirHref + "?" + "workitemid" + "=" + data;
                    }
                });
            }
        }
    });
}
DeWeb.Utilities.showBenefDetails = function ($this) {
   $this.click(function () {
       $(this).find("div.hiddenBenef").toggleClass("hiddenBenefB");
   });
 
}

DeWeb.Utilities.swipeTransfers = function ($this) {
    $this.click(function () {
        var dir = $this.data("direction");
        var ids = $("#transferident").data("transferlist");
        var current = $this.parent().data("current");
        currentId = ids.indexOf(current.toString());
        if (currentId + parseInt(dir) > ids.length || currentId + parseInt(dir) < 0) {
            return;
        }
        next = ids[currentId + parseInt(dir)];
        $("#" + next).trigger("click");

    });

};


DeWeb.Utilities.trackCurrencyField = function ($this) {
    creditorSlider = $("#CommisionAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
    //Filter Slides according to debtor account currency
    var filterSlides = function (currencies, indic) {
        var $mainSlider = $("#CommisionAccount_ID_slider");
        var currentSlides = [];
        var mockFirst = 0;
        var accid = $("#DebtorAccount_ID").val();
        $mainSlider.find(".slide").each(function () {
            $mainSlider.slick('slickRemove', mockFirst);
        });
        /*** Previous credited account (perhaps from step 2). ***/
        var prevCreditedAccount = null;
        var previousSelectedCommisionAccount = null;
        initialize.each(function () {
            if (currencies.indexOf($(this).data("currency")) > -1) {
                /*** Need to ex-filter credited accounts that are equal to debited ***/
                if (true) {
                    $mainSlider.slick('slickAdd', $(this));
                    /*** Get jQuery instance in a variable so that we can later find it in the currentSlides array. ***/
                    var reference = $(this);
                    currentSlides.push(reference);
                    try {
                        if ($(this).data("accountnumber") === $("#DebtorAccount_ID").val() && ($(this).attr('id') == undefined || $(this).attr('id').indexOf('cloned') == -1)) {
                            prevCreditedAccount = reference;
                        }

                        if ($("#CommisionAccount_ID") != undefined) {
                            if ($(this).data("accountnumber") === $("#CommisionAccount_ID").val() && ($(this).attr('id') == undefined || $(this).attr('id').indexOf('cloned') == -1)) {
                                previousSelectedCommisionAccount = reference;
                            }
                        }
                    } catch (e) {
                        console.log(e);
                    }
                }
            }
        });
        // add mockslides 
        if (currentSlides.length === 1 || currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }
        }
        var currencyText = $('div.slick-center').find('.ui-selectmenu-text').text();
        currencyText.substring(0, 3);
        $('input#InstructedAmount_Code_ID').val(currencyText);
        $mainSlider.slick('unslick');
        /*** By ex-filtering we can have 0 credited accounts. ***/
        if (currentSlides.length === 0) {
            $("#CommisionAccount_ID").val('');
            $('.slider-button-prev.slider-button-prev-CommisionAccount_ID').attr('style', 'display: none;');
            $('.slider-button-next.slider-button-next-CommisionAccount_ID').attr('style', 'display: none;');
        } else {
            $('.slider-button-prev.slider-button-prev-CommisionAccount_ID').attr('style', '');
            $('.slider-button-next.slider-button-next-CommisionAccount_ID').attr('style', '');
            var focus = 1;
            if (currentSlides.length == 1 || currentSlides.length == 2) {
                focus = 0;
            }
            /*** Set previous credited account. ***/
            if (prevCreditedAccount) {
                focus = currentSlides.indexOf(prevCreditedAccount);
            }
            if (previousSelectedCommisionAccount) {
                focus = currentSlides.indexOf(previousSelectedCommisionAccount);
            }

            var selectedAccount = $(currentSlides[focus]).data("accountnumber");

            $mainSlider.slick(getSlickSettings(focus));
            DeWeb.LoadUtilities($mainSlider.parent());
            /*** If no previous valid credited account, set new value ***/
            if (!prevCreditedAccount)
                $("#CommisionAccount_ID").val(selectedAccount);

            $("#DebtorAccount_ID_slider").on("afterChange", function () {
                var prevCreditedAccountIndex = $('#CommisionAccount_ID_slider') != undefined && $('#CommisionAccount_ID_slider').find("div[data-accountnumber='" + $("#DebtorAccount_ID").val() + "']") != undefined ? $('#CommisionAccount_ID_slider').find("[data-accountnumber='" + $("#DebtorAccount_ID").val() + "']").data('slick-index') : 0;
                $mainSlider.slick('slickGoTo', prevCreditedAccountIndex + '')
            });
        }
    };
    //Filter Currencies
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;
        if (currencies == null) {
            var accid = $("#DebtorAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        currencies = currencies.filter(Boolean);
        $this.val(currencies[0]);
        if (currencies.length !== 0 && initialize) {
            filterSlides(currencies, true);
        }
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
    {
        Id: "CurrencyId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    break;
                case 'CurrencyChanged':
                    if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                        filterCurrencies(args.Currency, $this.attr("id"));

                    }
                    break;
            }


        }
    }


    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"));
        ebs.AddListener(currency);

    });
};
DeWeb.Events.SwiftCodeAutocompleteRender = function (ul, item) {
    var address = item.BankAddress != null ? item.BankAddress + ", " + item.BankCity : item.BankCity;
    return $("<li>")
        .append("<span>" + item.BankName + "  |  <span>" + item.SwiftCode + "</span> </br> <span>" + address + "</span>")
        .appendTo(ul);

}

DeWeb.Events.SwiftCodeAutocompleteSelected = function (item) {
    var address = item.BankAddress != null ? item.BankAddress + ", " + item.BankCity : item.BankCity;
    $('#CreditorBankSwiftCode_ID').val(item.SwiftCode);
    $('#CreditorBank_ID').val(item.BankName);
    $("#CreditorBank_hidden_ID").val(item.BankName);
    $('#CreditorBankAddress_AddressLine_ID').val(address);
    $("#CreditorBankAddress_AddressLine_hidden_ID").val(address);
    $("#CreditorBank_AdressCountry_hidden").val(item.Country);
}


DeWeb.Events.CreditorNameAutocompleteRender = function (ul, item) {

    return $("<li>")
        .append("<span>" + item.Instruction.CreditorName + "<span>" + "</span> </br> <span>" + item.Instruction.CreditorAccount + "</span>")
        .appendTo(ul);

}

DeWeb.Events.CreditorNameAutocompleteSelected = function (item) {
    $('#CreditorName_ID').val(item.Instruction.CreditorName);
    $('#CreditorAccount_ID').val(item.Instruction.CreditorAccount);
    if (item.Instruction.DebtorAccount != null) {
        $('#DebtorAccount_ID').val(item.Instruction.DebtorAccount);
    }
    if (item.Instruction.CreditorAccount != "") {

        if ($('#CreditorAccount_ID').attr('disabled')) {
            $('#CreditorAccount_ID').removeAttr('disabled');
        }
    }
    if (item.Instruction.CreditorAddress != null) {
        $("#Input_CreditorAddress_Country_ID").val(item.Instruction.CreditorAddress.Country);
        $("#CreditorAddress_Locality_ID").val(item.Instruction.CreditorAddress.Locality);
        $("#CreditorAddress_AddressLine_ID").val(item.Instruction.CreditorAddress.AddressLine);
    }


    setTimeout(function () {
        $('#CreditorAccount_ID').blur();

    }, 700);

}

DeWeb.Events.CreditorAccountAutocompleteRender = function (ul, item) {
    return $("<li>")
        .append("<span>" + item.Instruction.CreditorAccount + "<span>" + "</span> </br> <span>" + item.Instruction.CreditorName + "</span>")
        .appendTo(ul);

}

DeWeb.Events.CreditorAccountAutocompleteSelected = function (item) {
    $('#CreditorName_ID').val(item.Instruction.CreditorName);
    $('#CreditorAccount_ID').val(item.Instruction.CreditorAccount);
}

DeWeb.Events.FileUploadedEvent = function (item) {
    $('#document_' + item.DocumentId).remove();
    $('#' + item.FormId).append('<div class="doc-wrapper" id="document_' + item.DocumentId + '"><p class="doc">' + item.DocumentName + '</p><a href="#" class="delete" onClick="$(\'#document_' + item.DocumentId + '\').remove();">&nbsp;</a></div>');
};

DeWeb.Events.CheckForSepa = function (item) {
    var sepaVisible = $("#SepaGroup").css('display') == "block";

    var currency = $(item).val();
    if (!sepaVisible) {
        return;
    }
    if (currency != "EUR") {
        //hide sepa
        $(".plus").toggleClass('active');
        $("#SepaGroup").slideToggle(300);
    }
};

DeWeb.Utilities.resetPackageFilter = function ($this) {
    $this.on('click', function () {
        var localizedAll = $this.data("culture");
        $("label.dd-option-text:contains(" + localizedAll + ")").click();
    });
};

// Set Geolocation
DeWeb.Functionalities.setGeolocationMap = new function () {

    // Map properties
    var selfLocationImg = {};
    var newLocationImg = {};
    var MAPTYPE = "";
    var markers = [];
    var map = {};
    var latid = "";
    var addid = "";
    var mainInfobox = {};
    var initialLocationImg = {};
    var addMarker = function (addtoMap, icon, infoboxContent, position, markerDescription) {
        var markerObj = {
            type: markerDescription.type,
            address: markerDescription.address,
            name: markerDescription.name,
            marker: new google.maps.Marker({
                position: position,
                map: addtoMap,
                icon: icon
            })
        };

        google.maps.event.addListener(markerObj.marker, 'click', function () {
            mainInfobox.close();
            mainInfobox.setContent(infoboxContent);
            mainInfobox.open(addtoMap, this);
        });


        markers.push(markerObj);
        map.setCenter(markerObj.marker.getPosition());
    };
    var preinit = function (bpath) {
        var baseContentPath = bpath;

        mainInfobox = new InfoBox({
            content: '',
            disableAutoPan: false,
            maxWidth: 200,
            pixelOffset: new google.maps.Size(20, -100),
            zIndex: null,
            boxStyle: {
                background: "",
                opacity: 1
            },
            closeBoxMargin: "10px 10px 0 0",
            closeBoxURL: baseContentPath + "img/icons/close.png",
            infoBoxClearance: new google.maps.Size(1, 1)
        });
        // Location pins
        selfLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-4.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );

        newLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-3.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        initialLocationImg = new google.maps.MarkerImage(
            baseContentPath + 'img/icons/pin-1.png',
            null,
            null,
            new google.maps.Point(16, 42),
            new google.maps.Size(32, 42)
        );
        var addMarker = function (addtoMap, icon, infoboxContent, position, markerDescription) {
            var markerObj = {
                type: markerDescription.type,
                address: markerDescription.address,
                name: markerDescription.name,
                marker: new google.maps.Marker({
                    position: position,
                    map: addtoMap,
                    icon: icon
                })
            };

            google.maps.event.addListener(markerObj.marker, 'click', function () {
                mainInfobox.close();
                mainInfobox.setContent(infoboxContent);
                mainInfobox.open(addtoMap, this);
            });
            markers.push(markerObj);
            map.setCenter(markerObj.marker.getPosition());
        };
    }
    var init = function (latId, lngId, addId, bpath) {
        latid = latId; lngid = lngId; addid = addId;
        var position = new google.maps.LatLng(parseFloat($("#" + latid).val().replace(',', '.')), parseFloat($("#" + lngid).val().replace(',', '.')));
        var geocoder = new google.maps.Geocoder;

        // Map options and styles
        var map_canvas = document.getElementById('geolocation-map');
        var styles = [
            { "featureType": "water", "elementType": "geometry.fill", "stylers": [{ "color": "#d3d3d3" }] }, { "featureType": "transit", "stylers": [{ "color": "#808080" }, { "visibility": "off" }] }, { "featureType": "road.highway", "elementType": "geometry.stroke", "stylers": [{ "visibility": "on" }, { "color": "#b3b3b3" }] }, { "featureType": "road.highway", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "road.local", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#ffffff" }, { "weight": 1.8 }] }, { "featureType": "road.local", "elementType": "geometry.stroke", "stylers": [{ "color": "#d7d7d7" }] }, { "featureType": "poi", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#ebebeb" }] }, { "featureType": "administrative", "elementType": "geometry", "stylers": [{ "color": "#a7a7a7" }] }, { "featureType": "road.arterial", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "road.arterial", "elementType": "geometry.fill", "stylers": [{ "color": "#ffffff" }] }, { "featureType": "landscape", "elementType": "geometry.fill", "stylers": [{ "visibility": "on" }, { "color": "#efefef" }] }, { "featureType": "road", "elementType": "labels.text.fill", "stylers": [{ "color": "#696969" }] }, { "featureType": "administrative", "elementType": "labels.text.fill", "stylers": [{ "visibility": "on" }, { "color": "#737373" }] }, { "featureType": "poi", "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] }, { "featureType": "poi", "elementType": "labels", "stylers": [{ "visibility": "off" }] }, { "featureType": "road.arterial", "elementType": "geometry.stroke", "stylers": [{ "color": "#d6d6d6" }] }, { "featureType": "road", "elementType": "labels.icon", "stylers": [{ "visibility": "off" }] }, {}, { "featureType": "poi", "elementType": "geometry.fill", "stylers": [{ "color": "#dadada" }] }
        ];

        var map_options = {
            center: new google.maps.LatLng(44.4325, 26.103889),
            zoom: 12,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            scrollwheel: false,
            draggable: !("ontouchend" in document),
            styles: styles,
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_BOTTOM
            },
            mapTypeControlOptions: {
                position: google.maps.ControlPosition.BOTTOM_LEFT
            }
        }
        map = new google.maps.Map(map_canvas, map_options);

        // Marker placements
        var addMyMarker = function (results, selfLocationImg, position) {

            var result = '';
            if (results[0] != null) {
                result = results[0];
            }
            var infoboxTemplate = $('#infobox-template').html();
            var content = infoboxTemplate.replace("{infobox-id}", "self")
                .replace("{location-title}", "Your location.")
                .replace("{location-info}", result.formatted_address);

            addMarker(map, selfLocationImg, content, position, { type: 'self' });
        };

        //Add current geolocation if exists

        if (!isNaN(position.lat()) && !isNaN(position.lng())) {

            placeMarker(position, initialLocationImg);
        }




        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var pos = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                //todo insert icon self
                map.setCenter(pos);
                reverseGeocoding(geocoder, map, pos, function (results) {
                    addMyMarker(results, selfLocationImg, pos);
                });
            }, function () {
                //handleLocationError(true, infoWindow, map.getCenter());
            });
        }



        //Click on map - place pin and remember location as potential transfer geolocation
        google.maps.event.addListener(map, "click", function (e) {

            var latLng = e.latLng;
            var lat = latLng.lat();
            var lng = latLng.lng();
            var address = "";
            reverseGeocoding(geocoder, map, latLng, function (results) {
                address = results[0].formatted_address;
                placeData(lat, lng, address);
                placeMarker(e.latLng, newLocationImg);
            });

        });

        $("#noresults").click(function () {
            $("#noresults").slideUp(300);
            $("#noresults").css("display", "none");
        })
    }

    //Geocoding and reverse geocoding
    var reverseGeocoding = function (geocoder, map, latlng, callback) {
        geocoder.geocode({ 'location': latlng }, function (results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
                if (results[0]) {
                    callback(results);
                } else {

                    //$("#noresults").slideDown(300);
                    console.log('No results found');
                }
            } else {
                //$("#noresults").slideDown(300);
                console.log('Geocoder failed due to: ' + status);
            }
        });
    };
    var placesSvc = new google.maps.places.AutocompleteService();
    var geocoding = function (geocoder, map, address, callback) {
        var geoOpt = {
            input: address + ' ',
            //location: new google.maps.LatLng(44.4325, 26.103889)
        };
        placesSvc.getQueryPredictions(geoOpt, function (results, status) {
            if (status === google.maps.places.PlacesServiceStatus.OK) {
                if (results[0]) {
                    geocoder.geocode({ 'address': results[0].description }, function (results2, status) {
                        if (status === google.maps.GeocoderStatus.OK) {
                            if (results2[0]) {
                                callback(results2);
                            } else {
                                //$("#noresults").slideDown(300);
                                console.log('No results found');
                                callback([]);
                            }
                        } else {
                            //$("#noresults").slideDown(300);
                            console.log('Geocoder failed due to: ' + status);
                            callback([]);
                        }
                    });
                } else {
                    //$("#noresults").slideDown(300);
                    console.log('No results found');
                    callback([]);
                }
            } else {
                //$("#noresults").slideDown(300);
                console.log('Place service failed due to: ' + status);
                callback([]);
            }
        });
    };

    //Helpers
    var removeTemporaryMarkers = function () {

        for (var i = 0; i < markers.length; i++) {
            if (markers[i].type == 'temporary-location') {
                markerObj = markers[i];
                markerObj.marker.setVisible(false);
                markers.slice(i, 1);
            }
        }
    };
    var placeData = function (lat, lng, address) {
        $("#" + latid).val(lat);
        $("#" + lngid).val(lng);
        $("#" + addid).val(address);
    }
    var placeMarker = function (location, icon) {

        removeTemporaryMarkers();
        var type = 'temporary-location';
        var name = '';
        if (icon == initialLocationImg) {
            type = 'current-location';
            name = 'Current transfer geolocation';
        }
        var infoboxTemplate = $('#infobox-template').html();
        var content = infoboxTemplate.replace("{infobox-id}", "geolocation")
            .replace("{location-title}", name)
            .replace("{location-info}", $("#" + addid).val());
        mainInfobox.close();
        addMarker(map, icon, content, location, { type: type });


    }


    //Calls
    var geocodeData = function (textSearch, callback) {

        var geocoder = new google.maps.Geocoder;
        geocoding(geocoder, map, textSearch, function (results) {
            var latlng = results[0].geometry.location;
            reverseGeocoding(geocoder, map, latlng, function (addressResults) {
                callback(addressResults);
                return;
            });

        })


    }
    var reverseGeocodeData = function (LATLNG) {
        var geocoder = new google.maps.Geocoder;
        var array = LATLNG.split(',');
        var lat = parseFloat(array[0]);
        var lng = parseFloat(array[1]);
        var pos = {
            lat: lat,
            lng: lng
        };
        var latlng = new google.maps.LatLng(lat, lng);
        var address = "";
        reverseGeocoding(geocoder, map, pos, function (results) {
            address = results[0].formatted_address;
            placeData(lat, lng, address);
            placeMarker(latlng, newLocationImg);
        });

    }
    return {
        PreInit: preinit,
        Init: init,
        GeocodeData: geocodeData,
        ReverseGeocodeData: reverseGeocodeData
    };

}





DeWeb.Utilities.SetGeo = function ($this) {

    DeWeb.Functionalities.setGeolocationMap.PreInit($this.data("base-path"));
    DeWeb.Functionalities.setGeolocationMap.Init($this.data("lat-id"), $this.data("lng-id"), $this.data("address-id"), $this.data("base-path"));

}

function GeocodeData(textSearch, done) {
    DeWeb.Functionalities.setGeolocationMap.GeocodeData(textSearch,
        function (result) {
            var restoreturn = [];
            for (index in result) {

                if (result[index]["geometry"] != undefined) {
                    var newreturntores = { label: result[index]["geometry"]["location"], value: result[index]["formatted_address"] };
                    restoreturn.push(newreturntores);
                }


            }
            done(restoreturn);
        });

}

function ReverseGeocodeData(geoloc) {
    geoloc = geoloc.substring(1, geoloc.length - 1);
    DeWeb.Functionalities.setGeolocationMap.ReverseGeocodeData(geoloc);

}










// Show Geolocation - transfers get
DeWeb.Utilities.showLocation = function ($this) {
    var source = $this.data('source');
    var bPath = $this.data('content-path');
    displayOn = "widget";
    realfacilities = $this.data("facilities-json");
    DeWeb.Functionalities.AtmBranchMap.Init(source, bPath, displayOn, realfacilities);
};
DeWeb.Utilities.openDetails = function ($this) {
    $("#Remove_account").parent().remove();
    $(".group").removeClass("uk-width-1-4");
    $(".group").addClass("uk-width-1-2");
    $("#NewAccountDetailsGroupId_right").children().after($("#Add_account_info").parent());
    $this.parent().siblings(".group").css("display", "none");
    console.log($this.siblings(".plain-list"));
    $this.parent().parent().parent().parent().find(".plain-list").parent().css("display", "block");
    $this.click(function () {

        if ($this.parent().siblings(".group").is(":visible")) {
            $this.parent().siblings(".group").slideUp(500);
            $this.parent().parent().parent().parent().find(".plain-list").parent().css("display", "block");

        }
        else {
            $this.parent().siblings(".group").slideDown(500);

        }
    });

};

DeWeb.Utilities.trackPrimaryField = function ($this) {
    var tracker =
    {
        Id: "TrackerId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    $this.val(args.Account);
                    break;

            }


        }
    };
    ebs.AddListener(tracker);

};

DeWeb.Utilities.switchCurrencies = function ($this) {
    creditorSlider = $("#CreditorAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
    //Filter Slides according to debtor account currency
    var filterSlides = function (currencies, indic) {
        var $mainSlider = $("#CreditorAccount_ID_slider");
        var currentSlides = [];
        var mockFirst = 0;
        var accid = $("#DebtorAccount_ID").val();
        $mainSlider.find(".slide").each(function () {
            $mainSlider.slick('slickRemove', mockFirst);
        });
        /*** Previous credited account (perhaps from step 2). ***/
        var prevCreditedAccount = null;
        initialize.each(function () {
            if (currencies.indexOf($(this).data("currency")) > -1) {
                /*** Need to ex-filter credited accounts that are equal to debited ***/
                if ($(this).data("accountnumber") !== accid) {
                    $mainSlider.slick('slickAdd', $(this));
                    /*** Get jQuery instance in a variable so that we can later find it in the currentSlides array. ***/
                    var reference = $(this);
                    currentSlides.push(reference);
                    if ($(this).attr('id') == undefined && $(this).data("accountnumber") === $("#CreditorAccount_ID").val()) {
                        prevCreditedAccount = reference;
                    }
                    if ($(this).data("accountnumber") === $("#CreditorAccount_ID").val() && ($(this).attr('id') != undefined && $(this).attr('id').indexOf('cloned') == -1)) {
                        prevCreditedAccount = reference;
                    }
                }
            }
        });
        // add mockslides 
        if (currentSlides.length === 1 || currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }
        }
        $mainSlider.slick('unslick');
        /*** By ex-filtering we can have 0 credited accounts. ***/
        if (currentSlides.length === 0) {
            $("#CreditorAccount_ID").val('');
            $('.slider-button-prev.slider-button-prev-CreditorAccount_ID').attr('style', 'display: none;');
            $('.slider-button-next.slider-button-next-CreditorAccount_ID').attr('style', 'display: none;');
        } else {
            $('.slider-button-prev.slider-button-prev-CreditorAccount_ID').attr('style', '');
            $('.slider-button-next.slider-button-next-CreditorAccount_ID').attr('style', '');
            var focus = 1;
            if (currentSlides.length == 1 || currentSlides.length == 2) {
                focus = 0;
            }
            /*** Set previous credited account. ***/
            if (prevCreditedAccount)
                focus = currentSlides.indexOf(prevCreditedAccount);
            var selectedAccount = $(currentSlides[focus]).data("accountnumber");
            $mainSlider.slick(getSlickSettings(focus));
            DeWeb.LoadUtilities($mainSlider.parent());
            /*** If no previous valid credited account, set new value ***/
            if (!prevCreditedAccount)
                $("#CreditorAccount_ID").val(selectedAccount);
        }
    };
    //Filter Currencies
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;
        if (currencies == null) {
            var accid = $("#DebtorAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        currencies = currencies.filter(Boolean);
        $this.attr('value', currencies[0]);

        $('input#InstructedAmount_Code_ID').val(currencies[0]).trigger("blur");

        if (currencies.length !== 0 && initialize) {
            filterSlides(currencies, true);
        }
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
    {
        Id: "CurrencyId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    break;
                case 'CurrencyChanged':
                    if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                        filterCurrencies(args.Currency, $this.attr("id"));
                    }
                    break;
            }


        }
    }


    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"));
        ebs.AddListener(currency);

    });
};

DeWeb.Utilities.includeInBody = function ($this) {
    var currentText = $("#BodyId_ID").val();
    var newText = $("[data-info=" + $this.data('for') + "]").text();

    $this.click(function () {
        if ($this.children().hasClass("checked")) {

            if (currentText.indexOf(newText) == -1) {
                var freshText = currentText + newText;
                $("#BodyId_ID").val(freshText);
            }
        }
        else {
            if (currentText.indexOf(newText) > -1) {
                var ntext = currentText.replace(newText, "");
                $("#BodyId_ID").val(ntext);
            }
        }

    });
};

DeWeb.Utilities.rememberChecks = function ($this) {
    var chcSelector = $this.data('checkbox-selector');

    var $checkboxes = $this.find(chcSelector);
    if (window.checkedBoxes && window.checkedBoxes.length && $checkboxes.length) {
        $.each($checkboxes, function () {
            var $that = $(this);
            for (var i = 0; i < window.checkedBoxes.length; i++) {
                var checked = window.checkedBoxes[i];
                var forId = $that.data('for-id');
                if (checked === forId) {
                    $that.attr('checked', true);
                    $that.addClass('checked');
                }
            }
        });
    }


    $this.on('change', chcSelector, function () {
        var forId = $(this).data('for-id');
        if (this.checked) {
            if (!window.checkedBoxes) {
                window.checkedBoxes = [];
            }
            window.checkedBoxes.push(forId);
        } else {
            if (!window.checkedBoxes) {
                window.checkedBoxes = [];
            }

            var index = window.checkedBoxes.indexOf(forId);
            if (index > -1) {
                window.checkedBoxes.splice(index, 1);
            }
        }
    });
};
DeWeb.Utilities.selectBeneficiary = function ($this) {
    $this.on('click', function () {
        var benId = $this.data('ben-id');
        var actionid = $this.data('action-id');
        var formId = $this.data('form-id');
        if (!formId) {
            var $parentForm = $this.parents('form');
            if ($parentForm.length) {
                formId = $parentForm.first().attr('id');
            }
        }

        $('#Beneficiary_ID').val(benId);
        DeWeb.Forms.setAction(formId, actionid);
    });
};


DeWeb.Utilities.mapToChoice = function ($this) {
    $this.on("click", function () {
        $("#DraftsId_ID").trigger("change", [$this.data("draft-id")]);

    });
};


DeWeb.Utilities.switchContent = function ($this) {
    var url = $this.data('switch-to-url');
    var replaceContent = $this.data('replace-content');
    var $replace = null;
    if (replaceContent) {
        $replace = $('#' + replaceContent);
    }
    $this.on('click', function () {
        DeWeb.AjaxForms.OnAjaxBegin(replaceContent);
        $.get(url).done(function (data) {
            if (data) {
                $replace.html(data);
                DeWeb.AjaxForms.OnAjaxComplete(replaceContent);
            } else {
                DeWeb.AjaxForms.OnAjaxComplete(replaceContent);
                DeWeb.AjaxForms.OnAjaxFailure(replaceContent);
            }
        });

        DeWeb.Ui.BlockElement(replaceContent);
    });
};


DeWeb.Utilities.getIdsAndRedirect = function ($this) {
    var redirHref = $this.data('redirect-to');
    var query = $this.data('query-param');

    //If HREF AND POPUPTYPE
    var pType = $this.data('popup-type');

    $this.on('click', function () {

        var $collect = $('input.id-collection');
        var ids = [];
        if ($collect.length) {
            $collect.each(function () {
                var $that = $(this);
                var id = $that.data('for-id');

                if (id) {
                    if ($that.is(':checkbox')) {
                        if ($that.prop('checked')) {
                            ids.push(id);
                        }
                    } else if ($that.data('selected')) {
                        ids.push(id);
                    }

                }
            });
            if (ids.length && pType && redirHref) {
                var preloadHref = redirHref + "?" + query + "=" + ids.join();

                if (pType == "inline") {
                    window.location = preloadHref;
                }
                else {
                    $.get(preloadHref, function (data) {
                        DeWeb.Ui.ShowPopup(data, pType);
                    });
                }

            }
            else if (ids.length && !pType) {
                var preloadHref = redirHref + "?" + query + "=" + ids.join() + "&cmd=preload";
                $.get(preloadHref, function (data) {
                    if (data) {
                        window.location = redirHref + "?" + "workitemid" + "=" + data;
                    }
                });
            }
        }
    });
}


DeWeb.Utilities.synchroniseWithPickerCB = function ($this) {
    var fieldSynchronizationC =
    {
        Id: "FieldSynchronization",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {

                case 'AccountChanged':
                    if (args.Account) {
                        $("#CommissionAccount_ID").val(args.Account);
                    }

                    break;
            }
        }
    };

    $(document).ready(function () {
        ebs.AddListener(fieldSynchronizationC);
    });
};
DeWeb.Utilities.synchroniseWithPicker = function ($this) {
    var fieldSynchronization =
    {
        Id: "FieldSynchronization",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {

                case 'AccountChanged':
                    if (args.Account) {
                        $this.val(args.Account);
                    }

                    break;
            }
        }
    };
    $(document).ready(function () {
        ebs.AddListener(fieldSynchronization);
        $("[name=CommissionAcc_ID]").val($("#DebtorAccount_ID").val());
        $("[name=SettlementAccount_ID]").val($("#DebtorAccount_ID").val());

    });
};
DeWeb.Utilities.untilCancelation = function ($this) {
    var evhnd = function () {
        $("[name=EndDate_ID]").prop("disabled", $this.parent().hasClass("checked"));
        var visible = "block";
        if ($this.parent().hasClass("checked")) {
            visible = "none";
        }
        $("[name=EndDate_ID]").parent().parent().css("display", visible);
    };
    $this.parent().click(evhnd);
    $(document).ready(evhnd);
};
DeWeb.Utilities.trustedBeneficiary = function ($this) {
    var evhnd = function () {
        $("[name=Maximum_Amount_ID]").prop("enabled", $this.parent().hasClass("checked"));
        $("[name=Currency_ID_maximum]").prop("enabled", $this.parent().hasClass("checked"));
        var visible = "none";
        if ($this.parent().hasClass("checked")) {
            visible = "block";
        }
        if (visible == "none") {
            $("[name=Maximum_Amount_ID]")[0].value = null;
        }
        $("[name=Maximum_Amount_ID]").closest('.group.uk-width-8-10').css("display", visible);
        $("[name=Currency_ID_maximum]").parents('.group.uk-width-2-10').css("display", visible);
    };
    $this.parent().click(evhnd);
    $(document).ready(evhnd);
};
DeWeb.Utilities.expandSepa = function ($this) {

    var evh = function () {

        var isSepaVisible = $('#SepaGroup_right').css('display') == 'block';
        var isUrgentChecked = $('[name=Urgency_ID]').parent().hasClass('checked');
        var isAmountOverLimit = parseFloat(parseFloat($('#InstructedAmount_Amount_ID').autoNumeric('get')).toFixed(2)) > 50000;

        if (isUrgentChecked || isAmountOverLimit) {
            if (isSepaVisible) {
                $('.plus').removeClass('active');
                $('#SepaGroup').closest('.widget-slat').slideToggle(300);
                $('#SepaGroup_right').css('display', 'none');
            }
        }
        else {
            if (!isSepaVisible) {
                $('.plus').addClass('active');
                $('#SepaGroup').closest('.widget-slat').slideToggle(300);
                $('#SepaGroup_right').css('display', 'block');
            }
        }
    }

    console.log($this.attr('id'));

    switch ($this.attr('id')) {

        case 'InstructedAmount_Amount_ID':
           //$this.blur(evh);
           $this.on("change keyup blur", evh);
            break;
        case 'Urgency_ID':
            $this.parent().click(evh);
            break;

    }


    $(document).ready(evh);

};

DeWeb.Utilities.showViewDrafts = function ($this) {

    $this.click(function () {
        formId = $this.parent().parent().data('form-id');
        data = $this.data("view-type");
        $("#ViewType_ID").val(data);
        $("#form_" + formId).submit();
    });
};

/*** Added this utility ***/
DeWeb.Utilities.trackCurrencyField = function ($this) {
    creditorSlider = $("#CommisionAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
    //Filter Slides according to debtor account currency
    var filterSlides = function (currencies, indic) {
        var $mainSlider = $("#CommisionAccount_ID_slider");
        var currentSlides = [];
        var mockFirst = 0;
        var accid = $("#DebtorAccount_ID").val();
        $mainSlider.find(".slide").each(function () {
            $mainSlider.slick('slickRemove', mockFirst);
        });
        /*** Previous credited account (perhaps from step 2). ***/
        var prevCreditedAccount = null;
        initialize.each(function () {
            if (currencies.indexOf($(this).data("currency")) > -1) {
                /*** Need to ex-filter credited accounts that are equal to debited ***/
                if (true) {
                    $mainSlider.slick('slickAdd', $(this));
                    /*** Get jQuery instance in a variable so that we can later find it in the currentSlides array. ***/
                    var reference = $(this);
                    currentSlides.push(reference);
                    try {
                        if ($(this).data("accountnumber") === $("#DebtorAccount_ID").val() && ($(this).attr('id') == undefined || $(this).attr('id').indexOf('cloned') == -1)) {
                            prevCreditedAccount = reference;
                        }
                    } catch (e) {
                        console.log(e);
                    }
                }
            }
        });
        // add mockslides 
        if (currentSlides.length === 1 || currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }
        }
        var currencyText = $('div.slick-center').find('.ui-selectmenu-text').text();
        currencyText.substring(0, 3);
        $('input#InstructedAmount_Code_ID').val(currencyText);
        $mainSlider.slick('unslick');
        /*** By ex-filtering we can have 0 credited accounts. ***/
        if (currentSlides.length === 0) {
            $("#CommisionAccount_ID").val('');
            $('.slider-button-prev.slider-button-prev-CommisionAccount_ID').attr('style', 'display: none;');
            $('.slider-button-next.slider-button-next-CommisionAccount_ID').attr('style', 'display: none;');
        } else {
            $('.slider-button-prev.slider-button-prev-CommisionAccount_ID').attr('style', '');
            $('.slider-button-next.slider-button-next-CommisionAccount_ID').attr('style', '');
            var focus = 1;
            if (currentSlides.length == 1 || currentSlides.length == 2) {
                focus = 0;
            }
            /*** Set previous credited account. ***/
            if (prevCreditedAccount)
                focus = currentSlides.indexOf(prevCreditedAccount);
            var selectedAccount = $(currentSlides[focus]).data("accountnumber");
            $mainSlider.slick(getSlickSettings(focus));
            DeWeb.LoadUtilities($mainSlider.parent());
            /*** If no previous valid credited account, set new value ***/
            if (!prevCreditedAccount)
                $("#CommisionAccount_ID").val(selectedAccount);
        }
    };
    //Filter Currencies
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;
        if (currencies == null) {
            var accid = $("#DebtorAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        currencies = currencies.filter(Boolean);
        $this.attr('value', currencies[0]);
        if (currencies.length !== 0 && initialize) {
            filterSlides(currencies, true);
        }
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
    {
        Id: "CurrencyId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    break;
                case 'CurrencyChanged':
                    if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                        filterCurrencies(args.Currency, $this.attr("id"));

                    }
                    break;
            }


        }
    }


    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"));
        ebs.AddListener(currency);

    });
};


DeWeb.Utilities.synchroniseWithPickerCT = function ($this) {
    var fieldSynchronizationCt =
    {
        Id: "FieldSynchronization",
        AcceptEvent: function (sender, args) {

            switch (args.CommandName) {

                case 'AccountChanged':
                    if (args.Account) {
                        var identificator = $this.attr('id').replace('_slider', '');
                        $commisionAccount_ID = $("#" + identificator);
                        $commisionAccount_ID.val($("#DebtorAccount_ID").val());
                        $("[name=Commission_Account_ID]").val(args.Account);
                        $("[name=SettlementAccount_ID]").val(args.Account);
                        $("#" + identificator).children().find(".dd-option-value").each(function () {
                            $(this).parent().css('display', 'block');
                            $(this).parent().removeClass("dd-option-selected");
                            if ($(this).val() == $("#DebtorAccount_ID").val()) {
                                $("#" + identificator).children().find(".dd-selected-text").text($(this).val());
                                $(this).parent().addClass("dd-option-selected");
                                $("input[type=hidden][name=" + identificator + "]").val($(this).val());
                            }
                        });
                    }

                    break;
            }
        }
    };
    $(document).ready(function () {
        ebs.AddListener(fieldSynchronizationCt);
        var identificator = $this.attr('id').replace('_slider', '');
        $commisionAccount_ID = $("#" + identificator);
        $commisionAccount_ID.val($("#DebtorAccount_ID").val());
        $("[name=Commission_Account_ID]").val($("#DebtorAccount_ID").val());
        $("[name=SettlementAccount_ID]").val($("#DebtorAccount_ID").val());

    });


};

$(document).ready(function () {
    if ($("#Input_CreditorBankAddress_Country_ID").val() != "") {
        selectedDoAction = "3";
        if (selectedDoAction) {
            var $form = $("body").find("form");
            DeWeb.Forms.setAction($form.attr('id').replace("form_", ""), selectedDoAction);
        }
    }
    if ($('#CreditorAccount_ID').val() != "") {
        $('#CreditorAccount_ID').blur();
    }
});


DeWeb.Utilities.exportTransfers = function ($this) {
    var downloadFile = function (filename, text) {
        var element = document.createElement('a');
        element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
        element.setAttribute('download', filename);
        element.style.display = 'none';
        document.body.appendChild(element);
        element.click();
        document.body.removeChild(element);
    };
    $this.click(function () {
        $forms = $("body").find('form');
        var $form;
        $forms.each(function () {
            if ($(this).attr("id").indexOf('filter') != -1) {
                $form = $(this);
            }

        });
        var _exportUrl = $this.data('href');
        $.ajax({
            url: _exportUrl,
            type: "POST",
            data: $form.serialize(),
            success: function (markup) {
                var fileName = "exportedTransfers." + $this.data('format');
                downloadFile(fileName, markup);
            }
        });
    });


};


DeWeb.Utilities.changeMaximumBeneficaryCode = function ($this) {
    $("#Currency_ID_maximum").val($("#Currency_ID > div > input").val());
    $("#Currency_ID > div > input").on('change', function (e, value) {
        $("#Currency_ID_maximum").val($("#Currency_ID > div > input").val());
    });
};
DeWeb.Utilities.ApplyCompany = function($this) {
    $this.donetyping(function() {
        var searchParam = $this.val().toLowerCase();
        var inputId = $this.attr("id").replace("Input", "values_");
        $("#" + inputId)
            .children()
            .each(function() {
                var param = $(this).text().toLowerCase();
                if (param.indexOf(searchParam) < 0) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
    });
};


DeWeb.Utilities.endStateMap = function ($this) {
    var sourceHref = $this.data('source');
    var ctPath = $this.data('content-path');
    DeWeb.Functionalities.AtmBranchMap.Init(sourceHref, ctPath, "becomeaclientmap");
};


DeWeb.Utilities.selectProduct = function ($this) {
    
    $this.click(function () {
        $("[name=SelectProductFieldId]").val($this.data("product-id"));

        //Svima skini i postavi osnovnu klasu
        $("[data-id=" + $this.parent().parent().data("id") + "]").removeClass();
        $("[data-id=" + $this.parent().parent().data("id") + "]").addClass("product-content");

        //Samo ovom dodaj product selectd
        $this.parent().parent().removeClass();
        $this.parent().parent().addClass("product-selected"); //Za trenutni postavi da je selektovan
        $("[data-utility=" + $this.data('utility') + "]").css("display", "block");
        $this.css('display', 'none');
    });
};
//DeWeb.Utilities.showProductVisualization = function ($this) {

//    //$("#SelectProductFieldId").css("display", "none");


//    //$("#SelectProductFieldId").parent().parent().parent()
//    //    .after('<div class="group uk-width-5-10"><div class="product-box " style="background-image: url(../Themes/Standard/img/bg/product-2.jpg)"><p class="title-1 color-1"><span>current-account-product</span></p><div data-id="product-selection" class="product-selected"><h4  style="color:white">Basic Package</h4><div class="expand"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suo enim quisque studio maxime ducitur. At enim sequor utilitatem. Tu vero, inquam, ducas licet, si sequetur; Experiamur igitur, inquit, etsi habet haec Stoicorum ratio difficilius quiddam et obscurius. Haec quo modo conveniant, non sane intellego. Duo Reges: constructio interrete. Quae quo sunt excelsiores, eo dant clariora indicia naturae. Cave putes quicquam esse verius. Zenonis est, inquam, hoc Stoici. Quae cum dixisset, finem ille. Quae cum dixisset, finem ille. Sed ad bona praeterita redeamus. Quid sequatur, quid repugnet, vident. Tubulum fuisse, qua illum, cuius is condemnatus est rogatione, P. Sed ut iis bonis erigimur, quae expectamus, sic laetamur iis, quae recordamur. Equidem etiam Epicurum, in physicis quidem, Democriteum puto. An quod ita callida est, ut optime possit architectari voluptates? Quis enim redargueret? Quae in controversiam veniunt, de iis, si placet, disseramus. Esse enim quam vellet iniquus iustus poterat inpune. Minime vero, inquit ille, consentit. Et quod est munus, quod opus sapientiae? Sed ad haec, nisi molestum est, habeo quae velim. Aliud igitur esse censet gaudere, aliud non dolere. Sed fac ista esse non inportuna; Quod si ita se habeat, non possit beatam praestare vitam sapientia. Deinde disputat, quod cuiusque generis animantium statui deceat extremum. Honesta oratio, Socratica, Platonis etiam. Nam quibus rebus efficiuntur voluptates, eae non sunt in potestate sapientis. Quo studio Aristophanem putamus aetatem in litteris duxisse? Hoc est non dividere, sed frangere. Quae quo sunt excelsiores, eo dant clariora indicia naturae. Sed vos squalidius, illorum vides quam niteat oratio.</p><a href="javascript:void(0)" class="btn-1 color-1" data-utility="selectProduct"style="display:none" data-product-id="current-account-domestic">Select</a></div></div></div></div>');
//    //$("#SelectProductFieldId").parent().parent().parent()
//    //    .after('<div class="group uk-width-5-10"><div class="product-box" style="background-image: url(../Themes/Standard/img/bg/product-1.jpg)"><p class="title-1 color-1"><span>current-account-product</span></p><div data-id="product-selection" class="product-content"><h4 style="color:white">Enhanced Package</h4><div class="expand"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suo enim quisque studio maxime ducitur. At enim sequor utilitatem. Tu vero, inquam, ducas licet, si sequetur; Experiamur igitur, inquit, etsi habet haec Stoicorum ratio difficilius quiddam et obscurius. Haec quo modo conveniant, non sane intellego. Duo Reges: constructio interrete. Quae quo sunt excelsiores, eo dant clariora indicia naturae. Cave putes quicquam esse verius. Zenonis est, inquam, hoc Stoici. Quae cum dixisset, finem ille. Quae cum dixisset, finem ille. Sed ad bona praeterita redeamus. Quid sequatur, quid repugnet, vident. Tubulum fuisse, qua illum, cuius is condemnatus est rogatione, P. Sed ut iis bonis erigimur, quae expectamus, sic laetamur iis, quae recordamur. Equidem etiam Epicurum, in physicis quidem, Democriteum puto. An quod ita callida est, ut optime possit architectari voluptates? Quis enim redargueret? Quae in controversiam veniunt, de iis, si placet, disseramus. Esse enim quam vellet iniquus iustus poterat inpune. Minime vero, inquit ille, consentit. Et quod est munus, quod opus sapientiae? Sed ad haec, nisi molestum est, habeo quae velim. Aliud igitur esse censet gaudere, aliud non dolere. Sed fac ista esse non inportuna; Quod si ita se habeat, non possit beatam praestare vitam sapientia. Deinde disputat, quod cuiusque generis animantium statui deceat extremum. Honesta oratio, Socratica, Platonis etiam. Nam quibus rebus efficiuntur voluptates, eae non sunt in potestate sapientis. Quo studio Aristophanem putamus aetatem in litteris duxisse? Hoc est non dividere, sed frangere. Quae quo sunt excelsiores, eo dant clariora indicia naturae. Sed vos squalidius, illorum vides quam niteat oratio.</p><a href="javascript:void(0)" class="btn-1 color-1" data-utility="selectProduct"  data-product-id="current-account-foreign">Select</a></div></div></div></div>');

//    //DeWeb.LoadUtilities();
//};

DeWeb.Utilities.switchCurrenciesTermDeposit = function ($this) {
    creditorSlider = $("#CreditorAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
    //Filter Slides according to debtor account currency
    var filterSlides = function (currencies, indic) {
        var $mainSlider = $("#CreditorAccount_ID_slider");
        var currentSlides = [];
        var mockFirst = 0;
        var accid = $("#DebtorAccount_ID").val();
        $mainSlider.find(".slide").each(function () {
            $mainSlider.slick('slickRemove', mockFirst);
        });
        /*** Previous credited account (perhaps from step 2). ***/
        var prevCreditedAccount = null;
        initialize.each(function () {
            if (currencies.indexOf($(this).data("currency")) > -1) {
                $mainSlider.slick('slickAdd', $(this));
                /*** Get jQuery instance in a variable so that we can later find it in the currentSlides array. ***/
                var reference = $(this);
                currentSlides.push(reference);
                try {
                    if ($(this).data("accountnumber") === $("#CreditorAccount_ID").val() && $(this).attr('id').indexOf('cloned') == -1) {
                        prevCreditedAccount = reference;
                    }
                } catch (e) {
                    console.log(e);
                }
            }
        });
        // add mockslides 
        if (currentSlides.length === 1 || currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }
        }
        $mainSlider.slick('unslick');
        /*** By ex-filtering we can have 0 credited accounts. ***/
        if (currentSlides.length === 0) {
            $("#CreditorAccount_ID").val('');
            $('.slider-button-prev.slider-button-prev-CreditorAccount_ID').attr('style', 'display: none;');
            $('.slider-button-next.slider-button-next-CreditorAccount_ID').attr('style', 'display: none;');
        } else {
            $('.slider-button-prev.slider-button-prev-CreditorAccount_ID').attr('style', '');
            $('.slider-button-next.slider-button-next-CreditorAccount_ID').attr('style', '');
            var focus = 1;
            var debtorSlider = $("#DebtorAccount_ID_slider").find(".slick-track");
            var selectedDebtorAccountNumber = debtorSlider.find(".slick-current").data("accountnumber");
            for (var i = 1; i <= currentSlides.length; i++) {
                var j = i - 1;
                var accountNumber = currentSlides[j].data("accountnumber");
                if (accountNumber == selectedDebtorAccountNumber) {
                    focus = j;
                }
            }
            //if (currentSlides.length == 1 || currentSlides.length == 2) {
            //    focus = 0;
            //}
            /*** Set previous credited account. ***/
            if (prevCreditedAccount)
                focus = currentSlides.indexOf(prevCreditedAccount);
            var selectedAccount = $(currentSlides[focus]).data("accountnumber");
            $mainSlider.slick(getSlickSettings(focus));
            DeWeb.LoadUtilities($mainSlider.parent());
            /*** If no previous valid credited account, set new value ***/
            if (!prevCreditedAccount)
                $("#CreditorAccount_ID").val(selectedAccount);
        }
    };
    //Filter Currencies
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;
        if (currencies == null) {
            var accid = $("#DebtorAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        currencies = currencies.filter(Boolean);
        currencies = jQuery.unique(currencies);
        if (currencies.length !== 0 && initialize) {
            filterSlides(currencies, true);
        }
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
    {
        Id: "CurrencyId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    break;
                case 'CurrencyChanged':
                    if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                        filterCurrencies(args.Currency, $this.attr("id"));
                    }
                    break;
            }


        }
    };

    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"));
        ebs.AddListener(currency);

    });
};

DeWeb.Utilities.displayDownloadLink = function ($this) {
    //kad se promeni da bude vidljiv download link na to ...... 

    $this.change(function () {
        checked = $(this).prop('checked');
        var id = $this.attr('id');

        if (checked) {
            $("#" + id + "Link").css('display', 'block');
        }
        else {
            $("#" + id + "Link").css('display', 'none');

        }

    });
};

DeWeb.Utilities.termDepositTransactions = function ($this) {
    var formId = $this.data('form-id');
    $(document).on('submit', '#form_' + formId, function () {
        DeWeb.Ui.HidePopup();
    });
};

DeWeb.Utilities.swipeTermDepositOrders = function ($this) {

    $this.click(function () {
        var dir = $this.data("direction");
        var ids = $("#termDepositOrdersIds").data("termdeporderlist");
        var current = $this.parent().data("current");
        currentId = ids.indexOf(current.toString());
        if (currentId + parseInt(dir) > ids.length || currentId + parseInt(dir) < 0) {
            return;
        }
        next = ids[currentId + parseInt(dir)];
        $("#" + next).trigger("click");

    });

}

DeWeb.Utilities.waitForResponse = function ($this) {
    DeWeb.Ui.BlockElement($this.attr("id"));
    interval = 20000;
    var updateUrl = $this.data("update");
    (function getOffer(firstTime) {
        setTimeout(function () {
            (function getOffer(firstTime) {
                setTimeout(function () {
                    $.ajax({
                        url: updateUrl,
                        success: function (offerObject) {
                            try {
                                DeWeb.Ui.BlockElement($this.attr("id"));

                                if (!offerObject.Direction.startsWith("negotiation")) {
                                    window.location.href = window.location.href + "?workItemId=" + $this.data("workitem-id");

                                }

                            } catch (e) {
                                console.log(e);
                            }


                        },
                        error: function (jqXHR, textStatus, errorThrown) {

                        },
                        dataType: "json",
                        complete: getOffer(false)
                    });
                }, interval);
            })(true);
        }, interval);
    })(true);

};

DeWeb.Utilities.negotiationEligibilityCheck = function ($this) {
    var updateUrl = $this.data('update-url');
    var redirectUrl = $this.data('redirect-url');
    var intervalJson = $this.data('interval');
    var urlParam = $this.data('url-param');
    var otherParams = $this.data('other-params');
    (function check(firstTime) {
        var interval = firstTime == true ? 0 : intervalJson;
        setTimeout(function () {
            $.ajax({
                url: updateUrl,
                success: function (result) {
                    try {
                        if (result.IsSuccesfull === true || result.IsSuccesfull == undefined) {
                            if (result !== undefined) {
                                if (result[1] == "offered") {
                                    window.location.replace(window.location.protocol + "//" + window.location.host + redirectUrl + "?" + urlParam + "=" + result[0] + otherParams);
                                }
                            }
                        }
                    } catch (e) {
                        console.log(e);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                },
                dataType: "json",
                complete: check(false)
            });
        }, interval);
    })(true);
};

DeWeb.Utilities.filterCurrenciesTermDeposit = function ($this) {
    creditorSlider = $("#DebtorAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
  
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;
        if (currencies == null) {
            var accid = $("#DebtorAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        currencies = currencies.filter(Boolean);
        $this.attr('value', currencies[0]);

        $('input#InstructedAmount_Code_ID').val(currencies[0]);

        
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
    {
        Id: "CurrencyId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    break;
                case 'CurrencyChanged':
                    if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                        filterCurrencies(args.Currency, $this.attr("id"));
                    }
                    break;
            }


        }
    }


    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"));
        ebs.AddListener(currency);

    });
};
DeWeb.Utilities.trackCurrencyField = function ($this) {
    creditorSlider = $("#CommisionAccount_ID_slider");
    var initialize;
    if (creditorSlider.length != 0) {
        initialize = creditorSlider.find(".slide");
    }
    //Slick settings for creditor account slider
    var getSlickSettings = function (slideInFocus) {
        return {
            centerMode: true,
            slidesToShow: 3,
            arrows: false,
            initialSlide: slideInFocus,
            infinite: false,
            centerPadding: '0px',
            responsive: [
                {
                    breakpoint: 980,
                    settings: {
                        slidesToShow: 1,
                        dots: true
                    }
                },
            ]
        };
    }
    //Filter Slides according to debtor account currency
    var filterSlides = function (currencies, indic) {
        var $mainSlider = $("#CommisionAccount_ID_slider");
        var currentSlides = [];
        var mockFirst = 0;
        var accid = $("#DebtorAccount_ID").val();
        $mainSlider.find(".slide").each(function () {
            $mainSlider.slick('slickRemove', mockFirst);
        });
        /*** Previous credited account (perhaps from step 2). ***/
        var prevCreditedAccount = null;
        initialize.each(function () {
            if (currencies.indexOf($(this).data("currency")) > -1) {
                /*** Need to ex-filter credited accounts that are equal to debited ***/
                if (true) {
                    $mainSlider.slick('slickAdd', $(this));
                    /*** Get jQuery instance in a variable so that we can later find it in the currentSlides array. ***/
                    var reference = $(this);
                    currentSlides.push(reference);
                    try {
                        if ($(this).data("accountnumber") === $("#DebtorAccount_ID").val() && ($(this).attr('id') == undefined || $(this).attr('id').indexOf('cloned') == -1)) {
                            prevCreditedAccount = reference;
                        }
                    } catch (e) {
                        console.log(e);
                    }
                }
            }
        });
        // add mockslides 
        if (currentSlides.length === 1 || currentSlides.length === 2 || currentSlides.length === 3) {
            for (var i = 1; i <= 3; i++) {

                var currentId = i - 1 + "_cloned";
                var toAdd = '<div class="slide" id="' + currentId + '"></div>';
                $(toAdd).css("visibility", "hidden");
                $mainSlider.slick('slickAdd', toAdd);
            }
        }
        var currencyText = $('div.slick-center').find('.ui-selectmenu-text').text();
        currencyText.substring(0, 3);
        $('input#Currency_ID').val(currencyText);
        $mainSlider.slick('unslick');
        /*** By ex-filtering we can have 0 credited accounts. ***/
        if (currentSlides.length === 0) {
            $("#CommisionAccount_ID").val('');
            $('.slider-button-prev.slider-button-prev-CommisionAccount_ID').attr('style', 'display: none;');
            $('.slider-button-next.slider-button-next-CommisionAccount_ID').attr('style', 'display: none;');
        } else {
            $('.slider-button-prev.slider-button-prev-CommisionAccount_ID').attr('style', '');
            $('.slider-button-next.slider-button-next-CommisionAccount_ID').attr('style', '');
            var focus = 1;
            if (currentSlides.length == 1 || currentSlides.length == 2) {
                focus = 0;
            }
            /*** Set previous credited account. ***/
            if (prevCreditedAccount)
                focus = currentSlides.indexOf(prevCreditedAccount);
            var selectedAccount = $(currentSlides[focus]).data("accountnumber");
            $mainSlider.slick(getSlickSettings(focus));
            DeWeb.LoadUtilities($mainSlider.parent());
            /*** If no previous valid credited account, set new value ***/
            if (!prevCreditedAccount)
                $("#CommisionAccount_ID").val(selectedAccount);
        }
    };
    //Filter Currencies
    var filterCurrencies = function (currencies, id) {
        var firstTime = true;
        if (currencies == null) {
            var accid = $("#DebtorAccount_ID").val();
            currencies = [];
            $(".slide[data-accountnumber=" + accid + "]").children().find("[name=available-amount]").children().each(function () {
                currencies.push($(this).val());
            });
        }
        currencies = currencies.filter(Boolean);
        $this.attr('value', currencies[0]);
        if (currencies.length !== 0 && initialize) {
            filterSlides(currencies, true);
        }
        $("#" + id).children().find(".dd-option-value").each(function () {
            if (currencies.indexOf($(this).val()) > -1) {
                $(this).parent().css('display', 'block');
                if (firstTime) {
                    $("#" + id).children().find(".dd-selected-text").text($(this).val());
                    $(this).parent().addClass("dd-option-selected");
                    $("input[type=hidden][name=" + id + "]").val($(this).val());
                    firstTime = false;
                }
            } else {
                $(this).parent().css('display', 'none');
            }
        });
    };
    var currency =
    {
        Id: "CurrencyId",
        AcceptEvent: function (sender, args) {
            switch (args.CommandName) {
                case 'AccountChanged':
                    break;
                case 'CurrencyChanged':
                    if (args.AccField.replace("_slider", "") == "DebtorAccount_ID") {
                        filterCurrencies(args.Currency, $this.attr("id"));

                    }
                    break;
            }


        }
    }


    $(document).ready(function () {
        filterCurrencies(null, $this.attr("id"));
        ebs.AddListener(currency);

    });
};

DeWeb.Utilities.displayDownloadLink = function ($this) {
    //kad se promeni da bude vidljiv download link na to ...... 

    $this.change(function () {
        checked = $(this).prop('checked');
        var id = $this.attr('id');

        if (checked) {
            $("#" + id + "Link").css('display', 'block');
        }
        else {
            $("#" + id + "Link").css('display', 'none');

        }

    });
};

DeWeb.Utilities.waitForResponse = function ($this) {
    DeWeb.Ui.BlockElement($this.attr("id"));
    interval = 20000;
    var updateUrl = $this.data("update");
    (function getOffer(firstTime) {
        setTimeout(function () {
            (function getOffer(firstTime) {
                setTimeout(function () {
                    $.ajax({
                        url: updateUrl,
                        success: function (offerObject) {
                            try {
                                DeWeb.Ui.BlockElement($this.attr("id"));

                                if (!offerObject.Direction.startsWith("negotiation")) {
                                    window.location.href = window.location.href + "?workItemId=" + $this.data("workitem-id");

                                }

                            } catch (e) {
                                console.log(e);
                            }


                        },
                        error: function (jqXHR, textStatus, errorThrown) {

                        },
                        dataType: "json",
                        complete: getOffer(false)
                    });
                }, interval);
            })(true);
        }, interval);
    })(true);

};

DeWeb.Utilities.negotiationEligibilityCheck = function ($this) {
    var updateUrl = $this.data('update-url');
    var redirectUrl = $this.data('redirect-url');
    var intervalJson = $this.data('interval');
    var urlParam = $this.data('url-param');
    var otherParams = $this.data('other-params');
    (function check(firstTime) {
        var interval = firstTime == true ? 0 : intervalJson;
        setTimeout(function () {
            $.ajax({
                url: updateUrl,
                success: function (result) {
                    try {
                        if (result.IsSuccesfull === true || result.IsSuccesfull == undefined) {
                            if (result !== undefined) {
                                if (result[1] == "offered") {
                                    window.location.replace(window.location.protocol + "//" + window.location.host + redirectUrl + "?" + urlParam + "=" + result[0] + otherParams);
                                }
                            }
                        }
                    } catch (e) {
                        console.log(e);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                },
                dataType: "json",
                complete: check(false)
            });
        }, interval);
    })(true);
};
DeWeb.Utilities.accountTransactionsBrief = function ($this) {
    var formId = $this.data("form-id");
    var transactionsLink = $this.data("transactions-link");
    var accountsLink = $this.data("accounts-link");

    DeWeb.Pages.AccountsBrief.Init(accountsLink, transactionsLink, formId);

}

DeWeb.Pages.AccountsBrief = new function () {
    var _transactionsUrl = '';
    var _accountsUrl = '';
    
    var $form = null;

    var _accountContentId = 'account-content';
    var _transactionsContentId = 'transactions-content';

    var init = function (accountsUrl, transactionsUrl, formId) {
        _transactionsUrl = transactionsUrl;
        _accountsUrl = accountsUrl;

        $form = $('#' + formId);

        var AccountsBrief =
        {
            Id: "AccountsBrief",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        getBriefDetails();
                        break;
                }
            }
        };

        ebs.AddListener(AccountsBrief);

        var TransactionsBrief =
        {
            Id: "TransactionsBrief",
            AcceptEvent: function (sender, args) {
                switch (args.CommandName) {
                    case 'AccountChanged':
                        getBriefTransactons();
                        break;
                }
            }
        };

        ebs.AddListener(TransactionsBrief);

        getBriefDetails();
        getBriefTransactons();
    };
    var getBriefDetails = function () {

        var $replContent = $('#' + _accountContentId);
        DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
        $.ajax({
            url: _accountsUrl,
            type: "POST",
            data: $form.serialize(),
            success: function (markup) {
                
                $replContent.html(markup);
                DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
            }
        });
    };
    var getBriefTransactons = function () {

        var $replContent = $('#' + _transactionsContentId);
        DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
        $.ajax({
            url: _transactionsUrl,
            type: "POST",
            data: $form.serialize(),
            success: function (markup) {
                $replContent.html(markup);
                DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
            }
        });
    };
    return {
        Init: init
    };
};

function FilterAccountFields(kind)
{
    if (kind != "current-account") { $("[data-type=current-account-actions]").remove(); }
    else { $("[data-name=acc-number]").remove(); }
    if (kind == "term-deposit-account") { kind = "demand-deposit-account"; }
    $('div[data-type=account-brief-details]:not([name=' + kind + '])').each(function () {

        if ($(this).attr("name") != "all") $(this).remove();
    });
}

$(document).on("click", "a[data-id=perform-action]", function (e) {
    e.preventDefault();
    $('body').removeClass('popup-open');
    $('.modal-container').fadeOut(200);
    $('div#popup-content-side').fadeOut(200).removeClass('active');
});

DeWeb.Utilities.ChangeFilter = function ($this) {
    $this.click(function(e) {
        e.preventDefault();
        changeFilter($this.data('id'));
    });
}

DeWeb.Utilities.swipeTransaction = function ($this) {
    $this.click(function () {
        var dir = $this.data("direction");
        var ids = $("#transactionident").data("transactionlist");
        var current = $this.parent().data("current");
        currentId = ids.indexOf(current.toString());
        if (currentId + parseInt(dir) > ids.length || currentId + parseInt(dir) < 0) {
            return;
        }
        next = ids[currentId + parseInt(dir)];
        $("#" + next).trigger("click");

    });

}
DeWeb.Utilities.swipeStatements = function ($this) {
    $this.click(function () {
        var dir = $this.data("direction");
        var ids = $("#statementident").data("statementlist");
        var current = $this.parent().data("current");
        currentId = ids.indexOf(current.toString());
        if (currentId + parseInt(dir) > ids.length || currentId + parseInt(dir) < 0) {
            return;
        }
        next = ids[currentId + parseInt(dir)];
        $("#" + next).trigger("click");

    });

};
$(function ()
{

});

DeWeb.Utilities.accountTransactionsBrief = function ($this)
{
    var formId = $this.data("form-id");
    var transactionsLink = $this.data("transactions-link");
    var accountsLink = $this.data("accounts-link");
    var accnum = $this.data("accnum");
    DeWeb.Pages.AccountsBrief.Init(accountsLink, transactionsLink, formId, accnum);

};

DeWeb.Pages.AccountsBrief = new function ()
{
    var _transactionsUrl = '';
    var _accountsUrl = '';
    var $form = null;
    var _accountContentId = 'account-content';
    var _transactionsContentId = 'transactions-content';
    var init = function (accountsUrl, transactionsUrl, formId, accountnum)
    {
        _transactionsUrl = transactionsUrl;
        _accountsUrl = accountsUrl;
        $form = $('#' + formId);

        var AccountsBrief =
        {
            Id: "AccountsBrief",
            AcceptEvent: function (sender, args)
            {
                switch (args.CommandName)
                {
                    case 'AccountChanged':
                        getBriefDetails();
                        break;
                }
            }
        };
        ebs.AddListener(AccountsBrief);


        var TransactionsBrief =
        {
            Id: "TransactionsBrief",
            AcceptEvent: function (sender, args)
            {
                switch (args.CommandName)
                {
                    case 'AccountChanged':
                        getBriefTransactons();
                        break;
                }
            }
        };

        ebs.AddListener(TransactionsBrief);
        //getBriefDetails();
        if (accountnum == 1)
        {
            getBriefDetails();
            getBriefTransactons();
        }
    };
    var getBriefDetails = function ()
    {

        var $replContent = $('#' + _accountContentId);
        DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
        $.ajax({
            url: _accountsUrl,
            type: "POST",
            data: $form.serialize(),
            success: function (markup)
            {
                $replContent.html(markup);
                DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
            }
        });
    };
    var getBriefTransactons = function ()
    {
        //return;
        if (_transactionsUrl != null)
        {

            var $replContent = $('#' + _transactionsContentId);

            DeWeb.AjaxForms.OnAjaxBegin($replContent.attr("id"));
            $.ajax({
                url: _transactionsUrl,
                type: "POST",
                data: $form.serialize(),
                success: function (markup)
                {
                    $replContent.html(markup);
                    DeWeb.AjaxForms.OnAjaxSuccess($replContent.attr("id"));
                    DeWeb.AjaxForms.OnAjaxComplete($replContent.attr("id"));
                }
            });
        }
    };
    return {
        Init: init
    };
};
DeWeb.Utilities.balancePieChart = function ($this)
{
    $(document).ready(function () 
    {
        chart = null;
        function setChart(options)
        {
            chart.series[0].remove(false);
            chart.addSeries({
                type: options.type,
                name: options.name,
                data: options.data,
                color: options.color || 'white',
                innerSize: options.innerSize
            }, false);
            chart.xAxis[0].setCategories(options.categories, false);
            chart.redraw();
        }

        function formatDecimal(value)
        {
            var culture = $this.data("culture");
            return value.toLocaleString(culture,
                { 'minimumFractionDigits': 2, 'maximumFractionDigits': 2 });
        }

        data = [];
        categories = [];
        var colors = ['#A7DDFF', '#89BB40', '#F8A1C4', '#FD795B', '#6CC6C7'];
        for (var i = 0; i < $this.data('available').length; i++)
        {
            drilldowndata = $this.data("drildown-data")[i];
            categories.push($this.data('drildown-flags')[i]);
            data.push({
                y: $this.data('available')[i],
                name: $this.data('account-labels')[i],
                color: colors[i],
                drilldown: {
                    //name: 'MSIE versions',
                    categories: $this.data('drildown-flags')[i],
                    name: $this.data('account-labels')[i],
                    id: $this.data("drildown-data")[i] + '_drilldown',
                    data: drilldowndata,
                    color: colors[i]
                }
            });
        }
        var defaultTitle = $this.data('label') + ' <br> <b>' + $this.data('total') + " " + $this.data("currency") + '</b>';
        chart = new Highcharts.Chart({
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: 0,
                plotShadow: false,
                renderTo: $this.attr('id')
            },
            title: {
                text: defaultTitle,
                align: 'center',
                verticalAlign: 'middle',
                y: 0,
                x: -100,
                style: {
                    color: '#209cd8',
                    fontSize: "100%"
                }
            },
            xAxis: {
                categories: categories
            },
            yAxis: {
                title: {
                    text: ""
                }
            },
            legend: {
                align: 'right',
                verticalAlign: 'middle',
                floating: false,
                width: 175,
                layout: 'horizontal',
                itemStyle: '{ "word-wrap": "break-word"}'
            },
            plotOptions: {
                pie: {
                    dataLabels: {
                        enabled: false
                    },
                    size: '100%',
                    center: ['50%', '50%'],
                    showInLegend: true
                },
                series: {
                    cursor: 'pointer',
                    center: ['50%', '50%'],

                    point: {
                        events: {
                            click: function (e)
                            {
                                var drilldown = this.drilldown;
                                var options;
                                var sum = 0;
                                if (drilldown)
                                { // drill down
                                    options = {
                                        'name': drilldown.name,
                                        'categories': drilldown.categories,
                                        'data': drilldown.data,
                                        'color': drilldown.color,
                                        'type': 'column'
                                    };
                                    $.each(drilldown.data, function (i, val)
                                    {
                                        sum += val;
                                    });
                                    chart.setTitle({ text: drilldown.name + ' <br> <b>' + formatDecimal(sum) + " " + $this.data("currency") + '</b>' });
                                } else
                                { // restore
                                    options = {
                                        'name': name,
                                        'categories': categories,
                                        'data': data,
                                        'type': 'pie',
                                        'innerSize': '80%'
                                    };
                                    chart.setTitle({ text: defaultTitle });
                                }
                                setChart(options);
                            },
                            legendItemClick: function () {
                                return false;
                            }
                        }
                    }
                },
                column: {
                    events: {
                        legendItemClick: function () {
                            return false;
                        }
                    }
                },
                allowPointSelect: false
            },
            tooltip: {
                formatter: function ()
                {
                    if (this.key != "")
                    {
                        return '<div style="border-radius:5px;padding:10px;color:white;background-color:' + this.color + '" class="tooltip"> ' +
                            this.key + " : " + formatDecimal(this.y) + " " + $this.data('currency') + '</div>';
                    }
                    else
                    {
                        return '<div style="border-radius:5px;padding:10px;color:white;background-color:' + this.color + '" class="tooltip"> ' +
                            this.key + " " + formatDecimal(this.y) + " " + $this.data('currency') + '</div>';
                    }

                },
                useHTML: true,
                backgroundColor: null,
                borderWidth: 0,
                shadow: false,
            },
            series: [{
                innerSize: '80%',
                type: 'pie',
                name: name,
                data: data,
                color: 'black'
            }],
            exporting: {
                enabled: false
            }
        });
    });
};
function FilterAccountFields(kind)
{
    if (kind != "current-account") { $("[data-type=current-account-actions]").remove(); }
    else { $("[data-name=acc-number]").remove(); }
    if (kind == "term-deposit-account") { kind = "demand-deposit-account"; }
    $('div[data-type=account-brief-details]:not([name=' + kind + '])').each(function ()
    {

        if ($(this).attr("name") != "all") $(this).remove();
    });
}

$(document).on("click", "a[data-id=perform-action]", function (e)
{
    e.preventDefault();
    $('body').removeClass('popup-open');
    $('.modal-container').fadeOut(200);
    $('div#popup-content-side').fadeOut(200).removeClass('active');
});

DeWeb.Utilities.ChangeFilter = function ($this)
{
    $this.click(function (e)
    {
        e.preventDefault();
        changeFilter($this.data('id'));
    });
}
DeWeb.Utilities.openFilterTransactions = function ($this)
{
    $this.click(function (e)
    {
        e.preventDefault();
        $('body').addClass('-overlay-active');
        $(".side-modal").addClass("active");
        $('body').addClass('popup-open');
        var nodeSelector = $(this).attr('data-filter-node');
        $("form").show("slide", { direction: "right" });
        $("#popup-content-side").css("margin-left", "-530px");
        $(".side-modal").css('display', 'block');
        $(nodeSelector).css('display', 'block');
        $(nodeSelector).addClass('active');

    });
};
DeWeb.Utilities.closeFilterTransactions = function ($this)
{
    $this.click(function (e)
    {
        e.preventDefault();
        DeWeb.Utilities.closeModal($this);
        $('body').removeClass('-overlay-active');
        $('body').removeClass('popup-open');
        $(".side-modal").css('display', 'none');
        $("#popup-content-side").css("margin-left", "0px");
    });
}

function DateChange(fieldFrom, fieldTo, formId, viewType, month, year)
{

    var currentDate = new Date();
    var lastDay = 30;
    if (month === -1)
    {
        year = currentDate.getFullYear();
        month = currentDate.getMonth();
        lastDay = new Date(currentDate.getFullYear(), month + 1, 0).getDate();
    }
    else
    {
        lastDay = new Date(year, month, 0).getDate();
        month = month - 1;
    }
    $("#form_" + formId).find("[name=" + fieldFrom + "]").trigger("click", [new Date(year, month, 1)]);
    $("#form_" + formId).find("[name=" + fieldTo + "]").trigger("click", [new Date(year, month, lastDay)]);
    $("#ViewType_ID").val(viewType);
    $("#form_" + formId).submit();
}


DeWeb.Utilities.showView = function ($this)
{

    $this.click(function ()
    {
        var formId = $this.parent().parent().data('form-id');
        var fieldTo = $this.parent().parent().data('field-to');
        var fieldFrom = $this.parent().parent().data('field-from');
        var data = $this.data("view-type");
        if ($this.data("view-type") == "list-view")
        {
            $("#filter_" + formId).find("#ViewType_ID").val(data);
            $("#filter_" + formId).find("[name=PageSize]").val('10');
            $("#filter_" + formId).submit();

            $("input#ViewType_ID").val("list-view");
            $("#form_Transfers_GetList_FormId").submit();


        }
        else
        {
            DateChange(fieldFrom, fieldTo, formId, data, -1, -1);

        }


    });
}

DeWeb.Utilities.showViewDrafts = function ($this)
{

    $this.click(function ()
    {
        formId = $this.parent().parent().data('form-id');
        data = $this.data("view-type");
        $("#ViewType_ID").val(data);
        $("#form_" + formId).submit();
    });
}
DeWeb.Utilities.filterCurrencies = function ($this)
{
    $this.change(function ()
    {
        $("[name=" + $this.data('field-id') + "]").val($(this).val());
        $("#form_" + $this.data('form-id')).submit();

    });

};
DeWeb.Utilities.monthSelect = function ($this)
{
    $this.change(function ()
    {
        var monthY = $(this).val().split(',');
        var currentDate = new Date();
        month = 1;
        year = currentDate.getFullYear();
        if (monthY.length == 2)
        {
            month = monthY[0];
            year = monthY[1];
        }
        else
        {
            month = monthY[0];
        }
        var fieldTo = $this.data("field-to");
        var fieldFrom = $this.data("field-from");
        var formId = $this.data("form-id");
        var data = $this.data('view-type');
        DateChange(fieldFrom, fieldTo, formId, data, month, year);

    });
};

DeWeb.Utilities.addIdent = function ($this)
{
    id = $this.attr("id").replace("infobox-", "");
    newHref = $("button.details-transfer").data("href") + "?transactionId=" + id;
    $("button.details-transfer").data("href", newHref);
};
DeWeb.Utilities.addIdentTransfer = function ($this)
{
    id = $this.attr("id").replace("infobox-", "");
    newHref = $("button.details-transfer").data("href") + "?TransferId=" + id;
    $("button.details-transfer").data("href", newHref);
};

DeWeb.Utilities.atmBranchTransactions = function ($this)
{

    var bPath = $this.data('base-path');
    var ids = $this.data("ids");
    var facilitiesJson = $this.data('facilities-json');
    var realfacilities = [];
    var br = 0;
    for (var i = 0; i < facilitiesJson.length; i++)
    {
        if (facilitiesJson[i] == null)
        {
            continue;
        }
        var item = facilitiesJson[i];
        var t = {
            'id': ids[i],
            'coordinates': {
                'lat': "",
                'long': ""
            },
            'name': item['mapped-address'],
            'address': "",
            'kind': "Transfer"

        };

        t['coordinates']['lat'] = item['lat'];
        t['coordinates']['long'] = item['long'];
        realfacilities[br] = t;
        br = br + 1;
    }
    if (realfacilities != [])
    {
        DeWeb.Functionalities.AtmBranchMap.Init("", bPath, "preloginatmbranch", realfacilities);

    }

};

/*** Added this utility for last transaction date on dashboard. ***/
DeWeb.Utilities.lastTransactionDate = function ($this)
{

    $.ajax({
        url: $this.data("link"),
        success: function (jsonTransaction)
        {
            try
            {
                if (!jsonTransaction || !Array.isArray(jsonTransaction) || jsonTransaction.length === 0)
                {
                    $this.text(oldText);
                    return;
                }
                // Parse JSON date from MS format.
                jsonTransaction.forEach(function (e)
                {
                    e.BookDate = new Date(parseInt(e.BookDate.substr(6)));
                });
                // Sort descending by date.
                jsonTransaction = jsonTransaction.sort(function (a, b)
                {
                    return b.BookDate - a.BookDate;
                });
                // Get culture from data attr or from browser.
                var cultureLocale = $this.data('culture') ? $this.data('culture') : navigator.language;
                var transaction = jsonTransaction[0];
                if (typeof transaction !== 'undefined')
                {
                    var oldText = $this.data("label");
                    // Set localized date text.
                    $this.text(oldText + " | " + transaction.BookDate.toLocaleDateString([cultureLocale]));
                }

            } catch (e)
            {
                console.log(e);
            }

        }
    });


};